namespace Tao.OpenGl
{
    using System;
    using System.Runtime.InteropServices;

    public static partial class Gl
    {

        [System.CLSCompliant(false)]
        public static 
        void glNewList(UInt32 list, int mode)
        {
            Delegates.glNewList((UInt32)list, (int)mode);
        }

        public static 
        void glNewList(Int32 list, int mode)
        {
            Delegates.glNewList((UInt32)list, (int)mode);
        }

        public static 
        void glEndList()
        {
            Delegates.glEndList();
        }

        [System.CLSCompliant(false)]
        public static 
        void glCallList(UInt32 list)
        {
            Delegates.glCallList((UInt32)list);
        }

        public static 
        void glCallList(Int32 list)
        {
            Delegates.glCallList((UInt32)list);
        }

        public static 
        void glCallLists(Int32 n, int type, IntPtr lists)
        {
            unsafe
            {
                Delegates.glCallLists((Int32)n, (int)type, (IntPtr)lists);
            }
        }

        public static 
        void glCallLists(Int32 n, int type, [In, Out] object lists)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle lists_ptr = System.Runtime.InteropServices.GCHandle.Alloc(lists, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glCallLists((Int32)n, (int)type, (IntPtr)lists_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    lists_ptr.Free();
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glDeleteLists(UInt32 list, Int32 range)
        {
            Delegates.glDeleteLists((UInt32)list, (Int32)range);
        }

        public static 
        void glDeleteLists(Int32 list, Int32 range)
        {
            Delegates.glDeleteLists((UInt32)list, (Int32)range);
        }

        public static 
        Int32 glGenLists(Int32 range)
        {
            return Delegates.glGenLists((Int32)range);
        }

        [System.CLSCompliant(false)]
        public static 
        void glListBase(UInt32 @base)
        {
            Delegates.glListBase((UInt32)@base);
        }

        public static 
        void glListBase(Int32 @base)
        {
            Delegates.glListBase((UInt32)@base);
        }

        public static 
        void glBegin(int mode)
        {
            Delegates.glBegin((int)mode);
        }

        public static 
        void glBitmap(Int32 width, Int32 height, Single xorig, Single yorig, Single xmove, Single ymove, Byte[] bitmap)
        {
            unsafe
            {
                fixed (Byte* bitmap_ptr = bitmap)
                {
                    Delegates.glBitmap((Int32)width, (Int32)height, (Single)xorig, (Single)yorig, (Single)xmove, (Single)ymove, (Byte*)bitmap_ptr);
                }
            }
        }

        public static 
        void glBitmap(Int32 width, Int32 height, Single xorig, Single yorig, Single xmove, Single ymove, ref Byte bitmap)
        {
            unsafe
            {
                fixed (Byte* bitmap_ptr = &bitmap)
                {
                    Delegates.glBitmap((Int32)width, (Int32)height, (Single)xorig, (Single)yorig, (Single)xmove, (Single)ymove, (Byte*)bitmap_ptr);
                }
            }
        }

        public static 
        void glBitmap(Int32 width, Int32 height, Single xorig, Single yorig, Single xmove, Single ymove, IntPtr bitmap)
        {
            unsafe
            {
                Delegates.glBitmap((Int32)width, (Int32)height, (Single)xorig, (Single)yorig, (Single)xmove, (Single)ymove, (Byte*)bitmap);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glColor3b(SByte red, SByte green, SByte blue)
        {
            Delegates.glColor3b((SByte)red, (SByte)green, (SByte)blue);
        }

        public static 
        void glColor3b(Byte red, Byte green, Byte blue)
        {
            Delegates.glColor3b((SByte)red, (SByte)green, (SByte)blue);
        }

        [System.CLSCompliant(false)]
        public static 
        void glColor3bv(SByte[] v)
        {
            unsafe
            {
                fixed (SByte* v_ptr = v)
                {
                    Delegates.glColor3bv((SByte*)v_ptr);
                }
            }
        }

        public static 
        void glColor3bv(Byte[] v)
        {
            unsafe
            {
                fixed (Byte* v_ptr = v)
                {
                    Delegates.glColor3bv((SByte*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glColor3bv(ref SByte v)
        {
            unsafe
            {
                fixed (SByte* v_ptr = &v)
                {
                    Delegates.glColor3bv((SByte*)v_ptr);
                }
            }
        }

        public static 
        void glColor3bv(ref Byte v)
        {
            unsafe
            {
                fixed (Byte* v_ptr = &v)
                {
                    Delegates.glColor3bv((SByte*)v_ptr);
                }
            }
        }

        public static 
        void glColor3bv(IntPtr v)
        {
            unsafe
            {
                Delegates.glColor3bv((SByte*)v);
            }
        }

        public static 
        void glColor3d(Double red, Double green, Double blue)
        {
            Delegates.glColor3d((Double)red, (Double)green, (Double)blue);
        }

        public static 
        void glColor3dv(Double[] v)
        {
            unsafe
            {
                fixed (Double* v_ptr = v)
                {
                    Delegates.glColor3dv((Double*)v_ptr);
                }
            }
        }

        public static 
        void glColor3dv(ref Double v)
        {
            unsafe
            {
                fixed (Double* v_ptr = &v)
                {
                    Delegates.glColor3dv((Double*)v_ptr);
                }
            }
        }

        public static 
        void glColor3dv(IntPtr v)
        {
            unsafe
            {
                Delegates.glColor3dv((Double*)v);
            }
        }

        public static 
        void glColor3f(Single red, Single green, Single blue)
        {
            Delegates.glColor3f((Single)red, (Single)green, (Single)blue);
        }

        public static 
        void glColor3fv(Single[] v)
        {
            unsafe
            {
                fixed (Single* v_ptr = v)
                {
                    Delegates.glColor3fv((Single*)v_ptr);
                }
            }
        }

        public static 
        void glColor3fv(ref Single v)
        {
            unsafe
            {
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glColor3fv((Single*)v_ptr);
                }
            }
        }

        public static 
        void glColor3fv(IntPtr v)
        {
            unsafe
            {
                Delegates.glColor3fv((Single*)v);
            }
        }

        public static 
        void glColor3i(Int32 red, Int32 green, Int32 blue)
        {
            Delegates.glColor3i((Int32)red, (Int32)green, (Int32)blue);
        }

        public static 
        void glColor3iv(Int32[] v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = v)
                {
                    Delegates.glColor3iv((Int32*)v_ptr);
                }
            }
        }

        public static 
        void glColor3iv(ref Int32 v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = &v)
                {
                    Delegates.glColor3iv((Int32*)v_ptr);
                }
            }
        }

        public static 
        void glColor3iv(IntPtr v)
        {
            unsafe
            {
                Delegates.glColor3iv((Int32*)v);
            }
        }

        public static 
        void glColor3s(Int16 red, Int16 green, Int16 blue)
        {
            Delegates.glColor3s((Int16)red, (Int16)green, (Int16)blue);
        }

        public static 
        void glColor3sv(Int16[] v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = v)
                {
                    Delegates.glColor3sv((Int16*)v_ptr);
                }
            }
        }

        public static 
        void glColor3sv(ref Int16 v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = &v)
                {
                    Delegates.glColor3sv((Int16*)v_ptr);
                }
            }
        }

        public static 
        void glColor3sv(IntPtr v)
        {
            unsafe
            {
                Delegates.glColor3sv((Int16*)v);
            }
        }

        public static 
        void glColor3ub(Byte red, Byte green, Byte blue)
        {
            Delegates.glColor3ub((Byte)red, (Byte)green, (Byte)blue);
        }

        public static 
        void glColor3ubv(Byte[] v)
        {
            unsafe
            {
                fixed (Byte* v_ptr = v)
                {
                    Delegates.glColor3ubv((Byte*)v_ptr);
                }
            }
        }

        public static 
        void glColor3ubv(ref Byte v)
        {
            unsafe
            {
                fixed (Byte* v_ptr = &v)
                {
                    Delegates.glColor3ubv((Byte*)v_ptr);
                }
            }
        }

        public static 
        void glColor3ubv(IntPtr v)
        {
            unsafe
            {
                Delegates.glColor3ubv((Byte*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glColor3ui(UInt32 red, UInt32 green, UInt32 blue)
        {
            Delegates.glColor3ui((UInt32)red, (UInt32)green, (UInt32)blue);
        }

        public static 
        void glColor3ui(Int32 red, Int32 green, Int32 blue)
        {
            Delegates.glColor3ui((UInt32)red, (UInt32)green, (UInt32)blue);
        }

        [System.CLSCompliant(false)]
        public static 
        void glColor3uiv(UInt32[] v)
        {
            unsafe
            {
                fixed (UInt32* v_ptr = v)
                {
                    Delegates.glColor3uiv((UInt32*)v_ptr);
                }
            }
        }

        public static 
        void glColor3uiv(Int32[] v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = v)
                {
                    Delegates.glColor3uiv((UInt32*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glColor3uiv(ref UInt32 v)
        {
            unsafe
            {
                fixed (UInt32* v_ptr = &v)
                {
                    Delegates.glColor3uiv((UInt32*)v_ptr);
                }
            }
        }

        public static 
        void glColor3uiv(ref Int32 v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = &v)
                {
                    Delegates.glColor3uiv((UInt32*)v_ptr);
                }
            }
        }

        public static 
        void glColor3uiv(IntPtr v)
        {
            unsafe
            {
                Delegates.glColor3uiv((UInt32*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glColor3us(UInt16 red, UInt16 green, UInt16 blue)
        {
            Delegates.glColor3us((UInt16)red, (UInt16)green, (UInt16)blue);
        }

        public static 
        void glColor3us(Int16 red, Int16 green, Int16 blue)
        {
            Delegates.glColor3us((UInt16)red, (UInt16)green, (UInt16)blue);
        }

        [System.CLSCompliant(false)]
        public static 
        void glColor3usv(UInt16[] v)
        {
            unsafe
            {
                fixed (UInt16* v_ptr = v)
                {
                    Delegates.glColor3usv((UInt16*)v_ptr);
                }
            }
        }

        public static 
        void glColor3usv(Int16[] v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = v)
                {
                    Delegates.glColor3usv((UInt16*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glColor3usv(ref UInt16 v)
        {
            unsafe
            {
                fixed (UInt16* v_ptr = &v)
                {
                    Delegates.glColor3usv((UInt16*)v_ptr);
                }
            }
        }

        public static 
        void glColor3usv(ref Int16 v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = &v)
                {
                    Delegates.glColor3usv((UInt16*)v_ptr);
                }
            }
        }

        public static 
        void glColor3usv(IntPtr v)
        {
            unsafe
            {
                Delegates.glColor3usv((UInt16*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glColor4b(SByte red, SByte green, SByte blue, SByte alpha)
        {
            Delegates.glColor4b((SByte)red, (SByte)green, (SByte)blue, (SByte)alpha);
        }

        public static 
        void glColor4b(Byte red, Byte green, Byte blue, Byte alpha)
        {
            Delegates.glColor4b((SByte)red, (SByte)green, (SByte)blue, (SByte)alpha);
        }

        [System.CLSCompliant(false)]
        public static 
        void glColor4bv(SByte[] v)
        {
            unsafe
            {
                fixed (SByte* v_ptr = v)
                {
                    Delegates.glColor4bv((SByte*)v_ptr);
                }
            }
        }

        public static 
        void glColor4bv(Byte[] v)
        {
            unsafe
            {
                fixed (Byte* v_ptr = v)
                {
                    Delegates.glColor4bv((SByte*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glColor4bv(ref SByte v)
        {
            unsafe
            {
                fixed (SByte* v_ptr = &v)
                {
                    Delegates.glColor4bv((SByte*)v_ptr);
                }
            }
        }

        public static 
        void glColor4bv(ref Byte v)
        {
            unsafe
            {
                fixed (Byte* v_ptr = &v)
                {
                    Delegates.glColor4bv((SByte*)v_ptr);
                }
            }
        }

        public static 
        void glColor4bv(IntPtr v)
        {
            unsafe
            {
                Delegates.glColor4bv((SByte*)v);
            }
        }

        public static 
        void glColor4d(Double red, Double green, Double blue, Double alpha)
        {
            Delegates.glColor4d((Double)red, (Double)green, (Double)blue, (Double)alpha);
        }

        public static 
        void glColor4dv(Double[] v)
        {
            unsafe
            {
                fixed (Double* v_ptr = v)
                {
                    Delegates.glColor4dv((Double*)v_ptr);
                }
            }
        }

        public static 
        void glColor4dv(ref Double v)
        {
            unsafe
            {
                fixed (Double* v_ptr = &v)
                {
                    Delegates.glColor4dv((Double*)v_ptr);
                }
            }
        }

        public static 
        void glColor4dv(IntPtr v)
        {
            unsafe
            {
                Delegates.glColor4dv((Double*)v);
            }
        }

        public static 
        void glColor4f(Single red, Single green, Single blue, Single alpha)
        {
            Delegates.glColor4f((Single)red, (Single)green, (Single)blue, (Single)alpha);
        }

        public static 
        void glColor4fv(Single[] v)
        {
            unsafe
            {
                fixed (Single* v_ptr = v)
                {
                    Delegates.glColor4fv((Single*)v_ptr);
                }
            }
        }

        public static 
        void glColor4fv(ref Single v)
        {
            unsafe
            {
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glColor4fv((Single*)v_ptr);
                }
            }
        }

        public static 
        void glColor4fv(IntPtr v)
        {
            unsafe
            {
                Delegates.glColor4fv((Single*)v);
            }
        }

        public static 
        void glColor4i(Int32 red, Int32 green, Int32 blue, Int32 alpha)
        {
            Delegates.glColor4i((Int32)red, (Int32)green, (Int32)blue, (Int32)alpha);
        }

        public static 
        void glColor4iv(Int32[] v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = v)
                {
                    Delegates.glColor4iv((Int32*)v_ptr);
                }
            }
        }

        public static 
        void glColor4iv(ref Int32 v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = &v)
                {
                    Delegates.glColor4iv((Int32*)v_ptr);
                }
            }
        }

        public static 
        void glColor4iv(IntPtr v)
        {
            unsafe
            {
                Delegates.glColor4iv((Int32*)v);
            }
        }

        public static 
        void glColor4s(Int16 red, Int16 green, Int16 blue, Int16 alpha)
        {
            Delegates.glColor4s((Int16)red, (Int16)green, (Int16)blue, (Int16)alpha);
        }

        public static 
        void glColor4sv(Int16[] v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = v)
                {
                    Delegates.glColor4sv((Int16*)v_ptr);
                }
            }
        }

        public static 
        void glColor4sv(ref Int16 v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = &v)
                {
                    Delegates.glColor4sv((Int16*)v_ptr);
                }
            }
        }

        public static 
        void glColor4sv(IntPtr v)
        {
            unsafe
            {
                Delegates.glColor4sv((Int16*)v);
            }
        }

        public static 
        void glColor4ub(Byte red, Byte green, Byte blue, Byte alpha)
        {
            Delegates.glColor4ub((Byte)red, (Byte)green, (Byte)blue, (Byte)alpha);
        }

        public static 
        void glColor4ubv(Byte[] v)
        {
            unsafe
            {
                fixed (Byte* v_ptr = v)
                {
                    Delegates.glColor4ubv((Byte*)v_ptr);
                }
            }
        }

        public static 
        void glColor4ubv(ref Byte v)
        {
            unsafe
            {
                fixed (Byte* v_ptr = &v)
                {
                    Delegates.glColor4ubv((Byte*)v_ptr);
                }
            }
        }

        public static 
        void glColor4ubv(IntPtr v)
        {
            unsafe
            {
                Delegates.glColor4ubv((Byte*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glColor4ui(UInt32 red, UInt32 green, UInt32 blue, UInt32 alpha)
        {
            Delegates.glColor4ui((UInt32)red, (UInt32)green, (UInt32)blue, (UInt32)alpha);
        }

        public static 
        void glColor4ui(Int32 red, Int32 green, Int32 blue, Int32 alpha)
        {
            Delegates.glColor4ui((UInt32)red, (UInt32)green, (UInt32)blue, (UInt32)alpha);
        }

        [System.CLSCompliant(false)]
        public static 
        void glColor4uiv(UInt32[] v)
        {
            unsafe
            {
                fixed (UInt32* v_ptr = v)
                {
                    Delegates.glColor4uiv((UInt32*)v_ptr);
                }
            }
        }

        public static 
        void glColor4uiv(Int32[] v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = v)
                {
                    Delegates.glColor4uiv((UInt32*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glColor4uiv(ref UInt32 v)
        {
            unsafe
            {
                fixed (UInt32* v_ptr = &v)
                {
                    Delegates.glColor4uiv((UInt32*)v_ptr);
                }
            }
        }

        public static 
        void glColor4uiv(ref Int32 v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = &v)
                {
                    Delegates.glColor4uiv((UInt32*)v_ptr);
                }
            }
        }

        public static 
        void glColor4uiv(IntPtr v)
        {
            unsafe
            {
                Delegates.glColor4uiv((UInt32*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glColor4us(UInt16 red, UInt16 green, UInt16 blue, UInt16 alpha)
        {
            Delegates.glColor4us((UInt16)red, (UInt16)green, (UInt16)blue, (UInt16)alpha);
        }

        public static 
        void glColor4us(Int16 red, Int16 green, Int16 blue, Int16 alpha)
        {
            Delegates.glColor4us((UInt16)red, (UInt16)green, (UInt16)blue, (UInt16)alpha);
        }

        [System.CLSCompliant(false)]
        public static 
        void glColor4usv(UInt16[] v)
        {
            unsafe
            {
                fixed (UInt16* v_ptr = v)
                {
                    Delegates.glColor4usv((UInt16*)v_ptr);
                }
            }
        }

        public static 
        void glColor4usv(Int16[] v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = v)
                {
                    Delegates.glColor4usv((UInt16*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glColor4usv(ref UInt16 v)
        {
            unsafe
            {
                fixed (UInt16* v_ptr = &v)
                {
                    Delegates.glColor4usv((UInt16*)v_ptr);
                }
            }
        }

        public static 
        void glColor4usv(ref Int16 v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = &v)
                {
                    Delegates.glColor4usv((UInt16*)v_ptr);
                }
            }
        }

        public static 
        void glColor4usv(IntPtr v)
        {
            unsafe
            {
                Delegates.glColor4usv((UInt16*)v);
            }
        }

        public static 
        void glEdgeFlag(bool flag)
        {
            Delegates.glEdgeFlag((bool)flag);
        }

        public static 
        void glEdgeFlagv(bool[] flag)
        {
            unsafe
            {
                fixed (bool* flag_ptr = flag)
                {
                    Delegates.glEdgeFlagv((bool*)flag_ptr);
                }
            }
        }

        public static 
        void glEdgeFlagv(ref bool flag)
        {
            unsafe
            {
                fixed (bool* flag_ptr = &flag)
                {
                    Delegates.glEdgeFlagv((bool*)flag_ptr);
                }
            }
        }

        public static 
        void glEdgeFlagv(IntPtr flag)
        {
            unsafe
            {
                Delegates.glEdgeFlagv((bool*)flag);
            }
        }

        public static 
        void glEnd()
        {
            Delegates.glEnd();
        }

        public static 
        void glIndexd(Double c)
        {
            Delegates.glIndexd((Double)c);
        }

        public static 
        void glIndexdv(Double[] c)
        {
            unsafe
            {
                fixed (Double* c_ptr = c)
                {
                    Delegates.glIndexdv((Double*)c_ptr);
                }
            }
        }

        public static 
        void glIndexdv(ref Double c)
        {
            unsafe
            {
                fixed (Double* c_ptr = &c)
                {
                    Delegates.glIndexdv((Double*)c_ptr);
                }
            }
        }

        public static 
        void glIndexdv(IntPtr c)
        {
            unsafe
            {
                Delegates.glIndexdv((Double*)c);
            }
        }

        public static 
        void glIndexf(Single c)
        {
            Delegates.glIndexf((Single)c);
        }

        public static 
        void glIndexfv(Single[] c)
        {
            unsafe
            {
                fixed (Single* c_ptr = c)
                {
                    Delegates.glIndexfv((Single*)c_ptr);
                }
            }
        }

        public static 
        void glIndexfv(ref Single c)
        {
            unsafe
            {
                fixed (Single* c_ptr = &c)
                {
                    Delegates.glIndexfv((Single*)c_ptr);
                }
            }
        }

        public static 
        void glIndexfv(IntPtr c)
        {
            unsafe
            {
                Delegates.glIndexfv((Single*)c);
            }
        }

        public static 
        void glIndexi(Int32 c)
        {
            Delegates.glIndexi((Int32)c);
        }

        public static 
        void glIndexiv(Int32[] c)
        {
            unsafe
            {
                fixed (Int32* c_ptr = c)
                {
                    Delegates.glIndexiv((Int32*)c_ptr);
                }
            }
        }

        public static 
        void glIndexiv(ref Int32 c)
        {
            unsafe
            {
                fixed (Int32* c_ptr = &c)
                {
                    Delegates.glIndexiv((Int32*)c_ptr);
                }
            }
        }

        public static 
        void glIndexiv(IntPtr c)
        {
            unsafe
            {
                Delegates.glIndexiv((Int32*)c);
            }
        }

        public static 
        void glIndexs(Int16 c)
        {
            Delegates.glIndexs((Int16)c);
        }

        public static 
        void glIndexsv(Int16[] c)
        {
            unsafe
            {
                fixed (Int16* c_ptr = c)
                {
                    Delegates.glIndexsv((Int16*)c_ptr);
                }
            }
        }

        public static 
        void glIndexsv(ref Int16 c)
        {
            unsafe
            {
                fixed (Int16* c_ptr = &c)
                {
                    Delegates.glIndexsv((Int16*)c_ptr);
                }
            }
        }

        public static 
        void glIndexsv(IntPtr c)
        {
            unsafe
            {
                Delegates.glIndexsv((Int16*)c);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glNormal3b(SByte nx, SByte ny, SByte nz)
        {
            Delegates.glNormal3b((SByte)nx, (SByte)ny, (SByte)nz);
        }

        public static 
        void glNormal3b(Byte nx, Byte ny, Byte nz)
        {
            Delegates.glNormal3b((SByte)nx, (SByte)ny, (SByte)nz);
        }

        [System.CLSCompliant(false)]
        public static 
        void glNormal3bv(SByte[] v)
        {
            unsafe
            {
                fixed (SByte* v_ptr = v)
                {
                    Delegates.glNormal3bv((SByte*)v_ptr);
                }
            }
        }

        public static 
        void glNormal3bv(Byte[] v)
        {
            unsafe
            {
                fixed (Byte* v_ptr = v)
                {
                    Delegates.glNormal3bv((SByte*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glNormal3bv(ref SByte v)
        {
            unsafe
            {
                fixed (SByte* v_ptr = &v)
                {
                    Delegates.glNormal3bv((SByte*)v_ptr);
                }
            }
        }

        public static 
        void glNormal3bv(ref Byte v)
        {
            unsafe
            {
                fixed (Byte* v_ptr = &v)
                {
                    Delegates.glNormal3bv((SByte*)v_ptr);
                }
            }
        }

        public static 
        void glNormal3bv(IntPtr v)
        {
            unsafe
            {
                Delegates.glNormal3bv((SByte*)v);
            }
        }

        public static 
        void glNormal3d(Double nx, Double ny, Double nz)
        {
            Delegates.glNormal3d((Double)nx, (Double)ny, (Double)nz);
        }

        public static 
        void glNormal3dv(Double[] v)
        {
            unsafe
            {
                fixed (Double* v_ptr = v)
                {
                    Delegates.glNormal3dv((Double*)v_ptr);
                }
            }
        }

        public static 
        void glNormal3dv(ref Double v)
        {
            unsafe
            {
                fixed (Double* v_ptr = &v)
                {
                    Delegates.glNormal3dv((Double*)v_ptr);
                }
            }
        }

        public static 
        void glNormal3dv(IntPtr v)
        {
            unsafe
            {
                Delegates.glNormal3dv((Double*)v);
            }
        }

        public static 
        void glNormal3f(Single nx, Single ny, Single nz)
        {
            Delegates.glNormal3f((Single)nx, (Single)ny, (Single)nz);
        }

        public static 
        void glNormal3fv(Single[] v)
        {
            unsafe
            {
                fixed (Single* v_ptr = v)
                {
                    Delegates.glNormal3fv((Single*)v_ptr);
                }
            }
        }

        public static 
        void glNormal3fv(ref Single v)
        {
            unsafe
            {
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glNormal3fv((Single*)v_ptr);
                }
            }
        }

        public static 
        void glNormal3fv(IntPtr v)
        {
            unsafe
            {
                Delegates.glNormal3fv((Single*)v);
            }
        }

        public static 
        void glNormal3i(Int32 nx, Int32 ny, Int32 nz)
        {
            Delegates.glNormal3i((Int32)nx, (Int32)ny, (Int32)nz);
        }

        public static 
        void glNormal3iv(Int32[] v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = v)
                {
                    Delegates.glNormal3iv((Int32*)v_ptr);
                }
            }
        }

        public static 
        void glNormal3iv(ref Int32 v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = &v)
                {
                    Delegates.glNormal3iv((Int32*)v_ptr);
                }
            }
        }

        public static 
        void glNormal3iv(IntPtr v)
        {
            unsafe
            {
                Delegates.glNormal3iv((Int32*)v);
            }
        }

        public static 
        void glNormal3s(Int16 nx, Int16 ny, Int16 nz)
        {
            Delegates.glNormal3s((Int16)nx, (Int16)ny, (Int16)nz);
        }

        public static 
        void glNormal3sv(Int16[] v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = v)
                {
                    Delegates.glNormal3sv((Int16*)v_ptr);
                }
            }
        }

        public static 
        void glNormal3sv(ref Int16 v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = &v)
                {
                    Delegates.glNormal3sv((Int16*)v_ptr);
                }
            }
        }

        public static 
        void glNormal3sv(IntPtr v)
        {
            unsafe
            {
                Delegates.glNormal3sv((Int16*)v);
            }
        }

        public static 
        void glRasterPos2d(Double x, Double y)
        {
            Delegates.glRasterPos2d((Double)x, (Double)y);
        }

        public static 
        void glRasterPos2dv(Double[] v)
        {
            unsafe
            {
                fixed (Double* v_ptr = v)
                {
                    Delegates.glRasterPos2dv((Double*)v_ptr);
                }
            }
        }

        public static 
        void glRasterPos2dv(ref Double v)
        {
            unsafe
            {
                fixed (Double* v_ptr = &v)
                {
                    Delegates.glRasterPos2dv((Double*)v_ptr);
                }
            }
        }

        public static 
        void glRasterPos2dv(IntPtr v)
        {
            unsafe
            {
                Delegates.glRasterPos2dv((Double*)v);
            }
        }

        public static 
        void glRasterPos2f(Single x, Single y)
        {
            Delegates.glRasterPos2f((Single)x, (Single)y);
        }

        public static 
        void glRasterPos2fv(Single[] v)
        {
            unsafe
            {
                fixed (Single* v_ptr = v)
                {
                    Delegates.glRasterPos2fv((Single*)v_ptr);
                }
            }
        }

        public static 
        void glRasterPos2fv(ref Single v)
        {
            unsafe
            {
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glRasterPos2fv((Single*)v_ptr);
                }
            }
        }

        public static 
        void glRasterPos2fv(IntPtr v)
        {
            unsafe
            {
                Delegates.glRasterPos2fv((Single*)v);
            }
        }

        public static 
        void glRasterPos2i(Int32 x, Int32 y)
        {
            Delegates.glRasterPos2i((Int32)x, (Int32)y);
        }

        public static 
        void glRasterPos2iv(Int32[] v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = v)
                {
                    Delegates.glRasterPos2iv((Int32*)v_ptr);
                }
            }
        }

        public static 
        void glRasterPos2iv(ref Int32 v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = &v)
                {
                    Delegates.glRasterPos2iv((Int32*)v_ptr);
                }
            }
        }

        public static 
        void glRasterPos2iv(IntPtr v)
        {
            unsafe
            {
                Delegates.glRasterPos2iv((Int32*)v);
            }
        }

        public static 
        void glRasterPos2s(Int16 x, Int16 y)
        {
            Delegates.glRasterPos2s((Int16)x, (Int16)y);
        }

        public static 
        void glRasterPos2sv(Int16[] v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = v)
                {
                    Delegates.glRasterPos2sv((Int16*)v_ptr);
                }
            }
        }

        public static 
        void glRasterPos2sv(ref Int16 v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = &v)
                {
                    Delegates.glRasterPos2sv((Int16*)v_ptr);
                }
            }
        }

        public static 
        void glRasterPos2sv(IntPtr v)
        {
            unsafe
            {
                Delegates.glRasterPos2sv((Int16*)v);
            }
        }

        public static 
        void glRasterPos3d(Double x, Double y, Double z)
        {
            Delegates.glRasterPos3d((Double)x, (Double)y, (Double)z);
        }

        public static 
        void glRasterPos3dv(Double[] v)
        {
            unsafe
            {
                fixed (Double* v_ptr = v)
                {
                    Delegates.glRasterPos3dv((Double*)v_ptr);
                }
            }
        }

        public static 
        void glRasterPos3dv(ref Double v)
        {
            unsafe
            {
                fixed (Double* v_ptr = &v)
                {
                    Delegates.glRasterPos3dv((Double*)v_ptr);
                }
            }
        }

        public static 
        void glRasterPos3dv(IntPtr v)
        {
            unsafe
            {
                Delegates.glRasterPos3dv((Double*)v);
            }
        }

        public static 
        void glRasterPos3f(Single x, Single y, Single z)
        {
            Delegates.glRasterPos3f((Single)x, (Single)y, (Single)z);
        }

        public static 
        void glRasterPos3fv(Single[] v)
        {
            unsafe
            {
                fixed (Single* v_ptr = v)
                {
                    Delegates.glRasterPos3fv((Single*)v_ptr);
                }
            }
        }

        public static 
        void glRasterPos3fv(ref Single v)
        {
            unsafe
            {
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glRasterPos3fv((Single*)v_ptr);
                }
            }
        }

        public static 
        void glRasterPos3fv(IntPtr v)
        {
            unsafe
            {
                Delegates.glRasterPos3fv((Single*)v);
            }
        }

        public static 
        void glRasterPos3i(Int32 x, Int32 y, Int32 z)
        {
            Delegates.glRasterPos3i((Int32)x, (Int32)y, (Int32)z);
        }

        public static 
        void glRasterPos3iv(Int32[] v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = v)
                {
                    Delegates.glRasterPos3iv((Int32*)v_ptr);
                }
            }
        }

        public static 
        void glRasterPos3iv(ref Int32 v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = &v)
                {
                    Delegates.glRasterPos3iv((Int32*)v_ptr);
                }
            }
        }

        public static 
        void glRasterPos3iv(IntPtr v)
        {
            unsafe
            {
                Delegates.glRasterPos3iv((Int32*)v);
            }
        }

        public static 
        void glRasterPos3s(Int16 x, Int16 y, Int16 z)
        {
            Delegates.glRasterPos3s((Int16)x, (Int16)y, (Int16)z);
        }

        public static 
        void glRasterPos3sv(Int16[] v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = v)
                {
                    Delegates.glRasterPos3sv((Int16*)v_ptr);
                }
            }
        }

        public static 
        void glRasterPos3sv(ref Int16 v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = &v)
                {
                    Delegates.glRasterPos3sv((Int16*)v_ptr);
                }
            }
        }

        public static 
        void glRasterPos3sv(IntPtr v)
        {
            unsafe
            {
                Delegates.glRasterPos3sv((Int16*)v);
            }
        }

        public static 
        void glRasterPos4d(Double x, Double y, Double z, Double w)
        {
            Delegates.glRasterPos4d((Double)x, (Double)y, (Double)z, (Double)w);
        }

        public static 
        void glRasterPos4dv(Double[] v)
        {
            unsafe
            {
                fixed (Double* v_ptr = v)
                {
                    Delegates.glRasterPos4dv((Double*)v_ptr);
                }
            }
        }

        public static 
        void glRasterPos4dv(ref Double v)
        {
            unsafe
            {
                fixed (Double* v_ptr = &v)
                {
                    Delegates.glRasterPos4dv((Double*)v_ptr);
                }
            }
        }

        public static 
        void glRasterPos4dv(IntPtr v)
        {
            unsafe
            {
                Delegates.glRasterPos4dv((Double*)v);
            }
        }

        public static 
        void glRasterPos4f(Single x, Single y, Single z, Single w)
        {
            Delegates.glRasterPos4f((Single)x, (Single)y, (Single)z, (Single)w);
        }

        public static 
        void glRasterPos4fv(Single[] v)
        {
            unsafe
            {
                fixed (Single* v_ptr = v)
                {
                    Delegates.glRasterPos4fv((Single*)v_ptr);
                }
            }
        }

        public static 
        void glRasterPos4fv(ref Single v)
        {
            unsafe
            {
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glRasterPos4fv((Single*)v_ptr);
                }
            }
        }

        public static 
        void glRasterPos4fv(IntPtr v)
        {
            unsafe
            {
                Delegates.glRasterPos4fv((Single*)v);
            }
        }

        public static 
        void glRasterPos4i(Int32 x, Int32 y, Int32 z, Int32 w)
        {
            Delegates.glRasterPos4i((Int32)x, (Int32)y, (Int32)z, (Int32)w);
        }

        public static 
        void glRasterPos4iv(Int32[] v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = v)
                {
                    Delegates.glRasterPos4iv((Int32*)v_ptr);
                }
            }
        }

        public static 
        void glRasterPos4iv(ref Int32 v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = &v)
                {
                    Delegates.glRasterPos4iv((Int32*)v_ptr);
                }
            }
        }

        public static 
        void glRasterPos4iv(IntPtr v)
        {
            unsafe
            {
                Delegates.glRasterPos4iv((Int32*)v);
            }
        }

        public static 
        void glRasterPos4s(Int16 x, Int16 y, Int16 z, Int16 w)
        {
            Delegates.glRasterPos4s((Int16)x, (Int16)y, (Int16)z, (Int16)w);
        }

        public static 
        void glRasterPos4sv(Int16[] v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = v)
                {
                    Delegates.glRasterPos4sv((Int16*)v_ptr);
                }
            }
        }

        public static 
        void glRasterPos4sv(ref Int16 v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = &v)
                {
                    Delegates.glRasterPos4sv((Int16*)v_ptr);
                }
            }
        }

        public static 
        void glRasterPos4sv(IntPtr v)
        {
            unsafe
            {
                Delegates.glRasterPos4sv((Int16*)v);
            }
        }

        public static 
        void glRectd(Double x1, Double y1, Double x2, Double y2)
        {
            Delegates.glRectd((Double)x1, (Double)y1, (Double)x2, (Double)y2);
        }

        public static 
        void glRectdv(Double[] v1, Double[] v2)
        {
            unsafe
            {
                fixed (Double* v1_ptr = v1)
                fixed (Double* v2_ptr = v2)
                {
                    Delegates.glRectdv((Double*)v1_ptr, (Double*)v2_ptr);
                }
            }
        }

        public static 
        void glRectdv(ref Double v1, ref Double v2)
        {
            unsafe
            {
                fixed (Double* v1_ptr = &v1)
                fixed (Double* v2_ptr = &v2)
                {
                    Delegates.glRectdv((Double*)v1_ptr, (Double*)v2_ptr);
                }
            }
        }

        public static 
        void glRectdv(IntPtr v1, IntPtr v2)
        {
            unsafe
            {
                Delegates.glRectdv((Double*)v1, (Double*)v2);
            }
        }

        public static 
        void glRectf(Single x1, Single y1, Single x2, Single y2)
        {
            Delegates.glRectf((Single)x1, (Single)y1, (Single)x2, (Single)y2);
        }

        public static 
        void glRectfv(Single[] v1, Single[] v2)
        {
            unsafe
            {
                fixed (Single* v1_ptr = v1)
                fixed (Single* v2_ptr = v2)
                {
                    Delegates.glRectfv((Single*)v1_ptr, (Single*)v2_ptr);
                }
            }
        }

        public static 
        void glRectfv(ref Single v1, ref Single v2)
        {
            unsafe
            {
                fixed (Single* v1_ptr = &v1)
                fixed (Single* v2_ptr = &v2)
                {
                    Delegates.glRectfv((Single*)v1_ptr, (Single*)v2_ptr);
                }
            }
        }

        public static 
        void glRectfv(IntPtr v1, IntPtr v2)
        {
            unsafe
            {
                Delegates.glRectfv((Single*)v1, (Single*)v2);
            }
        }

        public static 
        void glRecti(Int32 x1, Int32 y1, Int32 x2, Int32 y2)
        {
            Delegates.glRecti((Int32)x1, (Int32)y1, (Int32)x2, (Int32)y2);
        }

        public static 
        void glRectiv(Int32[] v1, Int32[] v2)
        {
            unsafe
            {
                fixed (Int32* v1_ptr = v1)
                fixed (Int32* v2_ptr = v2)
                {
                    Delegates.glRectiv((Int32*)v1_ptr, (Int32*)v2_ptr);
                }
            }
        }

        public static 
        void glRectiv(ref Int32 v1, ref Int32 v2)
        {
            unsafe
            {
                fixed (Int32* v1_ptr = &v1)
                fixed (Int32* v2_ptr = &v2)
                {
                    Delegates.glRectiv((Int32*)v1_ptr, (Int32*)v2_ptr);
                }
            }
        }

        public static 
        void glRectiv(IntPtr v1, IntPtr v2)
        {
            unsafe
            {
                Delegates.glRectiv((Int32*)v1, (Int32*)v2);
            }
        }

        public static 
        void glRects(Int16 x1, Int16 y1, Int16 x2, Int16 y2)
        {
            Delegates.glRects((Int16)x1, (Int16)y1, (Int16)x2, (Int16)y2);
        }

        public static 
        void glRectsv(Int16[] v1, Int16[] v2)
        {
            unsafe
            {
                fixed (Int16* v1_ptr = v1)
                fixed (Int16* v2_ptr = v2)
                {
                    Delegates.glRectsv((Int16*)v1_ptr, (Int16*)v2_ptr);
                }
            }
        }

        public static 
        void glRectsv(ref Int16 v1, ref Int16 v2)
        {
            unsafe
            {
                fixed (Int16* v1_ptr = &v1)
                fixed (Int16* v2_ptr = &v2)
                {
                    Delegates.glRectsv((Int16*)v1_ptr, (Int16*)v2_ptr);
                }
            }
        }

        public static 
        void glRectsv(IntPtr v1, IntPtr v2)
        {
            unsafe
            {
                Delegates.glRectsv((Int16*)v1, (Int16*)v2);
            }
        }

        public static 
        void glTexCoord1d(Double s)
        {
            Delegates.glTexCoord1d((Double)s);
        }

        public static 
        void glTexCoord1dv(Double[] v)
        {
            unsafe
            {
                fixed (Double* v_ptr = v)
                {
                    Delegates.glTexCoord1dv((Double*)v_ptr);
                }
            }
        }

        public static 
        void glTexCoord1dv(ref Double v)
        {
            unsafe
            {
                fixed (Double* v_ptr = &v)
                {
                    Delegates.glTexCoord1dv((Double*)v_ptr);
                }
            }
        }

        public static 
        void glTexCoord1dv(IntPtr v)
        {
            unsafe
            {
                Delegates.glTexCoord1dv((Double*)v);
            }
        }

        public static 
        void glTexCoord1f(Single s)
        {
            Delegates.glTexCoord1f((Single)s);
        }

        public static 
        void glTexCoord1fv(Single[] v)
        {
            unsafe
            {
                fixed (Single* v_ptr = v)
                {
                    Delegates.glTexCoord1fv((Single*)v_ptr);
                }
            }
        }

        public static 
        void glTexCoord1fv(ref Single v)
        {
            unsafe
            {
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glTexCoord1fv((Single*)v_ptr);
                }
            }
        }

        public static 
        void glTexCoord1fv(IntPtr v)
        {
            unsafe
            {
                Delegates.glTexCoord1fv((Single*)v);
            }
        }

        public static 
        void glTexCoord1i(Int32 s)
        {
            Delegates.glTexCoord1i((Int32)s);
        }

        public static 
        void glTexCoord1iv(Int32[] v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = v)
                {
                    Delegates.glTexCoord1iv((Int32*)v_ptr);
                }
            }
        }

        public static 
        void glTexCoord1iv(ref Int32 v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = &v)
                {
                    Delegates.glTexCoord1iv((Int32*)v_ptr);
                }
            }
        }

        public static 
        void glTexCoord1iv(IntPtr v)
        {
            unsafe
            {
                Delegates.glTexCoord1iv((Int32*)v);
            }
        }

        public static 
        void glTexCoord1s(Int16 s)
        {
            Delegates.glTexCoord1s((Int16)s);
        }

        public static 
        void glTexCoord1sv(Int16[] v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = v)
                {
                    Delegates.glTexCoord1sv((Int16*)v_ptr);
                }
            }
        }

        public static 
        void glTexCoord1sv(ref Int16 v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = &v)
                {
                    Delegates.glTexCoord1sv((Int16*)v_ptr);
                }
            }
        }

        public static 
        void glTexCoord1sv(IntPtr v)
        {
            unsafe
            {
                Delegates.glTexCoord1sv((Int16*)v);
            }
        }

        public static 
        void glTexCoord2d(Double s, Double t)
        {
            Delegates.glTexCoord2d((Double)s, (Double)t);
        }

        public static 
        void glTexCoord2dv(Double[] v)
        {
            unsafe
            {
                fixed (Double* v_ptr = v)
                {
                    Delegates.glTexCoord2dv((Double*)v_ptr);
                }
            }
        }

        public static 
        void glTexCoord2dv(ref Double v)
        {
            unsafe
            {
                fixed (Double* v_ptr = &v)
                {
                    Delegates.glTexCoord2dv((Double*)v_ptr);
                }
            }
        }

        public static 
        void glTexCoord2dv(IntPtr v)
        {
            unsafe
            {
                Delegates.glTexCoord2dv((Double*)v);
            }
        }

        public static 
        void glTexCoord2f(Single s, Single t)
        {
            Delegates.glTexCoord2f((Single)s, (Single)t);
        }

        public static 
        void glTexCoord2fv(Single[] v)
        {
            unsafe
            {
                fixed (Single* v_ptr = v)
                {
                    Delegates.glTexCoord2fv((Single*)v_ptr);
                }
            }
        }

        public static 
        void glTexCoord2fv(ref Single v)
        {
            unsafe
            {
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glTexCoord2fv((Single*)v_ptr);
                }
            }
        }

        public static 
        void glTexCoord2fv(IntPtr v)
        {
            unsafe
            {
                Delegates.glTexCoord2fv((Single*)v);
            }
        }

        public static 
        void glTexCoord2i(Int32 s, Int32 t)
        {
            Delegates.glTexCoord2i((Int32)s, (Int32)t);
        }

        public static 
        void glTexCoord2iv(Int32[] v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = v)
                {
                    Delegates.glTexCoord2iv((Int32*)v_ptr);
                }
            }
        }

        public static 
        void glTexCoord2iv(ref Int32 v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = &v)
                {
                    Delegates.glTexCoord2iv((Int32*)v_ptr);
                }
            }
        }

        public static 
        void glTexCoord2iv(IntPtr v)
        {
            unsafe
            {
                Delegates.glTexCoord2iv((Int32*)v);
            }
        }

        public static 
        void glTexCoord2s(Int16 s, Int16 t)
        {
            Delegates.glTexCoord2s((Int16)s, (Int16)t);
        }

        public static 
        void glTexCoord2sv(Int16[] v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = v)
                {
                    Delegates.glTexCoord2sv((Int16*)v_ptr);
                }
            }
        }

        public static 
        void glTexCoord2sv(ref Int16 v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = &v)
                {
                    Delegates.glTexCoord2sv((Int16*)v_ptr);
                }
            }
        }

        public static 
        void glTexCoord2sv(IntPtr v)
        {
            unsafe
            {
                Delegates.glTexCoord2sv((Int16*)v);
            }
        }

        public static 
        void glTexCoord3d(Double s, Double t, Double r)
        {
            Delegates.glTexCoord3d((Double)s, (Double)t, (Double)r);
        }

        public static 
        void glTexCoord3dv(Double[] v)
        {
            unsafe
            {
                fixed (Double* v_ptr = v)
                {
                    Delegates.glTexCoord3dv((Double*)v_ptr);
                }
            }
        }

        public static 
        void glTexCoord3dv(ref Double v)
        {
            unsafe
            {
                fixed (Double* v_ptr = &v)
                {
                    Delegates.glTexCoord3dv((Double*)v_ptr);
                }
            }
        }

        public static 
        void glTexCoord3dv(IntPtr v)
        {
            unsafe
            {
                Delegates.glTexCoord3dv((Double*)v);
            }
        }

        public static 
        void glTexCoord3f(Single s, Single t, Single r)
        {
            Delegates.glTexCoord3f((Single)s, (Single)t, (Single)r);
        }

        public static 
        void glTexCoord3fv(Single[] v)
        {
            unsafe
            {
                fixed (Single* v_ptr = v)
                {
                    Delegates.glTexCoord3fv((Single*)v_ptr);
                }
            }
        }

        public static 
        void glTexCoord3fv(ref Single v)
        {
            unsafe
            {
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glTexCoord3fv((Single*)v_ptr);
                }
            }
        }

        public static 
        void glTexCoord3fv(IntPtr v)
        {
            unsafe
            {
                Delegates.glTexCoord3fv((Single*)v);
            }
        }

        public static 
        void glTexCoord3i(Int32 s, Int32 t, Int32 r)
        {
            Delegates.glTexCoord3i((Int32)s, (Int32)t, (Int32)r);
        }

        public static 
        void glTexCoord3iv(Int32[] v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = v)
                {
                    Delegates.glTexCoord3iv((Int32*)v_ptr);
                }
            }
        }

        public static 
        void glTexCoord3iv(ref Int32 v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = &v)
                {
                    Delegates.glTexCoord3iv((Int32*)v_ptr);
                }
            }
        }

        public static 
        void glTexCoord3iv(IntPtr v)
        {
            unsafe
            {
                Delegates.glTexCoord3iv((Int32*)v);
            }
        }

        public static 
        void glTexCoord3s(Int16 s, Int16 t, Int16 r)
        {
            Delegates.glTexCoord3s((Int16)s, (Int16)t, (Int16)r);
        }

        public static 
        void glTexCoord3sv(Int16[] v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = v)
                {
                    Delegates.glTexCoord3sv((Int16*)v_ptr);
                }
            }
        }

        public static 
        void glTexCoord3sv(ref Int16 v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = &v)
                {
                    Delegates.glTexCoord3sv((Int16*)v_ptr);
                }
            }
        }

        public static 
        void glTexCoord3sv(IntPtr v)
        {
            unsafe
            {
                Delegates.glTexCoord3sv((Int16*)v);
            }
        }

        public static 
        void glTexCoord4d(Double s, Double t, Double r, Double q)
        {
            Delegates.glTexCoord4d((Double)s, (Double)t, (Double)r, (Double)q);
        }

        public static 
        void glTexCoord4dv(Double[] v)
        {
            unsafe
            {
                fixed (Double* v_ptr = v)
                {
                    Delegates.glTexCoord4dv((Double*)v_ptr);
                }
            }
        }

        public static 
        void glTexCoord4dv(ref Double v)
        {
            unsafe
            {
                fixed (Double* v_ptr = &v)
                {
                    Delegates.glTexCoord4dv((Double*)v_ptr);
                }
            }
        }

        public static 
        void glTexCoord4dv(IntPtr v)
        {
            unsafe
            {
                Delegates.glTexCoord4dv((Double*)v);
            }
        }

        public static 
        void glTexCoord4f(Single s, Single t, Single r, Single q)
        {
            Delegates.glTexCoord4f((Single)s, (Single)t, (Single)r, (Single)q);
        }

        public static 
        void glTexCoord4fv(Single[] v)
        {
            unsafe
            {
                fixed (Single* v_ptr = v)
                {
                    Delegates.glTexCoord4fv((Single*)v_ptr);
                }
            }
        }

        public static 
        void glTexCoord4fv(ref Single v)
        {
            unsafe
            {
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glTexCoord4fv((Single*)v_ptr);
                }
            }
        }

        public static 
        void glTexCoord4fv(IntPtr v)
        {
            unsafe
            {
                Delegates.glTexCoord4fv((Single*)v);
            }
        }

        public static 
        void glTexCoord4i(Int32 s, Int32 t, Int32 r, Int32 q)
        {
            Delegates.glTexCoord4i((Int32)s, (Int32)t, (Int32)r, (Int32)q);
        }

        public static 
        void glTexCoord4iv(Int32[] v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = v)
                {
                    Delegates.glTexCoord4iv((Int32*)v_ptr);
                }
            }
        }

        public static 
        void glTexCoord4iv(ref Int32 v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = &v)
                {
                    Delegates.glTexCoord4iv((Int32*)v_ptr);
                }
            }
        }

        public static 
        void glTexCoord4iv(IntPtr v)
        {
            unsafe
            {
                Delegates.glTexCoord4iv((Int32*)v);
            }
        }

        public static 
        void glTexCoord4s(Int16 s, Int16 t, Int16 r, Int16 q)
        {
            Delegates.glTexCoord4s((Int16)s, (Int16)t, (Int16)r, (Int16)q);
        }

        public static 
        void glTexCoord4sv(Int16[] v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = v)
                {
                    Delegates.glTexCoord4sv((Int16*)v_ptr);
                }
            }
        }

        public static 
        void glTexCoord4sv(ref Int16 v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = &v)
                {
                    Delegates.glTexCoord4sv((Int16*)v_ptr);
                }
            }
        }

        public static 
        void glTexCoord4sv(IntPtr v)
        {
            unsafe
            {
                Delegates.glTexCoord4sv((Int16*)v);
            }
        }

        public static 
        void glVertex2d(Double x, Double y)
        {
            Delegates.glVertex2d((Double)x, (Double)y);
        }

        public static 
        void glVertex2dv(Double[] v)
        {
            unsafe
            {
                fixed (Double* v_ptr = v)
                {
                    Delegates.glVertex2dv((Double*)v_ptr);
                }
            }
        }

        public static 
        void glVertex2dv(ref Double v)
        {
            unsafe
            {
                fixed (Double* v_ptr = &v)
                {
                    Delegates.glVertex2dv((Double*)v_ptr);
                }
            }
        }

        public static 
        void glVertex2dv(IntPtr v)
        {
            unsafe
            {
                Delegates.glVertex2dv((Double*)v);
            }
        }

        public static 
        void glVertex2f(Single x, Single y)
        {
            Delegates.glVertex2f((Single)x, (Single)y);
        }

        public static 
        void glVertex2fv(Single[] v)
        {
            unsafe
            {
                fixed (Single* v_ptr = v)
                {
                    Delegates.glVertex2fv((Single*)v_ptr);
                }
            }
        }

        public static 
        void glVertex2fv(ref Single v)
        {
            unsafe
            {
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glVertex2fv((Single*)v_ptr);
                }
            }
        }

        public static 
        void glVertex2fv(IntPtr v)
        {
            unsafe
            {
                Delegates.glVertex2fv((Single*)v);
            }
        }

        public static 
        void glVertex2i(Int32 x, Int32 y)
        {
            Delegates.glVertex2i((Int32)x, (Int32)y);
        }

        public static 
        void glVertex2iv(Int32[] v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = v)
                {
                    Delegates.glVertex2iv((Int32*)v_ptr);
                }
            }
        }

        public static 
        void glVertex2iv(ref Int32 v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = &v)
                {
                    Delegates.glVertex2iv((Int32*)v_ptr);
                }
            }
        }

        public static 
        void glVertex2iv(IntPtr v)
        {
            unsafe
            {
                Delegates.glVertex2iv((Int32*)v);
            }
        }

        public static 
        void glVertex2s(Int16 x, Int16 y)
        {
            Delegates.glVertex2s((Int16)x, (Int16)y);
        }

        public static 
        void glVertex2sv(Int16[] v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = v)
                {
                    Delegates.glVertex2sv((Int16*)v_ptr);
                }
            }
        }

        public static 
        void glVertex2sv(ref Int16 v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = &v)
                {
                    Delegates.glVertex2sv((Int16*)v_ptr);
                }
            }
        }

        public static 
        void glVertex2sv(IntPtr v)
        {
            unsafe
            {
                Delegates.glVertex2sv((Int16*)v);
            }
        }

        public static 
        void glVertex3d(Double x, Double y, Double z)
        {
            Delegates.glVertex3d((Double)x, (Double)y, (Double)z);
        }

        public static 
        void glVertex3dv(Double[] v)
        {
            unsafe
            {
                fixed (Double* v_ptr = v)
                {
                    Delegates.glVertex3dv((Double*)v_ptr);
                }
            }
        }

        public static 
        void glVertex3dv(ref Double v)
        {
            unsafe
            {
                fixed (Double* v_ptr = &v)
                {
                    Delegates.glVertex3dv((Double*)v_ptr);
                }
            }
        }

        public static 
        void glVertex3dv(IntPtr v)
        {
            unsafe
            {
                Delegates.glVertex3dv((Double*)v);
            }
        }

        public static 
        void glVertex3f(Single x, Single y, Single z)
        {
            Delegates.glVertex3f((Single)x, (Single)y, (Single)z);
        }

        public static 
        void glVertex3fv(Single[] v)
        {
            unsafe
            {
                fixed (Single* v_ptr = v)
                {
                    Delegates.glVertex3fv((Single*)v_ptr);
                }
            }
        }

        public static 
        void glVertex3fv(ref Single v)
        {
            unsafe
            {
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glVertex3fv((Single*)v_ptr);
                }
            }
        }

        public static 
        void glVertex3fv(IntPtr v)
        {
            unsafe
            {
                Delegates.glVertex3fv((Single*)v);
            }
        }

        public static 
        void glVertex3i(Int32 x, Int32 y, Int32 z)
        {
            Delegates.glVertex3i((Int32)x, (Int32)y, (Int32)z);
        }

        public static 
        void glVertex3iv(Int32[] v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = v)
                {
                    Delegates.glVertex3iv((Int32*)v_ptr);
                }
            }
        }

        public static 
        void glVertex3iv(ref Int32 v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = &v)
                {
                    Delegates.glVertex3iv((Int32*)v_ptr);
                }
            }
        }

        public static 
        void glVertex3iv(IntPtr v)
        {
            unsafe
            {
                Delegates.glVertex3iv((Int32*)v);
            }
        }

        public static 
        void glVertex3s(Int16 x, Int16 y, Int16 z)
        {
            Delegates.glVertex3s((Int16)x, (Int16)y, (Int16)z);
        }

        public static 
        void glVertex3sv(Int16[] v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = v)
                {
                    Delegates.glVertex3sv((Int16*)v_ptr);
                }
            }
        }

        public static 
        void glVertex3sv(ref Int16 v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = &v)
                {
                    Delegates.glVertex3sv((Int16*)v_ptr);
                }
            }
        }

        public static 
        void glVertex3sv(IntPtr v)
        {
            unsafe
            {
                Delegates.glVertex3sv((Int16*)v);
            }
        }

        public static 
        void glVertex4d(Double x, Double y, Double z, Double w)
        {
            Delegates.glVertex4d((Double)x, (Double)y, (Double)z, (Double)w);
        }

        public static 
        void glVertex4dv(Double[] v)
        {
            unsafe
            {
                fixed (Double* v_ptr = v)
                {
                    Delegates.glVertex4dv((Double*)v_ptr);
                }
            }
        }

        public static 
        void glVertex4dv(ref Double v)
        {
            unsafe
            {
                fixed (Double* v_ptr = &v)
                {
                    Delegates.glVertex4dv((Double*)v_ptr);
                }
            }
        }

        public static 
        void glVertex4dv(IntPtr v)
        {
            unsafe
            {
                Delegates.glVertex4dv((Double*)v);
            }
        }

        public static 
        void glVertex4f(Single x, Single y, Single z, Single w)
        {
            Delegates.glVertex4f((Single)x, (Single)y, (Single)z, (Single)w);
        }

        public static 
        void glVertex4fv(Single[] v)
        {
            unsafe
            {
                fixed (Single* v_ptr = v)
                {
                    Delegates.glVertex4fv((Single*)v_ptr);
                }
            }
        }

        public static 
        void glVertex4fv(ref Single v)
        {
            unsafe
            {
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glVertex4fv((Single*)v_ptr);
                }
            }
        }

        public static 
        void glVertex4fv(IntPtr v)
        {
            unsafe
            {
                Delegates.glVertex4fv((Single*)v);
            }
        }

        public static 
        void glVertex4i(Int32 x, Int32 y, Int32 z, Int32 w)
        {
            Delegates.glVertex4i((Int32)x, (Int32)y, (Int32)z, (Int32)w);
        }

        public static 
        void glVertex4iv(Int32[] v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = v)
                {
                    Delegates.glVertex4iv((Int32*)v_ptr);
                }
            }
        }

        public static 
        void glVertex4iv(ref Int32 v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = &v)
                {
                    Delegates.glVertex4iv((Int32*)v_ptr);
                }
            }
        }

        public static 
        void glVertex4iv(IntPtr v)
        {
            unsafe
            {
                Delegates.glVertex4iv((Int32*)v);
            }
        }

        public static 
        void glVertex4s(Int16 x, Int16 y, Int16 z, Int16 w)
        {
            Delegates.glVertex4s((Int16)x, (Int16)y, (Int16)z, (Int16)w);
        }

        public static 
        void glVertex4sv(Int16[] v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = v)
                {
                    Delegates.glVertex4sv((Int16*)v_ptr);
                }
            }
        }

        public static 
        void glVertex4sv(ref Int16 v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = &v)
                {
                    Delegates.glVertex4sv((Int16*)v_ptr);
                }
            }
        }

        public static 
        void glVertex4sv(IntPtr v)
        {
            unsafe
            {
                Delegates.glVertex4sv((Int16*)v);
            }
        }

        public static 
        void glClipPlane(int plane, Double[] equation)
        {
            unsafe
            {
                fixed (Double* equation_ptr = equation)
                {
                    Delegates.glClipPlane((int)plane, (Double*)equation_ptr);
                }
            }
        }

        public static 
        void glClipPlane(int plane, ref Double equation)
        {
            unsafe
            {
                fixed (Double* equation_ptr = &equation)
                {
                    Delegates.glClipPlane((int)plane, (Double*)equation_ptr);
                }
            }
        }

        public static 
        void glClipPlane(int plane, IntPtr equation)
        {
            unsafe
            {
                Delegates.glClipPlane((int)plane, (Double*)equation);
            }
        }

        public static 
        void glColorMaterial(int face, int mode)
        {
            Delegates.glColorMaterial((int)face, (int)mode);
        }

        public static 
        void glCullFace(int mode)
        {
            Delegates.glCullFace((int)mode);
        }

        public static 
        void glFogf(int pname, Single param)
        {
            Delegates.glFogf((int)pname, (Single)param);
        }

        public static 
        void glFogfv(int pname, Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glFogfv((int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glFogfv(int pname, ref Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glFogfv((int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glFogfv(int pname, IntPtr @params)
        {
            unsafe
            {
                Delegates.glFogfv((int)pname, (Single*)@params);
            }
        }

        public static 
        void glFogi(int pname, Int32 param)
        {
            Delegates.glFogi((int)pname, (Int32)param);
        }

        public static 
        void glFogiv(int pname, Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glFogiv((int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glFogiv(int pname, ref Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glFogiv((int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glFogiv(int pname, IntPtr @params)
        {
            unsafe
            {
                Delegates.glFogiv((int)pname, (Int32*)@params);
            }
        }

        public static 
        void glFrontFace(int mode)
        {
            Delegates.glFrontFace((int)mode);
        }

        public static 
        void glHint(int target, int mode)
        {
            Delegates.glHint((int)target, (int)mode);
        }

        public static 
        void glLightf(int light, int pname, Single param)
        {
            Delegates.glLightf((int)light, (int)pname, (Single)param);
        }

        public static 
        void glLightfv(int light, int pname, Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glLightfv((int)light, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glLightfv(int light, int pname, ref Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glLightfv((int)light, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glLightfv(int light, int pname, IntPtr @params)
        {
            unsafe
            {
                Delegates.glLightfv((int)light, (int)pname, (Single*)@params);
            }
        }

        public static 
        void glLighti(int light, int pname, Int32 param)
        {
            Delegates.glLighti((int)light, (int)pname, (Int32)param);
        }

        public static 
        void glLightiv(int light, int pname, Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glLightiv((int)light, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glLightiv(int light, int pname, ref Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glLightiv((int)light, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glLightiv(int light, int pname, IntPtr @params)
        {
            unsafe
            {
                Delegates.glLightiv((int)light, (int)pname, (Int32*)@params);
            }
        }

        public static 
        void glLightModelf(int pname, Single param)
        {
            Delegates.glLightModelf((int)pname, (Single)param);
        }

        public static 
        void glLightModelfv(int pname, Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glLightModelfv((int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glLightModelfv(int pname, ref Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glLightModelfv((int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glLightModelfv(int pname, IntPtr @params)
        {
            unsafe
            {
                Delegates.glLightModelfv((int)pname, (Single*)@params);
            }
        }

        public static 
        void glLightModeli(int pname, Int32 param)
        {
            Delegates.glLightModeli((int)pname, (Int32)param);
        }

        public static 
        void glLightModeliv(int pname, Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glLightModeliv((int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glLightModeliv(int pname, ref Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glLightModeliv((int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glLightModeliv(int pname, IntPtr @params)
        {
            unsafe
            {
                Delegates.glLightModeliv((int)pname, (Int32*)@params);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glLineStipple(Int32 factor, UInt16 pattern)
        {
            unsafe
            {
                Delegates.glLineStipple((Int32)factor, (UInt16)pattern);
            }
        }

        public static 
        void glLineStipple(Int32 factor, Int16 pattern)
        {
            unsafe
            {
                Delegates.glLineStipple((Int32)factor, (UInt16)pattern);
            }
        }

        public static 
        void glLineWidth(Single width)
        {
            Delegates.glLineWidth((Single)width);
        }

        public static 
        void glMaterialf(int face, int pname, Single param)
        {
            Delegates.glMaterialf((int)face, (int)pname, (Single)param);
        }

        public static 
        void glMaterialfv(int face, int pname, Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glMaterialfv((int)face, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glMaterialfv(int face, int pname, ref Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glMaterialfv((int)face, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glMaterialfv(int face, int pname, IntPtr @params)
        {
            unsafe
            {
                Delegates.glMaterialfv((int)face, (int)pname, (Single*)@params);
            }
        }

        public static 
        void glMateriali(int face, int pname, Int32 param)
        {
            Delegates.glMateriali((int)face, (int)pname, (Int32)param);
        }

        public static 
        void glMaterialiv(int face, int pname, Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glMaterialiv((int)face, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glMaterialiv(int face, int pname, ref Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glMaterialiv((int)face, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glMaterialiv(int face, int pname, IntPtr @params)
        {
            unsafe
            {
                Delegates.glMaterialiv((int)face, (int)pname, (Int32*)@params);
            }
        }

        public static 
        void glPointSize(Single size)
        {
            Delegates.glPointSize((Single)size);
        }

        public static 
        void glPolygonMode(int face, int mode)
        {
            Delegates.glPolygonMode((int)face, (int)mode);
        }

        public static 
        void glPolygonStipple(Byte[] mask)
        {
            unsafe
            {
                fixed (Byte* mask_ptr = mask)
                {
                    Delegates.glPolygonStipple((Byte*)mask_ptr);
                }
            }
        }

        public static 
        void glPolygonStipple(ref Byte mask)
        {
            unsafe
            {
                fixed (Byte* mask_ptr = &mask)
                {
                    Delegates.glPolygonStipple((Byte*)mask_ptr);
                }
            }
        }

        public static 
        void glPolygonStipple(IntPtr mask)
        {
            unsafe
            {
                Delegates.glPolygonStipple((Byte*)mask);
            }
        }

        public static 
        void glScissor(Int32 x, Int32 y, Int32 width, Int32 height)
        {
            Delegates.glScissor((Int32)x, (Int32)y, (Int32)width, (Int32)height);
        }

        public static 
        void glShadeModel(int mode)
        {
            Delegates.glShadeModel((int)mode);
        }

        public static 
        void glTexParameterf(int target, int pname, Single param)
        {
            Delegates.glTexParameterf((int)target, (int)pname, (Single)param);
        }

        public static 
        void glTexParameterfv(int target, int pname, Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glTexParameterfv((int)target, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glTexParameterfv(int target, int pname, ref Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glTexParameterfv((int)target, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glTexParameterfv(int target, int pname, IntPtr @params)
        {
            unsafe
            {
                Delegates.glTexParameterfv((int)target, (int)pname, (Single*)@params);
            }
        }

        public static 
        void glTexParameteri(int target, int pname, Int32 param)
        {
            Delegates.glTexParameteri((int)target, (int)pname, (Int32)param);
        }

        public static 
        void glTexParameteriv(int target, int pname, Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glTexParameteriv((int)target, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glTexParameteriv(int target, int pname, ref Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glTexParameteriv((int)target, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glTexParameteriv(int target, int pname, IntPtr @params)
        {
            unsafe
            {
                Delegates.glTexParameteriv((int)target, (int)pname, (Int32*)@params);
            }
        }

        public static 
        void glTexImage1D(int target, Int32 level, Int32 internalformat, Int32 width, Int32 border, int format, int type, IntPtr pixels)
        {
            unsafe
            {
                Delegates.glTexImage1D((int)target, (Int32)level, (Int32)internalformat, (Int32)width, (Int32)border, (int)format, (int)type, (IntPtr)pixels);
            }
        }

        public static 
        void glTexImage1D(int target, Int32 level, Int32 internalformat, Int32 width, Int32 border, int format, int type, [In, Out] object pixels)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle pixels_ptr = System.Runtime.InteropServices.GCHandle.Alloc(pixels, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glTexImage1D((int)target, (Int32)level, (Int32)internalformat, (Int32)width, (Int32)border, (int)format, (int)type, (IntPtr)pixels_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pixels_ptr.Free();
                }
            }
        }

        public static 
        void glTexImage2D(int target, Int32 level, Int32 internalformat, Int32 width, Int32 height, Int32 border, int format, int type, IntPtr pixels)
        {
            unsafe
            {
                Delegates.glTexImage2D((int)target, (Int32)level, (Int32)internalformat, (Int32)width, (Int32)height, (Int32)border, (int)format, (int)type, (IntPtr)pixels);
            }
        }

        public static 
        void glTexImage2D(int target, Int32 level, Int32 internalformat, Int32 width, Int32 height, Int32 border, int format, int type, [In, Out] object pixels)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle pixels_ptr = System.Runtime.InteropServices.GCHandle.Alloc(pixels, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glTexImage2D((int)target, (Int32)level, (Int32)internalformat, (Int32)width, (Int32)height, (Int32)border, (int)format, (int)type, (IntPtr)pixels_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pixels_ptr.Free();
                }
            }
        }

        public static 
        void glTexEnvf(int target, int pname, Single param)
        {
            Delegates.glTexEnvf((int)target, (int)pname, (Single)param);
        }

        public static 
        void glTexEnvfv(int target, int pname, Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glTexEnvfv((int)target, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glTexEnvfv(int target, int pname, ref Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glTexEnvfv((int)target, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glTexEnvfv(int target, int pname, IntPtr @params)
        {
            unsafe
            {
                Delegates.glTexEnvfv((int)target, (int)pname, (Single*)@params);
            }
        }

        public static 
        void glTexEnvi(int target, int pname, Int32 param)
        {
            Delegates.glTexEnvi((int)target, (int)pname, (Int32)param);
        }

        public static 
        void glTexEnviv(int target, int pname, Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glTexEnviv((int)target, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glTexEnviv(int target, int pname, ref Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glTexEnviv((int)target, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glTexEnviv(int target, int pname, IntPtr @params)
        {
            unsafe
            {
                Delegates.glTexEnviv((int)target, (int)pname, (Int32*)@params);
            }
        }

        public static 
        void glTexGend(int coord, int pname, Double param)
        {
            Delegates.glTexGend((int)coord, (int)pname, (Double)param);
        }

        public static 
        void glTexGendv(int coord, int pname, Double[] @params)
        {
            unsafe
            {
                fixed (Double* @params_ptr = @params)
                {
                    Delegates.glTexGendv((int)coord, (int)pname, (Double*)@params_ptr);
                }
            }
        }

        public static 
        void glTexGendv(int coord, int pname, ref Double @params)
        {
            unsafe
            {
                fixed (Double* @params_ptr = &@params)
                {
                    Delegates.glTexGendv((int)coord, (int)pname, (Double*)@params_ptr);
                }
            }
        }

        public static 
        void glTexGendv(int coord, int pname, IntPtr @params)
        {
            unsafe
            {
                Delegates.glTexGendv((int)coord, (int)pname, (Double*)@params);
            }
        }

        public static 
        void glTexGenf(int coord, int pname, Single param)
        {
            Delegates.glTexGenf((int)coord, (int)pname, (Single)param);
        }

        public static 
        void glTexGenfv(int coord, int pname, Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glTexGenfv((int)coord, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glTexGenfv(int coord, int pname, ref Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glTexGenfv((int)coord, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glTexGenfv(int coord, int pname, IntPtr @params)
        {
            unsafe
            {
                Delegates.glTexGenfv((int)coord, (int)pname, (Single*)@params);
            }
        }

        public static 
        void glTexGeni(int coord, int pname, Int32 param)
        {
            Delegates.glTexGeni((int)coord, (int)pname, (Int32)param);
        }

        public static 
        void glTexGeniv(int coord, int pname, Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glTexGeniv((int)coord, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glTexGeniv(int coord, int pname, ref Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glTexGeniv((int)coord, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glTexGeniv(int coord, int pname, IntPtr @params)
        {
            unsafe
            {
                Delegates.glTexGeniv((int)coord, (int)pname, (Int32*)@params);
            }
        }

        public static 
        void glFeedbackBuffer(Int32 size, int type, [Out] Single[] buffer)
        {
            unsafe
            {
                fixed (Single* buffer_ptr = buffer)
                {
                    Delegates.glFeedbackBuffer((Int32)size, (int)type, (Single*)buffer_ptr);
                }
            }
        }

        public static 
        void glFeedbackBuffer(Int32 size, int type, [Out] out Single buffer)
        {
            unsafe
            {
                fixed (Single* buffer_ptr = &buffer)
                {
                    Delegates.glFeedbackBuffer((Int32)size, (int)type, (Single*)buffer_ptr);
                    buffer = *buffer_ptr;
                }
            }
        }

        public static 
        void glFeedbackBuffer(Int32 size, int type, [Out] IntPtr buffer)
        {
            unsafe
            {
                Delegates.glFeedbackBuffer((Int32)size, (int)type, (Single*)buffer);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glSelectBuffer(Int32 size, [Out] UInt32[] buffer)
        {
            unsafe
            {
                fixed (UInt32* buffer_ptr = buffer)
                {
                    Delegates.glSelectBuffer((Int32)size, (UInt32*)buffer_ptr);
                }
            }
        }

        public static 
        void glSelectBuffer(Int32 size, [Out] Int32[] buffer)
        {
            unsafe
            {
                fixed (Int32* buffer_ptr = buffer)
                {
                    Delegates.glSelectBuffer((Int32)size, (UInt32*)buffer_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glSelectBuffer(Int32 size, [Out] out UInt32 buffer)
        {
            unsafe
            {
                fixed (UInt32* buffer_ptr = &buffer)
                {
                    Delegates.glSelectBuffer((Int32)size, (UInt32*)buffer_ptr);
                    buffer = *buffer_ptr;
                }
            }
        }

        public static 
        void glSelectBuffer(Int32 size, [Out] out Int32 buffer)
        {
            unsafe
            {
                fixed (Int32* buffer_ptr = &buffer)
                {
                    Delegates.glSelectBuffer((Int32)size, (UInt32*)buffer_ptr);
                    buffer = *buffer_ptr;
                }
            }
        }

        public static 
        void glSelectBuffer(Int32 size, [Out] IntPtr buffer)
        {
            unsafe
            {
                Delegates.glSelectBuffer((Int32)size, (UInt32*)buffer);
            }
        }

        public static 
        Int32 glRenderMode(int mode)
        {
            return Delegates.glRenderMode((int)mode);
        }

        public static 
        void glInitNames()
        {
            Delegates.glInitNames();
        }

        [System.CLSCompliant(false)]
        public static 
        void glLoadName(UInt32 name)
        {
            Delegates.glLoadName((UInt32)name);
        }

        public static 
        void glLoadName(Int32 name)
        {
            Delegates.glLoadName((UInt32)name);
        }

        public static 
        void glPassThrough(Single token)
        {
            Delegates.glPassThrough((Single)token);
        }

        public static 
        void glPopName()
        {
            Delegates.glPopName();
        }

        [System.CLSCompliant(false)]
        public static 
        void glPushName(UInt32 name)
        {
            Delegates.glPushName((UInt32)name);
        }

        public static 
        void glPushName(Int32 name)
        {
            Delegates.glPushName((UInt32)name);
        }

        public static 
        void glDrawBuffer(int mode)
        {
            Delegates.glDrawBuffer((int)mode);
        }

        public static 
        void glClear(int mask)
        {
            Delegates.glClear((int)mask);
        }

        public static 
        void glClearAccum(Single red, Single green, Single blue, Single alpha)
        {
            Delegates.glClearAccum((Single)red, (Single)green, (Single)blue, (Single)alpha);
        }

        public static 
        void glClearIndex(Single c)
        {
            Delegates.glClearIndex((Single)c);
        }

        public static 
        void glClearColor(Single red, Single green, Single blue, Single alpha)
        {
            Delegates.glClearColor((Single)red, (Single)green, (Single)blue, (Single)alpha);
        }

        public static 
        void glClearStencil(Int32 s)
        {
            Delegates.glClearStencil((Int32)s);
        }

        public static 
        void glClearDepth(Double depth)
        {
            Delegates.glClearDepth((Double)depth);
        }

        [System.CLSCompliant(false)]
        public static 
        void glStencilMask(UInt32 mask)
        {
            Delegates.glStencilMask((UInt32)mask);
        }

        public static 
        void glStencilMask(Int32 mask)
        {
            Delegates.glStencilMask((UInt32)mask);
        }

        public static 
        void glColorMask(bool red, bool green, bool blue, bool alpha)
        {
            Delegates.glColorMask((bool)red, (bool)green, (bool)blue, (bool)alpha);
        }

        public static 
        void glDepthMask(bool flag)
        {
            Delegates.glDepthMask((bool)flag);
        }

        [System.CLSCompliant(false)]
        public static 
        void glIndexMask(UInt32 mask)
        {
            Delegates.glIndexMask((UInt32)mask);
        }

        public static 
        void glIndexMask(Int32 mask)
        {
            Delegates.glIndexMask((UInt32)mask);
        }

        public static 
        void glAccum(int op, Single value)
        {
            Delegates.glAccum((int)op, (Single)value);
        }

        public static 
        void glDisable(int cap)
        {
            Delegates.glDisable((int)cap);
        }

        public static 
        void glEnable(int cap)
        {
            Delegates.glEnable((int)cap);
        }

        public static 
        void glFinish()
        {
            Delegates.glFinish();
        }

        public static 
        void glFlush()
        {
            Delegates.glFlush();
        }

        public static 
        void glPopAttrib()
        {
            Delegates.glPopAttrib();
        }

        public static 
        void glPushAttrib(int mask)
        {
            Delegates.glPushAttrib((int)mask);
        }

        public static 
        void glMap1d(int target, Double u1, Double u2, Int32 stride, Int32 order, Double[] points)
        {
            unsafe
            {
                fixed (Double* points_ptr = points)
                {
                    Delegates.glMap1d((int)target, (Double)u1, (Double)u2, (Int32)stride, (Int32)order, (Double*)points_ptr);
                }
            }
        }

        public static 
        void glMap1d(int target, Double u1, Double u2, Int32 stride, Int32 order, ref Double points)
        {
            unsafe
            {
                fixed (Double* points_ptr = &points)
                {
                    Delegates.glMap1d((int)target, (Double)u1, (Double)u2, (Int32)stride, (Int32)order, (Double*)points_ptr);
                }
            }
        }

        public static 
        void glMap1d(int target, Double u1, Double u2, Int32 stride, Int32 order, IntPtr points)
        {
            unsafe
            {
                Delegates.glMap1d((int)target, (Double)u1, (Double)u2, (Int32)stride, (Int32)order, (Double*)points);
            }
        }

        public static 
        void glMap1f(int target, Single u1, Single u2, Int32 stride, Int32 order, Single[] points)
        {
            unsafe
            {
                fixed (Single* points_ptr = points)
                {
                    Delegates.glMap1f((int)target, (Single)u1, (Single)u2, (Int32)stride, (Int32)order, (Single*)points_ptr);
                }
            }
        }

        public static 
        void glMap1f(int target, Single u1, Single u2, Int32 stride, Int32 order, ref Single points)
        {
            unsafe
            {
                fixed (Single* points_ptr = &points)
                {
                    Delegates.glMap1f((int)target, (Single)u1, (Single)u2, (Int32)stride, (Int32)order, (Single*)points_ptr);
                }
            }
        }

        public static 
        void glMap1f(int target, Single u1, Single u2, Int32 stride, Int32 order, IntPtr points)
        {
            unsafe
            {
                Delegates.glMap1f((int)target, (Single)u1, (Single)u2, (Int32)stride, (Int32)order, (Single*)points);
            }
        }

        public static 
        void glMap2d(int target, Double u1, Double u2, Int32 ustride, Int32 uorder, Double v1, Double v2, Int32 vstride, Int32 vorder, Double[] points)
        {
            unsafe
            {
                fixed (Double* points_ptr = points)
                {
                    Delegates.glMap2d((int)target, (Double)u1, (Double)u2, (Int32)ustride, (Int32)uorder, (Double)v1, (Double)v2, (Int32)vstride, (Int32)vorder, (Double*)points_ptr);
                }
            }
        }

        public static 
        void glMap2d(int target, Double u1, Double u2, Int32 ustride, Int32 uorder, Double v1, Double v2, Int32 vstride, Int32 vorder, ref Double points)
        {
            unsafe
            {
                fixed (Double* points_ptr = &points)
                {
                    Delegates.glMap2d((int)target, (Double)u1, (Double)u2, (Int32)ustride, (Int32)uorder, (Double)v1, (Double)v2, (Int32)vstride, (Int32)vorder, (Double*)points_ptr);
                }
            }
        }

        public static 
        void glMap2d(int target, Double u1, Double u2, Int32 ustride, Int32 uorder, Double v1, Double v2, Int32 vstride, Int32 vorder, IntPtr points)
        {
            unsafe
            {
                Delegates.glMap2d((int)target, (Double)u1, (Double)u2, (Int32)ustride, (Int32)uorder, (Double)v1, (Double)v2, (Int32)vstride, (Int32)vorder, (Double*)points);
            }
        }

        public static 
        void glMap2f(int target, Single u1, Single u2, Int32 ustride, Int32 uorder, Single v1, Single v2, Int32 vstride, Int32 vorder, Single[] points)
        {
            unsafe
            {
                fixed (Single* points_ptr = points)
                {
                    Delegates.glMap2f((int)target, (Single)u1, (Single)u2, (Int32)ustride, (Int32)uorder, (Single)v1, (Single)v2, (Int32)vstride, (Int32)vorder, (Single*)points_ptr);
                }
            }
        }

        public static 
        void glMap2f(int target, Single u1, Single u2, Int32 ustride, Int32 uorder, Single v1, Single v2, Int32 vstride, Int32 vorder, ref Single points)
        {
            unsafe
            {
                fixed (Single* points_ptr = &points)
                {
                    Delegates.glMap2f((int)target, (Single)u1, (Single)u2, (Int32)ustride, (Int32)uorder, (Single)v1, (Single)v2, (Int32)vstride, (Int32)vorder, (Single*)points_ptr);
                }
            }
        }

        public static 
        void glMap2f(int target, Single u1, Single u2, Int32 ustride, Int32 uorder, Single v1, Single v2, Int32 vstride, Int32 vorder, IntPtr points)
        {
            unsafe
            {
                Delegates.glMap2f((int)target, (Single)u1, (Single)u2, (Int32)ustride, (Int32)uorder, (Single)v1, (Single)v2, (Int32)vstride, (Int32)vorder, (Single*)points);
            }
        }

        public static 
        void glMapGrid1d(Int32 un, Double u1, Double u2)
        {
            Delegates.glMapGrid1d((Int32)un, (Double)u1, (Double)u2);
        }

        public static 
        void glMapGrid1f(Int32 un, Single u1, Single u2)
        {
            Delegates.glMapGrid1f((Int32)un, (Single)u1, (Single)u2);
        }

        public static 
        void glMapGrid2d(Int32 un, Double u1, Double u2, Int32 vn, Double v1, Double v2)
        {
            Delegates.glMapGrid2d((Int32)un, (Double)u1, (Double)u2, (Int32)vn, (Double)v1, (Double)v2);
        }

        public static 
        void glMapGrid2f(Int32 un, Single u1, Single u2, Int32 vn, Single v1, Single v2)
        {
            Delegates.glMapGrid2f((Int32)un, (Single)u1, (Single)u2, (Int32)vn, (Single)v1, (Single)v2);
        }

        public static 
        void glEvalCoord1d(Double u)
        {
            Delegates.glEvalCoord1d((Double)u);
        }

        public static 
        void glEvalCoord1dv(Double[] u)
        {
            unsafe
            {
                fixed (Double* u_ptr = u)
                {
                    Delegates.glEvalCoord1dv((Double*)u_ptr);
                }
            }
        }

        public static 
        void glEvalCoord1dv(ref Double u)
        {
            unsafe
            {
                fixed (Double* u_ptr = &u)
                {
                    Delegates.glEvalCoord1dv((Double*)u_ptr);
                }
            }
        }

        public static 
        void glEvalCoord1dv(IntPtr u)
        {
            unsafe
            {
                Delegates.glEvalCoord1dv((Double*)u);
            }
        }

        public static 
        void glEvalCoord1f(Single u)
        {
            Delegates.glEvalCoord1f((Single)u);
        }

        public static 
        void glEvalCoord1fv(Single[] u)
        {
            unsafe
            {
                fixed (Single* u_ptr = u)
                {
                    Delegates.glEvalCoord1fv((Single*)u_ptr);
                }
            }
        }

        public static 
        void glEvalCoord1fv(ref Single u)
        {
            unsafe
            {
                fixed (Single* u_ptr = &u)
                {
                    Delegates.glEvalCoord1fv((Single*)u_ptr);
                }
            }
        }

        public static 
        void glEvalCoord1fv(IntPtr u)
        {
            unsafe
            {
                Delegates.glEvalCoord1fv((Single*)u);
            }
        }

        public static 
        void glEvalCoord2d(Double u, Double v)
        {
            Delegates.glEvalCoord2d((Double)u, (Double)v);
        }

        public static 
        void glEvalCoord2dv(Double[] u)
        {
            unsafe
            {
                fixed (Double* u_ptr = u)
                {
                    Delegates.glEvalCoord2dv((Double*)u_ptr);
                }
            }
        }

        public static 
        void glEvalCoord2dv(ref Double u)
        {
            unsafe
            {
                fixed (Double* u_ptr = &u)
                {
                    Delegates.glEvalCoord2dv((Double*)u_ptr);
                }
            }
        }

        public static 
        void glEvalCoord2dv(IntPtr u)
        {
            unsafe
            {
                Delegates.glEvalCoord2dv((Double*)u);
            }
        }

        public static 
        void glEvalCoord2f(Single u, Single v)
        {
            Delegates.glEvalCoord2f((Single)u, (Single)v);
        }

        public static 
        void glEvalCoord2fv(Single[] u)
        {
            unsafe
            {
                fixed (Single* u_ptr = u)
                {
                    Delegates.glEvalCoord2fv((Single*)u_ptr);
                }
            }
        }

        public static 
        void glEvalCoord2fv(ref Single u)
        {
            unsafe
            {
                fixed (Single* u_ptr = &u)
                {
                    Delegates.glEvalCoord2fv((Single*)u_ptr);
                }
            }
        }

        public static 
        void glEvalCoord2fv(IntPtr u)
        {
            unsafe
            {
                Delegates.glEvalCoord2fv((Single*)u);
            }
        }

        public static 
        void glEvalMesh1(int mode, Int32 i1, Int32 i2)
        {
            Delegates.glEvalMesh1((int)mode, (Int32)i1, (Int32)i2);
        }

        public static 
        void glEvalPoint1(Int32 i)
        {
            Delegates.glEvalPoint1((Int32)i);
        }

        public static 
        void glEvalMesh2(int mode, Int32 i1, Int32 i2, Int32 j1, Int32 j2)
        {
            Delegates.glEvalMesh2((int)mode, (Int32)i1, (Int32)i2, (Int32)j1, (Int32)j2);
        }

        public static 
        void glEvalPoint2(Int32 i, Int32 j)
        {
            Delegates.glEvalPoint2((Int32)i, (Int32)j);
        }

        public static 
        void glAlphaFunc(int func, Single @ref)
        {
            Delegates.glAlphaFunc((int)func, (Single)@ref);
        }

        public static 
        void glBlendFunc(int sfactor, int dfactor)
        {
            Delegates.glBlendFunc((int)sfactor, (int)dfactor);
        }

        public static 
        void glLogicOp(int opcode)
        {
            Delegates.glLogicOp((int)opcode);
        }

        [System.CLSCompliant(false)]
        public static 
        void glStencilFunc(int func, Int32 @ref, UInt32 mask)
        {
            Delegates.glStencilFunc((int)func, (Int32)@ref, (UInt32)mask);
        }

        public static 
        void glStencilFunc(int func, Int32 @ref, Int32 mask)
        {
            Delegates.glStencilFunc((int)func, (Int32)@ref, (UInt32)mask);
        }

        public static 
        void glStencilOp(int fail, int zfail, int zpass)
        {
            Delegates.glStencilOp((int)fail, (int)zfail, (int)zpass);
        }

        public static 
        void glDepthFunc(int func)
        {
            Delegates.glDepthFunc((int)func);
        }

        public static 
        void glPixelZoom(Single xfactor, Single yfactor)
        {
            Delegates.glPixelZoom((Single)xfactor, (Single)yfactor);
        }

        public static 
        void glPixelTransferf(int pname, Single param)
        {
            Delegates.glPixelTransferf((int)pname, (Single)param);
        }

        public static 
        void glPixelTransferi(int pname, Int32 param)
        {
            Delegates.glPixelTransferi((int)pname, (Int32)param);
        }

        public static 
        void glPixelStoref(int pname, Single param)
        {
            Delegates.glPixelStoref((int)pname, (Single)param);
        }

        public static 
        void glPixelStorei(int pname, Int32 param)
        {
            Delegates.glPixelStorei((int)pname, (Int32)param);
        }

        public static 
        void glPixelMapfv(int map, Int32 mapsize, Single[] values)
        {
            unsafe
            {
                fixed (Single* values_ptr = values)
                {
                    Delegates.glPixelMapfv((int)map, (Int32)mapsize, (Single*)values_ptr);
                }
            }
        }

        public static 
        void glPixelMapfv(int map, Int32 mapsize, ref Single values)
        {
            unsafe
            {
                fixed (Single* values_ptr = &values)
                {
                    Delegates.glPixelMapfv((int)map, (Int32)mapsize, (Single*)values_ptr);
                }
            }
        }

        public static 
        void glPixelMapfv(int map, Int32 mapsize, IntPtr values)
        {
            unsafe
            {
                Delegates.glPixelMapfv((int)map, (Int32)mapsize, (Single*)values);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glPixelMapuiv(int map, Int32 mapsize, UInt32[] values)
        {
            unsafe
            {
                fixed (UInt32* values_ptr = values)
                {
                    Delegates.glPixelMapuiv((int)map, (Int32)mapsize, (UInt32*)values_ptr);
                }
            }
        }

        public static 
        void glPixelMapuiv(int map, Int32 mapsize, Int32[] values)
        {
            unsafe
            {
                fixed (Int32* values_ptr = values)
                {
                    Delegates.glPixelMapuiv((int)map, (Int32)mapsize, (UInt32*)values_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glPixelMapuiv(int map, Int32 mapsize, ref UInt32 values)
        {
            unsafe
            {
                fixed (UInt32* values_ptr = &values)
                {
                    Delegates.glPixelMapuiv((int)map, (Int32)mapsize, (UInt32*)values_ptr);
                }
            }
        }

        public static 
        void glPixelMapuiv(int map, Int32 mapsize, ref Int32 values)
        {
            unsafe
            {
                fixed (Int32* values_ptr = &values)
                {
                    Delegates.glPixelMapuiv((int)map, (Int32)mapsize, (UInt32*)values_ptr);
                }
            }
        }

        public static 
        void glPixelMapuiv(int map, Int32 mapsize, IntPtr values)
        {
            unsafe
            {
                Delegates.glPixelMapuiv((int)map, (Int32)mapsize, (UInt32*)values);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glPixelMapusv(int map, Int32 mapsize, UInt16[] values)
        {
            unsafe
            {
                fixed (UInt16* values_ptr = values)
                {
                    Delegates.glPixelMapusv((int)map, (Int32)mapsize, (UInt16*)values_ptr);
                }
            }
        }

        public static 
        void glPixelMapusv(int map, Int32 mapsize, Int16[] values)
        {
            unsafe
            {
                fixed (Int16* values_ptr = values)
                {
                    Delegates.glPixelMapusv((int)map, (Int32)mapsize, (UInt16*)values_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glPixelMapusv(int map, Int32 mapsize, ref UInt16 values)
        {
            unsafe
            {
                fixed (UInt16* values_ptr = &values)
                {
                    Delegates.glPixelMapusv((int)map, (Int32)mapsize, (UInt16*)values_ptr);
                }
            }
        }

        public static 
        void glPixelMapusv(int map, Int32 mapsize, ref Int16 values)
        {
            unsafe
            {
                fixed (Int16* values_ptr = &values)
                {
                    Delegates.glPixelMapusv((int)map, (Int32)mapsize, (UInt16*)values_ptr);
                }
            }
        }

        public static 
        void glPixelMapusv(int map, Int32 mapsize, IntPtr values)
        {
            unsafe
            {
                Delegates.glPixelMapusv((int)map, (Int32)mapsize, (UInt16*)values);
            }
        }

        public static 
        void glReadBuffer(int mode)
        {
            Delegates.glReadBuffer((int)mode);
        }

        public static 
        void glCopyPixels(Int32 x, Int32 y, Int32 width, Int32 height, int type)
        {
            Delegates.glCopyPixels((Int32)x, (Int32)y, (Int32)width, (Int32)height, (int)type);
        }

        public static 
        void glReadPixels(Int32 x, Int32 y, Int32 width, Int32 height, int format, int type, [Out] IntPtr pixels)
        {
            unsafe
            {
                Delegates.glReadPixels((Int32)x, (Int32)y, (Int32)width, (Int32)height, (int)format, (int)type, (IntPtr)pixels);
            }
        }

        public static 
        void glReadPixels(Int32 x, Int32 y, Int32 width, Int32 height, int format, int type, [In, Out] object pixels)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle pixels_ptr = System.Runtime.InteropServices.GCHandle.Alloc(pixels, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glReadPixels((Int32)x, (Int32)y, (Int32)width, (Int32)height, (int)format, (int)type, (IntPtr)pixels_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pixels_ptr.Free();
                }
            }
        }

        public static 
        void glDrawPixels(Int32 width, Int32 height, int format, int type, IntPtr pixels)
        {
            unsafe
            {
                Delegates.glDrawPixels((Int32)width, (Int32)height, (int)format, (int)type, (IntPtr)pixels);
            }
        }

        public static 
        void glDrawPixels(Int32 width, Int32 height, int format, int type, [In, Out] object pixels)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle pixels_ptr = System.Runtime.InteropServices.GCHandle.Alloc(pixels, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glDrawPixels((Int32)width, (Int32)height, (int)format, (int)type, (IntPtr)pixels_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pixels_ptr.Free();
                }
            }
        }

        public static 
        void glGetBooleanv(int pname, [Out] bool[] @params)
        {
            unsafe
            {
                fixed (bool* @params_ptr = @params)
                {
                    Delegates.glGetBooleanv((int)pname, (bool*)@params_ptr);
                }
            }
        }

        public static 
        void glGetBooleanv(int pname, [Out] out bool @params)
        {
            unsafe
            {
                fixed (bool* @params_ptr = &@params)
                {
                    Delegates.glGetBooleanv((int)pname, (bool*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetBooleanv(int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetBooleanv((int)pname, (bool*)@params);
            }
        }

        public static 
        void glGetClipPlane(int plane, [Out] Double[] equation)
        {
            unsafe
            {
                fixed (Double* equation_ptr = equation)
                {
                    Delegates.glGetClipPlane((int)plane, (Double*)equation_ptr);
                }
            }
        }

        public static 
        void glGetClipPlane(int plane, [Out] out Double equation)
        {
            unsafe
            {
                fixed (Double* equation_ptr = &equation)
                {
                    Delegates.glGetClipPlane((int)plane, (Double*)equation_ptr);
                    equation = *equation_ptr;
                }
            }
        }

        public static 
        void glGetClipPlane(int plane, [Out] IntPtr equation)
        {
            unsafe
            {
                Delegates.glGetClipPlane((int)plane, (Double*)equation);
            }
        }

        public static 
        void glGetDoublev(int pname, [Out] Double[] @params)
        {
            unsafe
            {
                fixed (Double* @params_ptr = @params)
                {
                    Delegates.glGetDoublev((int)pname, (Double*)@params_ptr);
                }
            }
        }

        public static 
        void glGetDoublev(int pname, [Out] out Double @params)
        {
            unsafe
            {
                fixed (Double* @params_ptr = &@params)
                {
                    Delegates.glGetDoublev((int)pname, (Double*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetDoublev(int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetDoublev((int)pname, (Double*)@params);
            }
        }

        public static 
        int glGetError()
        {
            return Delegates.glGetError();
        }

        public static 
        void glGetFloatv(int pname, [Out] Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glGetFloatv((int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glGetFloatv(int pname, [Out] out Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glGetFloatv((int)pname, (Single*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetFloatv(int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetFloatv((int)pname, (Single*)@params);
            }
        }

        public static 
        void glGetIntegerv(int pname, [Out] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetIntegerv((int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glGetIntegerv(int pname, [Out] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetIntegerv((int)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetIntegerv(int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetIntegerv((int)pname, (Int32*)@params);
            }
        }

        public static 
        void glGetLightfv(int light, int pname, [Out] Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glGetLightfv((int)light, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glGetLightfv(int light, int pname, [Out] out Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glGetLightfv((int)light, (int)pname, (Single*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetLightfv(int light, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetLightfv((int)light, (int)pname, (Single*)@params);
            }
        }

        public static 
        void glGetLightiv(int light, int pname, [Out] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetLightiv((int)light, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glGetLightiv(int light, int pname, [Out] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetLightiv((int)light, (int)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetLightiv(int light, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetLightiv((int)light, (int)pname, (Int32*)@params);
            }
        }

        public static 
        void glGetMapdv(int target, int query, [Out] Double[] v)
        {
            unsafe
            {
                fixed (Double* v_ptr = v)
                {
                    Delegates.glGetMapdv((int)target, (int)query, (Double*)v_ptr);
                }
            }
        }

        public static 
        void glGetMapdv(int target, int query, [Out] out Double v)
        {
            unsafe
            {
                fixed (Double* v_ptr = &v)
                {
                    Delegates.glGetMapdv((int)target, (int)query, (Double*)v_ptr);
                    v = *v_ptr;
                }
            }
        }

        public static 
        void glGetMapdv(int target, int query, [Out] IntPtr v)
        {
            unsafe
            {
                Delegates.glGetMapdv((int)target, (int)query, (Double*)v);
            }
        }

        public static 
        void glGetMapfv(int target, int query, [Out] Single[] v)
        {
            unsafe
            {
                fixed (Single* v_ptr = v)
                {
                    Delegates.glGetMapfv((int)target, (int)query, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glGetMapfv(int target, int query, [Out] out Single v)
        {
            unsafe
            {
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glGetMapfv((int)target, (int)query, (Single*)v_ptr);
                    v = *v_ptr;
                }
            }
        }

        public static 
        void glGetMapfv(int target, int query, [Out] IntPtr v)
        {
            unsafe
            {
                Delegates.glGetMapfv((int)target, (int)query, (Single*)v);
            }
        }

        public static 
        void glGetMapiv(int target, int query, [Out] Int32[] v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = v)
                {
                    Delegates.glGetMapiv((int)target, (int)query, (Int32*)v_ptr);
                }
            }
        }

        public static 
        void glGetMapiv(int target, int query, [Out] out Int32 v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = &v)
                {
                    Delegates.glGetMapiv((int)target, (int)query, (Int32*)v_ptr);
                    v = *v_ptr;
                }
            }
        }

        public static 
        void glGetMapiv(int target, int query, [Out] IntPtr v)
        {
            unsafe
            {
                Delegates.glGetMapiv((int)target, (int)query, (Int32*)v);
            }
        }

        public static 
        void glGetMaterialfv(int face, int pname, [Out] Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glGetMaterialfv((int)face, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glGetMaterialfv(int face, int pname, [Out] out Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glGetMaterialfv((int)face, (int)pname, (Single*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetMaterialfv(int face, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetMaterialfv((int)face, (int)pname, (Single*)@params);
            }
        }

        public static 
        void glGetMaterialiv(int face, int pname, [Out] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetMaterialiv((int)face, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glGetMaterialiv(int face, int pname, [Out] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetMaterialiv((int)face, (int)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetMaterialiv(int face, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetMaterialiv((int)face, (int)pname, (Int32*)@params);
            }
        }

        public static 
        void glGetPixelMapfv(int map, [Out] Single[] values)
        {
            unsafe
            {
                fixed (Single* values_ptr = values)
                {
                    Delegates.glGetPixelMapfv((int)map, (Single*)values_ptr);
                }
            }
        }

        public static 
        void glGetPixelMapfv(int map, [Out] out Single values)
        {
            unsafe
            {
                fixed (Single* values_ptr = &values)
                {
                    Delegates.glGetPixelMapfv((int)map, (Single*)values_ptr);
                    values = *values_ptr;
                }
            }
        }

        public static 
        void glGetPixelMapfv(int map, [Out] IntPtr values)
        {
            unsafe
            {
                Delegates.glGetPixelMapfv((int)map, (Single*)values);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetPixelMapuiv(int map, [Out] UInt32[] values)
        {
            unsafe
            {
                fixed (UInt32* values_ptr = values)
                {
                    Delegates.glGetPixelMapuiv((int)map, (UInt32*)values_ptr);
                }
            }
        }

        public static 
        void glGetPixelMapuiv(int map, [Out] Int32[] values)
        {
            unsafe
            {
                fixed (Int32* values_ptr = values)
                {
                    Delegates.glGetPixelMapuiv((int)map, (UInt32*)values_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetPixelMapuiv(int map, [Out] out UInt32 values)
        {
            unsafe
            {
                fixed (UInt32* values_ptr = &values)
                {
                    Delegates.glGetPixelMapuiv((int)map, (UInt32*)values_ptr);
                    values = *values_ptr;
                }
            }
        }

        public static 
        void glGetPixelMapuiv(int map, [Out] out Int32 values)
        {
            unsafe
            {
                fixed (Int32* values_ptr = &values)
                {
                    Delegates.glGetPixelMapuiv((int)map, (UInt32*)values_ptr);
                    values = *values_ptr;
                }
            }
        }

        public static 
        void glGetPixelMapuiv(int map, [Out] IntPtr values)
        {
            unsafe
            {
                Delegates.glGetPixelMapuiv((int)map, (UInt32*)values);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetPixelMapusv(int map, [Out] UInt16[] values)
        {
            unsafe
            {
                fixed (UInt16* values_ptr = values)
                {
                    Delegates.glGetPixelMapusv((int)map, (UInt16*)values_ptr);
                }
            }
        }

        public static 
        void glGetPixelMapusv(int map, [Out] Int16[] values)
        {
            unsafe
            {
                fixed (Int16* values_ptr = values)
                {
                    Delegates.glGetPixelMapusv((int)map, (UInt16*)values_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetPixelMapusv(int map, [Out] out UInt16 values)
        {
            unsafe
            {
                fixed (UInt16* values_ptr = &values)
                {
                    Delegates.glGetPixelMapusv((int)map, (UInt16*)values_ptr);
                    values = *values_ptr;
                }
            }
        }

        public static 
        void glGetPixelMapusv(int map, [Out] out Int16 values)
        {
            unsafe
            {
                fixed (Int16* values_ptr = &values)
                {
                    Delegates.glGetPixelMapusv((int)map, (UInt16*)values_ptr);
                    values = *values_ptr;
                }
            }
        }

        public static 
        void glGetPixelMapusv(int map, [Out] IntPtr values)
        {
            unsafe
            {
                Delegates.glGetPixelMapusv((int)map, (UInt16*)values);
            }
        }

        public static 
        void glGetPolygonStipple([Out] Byte[] mask)
        {
            unsafe
            {
                fixed (Byte* mask_ptr = mask)
                {
                    Delegates.glGetPolygonStipple((Byte*)mask_ptr);
                }
            }
        }

        public static 
        void glGetPolygonStipple([Out] out Byte mask)
        {
            unsafe
            {
                fixed (Byte* mask_ptr = &mask)
                {
                    Delegates.glGetPolygonStipple((Byte*)mask_ptr);
                    mask = *mask_ptr;
                }
            }
        }

        public static 
        void glGetPolygonStipple([Out] IntPtr mask)
        {
            unsafe
            {
                Delegates.glGetPolygonStipple((Byte*)mask);
            }
        }

        public static 
        string glGetString(int name)
        {
            unsafe
            {
                return System.Runtime.InteropServices.Marshal.PtrToStringAnsi(Delegates.glGetString((int)name));
            }
        }

        public static 
        void glGetTexEnvfv(int target, int pname, [Out] Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glGetTexEnvfv((int)target, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glGetTexEnvfv(int target, int pname, [Out] out Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glGetTexEnvfv((int)target, (int)pname, (Single*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetTexEnvfv(int target, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetTexEnvfv((int)target, (int)pname, (Single*)@params);
            }
        }

        public static 
        void glGetTexEnviv(int target, int pname, [Out] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetTexEnviv((int)target, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glGetTexEnviv(int target, int pname, [Out] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetTexEnviv((int)target, (int)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetTexEnviv(int target, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetTexEnviv((int)target, (int)pname, (Int32*)@params);
            }
        }

        public static 
        void glGetTexGendv(int coord, int pname, [Out] Double[] @params)
        {
            unsafe
            {
                fixed (Double* @params_ptr = @params)
                {
                    Delegates.glGetTexGendv((int)coord, (int)pname, (Double*)@params_ptr);
                }
            }
        }

        public static 
        void glGetTexGendv(int coord, int pname, [Out] out Double @params)
        {
            unsafe
            {
                fixed (Double* @params_ptr = &@params)
                {
                    Delegates.glGetTexGendv((int)coord, (int)pname, (Double*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetTexGendv(int coord, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetTexGendv((int)coord, (int)pname, (Double*)@params);
            }
        }

        public static 
        void glGetTexGenfv(int coord, int pname, [Out] Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glGetTexGenfv((int)coord, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glGetTexGenfv(int coord, int pname, [Out] out Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glGetTexGenfv((int)coord, (int)pname, (Single*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetTexGenfv(int coord, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetTexGenfv((int)coord, (int)pname, (Single*)@params);
            }
        }

        public static 
        void glGetTexGeniv(int coord, int pname, [Out] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetTexGeniv((int)coord, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glGetTexGeniv(int coord, int pname, [Out] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetTexGeniv((int)coord, (int)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetTexGeniv(int coord, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetTexGeniv((int)coord, (int)pname, (Int32*)@params);
            }
        }

        public static 
        void glGetTexImage(int target, Int32 level, int format, int type, [Out] IntPtr pixels)
        {
            unsafe
            {
                Delegates.glGetTexImage((int)target, (Int32)level, (int)format, (int)type, (IntPtr)pixels);
            }
        }

        public static 
        void glGetTexImage(int target, Int32 level, int format, int type, [In, Out] object pixels)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle pixels_ptr = System.Runtime.InteropServices.GCHandle.Alloc(pixels, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glGetTexImage((int)target, (Int32)level, (int)format, (int)type, (IntPtr)pixels_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pixels_ptr.Free();
                }
            }
        }

        public static 
        void glGetTexParameterfv(int target, int pname, [Out] Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glGetTexParameterfv((int)target, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glGetTexParameterfv(int target, int pname, [Out] out Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glGetTexParameterfv((int)target, (int)pname, (Single*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetTexParameterfv(int target, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetTexParameterfv((int)target, (int)pname, (Single*)@params);
            }
        }

        public static 
        void glGetTexParameteriv(int target, int pname, [Out] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetTexParameteriv((int)target, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glGetTexParameteriv(int target, int pname, [Out] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetTexParameteriv((int)target, (int)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetTexParameteriv(int target, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetTexParameteriv((int)target, (int)pname, (Int32*)@params);
            }
        }

        public static 
        void glGetTexLevelParameterfv(int target, Int32 level, int pname, [Out] Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glGetTexLevelParameterfv((int)target, (Int32)level, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glGetTexLevelParameterfv(int target, Int32 level, int pname, [Out] out Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glGetTexLevelParameterfv((int)target, (Int32)level, (int)pname, (Single*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetTexLevelParameterfv(int target, Int32 level, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetTexLevelParameterfv((int)target, (Int32)level, (int)pname, (Single*)@params);
            }
        }

        public static 
        void glGetTexLevelParameteriv(int target, Int32 level, int pname, [Out] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetTexLevelParameteriv((int)target, (Int32)level, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glGetTexLevelParameteriv(int target, Int32 level, int pname, [Out] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetTexLevelParameteriv((int)target, (Int32)level, (int)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetTexLevelParameteriv(int target, Int32 level, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetTexLevelParameteriv((int)target, (Int32)level, (int)pname, (Int32*)@params);
            }
        }

        public static 
        bool glIsEnabled(int cap)
        {
            return Delegates.glIsEnabled((int)cap);
        }

        [System.CLSCompliant(false)]
        public static 
        bool glIsList(UInt32 list)
        {
            return Delegates.glIsList((UInt32)list);
        }

        public static 
        bool glIsList(Int32 list)
        {
            return Delegates.glIsList((UInt32)list);
        }

        public static 
        void glDepthRange(Double near, Double far)
        {
            Delegates.glDepthRange((Double)near, (Double)far);
        }

        public static 
        void glFrustum(Double left, Double right, Double bottom, Double top, Double zNear, Double zFar)
        {
            Delegates.glFrustum((Double)left, (Double)right, (Double)bottom, (Double)top, (Double)zNear, (Double)zFar);
        }

        public static 
        void glLoadIdentity()
        {
            Delegates.glLoadIdentity();
        }

        public static 
        void glLoadMatrixf(Single[] m)
        {
            unsafe
            {
                fixed (Single* m_ptr = m)
                {
                    Delegates.glLoadMatrixf((Single*)m_ptr);
                }
            }
        }

        public static 
        void glLoadMatrixf(ref Single m)
        {
            unsafe
            {
                fixed (Single* m_ptr = &m)
                {
                    Delegates.glLoadMatrixf((Single*)m_ptr);
                }
            }
        }

        public static 
        void glLoadMatrixf(IntPtr m)
        {
            unsafe
            {
                Delegates.glLoadMatrixf((Single*)m);
            }
        }

        public static 
        void glLoadMatrixd(Double[] m)
        {
            unsafe
            {
                fixed (Double* m_ptr = m)
                {
                    Delegates.glLoadMatrixd((Double*)m_ptr);
                }
            }
        }

        public static 
        void glLoadMatrixd(ref Double m)
        {
            unsafe
            {
                fixed (Double* m_ptr = &m)
                {
                    Delegates.glLoadMatrixd((Double*)m_ptr);
                }
            }
        }

        public static 
        void glLoadMatrixd(IntPtr m)
        {
            unsafe
            {
                Delegates.glLoadMatrixd((Double*)m);
            }
        }

        public static 
        void glMatrixMode(int mode)
        {
            Delegates.glMatrixMode((int)mode);
        }

        public static 
        void glMultMatrixf(Single[] m)
        {
            unsafe
            {
                fixed (Single* m_ptr = m)
                {
                    Delegates.glMultMatrixf((Single*)m_ptr);
                }
            }
        }

        public static 
        void glMultMatrixf(ref Single m)
        {
            unsafe
            {
                fixed (Single* m_ptr = &m)
                {
                    Delegates.glMultMatrixf((Single*)m_ptr);
                }
            }
        }

        public static 
        void glMultMatrixf(IntPtr m)
        {
            unsafe
            {
                Delegates.glMultMatrixf((Single*)m);
            }
        }

        public static 
        void glMultMatrixd(Double[] m)
        {
            unsafe
            {
                fixed (Double* m_ptr = m)
                {
                    Delegates.glMultMatrixd((Double*)m_ptr);
                }
            }
        }

        public static 
        void glMultMatrixd(ref Double m)
        {
            unsafe
            {
                fixed (Double* m_ptr = &m)
                {
                    Delegates.glMultMatrixd((Double*)m_ptr);
                }
            }
        }

        public static 
        void glMultMatrixd(IntPtr m)
        {
            unsafe
            {
                Delegates.glMultMatrixd((Double*)m);
            }
        }

        public static 
        void glOrtho(Double left, Double right, Double bottom, Double top, Double zNear, Double zFar)
        {
            Delegates.glOrtho((Double)left, (Double)right, (Double)bottom, (Double)top, (Double)zNear, (Double)zFar);
        }

        public static 
        void glPopMatrix()
        {
            Delegates.glPopMatrix();
        }

        public static 
        void glPushMatrix()
        {
            Delegates.glPushMatrix();
        }

        public static 
        void glRotated(Double angle, Double x, Double y, Double z)
        {
            Delegates.glRotated((Double)angle, (Double)x, (Double)y, (Double)z);
        }

        public static 
        void glRotatef(Single angle, Single x, Single y, Single z)
        {
            Delegates.glRotatef((Single)angle, (Single)x, (Single)y, (Single)z);
        }

        public static 
        void glScaled(Double x, Double y, Double z)
        {
            Delegates.glScaled((Double)x, (Double)y, (Double)z);
        }

        public static 
        void glScalef(Single x, Single y, Single z)
        {
            Delegates.glScalef((Single)x, (Single)y, (Single)z);
        }

        public static 
        void glTranslated(Double x, Double y, Double z)
        {
            Delegates.glTranslated((Double)x, (Double)y, (Double)z);
        }

        public static 
        void glTranslatef(Single x, Single y, Single z)
        {
            Delegates.glTranslatef((Single)x, (Single)y, (Single)z);
        }

        public static 
        void glViewport(Int32 x, Int32 y, Int32 width, Int32 height)
        {
            Delegates.glViewport((Int32)x, (Int32)y, (Int32)width, (Int32)height);
        }

        public static 
        void glArrayElement(Int32 i)
        {
            Delegates.glArrayElement((Int32)i);
        }

        public static 
        void glColorPointer(Int32 size, int type, Int32 stride, IntPtr pointer)
        {
            unsafe
            {
                Delegates.glColorPointer((Int32)size, (int)type, (Int32)stride, (IntPtr)pointer);
            }
        }

        public static 
        void glColorPointer(Int32 size, int type, Int32 stride, [In, Out] object pointer)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle pointer_ptr = System.Runtime.InteropServices.GCHandle.Alloc(pointer, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glColorPointer((Int32)size, (int)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
            }
        }

        public static 
        void glDisableClientState(int array)
        {
            Delegates.glDisableClientState((int)array);
        }

        public static 
        void glDrawArrays(int mode, Int32 first, Int32 count)
        {
            Delegates.glDrawArrays((int)mode, (Int32)first, (Int32)count);
        }

        public static 
        void glDrawElements(int mode, Int32 count, int type, IntPtr indices)
        {
            unsafe
            {
                Delegates.glDrawElements((int)mode, (Int32)count, (int)type, (IntPtr)indices);
            }
        }

        public static 
        void glDrawElements(int mode, Int32 count, int type, [In, Out] object indices)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle indices_ptr = System.Runtime.InteropServices.GCHandle.Alloc(indices, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glDrawElements((int)mode, (Int32)count, (int)type, (IntPtr)indices_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    indices_ptr.Free();
                }
            }
        }

        public static 
        void glEdgeFlagPointer(Int32 stride, IntPtr pointer)
        {
            unsafe
            {
                Delegates.glEdgeFlagPointer((Int32)stride, (IntPtr)pointer);
            }
        }

        public static 
        void glEdgeFlagPointer(Int32 stride, [In, Out] object pointer)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle pointer_ptr = System.Runtime.InteropServices.GCHandle.Alloc(pointer, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glEdgeFlagPointer((Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
            }
        }

        public static 
        void glEnableClientState(int array)
        {
            Delegates.glEnableClientState((int)array);
        }

        public static 
        void glGetPointerv(int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetPointerv((int)pname, (IntPtr)@params);
            }
        }

        public static 
        void glGetPointerv(int pname, [In, Out] object @params)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle @params_ptr = System.Runtime.InteropServices.GCHandle.Alloc(@params, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glGetPointerv((int)pname, (IntPtr)@params_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    @params_ptr.Free();
                }
            }
        }

        public static 
        void glIndexPointer(int type, Int32 stride, IntPtr pointer)
        {
            unsafe
            {
                Delegates.glIndexPointer((int)type, (Int32)stride, (IntPtr)pointer);
            }
        }

        public static 
        void glIndexPointer(int type, Int32 stride, [In, Out] object pointer)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle pointer_ptr = System.Runtime.InteropServices.GCHandle.Alloc(pointer, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glIndexPointer((int)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
            }
        }

        public static 
        void glInterleavedArrays(int format, Int32 stride, IntPtr pointer)
        {
            unsafe
            {
                Delegates.glInterleavedArrays((int)format, (Int32)stride, (IntPtr)pointer);
            }
        }

        public static 
        void glInterleavedArrays(int format, Int32 stride, [In, Out] object pointer)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle pointer_ptr = System.Runtime.InteropServices.GCHandle.Alloc(pointer, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glInterleavedArrays((int)format, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
            }
        }

        public static 
        void glNormalPointer(int type, Int32 stride, IntPtr pointer)
        {
            unsafe
            {
                Delegates.glNormalPointer((int)type, (Int32)stride, (IntPtr)pointer);
            }
        }

        public static 
        void glNormalPointer(int type, Int32 stride, [In, Out] object pointer)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle pointer_ptr = System.Runtime.InteropServices.GCHandle.Alloc(pointer, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glNormalPointer((int)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
            }
        }

        public static 
        void glTexCoordPointer(Int32 size, int type, Int32 stride, IntPtr pointer)
        {
            unsafe
            {
                Delegates.glTexCoordPointer((Int32)size, (int)type, (Int32)stride, (IntPtr)pointer);
            }
        }

        public static 
        void glTexCoordPointer(Int32 size, int type, Int32 stride, [In, Out] object pointer)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle pointer_ptr = System.Runtime.InteropServices.GCHandle.Alloc(pointer, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glTexCoordPointer((Int32)size, (int)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
            }
        }

        public static 
        void glVertexPointer(Int32 size, int type, Int32 stride, IntPtr pointer)
        {
            unsafe
            {
                Delegates.glVertexPointer((Int32)size, (int)type, (Int32)stride, (IntPtr)pointer);
            }
        }

        public static 
        void glVertexPointer(Int32 size, int type, Int32 stride, [In, Out] object pointer)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle pointer_ptr = System.Runtime.InteropServices.GCHandle.Alloc(pointer, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glVertexPointer((Int32)size, (int)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
            }
        }

        public static 
        void glPolygonOffset(Single factor, Single units)
        {
            Delegates.glPolygonOffset((Single)factor, (Single)units);
        }

        public static 
        void glCopyTexImage1D(int target, Int32 level, int internalformat, Int32 x, Int32 y, Int32 width, Int32 border)
        {
            Delegates.glCopyTexImage1D((int)target, (Int32)level, (int)internalformat, (Int32)x, (Int32)y, (Int32)width, (Int32)border);
        }

        public static 
        void glCopyTexImage2D(int target, Int32 level, int internalformat, Int32 x, Int32 y, Int32 width, Int32 height, Int32 border)
        {
            Delegates.glCopyTexImage2D((int)target, (Int32)level, (int)internalformat, (Int32)x, (Int32)y, (Int32)width, (Int32)height, (Int32)border);
        }

        public static 
        void glCopyTexSubImage1D(int target, Int32 level, Int32 xoffset, Int32 x, Int32 y, Int32 width)
        {
            Delegates.glCopyTexSubImage1D((int)target, (Int32)level, (Int32)xoffset, (Int32)x, (Int32)y, (Int32)width);
        }

        public static 
        void glCopyTexSubImage2D(int target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 x, Int32 y, Int32 width, Int32 height)
        {
            Delegates.glCopyTexSubImage2D((int)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)x, (Int32)y, (Int32)width, (Int32)height);
        }

        public static 
        void glTexSubImage1D(int target, Int32 level, Int32 xoffset, Int32 width, int format, int type, IntPtr pixels)
        {
            unsafe
            {
                Delegates.glTexSubImage1D((int)target, (Int32)level, (Int32)xoffset, (Int32)width, (int)format, (int)type, (IntPtr)pixels);
            }
        }

        public static 
        void glTexSubImage1D(int target, Int32 level, Int32 xoffset, Int32 width, int format, int type, [In, Out] object pixels)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle pixels_ptr = System.Runtime.InteropServices.GCHandle.Alloc(pixels, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glTexSubImage1D((int)target, (Int32)level, (Int32)xoffset, (Int32)width, (int)format, (int)type, (IntPtr)pixels_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pixels_ptr.Free();
                }
            }
        }

        public static 
        void glTexSubImage2D(int target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 width, Int32 height, int format, int type, IntPtr pixels)
        {
            unsafe
            {
                Delegates.glTexSubImage2D((int)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)width, (Int32)height, (int)format, (int)type, (IntPtr)pixels);
            }
        }

        public static 
        void glTexSubImage2D(int target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 width, Int32 height, int format, int type, [In, Out] object pixels)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle pixels_ptr = System.Runtime.InteropServices.GCHandle.Alloc(pixels, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glTexSubImage2D((int)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)width, (Int32)height, (int)format, (int)type, (IntPtr)pixels_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pixels_ptr.Free();
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        bool glAreTexturesResident(Int32 n, UInt32[] textures, [Out] bool[] residences)
        {
            unsafe
            {
                fixed (UInt32* textures_ptr = textures)
                fixed (bool* residences_ptr = residences)
                {
                    return Delegates.glAreTexturesResident((Int32)n, (UInt32*)textures_ptr, (bool*)residences_ptr);
                }
            }
        }

        public static 
        bool glAreTexturesResident(Int32 n, Int32[] textures, [Out] bool[] residences)
        {
            unsafe
            {
                fixed (Int32* textures_ptr = textures)
                fixed (bool* residences_ptr = residences)
                {
                    return Delegates.glAreTexturesResident((Int32)n, (UInt32*)textures_ptr, (bool*)residences_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        bool glAreTexturesResident(Int32 n, ref UInt32 textures, [Out] out bool residences)
        {
            unsafe
            {
                fixed (UInt32* textures_ptr = &textures)
                fixed (bool* residences_ptr = &residences)
                {
                    bool retval = Delegates.glAreTexturesResident((Int32)n, (UInt32*)textures_ptr, (bool*)residences_ptr);
                    residences = *residences_ptr;
                    return retval;
                }
            }
        }

        public static 
        bool glAreTexturesResident(Int32 n, ref Int32 textures, [Out] out bool residences)
        {
            unsafe
            {
                fixed (Int32* textures_ptr = &textures)
                fixed (bool* residences_ptr = &residences)
                {
                    bool retval = Delegates.glAreTexturesResident((Int32)n, (UInt32*)textures_ptr, (bool*)residences_ptr);
                    residences = *residences_ptr;
                    return retval;
                }
            }
        }

        public static 
        bool glAreTexturesResident(Int32 n, IntPtr textures, [Out] IntPtr residences)
        {
            unsafe
            {
                return Delegates.glAreTexturesResident((Int32)n, (UInt32*)textures, (bool*)residences);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glBindTexture(int target, UInt32 texture)
        {
            Delegates.glBindTexture((int)target, (UInt32)texture);
        }

        public static 
        void glBindTexture(int target, Int32 texture)
        {
            Delegates.glBindTexture((int)target, (UInt32)texture);
        }

        [System.CLSCompliant(false)]
        public static 
        void glDeleteTextures(Int32 n, UInt32[] textures)
        {
            unsafe
            {
                fixed (UInt32* textures_ptr = textures)
                {
                    Delegates.glDeleteTextures((Int32)n, (UInt32*)textures_ptr);
                }
            }
        }

        public static 
        void glDeleteTextures(Int32 n, Int32[] textures)
        {
            unsafe
            {
                fixed (Int32* textures_ptr = textures)
                {
                    Delegates.glDeleteTextures((Int32)n, (UInt32*)textures_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glDeleteTextures(Int32 n, ref UInt32 textures)
        {
            unsafe
            {
                fixed (UInt32* textures_ptr = &textures)
                {
                    Delegates.glDeleteTextures((Int32)n, (UInt32*)textures_ptr);
                }
            }
        }

        public static 
        void glDeleteTextures(Int32 n, ref Int32 textures)
        {
            unsafe
            {
                fixed (Int32* textures_ptr = &textures)
                {
                    Delegates.glDeleteTextures((Int32)n, (UInt32*)textures_ptr);
                }
            }
        }

        public static 
        void glDeleteTextures(Int32 n, IntPtr textures)
        {
            unsafe
            {
                Delegates.glDeleteTextures((Int32)n, (UInt32*)textures);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGenTextures(Int32 n, [Out] UInt32[] textures)
        {
            unsafe
            {
                fixed (UInt32* textures_ptr = textures)
                {
                    Delegates.glGenTextures((Int32)n, (UInt32*)textures_ptr);
                }
            }
        }

        public static 
        void glGenTextures(Int32 n, [Out] Int32[] textures)
        {
            unsafe
            {
                fixed (Int32* textures_ptr = textures)
                {
                    Delegates.glGenTextures((Int32)n, (UInt32*)textures_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGenTextures(Int32 n, [Out] out UInt32 textures)
        {
            unsafe
            {
                fixed (UInt32* textures_ptr = &textures)
                {
                    Delegates.glGenTextures((Int32)n, (UInt32*)textures_ptr);
                    textures = *textures_ptr;
                }
            }
        }

        public static 
        void glGenTextures(Int32 n, [Out] out Int32 textures)
        {
            unsafe
            {
                fixed (Int32* textures_ptr = &textures)
                {
                    Delegates.glGenTextures((Int32)n, (UInt32*)textures_ptr);
                    textures = *textures_ptr;
                }
            }
        }

        public static 
        void glGenTextures(Int32 n, [Out] IntPtr textures)
        {
            unsafe
            {
                Delegates.glGenTextures((Int32)n, (UInt32*)textures);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        bool glIsTexture(UInt32 texture)
        {
            return Delegates.glIsTexture((UInt32)texture);
        }

        public static 
        bool glIsTexture(Int32 texture)
        {
            return Delegates.glIsTexture((UInt32)texture);
        }

        [System.CLSCompliant(false)]
        public static 
        void glPrioritizeTextures(Int32 n, UInt32[] textures, Single[] priorities)
        {
            unsafe
            {
                fixed (UInt32* textures_ptr = textures)
                fixed (Single* priorities_ptr = priorities)
                {
                    Delegates.glPrioritizeTextures((Int32)n, (UInt32*)textures_ptr, (Single*)priorities_ptr);
                }
            }
        }

        public static 
        void glPrioritizeTextures(Int32 n, Int32[] textures, Single[] priorities)
        {
            unsafe
            {
                fixed (Int32* textures_ptr = textures)
                fixed (Single* priorities_ptr = priorities)
                {
                    Delegates.glPrioritizeTextures((Int32)n, (UInt32*)textures_ptr, (Single*)priorities_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glPrioritizeTextures(Int32 n, ref UInt32 textures, ref Single priorities)
        {
            unsafe
            {
                fixed (UInt32* textures_ptr = &textures)
                fixed (Single* priorities_ptr = &priorities)
                {
                    Delegates.glPrioritizeTextures((Int32)n, (UInt32*)textures_ptr, (Single*)priorities_ptr);
                }
            }
        }

        public static 
        void glPrioritizeTextures(Int32 n, ref Int32 textures, ref Single priorities)
        {
            unsafe
            {
                fixed (Int32* textures_ptr = &textures)
                fixed (Single* priorities_ptr = &priorities)
                {
                    Delegates.glPrioritizeTextures((Int32)n, (UInt32*)textures_ptr, (Single*)priorities_ptr);
                }
            }
        }

        public static 
        void glPrioritizeTextures(Int32 n, IntPtr textures, IntPtr priorities)
        {
            unsafe
            {
                Delegates.glPrioritizeTextures((Int32)n, (UInt32*)textures, (Single*)priorities);
            }
        }

        public static 
        void glIndexub(Byte c)
        {
            Delegates.glIndexub((Byte)c);
        }

        public static 
        void glIndexubv(Byte[] c)
        {
            unsafe
            {
                fixed (Byte* c_ptr = c)
                {
                    Delegates.glIndexubv((Byte*)c_ptr);
                }
            }
        }

        public static 
        void glIndexubv(ref Byte c)
        {
            unsafe
            {
                fixed (Byte* c_ptr = &c)
                {
                    Delegates.glIndexubv((Byte*)c_ptr);
                }
            }
        }

        public static 
        void glIndexubv(IntPtr c)
        {
            unsafe
            {
                Delegates.glIndexubv((Byte*)c);
            }
        }

        public static 
        void glPopClientAttrib()
        {
            Delegates.glPopClientAttrib();
        }

        public static 
        void glPushClientAttrib(int mask)
        {
            Delegates.glPushClientAttrib((int)mask);
        }

        public static 
        void glBlendColor(Single red, Single green, Single blue, Single alpha)
        {
            Delegates.glBlendColor((Single)red, (Single)green, (Single)blue, (Single)alpha);
        }

        public static 
        void glBlendEquation(int mode)
        {
            Delegates.glBlendEquation((int)mode);
        }

        [System.CLSCompliant(false)]
        public static 
        void glDrawRangeElements(int mode, UInt32 start, UInt32 end, Int32 count, int type, IntPtr indices)
        {
            unsafe
            {
                Delegates.glDrawRangeElements((int)mode, (UInt32)start, (UInt32)end, (Int32)count, (int)type, (IntPtr)indices);
            }
        }

        public static 
        void glDrawRangeElements(int mode, Int32 start, Int32 end, Int32 count, int type, IntPtr indices)
        {
            unsafe
            {
                Delegates.glDrawRangeElements((int)mode, (UInt32)start, (UInt32)end, (Int32)count, (int)type, (IntPtr)indices);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glDrawRangeElements(int mode, UInt32 start, UInt32 end, Int32 count, int type, [In, Out] object indices)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle indices_ptr = System.Runtime.InteropServices.GCHandle.Alloc(indices, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glDrawRangeElements((int)mode, (UInt32)start, (UInt32)end, (Int32)count, (int)type, (IntPtr)indices_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    indices_ptr.Free();
                }
            }
        }

        public static 
        void glDrawRangeElements(int mode, Int32 start, Int32 end, Int32 count, int type, [In, Out] object indices)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle indices_ptr = System.Runtime.InteropServices.GCHandle.Alloc(indices, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glDrawRangeElements((int)mode, (UInt32)start, (UInt32)end, (Int32)count, (int)type, (IntPtr)indices_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    indices_ptr.Free();
                }
            }
        }

        public static 
        void glColorTable(int target, int internalformat, Int32 width, int format, int type, IntPtr table)
        {
            unsafe
            {
                Delegates.glColorTable((int)target, (int)internalformat, (Int32)width, (int)format, (int)type, (IntPtr)table);
            }
        }

        public static 
        void glColorTable(int target, int internalformat, Int32 width, int format, int type, [In, Out] object table)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle table_ptr = System.Runtime.InteropServices.GCHandle.Alloc(table, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glColorTable((int)target, (int)internalformat, (Int32)width, (int)format, (int)type, (IntPtr)table_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    table_ptr.Free();
                }
            }
        }

        public static 
        void glColorTableParameterfv(int target, int pname, Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glColorTableParameterfv((int)target, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glColorTableParameterfv(int target, int pname, ref Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glColorTableParameterfv((int)target, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glColorTableParameterfv(int target, int pname, IntPtr @params)
        {
            unsafe
            {
                Delegates.glColorTableParameterfv((int)target, (int)pname, (Single*)@params);
            }
        }

        public static 
        void glColorTableParameteriv(int target, int pname, Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glColorTableParameteriv((int)target, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glColorTableParameteriv(int target, int pname, ref Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glColorTableParameteriv((int)target, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glColorTableParameteriv(int target, int pname, IntPtr @params)
        {
            unsafe
            {
                Delegates.glColorTableParameteriv((int)target, (int)pname, (Int32*)@params);
            }
        }

        public static 
        void glCopyColorTable(int target, int internalformat, Int32 x, Int32 y, Int32 width)
        {
            Delegates.glCopyColorTable((int)target, (int)internalformat, (Int32)x, (Int32)y, (Int32)width);
        }

        public static 
        void glGetColorTable(int target, int format, int type, [Out] IntPtr table)
        {
            unsafe
            {
                Delegates.glGetColorTable((int)target, (int)format, (int)type, (IntPtr)table);
            }
        }

        public static 
        void glGetColorTable(int target, int format, int type, [In, Out] object table)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle table_ptr = System.Runtime.InteropServices.GCHandle.Alloc(table, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glGetColorTable((int)target, (int)format, (int)type, (IntPtr)table_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    table_ptr.Free();
                }
            }
        }

        public static 
        void glGetColorTableParameterfv(int target, int pname, [Out] Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glGetColorTableParameterfv((int)target, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glGetColorTableParameterfv(int target, int pname, [Out] out Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glGetColorTableParameterfv((int)target, (int)pname, (Single*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetColorTableParameterfv(int target, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetColorTableParameterfv((int)target, (int)pname, (Single*)@params);
            }
        }

        public static 
        void glGetColorTableParameteriv(int target, int pname, [Out] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetColorTableParameteriv((int)target, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glGetColorTableParameteriv(int target, int pname, [Out] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetColorTableParameteriv((int)target, (int)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetColorTableParameteriv(int target, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetColorTableParameteriv((int)target, (int)pname, (Int32*)@params);
            }
        }

        public static 
        void glColorSubTable(int target, Int32 start, Int32 count, int format, int type, IntPtr data)
        {
            unsafe
            {
                Delegates.glColorSubTable((int)target, (Int32)start, (Int32)count, (int)format, (int)type, (IntPtr)data);
            }
        }

        public static 
        void glColorSubTable(int target, Int32 start, Int32 count, int format, int type, [In, Out] object data)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle data_ptr = System.Runtime.InteropServices.GCHandle.Alloc(data, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glColorSubTable((int)target, (Int32)start, (Int32)count, (int)format, (int)type, (IntPtr)data_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    data_ptr.Free();
                }
            }
        }

        public static 
        void glCopyColorSubTable(int target, Int32 start, Int32 x, Int32 y, Int32 width)
        {
            Delegates.glCopyColorSubTable((int)target, (Int32)start, (Int32)x, (Int32)y, (Int32)width);
        }

        public static 
        void glConvolutionFilter1D(int target, int internalformat, Int32 width, int format, int type, IntPtr image)
        {
            unsafe
            {
                Delegates.glConvolutionFilter1D((int)target, (int)internalformat, (Int32)width, (int)format, (int)type, (IntPtr)image);
            }
        }

        public static 
        void glConvolutionFilter1D(int target, int internalformat, Int32 width, int format, int type, [In, Out] object image)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle image_ptr = System.Runtime.InteropServices.GCHandle.Alloc(image, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glConvolutionFilter1D((int)target, (int)internalformat, (Int32)width, (int)format, (int)type, (IntPtr)image_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    image_ptr.Free();
                }
            }
        }

        public static 
        void glConvolutionFilter2D(int target, int internalformat, Int32 width, Int32 height, int format, int type, IntPtr image)
        {
            unsafe
            {
                Delegates.glConvolutionFilter2D((int)target, (int)internalformat, (Int32)width, (Int32)height, (int)format, (int)type, (IntPtr)image);
            }
        }

        public static 
        void glConvolutionFilter2D(int target, int internalformat, Int32 width, Int32 height, int format, int type, [In, Out] object image)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle image_ptr = System.Runtime.InteropServices.GCHandle.Alloc(image, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glConvolutionFilter2D((int)target, (int)internalformat, (Int32)width, (Int32)height, (int)format, (int)type, (IntPtr)image_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    image_ptr.Free();
                }
            }
        }

        public static 
        void glConvolutionParameterf(int target, int pname, Single @params)
        {
            Delegates.glConvolutionParameterf((int)target, (int)pname, (Single)@params);
        }

        public static 
        void glConvolutionParameterfv(int target, int pname, Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glConvolutionParameterfv((int)target, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glConvolutionParameterfv(int target, int pname, ref Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glConvolutionParameterfv((int)target, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glConvolutionParameterfv(int target, int pname, IntPtr @params)
        {
            unsafe
            {
                Delegates.glConvolutionParameterfv((int)target, (int)pname, (Single*)@params);
            }
        }

        public static 
        void glConvolutionParameteri(int target, int pname, Int32 @params)
        {
            Delegates.glConvolutionParameteri((int)target, (int)pname, (Int32)@params);
        }

        public static 
        void glConvolutionParameteriv(int target, int pname, Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glConvolutionParameteriv((int)target, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glConvolutionParameteriv(int target, int pname, ref Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glConvolutionParameteriv((int)target, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glConvolutionParameteriv(int target, int pname, IntPtr @params)
        {
            unsafe
            {
                Delegates.glConvolutionParameteriv((int)target, (int)pname, (Int32*)@params);
            }
        }

        public static 
        void glCopyConvolutionFilter1D(int target, int internalformat, Int32 x, Int32 y, Int32 width)
        {
            Delegates.glCopyConvolutionFilter1D((int)target, (int)internalformat, (Int32)x, (Int32)y, (Int32)width);
        }

        public static 
        void glCopyConvolutionFilter2D(int target, int internalformat, Int32 x, Int32 y, Int32 width, Int32 height)
        {
            Delegates.glCopyConvolutionFilter2D((int)target, (int)internalformat, (Int32)x, (Int32)y, (Int32)width, (Int32)height);
        }

        public static 
        void glGetConvolutionFilter(int target, int format, int type, [Out] IntPtr image)
        {
            unsafe
            {
                Delegates.glGetConvolutionFilter((int)target, (int)format, (int)type, (IntPtr)image);
            }
        }

        public static 
        void glGetConvolutionFilter(int target, int format, int type, [In, Out] object image)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle image_ptr = System.Runtime.InteropServices.GCHandle.Alloc(image, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glGetConvolutionFilter((int)target, (int)format, (int)type, (IntPtr)image_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    image_ptr.Free();
                }
            }
        }

        public static 
        void glGetConvolutionParameterfv(int target, int pname, [Out] Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glGetConvolutionParameterfv((int)target, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glGetConvolutionParameterfv(int target, int pname, [Out] out Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glGetConvolutionParameterfv((int)target, (int)pname, (Single*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetConvolutionParameterfv(int target, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetConvolutionParameterfv((int)target, (int)pname, (Single*)@params);
            }
        }

        public static 
        void glGetConvolutionParameteriv(int target, int pname, [Out] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetConvolutionParameteriv((int)target, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glGetConvolutionParameteriv(int target, int pname, [Out] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetConvolutionParameteriv((int)target, (int)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetConvolutionParameteriv(int target, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetConvolutionParameteriv((int)target, (int)pname, (Int32*)@params);
            }
        }

        public static 
        void glGetSeparableFilter(int target, int format, int type, [Out] IntPtr row, [Out] IntPtr column, [Out] IntPtr span)
        {
            unsafe
            {
                Delegates.glGetSeparableFilter((int)target, (int)format, (int)type, (IntPtr)row, (IntPtr)column, (IntPtr)span);
            }
        }

        public static 
        void glGetSeparableFilter(int target, int format, int type, [In, Out] object row, [In, Out] object column, [In, Out] object span)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle row_ptr = System.Runtime.InteropServices.GCHandle.Alloc(row, System.Runtime.InteropServices.GCHandleType.Pinned);
                System.Runtime.InteropServices.GCHandle column_ptr = System.Runtime.InteropServices.GCHandle.Alloc(column, System.Runtime.InteropServices.GCHandleType.Pinned);
                System.Runtime.InteropServices.GCHandle span_ptr = System.Runtime.InteropServices.GCHandle.Alloc(span, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glGetSeparableFilter((int)target, (int)format, (int)type, (IntPtr)row_ptr.AddrOfPinnedObject(), (IntPtr)column_ptr.AddrOfPinnedObject(), (IntPtr)span_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    row_ptr.Free();
                    column_ptr.Free();
                    span_ptr.Free();
                }
            }
        }

        public static 
        void glGetSeparableFilter(int target, int format, int type, [Out] IntPtr row, [In, Out] object column, [In, Out] object span)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle column_ptr = System.Runtime.InteropServices.GCHandle.Alloc(column, System.Runtime.InteropServices.GCHandleType.Pinned);
                System.Runtime.InteropServices.GCHandle span_ptr = System.Runtime.InteropServices.GCHandle.Alloc(span, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glGetSeparableFilter((int)target, (int)format, (int)type, (IntPtr)row, (IntPtr)column_ptr.AddrOfPinnedObject(), (IntPtr)span_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    column_ptr.Free();
                    span_ptr.Free();
                }
            }
        }

        public static 
        void glSeparableFilter2D(int target, int internalformat, Int32 width, Int32 height, int format, int type, IntPtr row, IntPtr column)
        {
            unsafe
            {
                Delegates.glSeparableFilter2D((int)target, (int)internalformat, (Int32)width, (Int32)height, (int)format, (int)type, (IntPtr)row, (IntPtr)column);
            }
        }

        public static 
        void glSeparableFilter2D(int target, int internalformat, Int32 width, Int32 height, int format, int type, [In, Out] object row, [In, Out] object column)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle row_ptr = System.Runtime.InteropServices.GCHandle.Alloc(row, System.Runtime.InteropServices.GCHandleType.Pinned);
                System.Runtime.InteropServices.GCHandle column_ptr = System.Runtime.InteropServices.GCHandle.Alloc(column, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glSeparableFilter2D((int)target, (int)internalformat, (Int32)width, (Int32)height, (int)format, (int)type, (IntPtr)row_ptr.AddrOfPinnedObject(), (IntPtr)column_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    row_ptr.Free();
                    column_ptr.Free();
                }
            }
        }

        public static 
        void glGetHistogram(int target, bool reset, int format, int type, [Out] IntPtr values)
        {
            unsafe
            {
                Delegates.glGetHistogram((int)target, (bool)reset, (int)format, (int)type, (IntPtr)values);
            }
        }

        public static 
        void glGetHistogram(int target, bool reset, int format, int type, [In, Out] object values)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle values_ptr = System.Runtime.InteropServices.GCHandle.Alloc(values, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glGetHistogram((int)target, (bool)reset, (int)format, (int)type, (IntPtr)values_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    values_ptr.Free();
                }
            }
        }

        public static 
        void glGetHistogramParameterfv(int target, int pname, [Out] Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glGetHistogramParameterfv((int)target, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glGetHistogramParameterfv(int target, int pname, [Out] out Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glGetHistogramParameterfv((int)target, (int)pname, (Single*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetHistogramParameterfv(int target, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetHistogramParameterfv((int)target, (int)pname, (Single*)@params);
            }
        }

        public static 
        void glGetHistogramParameteriv(int target, int pname, [Out] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetHistogramParameteriv((int)target, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glGetHistogramParameteriv(int target, int pname, [Out] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetHistogramParameteriv((int)target, (int)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetHistogramParameteriv(int target, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetHistogramParameteriv((int)target, (int)pname, (Int32*)@params);
            }
        }

        public static 
        void glGetMinmax(int target, bool reset, int format, int type, [Out] IntPtr values)
        {
            unsafe
            {
                Delegates.glGetMinmax((int)target, (bool)reset, (int)format, (int)type, (IntPtr)values);
            }
        }

        public static 
        void glGetMinmax(int target, bool reset, int format, int type, [In, Out] object values)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle values_ptr = System.Runtime.InteropServices.GCHandle.Alloc(values, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glGetMinmax((int)target, (bool)reset, (int)format, (int)type, (IntPtr)values_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    values_ptr.Free();
                }
            }
        }

        public static 
        void glGetMinmaxParameterfv(int target, int pname, [Out] Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glGetMinmaxParameterfv((int)target, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glGetMinmaxParameterfv(int target, int pname, [Out] out Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glGetMinmaxParameterfv((int)target, (int)pname, (Single*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetMinmaxParameterfv(int target, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetMinmaxParameterfv((int)target, (int)pname, (Single*)@params);
            }
        }

        public static 
        void glGetMinmaxParameteriv(int target, int pname, [Out] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetMinmaxParameteriv((int)target, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glGetMinmaxParameteriv(int target, int pname, [Out] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetMinmaxParameteriv((int)target, (int)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetMinmaxParameteriv(int target, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetMinmaxParameteriv((int)target, (int)pname, (Int32*)@params);
            }
        }

        public static 
        void glHistogram(int target, Int32 width, int internalformat, bool sink)
        {
            Delegates.glHistogram((int)target, (Int32)width, (int)internalformat, (bool)sink);
        }

        public static 
        void glMinmax(int target, int internalformat, bool sink)
        {
            Delegates.glMinmax((int)target, (int)internalformat, (bool)sink);
        }

        public static 
        void glResetHistogram(int target)
        {
            Delegates.glResetHistogram((int)target);
        }

        public static 
        void glResetMinmax(int target)
        {
            Delegates.glResetMinmax((int)target);
        }

        public static 
        void glTexImage3D(int target, Int32 level, Int32 internalformat, Int32 width, Int32 height, Int32 depth, Int32 border, int format, int type, IntPtr pixels)
        {
            unsafe
            {
                Delegates.glTexImage3D((int)target, (Int32)level, (Int32)internalformat, (Int32)width, (Int32)height, (Int32)depth, (Int32)border, (int)format, (int)type, (IntPtr)pixels);
            }
        }

        public static 
        void glTexImage3D(int target, Int32 level, Int32 internalformat, Int32 width, Int32 height, Int32 depth, Int32 border, int format, int type, [In, Out] object pixels)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle pixels_ptr = System.Runtime.InteropServices.GCHandle.Alloc(pixels, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glTexImage3D((int)target, (Int32)level, (Int32)internalformat, (Int32)width, (Int32)height, (Int32)depth, (Int32)border, (int)format, (int)type, (IntPtr)pixels_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pixels_ptr.Free();
                }
            }
        }

        public static 
        void glTexSubImage3D(int target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 zoffset, Int32 width, Int32 height, Int32 depth, int format, int type, IntPtr pixels)
        {
            unsafe
            {
                Delegates.glTexSubImage3D((int)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)zoffset, (Int32)width, (Int32)height, (Int32)depth, (int)format, (int)type, (IntPtr)pixels);
            }
        }

        public static 
        void glTexSubImage3D(int target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 zoffset, Int32 width, Int32 height, Int32 depth, int format, int type, [In, Out] object pixels)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle pixels_ptr = System.Runtime.InteropServices.GCHandle.Alloc(pixels, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glTexSubImage3D((int)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)zoffset, (Int32)width, (Int32)height, (Int32)depth, (int)format, (int)type, (IntPtr)pixels_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pixels_ptr.Free();
                }
            }
        }

        public static 
        void glCopyTexSubImage3D(int target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 zoffset, Int32 x, Int32 y, Int32 width, Int32 height)
        {
            Delegates.glCopyTexSubImage3D((int)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)zoffset, (Int32)x, (Int32)y, (Int32)width, (Int32)height);
        }

        public static 
        void glActiveTexture(int texture)
        {
            Delegates.glActiveTexture((int)texture);
        }

        public static 
        void glClientActiveTexture(int texture)
        {
            Delegates.glClientActiveTexture((int)texture);
        }

        public static 
        void glMultiTexCoord1d(int target, Double s)
        {
            Delegates.glMultiTexCoord1d((int)target, (Double)s);
        }

        public static 
        void glMultiTexCoord1dv(int target, Double[] v)
        {
            unsafe
            {
                fixed (Double* v_ptr = v)
                {
                    Delegates.glMultiTexCoord1dv((int)target, (Double*)v_ptr);
                }
            }
        }

        public static 
        void glMultiTexCoord1dv(int target, ref Double v)
        {
            unsafe
            {
                fixed (Double* v_ptr = &v)
                {
                    Delegates.glMultiTexCoord1dv((int)target, (Double*)v_ptr);
                }
            }
        }

        public static 
        void glMultiTexCoord1dv(int target, IntPtr v)
        {
            unsafe
            {
                Delegates.glMultiTexCoord1dv((int)target, (Double*)v);
            }
        }

        public static 
        void glMultiTexCoord1f(int target, Single s)
        {
            Delegates.glMultiTexCoord1f((int)target, (Single)s);
        }

        public static 
        void glMultiTexCoord1fv(int target, Single[] v)
        {
            unsafe
            {
                fixed (Single* v_ptr = v)
                {
                    Delegates.glMultiTexCoord1fv((int)target, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glMultiTexCoord1fv(int target, ref Single v)
        {
            unsafe
            {
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glMultiTexCoord1fv((int)target, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glMultiTexCoord1fv(int target, IntPtr v)
        {
            unsafe
            {
                Delegates.glMultiTexCoord1fv((int)target, (Single*)v);
            }
        }

        public static 
        void glMultiTexCoord1i(int target, Int32 s)
        {
            Delegates.glMultiTexCoord1i((int)target, (Int32)s);
        }

        public static 
        void glMultiTexCoord1iv(int target, Int32[] v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = v)
                {
                    Delegates.glMultiTexCoord1iv((int)target, (Int32*)v_ptr);
                }
            }
        }

        public static 
        void glMultiTexCoord1iv(int target, ref Int32 v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = &v)
                {
                    Delegates.glMultiTexCoord1iv((int)target, (Int32*)v_ptr);
                }
            }
        }

        public static 
        void glMultiTexCoord1iv(int target, IntPtr v)
        {
            unsafe
            {
                Delegates.glMultiTexCoord1iv((int)target, (Int32*)v);
            }
        }

        public static 
        void glMultiTexCoord1s(int target, Int16 s)
        {
            Delegates.glMultiTexCoord1s((int)target, (Int16)s);
        }

        public static 
        void glMultiTexCoord1sv(int target, Int16[] v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = v)
                {
                    Delegates.glMultiTexCoord1sv((int)target, (Int16*)v_ptr);
                }
            }
        }

        public static 
        void glMultiTexCoord1sv(int target, ref Int16 v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = &v)
                {
                    Delegates.glMultiTexCoord1sv((int)target, (Int16*)v_ptr);
                }
            }
        }

        public static 
        void glMultiTexCoord1sv(int target, IntPtr v)
        {
            unsafe
            {
                Delegates.glMultiTexCoord1sv((int)target, (Int16*)v);
            }
        }

        public static 
        void glMultiTexCoord2d(int target, Double s, Double t)
        {
            Delegates.glMultiTexCoord2d((int)target, (Double)s, (Double)t);
        }

        public static 
        void glMultiTexCoord2dv(int target, Double[] v)
        {
            unsafe
            {
                fixed (Double* v_ptr = v)
                {
                    Delegates.glMultiTexCoord2dv((int)target, (Double*)v_ptr);
                }
            }
        }

        public static 
        void glMultiTexCoord2dv(int target, ref Double v)
        {
            unsafe
            {
                fixed (Double* v_ptr = &v)
                {
                    Delegates.glMultiTexCoord2dv((int)target, (Double*)v_ptr);
                }
            }
        }

        public static 
        void glMultiTexCoord2dv(int target, IntPtr v)
        {
            unsafe
            {
                Delegates.glMultiTexCoord2dv((int)target, (Double*)v);
            }
        }

        public static 
        void glMultiTexCoord2f(int target, Single s, Single t)
        {
            Delegates.glMultiTexCoord2f((int)target, (Single)s, (Single)t);
        }

        public static 
        void glMultiTexCoord2fv(int target, Single[] v)
        {
            unsafe
            {
                fixed (Single* v_ptr = v)
                {
                    Delegates.glMultiTexCoord2fv((int)target, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glMultiTexCoord2fv(int target, ref Single v)
        {
            unsafe
            {
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glMultiTexCoord2fv((int)target, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glMultiTexCoord2fv(int target, IntPtr v)
        {
            unsafe
            {
                Delegates.glMultiTexCoord2fv((int)target, (Single*)v);
            }
        }

        public static 
        void glMultiTexCoord2i(int target, Int32 s, Int32 t)
        {
            Delegates.glMultiTexCoord2i((int)target, (Int32)s, (Int32)t);
        }

        public static 
        void glMultiTexCoord2iv(int target, Int32[] v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = v)
                {
                    Delegates.glMultiTexCoord2iv((int)target, (Int32*)v_ptr);
                }
            }
        }

        public static 
        void glMultiTexCoord2iv(int target, ref Int32 v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = &v)
                {
                    Delegates.glMultiTexCoord2iv((int)target, (Int32*)v_ptr);
                }
            }
        }

        public static 
        void glMultiTexCoord2iv(int target, IntPtr v)
        {
            unsafe
            {
                Delegates.glMultiTexCoord2iv((int)target, (Int32*)v);
            }
        }

        public static 
        void glMultiTexCoord2s(int target, Int16 s, Int16 t)
        {
            Delegates.glMultiTexCoord2s((int)target, (Int16)s, (Int16)t);
        }

        public static 
        void glMultiTexCoord2sv(int target, Int16[] v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = v)
                {
                    Delegates.glMultiTexCoord2sv((int)target, (Int16*)v_ptr);
                }
            }
        }

        public static 
        void glMultiTexCoord2sv(int target, ref Int16 v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = &v)
                {
                    Delegates.glMultiTexCoord2sv((int)target, (Int16*)v_ptr);
                }
            }
        }

        public static 
        void glMultiTexCoord2sv(int target, IntPtr v)
        {
            unsafe
            {
                Delegates.glMultiTexCoord2sv((int)target, (Int16*)v);
            }
        }

        public static 
        void glMultiTexCoord3d(int target, Double s, Double t, Double r)
        {
            Delegates.glMultiTexCoord3d((int)target, (Double)s, (Double)t, (Double)r);
        }

        public static 
        void glMultiTexCoord3dv(int target, Double[] v)
        {
            unsafe
            {
                fixed (Double* v_ptr = v)
                {
                    Delegates.glMultiTexCoord3dv((int)target, (Double*)v_ptr);
                }
            }
        }

        public static 
        void glMultiTexCoord3dv(int target, ref Double v)
        {
            unsafe
            {
                fixed (Double* v_ptr = &v)
                {
                    Delegates.glMultiTexCoord3dv((int)target, (Double*)v_ptr);
                }
            }
        }

        public static 
        void glMultiTexCoord3dv(int target, IntPtr v)
        {
            unsafe
            {
                Delegates.glMultiTexCoord3dv((int)target, (Double*)v);
            }
        }

        public static 
        void glMultiTexCoord3f(int target, Single s, Single t, Single r)
        {
            Delegates.glMultiTexCoord3f((int)target, (Single)s, (Single)t, (Single)r);
        }

        public static 
        void glMultiTexCoord3fv(int target, Single[] v)
        {
            unsafe
            {
                fixed (Single* v_ptr = v)
                {
                    Delegates.glMultiTexCoord3fv((int)target, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glMultiTexCoord3fv(int target, ref Single v)
        {
            unsafe
            {
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glMultiTexCoord3fv((int)target, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glMultiTexCoord3fv(int target, IntPtr v)
        {
            unsafe
            {
                Delegates.glMultiTexCoord3fv((int)target, (Single*)v);
            }
        }

        public static 
        void glMultiTexCoord3i(int target, Int32 s, Int32 t, Int32 r)
        {
            Delegates.glMultiTexCoord3i((int)target, (Int32)s, (Int32)t, (Int32)r);
        }

        public static 
        void glMultiTexCoord3iv(int target, Int32[] v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = v)
                {
                    Delegates.glMultiTexCoord3iv((int)target, (Int32*)v_ptr);
                }
            }
        }

        public static 
        void glMultiTexCoord3iv(int target, ref Int32 v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = &v)
                {
                    Delegates.glMultiTexCoord3iv((int)target, (Int32*)v_ptr);
                }
            }
        }

        public static 
        void glMultiTexCoord3iv(int target, IntPtr v)
        {
            unsafe
            {
                Delegates.glMultiTexCoord3iv((int)target, (Int32*)v);
            }
        }

        public static 
        void glMultiTexCoord3s(int target, Int16 s, Int16 t, Int16 r)
        {
            Delegates.glMultiTexCoord3s((int)target, (Int16)s, (Int16)t, (Int16)r);
        }

        public static 
        void glMultiTexCoord3sv(int target, Int16[] v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = v)
                {
                    Delegates.glMultiTexCoord3sv((int)target, (Int16*)v_ptr);
                }
            }
        }

        public static 
        void glMultiTexCoord3sv(int target, ref Int16 v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = &v)
                {
                    Delegates.glMultiTexCoord3sv((int)target, (Int16*)v_ptr);
                }
            }
        }

        public static 
        void glMultiTexCoord3sv(int target, IntPtr v)
        {
            unsafe
            {
                Delegates.glMultiTexCoord3sv((int)target, (Int16*)v);
            }
        }

        public static 
        void glMultiTexCoord4d(int target, Double s, Double t, Double r, Double q)
        {
            Delegates.glMultiTexCoord4d((int)target, (Double)s, (Double)t, (Double)r, (Double)q);
        }

        public static 
        void glMultiTexCoord4dv(int target, Double[] v)
        {
            unsafe
            {
                fixed (Double* v_ptr = v)
                {
                    Delegates.glMultiTexCoord4dv((int)target, (Double*)v_ptr);
                }
            }
        }

        public static 
        void glMultiTexCoord4dv(int target, ref Double v)
        {
            unsafe
            {
                fixed (Double* v_ptr = &v)
                {
                    Delegates.glMultiTexCoord4dv((int)target, (Double*)v_ptr);
                }
            }
        }

        public static 
        void glMultiTexCoord4dv(int target, IntPtr v)
        {
            unsafe
            {
                Delegates.glMultiTexCoord4dv((int)target, (Double*)v);
            }
        }

        public static 
        void glMultiTexCoord4f(int target, Single s, Single t, Single r, Single q)
        {
            Delegates.glMultiTexCoord4f((int)target, (Single)s, (Single)t, (Single)r, (Single)q);
        }

        public static 
        void glMultiTexCoord4fv(int target, Single[] v)
        {
            unsafe
            {
                fixed (Single* v_ptr = v)
                {
                    Delegates.glMultiTexCoord4fv((int)target, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glMultiTexCoord4fv(int target, ref Single v)
        {
            unsafe
            {
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glMultiTexCoord4fv((int)target, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glMultiTexCoord4fv(int target, IntPtr v)
        {
            unsafe
            {
                Delegates.glMultiTexCoord4fv((int)target, (Single*)v);
            }
        }

        public static 
        void glMultiTexCoord4i(int target, Int32 s, Int32 t, Int32 r, Int32 q)
        {
            Delegates.glMultiTexCoord4i((int)target, (Int32)s, (Int32)t, (Int32)r, (Int32)q);
        }

        public static 
        void glMultiTexCoord4iv(int target, Int32[] v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = v)
                {
                    Delegates.glMultiTexCoord4iv((int)target, (Int32*)v_ptr);
                }
            }
        }

        public static 
        void glMultiTexCoord4iv(int target, ref Int32 v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = &v)
                {
                    Delegates.glMultiTexCoord4iv((int)target, (Int32*)v_ptr);
                }
            }
        }

        public static 
        void glMultiTexCoord4iv(int target, IntPtr v)
        {
            unsafe
            {
                Delegates.glMultiTexCoord4iv((int)target, (Int32*)v);
            }
        }

        public static 
        void glMultiTexCoord4s(int target, Int16 s, Int16 t, Int16 r, Int16 q)
        {
            Delegates.glMultiTexCoord4s((int)target, (Int16)s, (Int16)t, (Int16)r, (Int16)q);
        }

        public static 
        void glMultiTexCoord4sv(int target, Int16[] v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = v)
                {
                    Delegates.glMultiTexCoord4sv((int)target, (Int16*)v_ptr);
                }
            }
        }

        public static 
        void glMultiTexCoord4sv(int target, ref Int16 v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = &v)
                {
                    Delegates.glMultiTexCoord4sv((int)target, (Int16*)v_ptr);
                }
            }
        }

        public static 
        void glMultiTexCoord4sv(int target, IntPtr v)
        {
            unsafe
            {
                Delegates.glMultiTexCoord4sv((int)target, (Int16*)v);
            }
        }

        public static 
        void glLoadTransposeMatrixf(Single[] m)
        {
            unsafe
            {
                fixed (Single* m_ptr = m)
                {
                    Delegates.glLoadTransposeMatrixf((Single*)m_ptr);
                }
            }
        }

        public static 
        void glLoadTransposeMatrixf(ref Single m)
        {
            unsafe
            {
                fixed (Single* m_ptr = &m)
                {
                    Delegates.glLoadTransposeMatrixf((Single*)m_ptr);
                }
            }
        }

        public static 
        void glLoadTransposeMatrixf(IntPtr m)
        {
            unsafe
            {
                Delegates.glLoadTransposeMatrixf((Single*)m);
            }
        }

        public static 
        void glLoadTransposeMatrixd(Double[] m)
        {
            unsafe
            {
                fixed (Double* m_ptr = m)
                {
                    Delegates.glLoadTransposeMatrixd((Double*)m_ptr);
                }
            }
        }

        public static 
        void glLoadTransposeMatrixd(ref Double m)
        {
            unsafe
            {
                fixed (Double* m_ptr = &m)
                {
                    Delegates.glLoadTransposeMatrixd((Double*)m_ptr);
                }
            }
        }

        public static 
        void glLoadTransposeMatrixd(IntPtr m)
        {
            unsafe
            {
                Delegates.glLoadTransposeMatrixd((Double*)m);
            }
        }

        public static 
        void glMultTransposeMatrixf(Single[] m)
        {
            unsafe
            {
                fixed (Single* m_ptr = m)
                {
                    Delegates.glMultTransposeMatrixf((Single*)m_ptr);
                }
            }
        }

        public static 
        void glMultTransposeMatrixf(ref Single m)
        {
            unsafe
            {
                fixed (Single* m_ptr = &m)
                {
                    Delegates.glMultTransposeMatrixf((Single*)m_ptr);
                }
            }
        }

        public static 
        void glMultTransposeMatrixf(IntPtr m)
        {
            unsafe
            {
                Delegates.glMultTransposeMatrixf((Single*)m);
            }
        }

        public static 
        void glMultTransposeMatrixd(Double[] m)
        {
            unsafe
            {
                fixed (Double* m_ptr = m)
                {
                    Delegates.glMultTransposeMatrixd((Double*)m_ptr);
                }
            }
        }

        public static 
        void glMultTransposeMatrixd(ref Double m)
        {
            unsafe
            {
                fixed (Double* m_ptr = &m)
                {
                    Delegates.glMultTransposeMatrixd((Double*)m_ptr);
                }
            }
        }

        public static 
        void glMultTransposeMatrixd(IntPtr m)
        {
            unsafe
            {
                Delegates.glMultTransposeMatrixd((Double*)m);
            }
        }

        public static 
        void glSampleCoverage(Single value, bool invert)
        {
            Delegates.glSampleCoverage((Single)value, (bool)invert);
        }

        public static 
        void glCompressedTexImage3D(int target, Int32 level, int internalformat, Int32 width, Int32 height, Int32 depth, Int32 border, Int32 imageSize, IntPtr data)
        {
            unsafe
            {
                Delegates.glCompressedTexImage3D((int)target, (Int32)level, (int)internalformat, (Int32)width, (Int32)height, (Int32)depth, (Int32)border, (Int32)imageSize, (IntPtr)data);
            }
        }

        public static 
        void glCompressedTexImage3D(int target, Int32 level, int internalformat, Int32 width, Int32 height, Int32 depth, Int32 border, Int32 imageSize, [In, Out] object data)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle data_ptr = System.Runtime.InteropServices.GCHandle.Alloc(data, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glCompressedTexImage3D((int)target, (Int32)level, (int)internalformat, (Int32)width, (Int32)height, (Int32)depth, (Int32)border, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    data_ptr.Free();
                }
            }
        }

        public static 
        void glCompressedTexImage2D(int target, Int32 level, int internalformat, Int32 width, Int32 height, Int32 border, Int32 imageSize, IntPtr data)
        {
            unsafe
            {
                Delegates.glCompressedTexImage2D((int)target, (Int32)level, (int)internalformat, (Int32)width, (Int32)height, (Int32)border, (Int32)imageSize, (IntPtr)data);
            }
        }

        public static 
        void glCompressedTexImage2D(int target, Int32 level, int internalformat, Int32 width, Int32 height, Int32 border, Int32 imageSize, [In, Out] object data)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle data_ptr = System.Runtime.InteropServices.GCHandle.Alloc(data, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glCompressedTexImage2D((int)target, (Int32)level, (int)internalformat, (Int32)width, (Int32)height, (Int32)border, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    data_ptr.Free();
                }
            }
        }

        public static 
        void glCompressedTexImage1D(int target, Int32 level, int internalformat, Int32 width, Int32 border, Int32 imageSize, IntPtr data)
        {
            unsafe
            {
                Delegates.glCompressedTexImage1D((int)target, (Int32)level, (int)internalformat, (Int32)width, (Int32)border, (Int32)imageSize, (IntPtr)data);
            }
        }

        public static 
        void glCompressedTexImage1D(int target, Int32 level, int internalformat, Int32 width, Int32 border, Int32 imageSize, [In, Out] object data)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle data_ptr = System.Runtime.InteropServices.GCHandle.Alloc(data, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glCompressedTexImage1D((int)target, (Int32)level, (int)internalformat, (Int32)width, (Int32)border, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    data_ptr.Free();
                }
            }
        }

        public static 
        void glCompressedTexSubImage3D(int target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 zoffset, Int32 width, Int32 height, Int32 depth, int format, Int32 imageSize, IntPtr data)
        {
            unsafe
            {
                Delegates.glCompressedTexSubImage3D((int)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)zoffset, (Int32)width, (Int32)height, (Int32)depth, (int)format, (Int32)imageSize, (IntPtr)data);
            }
        }

        public static 
        void glCompressedTexSubImage3D(int target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 zoffset, Int32 width, Int32 height, Int32 depth, int format, Int32 imageSize, [In, Out] object data)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle data_ptr = System.Runtime.InteropServices.GCHandle.Alloc(data, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glCompressedTexSubImage3D((int)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)zoffset, (Int32)width, (Int32)height, (Int32)depth, (int)format, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    data_ptr.Free();
                }
            }
        }

        public static 
        void glCompressedTexSubImage2D(int target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 width, Int32 height, int format, Int32 imageSize, IntPtr data)
        {
            unsafe
            {
                Delegates.glCompressedTexSubImage2D((int)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)width, (Int32)height, (int)format, (Int32)imageSize, (IntPtr)data);
            }
        }

        public static 
        void glCompressedTexSubImage2D(int target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 width, Int32 height, int format, Int32 imageSize, [In, Out] object data)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle data_ptr = System.Runtime.InteropServices.GCHandle.Alloc(data, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glCompressedTexSubImage2D((int)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)width, (Int32)height, (int)format, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    data_ptr.Free();
                }
            }
        }

        public static 
        void glCompressedTexSubImage1D(int target, Int32 level, Int32 xoffset, Int32 width, int format, Int32 imageSize, IntPtr data)
        {
            unsafe
            {
                Delegates.glCompressedTexSubImage1D((int)target, (Int32)level, (Int32)xoffset, (Int32)width, (int)format, (Int32)imageSize, (IntPtr)data);
            }
        }

        public static 
        void glCompressedTexSubImage1D(int target, Int32 level, Int32 xoffset, Int32 width, int format, Int32 imageSize, [In, Out] object data)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle data_ptr = System.Runtime.InteropServices.GCHandle.Alloc(data, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glCompressedTexSubImage1D((int)target, (Int32)level, (Int32)xoffset, (Int32)width, (int)format, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    data_ptr.Free();
                }
            }
        }

        public static 
        void glGetCompressedTexImage(int target, Int32 level, [Out] IntPtr img)
        {
            unsafe
            {
                Delegates.glGetCompressedTexImage((int)target, (Int32)level, (IntPtr)img);
            }
        }

        public static 
        void glGetCompressedTexImage(int target, Int32 level, [In, Out] object img)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle img_ptr = System.Runtime.InteropServices.GCHandle.Alloc(img, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glGetCompressedTexImage((int)target, (Int32)level, (IntPtr)img_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    img_ptr.Free();
                }
            }
        }

        public static 
        void glBlendFuncSeparate(int sfactorRGB, int dfactorRGB, int sfactorAlpha, int dfactorAlpha)
        {
            Delegates.glBlendFuncSeparate((int)sfactorRGB, (int)dfactorRGB, (int)sfactorAlpha, (int)dfactorAlpha);
        }

        public static 
        void glFogCoordf(Single coord)
        {
            Delegates.glFogCoordf((Single)coord);
        }

        public static 
        void glFogCoordfv(Single[] coord)
        {
            unsafe
            {
                fixed (Single* coord_ptr = coord)
                {
                    Delegates.glFogCoordfv((Single*)coord_ptr);
                }
            }
        }

        public static 
        void glFogCoordfv(ref Single coord)
        {
            unsafe
            {
                fixed (Single* coord_ptr = &coord)
                {
                    Delegates.glFogCoordfv((Single*)coord_ptr);
                }
            }
        }

        public static 
        void glFogCoordfv(IntPtr coord)
        {
            unsafe
            {
                Delegates.glFogCoordfv((Single*)coord);
            }
        }

        public static 
        void glFogCoordd(Double coord)
        {
            Delegates.glFogCoordd((Double)coord);
        }

        public static 
        void glFogCoorddv(Double[] coord)
        {
            unsafe
            {
                fixed (Double* coord_ptr = coord)
                {
                    Delegates.glFogCoorddv((Double*)coord_ptr);
                }
            }
        }

        public static 
        void glFogCoorddv(ref Double coord)
        {
            unsafe
            {
                fixed (Double* coord_ptr = &coord)
                {
                    Delegates.glFogCoorddv((Double*)coord_ptr);
                }
            }
        }

        public static 
        void glFogCoorddv(IntPtr coord)
        {
            unsafe
            {
                Delegates.glFogCoorddv((Double*)coord);
            }
        }

        public static 
        void glFogCoordPointer(int type, Int32 stride, IntPtr pointer)
        {
            unsafe
            {
                Delegates.glFogCoordPointer((int)type, (Int32)stride, (IntPtr)pointer);
            }
        }

        public static 
        void glFogCoordPointer(int type, Int32 stride, [In, Out] object pointer)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle pointer_ptr = System.Runtime.InteropServices.GCHandle.Alloc(pointer, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glFogCoordPointer((int)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
            }
        }

        public static 
        void glMultiDrawArrays(int mode, [Out] Int32[] first, [Out] Int32[] count, Int32 primcount)
        {
            unsafe
            {
                fixed (Int32* first_ptr = first)
                fixed (Int32* count_ptr = count)
                {
                    Delegates.glMultiDrawArrays((int)mode, (Int32*)first_ptr, (Int32*)count_ptr, (Int32)primcount);
                }
            }
        }

        public static 
        void glMultiDrawArrays(int mode, [Out] out Int32 first, [Out] out Int32 count, Int32 primcount)
        {
            unsafe
            {
                fixed (Int32* first_ptr = &first)
                fixed (Int32* count_ptr = &count)
                {
                    Delegates.glMultiDrawArrays((int)mode, (Int32*)first_ptr, (Int32*)count_ptr, (Int32)primcount);
                    first = *first_ptr;
                    count = *count_ptr;
                }
            }
        }

        public static 
        void glMultiDrawArrays(int mode, [Out] IntPtr first, [Out] IntPtr count, Int32 primcount)
        {
            unsafe
            {
                Delegates.glMultiDrawArrays((int)mode, (Int32*)first, (Int32*)count, (Int32)primcount);
            }
        }

        public static 
        void glMultiDrawElements(int mode, Int32[] count, int type, IntPtr indices, Int32 primcount)
        {
            unsafe
            {
                fixed (Int32* count_ptr = count)
                {
                    Delegates.glMultiDrawElements((int)mode, (Int32*)count_ptr, (int)type, (IntPtr)indices, (Int32)primcount);
                }
            }
        }

        public static 
        void glMultiDrawElements(int mode, IntPtr count, int type, [In, Out] object indices, Int32 primcount)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle indices_ptr = System.Runtime.InteropServices.GCHandle.Alloc(indices, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glMultiDrawElements((int)mode, (Int32*)count, (int)type, (IntPtr)indices_ptr.AddrOfPinnedObject(), (Int32)primcount);
                }
                finally
                {
                    indices_ptr.Free();
                }
            }
        }

        public static 
        void glMultiDrawElements(int mode, ref Int32 count, int type, [In, Out] object indices, Int32 primcount)
        {
            unsafe
            {
                fixed (Int32* count_ptr = &count)
                {
                    System.Runtime.InteropServices.GCHandle indices_ptr = System.Runtime.InteropServices.GCHandle.Alloc(indices, System.Runtime.InteropServices.GCHandleType.Pinned);
                    try
                    {
                        Delegates.glMultiDrawElements((int)mode, (Int32*)count_ptr, (int)type, (IntPtr)indices_ptr.AddrOfPinnedObject(), (Int32)primcount);
                    }
                    finally
                    {
                        indices_ptr.Free();
                    }
                }
            }
        }

        public static 
        void glPointParameterf(int pname, Single param)
        {
            Delegates.glPointParameterf((int)pname, (Single)param);
        }

        public static 
        void glPointParameterfv(int pname, Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glPointParameterfv((int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glPointParameterfv(int pname, ref Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glPointParameterfv((int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glPointParameterfv(int pname, IntPtr @params)
        {
            unsafe
            {
                Delegates.glPointParameterfv((int)pname, (Single*)@params);
            }
        }

        public static 
        void glPointParameteri(int pname, Int32 param)
        {
            Delegates.glPointParameteri((int)pname, (Int32)param);
        }

        public static 
        void glPointParameteriv(int pname, Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glPointParameteriv((int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glPointParameteriv(int pname, ref Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glPointParameteriv((int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glPointParameteriv(int pname, IntPtr @params)
        {
            unsafe
            {
                Delegates.glPointParameteriv((int)pname, (Int32*)@params);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glSecondaryColor3b(SByte red, SByte green, SByte blue)
        {
            Delegates.glSecondaryColor3b((SByte)red, (SByte)green, (SByte)blue);
        }

        public static 
        void glSecondaryColor3b(Byte red, Byte green, Byte blue)
        {
            Delegates.glSecondaryColor3b((SByte)red, (SByte)green, (SByte)blue);
        }

        [System.CLSCompliant(false)]
        public static 
        void glSecondaryColor3bv(SByte[] v)
        {
            unsafe
            {
                fixed (SByte* v_ptr = v)
                {
                    Delegates.glSecondaryColor3bv((SByte*)v_ptr);
                }
            }
        }

        public static 
        void glSecondaryColor3bv(Byte[] v)
        {
            unsafe
            {
                fixed (Byte* v_ptr = v)
                {
                    Delegates.glSecondaryColor3bv((SByte*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glSecondaryColor3bv(ref SByte v)
        {
            unsafe
            {
                fixed (SByte* v_ptr = &v)
                {
                    Delegates.glSecondaryColor3bv((SByte*)v_ptr);
                }
            }
        }

        public static 
        void glSecondaryColor3bv(ref Byte v)
        {
            unsafe
            {
                fixed (Byte* v_ptr = &v)
                {
                    Delegates.glSecondaryColor3bv((SByte*)v_ptr);
                }
            }
        }

        public static 
        void glSecondaryColor3bv(IntPtr v)
        {
            unsafe
            {
                Delegates.glSecondaryColor3bv((SByte*)v);
            }
        }

        public static 
        void glSecondaryColor3d(Double red, Double green, Double blue)
        {
            Delegates.glSecondaryColor3d((Double)red, (Double)green, (Double)blue);
        }

        public static 
        void glSecondaryColor3dv(Double[] v)
        {
            unsafe
            {
                fixed (Double* v_ptr = v)
                {
                    Delegates.glSecondaryColor3dv((Double*)v_ptr);
                }
            }
        }

        public static 
        void glSecondaryColor3dv(ref Double v)
        {
            unsafe
            {
                fixed (Double* v_ptr = &v)
                {
                    Delegates.glSecondaryColor3dv((Double*)v_ptr);
                }
            }
        }

        public static 
        void glSecondaryColor3dv(IntPtr v)
        {
            unsafe
            {
                Delegates.glSecondaryColor3dv((Double*)v);
            }
        }

        public static 
        void glSecondaryColor3f(Single red, Single green, Single blue)
        {
            Delegates.glSecondaryColor3f((Single)red, (Single)green, (Single)blue);
        }

        public static 
        void glSecondaryColor3fv(Single[] v)
        {
            unsafe
            {
                fixed (Single* v_ptr = v)
                {
                    Delegates.glSecondaryColor3fv((Single*)v_ptr);
                }
            }
        }

        public static 
        void glSecondaryColor3fv(ref Single v)
        {
            unsafe
            {
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glSecondaryColor3fv((Single*)v_ptr);
                }
            }
        }

        public static 
        void glSecondaryColor3fv(IntPtr v)
        {
            unsafe
            {
                Delegates.glSecondaryColor3fv((Single*)v);
            }
        }

        public static 
        void glSecondaryColor3i(Int32 red, Int32 green, Int32 blue)
        {
            Delegates.glSecondaryColor3i((Int32)red, (Int32)green, (Int32)blue);
        }

        public static 
        void glSecondaryColor3iv(Int32[] v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = v)
                {
                    Delegates.glSecondaryColor3iv((Int32*)v_ptr);
                }
            }
        }

        public static 
        void glSecondaryColor3iv(ref Int32 v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = &v)
                {
                    Delegates.glSecondaryColor3iv((Int32*)v_ptr);
                }
            }
        }

        public static 
        void glSecondaryColor3iv(IntPtr v)
        {
            unsafe
            {
                Delegates.glSecondaryColor3iv((Int32*)v);
            }
        }

        public static 
        void glSecondaryColor3s(Int16 red, Int16 green, Int16 blue)
        {
            Delegates.glSecondaryColor3s((Int16)red, (Int16)green, (Int16)blue);
        }

        public static 
        void glSecondaryColor3sv(Int16[] v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = v)
                {
                    Delegates.glSecondaryColor3sv((Int16*)v_ptr);
                }
            }
        }

        public static 
        void glSecondaryColor3sv(ref Int16 v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = &v)
                {
                    Delegates.glSecondaryColor3sv((Int16*)v_ptr);
                }
            }
        }

        public static 
        void glSecondaryColor3sv(IntPtr v)
        {
            unsafe
            {
                Delegates.glSecondaryColor3sv((Int16*)v);
            }
        }

        public static 
        void glSecondaryColor3ub(Byte red, Byte green, Byte blue)
        {
            Delegates.glSecondaryColor3ub((Byte)red, (Byte)green, (Byte)blue);
        }

        public static 
        void glSecondaryColor3ubv(Byte[] v)
        {
            unsafe
            {
                fixed (Byte* v_ptr = v)
                {
                    Delegates.glSecondaryColor3ubv((Byte*)v_ptr);
                }
            }
        }

        public static 
        void glSecondaryColor3ubv(ref Byte v)
        {
            unsafe
            {
                fixed (Byte* v_ptr = &v)
                {
                    Delegates.glSecondaryColor3ubv((Byte*)v_ptr);
                }
            }
        }

        public static 
        void glSecondaryColor3ubv(IntPtr v)
        {
            unsafe
            {
                Delegates.glSecondaryColor3ubv((Byte*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glSecondaryColor3ui(UInt32 red, UInt32 green, UInt32 blue)
        {
            Delegates.glSecondaryColor3ui((UInt32)red, (UInt32)green, (UInt32)blue);
        }

        public static 
        void glSecondaryColor3ui(Int32 red, Int32 green, Int32 blue)
        {
            Delegates.glSecondaryColor3ui((UInt32)red, (UInt32)green, (UInt32)blue);
        }

        [System.CLSCompliant(false)]
        public static 
        void glSecondaryColor3uiv(UInt32[] v)
        {
            unsafe
            {
                fixed (UInt32* v_ptr = v)
                {
                    Delegates.glSecondaryColor3uiv((UInt32*)v_ptr);
                }
            }
        }

        public static 
        void glSecondaryColor3uiv(Int32[] v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = v)
                {
                    Delegates.glSecondaryColor3uiv((UInt32*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glSecondaryColor3uiv(ref UInt32 v)
        {
            unsafe
            {
                fixed (UInt32* v_ptr = &v)
                {
                    Delegates.glSecondaryColor3uiv((UInt32*)v_ptr);
                }
            }
        }

        public static 
        void glSecondaryColor3uiv(ref Int32 v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = &v)
                {
                    Delegates.glSecondaryColor3uiv((UInt32*)v_ptr);
                }
            }
        }

        public static 
        void glSecondaryColor3uiv(IntPtr v)
        {
            unsafe
            {
                Delegates.glSecondaryColor3uiv((UInt32*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glSecondaryColor3us(UInt16 red, UInt16 green, UInt16 blue)
        {
            Delegates.glSecondaryColor3us((UInt16)red, (UInt16)green, (UInt16)blue);
        }

        public static 
        void glSecondaryColor3us(Int16 red, Int16 green, Int16 blue)
        {
            Delegates.glSecondaryColor3us((UInt16)red, (UInt16)green, (UInt16)blue);
        }

        [System.CLSCompliant(false)]
        public static 
        void glSecondaryColor3usv(UInt16[] v)
        {
            unsafe
            {
                fixed (UInt16* v_ptr = v)
                {
                    Delegates.glSecondaryColor3usv((UInt16*)v_ptr);
                }
            }
        }

        public static 
        void glSecondaryColor3usv(Int16[] v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = v)
                {
                    Delegates.glSecondaryColor3usv((UInt16*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glSecondaryColor3usv(ref UInt16 v)
        {
            unsafe
            {
                fixed (UInt16* v_ptr = &v)
                {
                    Delegates.glSecondaryColor3usv((UInt16*)v_ptr);
                }
            }
        }

        public static 
        void glSecondaryColor3usv(ref Int16 v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = &v)
                {
                    Delegates.glSecondaryColor3usv((UInt16*)v_ptr);
                }
            }
        }

        public static 
        void glSecondaryColor3usv(IntPtr v)
        {
            unsafe
            {
                Delegates.glSecondaryColor3usv((UInt16*)v);
            }
        }

        public static 
        void glSecondaryColorPointer(Int32 size, int type, Int32 stride, IntPtr pointer)
        {
            unsafe
            {
                Delegates.glSecondaryColorPointer((Int32)size, (int)type, (Int32)stride, (IntPtr)pointer);
            }
        }

        public static 
        void glSecondaryColorPointer(Int32 size, int type, Int32 stride, [In, Out] object pointer)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle pointer_ptr = System.Runtime.InteropServices.GCHandle.Alloc(pointer, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glSecondaryColorPointer((Int32)size, (int)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
            }
        }

        public static 
        void glWindowPos2d(Double x, Double y)
        {
            Delegates.glWindowPos2d((Double)x, (Double)y);
        }

        public static 
        void glWindowPos2dv(Double[] v)
        {
            unsafe
            {
                fixed (Double* v_ptr = v)
                {
                    Delegates.glWindowPos2dv((Double*)v_ptr);
                }
            }
        }

        public static 
        void glWindowPos2dv(ref Double v)
        {
            unsafe
            {
                fixed (Double* v_ptr = &v)
                {
                    Delegates.glWindowPos2dv((Double*)v_ptr);
                }
            }
        }

        public static 
        void glWindowPos2dv(IntPtr v)
        {
            unsafe
            {
                Delegates.glWindowPos2dv((Double*)v);
            }
        }

        public static 
        void glWindowPos2f(Single x, Single y)
        {
            Delegates.glWindowPos2f((Single)x, (Single)y);
        }

        public static 
        void glWindowPos2fv(Single[] v)
        {
            unsafe
            {
                fixed (Single* v_ptr = v)
                {
                    Delegates.glWindowPos2fv((Single*)v_ptr);
                }
            }
        }

        public static 
        void glWindowPos2fv(ref Single v)
        {
            unsafe
            {
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glWindowPos2fv((Single*)v_ptr);
                }
            }
        }

        public static 
        void glWindowPos2fv(IntPtr v)
        {
            unsafe
            {
                Delegates.glWindowPos2fv((Single*)v);
            }
        }

        public static 
        void glWindowPos2i(Int32 x, Int32 y)
        {
            Delegates.glWindowPos2i((Int32)x, (Int32)y);
        }

        public static 
        void glWindowPos2iv(Int32[] v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = v)
                {
                    Delegates.glWindowPos2iv((Int32*)v_ptr);
                }
            }
        }

        public static 
        void glWindowPos2iv(ref Int32 v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = &v)
                {
                    Delegates.glWindowPos2iv((Int32*)v_ptr);
                }
            }
        }

        public static 
        void glWindowPos2iv(IntPtr v)
        {
            unsafe
            {
                Delegates.glWindowPos2iv((Int32*)v);
            }
        }

        public static 
        void glWindowPos2s(Int16 x, Int16 y)
        {
            Delegates.glWindowPos2s((Int16)x, (Int16)y);
        }

        public static 
        void glWindowPos2sv(Int16[] v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = v)
                {
                    Delegates.glWindowPos2sv((Int16*)v_ptr);
                }
            }
        }

        public static 
        void glWindowPos2sv(ref Int16 v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = &v)
                {
                    Delegates.glWindowPos2sv((Int16*)v_ptr);
                }
            }
        }

        public static 
        void glWindowPos2sv(IntPtr v)
        {
            unsafe
            {
                Delegates.glWindowPos2sv((Int16*)v);
            }
        }

        public static 
        void glWindowPos3d(Double x, Double y, Double z)
        {
            Delegates.glWindowPos3d((Double)x, (Double)y, (Double)z);
        }

        public static 
        void glWindowPos3dv(Double[] v)
        {
            unsafe
            {
                fixed (Double* v_ptr = v)
                {
                    Delegates.glWindowPos3dv((Double*)v_ptr);
                }
            }
        }

        public static 
        void glWindowPos3dv(ref Double v)
        {
            unsafe
            {
                fixed (Double* v_ptr = &v)
                {
                    Delegates.glWindowPos3dv((Double*)v_ptr);
                }
            }
        }

        public static 
        void glWindowPos3dv(IntPtr v)
        {
            unsafe
            {
                Delegates.glWindowPos3dv((Double*)v);
            }
        }

        public static 
        void glWindowPos3f(Single x, Single y, Single z)
        {
            Delegates.glWindowPos3f((Single)x, (Single)y, (Single)z);
        }

        public static 
        void glWindowPos3fv(Single[] v)
        {
            unsafe
            {
                fixed (Single* v_ptr = v)
                {
                    Delegates.glWindowPos3fv((Single*)v_ptr);
                }
            }
        }

        public static 
        void glWindowPos3fv(ref Single v)
        {
            unsafe
            {
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glWindowPos3fv((Single*)v_ptr);
                }
            }
        }

        public static 
        void glWindowPos3fv(IntPtr v)
        {
            unsafe
            {
                Delegates.glWindowPos3fv((Single*)v);
            }
        }

        public static 
        void glWindowPos3i(Int32 x, Int32 y, Int32 z)
        {
            Delegates.glWindowPos3i((Int32)x, (Int32)y, (Int32)z);
        }

        public static 
        void glWindowPos3iv(Int32[] v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = v)
                {
                    Delegates.glWindowPos3iv((Int32*)v_ptr);
                }
            }
        }

        public static 
        void glWindowPos3iv(ref Int32 v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = &v)
                {
                    Delegates.glWindowPos3iv((Int32*)v_ptr);
                }
            }
        }

        public static 
        void glWindowPos3iv(IntPtr v)
        {
            unsafe
            {
                Delegates.glWindowPos3iv((Int32*)v);
            }
        }

        public static 
        void glWindowPos3s(Int16 x, Int16 y, Int16 z)
        {
            Delegates.glWindowPos3s((Int16)x, (Int16)y, (Int16)z);
        }

        public static 
        void glWindowPos3sv(Int16[] v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = v)
                {
                    Delegates.glWindowPos3sv((Int16*)v_ptr);
                }
            }
        }

        public static 
        void glWindowPos3sv(ref Int16 v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = &v)
                {
                    Delegates.glWindowPos3sv((Int16*)v_ptr);
                }
            }
        }

        public static 
        void glWindowPos3sv(IntPtr v)
        {
            unsafe
            {
                Delegates.glWindowPos3sv((Int16*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGenQueries(Int32 n, [Out] UInt32[] ids)
        {
            unsafe
            {
                fixed (UInt32* ids_ptr = ids)
                {
                    Delegates.glGenQueries((Int32)n, (UInt32*)ids_ptr);
                }
            }
        }

        public static 
        void glGenQueries(Int32 n, [Out] Int32[] ids)
        {
            unsafe
            {
                fixed (Int32* ids_ptr = ids)
                {
                    Delegates.glGenQueries((Int32)n, (UInt32*)ids_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGenQueries(Int32 n, [Out] out UInt32 ids)
        {
            unsafe
            {
                fixed (UInt32* ids_ptr = &ids)
                {
                    Delegates.glGenQueries((Int32)n, (UInt32*)ids_ptr);
                    ids = *ids_ptr;
                }
            }
        }

        public static 
        void glGenQueries(Int32 n, [Out] out Int32 ids)
        {
            unsafe
            {
                fixed (Int32* ids_ptr = &ids)
                {
                    Delegates.glGenQueries((Int32)n, (UInt32*)ids_ptr);
                    ids = *ids_ptr;
                }
            }
        }

        public static 
        void glGenQueries(Int32 n, [Out] IntPtr ids)
        {
            unsafe
            {
                Delegates.glGenQueries((Int32)n, (UInt32*)ids);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glDeleteQueries(Int32 n, UInt32[] ids)
        {
            unsafe
            {
                fixed (UInt32* ids_ptr = ids)
                {
                    Delegates.glDeleteQueries((Int32)n, (UInt32*)ids_ptr);
                }
            }
        }

        public static 
        void glDeleteQueries(Int32 n, Int32[] ids)
        {
            unsafe
            {
                fixed (Int32* ids_ptr = ids)
                {
                    Delegates.glDeleteQueries((Int32)n, (UInt32*)ids_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glDeleteQueries(Int32 n, ref UInt32 ids)
        {
            unsafe
            {
                fixed (UInt32* ids_ptr = &ids)
                {
                    Delegates.glDeleteQueries((Int32)n, (UInt32*)ids_ptr);
                }
            }
        }

        public static 
        void glDeleteQueries(Int32 n, ref Int32 ids)
        {
            unsafe
            {
                fixed (Int32* ids_ptr = &ids)
                {
                    Delegates.glDeleteQueries((Int32)n, (UInt32*)ids_ptr);
                }
            }
        }

        public static 
        void glDeleteQueries(Int32 n, IntPtr ids)
        {
            unsafe
            {
                Delegates.glDeleteQueries((Int32)n, (UInt32*)ids);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        bool glIsQuery(UInt32 id)
        {
            return Delegates.glIsQuery((UInt32)id);
        }

        public static 
        bool glIsQuery(Int32 id)
        {
            return Delegates.glIsQuery((UInt32)id);
        }

        [System.CLSCompliant(false)]
        public static 
        void glBeginQuery(int target, UInt32 id)
        {
            Delegates.glBeginQuery((int)target, (UInt32)id);
        }

        public static 
        void glBeginQuery(int target, Int32 id)
        {
            Delegates.glBeginQuery((int)target, (UInt32)id);
        }

        public static 
        void glEndQuery(int target)
        {
            Delegates.glEndQuery((int)target);
        }

        public static 
        void glGetQueryiv(int target, int pname, [Out] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetQueryiv((int)target, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glGetQueryiv(int target, int pname, [Out] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetQueryiv((int)target, (int)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetQueryiv(int target, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetQueryiv((int)target, (int)pname, (Int32*)@params);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetQueryObjectiv(UInt32 id, int pname, [Out] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetQueryObjectiv((UInt32)id, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glGetQueryObjectiv(Int32 id, int pname, [Out] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetQueryObjectiv((UInt32)id, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetQueryObjectiv(UInt32 id, int pname, [Out] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetQueryObjectiv((UInt32)id, (int)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetQueryObjectiv(Int32 id, int pname, [Out] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetQueryObjectiv((UInt32)id, (int)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetQueryObjectiv(UInt32 id, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetQueryObjectiv((UInt32)id, (int)pname, (Int32*)@params);
            }
        }

        public static 
        void glGetQueryObjectiv(Int32 id, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetQueryObjectiv((UInt32)id, (int)pname, (Int32*)@params);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetQueryObjectuiv(UInt32 id, int pname, [Out] UInt32[] @params)
        {
            unsafe
            {
                fixed (UInt32* @params_ptr = @params)
                {
                    Delegates.glGetQueryObjectuiv((UInt32)id, (int)pname, (UInt32*)@params_ptr);
                }
            }
        }

        public static 
        void glGetQueryObjectuiv(Int32 id, int pname, [Out] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetQueryObjectuiv((UInt32)id, (int)pname, (UInt32*)@params_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetQueryObjectuiv(UInt32 id, int pname, [Out] out UInt32 @params)
        {
            unsafe
            {
                fixed (UInt32* @params_ptr = &@params)
                {
                    Delegates.glGetQueryObjectuiv((UInt32)id, (int)pname, (UInt32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetQueryObjectuiv(Int32 id, int pname, [Out] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetQueryObjectuiv((UInt32)id, (int)pname, (UInt32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetQueryObjectuiv(UInt32 id, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetQueryObjectuiv((UInt32)id, (int)pname, (UInt32*)@params);
            }
        }

        public static 
        void glGetQueryObjectuiv(Int32 id, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetQueryObjectuiv((UInt32)id, (int)pname, (UInt32*)@params);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glBindBuffer(int target, UInt32 buffer)
        {
            Delegates.glBindBuffer((int)target, (UInt32)buffer);
        }

        public static 
        void glBindBuffer(int target, Int32 buffer)
        {
            Delegates.glBindBuffer((int)target, (UInt32)buffer);
        }

        [System.CLSCompliant(false)]
        public static 
        void glDeleteBuffers(Int32 n, UInt32[] buffers)
        {
            unsafe
            {
                fixed (UInt32* buffers_ptr = buffers)
                {
                    Delegates.glDeleteBuffers((Int32)n, (UInt32*)buffers_ptr);
                }
            }
        }

        public static 
        void glDeleteBuffers(Int32 n, Int32[] buffers)
        {
            unsafe
            {
                fixed (Int32* buffers_ptr = buffers)
                {
                    Delegates.glDeleteBuffers((Int32)n, (UInt32*)buffers_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glDeleteBuffers(Int32 n, ref UInt32 buffers)
        {
            unsafe
            {
                fixed (UInt32* buffers_ptr = &buffers)
                {
                    Delegates.glDeleteBuffers((Int32)n, (UInt32*)buffers_ptr);
                }
            }
        }

        public static 
        void glDeleteBuffers(Int32 n, ref Int32 buffers)
        {
            unsafe
            {
                fixed (Int32* buffers_ptr = &buffers)
                {
                    Delegates.glDeleteBuffers((Int32)n, (UInt32*)buffers_ptr);
                }
            }
        }

        public static 
        void glDeleteBuffers(Int32 n, IntPtr buffers)
        {
            unsafe
            {
                Delegates.glDeleteBuffers((Int32)n, (UInt32*)buffers);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGenBuffers(Int32 n, [Out] UInt32[] buffers)
        {
            unsafe
            {
                fixed (UInt32* buffers_ptr = buffers)
                {
                    Delegates.glGenBuffers((Int32)n, (UInt32*)buffers_ptr);
                }
            }
        }

        public static 
        void glGenBuffers(Int32 n, [Out] Int32[] buffers)
        {
            unsafe
            {
                fixed (Int32* buffers_ptr = buffers)
                {
                    Delegates.glGenBuffers((Int32)n, (UInt32*)buffers_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGenBuffers(Int32 n, [Out] out UInt32 buffers)
        {
            unsafe
            {
                fixed (UInt32* buffers_ptr = &buffers)
                {
                    Delegates.glGenBuffers((Int32)n, (UInt32*)buffers_ptr);
                    buffers = *buffers_ptr;
                }
            }
        }

        public static 
        void glGenBuffers(Int32 n, [Out] out Int32 buffers)
        {
            unsafe
            {
                fixed (Int32* buffers_ptr = &buffers)
                {
                    Delegates.glGenBuffers((Int32)n, (UInt32*)buffers_ptr);
                    buffers = *buffers_ptr;
                }
            }
        }

        public static 
        void glGenBuffers(Int32 n, [Out] IntPtr buffers)
        {
            unsafe
            {
                Delegates.glGenBuffers((Int32)n, (UInt32*)buffers);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        bool glIsBuffer(UInt32 buffer)
        {
            return Delegates.glIsBuffer((UInt32)buffer);
        }

        public static 
        bool glIsBuffer(Int32 buffer)
        {
            return Delegates.glIsBuffer((UInt32)buffer);
        }

        public static 
        void glBufferData(int target, IntPtr size, IntPtr data, int usage)
        {
            unsafe
            {
                Delegates.glBufferData((int)target, (IntPtr)size, (IntPtr)data, (int)usage);
            }
        }

        public static 
        void glBufferData(int target, IntPtr size, [In, Out] object data, int usage)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle data_ptr = System.Runtime.InteropServices.GCHandle.Alloc(data, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glBufferData((int)target, (IntPtr)size, (IntPtr)data_ptr.AddrOfPinnedObject(), (int)usage);
                }
                finally
                {
                    data_ptr.Free();
                }
            }
        }

        public static 
        void glBufferSubData(int target, IntPtr offset, IntPtr size, IntPtr data)
        {
            unsafe
            {
                Delegates.glBufferSubData((int)target, (IntPtr)offset, (IntPtr)size, (IntPtr)data);
            }
        }

        public static 
        void glBufferSubData(int target, IntPtr offset, IntPtr size, [In, Out] object data)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle data_ptr = System.Runtime.InteropServices.GCHandle.Alloc(data, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glBufferSubData((int)target, (IntPtr)offset, (IntPtr)size, (IntPtr)data_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    data_ptr.Free();
                }
            }
        }

        public static 
        void glGetBufferSubData(int target, IntPtr offset, IntPtr size, [Out] IntPtr data)
        {
            unsafe
            {
                Delegates.glGetBufferSubData((int)target, (IntPtr)offset, (IntPtr)size, (IntPtr)data);
            }
        }

        public static 
        void glGetBufferSubData(int target, IntPtr offset, IntPtr size, [In, Out] object data)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle data_ptr = System.Runtime.InteropServices.GCHandle.Alloc(data, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glGetBufferSubData((int)target, (IntPtr)offset, (IntPtr)size, (IntPtr)data_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    data_ptr.Free();
                }
            }
        }

        public static 
        IntPtr glMapBuffer(int target, int access)
        {
            return Delegates.glMapBuffer((int)target, (int)access);
        }

        public static 
        bool glUnmapBuffer(int target)
        {
            return Delegates.glUnmapBuffer((int)target);
        }

        public static 
        void glGetBufferParameteriv(int target, int pname, [Out] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetBufferParameteriv((int)target, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glGetBufferParameteriv(int target, int pname, [Out] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetBufferParameteriv((int)target, (int)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetBufferParameteriv(int target, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetBufferParameteriv((int)target, (int)pname, (Int32*)@params);
            }
        }

        public static 
        void glGetBufferPointerv(int target, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetBufferPointerv((int)target, (int)pname, (IntPtr)@params);
            }
        }

        public static 
        void glGetBufferPointerv(int target, int pname, [In, Out] object @params)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle @params_ptr = System.Runtime.InteropServices.GCHandle.Alloc(@params, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glGetBufferPointerv((int)target, (int)pname, (IntPtr)@params_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    @params_ptr.Free();
                }
            }
        }

        public static 
        void glBlendEquationSeparate(int modeRGB, int modeAlpha)
        {
            Delegates.glBlendEquationSeparate((int)modeRGB, (int)modeAlpha);
        }

        public static 
        void glDrawBuffers(Int32 n, int[] bufs)
        {
            unsafe
            {
                fixed (int* bufs_ptr = bufs)
                {
                    Delegates.glDrawBuffers((Int32)n, (int*)bufs_ptr);
                }
            }
        }

        public static 
        void glDrawBuffers(Int32 n, ref int bufs)
        {
            unsafe
            {
                fixed (int* bufs_ptr = &bufs)
                {
                    Delegates.glDrawBuffers((Int32)n, (int*)bufs_ptr);
                }
            }
        }

        public static 
        void glDrawBuffers(Int32 n, IntPtr bufs)
        {
            unsafe
            {
                Delegates.glDrawBuffers((Int32)n, (int*)bufs);
            }
        }

        public static 
        void glStencilOpSeparate(int face, int sfail, int dpfail, int dppass)
        {
            Delegates.glStencilOpSeparate((int)face, (int)sfail, (int)dpfail, (int)dppass);
        }

        [System.CLSCompliant(false)]
        public static 
        void glStencilFuncSeparate(int frontfunc, int backfunc, Int32 @ref, UInt32 mask)
        {
            Delegates.glStencilFuncSeparate((int)frontfunc, (int)backfunc, (Int32)@ref, (UInt32)mask);
        }

        public static 
        void glStencilFuncSeparate(int frontfunc, int backfunc, Int32 @ref, Int32 mask)
        {
            Delegates.glStencilFuncSeparate((int)frontfunc, (int)backfunc, (Int32)@ref, (UInt32)mask);
        }

        [System.CLSCompliant(false)]
        public static 
        void glStencilMaskSeparate(int face, UInt32 mask)
        {
            Delegates.glStencilMaskSeparate((int)face, (UInt32)mask);
        }

        public static 
        void glStencilMaskSeparate(int face, Int32 mask)
        {
            Delegates.glStencilMaskSeparate((int)face, (UInt32)mask);
        }

        [System.CLSCompliant(false)]
        public static 
        void glAttachShader(UInt32 program, UInt32 shader)
        {
            Delegates.glAttachShader((UInt32)program, (UInt32)shader);
        }

        public static 
        void glAttachShader(Int32 program, Int32 shader)
        {
            Delegates.glAttachShader((UInt32)program, (UInt32)shader);
        }

        [System.CLSCompliant(false)]
        public static 
        void glBindAttribLocation(UInt32 program, UInt32 index, System.String name)
        {
            Delegates.glBindAttribLocation((UInt32)program, (UInt32)index, (System.String)name);
        }

        public static 
        void glBindAttribLocation(Int32 program, Int32 index, System.String name)
        {
            Delegates.glBindAttribLocation((UInt32)program, (UInt32)index, (System.String)name);
        }

        [System.CLSCompliant(false)]
        public static 
        void glCompileShader(UInt32 shader)
        {
            Delegates.glCompileShader((UInt32)shader);
        }

        public static 
        void glCompileShader(Int32 shader)
        {
            Delegates.glCompileShader((UInt32)shader);
        }

        public static 
        Int32 glCreateProgram()
        {
            return Delegates.glCreateProgram();
        }

        public static 
        Int32 glCreateShader(int type)
        {
            return Delegates.glCreateShader((int)type);
        }

        [System.CLSCompliant(false)]
        public static 
        void glDeleteProgram(UInt32 program)
        {
            Delegates.glDeleteProgram((UInt32)program);
        }

        public static 
        void glDeleteProgram(Int32 program)
        {
            Delegates.glDeleteProgram((UInt32)program);
        }

        [System.CLSCompliant(false)]
        public static 
        void glDeleteShader(UInt32 shader)
        {
            Delegates.glDeleteShader((UInt32)shader);
        }

        public static 
        void glDeleteShader(Int32 shader)
        {
            Delegates.glDeleteShader((UInt32)shader);
        }

        [System.CLSCompliant(false)]
        public static 
        void glDetachShader(UInt32 program, UInt32 shader)
        {
            Delegates.glDetachShader((UInt32)program, (UInt32)shader);
        }

        public static 
        void glDetachShader(Int32 program, Int32 shader)
        {
            Delegates.glDetachShader((UInt32)program, (UInt32)shader);
        }

        [System.CLSCompliant(false)]
        public static 
        void glDisableVertexAttribArray(UInt32 index)
        {
            Delegates.glDisableVertexAttribArray((UInt32)index);
        }

        public static 
        void glDisableVertexAttribArray(Int32 index)
        {
            Delegates.glDisableVertexAttribArray((UInt32)index);
        }

        [System.CLSCompliant(false)]
        public static 
        void glEnableVertexAttribArray(UInt32 index)
        {
            Delegates.glEnableVertexAttribArray((UInt32)index);
        }

        public static 
        void glEnableVertexAttribArray(Int32 index)
        {
            Delegates.glEnableVertexAttribArray((UInt32)index);
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetActiveAttrib(UInt32 program, UInt32 index, Int32 bufSize, [Out] Int32[] length, [Out] Int32[] size, [Out] int[] type, [Out] System.Text.StringBuilder name)
        {
            unsafe
            {
                fixed (Int32* length_ptr = length)
                fixed (Int32* size_ptr = size)
                fixed (int* type_ptr = type)
                {
                    Delegates.glGetActiveAttrib((UInt32)program, (UInt32)index, (Int32)bufSize, (Int32*)length_ptr, (Int32*)size_ptr, (int*)type_ptr, (System.Text.StringBuilder)name);
                }
            }
        }

        public static 
        void glGetActiveAttrib(Int32 program, Int32 index, Int32 bufSize, [Out] Int32[] length, [Out] Int32[] size, [Out] int[] type, [Out] System.Text.StringBuilder name)
        {
            unsafe
            {
                fixed (Int32* length_ptr = length)
                fixed (Int32* size_ptr = size)
                fixed (int* type_ptr = type)
                {
                    Delegates.glGetActiveAttrib((UInt32)program, (UInt32)index, (Int32)bufSize, (Int32*)length_ptr, (Int32*)size_ptr, (int*)type_ptr, (System.Text.StringBuilder)name);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetActiveAttrib(UInt32 program, UInt32 index, Int32 bufSize, [Out] out Int32 length, [Out] out Int32 size, [Out] out int type, [Out] System.Text.StringBuilder name)
        {
            unsafe
            {
                fixed (Int32* length_ptr = &length)
                fixed (Int32* size_ptr = &size)
                fixed (int* type_ptr = &type)
                {
                    Delegates.glGetActiveAttrib((UInt32)program, (UInt32)index, (Int32)bufSize, (Int32*)length_ptr, (Int32*)size_ptr, (int*)type_ptr, (System.Text.StringBuilder)name);
                    length = *length_ptr;
                    size = *size_ptr;
                    type = *type_ptr;
                }
            }
        }

        public static 
        void glGetActiveAttrib(Int32 program, Int32 index, Int32 bufSize, [Out] out Int32 length, [Out] out Int32 size, [Out] out int type, [Out] System.Text.StringBuilder name)
        {
            unsafe
            {
                fixed (Int32* length_ptr = &length)
                fixed (Int32* size_ptr = &size)
                fixed (int* type_ptr = &type)
                {
                    Delegates.glGetActiveAttrib((UInt32)program, (UInt32)index, (Int32)bufSize, (Int32*)length_ptr, (Int32*)size_ptr, (int*)type_ptr, (System.Text.StringBuilder)name);
                    length = *length_ptr;
                    size = *size_ptr;
                    type = *type_ptr;
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetActiveAttrib(UInt32 program, UInt32 index, Int32 bufSize, [Out] IntPtr length, [Out] IntPtr size, [Out] IntPtr type, [Out] System.Text.StringBuilder name)
        {
            unsafe
            {
                Delegates.glGetActiveAttrib((UInt32)program, (UInt32)index, (Int32)bufSize, (Int32*)length, (Int32*)size, (int*)type, (System.Text.StringBuilder)name);
            }
        }

        public static 
        void glGetActiveAttrib(Int32 program, Int32 index, Int32 bufSize, [Out] IntPtr length, [Out] IntPtr size, [Out] IntPtr type, [Out] System.Text.StringBuilder name)
        {
            unsafe
            {
                Delegates.glGetActiveAttrib((UInt32)program, (UInt32)index, (Int32)bufSize, (Int32*)length, (Int32*)size, (int*)type, (System.Text.StringBuilder)name);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetActiveUniform(UInt32 program, UInt32 index, Int32 bufSize, [Out] Int32[] length, [Out] Int32[] size, [Out] int[] type, [Out] System.Text.StringBuilder name)
        {
            unsafe
            {
                fixed (Int32* length_ptr = length)
                fixed (Int32* size_ptr = size)
                fixed (int* type_ptr = type)
                {
                    Delegates.glGetActiveUniform((UInt32)program, (UInt32)index, (Int32)bufSize, (Int32*)length_ptr, (Int32*)size_ptr, (int*)type_ptr, (System.Text.StringBuilder)name);
                }
            }
        }

        public static 
        void glGetActiveUniform(Int32 program, Int32 index, Int32 bufSize, [Out] Int32[] length, [Out] Int32[] size, [Out] int[] type, [Out] System.Text.StringBuilder name)
        {
            unsafe
            {
                fixed (Int32* length_ptr = length)
                fixed (Int32* size_ptr = size)
                fixed (int* type_ptr = type)
                {
                    Delegates.glGetActiveUniform((UInt32)program, (UInt32)index, (Int32)bufSize, (Int32*)length_ptr, (Int32*)size_ptr, (int*)type_ptr, (System.Text.StringBuilder)name);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetActiveUniform(UInt32 program, UInt32 index, Int32 bufSize, [Out] out Int32 length, [Out] out Int32 size, [Out] out int type, [Out] System.Text.StringBuilder name)
        {
            unsafe
            {
                fixed (Int32* length_ptr = &length)
                fixed (Int32* size_ptr = &size)
                fixed (int* type_ptr = &type)
                {
                    Delegates.glGetActiveUniform((UInt32)program, (UInt32)index, (Int32)bufSize, (Int32*)length_ptr, (Int32*)size_ptr, (int*)type_ptr, (System.Text.StringBuilder)name);
                    length = *length_ptr;
                    size = *size_ptr;
                    type = *type_ptr;
                }
            }
        }

        public static 
        void glGetActiveUniform(Int32 program, Int32 index, Int32 bufSize, [Out] out Int32 length, [Out] out Int32 size, [Out] out int type, [Out] System.Text.StringBuilder name)
        {
            unsafe
            {
                fixed (Int32* length_ptr = &length)
                fixed (Int32* size_ptr = &size)
                fixed (int* type_ptr = &type)
                {
                    Delegates.glGetActiveUniform((UInt32)program, (UInt32)index, (Int32)bufSize, (Int32*)length_ptr, (Int32*)size_ptr, (int*)type_ptr, (System.Text.StringBuilder)name);
                    length = *length_ptr;
                    size = *size_ptr;
                    type = *type_ptr;
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetActiveUniform(UInt32 program, UInt32 index, Int32 bufSize, [Out] IntPtr length, [Out] IntPtr size, [Out] IntPtr type, [Out] System.Text.StringBuilder name)
        {
            unsafe
            {
                Delegates.glGetActiveUniform((UInt32)program, (UInt32)index, (Int32)bufSize, (Int32*)length, (Int32*)size, (int*)type, (System.Text.StringBuilder)name);
            }
        }

        public static 
        void glGetActiveUniform(Int32 program, Int32 index, Int32 bufSize, [Out] IntPtr length, [Out] IntPtr size, [Out] IntPtr type, [Out] System.Text.StringBuilder name)
        {
            unsafe
            {
                Delegates.glGetActiveUniform((UInt32)program, (UInt32)index, (Int32)bufSize, (Int32*)length, (Int32*)size, (int*)type, (System.Text.StringBuilder)name);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetAttachedShaders(UInt32 program, Int32 maxCount, [Out] Int32[] count, [Out] UInt32[] obj)
        {
            unsafe
            {
                fixed (Int32* count_ptr = count)
                fixed (UInt32* obj_ptr = obj)
                {
                    Delegates.glGetAttachedShaders((UInt32)program, (Int32)maxCount, (Int32*)count_ptr, (UInt32*)obj_ptr);
                }
            }
        }

        public static 
        void glGetAttachedShaders(Int32 program, Int32 maxCount, [Out] Int32[] count, [Out] Int32[] obj)
        {
            unsafe
            {
                fixed (Int32* count_ptr = count)
                fixed (Int32* obj_ptr = obj)
                {
                    Delegates.glGetAttachedShaders((UInt32)program, (Int32)maxCount, (Int32*)count_ptr, (UInt32*)obj_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetAttachedShaders(UInt32 program, Int32 maxCount, [Out] out Int32 count, [Out] out UInt32 obj)
        {
            unsafe
            {
                fixed (Int32* count_ptr = &count)
                fixed (UInt32* obj_ptr = &obj)
                {
                    Delegates.glGetAttachedShaders((UInt32)program, (Int32)maxCount, (Int32*)count_ptr, (UInt32*)obj_ptr);
                    count = *count_ptr;
                    obj = *obj_ptr;
                }
            }
        }

        public static 
        void glGetAttachedShaders(Int32 program, Int32 maxCount, [Out] out Int32 count, [Out] out Int32 obj)
        {
            unsafe
            {
                fixed (Int32* count_ptr = &count)
                fixed (Int32* obj_ptr = &obj)
                {
                    Delegates.glGetAttachedShaders((UInt32)program, (Int32)maxCount, (Int32*)count_ptr, (UInt32*)obj_ptr);
                    count = *count_ptr;
                    obj = *obj_ptr;
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetAttachedShaders(UInt32 program, Int32 maxCount, [Out] IntPtr count, [Out] IntPtr obj)
        {
            unsafe
            {
                Delegates.glGetAttachedShaders((UInt32)program, (Int32)maxCount, (Int32*)count, (UInt32*)obj);
            }
        }

        public static 
        void glGetAttachedShaders(Int32 program, Int32 maxCount, [Out] IntPtr count, [Out] IntPtr obj)
        {
            unsafe
            {
                Delegates.glGetAttachedShaders((UInt32)program, (Int32)maxCount, (Int32*)count, (UInt32*)obj);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        Int32 glGetAttribLocation(UInt32 program, System.String name)
        {
            return Delegates.glGetAttribLocation((UInt32)program, (System.String)name);
        }

        public static 
        Int32 glGetAttribLocation(Int32 program, System.String name)
        {
            return Delegates.glGetAttribLocation((UInt32)program, (System.String)name);
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetProgramiv(UInt32 program, int pname, [Out] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetProgramiv((UInt32)program, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glGetProgramiv(Int32 program, int pname, [Out] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetProgramiv((UInt32)program, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetProgramiv(UInt32 program, int pname, [Out] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetProgramiv((UInt32)program, (int)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetProgramiv(Int32 program, int pname, [Out] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetProgramiv((UInt32)program, (int)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetProgramiv(UInt32 program, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetProgramiv((UInt32)program, (int)pname, (Int32*)@params);
            }
        }

        public static 
        void glGetProgramiv(Int32 program, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetProgramiv((UInt32)program, (int)pname, (Int32*)@params);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetProgramInfoLog(UInt32 program, Int32 bufSize, [Out] Int32[] length, [Out] System.Text.StringBuilder infoLog)
        {
            unsafe
            {
                fixed (Int32* length_ptr = length)
                {
                    Delegates.glGetProgramInfoLog((UInt32)program, (Int32)bufSize, (Int32*)length_ptr, (System.Text.StringBuilder)infoLog);
                }
            }
        }

        public static 
        void glGetProgramInfoLog(Int32 program, Int32 bufSize, [Out] Int32[] length, [Out] System.Text.StringBuilder infoLog)
        {
            unsafe
            {
                fixed (Int32* length_ptr = length)
                {
                    Delegates.glGetProgramInfoLog((UInt32)program, (Int32)bufSize, (Int32*)length_ptr, (System.Text.StringBuilder)infoLog);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetProgramInfoLog(UInt32 program, Int32 bufSize, [Out] out Int32 length, [Out] System.Text.StringBuilder infoLog)
        {
            unsafe
            {
                fixed (Int32* length_ptr = &length)
                {
                    Delegates.glGetProgramInfoLog((UInt32)program, (Int32)bufSize, (Int32*)length_ptr, (System.Text.StringBuilder)infoLog);
                    length = *length_ptr;
                }
            }
        }

        public static 
        void glGetProgramInfoLog(Int32 program, Int32 bufSize, [Out] out Int32 length, [Out] System.Text.StringBuilder infoLog)
        {
            unsafe
            {
                fixed (Int32* length_ptr = &length)
                {
                    Delegates.glGetProgramInfoLog((UInt32)program, (Int32)bufSize, (Int32*)length_ptr, (System.Text.StringBuilder)infoLog);
                    length = *length_ptr;
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetProgramInfoLog(UInt32 program, Int32 bufSize, [Out] IntPtr length, [Out] System.Text.StringBuilder infoLog)
        {
            unsafe
            {
                Delegates.glGetProgramInfoLog((UInt32)program, (Int32)bufSize, (Int32*)length, (System.Text.StringBuilder)infoLog);
            }
        }

        public static 
        void glGetProgramInfoLog(Int32 program, Int32 bufSize, [Out] IntPtr length, [Out] System.Text.StringBuilder infoLog)
        {
            unsafe
            {
                Delegates.glGetProgramInfoLog((UInt32)program, (Int32)bufSize, (Int32*)length, (System.Text.StringBuilder)infoLog);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetShaderiv(UInt32 shader, int pname, [Out] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetShaderiv((UInt32)shader, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glGetShaderiv(Int32 shader, int pname, [Out] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetShaderiv((UInt32)shader, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetShaderiv(UInt32 shader, int pname, [Out] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetShaderiv((UInt32)shader, (int)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetShaderiv(Int32 shader, int pname, [Out] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetShaderiv((UInt32)shader, (int)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetShaderiv(UInt32 shader, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetShaderiv((UInt32)shader, (int)pname, (Int32*)@params);
            }
        }

        public static 
        void glGetShaderiv(Int32 shader, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetShaderiv((UInt32)shader, (int)pname, (Int32*)@params);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetShaderInfoLog(UInt32 shader, Int32 bufSize, [Out] Int32[] length, [Out] System.Text.StringBuilder infoLog)
        {
            unsafe
            {
                fixed (Int32* length_ptr = length)
                {
                    Delegates.glGetShaderInfoLog((UInt32)shader, (Int32)bufSize, (Int32*)length_ptr, (System.Text.StringBuilder)infoLog);
                }
            }
        }

        public static 
        void glGetShaderInfoLog(Int32 shader, Int32 bufSize, [Out] Int32[] length, [Out] System.Text.StringBuilder infoLog)
        {
            unsafe
            {
                fixed (Int32* length_ptr = length)
                {
                    Delegates.glGetShaderInfoLog((UInt32)shader, (Int32)bufSize, (Int32*)length_ptr, (System.Text.StringBuilder)infoLog);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetShaderInfoLog(UInt32 shader, Int32 bufSize, [Out] out Int32 length, [Out] System.Text.StringBuilder infoLog)
        {
            unsafe
            {
                fixed (Int32* length_ptr = &length)
                {
                    Delegates.glGetShaderInfoLog((UInt32)shader, (Int32)bufSize, (Int32*)length_ptr, (System.Text.StringBuilder)infoLog);
                    length = *length_ptr;
                }
            }
        }

        public static 
        void glGetShaderInfoLog(Int32 shader, Int32 bufSize, [Out] out Int32 length, [Out] System.Text.StringBuilder infoLog)
        {
            unsafe
            {
                fixed (Int32* length_ptr = &length)
                {
                    Delegates.glGetShaderInfoLog((UInt32)shader, (Int32)bufSize, (Int32*)length_ptr, (System.Text.StringBuilder)infoLog);
                    length = *length_ptr;
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetShaderInfoLog(UInt32 shader, Int32 bufSize, [Out] IntPtr length, [Out] System.Text.StringBuilder infoLog)
        {
            unsafe
            {
                Delegates.glGetShaderInfoLog((UInt32)shader, (Int32)bufSize, (Int32*)length, (System.Text.StringBuilder)infoLog);
            }
        }

        public static 
        void glGetShaderInfoLog(Int32 shader, Int32 bufSize, [Out] IntPtr length, [Out] System.Text.StringBuilder infoLog)
        {
            unsafe
            {
                Delegates.glGetShaderInfoLog((UInt32)shader, (Int32)bufSize, (Int32*)length, (System.Text.StringBuilder)infoLog);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetShaderSource(UInt32 shader, Int32 bufSize, [Out] Int32[] length, [Out] System.Text.StringBuilder[] source)
        {
            unsafe
            {
                fixed (Int32* length_ptr = length)
                {
                    Delegates.glGetShaderSource((UInt32)shader, (Int32)bufSize, (Int32*)length_ptr, (System.Text.StringBuilder[])source);
                }
            }
        }

        public static 
        void glGetShaderSource(Int32 shader, Int32 bufSize, [Out] Int32[] length, [Out] System.Text.StringBuilder[] source)
        {
            unsafe
            {
                fixed (Int32* length_ptr = length)
                {
                    Delegates.glGetShaderSource((UInt32)shader, (Int32)bufSize, (Int32*)length_ptr, (System.Text.StringBuilder[])source);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetShaderSource(UInt32 shader, Int32 bufSize, [Out] out Int32 length, [Out] System.Text.StringBuilder[] source)
        {
            unsafe
            {
                fixed (Int32* length_ptr = &length)
                {
                    Delegates.glGetShaderSource((UInt32)shader, (Int32)bufSize, (Int32*)length_ptr, (System.Text.StringBuilder[])source);
                    length = *length_ptr;
                }
            }
        }

        public static 
        void glGetShaderSource(Int32 shader, Int32 bufSize, [Out] out Int32 length, [Out] System.Text.StringBuilder[] source)
        {
            unsafe
            {
                fixed (Int32* length_ptr = &length)
                {
                    Delegates.glGetShaderSource((UInt32)shader, (Int32)bufSize, (Int32*)length_ptr, (System.Text.StringBuilder[])source);
                    length = *length_ptr;
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetShaderSource(UInt32 shader, Int32 bufSize, [Out] IntPtr length, [Out] System.Text.StringBuilder[] source)
        {
            unsafe
            {
                Delegates.glGetShaderSource((UInt32)shader, (Int32)bufSize, (Int32*)length, (System.Text.StringBuilder[])source);
            }
        }

        public static 
        void glGetShaderSource(Int32 shader, Int32 bufSize, [Out] IntPtr length, [Out] System.Text.StringBuilder[] source)
        {
            unsafe
            {
                Delegates.glGetShaderSource((UInt32)shader, (Int32)bufSize, (Int32*)length, (System.Text.StringBuilder[])source);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        Int32 glGetUniformLocation(UInt32 program, System.String name)
        {
            return Delegates.glGetUniformLocation((UInt32)program, (System.String)name);
        }

        public static 
        Int32 glGetUniformLocation(Int32 program, System.String name)
        {
            return Delegates.glGetUniformLocation((UInt32)program, (System.String)name);
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetUniformfv(UInt32 program, Int32 location, [Out] Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glGetUniformfv((UInt32)program, (Int32)location, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glGetUniformfv(Int32 program, Int32 location, [Out] Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glGetUniformfv((UInt32)program, (Int32)location, (Single*)@params_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetUniformfv(UInt32 program, Int32 location, [Out] out Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glGetUniformfv((UInt32)program, (Int32)location, (Single*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetUniformfv(Int32 program, Int32 location, [Out] out Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glGetUniformfv((UInt32)program, (Int32)location, (Single*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetUniformfv(UInt32 program, Int32 location, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetUniformfv((UInt32)program, (Int32)location, (Single*)@params);
            }
        }

        public static 
        void glGetUniformfv(Int32 program, Int32 location, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetUniformfv((UInt32)program, (Int32)location, (Single*)@params);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetUniformiv(UInt32 program, Int32 location, [Out] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetUniformiv((UInt32)program, (Int32)location, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glGetUniformiv(Int32 program, Int32 location, [Out] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetUniformiv((UInt32)program, (Int32)location, (Int32*)@params_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetUniformiv(UInt32 program, Int32 location, [Out] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetUniformiv((UInt32)program, (Int32)location, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetUniformiv(Int32 program, Int32 location, [Out] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetUniformiv((UInt32)program, (Int32)location, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetUniformiv(UInt32 program, Int32 location, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetUniformiv((UInt32)program, (Int32)location, (Int32*)@params);
            }
        }

        public static 
        void glGetUniformiv(Int32 program, Int32 location, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetUniformiv((UInt32)program, (Int32)location, (Int32*)@params);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetVertexAttribdv(UInt32 index, int pname, [Out] Double[] @params)
        {
            unsafe
            {
                fixed (Double* @params_ptr = @params)
                {
                    Delegates.glGetVertexAttribdv((UInt32)index, (int)pname, (Double*)@params_ptr);
                }
            }
        }

        public static 
        void glGetVertexAttribdv(Int32 index, int pname, [Out] Double[] @params)
        {
            unsafe
            {
                fixed (Double* @params_ptr = @params)
                {
                    Delegates.glGetVertexAttribdv((UInt32)index, (int)pname, (Double*)@params_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetVertexAttribdv(UInt32 index, int pname, [Out] out Double @params)
        {
            unsafe
            {
                fixed (Double* @params_ptr = &@params)
                {
                    Delegates.glGetVertexAttribdv((UInt32)index, (int)pname, (Double*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetVertexAttribdv(Int32 index, int pname, [Out] out Double @params)
        {
            unsafe
            {
                fixed (Double* @params_ptr = &@params)
                {
                    Delegates.glGetVertexAttribdv((UInt32)index, (int)pname, (Double*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetVertexAttribdv(UInt32 index, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetVertexAttribdv((UInt32)index, (int)pname, (Double*)@params);
            }
        }

        public static 
        void glGetVertexAttribdv(Int32 index, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetVertexAttribdv((UInt32)index, (int)pname, (Double*)@params);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetVertexAttribfv(UInt32 index, int pname, [Out] Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glGetVertexAttribfv((UInt32)index, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glGetVertexAttribfv(Int32 index, int pname, [Out] Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glGetVertexAttribfv((UInt32)index, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetVertexAttribfv(UInt32 index, int pname, [Out] out Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glGetVertexAttribfv((UInt32)index, (int)pname, (Single*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetVertexAttribfv(Int32 index, int pname, [Out] out Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glGetVertexAttribfv((UInt32)index, (int)pname, (Single*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetVertexAttribfv(UInt32 index, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetVertexAttribfv((UInt32)index, (int)pname, (Single*)@params);
            }
        }

        public static 
        void glGetVertexAttribfv(Int32 index, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetVertexAttribfv((UInt32)index, (int)pname, (Single*)@params);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetVertexAttribiv(UInt32 index, int pname, [Out] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetVertexAttribiv((UInt32)index, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glGetVertexAttribiv(Int32 index, int pname, [Out] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetVertexAttribiv((UInt32)index, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetVertexAttribiv(UInt32 index, int pname, [Out] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetVertexAttribiv((UInt32)index, (int)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetVertexAttribiv(Int32 index, int pname, [Out] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetVertexAttribiv((UInt32)index, (int)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetVertexAttribiv(UInt32 index, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetVertexAttribiv((UInt32)index, (int)pname, (Int32*)@params);
            }
        }

        public static 
        void glGetVertexAttribiv(Int32 index, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetVertexAttribiv((UInt32)index, (int)pname, (Int32*)@params);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetVertexAttribPointerv(UInt32 index, int pname, [Out] IntPtr pointer)
        {
            unsafe
            {
                Delegates.glGetVertexAttribPointerv((UInt32)index, (int)pname, (IntPtr)pointer);
            }
        }

        public static 
        void glGetVertexAttribPointerv(Int32 index, int pname, [Out] IntPtr pointer)
        {
            unsafe
            {
                Delegates.glGetVertexAttribPointerv((UInt32)index, (int)pname, (IntPtr)pointer);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetVertexAttribPointerv(UInt32 index, int pname, [In, Out] object pointer)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle pointer_ptr = System.Runtime.InteropServices.GCHandle.Alloc(pointer, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glGetVertexAttribPointerv((UInt32)index, (int)pname, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
            }
        }

        public static 
        void glGetVertexAttribPointerv(Int32 index, int pname, [In, Out] object pointer)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle pointer_ptr = System.Runtime.InteropServices.GCHandle.Alloc(pointer, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glGetVertexAttribPointerv((UInt32)index, (int)pname, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        bool glIsProgram(UInt32 program)
        {
            return Delegates.glIsProgram((UInt32)program);
        }

        public static 
        bool glIsProgram(Int32 program)
        {
            return Delegates.glIsProgram((UInt32)program);
        }

        [System.CLSCompliant(false)]
        public static 
        bool glIsShader(UInt32 shader)
        {
            return Delegates.glIsShader((UInt32)shader);
        }

        public static 
        bool glIsShader(Int32 shader)
        {
            return Delegates.glIsShader((UInt32)shader);
        }

        [System.CLSCompliant(false)]
        public static 
        void glLinkProgram(UInt32 program)
        {
            Delegates.glLinkProgram((UInt32)program);
        }

        public static 
        void glLinkProgram(Int32 program)
        {
            Delegates.glLinkProgram((UInt32)program);
        }

        [System.CLSCompliant(false)]
        public static 
        void glShaderSource(UInt32 shader, Int32 count, System.String[] @string, Int32[] length)
        {
            unsafe
            {
                fixed (Int32* length_ptr = length)
                {
                    Delegates.glShaderSource((UInt32)shader, (Int32)count, (System.String[])@string, (Int32*)length_ptr);
                }
            }
        }

        public static 
        void glShaderSource(Int32 shader, Int32 count, System.String[] @string, Int32[] length)
        {
            unsafe
            {
                fixed (Int32* length_ptr = length)
                {
                    Delegates.glShaderSource((UInt32)shader, (Int32)count, (System.String[])@string, (Int32*)length_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glShaderSource(UInt32 shader, Int32 count, System.String[] @string, ref Int32 length)
        {
            unsafe
            {
                fixed (Int32* length_ptr = &length)
                {
                    Delegates.glShaderSource((UInt32)shader, (Int32)count, (System.String[])@string, (Int32*)length_ptr);
                }
            }
        }

        public static 
        void glShaderSource(Int32 shader, Int32 count, System.String[] @string, ref Int32 length)
        {
            unsafe
            {
                fixed (Int32* length_ptr = &length)
                {
                    Delegates.glShaderSource((UInt32)shader, (Int32)count, (System.String[])@string, (Int32*)length_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glShaderSource(UInt32 shader, Int32 count, System.String[] @string, IntPtr length)
        {
            unsafe
            {
                Delegates.glShaderSource((UInt32)shader, (Int32)count, (System.String[])@string, (Int32*)length);
            }
        }

        public static 
        void glShaderSource(Int32 shader, Int32 count, System.String[] @string, IntPtr length)
        {
            unsafe
            {
                Delegates.glShaderSource((UInt32)shader, (Int32)count, (System.String[])@string, (Int32*)length);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glUseProgram(UInt32 program)
        {
            Delegates.glUseProgram((UInt32)program);
        }

        public static 
        void glUseProgram(Int32 program)
        {
            Delegates.glUseProgram((UInt32)program);
        }

        public static 
        void glUniform1f(Int32 location, Single v0)
        {
            Delegates.glUniform1f((Int32)location, (Single)v0);
        }

        public static 
        void glUniform2f(Int32 location, Single v0, Single v1)
        {
            Delegates.glUniform2f((Int32)location, (Single)v0, (Single)v1);
        }

        public static 
        void glUniform3f(Int32 location, Single v0, Single v1, Single v2)
        {
            Delegates.glUniform3f((Int32)location, (Single)v0, (Single)v1, (Single)v2);
        }

        public static 
        void glUniform4f(Int32 location, Single v0, Single v1, Single v2, Single v3)
        {
            Delegates.glUniform4f((Int32)location, (Single)v0, (Single)v1, (Single)v2, (Single)v3);
        }

        public static 
        void glUniform1i(Int32 location, Int32 v0)
        {
            Delegates.glUniform1i((Int32)location, (Int32)v0);
        }

        public static 
        void glUniform2i(Int32 location, Int32 v0, Int32 v1)
        {
            Delegates.glUniform2i((Int32)location, (Int32)v0, (Int32)v1);
        }

        public static 
        void glUniform3i(Int32 location, Int32 v0, Int32 v1, Int32 v2)
        {
            Delegates.glUniform3i((Int32)location, (Int32)v0, (Int32)v1, (Int32)v2);
        }

        public static 
        void glUniform4i(Int32 location, Int32 v0, Int32 v1, Int32 v2, Int32 v3)
        {
            Delegates.glUniform4i((Int32)location, (Int32)v0, (Int32)v1, (Int32)v2, (Int32)v3);
        }

        public static 
        void glUniform1fv(Int32 location, Int32 count, Single[] value)
        {
            unsafe
            {
                fixed (Single* value_ptr = value)
                {
                    Delegates.glUniform1fv((Int32)location, (Int32)count, (Single*)value_ptr);
                }
            }
        }

        public static 
        void glUniform1fv(Int32 location, Int32 count, ref Single value)
        {
            unsafe
            {
                fixed (Single* value_ptr = &value)
                {
                    Delegates.glUniform1fv((Int32)location, (Int32)count, (Single*)value_ptr);
                }
            }
        }

        public static 
        void glUniform1fv(Int32 location, Int32 count, IntPtr value)
        {
            unsafe
            {
                Delegates.glUniform1fv((Int32)location, (Int32)count, (Single*)value);
            }
        }

        public static 
        void glUniform2fv(Int32 location, Int32 count, Single[] value)
        {
            unsafe
            {
                fixed (Single* value_ptr = value)
                {
                    Delegates.glUniform2fv((Int32)location, (Int32)count, (Single*)value_ptr);
                }
            }
        }

        public static 
        void glUniform2fv(Int32 location, Int32 count, ref Single value)
        {
            unsafe
            {
                fixed (Single* value_ptr = &value)
                {
                    Delegates.glUniform2fv((Int32)location, (Int32)count, (Single*)value_ptr);
                }
            }
        }

        public static 
        void glUniform2fv(Int32 location, Int32 count, IntPtr value)
        {
            unsafe
            {
                Delegates.glUniform2fv((Int32)location, (Int32)count, (Single*)value);
            }
        }

        public static 
        void glUniform3fv(Int32 location, Int32 count, Single[] value)
        {
            unsafe
            {
                fixed (Single* value_ptr = value)
                {
                    Delegates.glUniform3fv((Int32)location, (Int32)count, (Single*)value_ptr);
                }
            }
        }

        public static 
        void glUniform3fv(Int32 location, Int32 count, ref Single value)
        {
            unsafe
            {
                fixed (Single* value_ptr = &value)
                {
                    Delegates.glUniform3fv((Int32)location, (Int32)count, (Single*)value_ptr);
                }
            }
        }

        public static 
        void glUniform3fv(Int32 location, Int32 count, IntPtr value)
        {
            unsafe
            {
                Delegates.glUniform3fv((Int32)location, (Int32)count, (Single*)value);
            }
        }

        public static 
        void glUniform4fv(Int32 location, Int32 count, Single[] value)
        {
            unsafe
            {
                fixed (Single* value_ptr = value)
                {
                    Delegates.glUniform4fv((Int32)location, (Int32)count, (Single*)value_ptr);
                }
            }
        }

        public static 
        void glUniform4fv(Int32 location, Int32 count, ref Single value)
        {
            unsafe
            {
                fixed (Single* value_ptr = &value)
                {
                    Delegates.glUniform4fv((Int32)location, (Int32)count, (Single*)value_ptr);
                }
            }
        }

        public static 
        void glUniform4fv(Int32 location, Int32 count, IntPtr value)
        {
            unsafe
            {
                Delegates.glUniform4fv((Int32)location, (Int32)count, (Single*)value);
            }
        }

        public static 
        void glUniform1iv(Int32 location, Int32 count, Int32[] value)
        {
            unsafe
            {
                fixed (Int32* value_ptr = value)
                {
                    Delegates.glUniform1iv((Int32)location, (Int32)count, (Int32*)value_ptr);
                }
            }
        }

        public static 
        void glUniform1iv(Int32 location, Int32 count, ref Int32 value)
        {
            unsafe
            {
                fixed (Int32* value_ptr = &value)
                {
                    Delegates.glUniform1iv((Int32)location, (Int32)count, (Int32*)value_ptr);
                }
            }
        }

        public static 
        void glUniform1iv(Int32 location, Int32 count, IntPtr value)
        {
            unsafe
            {
                Delegates.glUniform1iv((Int32)location, (Int32)count, (Int32*)value);
            }
        }

        public static 
        void glUniform2iv(Int32 location, Int32 count, Int32[] value)
        {
            unsafe
            {
                fixed (Int32* value_ptr = value)
                {
                    Delegates.glUniform2iv((Int32)location, (Int32)count, (Int32*)value_ptr);
                }
            }
        }

        public static 
        void glUniform2iv(Int32 location, Int32 count, ref Int32 value)
        {
            unsafe
            {
                fixed (Int32* value_ptr = &value)
                {
                    Delegates.glUniform2iv((Int32)location, (Int32)count, (Int32*)value_ptr);
                }
            }
        }

        public static 
        void glUniform2iv(Int32 location, Int32 count, IntPtr value)
        {
            unsafe
            {
                Delegates.glUniform2iv((Int32)location, (Int32)count, (Int32*)value);
            }
        }

        public static 
        void glUniform3iv(Int32 location, Int32 count, Int32[] value)
        {
            unsafe
            {
                fixed (Int32* value_ptr = value)
                {
                    Delegates.glUniform3iv((Int32)location, (Int32)count, (Int32*)value_ptr);
                }
            }
        }

        public static 
        void glUniform3iv(Int32 location, Int32 count, ref Int32 value)
        {
            unsafe
            {
                fixed (Int32* value_ptr = &value)
                {
                    Delegates.glUniform3iv((Int32)location, (Int32)count, (Int32*)value_ptr);
                }
            }
        }

        public static 
        void glUniform3iv(Int32 location, Int32 count, IntPtr value)
        {
            unsafe
            {
                Delegates.glUniform3iv((Int32)location, (Int32)count, (Int32*)value);
            }
        }

        public static 
        void glUniform4iv(Int32 location, Int32 count, Int32[] value)
        {
            unsafe
            {
                fixed (Int32* value_ptr = value)
                {
                    Delegates.glUniform4iv((Int32)location, (Int32)count, (Int32*)value_ptr);
                }
            }
        }

        public static 
        void glUniform4iv(Int32 location, Int32 count, ref Int32 value)
        {
            unsafe
            {
                fixed (Int32* value_ptr = &value)
                {
                    Delegates.glUniform4iv((Int32)location, (Int32)count, (Int32*)value_ptr);
                }
            }
        }

        public static 
        void glUniform4iv(Int32 location, Int32 count, IntPtr value)
        {
            unsafe
            {
                Delegates.glUniform4iv((Int32)location, (Int32)count, (Int32*)value);
            }
        }

        public static 
        void glUniformMatrix2fv(Int32 location, Int32 count, bool transpose, Single[] value)
        {
            unsafe
            {
                fixed (Single* value_ptr = value)
                {
                    Delegates.glUniformMatrix2fv((Int32)location, (Int32)count, (bool)transpose, (Single*)value_ptr);
                }
            }
        }

        public static 
        void glUniformMatrix2fv(Int32 location, Int32 count, bool transpose, ref Single value)
        {
            unsafe
            {
                fixed (Single* value_ptr = &value)
                {
                    Delegates.glUniformMatrix2fv((Int32)location, (Int32)count, (bool)transpose, (Single*)value_ptr);
                }
            }
        }

        public static 
        void glUniformMatrix2fv(Int32 location, Int32 count, bool transpose, IntPtr value)
        {
            unsafe
            {
                Delegates.glUniformMatrix2fv((Int32)location, (Int32)count, (bool)transpose, (Single*)value);
            }
        }

        public static 
        void glUniformMatrix3fv(Int32 location, Int32 count, bool transpose, Single[] value)
        {
            unsafe
            {
                fixed (Single* value_ptr = value)
                {
                    Delegates.glUniformMatrix3fv((Int32)location, (Int32)count, (bool)transpose, (Single*)value_ptr);
                }
            }
        }

        public static 
        void glUniformMatrix3fv(Int32 location, Int32 count, bool transpose, ref Single value)
        {
            unsafe
            {
                fixed (Single* value_ptr = &value)
                {
                    Delegates.glUniformMatrix3fv((Int32)location, (Int32)count, (bool)transpose, (Single*)value_ptr);
                }
            }
        }

        public static 
        void glUniformMatrix3fv(Int32 location, Int32 count, bool transpose, IntPtr value)
        {
            unsafe
            {
                Delegates.glUniformMatrix3fv((Int32)location, (Int32)count, (bool)transpose, (Single*)value);
            }
        }

        public static 
        void glUniformMatrix4fv(Int32 location, Int32 count, bool transpose, Single[] value)
        {
            unsafe
            {
                fixed (Single* value_ptr = value)
                {
                    Delegates.glUniformMatrix4fv((Int32)location, (Int32)count, (bool)transpose, (Single*)value_ptr);
                }
            }
        }

        public static 
        void glUniformMatrix4fv(Int32 location, Int32 count, bool transpose, ref Single value)
        {
            unsafe
            {
                fixed (Single* value_ptr = &value)
                {
                    Delegates.glUniformMatrix4fv((Int32)location, (Int32)count, (bool)transpose, (Single*)value_ptr);
                }
            }
        }

        public static 
        void glUniformMatrix4fv(Int32 location, Int32 count, bool transpose, IntPtr value)
        {
            unsafe
            {
                Delegates.glUniformMatrix4fv((Int32)location, (Int32)count, (bool)transpose, (Single*)value);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glValidateProgram(UInt32 program)
        {
            Delegates.glValidateProgram((UInt32)program);
        }

        public static 
        void glValidateProgram(Int32 program)
        {
            Delegates.glValidateProgram((UInt32)program);
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib1d(UInt32 index, Double x)
        {
            Delegates.glVertexAttrib1d((UInt32)index, (Double)x);
        }

        public static 
        void glVertexAttrib1d(Int32 index, Double x)
        {
            Delegates.glVertexAttrib1d((UInt32)index, (Double)x);
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib1dv(UInt32 index, Double[] v)
        {
            unsafe
            {
                fixed (Double* v_ptr = v)
                {
                    Delegates.glVertexAttrib1dv((UInt32)index, (Double*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib1dv(Int32 index, Double[] v)
        {
            unsafe
            {
                fixed (Double* v_ptr = v)
                {
                    Delegates.glVertexAttrib1dv((UInt32)index, (Double*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib1dv(UInt32 index, ref Double v)
        {
            unsafe
            {
                fixed (Double* v_ptr = &v)
                {
                    Delegates.glVertexAttrib1dv((UInt32)index, (Double*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib1dv(Int32 index, ref Double v)
        {
            unsafe
            {
                fixed (Double* v_ptr = &v)
                {
                    Delegates.glVertexAttrib1dv((UInt32)index, (Double*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib1dv(UInt32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib1dv((UInt32)index, (Double*)v);
            }
        }

        public static 
        void glVertexAttrib1dv(Int32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib1dv((UInt32)index, (Double*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib1f(UInt32 index, Single x)
        {
            Delegates.glVertexAttrib1f((UInt32)index, (Single)x);
        }

        public static 
        void glVertexAttrib1f(Int32 index, Single x)
        {
            Delegates.glVertexAttrib1f((UInt32)index, (Single)x);
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib1fv(UInt32 index, Single[] v)
        {
            unsafe
            {
                fixed (Single* v_ptr = v)
                {
                    Delegates.glVertexAttrib1fv((UInt32)index, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib1fv(Int32 index, Single[] v)
        {
            unsafe
            {
                fixed (Single* v_ptr = v)
                {
                    Delegates.glVertexAttrib1fv((UInt32)index, (Single*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib1fv(UInt32 index, ref Single v)
        {
            unsafe
            {
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glVertexAttrib1fv((UInt32)index, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib1fv(Int32 index, ref Single v)
        {
            unsafe
            {
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glVertexAttrib1fv((UInt32)index, (Single*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib1fv(UInt32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib1fv((UInt32)index, (Single*)v);
            }
        }

        public static 
        void glVertexAttrib1fv(Int32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib1fv((UInt32)index, (Single*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib1s(UInt32 index, Int16 x)
        {
            Delegates.glVertexAttrib1s((UInt32)index, (Int16)x);
        }

        public static 
        void glVertexAttrib1s(Int32 index, Int16 x)
        {
            Delegates.glVertexAttrib1s((UInt32)index, (Int16)x);
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib1sv(UInt32 index, Int16[] v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = v)
                {
                    Delegates.glVertexAttrib1sv((UInt32)index, (Int16*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib1sv(Int32 index, Int16[] v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = v)
                {
                    Delegates.glVertexAttrib1sv((UInt32)index, (Int16*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib1sv(UInt32 index, ref Int16 v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = &v)
                {
                    Delegates.glVertexAttrib1sv((UInt32)index, (Int16*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib1sv(Int32 index, ref Int16 v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = &v)
                {
                    Delegates.glVertexAttrib1sv((UInt32)index, (Int16*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib1sv(UInt32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib1sv((UInt32)index, (Int16*)v);
            }
        }

        public static 
        void glVertexAttrib1sv(Int32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib1sv((UInt32)index, (Int16*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib2d(UInt32 index, Double x, Double y)
        {
            Delegates.glVertexAttrib2d((UInt32)index, (Double)x, (Double)y);
        }

        public static 
        void glVertexAttrib2d(Int32 index, Double x, Double y)
        {
            Delegates.glVertexAttrib2d((UInt32)index, (Double)x, (Double)y);
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib2dv(UInt32 index, Double[] v)
        {
            unsafe
            {
                fixed (Double* v_ptr = v)
                {
                    Delegates.glVertexAttrib2dv((UInt32)index, (Double*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib2dv(Int32 index, Double[] v)
        {
            unsafe
            {
                fixed (Double* v_ptr = v)
                {
                    Delegates.glVertexAttrib2dv((UInt32)index, (Double*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib2dv(UInt32 index, ref Double v)
        {
            unsafe
            {
                fixed (Double* v_ptr = &v)
                {
                    Delegates.glVertexAttrib2dv((UInt32)index, (Double*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib2dv(Int32 index, ref Double v)
        {
            unsafe
            {
                fixed (Double* v_ptr = &v)
                {
                    Delegates.glVertexAttrib2dv((UInt32)index, (Double*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib2dv(UInt32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib2dv((UInt32)index, (Double*)v);
            }
        }

        public static 
        void glVertexAttrib2dv(Int32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib2dv((UInt32)index, (Double*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib2f(UInt32 index, Single x, Single y)
        {
            Delegates.glVertexAttrib2f((UInt32)index, (Single)x, (Single)y);
        }

        public static 
        void glVertexAttrib2f(Int32 index, Single x, Single y)
        {
            Delegates.glVertexAttrib2f((UInt32)index, (Single)x, (Single)y);
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib2fv(UInt32 index, Single[] v)
        {
            unsafe
            {
                fixed (Single* v_ptr = v)
                {
                    Delegates.glVertexAttrib2fv((UInt32)index, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib2fv(Int32 index, Single[] v)
        {
            unsafe
            {
                fixed (Single* v_ptr = v)
                {
                    Delegates.glVertexAttrib2fv((UInt32)index, (Single*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib2fv(UInt32 index, ref Single v)
        {
            unsafe
            {
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glVertexAttrib2fv((UInt32)index, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib2fv(Int32 index, ref Single v)
        {
            unsafe
            {
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glVertexAttrib2fv((UInt32)index, (Single*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib2fv(UInt32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib2fv((UInt32)index, (Single*)v);
            }
        }

        public static 
        void glVertexAttrib2fv(Int32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib2fv((UInt32)index, (Single*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib2s(UInt32 index, Int16 x, Int16 y)
        {
            Delegates.glVertexAttrib2s((UInt32)index, (Int16)x, (Int16)y);
        }

        public static 
        void glVertexAttrib2s(Int32 index, Int16 x, Int16 y)
        {
            Delegates.glVertexAttrib2s((UInt32)index, (Int16)x, (Int16)y);
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib2sv(UInt32 index, Int16[] v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = v)
                {
                    Delegates.glVertexAttrib2sv((UInt32)index, (Int16*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib2sv(Int32 index, Int16[] v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = v)
                {
                    Delegates.glVertexAttrib2sv((UInt32)index, (Int16*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib2sv(UInt32 index, ref Int16 v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = &v)
                {
                    Delegates.glVertexAttrib2sv((UInt32)index, (Int16*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib2sv(Int32 index, ref Int16 v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = &v)
                {
                    Delegates.glVertexAttrib2sv((UInt32)index, (Int16*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib2sv(UInt32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib2sv((UInt32)index, (Int16*)v);
            }
        }

        public static 
        void glVertexAttrib2sv(Int32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib2sv((UInt32)index, (Int16*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib3d(UInt32 index, Double x, Double y, Double z)
        {
            Delegates.glVertexAttrib3d((UInt32)index, (Double)x, (Double)y, (Double)z);
        }

        public static 
        void glVertexAttrib3d(Int32 index, Double x, Double y, Double z)
        {
            Delegates.glVertexAttrib3d((UInt32)index, (Double)x, (Double)y, (Double)z);
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib3dv(UInt32 index, Double[] v)
        {
            unsafe
            {
                fixed (Double* v_ptr = v)
                {
                    Delegates.glVertexAttrib3dv((UInt32)index, (Double*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib3dv(Int32 index, Double[] v)
        {
            unsafe
            {
                fixed (Double* v_ptr = v)
                {
                    Delegates.glVertexAttrib3dv((UInt32)index, (Double*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib3dv(UInt32 index, ref Double v)
        {
            unsafe
            {
                fixed (Double* v_ptr = &v)
                {
                    Delegates.glVertexAttrib3dv((UInt32)index, (Double*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib3dv(Int32 index, ref Double v)
        {
            unsafe
            {
                fixed (Double* v_ptr = &v)
                {
                    Delegates.glVertexAttrib3dv((UInt32)index, (Double*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib3dv(UInt32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib3dv((UInt32)index, (Double*)v);
            }
        }

        public static 
        void glVertexAttrib3dv(Int32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib3dv((UInt32)index, (Double*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib3f(UInt32 index, Single x, Single y, Single z)
        {
            Delegates.glVertexAttrib3f((UInt32)index, (Single)x, (Single)y, (Single)z);
        }

        public static 
        void glVertexAttrib3f(Int32 index, Single x, Single y, Single z)
        {
            Delegates.glVertexAttrib3f((UInt32)index, (Single)x, (Single)y, (Single)z);
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib3fv(UInt32 index, Single[] v)
        {
            unsafe
            {
                fixed (Single* v_ptr = v)
                {
                    Delegates.glVertexAttrib3fv((UInt32)index, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib3fv(Int32 index, Single[] v)
        {
            unsafe
            {
                fixed (Single* v_ptr = v)
                {
                    Delegates.glVertexAttrib3fv((UInt32)index, (Single*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib3fv(UInt32 index, ref Single v)
        {
            unsafe
            {
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glVertexAttrib3fv((UInt32)index, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib3fv(Int32 index, ref Single v)
        {
            unsafe
            {
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glVertexAttrib3fv((UInt32)index, (Single*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib3fv(UInt32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib3fv((UInt32)index, (Single*)v);
            }
        }

        public static 
        void glVertexAttrib3fv(Int32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib3fv((UInt32)index, (Single*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib3s(UInt32 index, Int16 x, Int16 y, Int16 z)
        {
            Delegates.glVertexAttrib3s((UInt32)index, (Int16)x, (Int16)y, (Int16)z);
        }

        public static 
        void glVertexAttrib3s(Int32 index, Int16 x, Int16 y, Int16 z)
        {
            Delegates.glVertexAttrib3s((UInt32)index, (Int16)x, (Int16)y, (Int16)z);
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib3sv(UInt32 index, Int16[] v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = v)
                {
                    Delegates.glVertexAttrib3sv((UInt32)index, (Int16*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib3sv(Int32 index, Int16[] v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = v)
                {
                    Delegates.glVertexAttrib3sv((UInt32)index, (Int16*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib3sv(UInt32 index, ref Int16 v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = &v)
                {
                    Delegates.glVertexAttrib3sv((UInt32)index, (Int16*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib3sv(Int32 index, ref Int16 v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = &v)
                {
                    Delegates.glVertexAttrib3sv((UInt32)index, (Int16*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib3sv(UInt32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib3sv((UInt32)index, (Int16*)v);
            }
        }

        public static 
        void glVertexAttrib3sv(Int32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib3sv((UInt32)index, (Int16*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4Nbv(UInt32 index, SByte[] v)
        {
            unsafe
            {
                fixed (SByte* v_ptr = v)
                {
                    Delegates.glVertexAttrib4Nbv((UInt32)index, (SByte*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib4Nbv(Int32 index, Byte[] v)
        {
            unsafe
            {
                fixed (Byte* v_ptr = v)
                {
                    Delegates.glVertexAttrib4Nbv((UInt32)index, (SByte*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4Nbv(UInt32 index, ref SByte v)
        {
            unsafe
            {
                fixed (SByte* v_ptr = &v)
                {
                    Delegates.glVertexAttrib4Nbv((UInt32)index, (SByte*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib4Nbv(Int32 index, ref Byte v)
        {
            unsafe
            {
                fixed (Byte* v_ptr = &v)
                {
                    Delegates.glVertexAttrib4Nbv((UInt32)index, (SByte*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4Nbv(UInt32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib4Nbv((UInt32)index, (SByte*)v);
            }
        }

        public static 
        void glVertexAttrib4Nbv(Int32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib4Nbv((UInt32)index, (SByte*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4Niv(UInt32 index, Int32[] v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = v)
                {
                    Delegates.glVertexAttrib4Niv((UInt32)index, (Int32*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib4Niv(Int32 index, Int32[] v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = v)
                {
                    Delegates.glVertexAttrib4Niv((UInt32)index, (Int32*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4Niv(UInt32 index, ref Int32 v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = &v)
                {
                    Delegates.glVertexAttrib4Niv((UInt32)index, (Int32*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib4Niv(Int32 index, ref Int32 v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = &v)
                {
                    Delegates.glVertexAttrib4Niv((UInt32)index, (Int32*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4Niv(UInt32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib4Niv((UInt32)index, (Int32*)v);
            }
        }

        public static 
        void glVertexAttrib4Niv(Int32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib4Niv((UInt32)index, (Int32*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4Nsv(UInt32 index, Int16[] v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = v)
                {
                    Delegates.glVertexAttrib4Nsv((UInt32)index, (Int16*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib4Nsv(Int32 index, Int16[] v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = v)
                {
                    Delegates.glVertexAttrib4Nsv((UInt32)index, (Int16*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4Nsv(UInt32 index, ref Int16 v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = &v)
                {
                    Delegates.glVertexAttrib4Nsv((UInt32)index, (Int16*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib4Nsv(Int32 index, ref Int16 v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = &v)
                {
                    Delegates.glVertexAttrib4Nsv((UInt32)index, (Int16*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4Nsv(UInt32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib4Nsv((UInt32)index, (Int16*)v);
            }
        }

        public static 
        void glVertexAttrib4Nsv(Int32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib4Nsv((UInt32)index, (Int16*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4Nub(UInt32 index, Byte x, Byte y, Byte z, Byte w)
        {
            Delegates.glVertexAttrib4Nub((UInt32)index, (Byte)x, (Byte)y, (Byte)z, (Byte)w);
        }

        public static 
        void glVertexAttrib4Nub(Int32 index, Byte x, Byte y, Byte z, Byte w)
        {
            Delegates.glVertexAttrib4Nub((UInt32)index, (Byte)x, (Byte)y, (Byte)z, (Byte)w);
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4Nubv(UInt32 index, Byte[] v)
        {
            unsafe
            {
                fixed (Byte* v_ptr = v)
                {
                    Delegates.glVertexAttrib4Nubv((UInt32)index, (Byte*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib4Nubv(Int32 index, Byte[] v)
        {
            unsafe
            {
                fixed (Byte* v_ptr = v)
                {
                    Delegates.glVertexAttrib4Nubv((UInt32)index, (Byte*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4Nubv(UInt32 index, ref Byte v)
        {
            unsafe
            {
                fixed (Byte* v_ptr = &v)
                {
                    Delegates.glVertexAttrib4Nubv((UInt32)index, (Byte*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib4Nubv(Int32 index, ref Byte v)
        {
            unsafe
            {
                fixed (Byte* v_ptr = &v)
                {
                    Delegates.glVertexAttrib4Nubv((UInt32)index, (Byte*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4Nubv(UInt32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib4Nubv((UInt32)index, (Byte*)v);
            }
        }

        public static 
        void glVertexAttrib4Nubv(Int32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib4Nubv((UInt32)index, (Byte*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4Nuiv(UInt32 index, UInt32[] v)
        {
            unsafe
            {
                fixed (UInt32* v_ptr = v)
                {
                    Delegates.glVertexAttrib4Nuiv((UInt32)index, (UInt32*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib4Nuiv(Int32 index, Int32[] v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = v)
                {
                    Delegates.glVertexAttrib4Nuiv((UInt32)index, (UInt32*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4Nuiv(UInt32 index, ref UInt32 v)
        {
            unsafe
            {
                fixed (UInt32* v_ptr = &v)
                {
                    Delegates.glVertexAttrib4Nuiv((UInt32)index, (UInt32*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib4Nuiv(Int32 index, ref Int32 v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = &v)
                {
                    Delegates.glVertexAttrib4Nuiv((UInt32)index, (UInt32*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4Nuiv(UInt32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib4Nuiv((UInt32)index, (UInt32*)v);
            }
        }

        public static 
        void glVertexAttrib4Nuiv(Int32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib4Nuiv((UInt32)index, (UInt32*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4Nusv(UInt32 index, UInt16[] v)
        {
            unsafe
            {
                fixed (UInt16* v_ptr = v)
                {
                    Delegates.glVertexAttrib4Nusv((UInt32)index, (UInt16*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib4Nusv(Int32 index, Int16[] v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = v)
                {
                    Delegates.glVertexAttrib4Nusv((UInt32)index, (UInt16*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4Nusv(UInt32 index, ref UInt16 v)
        {
            unsafe
            {
                fixed (UInt16* v_ptr = &v)
                {
                    Delegates.glVertexAttrib4Nusv((UInt32)index, (UInt16*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib4Nusv(Int32 index, ref Int16 v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = &v)
                {
                    Delegates.glVertexAttrib4Nusv((UInt32)index, (UInt16*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4Nusv(UInt32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib4Nusv((UInt32)index, (UInt16*)v);
            }
        }

        public static 
        void glVertexAttrib4Nusv(Int32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib4Nusv((UInt32)index, (UInt16*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4bv(UInt32 index, SByte[] v)
        {
            unsafe
            {
                fixed (SByte* v_ptr = v)
                {
                    Delegates.glVertexAttrib4bv((UInt32)index, (SByte*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib4bv(Int32 index, Byte[] v)
        {
            unsafe
            {
                fixed (Byte* v_ptr = v)
                {
                    Delegates.glVertexAttrib4bv((UInt32)index, (SByte*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4bv(UInt32 index, ref SByte v)
        {
            unsafe
            {
                fixed (SByte* v_ptr = &v)
                {
                    Delegates.glVertexAttrib4bv((UInt32)index, (SByte*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib4bv(Int32 index, ref Byte v)
        {
            unsafe
            {
                fixed (Byte* v_ptr = &v)
                {
                    Delegates.glVertexAttrib4bv((UInt32)index, (SByte*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4bv(UInt32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib4bv((UInt32)index, (SByte*)v);
            }
        }

        public static 
        void glVertexAttrib4bv(Int32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib4bv((UInt32)index, (SByte*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4d(UInt32 index, Double x, Double y, Double z, Double w)
        {
            Delegates.glVertexAttrib4d((UInt32)index, (Double)x, (Double)y, (Double)z, (Double)w);
        }

        public static 
        void glVertexAttrib4d(Int32 index, Double x, Double y, Double z, Double w)
        {
            Delegates.glVertexAttrib4d((UInt32)index, (Double)x, (Double)y, (Double)z, (Double)w);
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4dv(UInt32 index, Double[] v)
        {
            unsafe
            {
                fixed (Double* v_ptr = v)
                {
                    Delegates.glVertexAttrib4dv((UInt32)index, (Double*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib4dv(Int32 index, Double[] v)
        {
            unsafe
            {
                fixed (Double* v_ptr = v)
                {
                    Delegates.glVertexAttrib4dv((UInt32)index, (Double*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4dv(UInt32 index, ref Double v)
        {
            unsafe
            {
                fixed (Double* v_ptr = &v)
                {
                    Delegates.glVertexAttrib4dv((UInt32)index, (Double*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib4dv(Int32 index, ref Double v)
        {
            unsafe
            {
                fixed (Double* v_ptr = &v)
                {
                    Delegates.glVertexAttrib4dv((UInt32)index, (Double*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4dv(UInt32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib4dv((UInt32)index, (Double*)v);
            }
        }

        public static 
        void glVertexAttrib4dv(Int32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib4dv((UInt32)index, (Double*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4f(UInt32 index, Single x, Single y, Single z, Single w)
        {
            Delegates.glVertexAttrib4f((UInt32)index, (Single)x, (Single)y, (Single)z, (Single)w);
        }

        public static 
        void glVertexAttrib4f(Int32 index, Single x, Single y, Single z, Single w)
        {
            Delegates.glVertexAttrib4f((UInt32)index, (Single)x, (Single)y, (Single)z, (Single)w);
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4fv(UInt32 index, Single[] v)
        {
            unsafe
            {
                fixed (Single* v_ptr = v)
                {
                    Delegates.glVertexAttrib4fv((UInt32)index, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib4fv(Int32 index, Single[] v)
        {
            unsafe
            {
                fixed (Single* v_ptr = v)
                {
                    Delegates.glVertexAttrib4fv((UInt32)index, (Single*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4fv(UInt32 index, ref Single v)
        {
            unsafe
            {
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glVertexAttrib4fv((UInt32)index, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib4fv(Int32 index, ref Single v)
        {
            unsafe
            {
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glVertexAttrib4fv((UInt32)index, (Single*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4fv(UInt32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib4fv((UInt32)index, (Single*)v);
            }
        }

        public static 
        void glVertexAttrib4fv(Int32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib4fv((UInt32)index, (Single*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4iv(UInt32 index, Int32[] v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = v)
                {
                    Delegates.glVertexAttrib4iv((UInt32)index, (Int32*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib4iv(Int32 index, Int32[] v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = v)
                {
                    Delegates.glVertexAttrib4iv((UInt32)index, (Int32*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4iv(UInt32 index, ref Int32 v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = &v)
                {
                    Delegates.glVertexAttrib4iv((UInt32)index, (Int32*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib4iv(Int32 index, ref Int32 v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = &v)
                {
                    Delegates.glVertexAttrib4iv((UInt32)index, (Int32*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4iv(UInt32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib4iv((UInt32)index, (Int32*)v);
            }
        }

        public static 
        void glVertexAttrib4iv(Int32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib4iv((UInt32)index, (Int32*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4s(UInt32 index, Int16 x, Int16 y, Int16 z, Int16 w)
        {
            Delegates.glVertexAttrib4s((UInt32)index, (Int16)x, (Int16)y, (Int16)z, (Int16)w);
        }

        public static 
        void glVertexAttrib4s(Int32 index, Int16 x, Int16 y, Int16 z, Int16 w)
        {
            Delegates.glVertexAttrib4s((UInt32)index, (Int16)x, (Int16)y, (Int16)z, (Int16)w);
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4sv(UInt32 index, Int16[] v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = v)
                {
                    Delegates.glVertexAttrib4sv((UInt32)index, (Int16*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib4sv(Int32 index, Int16[] v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = v)
                {
                    Delegates.glVertexAttrib4sv((UInt32)index, (Int16*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4sv(UInt32 index, ref Int16 v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = &v)
                {
                    Delegates.glVertexAttrib4sv((UInt32)index, (Int16*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib4sv(Int32 index, ref Int16 v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = &v)
                {
                    Delegates.glVertexAttrib4sv((UInt32)index, (Int16*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4sv(UInt32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib4sv((UInt32)index, (Int16*)v);
            }
        }

        public static 
        void glVertexAttrib4sv(Int32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib4sv((UInt32)index, (Int16*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4ubv(UInt32 index, Byte[] v)
        {
            unsafe
            {
                fixed (Byte* v_ptr = v)
                {
                    Delegates.glVertexAttrib4ubv((UInt32)index, (Byte*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib4ubv(Int32 index, Byte[] v)
        {
            unsafe
            {
                fixed (Byte* v_ptr = v)
                {
                    Delegates.glVertexAttrib4ubv((UInt32)index, (Byte*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4ubv(UInt32 index, ref Byte v)
        {
            unsafe
            {
                fixed (Byte* v_ptr = &v)
                {
                    Delegates.glVertexAttrib4ubv((UInt32)index, (Byte*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib4ubv(Int32 index, ref Byte v)
        {
            unsafe
            {
                fixed (Byte* v_ptr = &v)
                {
                    Delegates.glVertexAttrib4ubv((UInt32)index, (Byte*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4ubv(UInt32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib4ubv((UInt32)index, (Byte*)v);
            }
        }

        public static 
        void glVertexAttrib4ubv(Int32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib4ubv((UInt32)index, (Byte*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4uiv(UInt32 index, UInt32[] v)
        {
            unsafe
            {
                fixed (UInt32* v_ptr = v)
                {
                    Delegates.glVertexAttrib4uiv((UInt32)index, (UInt32*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib4uiv(Int32 index, Int32[] v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = v)
                {
                    Delegates.glVertexAttrib4uiv((UInt32)index, (UInt32*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4uiv(UInt32 index, ref UInt32 v)
        {
            unsafe
            {
                fixed (UInt32* v_ptr = &v)
                {
                    Delegates.glVertexAttrib4uiv((UInt32)index, (UInt32*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib4uiv(Int32 index, ref Int32 v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = &v)
                {
                    Delegates.glVertexAttrib4uiv((UInt32)index, (UInt32*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4uiv(UInt32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib4uiv((UInt32)index, (UInt32*)v);
            }
        }

        public static 
        void glVertexAttrib4uiv(Int32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib4uiv((UInt32)index, (UInt32*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4usv(UInt32 index, UInt16[] v)
        {
            unsafe
            {
                fixed (UInt16* v_ptr = v)
                {
                    Delegates.glVertexAttrib4usv((UInt32)index, (UInt16*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib4usv(Int32 index, Int16[] v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = v)
                {
                    Delegates.glVertexAttrib4usv((UInt32)index, (UInt16*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4usv(UInt32 index, ref UInt16 v)
        {
            unsafe
            {
                fixed (UInt16* v_ptr = &v)
                {
                    Delegates.glVertexAttrib4usv((UInt32)index, (UInt16*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib4usv(Int32 index, ref Int16 v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = &v)
                {
                    Delegates.glVertexAttrib4usv((UInt32)index, (UInt16*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4usv(UInt32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib4usv((UInt32)index, (UInt16*)v);
            }
        }

        public static 
        void glVertexAttrib4usv(Int32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib4usv((UInt32)index, (UInt16*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttribPointer(UInt32 index, Int32 size, int type, bool normalized, Int32 stride, IntPtr pointer)
        {
            unsafe
            {
                Delegates.glVertexAttribPointer((UInt32)index, (Int32)size, (int)type, (bool)normalized, (Int32)stride, (IntPtr)pointer);
            }
        }

        public static 
        void glVertexAttribPointer(Int32 index, Int32 size, int type, bool normalized, Int32 stride, IntPtr pointer)
        {
            unsafe
            {
                Delegates.glVertexAttribPointer((UInt32)index, (Int32)size, (int)type, (bool)normalized, (Int32)stride, (IntPtr)pointer);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttribPointer(UInt32 index, Int32 size, int type, bool normalized, Int32 stride, [In, Out] object pointer)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle pointer_ptr = System.Runtime.InteropServices.GCHandle.Alloc(pointer, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glVertexAttribPointer((UInt32)index, (Int32)size, (int)type, (bool)normalized, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
            }
        }

        public static 
        void glVertexAttribPointer(Int32 index, Int32 size, int type, bool normalized, Int32 stride, [In, Out] object pointer)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle pointer_ptr = System.Runtime.InteropServices.GCHandle.Alloc(pointer, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glVertexAttribPointer((UInt32)index, (Int32)size, (int)type, (bool)normalized, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
            }
        }

        public static 
        void glUniformMatrix2x3fv(Int32 location, Int32 count, bool transpose, Single[] value)
        {
            unsafe
            {
                fixed (Single* value_ptr = value)
                {
                    Delegates.glUniformMatrix2x3fv((Int32)location, (Int32)count, (bool)transpose, (Single*)value_ptr);
                }
            }
        }

        public static 
        void glUniformMatrix2x3fv(Int32 location, Int32 count, bool transpose, ref Single value)
        {
            unsafe
            {
                fixed (Single* value_ptr = &value)
                {
                    Delegates.glUniformMatrix2x3fv((Int32)location, (Int32)count, (bool)transpose, (Single*)value_ptr);
                }
            }
        }

        public static 
        void glUniformMatrix2x3fv(Int32 location, Int32 count, bool transpose, IntPtr value)
        {
            unsafe
            {
                Delegates.glUniformMatrix2x3fv((Int32)location, (Int32)count, (bool)transpose, (Single*)value);
            }
        }

        public static 
        void glUniformMatrix3x2fv(Int32 location, Int32 count, bool transpose, Single[] value)
        {
            unsafe
            {
                fixed (Single* value_ptr = value)
                {
                    Delegates.glUniformMatrix3x2fv((Int32)location, (Int32)count, (bool)transpose, (Single*)value_ptr);
                }
            }
        }

        public static 
        void glUniformMatrix3x2fv(Int32 location, Int32 count, bool transpose, ref Single value)
        {
            unsafe
            {
                fixed (Single* value_ptr = &value)
                {
                    Delegates.glUniformMatrix3x2fv((Int32)location, (Int32)count, (bool)transpose, (Single*)value_ptr);
                }
            }
        }

        public static 
        void glUniformMatrix3x2fv(Int32 location, Int32 count, bool transpose, IntPtr value)
        {
            unsafe
            {
                Delegates.glUniformMatrix3x2fv((Int32)location, (Int32)count, (bool)transpose, (Single*)value);
            }
        }

        public static 
        void glUniformMatrix2x4fv(Int32 location, Int32 count, bool transpose, Single[] value)
        {
            unsafe
            {
                fixed (Single* value_ptr = value)
                {
                    Delegates.glUniformMatrix2x4fv((Int32)location, (Int32)count, (bool)transpose, (Single*)value_ptr);
                }
            }
        }

        public static 
        void glUniformMatrix2x4fv(Int32 location, Int32 count, bool transpose, ref Single value)
        {
            unsafe
            {
                fixed (Single* value_ptr = &value)
                {
                    Delegates.glUniformMatrix2x4fv((Int32)location, (Int32)count, (bool)transpose, (Single*)value_ptr);
                }
            }
        }

        public static 
        void glUniformMatrix2x4fv(Int32 location, Int32 count, bool transpose, IntPtr value)
        {
            unsafe
            {
                Delegates.glUniformMatrix2x4fv((Int32)location, (Int32)count, (bool)transpose, (Single*)value);
            }
        }

        public static 
        void glUniformMatrix4x2fv(Int32 location, Int32 count, bool transpose, Single[] value)
        {
            unsafe
            {
                fixed (Single* value_ptr = value)
                {
                    Delegates.glUniformMatrix4x2fv((Int32)location, (Int32)count, (bool)transpose, (Single*)value_ptr);
                }
            }
        }

        public static 
        void glUniformMatrix4x2fv(Int32 location, Int32 count, bool transpose, ref Single value)
        {
            unsafe
            {
                fixed (Single* value_ptr = &value)
                {
                    Delegates.glUniformMatrix4x2fv((Int32)location, (Int32)count, (bool)transpose, (Single*)value_ptr);
                }
            }
        }

        public static 
        void glUniformMatrix4x2fv(Int32 location, Int32 count, bool transpose, IntPtr value)
        {
            unsafe
            {
                Delegates.glUniformMatrix4x2fv((Int32)location, (Int32)count, (bool)transpose, (Single*)value);
            }
        }

        public static 
        void glUniformMatrix3x4fv(Int32 location, Int32 count, bool transpose, Single[] value)
        {
            unsafe
            {
                fixed (Single* value_ptr = value)
                {
                    Delegates.glUniformMatrix3x4fv((Int32)location, (Int32)count, (bool)transpose, (Single*)value_ptr);
                }
            }
        }

        public static 
        void glUniformMatrix3x4fv(Int32 location, Int32 count, bool transpose, ref Single value)
        {
            unsafe
            {
                fixed (Single* value_ptr = &value)
                {
                    Delegates.glUniformMatrix3x4fv((Int32)location, (Int32)count, (bool)transpose, (Single*)value_ptr);
                }
            }
        }

        public static 
        void glUniformMatrix3x4fv(Int32 location, Int32 count, bool transpose, IntPtr value)
        {
            unsafe
            {
                Delegates.glUniformMatrix3x4fv((Int32)location, (Int32)count, (bool)transpose, (Single*)value);
            }
        }

        public static 
        void glUniformMatrix4x3fv(Int32 location, Int32 count, bool transpose, Single[] value)
        {
            unsafe
            {
                fixed (Single* value_ptr = value)
                {
                    Delegates.glUniformMatrix4x3fv((Int32)location, (Int32)count, (bool)transpose, (Single*)value_ptr);
                }
            }
        }

        public static 
        void glUniformMatrix4x3fv(Int32 location, Int32 count, bool transpose, ref Single value)
        {
            unsafe
            {
                fixed (Single* value_ptr = &value)
                {
                    Delegates.glUniformMatrix4x3fv((Int32)location, (Int32)count, (bool)transpose, (Single*)value_ptr);
                }
            }
        }

        public static 
        void glUniformMatrix4x3fv(Int32 location, Int32 count, bool transpose, IntPtr value)
        {
            unsafe
            {
                Delegates.glUniformMatrix4x3fv((Int32)location, (Int32)count, (bool)transpose, (Single*)value);
            }
        }

        public static 
        void glActiveTextureARB(int texture)
        {
            Delegates.glActiveTextureARB((int)texture);
        }

        public static 
        void glClientActiveTextureARB(int texture)
        {
            Delegates.glClientActiveTextureARB((int)texture);
        }

        public static 
        void glMultiTexCoord1dARB(int target, Double s)
        {
            Delegates.glMultiTexCoord1dARB((int)target, (Double)s);
        }

        public static 
        void glMultiTexCoord1dvARB(int target, Double[] v)
        {
            unsafe
            {
                fixed (Double* v_ptr = v)
                {
                    Delegates.glMultiTexCoord1dvARB((int)target, (Double*)v_ptr);
                }
            }
        }

        public static 
        void glMultiTexCoord1dvARB(int target, ref Double v)
        {
            unsafe
            {
                fixed (Double* v_ptr = &v)
                {
                    Delegates.glMultiTexCoord1dvARB((int)target, (Double*)v_ptr);
                }
            }
        }

        public static 
        void glMultiTexCoord1dvARB(int target, IntPtr v)
        {
            unsafe
            {
                Delegates.glMultiTexCoord1dvARB((int)target, (Double*)v);
            }
        }

        public static 
        void glMultiTexCoord1fARB(int target, Single s)
        {
            Delegates.glMultiTexCoord1fARB((int)target, (Single)s);
        }

        public static 
        void glMultiTexCoord1fvARB(int target, Single[] v)
        {
            unsafe
            {
                fixed (Single* v_ptr = v)
                {
                    Delegates.glMultiTexCoord1fvARB((int)target, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glMultiTexCoord1fvARB(int target, ref Single v)
        {
            unsafe
            {
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glMultiTexCoord1fvARB((int)target, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glMultiTexCoord1fvARB(int target, IntPtr v)
        {
            unsafe
            {
                Delegates.glMultiTexCoord1fvARB((int)target, (Single*)v);
            }
        }

        public static 
        void glMultiTexCoord1iARB(int target, Int32 s)
        {
            Delegates.glMultiTexCoord1iARB((int)target, (Int32)s);
        }

        public static 
        void glMultiTexCoord1ivARB(int target, Int32[] v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = v)
                {
                    Delegates.glMultiTexCoord1ivARB((int)target, (Int32*)v_ptr);
                }
            }
        }

        public static 
        void glMultiTexCoord1ivARB(int target, ref Int32 v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = &v)
                {
                    Delegates.glMultiTexCoord1ivARB((int)target, (Int32*)v_ptr);
                }
            }
        }

        public static 
        void glMultiTexCoord1ivARB(int target, IntPtr v)
        {
            unsafe
            {
                Delegates.glMultiTexCoord1ivARB((int)target, (Int32*)v);
            }
        }

        public static 
        void glMultiTexCoord1sARB(int target, Int16 s)
        {
            Delegates.glMultiTexCoord1sARB((int)target, (Int16)s);
        }

        public static 
        void glMultiTexCoord1svARB(int target, Int16[] v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = v)
                {
                    Delegates.glMultiTexCoord1svARB((int)target, (Int16*)v_ptr);
                }
            }
        }

        public static 
        void glMultiTexCoord1svARB(int target, ref Int16 v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = &v)
                {
                    Delegates.glMultiTexCoord1svARB((int)target, (Int16*)v_ptr);
                }
            }
        }

        public static 
        void glMultiTexCoord1svARB(int target, IntPtr v)
        {
            unsafe
            {
                Delegates.glMultiTexCoord1svARB((int)target, (Int16*)v);
            }
        }

        public static 
        void glMultiTexCoord2dARB(int target, Double s, Double t)
        {
            Delegates.glMultiTexCoord2dARB((int)target, (Double)s, (Double)t);
        }

        public static 
        void glMultiTexCoord2dvARB(int target, Double[] v)
        {
            unsafe
            {
                fixed (Double* v_ptr = v)
                {
                    Delegates.glMultiTexCoord2dvARB((int)target, (Double*)v_ptr);
                }
            }
        }

        public static 
        void glMultiTexCoord2dvARB(int target, ref Double v)
        {
            unsafe
            {
                fixed (Double* v_ptr = &v)
                {
                    Delegates.glMultiTexCoord2dvARB((int)target, (Double*)v_ptr);
                }
            }
        }

        public static 
        void glMultiTexCoord2dvARB(int target, IntPtr v)
        {
            unsafe
            {
                Delegates.glMultiTexCoord2dvARB((int)target, (Double*)v);
            }
        }

        public static 
        void glMultiTexCoord2fARB(int target, Single s, Single t)
        {
            Delegates.glMultiTexCoord2fARB((int)target, (Single)s, (Single)t);
        }

        public static 
        void glMultiTexCoord2fvARB(int target, Single[] v)
        {
            unsafe
            {
                fixed (Single* v_ptr = v)
                {
                    Delegates.glMultiTexCoord2fvARB((int)target, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glMultiTexCoord2fvARB(int target, ref Single v)
        {
            unsafe
            {
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glMultiTexCoord2fvARB((int)target, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glMultiTexCoord2fvARB(int target, IntPtr v)
        {
            unsafe
            {
                Delegates.glMultiTexCoord2fvARB((int)target, (Single*)v);
            }
        }

        public static 
        void glMultiTexCoord2iARB(int target, Int32 s, Int32 t)
        {
            Delegates.glMultiTexCoord2iARB((int)target, (Int32)s, (Int32)t);
        }

        public static 
        void glMultiTexCoord2ivARB(int target, Int32[] v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = v)
                {
                    Delegates.glMultiTexCoord2ivARB((int)target, (Int32*)v_ptr);
                }
            }
        }

        public static 
        void glMultiTexCoord2ivARB(int target, ref Int32 v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = &v)
                {
                    Delegates.glMultiTexCoord2ivARB((int)target, (Int32*)v_ptr);
                }
            }
        }

        public static 
        void glMultiTexCoord2ivARB(int target, IntPtr v)
        {
            unsafe
            {
                Delegates.glMultiTexCoord2ivARB((int)target, (Int32*)v);
            }
        }

        public static 
        void glMultiTexCoord2sARB(int target, Int16 s, Int16 t)
        {
            Delegates.glMultiTexCoord2sARB((int)target, (Int16)s, (Int16)t);
        }

        public static 
        void glMultiTexCoord2svARB(int target, Int16[] v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = v)
                {
                    Delegates.glMultiTexCoord2svARB((int)target, (Int16*)v_ptr);
                }
            }
        }

        public static 
        void glMultiTexCoord2svARB(int target, ref Int16 v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = &v)
                {
                    Delegates.glMultiTexCoord2svARB((int)target, (Int16*)v_ptr);
                }
            }
        }

        public static 
        void glMultiTexCoord2svARB(int target, IntPtr v)
        {
            unsafe
            {
                Delegates.glMultiTexCoord2svARB((int)target, (Int16*)v);
            }
        }

        public static 
        void glMultiTexCoord3dARB(int target, Double s, Double t, Double r)
        {
            Delegates.glMultiTexCoord3dARB((int)target, (Double)s, (Double)t, (Double)r);
        }

        public static 
        void glMultiTexCoord3dvARB(int target, Double[] v)
        {
            unsafe
            {
                fixed (Double* v_ptr = v)
                {
                    Delegates.glMultiTexCoord3dvARB((int)target, (Double*)v_ptr);
                }
            }
        }

        public static 
        void glMultiTexCoord3dvARB(int target, ref Double v)
        {
            unsafe
            {
                fixed (Double* v_ptr = &v)
                {
                    Delegates.glMultiTexCoord3dvARB((int)target, (Double*)v_ptr);
                }
            }
        }

        public static 
        void glMultiTexCoord3dvARB(int target, IntPtr v)
        {
            unsafe
            {
                Delegates.glMultiTexCoord3dvARB((int)target, (Double*)v);
            }
        }

        public static 
        void glMultiTexCoord3fARB(int target, Single s, Single t, Single r)
        {
            Delegates.glMultiTexCoord3fARB((int)target, (Single)s, (Single)t, (Single)r);
        }

        public static 
        void glMultiTexCoord3fvARB(int target, Single[] v)
        {
            unsafe
            {
                fixed (Single* v_ptr = v)
                {
                    Delegates.glMultiTexCoord3fvARB((int)target, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glMultiTexCoord3fvARB(int target, ref Single v)
        {
            unsafe
            {
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glMultiTexCoord3fvARB((int)target, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glMultiTexCoord3fvARB(int target, IntPtr v)
        {
            unsafe
            {
                Delegates.glMultiTexCoord3fvARB((int)target, (Single*)v);
            }
        }

        public static 
        void glMultiTexCoord3iARB(int target, Int32 s, Int32 t, Int32 r)
        {
            Delegates.glMultiTexCoord3iARB((int)target, (Int32)s, (Int32)t, (Int32)r);
        }

        public static 
        void glMultiTexCoord3ivARB(int target, Int32[] v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = v)
                {
                    Delegates.glMultiTexCoord3ivARB((int)target, (Int32*)v_ptr);
                }
            }
        }

        public static 
        void glMultiTexCoord3ivARB(int target, ref Int32 v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = &v)
                {
                    Delegates.glMultiTexCoord3ivARB((int)target, (Int32*)v_ptr);
                }
            }
        }

        public static 
        void glMultiTexCoord3ivARB(int target, IntPtr v)
        {
            unsafe
            {
                Delegates.glMultiTexCoord3ivARB((int)target, (Int32*)v);
            }
        }

        public static 
        void glMultiTexCoord3sARB(int target, Int16 s, Int16 t, Int16 r)
        {
            Delegates.glMultiTexCoord3sARB((int)target, (Int16)s, (Int16)t, (Int16)r);
        }

        public static 
        void glMultiTexCoord3svARB(int target, Int16[] v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = v)
                {
                    Delegates.glMultiTexCoord3svARB((int)target, (Int16*)v_ptr);
                }
            }
        }

        public static 
        void glMultiTexCoord3svARB(int target, ref Int16 v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = &v)
                {
                    Delegates.glMultiTexCoord3svARB((int)target, (Int16*)v_ptr);
                }
            }
        }

        public static 
        void glMultiTexCoord3svARB(int target, IntPtr v)
        {
            unsafe
            {
                Delegates.glMultiTexCoord3svARB((int)target, (Int16*)v);
            }
        }

        public static 
        void glMultiTexCoord4dARB(int target, Double s, Double t, Double r, Double q)
        {
            Delegates.glMultiTexCoord4dARB((int)target, (Double)s, (Double)t, (Double)r, (Double)q);
        }

        public static 
        void glMultiTexCoord4dvARB(int target, Double[] v)
        {
            unsafe
            {
                fixed (Double* v_ptr = v)
                {
                    Delegates.glMultiTexCoord4dvARB((int)target, (Double*)v_ptr);
                }
            }
        }

        public static 
        void glMultiTexCoord4dvARB(int target, ref Double v)
        {
            unsafe
            {
                fixed (Double* v_ptr = &v)
                {
                    Delegates.glMultiTexCoord4dvARB((int)target, (Double*)v_ptr);
                }
            }
        }

        public static 
        void glMultiTexCoord4dvARB(int target, IntPtr v)
        {
            unsafe
            {
                Delegates.glMultiTexCoord4dvARB((int)target, (Double*)v);
            }
        }

        public static 
        void glMultiTexCoord4fARB(int target, Single s, Single t, Single r, Single q)
        {
            Delegates.glMultiTexCoord4fARB((int)target, (Single)s, (Single)t, (Single)r, (Single)q);
        }

        public static 
        void glMultiTexCoord4fvARB(int target, Single[] v)
        {
            unsafe
            {
                fixed (Single* v_ptr = v)
                {
                    Delegates.glMultiTexCoord4fvARB((int)target, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glMultiTexCoord4fvARB(int target, ref Single v)
        {
            unsafe
            {
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glMultiTexCoord4fvARB((int)target, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glMultiTexCoord4fvARB(int target, IntPtr v)
        {
            unsafe
            {
                Delegates.glMultiTexCoord4fvARB((int)target, (Single*)v);
            }
        }

        public static 
        void glMultiTexCoord4iARB(int target, Int32 s, Int32 t, Int32 r, Int32 q)
        {
            Delegates.glMultiTexCoord4iARB((int)target, (Int32)s, (Int32)t, (Int32)r, (Int32)q);
        }

        public static 
        void glMultiTexCoord4ivARB(int target, Int32[] v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = v)
                {
                    Delegates.glMultiTexCoord4ivARB((int)target, (Int32*)v_ptr);
                }
            }
        }

        public static 
        void glMultiTexCoord4ivARB(int target, ref Int32 v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = &v)
                {
                    Delegates.glMultiTexCoord4ivARB((int)target, (Int32*)v_ptr);
                }
            }
        }

        public static 
        void glMultiTexCoord4ivARB(int target, IntPtr v)
        {
            unsafe
            {
                Delegates.glMultiTexCoord4ivARB((int)target, (Int32*)v);
            }
        }

        public static 
        void glMultiTexCoord4sARB(int target, Int16 s, Int16 t, Int16 r, Int16 q)
        {
            Delegates.glMultiTexCoord4sARB((int)target, (Int16)s, (Int16)t, (Int16)r, (Int16)q);
        }

        public static 
        void glMultiTexCoord4svARB(int target, Int16[] v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = v)
                {
                    Delegates.glMultiTexCoord4svARB((int)target, (Int16*)v_ptr);
                }
            }
        }

        public static 
        void glMultiTexCoord4svARB(int target, ref Int16 v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = &v)
                {
                    Delegates.glMultiTexCoord4svARB((int)target, (Int16*)v_ptr);
                }
            }
        }

        public static 
        void glMultiTexCoord4svARB(int target, IntPtr v)
        {
            unsafe
            {
                Delegates.glMultiTexCoord4svARB((int)target, (Int16*)v);
            }
        }

        public static 
        void glLoadTransposeMatrixfARB(Single[] m)
        {
            unsafe
            {
                fixed (Single* m_ptr = m)
                {
                    Delegates.glLoadTransposeMatrixfARB((Single*)m_ptr);
                }
            }
        }

        public static 
        void glLoadTransposeMatrixfARB(ref Single m)
        {
            unsafe
            {
                fixed (Single* m_ptr = &m)
                {
                    Delegates.glLoadTransposeMatrixfARB((Single*)m_ptr);
                }
            }
        }

        public static 
        void glLoadTransposeMatrixfARB(IntPtr m)
        {
            unsafe
            {
                Delegates.glLoadTransposeMatrixfARB((Single*)m);
            }
        }

        public static 
        void glLoadTransposeMatrixdARB(Double[] m)
        {
            unsafe
            {
                fixed (Double* m_ptr = m)
                {
                    Delegates.glLoadTransposeMatrixdARB((Double*)m_ptr);
                }
            }
        }

        public static 
        void glLoadTransposeMatrixdARB(ref Double m)
        {
            unsafe
            {
                fixed (Double* m_ptr = &m)
                {
                    Delegates.glLoadTransposeMatrixdARB((Double*)m_ptr);
                }
            }
        }

        public static 
        void glLoadTransposeMatrixdARB(IntPtr m)
        {
            unsafe
            {
                Delegates.glLoadTransposeMatrixdARB((Double*)m);
            }
        }

        public static 
        void glMultTransposeMatrixfARB(Single[] m)
        {
            unsafe
            {
                fixed (Single* m_ptr = m)
                {
                    Delegates.glMultTransposeMatrixfARB((Single*)m_ptr);
                }
            }
        }

        public static 
        void glMultTransposeMatrixfARB(ref Single m)
        {
            unsafe
            {
                fixed (Single* m_ptr = &m)
                {
                    Delegates.glMultTransposeMatrixfARB((Single*)m_ptr);
                }
            }
        }

        public static 
        void glMultTransposeMatrixfARB(IntPtr m)
        {
            unsafe
            {
                Delegates.glMultTransposeMatrixfARB((Single*)m);
            }
        }

        public static 
        void glMultTransposeMatrixdARB(Double[] m)
        {
            unsafe
            {
                fixed (Double* m_ptr = m)
                {
                    Delegates.glMultTransposeMatrixdARB((Double*)m_ptr);
                }
            }
        }

        public static 
        void glMultTransposeMatrixdARB(ref Double m)
        {
            unsafe
            {
                fixed (Double* m_ptr = &m)
                {
                    Delegates.glMultTransposeMatrixdARB((Double*)m_ptr);
                }
            }
        }

        public static 
        void glMultTransposeMatrixdARB(IntPtr m)
        {
            unsafe
            {
                Delegates.glMultTransposeMatrixdARB((Double*)m);
            }
        }

        public static 
        void glSampleCoverageARB(Single value, bool invert)
        {
            Delegates.glSampleCoverageARB((Single)value, (bool)invert);
        }

        public static 
        void glCompressedTexImage3DARB(int target, Int32 level, int internalformat, Int32 width, Int32 height, Int32 depth, Int32 border, Int32 imageSize, IntPtr data)
        {
            unsafe
            {
                Delegates.glCompressedTexImage3DARB((int)target, (Int32)level, (int)internalformat, (Int32)width, (Int32)height, (Int32)depth, (Int32)border, (Int32)imageSize, (IntPtr)data);
            }
        }

        public static 
        void glCompressedTexImage3DARB(int target, Int32 level, int internalformat, Int32 width, Int32 height, Int32 depth, Int32 border, Int32 imageSize, [In, Out] object data)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle data_ptr = System.Runtime.InteropServices.GCHandle.Alloc(data, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glCompressedTexImage3DARB((int)target, (Int32)level, (int)internalformat, (Int32)width, (Int32)height, (Int32)depth, (Int32)border, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    data_ptr.Free();
                }
            }
        }

        public static 
        void glCompressedTexImage2DARB(int target, Int32 level, int internalformat, Int32 width, Int32 height, Int32 border, Int32 imageSize, IntPtr data)
        {
            unsafe
            {
                Delegates.glCompressedTexImage2DARB((int)target, (Int32)level, (int)internalformat, (Int32)width, (Int32)height, (Int32)border, (Int32)imageSize, (IntPtr)data);
            }
        }

        public static 
        void glCompressedTexImage2DARB(int target, Int32 level, int internalformat, Int32 width, Int32 height, Int32 border, Int32 imageSize, [In, Out] object data)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle data_ptr = System.Runtime.InteropServices.GCHandle.Alloc(data, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glCompressedTexImage2DARB((int)target, (Int32)level, (int)internalformat, (Int32)width, (Int32)height, (Int32)border, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    data_ptr.Free();
                }
            }
        }

        public static 
        void glCompressedTexImage1DARB(int target, Int32 level, int internalformat, Int32 width, Int32 border, Int32 imageSize, IntPtr data)
        {
            unsafe
            {
                Delegates.glCompressedTexImage1DARB((int)target, (Int32)level, (int)internalformat, (Int32)width, (Int32)border, (Int32)imageSize, (IntPtr)data);
            }
        }

        public static 
        void glCompressedTexImage1DARB(int target, Int32 level, int internalformat, Int32 width, Int32 border, Int32 imageSize, [In, Out] object data)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle data_ptr = System.Runtime.InteropServices.GCHandle.Alloc(data, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glCompressedTexImage1DARB((int)target, (Int32)level, (int)internalformat, (Int32)width, (Int32)border, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    data_ptr.Free();
                }
            }
        }

        public static 
        void glCompressedTexSubImage3DARB(int target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 zoffset, Int32 width, Int32 height, Int32 depth, int format, Int32 imageSize, IntPtr data)
        {
            unsafe
            {
                Delegates.glCompressedTexSubImage3DARB((int)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)zoffset, (Int32)width, (Int32)height, (Int32)depth, (int)format, (Int32)imageSize, (IntPtr)data);
            }
        }

        public static 
        void glCompressedTexSubImage3DARB(int target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 zoffset, Int32 width, Int32 height, Int32 depth, int format, Int32 imageSize, [In, Out] object data)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle data_ptr = System.Runtime.InteropServices.GCHandle.Alloc(data, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glCompressedTexSubImage3DARB((int)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)zoffset, (Int32)width, (Int32)height, (Int32)depth, (int)format, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    data_ptr.Free();
                }
            }
        }

        public static 
        void glCompressedTexSubImage2DARB(int target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 width, Int32 height, int format, Int32 imageSize, IntPtr data)
        {
            unsafe
            {
                Delegates.glCompressedTexSubImage2DARB((int)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)width, (Int32)height, (int)format, (Int32)imageSize, (IntPtr)data);
            }
        }

        public static 
        void glCompressedTexSubImage2DARB(int target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 width, Int32 height, int format, Int32 imageSize, [In, Out] object data)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle data_ptr = System.Runtime.InteropServices.GCHandle.Alloc(data, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glCompressedTexSubImage2DARB((int)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)width, (Int32)height, (int)format, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    data_ptr.Free();
                }
            }
        }

        public static 
        void glCompressedTexSubImage1DARB(int target, Int32 level, Int32 xoffset, Int32 width, int format, Int32 imageSize, IntPtr data)
        {
            unsafe
            {
                Delegates.glCompressedTexSubImage1DARB((int)target, (Int32)level, (Int32)xoffset, (Int32)width, (int)format, (Int32)imageSize, (IntPtr)data);
            }
        }

        public static 
        void glCompressedTexSubImage1DARB(int target, Int32 level, Int32 xoffset, Int32 width, int format, Int32 imageSize, [In, Out] object data)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle data_ptr = System.Runtime.InteropServices.GCHandle.Alloc(data, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glCompressedTexSubImage1DARB((int)target, (Int32)level, (Int32)xoffset, (Int32)width, (int)format, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    data_ptr.Free();
                }
            }
        }

        public static 
        void glGetCompressedTexImageARB(int target, Int32 level, [Out] IntPtr img)
        {
            unsafe
            {
                Delegates.glGetCompressedTexImageARB((int)target, (Int32)level, (IntPtr)img);
            }
        }

        public static 
        void glGetCompressedTexImageARB(int target, Int32 level, [In, Out] object img)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle img_ptr = System.Runtime.InteropServices.GCHandle.Alloc(img, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glGetCompressedTexImageARB((int)target, (Int32)level, (IntPtr)img_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    img_ptr.Free();
                }
            }
        }

        public static 
        void glPointParameterfARB(int pname, Single param)
        {
            Delegates.glPointParameterfARB((int)pname, (Single)param);
        }

        public static 
        void glPointParameterfvARB(int pname, Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glPointParameterfvARB((int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glPointParameterfvARB(int pname, ref Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glPointParameterfvARB((int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glPointParameterfvARB(int pname, IntPtr @params)
        {
            unsafe
            {
                Delegates.glPointParameterfvARB((int)pname, (Single*)@params);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glWeightbvARB(Int32 size, SByte[] weights)
        {
            unsafe
            {
                fixed (SByte* weights_ptr = weights)
                {
                    Delegates.glWeightbvARB((Int32)size, (SByte*)weights_ptr);
                }
            }
        }

        public static 
        void glWeightbvARB(Int32 size, Byte[] weights)
        {
            unsafe
            {
                fixed (Byte* weights_ptr = weights)
                {
                    Delegates.glWeightbvARB((Int32)size, (SByte*)weights_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glWeightbvARB(Int32 size, ref SByte weights)
        {
            unsafe
            {
                fixed (SByte* weights_ptr = &weights)
                {
                    Delegates.glWeightbvARB((Int32)size, (SByte*)weights_ptr);
                }
            }
        }

        public static 
        void glWeightbvARB(Int32 size, ref Byte weights)
        {
            unsafe
            {
                fixed (Byte* weights_ptr = &weights)
                {
                    Delegates.glWeightbvARB((Int32)size, (SByte*)weights_ptr);
                }
            }
        }

        public static 
        void glWeightbvARB(Int32 size, IntPtr weights)
        {
            unsafe
            {
                Delegates.glWeightbvARB((Int32)size, (SByte*)weights);
            }
        }

        public static 
        void glWeightsvARB(Int32 size, Int16[] weights)
        {
            unsafe
            {
                fixed (Int16* weights_ptr = weights)
                {
                    Delegates.glWeightsvARB((Int32)size, (Int16*)weights_ptr);
                }
            }
        }

        public static 
        void glWeightsvARB(Int32 size, ref Int16 weights)
        {
            unsafe
            {
                fixed (Int16* weights_ptr = &weights)
                {
                    Delegates.glWeightsvARB((Int32)size, (Int16*)weights_ptr);
                }
            }
        }

        public static 
        void glWeightsvARB(Int32 size, IntPtr weights)
        {
            unsafe
            {
                Delegates.glWeightsvARB((Int32)size, (Int16*)weights);
            }
        }

        public static 
        void glWeightivARB(Int32 size, Int32[] weights)
        {
            unsafe
            {
                fixed (Int32* weights_ptr = weights)
                {
                    Delegates.glWeightivARB((Int32)size, (Int32*)weights_ptr);
                }
            }
        }

        public static 
        void glWeightivARB(Int32 size, ref Int32 weights)
        {
            unsafe
            {
                fixed (Int32* weights_ptr = &weights)
                {
                    Delegates.glWeightivARB((Int32)size, (Int32*)weights_ptr);
                }
            }
        }

        public static 
        void glWeightivARB(Int32 size, IntPtr weights)
        {
            unsafe
            {
                Delegates.glWeightivARB((Int32)size, (Int32*)weights);
            }
        }

        public static 
        void glWeightfvARB(Int32 size, Single[] weights)
        {
            unsafe
            {
                fixed (Single* weights_ptr = weights)
                {
                    Delegates.glWeightfvARB((Int32)size, (Single*)weights_ptr);
                }
            }
        }

        public static 
        void glWeightfvARB(Int32 size, ref Single weights)
        {
            unsafe
            {
                fixed (Single* weights_ptr = &weights)
                {
                    Delegates.glWeightfvARB((Int32)size, (Single*)weights_ptr);
                }
            }
        }

        public static 
        void glWeightfvARB(Int32 size, IntPtr weights)
        {
            unsafe
            {
                Delegates.glWeightfvARB((Int32)size, (Single*)weights);
            }
        }

        public static 
        void glWeightdvARB(Int32 size, Double[] weights)
        {
            unsafe
            {
                fixed (Double* weights_ptr = weights)
                {
                    Delegates.glWeightdvARB((Int32)size, (Double*)weights_ptr);
                }
            }
        }

        public static 
        void glWeightdvARB(Int32 size, ref Double weights)
        {
            unsafe
            {
                fixed (Double* weights_ptr = &weights)
                {
                    Delegates.glWeightdvARB((Int32)size, (Double*)weights_ptr);
                }
            }
        }

        public static 
        void glWeightdvARB(Int32 size, IntPtr weights)
        {
            unsafe
            {
                Delegates.glWeightdvARB((Int32)size, (Double*)weights);
            }
        }

        public static 
        void glWeightubvARB(Int32 size, Byte[] weights)
        {
            unsafe
            {
                fixed (Byte* weights_ptr = weights)
                {
                    Delegates.glWeightubvARB((Int32)size, (Byte*)weights_ptr);
                }
            }
        }

        public static 
        void glWeightubvARB(Int32 size, ref Byte weights)
        {
            unsafe
            {
                fixed (Byte* weights_ptr = &weights)
                {
                    Delegates.glWeightubvARB((Int32)size, (Byte*)weights_ptr);
                }
            }
        }

        public static 
        void glWeightubvARB(Int32 size, IntPtr weights)
        {
            unsafe
            {
                Delegates.glWeightubvARB((Int32)size, (Byte*)weights);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glWeightusvARB(Int32 size, UInt16[] weights)
        {
            unsafe
            {
                fixed (UInt16* weights_ptr = weights)
                {
                    Delegates.glWeightusvARB((Int32)size, (UInt16*)weights_ptr);
                }
            }
        }

        public static 
        void glWeightusvARB(Int32 size, Int16[] weights)
        {
            unsafe
            {
                fixed (Int16* weights_ptr = weights)
                {
                    Delegates.glWeightusvARB((Int32)size, (UInt16*)weights_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glWeightusvARB(Int32 size, ref UInt16 weights)
        {
            unsafe
            {
                fixed (UInt16* weights_ptr = &weights)
                {
                    Delegates.glWeightusvARB((Int32)size, (UInt16*)weights_ptr);
                }
            }
        }

        public static 
        void glWeightusvARB(Int32 size, ref Int16 weights)
        {
            unsafe
            {
                fixed (Int16* weights_ptr = &weights)
                {
                    Delegates.glWeightusvARB((Int32)size, (UInt16*)weights_ptr);
                }
            }
        }

        public static 
        void glWeightusvARB(Int32 size, IntPtr weights)
        {
            unsafe
            {
                Delegates.glWeightusvARB((Int32)size, (UInt16*)weights);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glWeightuivARB(Int32 size, UInt32[] weights)
        {
            unsafe
            {
                fixed (UInt32* weights_ptr = weights)
                {
                    Delegates.glWeightuivARB((Int32)size, (UInt32*)weights_ptr);
                }
            }
        }

        public static 
        void glWeightuivARB(Int32 size, Int32[] weights)
        {
            unsafe
            {
                fixed (Int32* weights_ptr = weights)
                {
                    Delegates.glWeightuivARB((Int32)size, (UInt32*)weights_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glWeightuivARB(Int32 size, ref UInt32 weights)
        {
            unsafe
            {
                fixed (UInt32* weights_ptr = &weights)
                {
                    Delegates.glWeightuivARB((Int32)size, (UInt32*)weights_ptr);
                }
            }
        }

        public static 
        void glWeightuivARB(Int32 size, ref Int32 weights)
        {
            unsafe
            {
                fixed (Int32* weights_ptr = &weights)
                {
                    Delegates.glWeightuivARB((Int32)size, (UInt32*)weights_ptr);
                }
            }
        }

        public static 
        void glWeightuivARB(Int32 size, IntPtr weights)
        {
            unsafe
            {
                Delegates.glWeightuivARB((Int32)size, (UInt32*)weights);
            }
        }

        public static 
        void glWeightPointerARB(Int32 size, int type, Int32 stride, IntPtr pointer)
        {
            unsafe
            {
                Delegates.glWeightPointerARB((Int32)size, (int)type, (Int32)stride, (IntPtr)pointer);
            }
        }

        public static 
        void glWeightPointerARB(Int32 size, int type, Int32 stride, [In, Out] object pointer)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle pointer_ptr = System.Runtime.InteropServices.GCHandle.Alloc(pointer, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glWeightPointerARB((Int32)size, (int)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
            }
        }

        public static 
        void glVertexBlendARB(Int32 count)
        {
            Delegates.glVertexBlendARB((Int32)count);
        }

        public static 
        void glCurrentPaletteMatrixARB(Int32 index)
        {
            Delegates.glCurrentPaletteMatrixARB((Int32)index);
        }

        public static 
        void glMatrixIndexubvARB(Int32 size, Byte[] indices)
        {
            unsafe
            {
                fixed (Byte* indices_ptr = indices)
                {
                    Delegates.glMatrixIndexubvARB((Int32)size, (Byte*)indices_ptr);
                }
            }
        }

        public static 
        void glMatrixIndexubvARB(Int32 size, ref Byte indices)
        {
            unsafe
            {
                fixed (Byte* indices_ptr = &indices)
                {
                    Delegates.glMatrixIndexubvARB((Int32)size, (Byte*)indices_ptr);
                }
            }
        }

        public static 
        void glMatrixIndexubvARB(Int32 size, IntPtr indices)
        {
            unsafe
            {
                Delegates.glMatrixIndexubvARB((Int32)size, (Byte*)indices);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glMatrixIndexusvARB(Int32 size, UInt16[] indices)
        {
            unsafe
            {
                fixed (UInt16* indices_ptr = indices)
                {
                    Delegates.glMatrixIndexusvARB((Int32)size, (UInt16*)indices_ptr);
                }
            }
        }

        public static 
        void glMatrixIndexusvARB(Int32 size, Int16[] indices)
        {
            unsafe
            {
                fixed (Int16* indices_ptr = indices)
                {
                    Delegates.glMatrixIndexusvARB((Int32)size, (UInt16*)indices_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glMatrixIndexusvARB(Int32 size, ref UInt16 indices)
        {
            unsafe
            {
                fixed (UInt16* indices_ptr = &indices)
                {
                    Delegates.glMatrixIndexusvARB((Int32)size, (UInt16*)indices_ptr);
                }
            }
        }

        public static 
        void glMatrixIndexusvARB(Int32 size, ref Int16 indices)
        {
            unsafe
            {
                fixed (Int16* indices_ptr = &indices)
                {
                    Delegates.glMatrixIndexusvARB((Int32)size, (UInt16*)indices_ptr);
                }
            }
        }

        public static 
        void glMatrixIndexusvARB(Int32 size, IntPtr indices)
        {
            unsafe
            {
                Delegates.glMatrixIndexusvARB((Int32)size, (UInt16*)indices);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glMatrixIndexuivARB(Int32 size, UInt32[] indices)
        {
            unsafe
            {
                fixed (UInt32* indices_ptr = indices)
                {
                    Delegates.glMatrixIndexuivARB((Int32)size, (UInt32*)indices_ptr);
                }
            }
        }

        public static 
        void glMatrixIndexuivARB(Int32 size, Int32[] indices)
        {
            unsafe
            {
                fixed (Int32* indices_ptr = indices)
                {
                    Delegates.glMatrixIndexuivARB((Int32)size, (UInt32*)indices_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glMatrixIndexuivARB(Int32 size, ref UInt32 indices)
        {
            unsafe
            {
                fixed (UInt32* indices_ptr = &indices)
                {
                    Delegates.glMatrixIndexuivARB((Int32)size, (UInt32*)indices_ptr);
                }
            }
        }

        public static 
        void glMatrixIndexuivARB(Int32 size, ref Int32 indices)
        {
            unsafe
            {
                fixed (Int32* indices_ptr = &indices)
                {
                    Delegates.glMatrixIndexuivARB((Int32)size, (UInt32*)indices_ptr);
                }
            }
        }

        public static 
        void glMatrixIndexuivARB(Int32 size, IntPtr indices)
        {
            unsafe
            {
                Delegates.glMatrixIndexuivARB((Int32)size, (UInt32*)indices);
            }
        }

        public static 
        void glMatrixIndexPointerARB(Int32 size, int type, Int32 stride, IntPtr pointer)
        {
            unsafe
            {
                Delegates.glMatrixIndexPointerARB((Int32)size, (int)type, (Int32)stride, (IntPtr)pointer);
            }
        }

        public static 
        void glMatrixIndexPointerARB(Int32 size, int type, Int32 stride, [In, Out] object pointer)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle pointer_ptr = System.Runtime.InteropServices.GCHandle.Alloc(pointer, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glMatrixIndexPointerARB((Int32)size, (int)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
            }
        }

        public static 
        void glWindowPos2dARB(Double x, Double y)
        {
            Delegates.glWindowPos2dARB((Double)x, (Double)y);
        }

        public static 
        void glWindowPos2dvARB(Double[] v)
        {
            unsafe
            {
                fixed (Double* v_ptr = v)
                {
                    Delegates.glWindowPos2dvARB((Double*)v_ptr);
                }
            }
        }

        public static 
        void glWindowPos2dvARB(ref Double v)
        {
            unsafe
            {
                fixed (Double* v_ptr = &v)
                {
                    Delegates.glWindowPos2dvARB((Double*)v_ptr);
                }
            }
        }

        public static 
        void glWindowPos2dvARB(IntPtr v)
        {
            unsafe
            {
                Delegates.glWindowPos2dvARB((Double*)v);
            }
        }

        public static 
        void glWindowPos2fARB(Single x, Single y)
        {
            Delegates.glWindowPos2fARB((Single)x, (Single)y);
        }

        public static 
        void glWindowPos2fvARB(Single[] v)
        {
            unsafe
            {
                fixed (Single* v_ptr = v)
                {
                    Delegates.glWindowPos2fvARB((Single*)v_ptr);
                }
            }
        }

        public static 
        void glWindowPos2fvARB(ref Single v)
        {
            unsafe
            {
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glWindowPos2fvARB((Single*)v_ptr);
                }
            }
        }

        public static 
        void glWindowPos2fvARB(IntPtr v)
        {
            unsafe
            {
                Delegates.glWindowPos2fvARB((Single*)v);
            }
        }

        public static 
        void glWindowPos2iARB(Int32 x, Int32 y)
        {
            Delegates.glWindowPos2iARB((Int32)x, (Int32)y);
        }

        public static 
        void glWindowPos2ivARB(Int32[] v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = v)
                {
                    Delegates.glWindowPos2ivARB((Int32*)v_ptr);
                }
            }
        }

        public static 
        void glWindowPos2ivARB(ref Int32 v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = &v)
                {
                    Delegates.glWindowPos2ivARB((Int32*)v_ptr);
                }
            }
        }

        public static 
        void glWindowPos2ivARB(IntPtr v)
        {
            unsafe
            {
                Delegates.glWindowPos2ivARB((Int32*)v);
            }
        }

        public static 
        void glWindowPos2sARB(Int16 x, Int16 y)
        {
            Delegates.glWindowPos2sARB((Int16)x, (Int16)y);
        }

        public static 
        void glWindowPos2svARB(Int16[] v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = v)
                {
                    Delegates.glWindowPos2svARB((Int16*)v_ptr);
                }
            }
        }

        public static 
        void glWindowPos2svARB(ref Int16 v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = &v)
                {
                    Delegates.glWindowPos2svARB((Int16*)v_ptr);
                }
            }
        }

        public static 
        void glWindowPos2svARB(IntPtr v)
        {
            unsafe
            {
                Delegates.glWindowPos2svARB((Int16*)v);
            }
        }

        public static 
        void glWindowPos3dARB(Double x, Double y, Double z)
        {
            Delegates.glWindowPos3dARB((Double)x, (Double)y, (Double)z);
        }

        public static 
        void glWindowPos3dvARB(Double[] v)
        {
            unsafe
            {
                fixed (Double* v_ptr = v)
                {
                    Delegates.glWindowPos3dvARB((Double*)v_ptr);
                }
            }
        }

        public static 
        void glWindowPos3dvARB(ref Double v)
        {
            unsafe
            {
                fixed (Double* v_ptr = &v)
                {
                    Delegates.glWindowPos3dvARB((Double*)v_ptr);
                }
            }
        }

        public static 
        void glWindowPos3dvARB(IntPtr v)
        {
            unsafe
            {
                Delegates.glWindowPos3dvARB((Double*)v);
            }
        }

        public static 
        void glWindowPos3fARB(Single x, Single y, Single z)
        {
            Delegates.glWindowPos3fARB((Single)x, (Single)y, (Single)z);
        }

        public static 
        void glWindowPos3fvARB(Single[] v)
        {
            unsafe
            {
                fixed (Single* v_ptr = v)
                {
                    Delegates.glWindowPos3fvARB((Single*)v_ptr);
                }
            }
        }

        public static 
        void glWindowPos3fvARB(ref Single v)
        {
            unsafe
            {
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glWindowPos3fvARB((Single*)v_ptr);
                }
            }
        }

        public static 
        void glWindowPos3fvARB(IntPtr v)
        {
            unsafe
            {
                Delegates.glWindowPos3fvARB((Single*)v);
            }
        }

        public static 
        void glWindowPos3iARB(Int32 x, Int32 y, Int32 z)
        {
            Delegates.glWindowPos3iARB((Int32)x, (Int32)y, (Int32)z);
        }

        public static 
        void glWindowPos3ivARB(Int32[] v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = v)
                {
                    Delegates.glWindowPos3ivARB((Int32*)v_ptr);
                }
            }
        }

        public static 
        void glWindowPos3ivARB(ref Int32 v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = &v)
                {
                    Delegates.glWindowPos3ivARB((Int32*)v_ptr);
                }
            }
        }

        public static 
        void glWindowPos3ivARB(IntPtr v)
        {
            unsafe
            {
                Delegates.glWindowPos3ivARB((Int32*)v);
            }
        }

        public static 
        void glWindowPos3sARB(Int16 x, Int16 y, Int16 z)
        {
            Delegates.glWindowPos3sARB((Int16)x, (Int16)y, (Int16)z);
        }

        public static 
        void glWindowPos3svARB(Int16[] v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = v)
                {
                    Delegates.glWindowPos3svARB((Int16*)v_ptr);
                }
            }
        }

        public static 
        void glWindowPos3svARB(ref Int16 v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = &v)
                {
                    Delegates.glWindowPos3svARB((Int16*)v_ptr);
                }
            }
        }

        public static 
        void glWindowPos3svARB(IntPtr v)
        {
            unsafe
            {
                Delegates.glWindowPos3svARB((Int16*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib1dARB(UInt32 index, Double x)
        {
            Delegates.glVertexAttrib1dARB((UInt32)index, (Double)x);
        }

        public static 
        void glVertexAttrib1dARB(Int32 index, Double x)
        {
            Delegates.glVertexAttrib1dARB((UInt32)index, (Double)x);
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib1dvARB(UInt32 index, Double[] v)
        {
            unsafe
            {
                fixed (Double* v_ptr = v)
                {
                    Delegates.glVertexAttrib1dvARB((UInt32)index, (Double*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib1dvARB(Int32 index, Double[] v)
        {
            unsafe
            {
                fixed (Double* v_ptr = v)
                {
                    Delegates.glVertexAttrib1dvARB((UInt32)index, (Double*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib1dvARB(UInt32 index, ref Double v)
        {
            unsafe
            {
                fixed (Double* v_ptr = &v)
                {
                    Delegates.glVertexAttrib1dvARB((UInt32)index, (Double*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib1dvARB(Int32 index, ref Double v)
        {
            unsafe
            {
                fixed (Double* v_ptr = &v)
                {
                    Delegates.glVertexAttrib1dvARB((UInt32)index, (Double*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib1dvARB(UInt32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib1dvARB((UInt32)index, (Double*)v);
            }
        }

        public static 
        void glVertexAttrib1dvARB(Int32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib1dvARB((UInt32)index, (Double*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib1fARB(UInt32 index, Single x)
        {
            Delegates.glVertexAttrib1fARB((UInt32)index, (Single)x);
        }

        public static 
        void glVertexAttrib1fARB(Int32 index, Single x)
        {
            Delegates.glVertexAttrib1fARB((UInt32)index, (Single)x);
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib1fvARB(UInt32 index, Single[] v)
        {
            unsafe
            {
                fixed (Single* v_ptr = v)
                {
                    Delegates.glVertexAttrib1fvARB((UInt32)index, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib1fvARB(Int32 index, Single[] v)
        {
            unsafe
            {
                fixed (Single* v_ptr = v)
                {
                    Delegates.glVertexAttrib1fvARB((UInt32)index, (Single*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib1fvARB(UInt32 index, ref Single v)
        {
            unsafe
            {
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glVertexAttrib1fvARB((UInt32)index, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib1fvARB(Int32 index, ref Single v)
        {
            unsafe
            {
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glVertexAttrib1fvARB((UInt32)index, (Single*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib1fvARB(UInt32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib1fvARB((UInt32)index, (Single*)v);
            }
        }

        public static 
        void glVertexAttrib1fvARB(Int32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib1fvARB((UInt32)index, (Single*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib1sARB(UInt32 index, Int16 x)
        {
            Delegates.glVertexAttrib1sARB((UInt32)index, (Int16)x);
        }

        public static 
        void glVertexAttrib1sARB(Int32 index, Int16 x)
        {
            Delegates.glVertexAttrib1sARB((UInt32)index, (Int16)x);
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib1svARB(UInt32 index, Int16[] v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = v)
                {
                    Delegates.glVertexAttrib1svARB((UInt32)index, (Int16*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib1svARB(Int32 index, Int16[] v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = v)
                {
                    Delegates.glVertexAttrib1svARB((UInt32)index, (Int16*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib1svARB(UInt32 index, ref Int16 v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = &v)
                {
                    Delegates.glVertexAttrib1svARB((UInt32)index, (Int16*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib1svARB(Int32 index, ref Int16 v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = &v)
                {
                    Delegates.glVertexAttrib1svARB((UInt32)index, (Int16*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib1svARB(UInt32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib1svARB((UInt32)index, (Int16*)v);
            }
        }

        public static 
        void glVertexAttrib1svARB(Int32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib1svARB((UInt32)index, (Int16*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib2dARB(UInt32 index, Double x, Double y)
        {
            Delegates.glVertexAttrib2dARB((UInt32)index, (Double)x, (Double)y);
        }

        public static 
        void glVertexAttrib2dARB(Int32 index, Double x, Double y)
        {
            Delegates.glVertexAttrib2dARB((UInt32)index, (Double)x, (Double)y);
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib2dvARB(UInt32 index, Double[] v)
        {
            unsafe
            {
                fixed (Double* v_ptr = v)
                {
                    Delegates.glVertexAttrib2dvARB((UInt32)index, (Double*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib2dvARB(Int32 index, Double[] v)
        {
            unsafe
            {
                fixed (Double* v_ptr = v)
                {
                    Delegates.glVertexAttrib2dvARB((UInt32)index, (Double*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib2dvARB(UInt32 index, ref Double v)
        {
            unsafe
            {
                fixed (Double* v_ptr = &v)
                {
                    Delegates.glVertexAttrib2dvARB((UInt32)index, (Double*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib2dvARB(Int32 index, ref Double v)
        {
            unsafe
            {
                fixed (Double* v_ptr = &v)
                {
                    Delegates.glVertexAttrib2dvARB((UInt32)index, (Double*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib2dvARB(UInt32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib2dvARB((UInt32)index, (Double*)v);
            }
        }

        public static 
        void glVertexAttrib2dvARB(Int32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib2dvARB((UInt32)index, (Double*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib2fARB(UInt32 index, Single x, Single y)
        {
            Delegates.glVertexAttrib2fARB((UInt32)index, (Single)x, (Single)y);
        }

        public static 
        void glVertexAttrib2fARB(Int32 index, Single x, Single y)
        {
            Delegates.glVertexAttrib2fARB((UInt32)index, (Single)x, (Single)y);
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib2fvARB(UInt32 index, Single[] v)
        {
            unsafe
            {
                fixed (Single* v_ptr = v)
                {
                    Delegates.glVertexAttrib2fvARB((UInt32)index, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib2fvARB(Int32 index, Single[] v)
        {
            unsafe
            {
                fixed (Single* v_ptr = v)
                {
                    Delegates.glVertexAttrib2fvARB((UInt32)index, (Single*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib2fvARB(UInt32 index, ref Single v)
        {
            unsafe
            {
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glVertexAttrib2fvARB((UInt32)index, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib2fvARB(Int32 index, ref Single v)
        {
            unsafe
            {
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glVertexAttrib2fvARB((UInt32)index, (Single*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib2fvARB(UInt32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib2fvARB((UInt32)index, (Single*)v);
            }
        }

        public static 
        void glVertexAttrib2fvARB(Int32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib2fvARB((UInt32)index, (Single*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib2sARB(UInt32 index, Int16 x, Int16 y)
        {
            Delegates.glVertexAttrib2sARB((UInt32)index, (Int16)x, (Int16)y);
        }

        public static 
        void glVertexAttrib2sARB(Int32 index, Int16 x, Int16 y)
        {
            Delegates.glVertexAttrib2sARB((UInt32)index, (Int16)x, (Int16)y);
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib2svARB(UInt32 index, Int16[] v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = v)
                {
                    Delegates.glVertexAttrib2svARB((UInt32)index, (Int16*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib2svARB(Int32 index, Int16[] v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = v)
                {
                    Delegates.glVertexAttrib2svARB((UInt32)index, (Int16*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib2svARB(UInt32 index, ref Int16 v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = &v)
                {
                    Delegates.glVertexAttrib2svARB((UInt32)index, (Int16*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib2svARB(Int32 index, ref Int16 v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = &v)
                {
                    Delegates.glVertexAttrib2svARB((UInt32)index, (Int16*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib2svARB(UInt32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib2svARB((UInt32)index, (Int16*)v);
            }
        }

        public static 
        void glVertexAttrib2svARB(Int32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib2svARB((UInt32)index, (Int16*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib3dARB(UInt32 index, Double x, Double y, Double z)
        {
            Delegates.glVertexAttrib3dARB((UInt32)index, (Double)x, (Double)y, (Double)z);
        }

        public static 
        void glVertexAttrib3dARB(Int32 index, Double x, Double y, Double z)
        {
            Delegates.glVertexAttrib3dARB((UInt32)index, (Double)x, (Double)y, (Double)z);
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib3dvARB(UInt32 index, Double[] v)
        {
            unsafe
            {
                fixed (Double* v_ptr = v)
                {
                    Delegates.glVertexAttrib3dvARB((UInt32)index, (Double*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib3dvARB(Int32 index, Double[] v)
        {
            unsafe
            {
                fixed (Double* v_ptr = v)
                {
                    Delegates.glVertexAttrib3dvARB((UInt32)index, (Double*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib3dvARB(UInt32 index, ref Double v)
        {
            unsafe
            {
                fixed (Double* v_ptr = &v)
                {
                    Delegates.glVertexAttrib3dvARB((UInt32)index, (Double*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib3dvARB(Int32 index, ref Double v)
        {
            unsafe
            {
                fixed (Double* v_ptr = &v)
                {
                    Delegates.glVertexAttrib3dvARB((UInt32)index, (Double*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib3dvARB(UInt32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib3dvARB((UInt32)index, (Double*)v);
            }
        }

        public static 
        void glVertexAttrib3dvARB(Int32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib3dvARB((UInt32)index, (Double*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib3fARB(UInt32 index, Single x, Single y, Single z)
        {
            Delegates.glVertexAttrib3fARB((UInt32)index, (Single)x, (Single)y, (Single)z);
        }

        public static 
        void glVertexAttrib3fARB(Int32 index, Single x, Single y, Single z)
        {
            Delegates.glVertexAttrib3fARB((UInt32)index, (Single)x, (Single)y, (Single)z);
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib3fvARB(UInt32 index, Single[] v)
        {
            unsafe
            {
                fixed (Single* v_ptr = v)
                {
                    Delegates.glVertexAttrib3fvARB((UInt32)index, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib3fvARB(Int32 index, Single[] v)
        {
            unsafe
            {
                fixed (Single* v_ptr = v)
                {
                    Delegates.glVertexAttrib3fvARB((UInt32)index, (Single*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib3fvARB(UInt32 index, ref Single v)
        {
            unsafe
            {
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glVertexAttrib3fvARB((UInt32)index, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib3fvARB(Int32 index, ref Single v)
        {
            unsafe
            {
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glVertexAttrib3fvARB((UInt32)index, (Single*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib3fvARB(UInt32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib3fvARB((UInt32)index, (Single*)v);
            }
        }

        public static 
        void glVertexAttrib3fvARB(Int32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib3fvARB((UInt32)index, (Single*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib3sARB(UInt32 index, Int16 x, Int16 y, Int16 z)
        {
            Delegates.glVertexAttrib3sARB((UInt32)index, (Int16)x, (Int16)y, (Int16)z);
        }

        public static 
        void glVertexAttrib3sARB(Int32 index, Int16 x, Int16 y, Int16 z)
        {
            Delegates.glVertexAttrib3sARB((UInt32)index, (Int16)x, (Int16)y, (Int16)z);
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib3svARB(UInt32 index, Int16[] v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = v)
                {
                    Delegates.glVertexAttrib3svARB((UInt32)index, (Int16*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib3svARB(Int32 index, Int16[] v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = v)
                {
                    Delegates.glVertexAttrib3svARB((UInt32)index, (Int16*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib3svARB(UInt32 index, ref Int16 v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = &v)
                {
                    Delegates.glVertexAttrib3svARB((UInt32)index, (Int16*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib3svARB(Int32 index, ref Int16 v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = &v)
                {
                    Delegates.glVertexAttrib3svARB((UInt32)index, (Int16*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib3svARB(UInt32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib3svARB((UInt32)index, (Int16*)v);
            }
        }

        public static 
        void glVertexAttrib3svARB(Int32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib3svARB((UInt32)index, (Int16*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4NbvARB(UInt32 index, SByte[] v)
        {
            unsafe
            {
                fixed (SByte* v_ptr = v)
                {
                    Delegates.glVertexAttrib4NbvARB((UInt32)index, (SByte*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib4NbvARB(Int32 index, Byte[] v)
        {
            unsafe
            {
                fixed (Byte* v_ptr = v)
                {
                    Delegates.glVertexAttrib4NbvARB((UInt32)index, (SByte*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4NbvARB(UInt32 index, ref SByte v)
        {
            unsafe
            {
                fixed (SByte* v_ptr = &v)
                {
                    Delegates.glVertexAttrib4NbvARB((UInt32)index, (SByte*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib4NbvARB(Int32 index, ref Byte v)
        {
            unsafe
            {
                fixed (Byte* v_ptr = &v)
                {
                    Delegates.glVertexAttrib4NbvARB((UInt32)index, (SByte*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4NbvARB(UInt32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib4NbvARB((UInt32)index, (SByte*)v);
            }
        }

        public static 
        void glVertexAttrib4NbvARB(Int32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib4NbvARB((UInt32)index, (SByte*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4NivARB(UInt32 index, Int32[] v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = v)
                {
                    Delegates.glVertexAttrib4NivARB((UInt32)index, (Int32*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib4NivARB(Int32 index, Int32[] v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = v)
                {
                    Delegates.glVertexAttrib4NivARB((UInt32)index, (Int32*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4NivARB(UInt32 index, ref Int32 v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = &v)
                {
                    Delegates.glVertexAttrib4NivARB((UInt32)index, (Int32*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib4NivARB(Int32 index, ref Int32 v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = &v)
                {
                    Delegates.glVertexAttrib4NivARB((UInt32)index, (Int32*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4NivARB(UInt32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib4NivARB((UInt32)index, (Int32*)v);
            }
        }

        public static 
        void glVertexAttrib4NivARB(Int32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib4NivARB((UInt32)index, (Int32*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4NsvARB(UInt32 index, Int16[] v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = v)
                {
                    Delegates.glVertexAttrib4NsvARB((UInt32)index, (Int16*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib4NsvARB(Int32 index, Int16[] v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = v)
                {
                    Delegates.glVertexAttrib4NsvARB((UInt32)index, (Int16*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4NsvARB(UInt32 index, ref Int16 v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = &v)
                {
                    Delegates.glVertexAttrib4NsvARB((UInt32)index, (Int16*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib4NsvARB(Int32 index, ref Int16 v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = &v)
                {
                    Delegates.glVertexAttrib4NsvARB((UInt32)index, (Int16*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4NsvARB(UInt32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib4NsvARB((UInt32)index, (Int16*)v);
            }
        }

        public static 
        void glVertexAttrib4NsvARB(Int32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib4NsvARB((UInt32)index, (Int16*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4NubARB(UInt32 index, Byte x, Byte y, Byte z, Byte w)
        {
            Delegates.glVertexAttrib4NubARB((UInt32)index, (Byte)x, (Byte)y, (Byte)z, (Byte)w);
        }

        public static 
        void glVertexAttrib4NubARB(Int32 index, Byte x, Byte y, Byte z, Byte w)
        {
            Delegates.glVertexAttrib4NubARB((UInt32)index, (Byte)x, (Byte)y, (Byte)z, (Byte)w);
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4NubvARB(UInt32 index, Byte[] v)
        {
            unsafe
            {
                fixed (Byte* v_ptr = v)
                {
                    Delegates.glVertexAttrib4NubvARB((UInt32)index, (Byte*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib4NubvARB(Int32 index, Byte[] v)
        {
            unsafe
            {
                fixed (Byte* v_ptr = v)
                {
                    Delegates.glVertexAttrib4NubvARB((UInt32)index, (Byte*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4NubvARB(UInt32 index, ref Byte v)
        {
            unsafe
            {
                fixed (Byte* v_ptr = &v)
                {
                    Delegates.glVertexAttrib4NubvARB((UInt32)index, (Byte*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib4NubvARB(Int32 index, ref Byte v)
        {
            unsafe
            {
                fixed (Byte* v_ptr = &v)
                {
                    Delegates.glVertexAttrib4NubvARB((UInt32)index, (Byte*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4NubvARB(UInt32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib4NubvARB((UInt32)index, (Byte*)v);
            }
        }

        public static 
        void glVertexAttrib4NubvARB(Int32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib4NubvARB((UInt32)index, (Byte*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4NuivARB(UInt32 index, UInt32[] v)
        {
            unsafe
            {
                fixed (UInt32* v_ptr = v)
                {
                    Delegates.glVertexAttrib4NuivARB((UInt32)index, (UInt32*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib4NuivARB(Int32 index, Int32[] v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = v)
                {
                    Delegates.glVertexAttrib4NuivARB((UInt32)index, (UInt32*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4NuivARB(UInt32 index, ref UInt32 v)
        {
            unsafe
            {
                fixed (UInt32* v_ptr = &v)
                {
                    Delegates.glVertexAttrib4NuivARB((UInt32)index, (UInt32*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib4NuivARB(Int32 index, ref Int32 v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = &v)
                {
                    Delegates.glVertexAttrib4NuivARB((UInt32)index, (UInt32*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4NuivARB(UInt32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib4NuivARB((UInt32)index, (UInt32*)v);
            }
        }

        public static 
        void glVertexAttrib4NuivARB(Int32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib4NuivARB((UInt32)index, (UInt32*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4NusvARB(UInt32 index, UInt16[] v)
        {
            unsafe
            {
                fixed (UInt16* v_ptr = v)
                {
                    Delegates.glVertexAttrib4NusvARB((UInt32)index, (UInt16*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib4NusvARB(Int32 index, Int16[] v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = v)
                {
                    Delegates.glVertexAttrib4NusvARB((UInt32)index, (UInt16*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4NusvARB(UInt32 index, ref UInt16 v)
        {
            unsafe
            {
                fixed (UInt16* v_ptr = &v)
                {
                    Delegates.glVertexAttrib4NusvARB((UInt32)index, (UInt16*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib4NusvARB(Int32 index, ref Int16 v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = &v)
                {
                    Delegates.glVertexAttrib4NusvARB((UInt32)index, (UInt16*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4NusvARB(UInt32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib4NusvARB((UInt32)index, (UInt16*)v);
            }
        }

        public static 
        void glVertexAttrib4NusvARB(Int32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib4NusvARB((UInt32)index, (UInt16*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4bvARB(UInt32 index, SByte[] v)
        {
            unsafe
            {
                fixed (SByte* v_ptr = v)
                {
                    Delegates.glVertexAttrib4bvARB((UInt32)index, (SByte*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib4bvARB(Int32 index, Byte[] v)
        {
            unsafe
            {
                fixed (Byte* v_ptr = v)
                {
                    Delegates.glVertexAttrib4bvARB((UInt32)index, (SByte*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4bvARB(UInt32 index, ref SByte v)
        {
            unsafe
            {
                fixed (SByte* v_ptr = &v)
                {
                    Delegates.glVertexAttrib4bvARB((UInt32)index, (SByte*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib4bvARB(Int32 index, ref Byte v)
        {
            unsafe
            {
                fixed (Byte* v_ptr = &v)
                {
                    Delegates.glVertexAttrib4bvARB((UInt32)index, (SByte*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4bvARB(UInt32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib4bvARB((UInt32)index, (SByte*)v);
            }
        }

        public static 
        void glVertexAttrib4bvARB(Int32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib4bvARB((UInt32)index, (SByte*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4dARB(UInt32 index, Double x, Double y, Double z, Double w)
        {
            Delegates.glVertexAttrib4dARB((UInt32)index, (Double)x, (Double)y, (Double)z, (Double)w);
        }

        public static 
        void glVertexAttrib4dARB(Int32 index, Double x, Double y, Double z, Double w)
        {
            Delegates.glVertexAttrib4dARB((UInt32)index, (Double)x, (Double)y, (Double)z, (Double)w);
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4dvARB(UInt32 index, Double[] v)
        {
            unsafe
            {
                fixed (Double* v_ptr = v)
                {
                    Delegates.glVertexAttrib4dvARB((UInt32)index, (Double*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib4dvARB(Int32 index, Double[] v)
        {
            unsafe
            {
                fixed (Double* v_ptr = v)
                {
                    Delegates.glVertexAttrib4dvARB((UInt32)index, (Double*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4dvARB(UInt32 index, ref Double v)
        {
            unsafe
            {
                fixed (Double* v_ptr = &v)
                {
                    Delegates.glVertexAttrib4dvARB((UInt32)index, (Double*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib4dvARB(Int32 index, ref Double v)
        {
            unsafe
            {
                fixed (Double* v_ptr = &v)
                {
                    Delegates.glVertexAttrib4dvARB((UInt32)index, (Double*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4dvARB(UInt32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib4dvARB((UInt32)index, (Double*)v);
            }
        }

        public static 
        void glVertexAttrib4dvARB(Int32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib4dvARB((UInt32)index, (Double*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4fARB(UInt32 index, Single x, Single y, Single z, Single w)
        {
            Delegates.glVertexAttrib4fARB((UInt32)index, (Single)x, (Single)y, (Single)z, (Single)w);
        }

        public static 
        void glVertexAttrib4fARB(Int32 index, Single x, Single y, Single z, Single w)
        {
            Delegates.glVertexAttrib4fARB((UInt32)index, (Single)x, (Single)y, (Single)z, (Single)w);
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4fvARB(UInt32 index, Single[] v)
        {
            unsafe
            {
                fixed (Single* v_ptr = v)
                {
                    Delegates.glVertexAttrib4fvARB((UInt32)index, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib4fvARB(Int32 index, Single[] v)
        {
            unsafe
            {
                fixed (Single* v_ptr = v)
                {
                    Delegates.glVertexAttrib4fvARB((UInt32)index, (Single*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4fvARB(UInt32 index, ref Single v)
        {
            unsafe
            {
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glVertexAttrib4fvARB((UInt32)index, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib4fvARB(Int32 index, ref Single v)
        {
            unsafe
            {
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glVertexAttrib4fvARB((UInt32)index, (Single*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4fvARB(UInt32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib4fvARB((UInt32)index, (Single*)v);
            }
        }

        public static 
        void glVertexAttrib4fvARB(Int32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib4fvARB((UInt32)index, (Single*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4ivARB(UInt32 index, Int32[] v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = v)
                {
                    Delegates.glVertexAttrib4ivARB((UInt32)index, (Int32*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib4ivARB(Int32 index, Int32[] v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = v)
                {
                    Delegates.glVertexAttrib4ivARB((UInt32)index, (Int32*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4ivARB(UInt32 index, ref Int32 v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = &v)
                {
                    Delegates.glVertexAttrib4ivARB((UInt32)index, (Int32*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib4ivARB(Int32 index, ref Int32 v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = &v)
                {
                    Delegates.glVertexAttrib4ivARB((UInt32)index, (Int32*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4ivARB(UInt32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib4ivARB((UInt32)index, (Int32*)v);
            }
        }

        public static 
        void glVertexAttrib4ivARB(Int32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib4ivARB((UInt32)index, (Int32*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4sARB(UInt32 index, Int16 x, Int16 y, Int16 z, Int16 w)
        {
            Delegates.glVertexAttrib4sARB((UInt32)index, (Int16)x, (Int16)y, (Int16)z, (Int16)w);
        }

        public static 
        void glVertexAttrib4sARB(Int32 index, Int16 x, Int16 y, Int16 z, Int16 w)
        {
            Delegates.glVertexAttrib4sARB((UInt32)index, (Int16)x, (Int16)y, (Int16)z, (Int16)w);
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4svARB(UInt32 index, Int16[] v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = v)
                {
                    Delegates.glVertexAttrib4svARB((UInt32)index, (Int16*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib4svARB(Int32 index, Int16[] v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = v)
                {
                    Delegates.glVertexAttrib4svARB((UInt32)index, (Int16*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4svARB(UInt32 index, ref Int16 v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = &v)
                {
                    Delegates.glVertexAttrib4svARB((UInt32)index, (Int16*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib4svARB(Int32 index, ref Int16 v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = &v)
                {
                    Delegates.glVertexAttrib4svARB((UInt32)index, (Int16*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4svARB(UInt32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib4svARB((UInt32)index, (Int16*)v);
            }
        }

        public static 
        void glVertexAttrib4svARB(Int32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib4svARB((UInt32)index, (Int16*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4ubvARB(UInt32 index, Byte[] v)
        {
            unsafe
            {
                fixed (Byte* v_ptr = v)
                {
                    Delegates.glVertexAttrib4ubvARB((UInt32)index, (Byte*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib4ubvARB(Int32 index, Byte[] v)
        {
            unsafe
            {
                fixed (Byte* v_ptr = v)
                {
                    Delegates.glVertexAttrib4ubvARB((UInt32)index, (Byte*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4ubvARB(UInt32 index, ref Byte v)
        {
            unsafe
            {
                fixed (Byte* v_ptr = &v)
                {
                    Delegates.glVertexAttrib4ubvARB((UInt32)index, (Byte*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib4ubvARB(Int32 index, ref Byte v)
        {
            unsafe
            {
                fixed (Byte* v_ptr = &v)
                {
                    Delegates.glVertexAttrib4ubvARB((UInt32)index, (Byte*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4ubvARB(UInt32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib4ubvARB((UInt32)index, (Byte*)v);
            }
        }

        public static 
        void glVertexAttrib4ubvARB(Int32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib4ubvARB((UInt32)index, (Byte*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4uivARB(UInt32 index, UInt32[] v)
        {
            unsafe
            {
                fixed (UInt32* v_ptr = v)
                {
                    Delegates.glVertexAttrib4uivARB((UInt32)index, (UInt32*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib4uivARB(Int32 index, Int32[] v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = v)
                {
                    Delegates.glVertexAttrib4uivARB((UInt32)index, (UInt32*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4uivARB(UInt32 index, ref UInt32 v)
        {
            unsafe
            {
                fixed (UInt32* v_ptr = &v)
                {
                    Delegates.glVertexAttrib4uivARB((UInt32)index, (UInt32*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib4uivARB(Int32 index, ref Int32 v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = &v)
                {
                    Delegates.glVertexAttrib4uivARB((UInt32)index, (UInt32*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4uivARB(UInt32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib4uivARB((UInt32)index, (UInt32*)v);
            }
        }

        public static 
        void glVertexAttrib4uivARB(Int32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib4uivARB((UInt32)index, (UInt32*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4usvARB(UInt32 index, UInt16[] v)
        {
            unsafe
            {
                fixed (UInt16* v_ptr = v)
                {
                    Delegates.glVertexAttrib4usvARB((UInt32)index, (UInt16*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib4usvARB(Int32 index, Int16[] v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = v)
                {
                    Delegates.glVertexAttrib4usvARB((UInt32)index, (UInt16*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4usvARB(UInt32 index, ref UInt16 v)
        {
            unsafe
            {
                fixed (UInt16* v_ptr = &v)
                {
                    Delegates.glVertexAttrib4usvARB((UInt32)index, (UInt16*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttrib4usvARB(Int32 index, ref Int16 v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = &v)
                {
                    Delegates.glVertexAttrib4usvARB((UInt32)index, (UInt16*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttrib4usvARB(UInt32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib4usvARB((UInt32)index, (UInt16*)v);
            }
        }

        public static 
        void glVertexAttrib4usvARB(Int32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttrib4usvARB((UInt32)index, (UInt16*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttribPointerARB(UInt32 index, Int32 size, int type, bool normalized, Int32 stride, IntPtr pointer)
        {
            unsafe
            {
                Delegates.glVertexAttribPointerARB((UInt32)index, (Int32)size, (int)type, (bool)normalized, (Int32)stride, (IntPtr)pointer);
            }
        }

        public static 
        void glVertexAttribPointerARB(Int32 index, Int32 size, int type, bool normalized, Int32 stride, IntPtr pointer)
        {
            unsafe
            {
                Delegates.glVertexAttribPointerARB((UInt32)index, (Int32)size, (int)type, (bool)normalized, (Int32)stride, (IntPtr)pointer);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttribPointerARB(UInt32 index, Int32 size, int type, bool normalized, Int32 stride, [In, Out] object pointer)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle pointer_ptr = System.Runtime.InteropServices.GCHandle.Alloc(pointer, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glVertexAttribPointerARB((UInt32)index, (Int32)size, (int)type, (bool)normalized, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
            }
        }

        public static 
        void glVertexAttribPointerARB(Int32 index, Int32 size, int type, bool normalized, Int32 stride, [In, Out] object pointer)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle pointer_ptr = System.Runtime.InteropServices.GCHandle.Alloc(pointer, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glVertexAttribPointerARB((UInt32)index, (Int32)size, (int)type, (bool)normalized, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glEnableVertexAttribArrayARB(UInt32 index)
        {
            Delegates.glEnableVertexAttribArrayARB((UInt32)index);
        }

        public static 
        void glEnableVertexAttribArrayARB(Int32 index)
        {
            Delegates.glEnableVertexAttribArrayARB((UInt32)index);
        }

        [System.CLSCompliant(false)]
        public static 
        void glDisableVertexAttribArrayARB(UInt32 index)
        {
            Delegates.glDisableVertexAttribArrayARB((UInt32)index);
        }

        public static 
        void glDisableVertexAttribArrayARB(Int32 index)
        {
            Delegates.glDisableVertexAttribArrayARB((UInt32)index);
        }

        public static 
        void glProgramStringARB(int target, int format, Int32 len, IntPtr @string)
        {
            unsafe
            {
                Delegates.glProgramStringARB((int)target, (int)format, (Int32)len, (IntPtr)@string);
            }
        }

        public static 
        void glProgramStringARB(int target, int format, Int32 len, [In, Out] object @string)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle @string_ptr = System.Runtime.InteropServices.GCHandle.Alloc(@string, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glProgramStringARB((int)target, (int)format, (Int32)len, (IntPtr)@string_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    @string_ptr.Free();
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glBindProgramARB(int target, UInt32 program)
        {
            Delegates.glBindProgramARB((int)target, (UInt32)program);
        }

        public static 
        void glBindProgramARB(int target, Int32 program)
        {
            Delegates.glBindProgramARB((int)target, (UInt32)program);
        }

        [System.CLSCompliant(false)]
        public static 
        void glDeleteProgramsARB(Int32 n, UInt32[] programs)
        {
            unsafe
            {
                fixed (UInt32* programs_ptr = programs)
                {
                    Delegates.glDeleteProgramsARB((Int32)n, (UInt32*)programs_ptr);
                }
            }
        }

        public static 
        void glDeleteProgramsARB(Int32 n, Int32[] programs)
        {
            unsafe
            {
                fixed (Int32* programs_ptr = programs)
                {
                    Delegates.glDeleteProgramsARB((Int32)n, (UInt32*)programs_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glDeleteProgramsARB(Int32 n, ref UInt32 programs)
        {
            unsafe
            {
                fixed (UInt32* programs_ptr = &programs)
                {
                    Delegates.glDeleteProgramsARB((Int32)n, (UInt32*)programs_ptr);
                }
            }
        }

        public static 
        void glDeleteProgramsARB(Int32 n, ref Int32 programs)
        {
            unsafe
            {
                fixed (Int32* programs_ptr = &programs)
                {
                    Delegates.glDeleteProgramsARB((Int32)n, (UInt32*)programs_ptr);
                }
            }
        }

        public static 
        void glDeleteProgramsARB(Int32 n, IntPtr programs)
        {
            unsafe
            {
                Delegates.glDeleteProgramsARB((Int32)n, (UInt32*)programs);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGenProgramsARB(Int32 n, [Out] UInt32[] programs)
        {
            unsafe
            {
                fixed (UInt32* programs_ptr = programs)
                {
                    Delegates.glGenProgramsARB((Int32)n, (UInt32*)programs_ptr);
                }
            }
        }

        public static 
        void glGenProgramsARB(Int32 n, [Out] Int32[] programs)
        {
            unsafe
            {
                fixed (Int32* programs_ptr = programs)
                {
                    Delegates.glGenProgramsARB((Int32)n, (UInt32*)programs_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGenProgramsARB(Int32 n, [Out] out UInt32 programs)
        {
            unsafe
            {
                fixed (UInt32* programs_ptr = &programs)
                {
                    Delegates.glGenProgramsARB((Int32)n, (UInt32*)programs_ptr);
                    programs = *programs_ptr;
                }
            }
        }

        public static 
        void glGenProgramsARB(Int32 n, [Out] out Int32 programs)
        {
            unsafe
            {
                fixed (Int32* programs_ptr = &programs)
                {
                    Delegates.glGenProgramsARB((Int32)n, (UInt32*)programs_ptr);
                    programs = *programs_ptr;
                }
            }
        }

        public static 
        void glGenProgramsARB(Int32 n, [Out] IntPtr programs)
        {
            unsafe
            {
                Delegates.glGenProgramsARB((Int32)n, (UInt32*)programs);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glProgramEnvParameter4dARB(int target, UInt32 index, Double x, Double y, Double z, Double w)
        {
            Delegates.glProgramEnvParameter4dARB((int)target, (UInt32)index, (Double)x, (Double)y, (Double)z, (Double)w);
        }

        public static 
        void glProgramEnvParameter4dARB(int target, Int32 index, Double x, Double y, Double z, Double w)
        {
            Delegates.glProgramEnvParameter4dARB((int)target, (UInt32)index, (Double)x, (Double)y, (Double)z, (Double)w);
        }

        [System.CLSCompliant(false)]
        public static 
        void glProgramEnvParameter4dvARB(int target, UInt32 index, Double[] @params)
        {
            unsafe
            {
                fixed (Double* @params_ptr = @params)
                {
                    Delegates.glProgramEnvParameter4dvARB((int)target, (UInt32)index, (Double*)@params_ptr);
                }
            }
        }

        public static 
        void glProgramEnvParameter4dvARB(int target, Int32 index, Double[] @params)
        {
            unsafe
            {
                fixed (Double* @params_ptr = @params)
                {
                    Delegates.glProgramEnvParameter4dvARB((int)target, (UInt32)index, (Double*)@params_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glProgramEnvParameter4dvARB(int target, UInt32 index, ref Double @params)
        {
            unsafe
            {
                fixed (Double* @params_ptr = &@params)
                {
                    Delegates.glProgramEnvParameter4dvARB((int)target, (UInt32)index, (Double*)@params_ptr);
                }
            }
        }

        public static 
        void glProgramEnvParameter4dvARB(int target, Int32 index, ref Double @params)
        {
            unsafe
            {
                fixed (Double* @params_ptr = &@params)
                {
                    Delegates.glProgramEnvParameter4dvARB((int)target, (UInt32)index, (Double*)@params_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glProgramEnvParameter4dvARB(int target, UInt32 index, IntPtr @params)
        {
            unsafe
            {
                Delegates.glProgramEnvParameter4dvARB((int)target, (UInt32)index, (Double*)@params);
            }
        }

        public static 
        void glProgramEnvParameter4dvARB(int target, Int32 index, IntPtr @params)
        {
            unsafe
            {
                Delegates.glProgramEnvParameter4dvARB((int)target, (UInt32)index, (Double*)@params);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glProgramEnvParameter4fARB(int target, UInt32 index, Single x, Single y, Single z, Single w)
        {
            Delegates.glProgramEnvParameter4fARB((int)target, (UInt32)index, (Single)x, (Single)y, (Single)z, (Single)w);
        }

        public static 
        void glProgramEnvParameter4fARB(int target, Int32 index, Single x, Single y, Single z, Single w)
        {
            Delegates.glProgramEnvParameter4fARB((int)target, (UInt32)index, (Single)x, (Single)y, (Single)z, (Single)w);
        }

        [System.CLSCompliant(false)]
        public static 
        void glProgramEnvParameter4fvARB(int target, UInt32 index, Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glProgramEnvParameter4fvARB((int)target, (UInt32)index, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glProgramEnvParameter4fvARB(int target, Int32 index, Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glProgramEnvParameter4fvARB((int)target, (UInt32)index, (Single*)@params_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glProgramEnvParameter4fvARB(int target, UInt32 index, ref Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glProgramEnvParameter4fvARB((int)target, (UInt32)index, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glProgramEnvParameter4fvARB(int target, Int32 index, ref Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glProgramEnvParameter4fvARB((int)target, (UInt32)index, (Single*)@params_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glProgramEnvParameter4fvARB(int target, UInt32 index, IntPtr @params)
        {
            unsafe
            {
                Delegates.glProgramEnvParameter4fvARB((int)target, (UInt32)index, (Single*)@params);
            }
        }

        public static 
        void glProgramEnvParameter4fvARB(int target, Int32 index, IntPtr @params)
        {
            unsafe
            {
                Delegates.glProgramEnvParameter4fvARB((int)target, (UInt32)index, (Single*)@params);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glProgramLocalParameter4dARB(int target, UInt32 index, Double x, Double y, Double z, Double w)
        {
            Delegates.glProgramLocalParameter4dARB((int)target, (UInt32)index, (Double)x, (Double)y, (Double)z, (Double)w);
        }

        public static 
        void glProgramLocalParameter4dARB(int target, Int32 index, Double x, Double y, Double z, Double w)
        {
            Delegates.glProgramLocalParameter4dARB((int)target, (UInt32)index, (Double)x, (Double)y, (Double)z, (Double)w);
        }

        [System.CLSCompliant(false)]
        public static 
        void glProgramLocalParameter4dvARB(int target, UInt32 index, Double[] @params)
        {
            unsafe
            {
                fixed (Double* @params_ptr = @params)
                {
                    Delegates.glProgramLocalParameter4dvARB((int)target, (UInt32)index, (Double*)@params_ptr);
                }
            }
        }

        public static 
        void glProgramLocalParameter4dvARB(int target, Int32 index, Double[] @params)
        {
            unsafe
            {
                fixed (Double* @params_ptr = @params)
                {
                    Delegates.glProgramLocalParameter4dvARB((int)target, (UInt32)index, (Double*)@params_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glProgramLocalParameter4dvARB(int target, UInt32 index, ref Double @params)
        {
            unsafe
            {
                fixed (Double* @params_ptr = &@params)
                {
                    Delegates.glProgramLocalParameter4dvARB((int)target, (UInt32)index, (Double*)@params_ptr);
                }
            }
        }

        public static 
        void glProgramLocalParameter4dvARB(int target, Int32 index, ref Double @params)
        {
            unsafe
            {
                fixed (Double* @params_ptr = &@params)
                {
                    Delegates.glProgramLocalParameter4dvARB((int)target, (UInt32)index, (Double*)@params_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glProgramLocalParameter4dvARB(int target, UInt32 index, IntPtr @params)
        {
            unsafe
            {
                Delegates.glProgramLocalParameter4dvARB((int)target, (UInt32)index, (Double*)@params);
            }
        }

        public static 
        void glProgramLocalParameter4dvARB(int target, Int32 index, IntPtr @params)
        {
            unsafe
            {
                Delegates.glProgramLocalParameter4dvARB((int)target, (UInt32)index, (Double*)@params);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glProgramLocalParameter4fARB(int target, UInt32 index, Single x, Single y, Single z, Single w)
        {
            Delegates.glProgramLocalParameter4fARB((int)target, (UInt32)index, (Single)x, (Single)y, (Single)z, (Single)w);
        }

        public static 
        void glProgramLocalParameter4fARB(int target, Int32 index, Single x, Single y, Single z, Single w)
        {
            Delegates.glProgramLocalParameter4fARB((int)target, (UInt32)index, (Single)x, (Single)y, (Single)z, (Single)w);
        }

        [System.CLSCompliant(false)]
        public static 
        void glProgramLocalParameter4fvARB(int target, UInt32 index, Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glProgramLocalParameter4fvARB((int)target, (UInt32)index, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glProgramLocalParameter4fvARB(int target, Int32 index, Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glProgramLocalParameter4fvARB((int)target, (UInt32)index, (Single*)@params_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glProgramLocalParameter4fvARB(int target, UInt32 index, ref Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glProgramLocalParameter4fvARB((int)target, (UInt32)index, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glProgramLocalParameter4fvARB(int target, Int32 index, ref Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glProgramLocalParameter4fvARB((int)target, (UInt32)index, (Single*)@params_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glProgramLocalParameter4fvARB(int target, UInt32 index, IntPtr @params)
        {
            unsafe
            {
                Delegates.glProgramLocalParameter4fvARB((int)target, (UInt32)index, (Single*)@params);
            }
        }

        public static 
        void glProgramLocalParameter4fvARB(int target, Int32 index, IntPtr @params)
        {
            unsafe
            {
                Delegates.glProgramLocalParameter4fvARB((int)target, (UInt32)index, (Single*)@params);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetProgramEnvParameterdvARB(int target, UInt32 index, [Out] Double[] @params)
        {
            unsafe
            {
                fixed (Double* @params_ptr = @params)
                {
                    Delegates.glGetProgramEnvParameterdvARB((int)target, (UInt32)index, (Double*)@params_ptr);
                }
            }
        }

        public static 
        void glGetProgramEnvParameterdvARB(int target, Int32 index, [Out] Double[] @params)
        {
            unsafe
            {
                fixed (Double* @params_ptr = @params)
                {
                    Delegates.glGetProgramEnvParameterdvARB((int)target, (UInt32)index, (Double*)@params_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetProgramEnvParameterdvARB(int target, UInt32 index, [Out] out Double @params)
        {
            unsafe
            {
                fixed (Double* @params_ptr = &@params)
                {
                    Delegates.glGetProgramEnvParameterdvARB((int)target, (UInt32)index, (Double*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetProgramEnvParameterdvARB(int target, Int32 index, [Out] out Double @params)
        {
            unsafe
            {
                fixed (Double* @params_ptr = &@params)
                {
                    Delegates.glGetProgramEnvParameterdvARB((int)target, (UInt32)index, (Double*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetProgramEnvParameterdvARB(int target, UInt32 index, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetProgramEnvParameterdvARB((int)target, (UInt32)index, (Double*)@params);
            }
        }

        public static 
        void glGetProgramEnvParameterdvARB(int target, Int32 index, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetProgramEnvParameterdvARB((int)target, (UInt32)index, (Double*)@params);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetProgramEnvParameterfvARB(int target, UInt32 index, [Out] Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glGetProgramEnvParameterfvARB((int)target, (UInt32)index, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glGetProgramEnvParameterfvARB(int target, Int32 index, [Out] Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glGetProgramEnvParameterfvARB((int)target, (UInt32)index, (Single*)@params_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetProgramEnvParameterfvARB(int target, UInt32 index, [Out] out Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glGetProgramEnvParameterfvARB((int)target, (UInt32)index, (Single*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetProgramEnvParameterfvARB(int target, Int32 index, [Out] out Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glGetProgramEnvParameterfvARB((int)target, (UInt32)index, (Single*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetProgramEnvParameterfvARB(int target, UInt32 index, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetProgramEnvParameterfvARB((int)target, (UInt32)index, (Single*)@params);
            }
        }

        public static 
        void glGetProgramEnvParameterfvARB(int target, Int32 index, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetProgramEnvParameterfvARB((int)target, (UInt32)index, (Single*)@params);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetProgramLocalParameterdvARB(int target, UInt32 index, [Out] Double[] @params)
        {
            unsafe
            {
                fixed (Double* @params_ptr = @params)
                {
                    Delegates.glGetProgramLocalParameterdvARB((int)target, (UInt32)index, (Double*)@params_ptr);
                }
            }
        }

        public static 
        void glGetProgramLocalParameterdvARB(int target, Int32 index, [Out] Double[] @params)
        {
            unsafe
            {
                fixed (Double* @params_ptr = @params)
                {
                    Delegates.glGetProgramLocalParameterdvARB((int)target, (UInt32)index, (Double*)@params_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetProgramLocalParameterdvARB(int target, UInt32 index, [Out] out Double @params)
        {
            unsafe
            {
                fixed (Double* @params_ptr = &@params)
                {
                    Delegates.glGetProgramLocalParameterdvARB((int)target, (UInt32)index, (Double*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetProgramLocalParameterdvARB(int target, Int32 index, [Out] out Double @params)
        {
            unsafe
            {
                fixed (Double* @params_ptr = &@params)
                {
                    Delegates.glGetProgramLocalParameterdvARB((int)target, (UInt32)index, (Double*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetProgramLocalParameterdvARB(int target, UInt32 index, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetProgramLocalParameterdvARB((int)target, (UInt32)index, (Double*)@params);
            }
        }

        public static 
        void glGetProgramLocalParameterdvARB(int target, Int32 index, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetProgramLocalParameterdvARB((int)target, (UInt32)index, (Double*)@params);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetProgramLocalParameterfvARB(int target, UInt32 index, [Out] Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glGetProgramLocalParameterfvARB((int)target, (UInt32)index, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glGetProgramLocalParameterfvARB(int target, Int32 index, [Out] Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glGetProgramLocalParameterfvARB((int)target, (UInt32)index, (Single*)@params_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetProgramLocalParameterfvARB(int target, UInt32 index, [Out] out Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glGetProgramLocalParameterfvARB((int)target, (UInt32)index, (Single*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetProgramLocalParameterfvARB(int target, Int32 index, [Out] out Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glGetProgramLocalParameterfvARB((int)target, (UInt32)index, (Single*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetProgramLocalParameterfvARB(int target, UInt32 index, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetProgramLocalParameterfvARB((int)target, (UInt32)index, (Single*)@params);
            }
        }

        public static 
        void glGetProgramLocalParameterfvARB(int target, Int32 index, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetProgramLocalParameterfvARB((int)target, (UInt32)index, (Single*)@params);
            }
        }

        public static 
        void glGetProgramivARB(int target, int pname, [Out] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetProgramivARB((int)target, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glGetProgramivARB(int target, int pname, [Out] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetProgramivARB((int)target, (int)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetProgramivARB(int target, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetProgramivARB((int)target, (int)pname, (Int32*)@params);
            }
        }

        public static 
        void glGetProgramStringARB(int target, int pname, [Out] IntPtr @string)
        {
            unsafe
            {
                Delegates.glGetProgramStringARB((int)target, (int)pname, (IntPtr)@string);
            }
        }

        public static 
        void glGetProgramStringARB(int target, int pname, [In, Out] object @string)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle @string_ptr = System.Runtime.InteropServices.GCHandle.Alloc(@string, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glGetProgramStringARB((int)target, (int)pname, (IntPtr)@string_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    @string_ptr.Free();
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetVertexAttribdvARB(UInt32 index, int pname, [Out] Double[] @params)
        {
            unsafe
            {
                fixed (Double* @params_ptr = @params)
                {
                    Delegates.glGetVertexAttribdvARB((UInt32)index, (int)pname, (Double*)@params_ptr);
                }
            }
        }

        public static 
        void glGetVertexAttribdvARB(Int32 index, int pname, [Out] Double[] @params)
        {
            unsafe
            {
                fixed (Double* @params_ptr = @params)
                {
                    Delegates.glGetVertexAttribdvARB((UInt32)index, (int)pname, (Double*)@params_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetVertexAttribdvARB(UInt32 index, int pname, [Out] out Double @params)
        {
            unsafe
            {
                fixed (Double* @params_ptr = &@params)
                {
                    Delegates.glGetVertexAttribdvARB((UInt32)index, (int)pname, (Double*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetVertexAttribdvARB(Int32 index, int pname, [Out] out Double @params)
        {
            unsafe
            {
                fixed (Double* @params_ptr = &@params)
                {
                    Delegates.glGetVertexAttribdvARB((UInt32)index, (int)pname, (Double*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetVertexAttribdvARB(UInt32 index, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetVertexAttribdvARB((UInt32)index, (int)pname, (Double*)@params);
            }
        }

        public static 
        void glGetVertexAttribdvARB(Int32 index, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetVertexAttribdvARB((UInt32)index, (int)pname, (Double*)@params);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetVertexAttribfvARB(UInt32 index, int pname, [Out] Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glGetVertexAttribfvARB((UInt32)index, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glGetVertexAttribfvARB(Int32 index, int pname, [Out] Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glGetVertexAttribfvARB((UInt32)index, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetVertexAttribfvARB(UInt32 index, int pname, [Out] out Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glGetVertexAttribfvARB((UInt32)index, (int)pname, (Single*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetVertexAttribfvARB(Int32 index, int pname, [Out] out Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glGetVertexAttribfvARB((UInt32)index, (int)pname, (Single*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetVertexAttribfvARB(UInt32 index, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetVertexAttribfvARB((UInt32)index, (int)pname, (Single*)@params);
            }
        }

        public static 
        void glGetVertexAttribfvARB(Int32 index, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetVertexAttribfvARB((UInt32)index, (int)pname, (Single*)@params);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetVertexAttribivARB(UInt32 index, int pname, [Out] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetVertexAttribivARB((UInt32)index, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glGetVertexAttribivARB(Int32 index, int pname, [Out] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetVertexAttribivARB((UInt32)index, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetVertexAttribivARB(UInt32 index, int pname, [Out] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetVertexAttribivARB((UInt32)index, (int)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetVertexAttribivARB(Int32 index, int pname, [Out] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetVertexAttribivARB((UInt32)index, (int)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetVertexAttribivARB(UInt32 index, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetVertexAttribivARB((UInt32)index, (int)pname, (Int32*)@params);
            }
        }

        public static 
        void glGetVertexAttribivARB(Int32 index, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetVertexAttribivARB((UInt32)index, (int)pname, (Int32*)@params);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetVertexAttribPointervARB(UInt32 index, int pname, [Out] IntPtr pointer)
        {
            unsafe
            {
                Delegates.glGetVertexAttribPointervARB((UInt32)index, (int)pname, (IntPtr)pointer);
            }
        }

        public static 
        void glGetVertexAttribPointervARB(Int32 index, int pname, [Out] IntPtr pointer)
        {
            unsafe
            {
                Delegates.glGetVertexAttribPointervARB((UInt32)index, (int)pname, (IntPtr)pointer);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetVertexAttribPointervARB(UInt32 index, int pname, [In, Out] object pointer)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle pointer_ptr = System.Runtime.InteropServices.GCHandle.Alloc(pointer, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glGetVertexAttribPointervARB((UInt32)index, (int)pname, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
            }
        }

        public static 
        void glGetVertexAttribPointervARB(Int32 index, int pname, [In, Out] object pointer)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle pointer_ptr = System.Runtime.InteropServices.GCHandle.Alloc(pointer, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glGetVertexAttribPointervARB((UInt32)index, (int)pname, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        bool glIsProgramARB(UInt32 program)
        {
            return Delegates.glIsProgramARB((UInt32)program);
        }

        public static 
        bool glIsProgramARB(Int32 program)
        {
            return Delegates.glIsProgramARB((UInt32)program);
        }

        [System.CLSCompliant(false)]
        public static 
        void glBindBufferARB(int target, UInt32 buffer)
        {
            Delegates.glBindBufferARB((int)target, (UInt32)buffer);
        }

        public static 
        void glBindBufferARB(int target, Int32 buffer)
        {
            Delegates.glBindBufferARB((int)target, (UInt32)buffer);
        }

        [System.CLSCompliant(false)]
        public static 
        void glDeleteBuffersARB(Int32 n, UInt32[] buffers)
        {
            unsafe
            {
                fixed (UInt32* buffers_ptr = buffers)
                {
                    Delegates.glDeleteBuffersARB((Int32)n, (UInt32*)buffers_ptr);
                }
            }
        }

        public static 
        void glDeleteBuffersARB(Int32 n, Int32[] buffers)
        {
            unsafe
            {
                fixed (Int32* buffers_ptr = buffers)
                {
                    Delegates.glDeleteBuffersARB((Int32)n, (UInt32*)buffers_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glDeleteBuffersARB(Int32 n, ref UInt32 buffers)
        {
            unsafe
            {
                fixed (UInt32* buffers_ptr = &buffers)
                {
                    Delegates.glDeleteBuffersARB((Int32)n, (UInt32*)buffers_ptr);
                }
            }
        }

        public static 
        void glDeleteBuffersARB(Int32 n, ref Int32 buffers)
        {
            unsafe
            {
                fixed (Int32* buffers_ptr = &buffers)
                {
                    Delegates.glDeleteBuffersARB((Int32)n, (UInt32*)buffers_ptr);
                }
            }
        }

        public static 
        void glDeleteBuffersARB(Int32 n, IntPtr buffers)
        {
            unsafe
            {
                Delegates.glDeleteBuffersARB((Int32)n, (UInt32*)buffers);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGenBuffersARB(Int32 n, [Out] UInt32[] buffers)
        {
            unsafe
            {
                fixed (UInt32* buffers_ptr = buffers)
                {
                    Delegates.glGenBuffersARB((Int32)n, (UInt32*)buffers_ptr);
                }
            }
        }

        public static 
        void glGenBuffersARB(Int32 n, [Out] Int32[] buffers)
        {
            unsafe
            {
                fixed (Int32* buffers_ptr = buffers)
                {
                    Delegates.glGenBuffersARB((Int32)n, (UInt32*)buffers_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGenBuffersARB(Int32 n, [Out] out UInt32 buffers)
        {
            unsafe
            {
                fixed (UInt32* buffers_ptr = &buffers)
                {
                    Delegates.glGenBuffersARB((Int32)n, (UInt32*)buffers_ptr);
                    buffers = *buffers_ptr;
                }
            }
        }

        public static 
        void glGenBuffersARB(Int32 n, [Out] out Int32 buffers)
        {
            unsafe
            {
                fixed (Int32* buffers_ptr = &buffers)
                {
                    Delegates.glGenBuffersARB((Int32)n, (UInt32*)buffers_ptr);
                    buffers = *buffers_ptr;
                }
            }
        }

        public static 
        void glGenBuffersARB(Int32 n, [Out] IntPtr buffers)
        {
            unsafe
            {
                Delegates.glGenBuffersARB((Int32)n, (UInt32*)buffers);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        bool glIsBufferARB(UInt32 buffer)
        {
            return Delegates.glIsBufferARB((UInt32)buffer);
        }

        public static 
        bool glIsBufferARB(Int32 buffer)
        {
            return Delegates.glIsBufferARB((UInt32)buffer);
        }

        public static 
        void glBufferDataARB(int target, IntPtr size, IntPtr data, int usage)
        {
            unsafe
            {
                Delegates.glBufferDataARB((int)target, (IntPtr)size, (IntPtr)data, (int)usage);
            }
        }

        public static 
        void glBufferDataARB(int target, IntPtr size, [In, Out] object data, int usage)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle data_ptr = System.Runtime.InteropServices.GCHandle.Alloc(data, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glBufferDataARB((int)target, (IntPtr)size, (IntPtr)data_ptr.AddrOfPinnedObject(), (int)usage);
                }
                finally
                {
                    data_ptr.Free();
                }
            }
        }

        public static 
        void glBufferSubDataARB(int target, IntPtr offset, IntPtr size, IntPtr data)
        {
            unsafe
            {
                Delegates.glBufferSubDataARB((int)target, (IntPtr)offset, (IntPtr)size, (IntPtr)data);
            }
        }

        public static 
        void glBufferSubDataARB(int target, IntPtr offset, IntPtr size, [In, Out] object data)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle data_ptr = System.Runtime.InteropServices.GCHandle.Alloc(data, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glBufferSubDataARB((int)target, (IntPtr)offset, (IntPtr)size, (IntPtr)data_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    data_ptr.Free();
                }
            }
        }

        public static 
        void glGetBufferSubDataARB(int target, IntPtr offset, IntPtr size, [Out] IntPtr data)
        {
            unsafe
            {
                Delegates.glGetBufferSubDataARB((int)target, (IntPtr)offset, (IntPtr)size, (IntPtr)data);
            }
        }

        public static 
        void glGetBufferSubDataARB(int target, IntPtr offset, IntPtr size, [In, Out] object data)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle data_ptr = System.Runtime.InteropServices.GCHandle.Alloc(data, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glGetBufferSubDataARB((int)target, (IntPtr)offset, (IntPtr)size, (IntPtr)data_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    data_ptr.Free();
                }
            }
        }

        public static 
        IntPtr glMapBufferARB(int target, int access)
        {
            return Delegates.glMapBufferARB((int)target, (int)access);
        }

        public static 
        bool glUnmapBufferARB(int target)
        {
            return Delegates.glUnmapBufferARB((int)target);
        }

        public static 
        void glGetBufferParameterivARB(int target, int pname, [Out] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetBufferParameterivARB((int)target, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glGetBufferParameterivARB(int target, int pname, [Out] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetBufferParameterivARB((int)target, (int)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetBufferParameterivARB(int target, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetBufferParameterivARB((int)target, (int)pname, (Int32*)@params);
            }
        }

        public static 
        void glGetBufferPointervARB(int target, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetBufferPointervARB((int)target, (int)pname, (IntPtr)@params);
            }
        }

        public static 
        void glGetBufferPointervARB(int target, int pname, [In, Out] object @params)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle @params_ptr = System.Runtime.InteropServices.GCHandle.Alloc(@params, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glGetBufferPointervARB((int)target, (int)pname, (IntPtr)@params_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    @params_ptr.Free();
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGenQueriesARB(Int32 n, [Out] UInt32[] ids)
        {
            unsafe
            {
                fixed (UInt32* ids_ptr = ids)
                {
                    Delegates.glGenQueriesARB((Int32)n, (UInt32*)ids_ptr);
                }
            }
        }

        public static 
        void glGenQueriesARB(Int32 n, [Out] Int32[] ids)
        {
            unsafe
            {
                fixed (Int32* ids_ptr = ids)
                {
                    Delegates.glGenQueriesARB((Int32)n, (UInt32*)ids_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGenQueriesARB(Int32 n, [Out] out UInt32 ids)
        {
            unsafe
            {
                fixed (UInt32* ids_ptr = &ids)
                {
                    Delegates.glGenQueriesARB((Int32)n, (UInt32*)ids_ptr);
                    ids = *ids_ptr;
                }
            }
        }

        public static 
        void glGenQueriesARB(Int32 n, [Out] out Int32 ids)
        {
            unsafe
            {
                fixed (Int32* ids_ptr = &ids)
                {
                    Delegates.glGenQueriesARB((Int32)n, (UInt32*)ids_ptr);
                    ids = *ids_ptr;
                }
            }
        }

        public static 
        void glGenQueriesARB(Int32 n, [Out] IntPtr ids)
        {
            unsafe
            {
                Delegates.glGenQueriesARB((Int32)n, (UInt32*)ids);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glDeleteQueriesARB(Int32 n, UInt32[] ids)
        {
            unsafe
            {
                fixed (UInt32* ids_ptr = ids)
                {
                    Delegates.glDeleteQueriesARB((Int32)n, (UInt32*)ids_ptr);
                }
            }
        }

        public static 
        void glDeleteQueriesARB(Int32 n, Int32[] ids)
        {
            unsafe
            {
                fixed (Int32* ids_ptr = ids)
                {
                    Delegates.glDeleteQueriesARB((Int32)n, (UInt32*)ids_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glDeleteQueriesARB(Int32 n, ref UInt32 ids)
        {
            unsafe
            {
                fixed (UInt32* ids_ptr = &ids)
                {
                    Delegates.glDeleteQueriesARB((Int32)n, (UInt32*)ids_ptr);
                }
            }
        }

        public static 
        void glDeleteQueriesARB(Int32 n, ref Int32 ids)
        {
            unsafe
            {
                fixed (Int32* ids_ptr = &ids)
                {
                    Delegates.glDeleteQueriesARB((Int32)n, (UInt32*)ids_ptr);
                }
            }
        }

        public static 
        void glDeleteQueriesARB(Int32 n, IntPtr ids)
        {
            unsafe
            {
                Delegates.glDeleteQueriesARB((Int32)n, (UInt32*)ids);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        bool glIsQueryARB(UInt32 id)
        {
            return Delegates.glIsQueryARB((UInt32)id);
        }

        public static 
        bool glIsQueryARB(Int32 id)
        {
            return Delegates.glIsQueryARB((UInt32)id);
        }

        [System.CLSCompliant(false)]
        public static 
        void glBeginQueryARB(int target, UInt32 id)
        {
            Delegates.glBeginQueryARB((int)target, (UInt32)id);
        }

        public static 
        void glBeginQueryARB(int target, Int32 id)
        {
            Delegates.glBeginQueryARB((int)target, (UInt32)id);
        }

        public static 
        void glEndQueryARB(int target)
        {
            Delegates.glEndQueryARB((int)target);
        }

        public static 
        void glGetQueryivARB(int target, int pname, [Out] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetQueryivARB((int)target, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glGetQueryivARB(int target, int pname, [Out] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetQueryivARB((int)target, (int)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetQueryivARB(int target, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetQueryivARB((int)target, (int)pname, (Int32*)@params);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetQueryObjectivARB(UInt32 id, int pname, [Out] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetQueryObjectivARB((UInt32)id, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glGetQueryObjectivARB(Int32 id, int pname, [Out] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetQueryObjectivARB((UInt32)id, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetQueryObjectivARB(UInt32 id, int pname, [Out] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetQueryObjectivARB((UInt32)id, (int)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetQueryObjectivARB(Int32 id, int pname, [Out] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetQueryObjectivARB((UInt32)id, (int)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetQueryObjectivARB(UInt32 id, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetQueryObjectivARB((UInt32)id, (int)pname, (Int32*)@params);
            }
        }

        public static 
        void glGetQueryObjectivARB(Int32 id, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetQueryObjectivARB((UInt32)id, (int)pname, (Int32*)@params);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetQueryObjectuivARB(UInt32 id, int pname, [Out] UInt32[] @params)
        {
            unsafe
            {
                fixed (UInt32* @params_ptr = @params)
                {
                    Delegates.glGetQueryObjectuivARB((UInt32)id, (int)pname, (UInt32*)@params_ptr);
                }
            }
        }

        public static 
        void glGetQueryObjectuivARB(Int32 id, int pname, [Out] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetQueryObjectuivARB((UInt32)id, (int)pname, (UInt32*)@params_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetQueryObjectuivARB(UInt32 id, int pname, [Out] out UInt32 @params)
        {
            unsafe
            {
                fixed (UInt32* @params_ptr = &@params)
                {
                    Delegates.glGetQueryObjectuivARB((UInt32)id, (int)pname, (UInt32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetQueryObjectuivARB(Int32 id, int pname, [Out] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetQueryObjectuivARB((UInt32)id, (int)pname, (UInt32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetQueryObjectuivARB(UInt32 id, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetQueryObjectuivARB((UInt32)id, (int)pname, (UInt32*)@params);
            }
        }

        public static 
        void glGetQueryObjectuivARB(Int32 id, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetQueryObjectuivARB((UInt32)id, (int)pname, (UInt32*)@params);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glDeleteObjectARB(UInt32 obj)
        {
            Delegates.glDeleteObjectARB((UInt32)obj);
        }

        public static 
        void glDeleteObjectARB(Int32 obj)
        {
            Delegates.glDeleteObjectARB((UInt32)obj);
        }

        public static 
        Int32 glGetHandleARB(int pname)
        {
            return Delegates.glGetHandleARB((int)pname);
        }

        [System.CLSCompliant(false)]
        public static 
        void glDetachObjectARB(UInt32 containerObj, UInt32 attachedObj)
        {
            Delegates.glDetachObjectARB((UInt32)containerObj, (UInt32)attachedObj);
        }

        public static 
        void glDetachObjectARB(Int32 containerObj, Int32 attachedObj)
        {
            Delegates.glDetachObjectARB((UInt32)containerObj, (UInt32)attachedObj);
        }

        public static 
        Int32 glCreateShaderObjectARB(int shaderType)
        {
            return Delegates.glCreateShaderObjectARB((int)shaderType);
        }

        [System.CLSCompliant(false)]
        public static 
        void glShaderSourceARB(UInt32 shaderObj, Int32 count, System.String[] @string, Int32[] length)
        {
            unsafe
            {
                fixed (Int32* length_ptr = length)
                {
                    Delegates.glShaderSourceARB((UInt32)shaderObj, (Int32)count, (System.String[])@string, (Int32*)length_ptr);
                }
            }
        }

        public static 
        void glShaderSourceARB(Int32 shaderObj, Int32 count, System.String[] @string, Int32[] length)
        {
            unsafe
            {
                fixed (Int32* length_ptr = length)
                {
                    Delegates.glShaderSourceARB((UInt32)shaderObj, (Int32)count, (System.String[])@string, (Int32*)length_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glShaderSourceARB(UInt32 shaderObj, Int32 count, System.String[] @string, ref Int32 length)
        {
            unsafe
            {
                fixed (Int32* length_ptr = &length)
                {
                    Delegates.glShaderSourceARB((UInt32)shaderObj, (Int32)count, (System.String[])@string, (Int32*)length_ptr);
                }
            }
        }

        public static 
        void glShaderSourceARB(Int32 shaderObj, Int32 count, System.String[] @string, ref Int32 length)
        {
            unsafe
            {
                fixed (Int32* length_ptr = &length)
                {
                    Delegates.glShaderSourceARB((UInt32)shaderObj, (Int32)count, (System.String[])@string, (Int32*)length_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glShaderSourceARB(UInt32 shaderObj, Int32 count, System.String[] @string, IntPtr length)
        {
            unsafe
            {
                Delegates.glShaderSourceARB((UInt32)shaderObj, (Int32)count, (System.String[])@string, (Int32*)length);
            }
        }

        public static 
        void glShaderSourceARB(Int32 shaderObj, Int32 count, System.String[] @string, IntPtr length)
        {
            unsafe
            {
                Delegates.glShaderSourceARB((UInt32)shaderObj, (Int32)count, (System.String[])@string, (Int32*)length);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glCompileShaderARB(UInt32 shaderObj)
        {
            Delegates.glCompileShaderARB((UInt32)shaderObj);
        }

        public static 
        void glCompileShaderARB(Int32 shaderObj)
        {
            Delegates.glCompileShaderARB((UInt32)shaderObj);
        }

        public static 
        Int32 glCreateProgramObjectARB()
        {
            return Delegates.glCreateProgramObjectARB();
        }

        [System.CLSCompliant(false)]
        public static 
        void glAttachObjectARB(UInt32 containerObj, UInt32 obj)
        {
            Delegates.glAttachObjectARB((UInt32)containerObj, (UInt32)obj);
        }

        public static 
        void glAttachObjectARB(Int32 containerObj, Int32 obj)
        {
            Delegates.glAttachObjectARB((UInt32)containerObj, (UInt32)obj);
        }

        [System.CLSCompliant(false)]
        public static 
        void glLinkProgramARB(UInt32 programObj)
        {
            Delegates.glLinkProgramARB((UInt32)programObj);
        }

        public static 
        void glLinkProgramARB(Int32 programObj)
        {
            Delegates.glLinkProgramARB((UInt32)programObj);
        }

        [System.CLSCompliant(false)]
        public static 
        void glUseProgramObjectARB(UInt32 programObj)
        {
            Delegates.glUseProgramObjectARB((UInt32)programObj);
        }

        public static 
        void glUseProgramObjectARB(Int32 programObj)
        {
            Delegates.glUseProgramObjectARB((UInt32)programObj);
        }

        [System.CLSCompliant(false)]
        public static 
        void glValidateProgramARB(UInt32 programObj)
        {
            Delegates.glValidateProgramARB((UInt32)programObj);
        }

        public static 
        void glValidateProgramARB(Int32 programObj)
        {
            Delegates.glValidateProgramARB((UInt32)programObj);
        }

        public static 
        void glUniform1fARB(Int32 location, Single v0)
        {
            Delegates.glUniform1fARB((Int32)location, (Single)v0);
        }

        public static 
        void glUniform2fARB(Int32 location, Single v0, Single v1)
        {
            Delegates.glUniform2fARB((Int32)location, (Single)v0, (Single)v1);
        }

        public static 
        void glUniform3fARB(Int32 location, Single v0, Single v1, Single v2)
        {
            Delegates.glUniform3fARB((Int32)location, (Single)v0, (Single)v1, (Single)v2);
        }

        public static 
        void glUniform4fARB(Int32 location, Single v0, Single v1, Single v2, Single v3)
        {
            Delegates.glUniform4fARB((Int32)location, (Single)v0, (Single)v1, (Single)v2, (Single)v3);
        }

        public static 
        void glUniform1iARB(Int32 location, Int32 v0)
        {
            Delegates.glUniform1iARB((Int32)location, (Int32)v0);
        }

        public static 
        void glUniform2iARB(Int32 location, Int32 v0, Int32 v1)
        {
            Delegates.glUniform2iARB((Int32)location, (Int32)v0, (Int32)v1);
        }

        public static 
        void glUniform3iARB(Int32 location, Int32 v0, Int32 v1, Int32 v2)
        {
            Delegates.glUniform3iARB((Int32)location, (Int32)v0, (Int32)v1, (Int32)v2);
        }

        public static 
        void glUniform4iARB(Int32 location, Int32 v0, Int32 v1, Int32 v2, Int32 v3)
        {
            Delegates.glUniform4iARB((Int32)location, (Int32)v0, (Int32)v1, (Int32)v2, (Int32)v3);
        }

        public static 
        void glUniform1fvARB(Int32 location, Int32 count, Single[] value)
        {
            unsafe
            {
                fixed (Single* value_ptr = value)
                {
                    Delegates.glUniform1fvARB((Int32)location, (Int32)count, (Single*)value_ptr);
                }
            }
        }

        public static 
        void glUniform1fvARB(Int32 location, Int32 count, ref Single value)
        {
            unsafe
            {
                fixed (Single* value_ptr = &value)
                {
                    Delegates.glUniform1fvARB((Int32)location, (Int32)count, (Single*)value_ptr);
                }
            }
        }

        public static 
        void glUniform1fvARB(Int32 location, Int32 count, IntPtr value)
        {
            unsafe
            {
                Delegates.glUniform1fvARB((Int32)location, (Int32)count, (Single*)value);
            }
        }

        public static 
        void glUniform2fvARB(Int32 location, Int32 count, Single[] value)
        {
            unsafe
            {
                fixed (Single* value_ptr = value)
                {
                    Delegates.glUniform2fvARB((Int32)location, (Int32)count, (Single*)value_ptr);
                }
            }
        }

        public static 
        void glUniform2fvARB(Int32 location, Int32 count, ref Single value)
        {
            unsafe
            {
                fixed (Single* value_ptr = &value)
                {
                    Delegates.glUniform2fvARB((Int32)location, (Int32)count, (Single*)value_ptr);
                }
            }
        }

        public static 
        void glUniform2fvARB(Int32 location, Int32 count, IntPtr value)
        {
            unsafe
            {
                Delegates.glUniform2fvARB((Int32)location, (Int32)count, (Single*)value);
            }
        }

        public static 
        void glUniform3fvARB(Int32 location, Int32 count, Single[] value)
        {
            unsafe
            {
                fixed (Single* value_ptr = value)
                {
                    Delegates.glUniform3fvARB((Int32)location, (Int32)count, (Single*)value_ptr);
                }
            }
        }

        public static 
        void glUniform3fvARB(Int32 location, Int32 count, ref Single value)
        {
            unsafe
            {
                fixed (Single* value_ptr = &value)
                {
                    Delegates.glUniform3fvARB((Int32)location, (Int32)count, (Single*)value_ptr);
                }
            }
        }

        public static 
        void glUniform3fvARB(Int32 location, Int32 count, IntPtr value)
        {
            unsafe
            {
                Delegates.glUniform3fvARB((Int32)location, (Int32)count, (Single*)value);
            }
        }

        public static 
        void glUniform4fvARB(Int32 location, Int32 count, Single[] value)
        {
            unsafe
            {
                fixed (Single* value_ptr = value)
                {
                    Delegates.glUniform4fvARB((Int32)location, (Int32)count, (Single*)value_ptr);
                }
            }
        }

        public static 
        void glUniform4fvARB(Int32 location, Int32 count, ref Single value)
        {
            unsafe
            {
                fixed (Single* value_ptr = &value)
                {
                    Delegates.glUniform4fvARB((Int32)location, (Int32)count, (Single*)value_ptr);
                }
            }
        }

        public static 
        void glUniform4fvARB(Int32 location, Int32 count, IntPtr value)
        {
            unsafe
            {
                Delegates.glUniform4fvARB((Int32)location, (Int32)count, (Single*)value);
            }
        }

        public static 
        void glUniform1ivARB(Int32 location, Int32 count, Int32[] value)
        {
            unsafe
            {
                fixed (Int32* value_ptr = value)
                {
                    Delegates.glUniform1ivARB((Int32)location, (Int32)count, (Int32*)value_ptr);
                }
            }
        }

        public static 
        void glUniform1ivARB(Int32 location, Int32 count, ref Int32 value)
        {
            unsafe
            {
                fixed (Int32* value_ptr = &value)
                {
                    Delegates.glUniform1ivARB((Int32)location, (Int32)count, (Int32*)value_ptr);
                }
            }
        }

        public static 
        void glUniform1ivARB(Int32 location, Int32 count, IntPtr value)
        {
            unsafe
            {
                Delegates.glUniform1ivARB((Int32)location, (Int32)count, (Int32*)value);
            }
        }

        public static 
        void glUniform2ivARB(Int32 location, Int32 count, Int32[] value)
        {
            unsafe
            {
                fixed (Int32* value_ptr = value)
                {
                    Delegates.glUniform2ivARB((Int32)location, (Int32)count, (Int32*)value_ptr);
                }
            }
        }

        public static 
        void glUniform2ivARB(Int32 location, Int32 count, ref Int32 value)
        {
            unsafe
            {
                fixed (Int32* value_ptr = &value)
                {
                    Delegates.glUniform2ivARB((Int32)location, (Int32)count, (Int32*)value_ptr);
                }
            }
        }

        public static 
        void glUniform2ivARB(Int32 location, Int32 count, IntPtr value)
        {
            unsafe
            {
                Delegates.glUniform2ivARB((Int32)location, (Int32)count, (Int32*)value);
            }
        }

        public static 
        void glUniform3ivARB(Int32 location, Int32 count, Int32[] value)
        {
            unsafe
            {
                fixed (Int32* value_ptr = value)
                {
                    Delegates.glUniform3ivARB((Int32)location, (Int32)count, (Int32*)value_ptr);
                }
            }
        }

        public static 
        void glUniform3ivARB(Int32 location, Int32 count, ref Int32 value)
        {
            unsafe
            {
                fixed (Int32* value_ptr = &value)
                {
                    Delegates.glUniform3ivARB((Int32)location, (Int32)count, (Int32*)value_ptr);
                }
            }
        }

        public static 
        void glUniform3ivARB(Int32 location, Int32 count, IntPtr value)
        {
            unsafe
            {
                Delegates.glUniform3ivARB((Int32)location, (Int32)count, (Int32*)value);
            }
        }

        public static 
        void glUniform4ivARB(Int32 location, Int32 count, Int32[] value)
        {
            unsafe
            {
                fixed (Int32* value_ptr = value)
                {
                    Delegates.glUniform4ivARB((Int32)location, (Int32)count, (Int32*)value_ptr);
                }
            }
        }

        public static 
        void glUniform4ivARB(Int32 location, Int32 count, ref Int32 value)
        {
            unsafe
            {
                fixed (Int32* value_ptr = &value)
                {
                    Delegates.glUniform4ivARB((Int32)location, (Int32)count, (Int32*)value_ptr);
                }
            }
        }

        public static 
        void glUniform4ivARB(Int32 location, Int32 count, IntPtr value)
        {
            unsafe
            {
                Delegates.glUniform4ivARB((Int32)location, (Int32)count, (Int32*)value);
            }
        }

        public static 
        void glUniformMatrix2fvARB(Int32 location, Int32 count, bool transpose, Single[] value)
        {
            unsafe
            {
                fixed (Single* value_ptr = value)
                {
                    Delegates.glUniformMatrix2fvARB((Int32)location, (Int32)count, (bool)transpose, (Single*)value_ptr);
                }
            }
        }

        public static 
        void glUniformMatrix2fvARB(Int32 location, Int32 count, bool transpose, ref Single value)
        {
            unsafe
            {
                fixed (Single* value_ptr = &value)
                {
                    Delegates.glUniformMatrix2fvARB((Int32)location, (Int32)count, (bool)transpose, (Single*)value_ptr);
                }
            }
        }

        public static 
        void glUniformMatrix2fvARB(Int32 location, Int32 count, bool transpose, IntPtr value)
        {
            unsafe
            {
                Delegates.glUniformMatrix2fvARB((Int32)location, (Int32)count, (bool)transpose, (Single*)value);
            }
        }

        public static 
        void glUniformMatrix3fvARB(Int32 location, Int32 count, bool transpose, Single[] value)
        {
            unsafe
            {
                fixed (Single* value_ptr = value)
                {
                    Delegates.glUniformMatrix3fvARB((Int32)location, (Int32)count, (bool)transpose, (Single*)value_ptr);
                }
            }
        }

        public static 
        void glUniformMatrix3fvARB(Int32 location, Int32 count, bool transpose, ref Single value)
        {
            unsafe
            {
                fixed (Single* value_ptr = &value)
                {
                    Delegates.glUniformMatrix3fvARB((Int32)location, (Int32)count, (bool)transpose, (Single*)value_ptr);
                }
            }
        }

        public static 
        void glUniformMatrix3fvARB(Int32 location, Int32 count, bool transpose, IntPtr value)
        {
            unsafe
            {
                Delegates.glUniformMatrix3fvARB((Int32)location, (Int32)count, (bool)transpose, (Single*)value);
            }
        }

        public static 
        void glUniformMatrix4fvARB(Int32 location, Int32 count, bool transpose, Single[] value)
        {
            unsafe
            {
                fixed (Single* value_ptr = value)
                {
                    Delegates.glUniformMatrix4fvARB((Int32)location, (Int32)count, (bool)transpose, (Single*)value_ptr);
                }
            }
        }

        public static 
        void glUniformMatrix4fvARB(Int32 location, Int32 count, bool transpose, ref Single value)
        {
            unsafe
            {
                fixed (Single* value_ptr = &value)
                {
                    Delegates.glUniformMatrix4fvARB((Int32)location, (Int32)count, (bool)transpose, (Single*)value_ptr);
                }
            }
        }

        public static 
        void glUniformMatrix4fvARB(Int32 location, Int32 count, bool transpose, IntPtr value)
        {
            unsafe
            {
                Delegates.glUniformMatrix4fvARB((Int32)location, (Int32)count, (bool)transpose, (Single*)value);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetObjectParameterfvARB(UInt32 obj, int pname, [Out] Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glGetObjectParameterfvARB((UInt32)obj, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glGetObjectParameterfvARB(Int32 obj, int pname, [Out] Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glGetObjectParameterfvARB((UInt32)obj, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetObjectParameterfvARB(UInt32 obj, int pname, [Out] out Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glGetObjectParameterfvARB((UInt32)obj, (int)pname, (Single*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetObjectParameterfvARB(Int32 obj, int pname, [Out] out Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glGetObjectParameterfvARB((UInt32)obj, (int)pname, (Single*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetObjectParameterfvARB(UInt32 obj, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetObjectParameterfvARB((UInt32)obj, (int)pname, (Single*)@params);
            }
        }

        public static 
        void glGetObjectParameterfvARB(Int32 obj, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetObjectParameterfvARB((UInt32)obj, (int)pname, (Single*)@params);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetObjectParameterivARB(UInt32 obj, int pname, [Out] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetObjectParameterivARB((UInt32)obj, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glGetObjectParameterivARB(Int32 obj, int pname, [Out] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetObjectParameterivARB((UInt32)obj, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetObjectParameterivARB(UInt32 obj, int pname, [Out] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetObjectParameterivARB((UInt32)obj, (int)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetObjectParameterivARB(Int32 obj, int pname, [Out] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetObjectParameterivARB((UInt32)obj, (int)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetObjectParameterivARB(UInt32 obj, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetObjectParameterivARB((UInt32)obj, (int)pname, (Int32*)@params);
            }
        }

        public static 
        void glGetObjectParameterivARB(Int32 obj, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetObjectParameterivARB((UInt32)obj, (int)pname, (Int32*)@params);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetInfoLogARB(UInt32 obj, Int32 maxLength, [Out] Int32[] length, [Out] System.Text.StringBuilder infoLog)
        {
            unsafe
            {
                fixed (Int32* length_ptr = length)
                {
                    Delegates.glGetInfoLogARB((UInt32)obj, (Int32)maxLength, (Int32*)length_ptr, (System.Text.StringBuilder)infoLog);
                }
            }
        }

        public static 
        void glGetInfoLogARB(Int32 obj, Int32 maxLength, [Out] Int32[] length, [Out] System.Text.StringBuilder infoLog)
        {
            unsafe
            {
                fixed (Int32* length_ptr = length)
                {
                    Delegates.glGetInfoLogARB((UInt32)obj, (Int32)maxLength, (Int32*)length_ptr, (System.Text.StringBuilder)infoLog);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetInfoLogARB(UInt32 obj, Int32 maxLength, [Out] out Int32 length, [Out] System.Text.StringBuilder infoLog)
        {
            unsafe
            {
                fixed (Int32* length_ptr = &length)
                {
                    Delegates.glGetInfoLogARB((UInt32)obj, (Int32)maxLength, (Int32*)length_ptr, (System.Text.StringBuilder)infoLog);
                    length = *length_ptr;
                }
            }
        }

        public static 
        void glGetInfoLogARB(Int32 obj, Int32 maxLength, [Out] out Int32 length, [Out] System.Text.StringBuilder infoLog)
        {
            unsafe
            {
                fixed (Int32* length_ptr = &length)
                {
                    Delegates.glGetInfoLogARB((UInt32)obj, (Int32)maxLength, (Int32*)length_ptr, (System.Text.StringBuilder)infoLog);
                    length = *length_ptr;
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetInfoLogARB(UInt32 obj, Int32 maxLength, [Out] IntPtr length, [Out] System.Text.StringBuilder infoLog)
        {
            unsafe
            {
                Delegates.glGetInfoLogARB((UInt32)obj, (Int32)maxLength, (Int32*)length, (System.Text.StringBuilder)infoLog);
            }
        }

        public static 
        void glGetInfoLogARB(Int32 obj, Int32 maxLength, [Out] IntPtr length, [Out] System.Text.StringBuilder infoLog)
        {
            unsafe
            {
                Delegates.glGetInfoLogARB((UInt32)obj, (Int32)maxLength, (Int32*)length, (System.Text.StringBuilder)infoLog);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetAttachedObjectsARB(UInt32 containerObj, Int32 maxCount, [Out] Int32[] count, [Out] UInt32[] obj)
        {
            unsafe
            {
                fixed (Int32* count_ptr = count)
                fixed (UInt32* obj_ptr = obj)
                {
                    Delegates.glGetAttachedObjectsARB((UInt32)containerObj, (Int32)maxCount, (Int32*)count_ptr, (UInt32*)obj_ptr);
                }
            }
        }

        public static 
        void glGetAttachedObjectsARB(Int32 containerObj, Int32 maxCount, [Out] Int32[] count, [Out] Int32[] obj)
        {
            unsafe
            {
                fixed (Int32* count_ptr = count)
                fixed (Int32* obj_ptr = obj)
                {
                    Delegates.glGetAttachedObjectsARB((UInt32)containerObj, (Int32)maxCount, (Int32*)count_ptr, (UInt32*)obj_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetAttachedObjectsARB(UInt32 containerObj, Int32 maxCount, [Out] out Int32 count, [Out] out UInt32 obj)
        {
            unsafe
            {
                fixed (Int32* count_ptr = &count)
                fixed (UInt32* obj_ptr = &obj)
                {
                    Delegates.glGetAttachedObjectsARB((UInt32)containerObj, (Int32)maxCount, (Int32*)count_ptr, (UInt32*)obj_ptr);
                    count = *count_ptr;
                    obj = *obj_ptr;
                }
            }
        }

        public static 
        void glGetAttachedObjectsARB(Int32 containerObj, Int32 maxCount, [Out] out Int32 count, [Out] out Int32 obj)
        {
            unsafe
            {
                fixed (Int32* count_ptr = &count)
                fixed (Int32* obj_ptr = &obj)
                {
                    Delegates.glGetAttachedObjectsARB((UInt32)containerObj, (Int32)maxCount, (Int32*)count_ptr, (UInt32*)obj_ptr);
                    count = *count_ptr;
                    obj = *obj_ptr;
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetAttachedObjectsARB(UInt32 containerObj, Int32 maxCount, [Out] IntPtr count, [Out] IntPtr obj)
        {
            unsafe
            {
                Delegates.glGetAttachedObjectsARB((UInt32)containerObj, (Int32)maxCount, (Int32*)count, (UInt32*)obj);
            }
        }

        public static 
        void glGetAttachedObjectsARB(Int32 containerObj, Int32 maxCount, [Out] IntPtr count, [Out] IntPtr obj)
        {
            unsafe
            {
                Delegates.glGetAttachedObjectsARB((UInt32)containerObj, (Int32)maxCount, (Int32*)count, (UInt32*)obj);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        Int32 glGetUniformLocationARB(UInt32 programObj, System.String name)
        {
            return Delegates.glGetUniformLocationARB((UInt32)programObj, (System.String)name);
        }

        public static 
        Int32 glGetUniformLocationARB(Int32 programObj, System.String name)
        {
            return Delegates.glGetUniformLocationARB((UInt32)programObj, (System.String)name);
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetActiveUniformARB(UInt32 programObj, UInt32 index, Int32 maxLength, [Out] Int32[] length, [Out] Int32[] size, [Out] int[] type, [Out] System.Text.StringBuilder name)
        {
            unsafe
            {
                fixed (Int32* length_ptr = length)
                fixed (Int32* size_ptr = size)
                fixed (int* type_ptr = type)
                {
                    Delegates.glGetActiveUniformARB((UInt32)programObj, (UInt32)index, (Int32)maxLength, (Int32*)length_ptr, (Int32*)size_ptr, (int*)type_ptr, (System.Text.StringBuilder)name);
                }
            }
        }

        public static 
        void glGetActiveUniformARB(Int32 programObj, Int32 index, Int32 maxLength, [Out] Int32[] length, [Out] Int32[] size, [Out] int[] type, [Out] System.Text.StringBuilder name)
        {
            unsafe
            {
                fixed (Int32* length_ptr = length)
                fixed (Int32* size_ptr = size)
                fixed (int* type_ptr = type)
                {
                    Delegates.glGetActiveUniformARB((UInt32)programObj, (UInt32)index, (Int32)maxLength, (Int32*)length_ptr, (Int32*)size_ptr, (int*)type_ptr, (System.Text.StringBuilder)name);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetActiveUniformARB(UInt32 programObj, UInt32 index, Int32 maxLength, [Out] out Int32 length, [Out] out Int32 size, [Out] out int type, [Out] System.Text.StringBuilder name)
        {
            unsafe
            {
                fixed (Int32* length_ptr = &length)
                fixed (Int32* size_ptr = &size)
                fixed (int* type_ptr = &type)
                {
                    Delegates.glGetActiveUniformARB((UInt32)programObj, (UInt32)index, (Int32)maxLength, (Int32*)length_ptr, (Int32*)size_ptr, (int*)type_ptr, (System.Text.StringBuilder)name);
                    length = *length_ptr;
                    size = *size_ptr;
                    type = *type_ptr;
                }
            }
        }

        public static 
        void glGetActiveUniformARB(Int32 programObj, Int32 index, Int32 maxLength, [Out] out Int32 length, [Out] out Int32 size, [Out] out int type, [Out] System.Text.StringBuilder name)
        {
            unsafe
            {
                fixed (Int32* length_ptr = &length)
                fixed (Int32* size_ptr = &size)
                fixed (int* type_ptr = &type)
                {
                    Delegates.glGetActiveUniformARB((UInt32)programObj, (UInt32)index, (Int32)maxLength, (Int32*)length_ptr, (Int32*)size_ptr, (int*)type_ptr, (System.Text.StringBuilder)name);
                    length = *length_ptr;
                    size = *size_ptr;
                    type = *type_ptr;
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetActiveUniformARB(UInt32 programObj, UInt32 index, Int32 maxLength, [Out] IntPtr length, [Out] IntPtr size, [Out] IntPtr type, [Out] System.Text.StringBuilder name)
        {
            unsafe
            {
                Delegates.glGetActiveUniformARB((UInt32)programObj, (UInt32)index, (Int32)maxLength, (Int32*)length, (Int32*)size, (int*)type, (System.Text.StringBuilder)name);
            }
        }

        public static 
        void glGetActiveUniformARB(Int32 programObj, Int32 index, Int32 maxLength, [Out] IntPtr length, [Out] IntPtr size, [Out] IntPtr type, [Out] System.Text.StringBuilder name)
        {
            unsafe
            {
                Delegates.glGetActiveUniformARB((UInt32)programObj, (UInt32)index, (Int32)maxLength, (Int32*)length, (Int32*)size, (int*)type, (System.Text.StringBuilder)name);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetUniformfvARB(UInt32 programObj, Int32 location, [Out] Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glGetUniformfvARB((UInt32)programObj, (Int32)location, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glGetUniformfvARB(Int32 programObj, Int32 location, [Out] Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glGetUniformfvARB((UInt32)programObj, (Int32)location, (Single*)@params_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetUniformfvARB(UInt32 programObj, Int32 location, [Out] out Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glGetUniformfvARB((UInt32)programObj, (Int32)location, (Single*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetUniformfvARB(Int32 programObj, Int32 location, [Out] out Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glGetUniformfvARB((UInt32)programObj, (Int32)location, (Single*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetUniformfvARB(UInt32 programObj, Int32 location, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetUniformfvARB((UInt32)programObj, (Int32)location, (Single*)@params);
            }
        }

        public static 
        void glGetUniformfvARB(Int32 programObj, Int32 location, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetUniformfvARB((UInt32)programObj, (Int32)location, (Single*)@params);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetUniformivARB(UInt32 programObj, Int32 location, [Out] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetUniformivARB((UInt32)programObj, (Int32)location, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glGetUniformivARB(Int32 programObj, Int32 location, [Out] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetUniformivARB((UInt32)programObj, (Int32)location, (Int32*)@params_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetUniformivARB(UInt32 programObj, Int32 location, [Out] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetUniformivARB((UInt32)programObj, (Int32)location, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetUniformivARB(Int32 programObj, Int32 location, [Out] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetUniformivARB((UInt32)programObj, (Int32)location, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetUniformivARB(UInt32 programObj, Int32 location, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetUniformivARB((UInt32)programObj, (Int32)location, (Int32*)@params);
            }
        }

        public static 
        void glGetUniformivARB(Int32 programObj, Int32 location, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetUniformivARB((UInt32)programObj, (Int32)location, (Int32*)@params);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetShaderSourceARB(UInt32 obj, Int32 maxLength, [Out] Int32[] length, [Out] System.Text.StringBuilder[] source)
        {
            unsafe
            {
                fixed (Int32* length_ptr = length)
                {
                    Delegates.glGetShaderSourceARB((UInt32)obj, (Int32)maxLength, (Int32*)length_ptr, (System.Text.StringBuilder[])source);
                }
            }
        }

        public static 
        void glGetShaderSourceARB(Int32 obj, Int32 maxLength, [Out] Int32[] length, [Out] System.Text.StringBuilder[] source)
        {
            unsafe
            {
                fixed (Int32* length_ptr = length)
                {
                    Delegates.glGetShaderSourceARB((UInt32)obj, (Int32)maxLength, (Int32*)length_ptr, (System.Text.StringBuilder[])source);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetShaderSourceARB(UInt32 obj, Int32 maxLength, [Out] out Int32 length, [Out] System.Text.StringBuilder[] source)
        {
            unsafe
            {
                fixed (Int32* length_ptr = &length)
                {
                    Delegates.glGetShaderSourceARB((UInt32)obj, (Int32)maxLength, (Int32*)length_ptr, (System.Text.StringBuilder[])source);
                    length = *length_ptr;
                }
            }
        }

        public static 
        void glGetShaderSourceARB(Int32 obj, Int32 maxLength, [Out] out Int32 length, [Out] System.Text.StringBuilder[] source)
        {
            unsafe
            {
                fixed (Int32* length_ptr = &length)
                {
                    Delegates.glGetShaderSourceARB((UInt32)obj, (Int32)maxLength, (Int32*)length_ptr, (System.Text.StringBuilder[])source);
                    length = *length_ptr;
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetShaderSourceARB(UInt32 obj, Int32 maxLength, [Out] IntPtr length, [Out] System.Text.StringBuilder[] source)
        {
            unsafe
            {
                Delegates.glGetShaderSourceARB((UInt32)obj, (Int32)maxLength, (Int32*)length, (System.Text.StringBuilder[])source);
            }
        }

        public static 
        void glGetShaderSourceARB(Int32 obj, Int32 maxLength, [Out] IntPtr length, [Out] System.Text.StringBuilder[] source)
        {
            unsafe
            {
                Delegates.glGetShaderSourceARB((UInt32)obj, (Int32)maxLength, (Int32*)length, (System.Text.StringBuilder[])source);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glBindAttribLocationARB(UInt32 programObj, UInt32 index, System.String name)
        {
            Delegates.glBindAttribLocationARB((UInt32)programObj, (UInt32)index, (System.String)name);
        }

        public static 
        void glBindAttribLocationARB(Int32 programObj, Int32 index, System.String name)
        {
            Delegates.glBindAttribLocationARB((UInt32)programObj, (UInt32)index, (System.String)name);
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetActiveAttribARB(UInt32 programObj, UInt32 index, Int32 maxLength, [Out] Int32[] length, [Out] Int32[] size, [Out] int[] type, [Out] System.Text.StringBuilder name)
        {
            unsafe
            {
                fixed (Int32* length_ptr = length)
                fixed (Int32* size_ptr = size)
                fixed (int* type_ptr = type)
                {
                    Delegates.glGetActiveAttribARB((UInt32)programObj, (UInt32)index, (Int32)maxLength, (Int32*)length_ptr, (Int32*)size_ptr, (int*)type_ptr, (System.Text.StringBuilder)name);
                }
            }
        }

        public static 
        void glGetActiveAttribARB(Int32 programObj, Int32 index, Int32 maxLength, [Out] Int32[] length, [Out] Int32[] size, [Out] int[] type, [Out] System.Text.StringBuilder name)
        {
            unsafe
            {
                fixed (Int32* length_ptr = length)
                fixed (Int32* size_ptr = size)
                fixed (int* type_ptr = type)
                {
                    Delegates.glGetActiveAttribARB((UInt32)programObj, (UInt32)index, (Int32)maxLength, (Int32*)length_ptr, (Int32*)size_ptr, (int*)type_ptr, (System.Text.StringBuilder)name);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetActiveAttribARB(UInt32 programObj, UInt32 index, Int32 maxLength, [Out] out Int32 length, [Out] out Int32 size, [Out] out int type, [Out] System.Text.StringBuilder name)
        {
            unsafe
            {
                fixed (Int32* length_ptr = &length)
                fixed (Int32* size_ptr = &size)
                fixed (int* type_ptr = &type)
                {
                    Delegates.glGetActiveAttribARB((UInt32)programObj, (UInt32)index, (Int32)maxLength, (Int32*)length_ptr, (Int32*)size_ptr, (int*)type_ptr, (System.Text.StringBuilder)name);
                    length = *length_ptr;
                    size = *size_ptr;
                    type = *type_ptr;
                }
            }
        }

        public static 
        void glGetActiveAttribARB(Int32 programObj, Int32 index, Int32 maxLength, [Out] out Int32 length, [Out] out Int32 size, [Out] out int type, [Out] System.Text.StringBuilder name)
        {
            unsafe
            {
                fixed (Int32* length_ptr = &length)
                fixed (Int32* size_ptr = &size)
                fixed (int* type_ptr = &type)
                {
                    Delegates.glGetActiveAttribARB((UInt32)programObj, (UInt32)index, (Int32)maxLength, (Int32*)length_ptr, (Int32*)size_ptr, (int*)type_ptr, (System.Text.StringBuilder)name);
                    length = *length_ptr;
                    size = *size_ptr;
                    type = *type_ptr;
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetActiveAttribARB(UInt32 programObj, UInt32 index, Int32 maxLength, [Out] IntPtr length, [Out] IntPtr size, [Out] IntPtr type, [Out] System.Text.StringBuilder name)
        {
            unsafe
            {
                Delegates.glGetActiveAttribARB((UInt32)programObj, (UInt32)index, (Int32)maxLength, (Int32*)length, (Int32*)size, (int*)type, (System.Text.StringBuilder)name);
            }
        }

        public static 
        void glGetActiveAttribARB(Int32 programObj, Int32 index, Int32 maxLength, [Out] IntPtr length, [Out] IntPtr size, [Out] IntPtr type, [Out] System.Text.StringBuilder name)
        {
            unsafe
            {
                Delegates.glGetActiveAttribARB((UInt32)programObj, (UInt32)index, (Int32)maxLength, (Int32*)length, (Int32*)size, (int*)type, (System.Text.StringBuilder)name);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        Int32 glGetAttribLocationARB(UInt32 programObj, System.String name)
        {
            return Delegates.glGetAttribLocationARB((UInt32)programObj, (System.String)name);
        }

        public static 
        Int32 glGetAttribLocationARB(Int32 programObj, System.String name)
        {
            return Delegates.glGetAttribLocationARB((UInt32)programObj, (System.String)name);
        }

        public static 
        void glDrawBuffersARB(Int32 n, int[] bufs)
        {
            unsafe
            {
                fixed (int* bufs_ptr = bufs)
                {
                    Delegates.glDrawBuffersARB((Int32)n, (int*)bufs_ptr);
                }
            }
        }

        public static 
        void glDrawBuffersARB(Int32 n, ref int bufs)
        {
            unsafe
            {
                fixed (int* bufs_ptr = &bufs)
                {
                    Delegates.glDrawBuffersARB((Int32)n, (int*)bufs_ptr);
                }
            }
        }

        public static 
        void glDrawBuffersARB(Int32 n, IntPtr bufs)
        {
            unsafe
            {
                Delegates.glDrawBuffersARB((Int32)n, (int*)bufs);
            }
        }

        public static 
        void glClampColorARB(int target, int clamp)
        {
            Delegates.glClampColorARB((int)target, (int)clamp);
        }

        public static 
        void glBlendColorEXT(Single red, Single green, Single blue, Single alpha)
        {
            Delegates.glBlendColorEXT((Single)red, (Single)green, (Single)blue, (Single)alpha);
        }

        public static 
        void glPolygonOffsetEXT(Single factor, Single bias)
        {
            Delegates.glPolygonOffsetEXT((Single)factor, (Single)bias);
        }

        public static 
        void glTexImage3DEXT(int target, Int32 level, int internalformat, Int32 width, Int32 height, Int32 depth, Int32 border, int format, int type, IntPtr pixels)
        {
            unsafe
            {
                Delegates.glTexImage3DEXT((int)target, (Int32)level, (int)internalformat, (Int32)width, (Int32)height, (Int32)depth, (Int32)border, (int)format, (int)type, (IntPtr)pixels);
            }
        }

        public static 
        void glTexImage3DEXT(int target, Int32 level, int internalformat, Int32 width, Int32 height, Int32 depth, Int32 border, int format, int type, [In, Out] object pixels)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle pixels_ptr = System.Runtime.InteropServices.GCHandle.Alloc(pixels, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glTexImage3DEXT((int)target, (Int32)level, (int)internalformat, (Int32)width, (Int32)height, (Int32)depth, (Int32)border, (int)format, (int)type, (IntPtr)pixels_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pixels_ptr.Free();
                }
            }
        }

        public static 
        void glTexSubImage3DEXT(int target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 zoffset, Int32 width, Int32 height, Int32 depth, int format, int type, IntPtr pixels)
        {
            unsafe
            {
                Delegates.glTexSubImage3DEXT((int)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)zoffset, (Int32)width, (Int32)height, (Int32)depth, (int)format, (int)type, (IntPtr)pixels);
            }
        }

        public static 
        void glTexSubImage3DEXT(int target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 zoffset, Int32 width, Int32 height, Int32 depth, int format, int type, [In, Out] object pixels)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle pixels_ptr = System.Runtime.InteropServices.GCHandle.Alloc(pixels, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glTexSubImage3DEXT((int)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)zoffset, (Int32)width, (Int32)height, (Int32)depth, (int)format, (int)type, (IntPtr)pixels_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pixels_ptr.Free();
                }
            }
        }

        public static 
        void glTexSubImage1DEXT(int target, Int32 level, Int32 xoffset, Int32 width, int format, int type, IntPtr pixels)
        {
            unsafe
            {
                Delegates.glTexSubImage1DEXT((int)target, (Int32)level, (Int32)xoffset, (Int32)width, (int)format, (int)type, (IntPtr)pixels);
            }
        }

        public static 
        void glTexSubImage1DEXT(int target, Int32 level, Int32 xoffset, Int32 width, int format, int type, [In, Out] object pixels)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle pixels_ptr = System.Runtime.InteropServices.GCHandle.Alloc(pixels, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glTexSubImage1DEXT((int)target, (Int32)level, (Int32)xoffset, (Int32)width, (int)format, (int)type, (IntPtr)pixels_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pixels_ptr.Free();
                }
            }
        }

        public static 
        void glTexSubImage2DEXT(int target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 width, Int32 height, int format, int type, IntPtr pixels)
        {
            unsafe
            {
                Delegates.glTexSubImage2DEXT((int)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)width, (Int32)height, (int)format, (int)type, (IntPtr)pixels);
            }
        }

        public static 
        void glTexSubImage2DEXT(int target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 width, Int32 height, int format, int type, [In, Out] object pixels)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle pixels_ptr = System.Runtime.InteropServices.GCHandle.Alloc(pixels, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glTexSubImage2DEXT((int)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)width, (Int32)height, (int)format, (int)type, (IntPtr)pixels_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pixels_ptr.Free();
                }
            }
        }

        public static 
        void glCopyTexImage1DEXT(int target, Int32 level, int internalformat, Int32 x, Int32 y, Int32 width, Int32 border)
        {
            Delegates.glCopyTexImage1DEXT((int)target, (Int32)level, (int)internalformat, (Int32)x, (Int32)y, (Int32)width, (Int32)border);
        }

        public static 
        void glCopyTexImage2DEXT(int target, Int32 level, int internalformat, Int32 x, Int32 y, Int32 width, Int32 height, Int32 border)
        {
            Delegates.glCopyTexImage2DEXT((int)target, (Int32)level, (int)internalformat, (Int32)x, (Int32)y, (Int32)width, (Int32)height, (Int32)border);
        }

        public static 
        void glCopyTexSubImage1DEXT(int target, Int32 level, Int32 xoffset, Int32 x, Int32 y, Int32 width)
        {
            Delegates.glCopyTexSubImage1DEXT((int)target, (Int32)level, (Int32)xoffset, (Int32)x, (Int32)y, (Int32)width);
        }

        public static 
        void glCopyTexSubImage2DEXT(int target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 x, Int32 y, Int32 width, Int32 height)
        {
            Delegates.glCopyTexSubImage2DEXT((int)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)x, (Int32)y, (Int32)width, (Int32)height);
        }

        public static 
        void glCopyTexSubImage3DEXT(int target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 zoffset, Int32 x, Int32 y, Int32 width, Int32 height)
        {
            Delegates.glCopyTexSubImage3DEXT((int)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)zoffset, (Int32)x, (Int32)y, (Int32)width, (Int32)height);
        }

        public static 
        void glGetHistogramEXT(int target, bool reset, int format, int type, [Out] IntPtr values)
        {
            unsafe
            {
                Delegates.glGetHistogramEXT((int)target, (bool)reset, (int)format, (int)type, (IntPtr)values);
            }
        }

        public static 
        void glGetHistogramEXT(int target, bool reset, int format, int type, [In, Out] object values)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle values_ptr = System.Runtime.InteropServices.GCHandle.Alloc(values, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glGetHistogramEXT((int)target, (bool)reset, (int)format, (int)type, (IntPtr)values_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    values_ptr.Free();
                }
            }
        }

        public static 
        void glGetHistogramParameterfvEXT(int target, int pname, [Out] Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glGetHistogramParameterfvEXT((int)target, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glGetHistogramParameterfvEXT(int target, int pname, [Out] out Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glGetHistogramParameterfvEXT((int)target, (int)pname, (Single*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetHistogramParameterfvEXT(int target, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetHistogramParameterfvEXT((int)target, (int)pname, (Single*)@params);
            }
        }

        public static 
        void glGetHistogramParameterivEXT(int target, int pname, [Out] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetHistogramParameterivEXT((int)target, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glGetHistogramParameterivEXT(int target, int pname, [Out] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetHistogramParameterivEXT((int)target, (int)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetHistogramParameterivEXT(int target, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetHistogramParameterivEXT((int)target, (int)pname, (Int32*)@params);
            }
        }

        public static 
        void glGetMinmaxEXT(int target, bool reset, int format, int type, [Out] IntPtr values)
        {
            unsafe
            {
                Delegates.glGetMinmaxEXT((int)target, (bool)reset, (int)format, (int)type, (IntPtr)values);
            }
        }

        public static 
        void glGetMinmaxEXT(int target, bool reset, int format, int type, [In, Out] object values)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle values_ptr = System.Runtime.InteropServices.GCHandle.Alloc(values, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glGetMinmaxEXT((int)target, (bool)reset, (int)format, (int)type, (IntPtr)values_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    values_ptr.Free();
                }
            }
        }

        public static 
        void glGetMinmaxParameterfvEXT(int target, int pname, [Out] Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glGetMinmaxParameterfvEXT((int)target, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glGetMinmaxParameterfvEXT(int target, int pname, [Out] out Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glGetMinmaxParameterfvEXT((int)target, (int)pname, (Single*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetMinmaxParameterfvEXT(int target, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetMinmaxParameterfvEXT((int)target, (int)pname, (Single*)@params);
            }
        }

        public static 
        void glGetMinmaxParameterivEXT(int target, int pname, [Out] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetMinmaxParameterivEXT((int)target, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glGetMinmaxParameterivEXT(int target, int pname, [Out] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetMinmaxParameterivEXT((int)target, (int)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetMinmaxParameterivEXT(int target, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetMinmaxParameterivEXT((int)target, (int)pname, (Int32*)@params);
            }
        }

        public static 
        void glHistogramEXT(int target, Int32 width, int internalformat, bool sink)
        {
            Delegates.glHistogramEXT((int)target, (Int32)width, (int)internalformat, (bool)sink);
        }

        public static 
        void glMinmaxEXT(int target, int internalformat, bool sink)
        {
            Delegates.glMinmaxEXT((int)target, (int)internalformat, (bool)sink);
        }

        public static 
        void glResetHistogramEXT(int target)
        {
            Delegates.glResetHistogramEXT((int)target);
        }

        public static 
        void glResetMinmaxEXT(int target)
        {
            Delegates.glResetMinmaxEXT((int)target);
        }

        public static 
        void glConvolutionFilter1DEXT(int target, int internalformat, Int32 width, int format, int type, IntPtr image)
        {
            unsafe
            {
                Delegates.glConvolutionFilter1DEXT((int)target, (int)internalformat, (Int32)width, (int)format, (int)type, (IntPtr)image);
            }
        }

        public static 
        void glConvolutionFilter1DEXT(int target, int internalformat, Int32 width, int format, int type, [In, Out] object image)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle image_ptr = System.Runtime.InteropServices.GCHandle.Alloc(image, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glConvolutionFilter1DEXT((int)target, (int)internalformat, (Int32)width, (int)format, (int)type, (IntPtr)image_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    image_ptr.Free();
                }
            }
        }

        public static 
        void glConvolutionFilter2DEXT(int target, int internalformat, Int32 width, Int32 height, int format, int type, IntPtr image)
        {
            unsafe
            {
                Delegates.glConvolutionFilter2DEXT((int)target, (int)internalformat, (Int32)width, (Int32)height, (int)format, (int)type, (IntPtr)image);
            }
        }

        public static 
        void glConvolutionFilter2DEXT(int target, int internalformat, Int32 width, Int32 height, int format, int type, [In, Out] object image)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle image_ptr = System.Runtime.InteropServices.GCHandle.Alloc(image, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glConvolutionFilter2DEXT((int)target, (int)internalformat, (Int32)width, (Int32)height, (int)format, (int)type, (IntPtr)image_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    image_ptr.Free();
                }
            }
        }

        public static 
        void glConvolutionParameterfEXT(int target, int pname, Single @params)
        {
            Delegates.glConvolutionParameterfEXT((int)target, (int)pname, (Single)@params);
        }

        public static 
        void glConvolutionParameterfvEXT(int target, int pname, Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glConvolutionParameterfvEXT((int)target, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glConvolutionParameterfvEXT(int target, int pname, ref Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glConvolutionParameterfvEXT((int)target, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glConvolutionParameterfvEXT(int target, int pname, IntPtr @params)
        {
            unsafe
            {
                Delegates.glConvolutionParameterfvEXT((int)target, (int)pname, (Single*)@params);
            }
        }

        public static 
        void glConvolutionParameteriEXT(int target, int pname, Int32 @params)
        {
            Delegates.glConvolutionParameteriEXT((int)target, (int)pname, (Int32)@params);
        }

        public static 
        void glConvolutionParameterivEXT(int target, int pname, Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glConvolutionParameterivEXT((int)target, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glConvolutionParameterivEXT(int target, int pname, ref Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glConvolutionParameterivEXT((int)target, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glConvolutionParameterivEXT(int target, int pname, IntPtr @params)
        {
            unsafe
            {
                Delegates.glConvolutionParameterivEXT((int)target, (int)pname, (Int32*)@params);
            }
        }

        public static 
        void glCopyConvolutionFilter1DEXT(int target, int internalformat, Int32 x, Int32 y, Int32 width)
        {
            Delegates.glCopyConvolutionFilter1DEXT((int)target, (int)internalformat, (Int32)x, (Int32)y, (Int32)width);
        }

        public static 
        void glCopyConvolutionFilter2DEXT(int target, int internalformat, Int32 x, Int32 y, Int32 width, Int32 height)
        {
            Delegates.glCopyConvolutionFilter2DEXT((int)target, (int)internalformat, (Int32)x, (Int32)y, (Int32)width, (Int32)height);
        }

        public static 
        void glGetConvolutionFilterEXT(int target, int format, int type, [Out] IntPtr image)
        {
            unsafe
            {
                Delegates.glGetConvolutionFilterEXT((int)target, (int)format, (int)type, (IntPtr)image);
            }
        }

        public static 
        void glGetConvolutionFilterEXT(int target, int format, int type, [In, Out] object image)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle image_ptr = System.Runtime.InteropServices.GCHandle.Alloc(image, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glGetConvolutionFilterEXT((int)target, (int)format, (int)type, (IntPtr)image_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    image_ptr.Free();
                }
            }
        }

        public static 
        void glGetConvolutionParameterfvEXT(int target, int pname, [Out] Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glGetConvolutionParameterfvEXT((int)target, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glGetConvolutionParameterfvEXT(int target, int pname, [Out] out Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glGetConvolutionParameterfvEXT((int)target, (int)pname, (Single*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetConvolutionParameterfvEXT(int target, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetConvolutionParameterfvEXT((int)target, (int)pname, (Single*)@params);
            }
        }

        public static 
        void glGetConvolutionParameterivEXT(int target, int pname, [Out] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetConvolutionParameterivEXT((int)target, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glGetConvolutionParameterivEXT(int target, int pname, [Out] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetConvolutionParameterivEXT((int)target, (int)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetConvolutionParameterivEXT(int target, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetConvolutionParameterivEXT((int)target, (int)pname, (Int32*)@params);
            }
        }

        public static 
        void glGetSeparableFilterEXT(int target, int format, int type, [Out] IntPtr row, [Out] IntPtr column, [Out] IntPtr span)
        {
            unsafe
            {
                Delegates.glGetSeparableFilterEXT((int)target, (int)format, (int)type, (IntPtr)row, (IntPtr)column, (IntPtr)span);
            }
        }

        public static 
        void glGetSeparableFilterEXT(int target, int format, int type, [In, Out] object row, [In, Out] object column, [In, Out] object span)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle row_ptr = System.Runtime.InteropServices.GCHandle.Alloc(row, System.Runtime.InteropServices.GCHandleType.Pinned);
                System.Runtime.InteropServices.GCHandle column_ptr = System.Runtime.InteropServices.GCHandle.Alloc(column, System.Runtime.InteropServices.GCHandleType.Pinned);
                System.Runtime.InteropServices.GCHandle span_ptr = System.Runtime.InteropServices.GCHandle.Alloc(span, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glGetSeparableFilterEXT((int)target, (int)format, (int)type, (IntPtr)row_ptr.AddrOfPinnedObject(), (IntPtr)column_ptr.AddrOfPinnedObject(), (IntPtr)span_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    row_ptr.Free();
                    column_ptr.Free();
                    span_ptr.Free();
                }
            }
        }

        public static 
        void glGetSeparableFilterEXT(int target, int format, int type, [Out] IntPtr row, [In, Out] object column, [In, Out] object span)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle column_ptr = System.Runtime.InteropServices.GCHandle.Alloc(column, System.Runtime.InteropServices.GCHandleType.Pinned);
                System.Runtime.InteropServices.GCHandle span_ptr = System.Runtime.InteropServices.GCHandle.Alloc(span, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glGetSeparableFilterEXT((int)target, (int)format, (int)type, (IntPtr)row, (IntPtr)column_ptr.AddrOfPinnedObject(), (IntPtr)span_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    column_ptr.Free();
                    span_ptr.Free();
                }
            }
        }

        public static 
        void glSeparableFilter2DEXT(int target, int internalformat, Int32 width, Int32 height, int format, int type, IntPtr row, IntPtr column)
        {
            unsafe
            {
                Delegates.glSeparableFilter2DEXT((int)target, (int)internalformat, (Int32)width, (Int32)height, (int)format, (int)type, (IntPtr)row, (IntPtr)column);
            }
        }

        public static 
        void glSeparableFilter2DEXT(int target, int internalformat, Int32 width, Int32 height, int format, int type, [In, Out] object row, [In, Out] object column)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle row_ptr = System.Runtime.InteropServices.GCHandle.Alloc(row, System.Runtime.InteropServices.GCHandleType.Pinned);
                System.Runtime.InteropServices.GCHandle column_ptr = System.Runtime.InteropServices.GCHandle.Alloc(column, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glSeparableFilter2DEXT((int)target, (int)internalformat, (Int32)width, (Int32)height, (int)format, (int)type, (IntPtr)row_ptr.AddrOfPinnedObject(), (IntPtr)column_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    row_ptr.Free();
                    column_ptr.Free();
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        bool glAreTexturesResidentEXT(Int32 n, UInt32[] textures, [Out] bool[] residences)
        {
            unsafe
            {
                fixed (UInt32* textures_ptr = textures)
                fixed (bool* residences_ptr = residences)
                {
                    return Delegates.glAreTexturesResidentEXT((Int32)n, (UInt32*)textures_ptr, (bool*)residences_ptr);
                }
            }
        }

        public static 
        bool glAreTexturesResidentEXT(Int32 n, Int32[] textures, [Out] bool[] residences)
        {
            unsafe
            {
                fixed (Int32* textures_ptr = textures)
                fixed (bool* residences_ptr = residences)
                {
                    return Delegates.glAreTexturesResidentEXT((Int32)n, (UInt32*)textures_ptr, (bool*)residences_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        bool glAreTexturesResidentEXT(Int32 n, ref UInt32 textures, [Out] out bool residences)
        {
            unsafe
            {
                fixed (UInt32* textures_ptr = &textures)
                fixed (bool* residences_ptr = &residences)
                {
                    bool retval = Delegates.glAreTexturesResidentEXT((Int32)n, (UInt32*)textures_ptr, (bool*)residences_ptr);
                    residences = *residences_ptr;
                    return retval;
                }
            }
        }

        public static 
        bool glAreTexturesResidentEXT(Int32 n, ref Int32 textures, [Out] out bool residences)
        {
            unsafe
            {
                fixed (Int32* textures_ptr = &textures)
                fixed (bool* residences_ptr = &residences)
                {
                    bool retval = Delegates.glAreTexturesResidentEXT((Int32)n, (UInt32*)textures_ptr, (bool*)residences_ptr);
                    residences = *residences_ptr;
                    return retval;
                }
            }
        }

        public static 
        bool glAreTexturesResidentEXT(Int32 n, IntPtr textures, [Out] IntPtr residences)
        {
            unsafe
            {
                return Delegates.glAreTexturesResidentEXT((Int32)n, (UInt32*)textures, (bool*)residences);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glBindTextureEXT(int target, UInt32 texture)
        {
            Delegates.glBindTextureEXT((int)target, (UInt32)texture);
        }

        public static 
        void glBindTextureEXT(int target, Int32 texture)
        {
            Delegates.glBindTextureEXT((int)target, (UInt32)texture);
        }

        [System.CLSCompliant(false)]
        public static 
        void glDeleteTexturesEXT(Int32 n, UInt32[] textures)
        {
            unsafe
            {
                fixed (UInt32* textures_ptr = textures)
                {
                    Delegates.glDeleteTexturesEXT((Int32)n, (UInt32*)textures_ptr);
                }
            }
        }

        public static 
        void glDeleteTexturesEXT(Int32 n, Int32[] textures)
        {
            unsafe
            {
                fixed (Int32* textures_ptr = textures)
                {
                    Delegates.glDeleteTexturesEXT((Int32)n, (UInt32*)textures_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glDeleteTexturesEXT(Int32 n, ref UInt32 textures)
        {
            unsafe
            {
                fixed (UInt32* textures_ptr = &textures)
                {
                    Delegates.glDeleteTexturesEXT((Int32)n, (UInt32*)textures_ptr);
                }
            }
        }

        public static 
        void glDeleteTexturesEXT(Int32 n, ref Int32 textures)
        {
            unsafe
            {
                fixed (Int32* textures_ptr = &textures)
                {
                    Delegates.glDeleteTexturesEXT((Int32)n, (UInt32*)textures_ptr);
                }
            }
        }

        public static 
        void glDeleteTexturesEXT(Int32 n, IntPtr textures)
        {
            unsafe
            {
                Delegates.glDeleteTexturesEXT((Int32)n, (UInt32*)textures);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGenTexturesEXT(Int32 n, [Out] UInt32[] textures)
        {
            unsafe
            {
                fixed (UInt32* textures_ptr = textures)
                {
                    Delegates.glGenTexturesEXT((Int32)n, (UInt32*)textures_ptr);
                }
            }
        }

        public static 
        void glGenTexturesEXT(Int32 n, [Out] Int32[] textures)
        {
            unsafe
            {
                fixed (Int32* textures_ptr = textures)
                {
                    Delegates.glGenTexturesEXT((Int32)n, (UInt32*)textures_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGenTexturesEXT(Int32 n, [Out] out UInt32 textures)
        {
            unsafe
            {
                fixed (UInt32* textures_ptr = &textures)
                {
                    Delegates.glGenTexturesEXT((Int32)n, (UInt32*)textures_ptr);
                    textures = *textures_ptr;
                }
            }
        }

        public static 
        void glGenTexturesEXT(Int32 n, [Out] out Int32 textures)
        {
            unsafe
            {
                fixed (Int32* textures_ptr = &textures)
                {
                    Delegates.glGenTexturesEXT((Int32)n, (UInt32*)textures_ptr);
                    textures = *textures_ptr;
                }
            }
        }

        public static 
        void glGenTexturesEXT(Int32 n, [Out] IntPtr textures)
        {
            unsafe
            {
                Delegates.glGenTexturesEXT((Int32)n, (UInt32*)textures);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        bool glIsTextureEXT(UInt32 texture)
        {
            return Delegates.glIsTextureEXT((UInt32)texture);
        }

        public static 
        bool glIsTextureEXT(Int32 texture)
        {
            return Delegates.glIsTextureEXT((UInt32)texture);
        }

        [System.CLSCompliant(false)]
        public static 
        void glPrioritizeTexturesEXT(Int32 n, UInt32[] textures, Single[] priorities)
        {
            unsafe
            {
                fixed (UInt32* textures_ptr = textures)
                fixed (Single* priorities_ptr = priorities)
                {
                    Delegates.glPrioritizeTexturesEXT((Int32)n, (UInt32*)textures_ptr, (Single*)priorities_ptr);
                }
            }
        }

        public static 
        void glPrioritizeTexturesEXT(Int32 n, Int32[] textures, Single[] priorities)
        {
            unsafe
            {
                fixed (Int32* textures_ptr = textures)
                fixed (Single* priorities_ptr = priorities)
                {
                    Delegates.glPrioritizeTexturesEXT((Int32)n, (UInt32*)textures_ptr, (Single*)priorities_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glPrioritizeTexturesEXT(Int32 n, ref UInt32 textures, ref Single priorities)
        {
            unsafe
            {
                fixed (UInt32* textures_ptr = &textures)
                fixed (Single* priorities_ptr = &priorities)
                {
                    Delegates.glPrioritizeTexturesEXT((Int32)n, (UInt32*)textures_ptr, (Single*)priorities_ptr);
                }
            }
        }

        public static 
        void glPrioritizeTexturesEXT(Int32 n, ref Int32 textures, ref Single priorities)
        {
            unsafe
            {
                fixed (Int32* textures_ptr = &textures)
                fixed (Single* priorities_ptr = &priorities)
                {
                    Delegates.glPrioritizeTexturesEXT((Int32)n, (UInt32*)textures_ptr, (Single*)priorities_ptr);
                }
            }
        }

        public static 
        void glPrioritizeTexturesEXT(Int32 n, IntPtr textures, IntPtr priorities)
        {
            unsafe
            {
                Delegates.glPrioritizeTexturesEXT((Int32)n, (UInt32*)textures, (Single*)priorities);
            }
        }

        public static 
        void glArrayElementEXT(Int32 i)
        {
            Delegates.glArrayElementEXT((Int32)i);
        }

        public static 
        void glColorPointerEXT(Int32 size, int type, Int32 stride, Int32 count, IntPtr pointer)
        {
            unsafe
            {
                Delegates.glColorPointerEXT((Int32)size, (int)type, (Int32)stride, (Int32)count, (IntPtr)pointer);
            }
        }

        public static 
        void glColorPointerEXT(Int32 size, int type, Int32 stride, Int32 count, [In, Out] object pointer)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle pointer_ptr = System.Runtime.InteropServices.GCHandle.Alloc(pointer, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glColorPointerEXT((Int32)size, (int)type, (Int32)stride, (Int32)count, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
            }
        }

        public static 
        void glDrawArraysEXT(int mode, Int32 first, Int32 count)
        {
            Delegates.glDrawArraysEXT((int)mode, (Int32)first, (Int32)count);
        }

        public static 
        void glEdgeFlagPointerEXT(Int32 stride, Int32 count, bool[] pointer)
        {
            unsafe
            {
                fixed (bool* pointer_ptr = pointer)
                {
                    Delegates.glEdgeFlagPointerEXT((Int32)stride, (Int32)count, (bool*)pointer_ptr);
                }
            }
        }

        public static 
        void glEdgeFlagPointerEXT(Int32 stride, Int32 count, ref bool pointer)
        {
            unsafe
            {
                fixed (bool* pointer_ptr = &pointer)
                {
                    Delegates.glEdgeFlagPointerEXT((Int32)stride, (Int32)count, (bool*)pointer_ptr);
                }
            }
        }

        public static 
        void glEdgeFlagPointerEXT(Int32 stride, Int32 count, IntPtr pointer)
        {
            unsafe
            {
                Delegates.glEdgeFlagPointerEXT((Int32)stride, (Int32)count, (bool*)pointer);
            }
        }

        public static 
        void glGetPointervEXT(int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetPointervEXT((int)pname, (IntPtr)@params);
            }
        }

        public static 
        void glGetPointervEXT(int pname, [In, Out] object @params)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle @params_ptr = System.Runtime.InteropServices.GCHandle.Alloc(@params, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glGetPointervEXT((int)pname, (IntPtr)@params_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    @params_ptr.Free();
                }
            }
        }

        public static 
        void glIndexPointerEXT(int type, Int32 stride, Int32 count, IntPtr pointer)
        {
            unsafe
            {
                Delegates.glIndexPointerEXT((int)type, (Int32)stride, (Int32)count, (IntPtr)pointer);
            }
        }

        public static 
        void glIndexPointerEXT(int type, Int32 stride, Int32 count, [In, Out] object pointer)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle pointer_ptr = System.Runtime.InteropServices.GCHandle.Alloc(pointer, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glIndexPointerEXT((int)type, (Int32)stride, (Int32)count, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
            }
        }

        public static 
        void glNormalPointerEXT(int type, Int32 stride, Int32 count, IntPtr pointer)
        {
            unsafe
            {
                Delegates.glNormalPointerEXT((int)type, (Int32)stride, (Int32)count, (IntPtr)pointer);
            }
        }

        public static 
        void glNormalPointerEXT(int type, Int32 stride, Int32 count, [In, Out] object pointer)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle pointer_ptr = System.Runtime.InteropServices.GCHandle.Alloc(pointer, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glNormalPointerEXT((int)type, (Int32)stride, (Int32)count, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
            }
        }

        public static 
        void glTexCoordPointerEXT(Int32 size, int type, Int32 stride, Int32 count, IntPtr pointer)
        {
            unsafe
            {
                Delegates.glTexCoordPointerEXT((Int32)size, (int)type, (Int32)stride, (Int32)count, (IntPtr)pointer);
            }
        }

        public static 
        void glTexCoordPointerEXT(Int32 size, int type, Int32 stride, Int32 count, [In, Out] object pointer)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle pointer_ptr = System.Runtime.InteropServices.GCHandle.Alloc(pointer, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glTexCoordPointerEXT((Int32)size, (int)type, (Int32)stride, (Int32)count, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
            }
        }

        public static 
        void glVertexPointerEXT(Int32 size, int type, Int32 stride, Int32 count, IntPtr pointer)
        {
            unsafe
            {
                Delegates.glVertexPointerEXT((Int32)size, (int)type, (Int32)stride, (Int32)count, (IntPtr)pointer);
            }
        }

        public static 
        void glVertexPointerEXT(Int32 size, int type, Int32 stride, Int32 count, [In, Out] object pointer)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle pointer_ptr = System.Runtime.InteropServices.GCHandle.Alloc(pointer, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glVertexPointerEXT((Int32)size, (int)type, (Int32)stride, (Int32)count, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
            }
        }

        public static 
        void glBlendEquationEXT(int mode)
        {
            Delegates.glBlendEquationEXT((int)mode);
        }

        public static 
        void glPointParameterfEXT(int pname, Single param)
        {
            Delegates.glPointParameterfEXT((int)pname, (Single)param);
        }

        public static 
        void glPointParameterfvEXT(int pname, Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glPointParameterfvEXT((int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glPointParameterfvEXT(int pname, ref Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glPointParameterfvEXT((int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glPointParameterfvEXT(int pname, IntPtr @params)
        {
            unsafe
            {
                Delegates.glPointParameterfvEXT((int)pname, (Single*)@params);
            }
        }

        public static 
        void glColorSubTableEXT(int target, Int32 start, Int32 count, int format, int type, IntPtr data)
        {
            unsafe
            {
                Delegates.glColorSubTableEXT((int)target, (Int32)start, (Int32)count, (int)format, (int)type, (IntPtr)data);
            }
        }

        public static 
        void glColorSubTableEXT(int target, Int32 start, Int32 count, int format, int type, [In, Out] object data)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle data_ptr = System.Runtime.InteropServices.GCHandle.Alloc(data, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glColorSubTableEXT((int)target, (Int32)start, (Int32)count, (int)format, (int)type, (IntPtr)data_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    data_ptr.Free();
                }
            }
        }

        public static 
        void glCopyColorSubTableEXT(int target, Int32 start, Int32 x, Int32 y, Int32 width)
        {
            Delegates.glCopyColorSubTableEXT((int)target, (Int32)start, (Int32)x, (Int32)y, (Int32)width);
        }

        public static 
        void glColorTableEXT(int target, int internalFormat, Int32 width, int format, int type, IntPtr table)
        {
            unsafe
            {
                Delegates.glColorTableEXT((int)target, (int)internalFormat, (Int32)width, (int)format, (int)type, (IntPtr)table);
            }
        }

        public static 
        void glColorTableEXT(int target, int internalFormat, Int32 width, int format, int type, [In, Out] object table)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle table_ptr = System.Runtime.InteropServices.GCHandle.Alloc(table, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glColorTableEXT((int)target, (int)internalFormat, (Int32)width, (int)format, (int)type, (IntPtr)table_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    table_ptr.Free();
                }
            }
        }

        public static 
        void glGetColorTableEXT(int target, int format, int type, [Out] IntPtr data)
        {
            unsafe
            {
                Delegates.glGetColorTableEXT((int)target, (int)format, (int)type, (IntPtr)data);
            }
        }

        public static 
        void glGetColorTableEXT(int target, int format, int type, [In, Out] object data)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle data_ptr = System.Runtime.InteropServices.GCHandle.Alloc(data, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glGetColorTableEXT((int)target, (int)format, (int)type, (IntPtr)data_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    data_ptr.Free();
                }
            }
        }

        public static 
        void glGetColorTableParameterivEXT(int target, int pname, [Out] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetColorTableParameterivEXT((int)target, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glGetColorTableParameterivEXT(int target, int pname, [Out] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetColorTableParameterivEXT((int)target, (int)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetColorTableParameterivEXT(int target, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetColorTableParameterivEXT((int)target, (int)pname, (Int32*)@params);
            }
        }

        public static 
        void glGetColorTableParameterfvEXT(int target, int pname, [Out] Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glGetColorTableParameterfvEXT((int)target, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glGetColorTableParameterfvEXT(int target, int pname, [Out] out Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glGetColorTableParameterfvEXT((int)target, (int)pname, (Single*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetColorTableParameterfvEXT(int target, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetColorTableParameterfvEXT((int)target, (int)pname, (Single*)@params);
            }
        }

        public static 
        void glIndexMaterialEXT(int face, int mode)
        {
            Delegates.glIndexMaterialEXT((int)face, (int)mode);
        }

        public static 
        void glIndexFuncEXT(int func, Single @ref)
        {
            Delegates.glIndexFuncEXT((int)func, (Single)@ref);
        }

        public static 
        void glLockArraysEXT(Int32 first, Int32 count)
        {
            Delegates.glLockArraysEXT((Int32)first, (Int32)count);
        }

        public static 
        void glUnlockArraysEXT()
        {
            Delegates.glUnlockArraysEXT();
        }

        public static 
        void glCullParameterdvEXT(int pname, [Out] Double[] @params)
        {
            unsafe
            {
                fixed (Double* @params_ptr = @params)
                {
                    Delegates.glCullParameterdvEXT((int)pname, (Double*)@params_ptr);
                }
            }
        }

        public static 
        void glCullParameterdvEXT(int pname, [Out] out Double @params)
        {
            unsafe
            {
                fixed (Double* @params_ptr = &@params)
                {
                    Delegates.glCullParameterdvEXT((int)pname, (Double*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glCullParameterdvEXT(int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glCullParameterdvEXT((int)pname, (Double*)@params);
            }
        }

        public static 
        void glCullParameterfvEXT(int pname, [Out] Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glCullParameterfvEXT((int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glCullParameterfvEXT(int pname, [Out] out Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glCullParameterfvEXT((int)pname, (Single*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glCullParameterfvEXT(int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glCullParameterfvEXT((int)pname, (Single*)@params);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glDrawRangeElementsEXT(int mode, UInt32 start, UInt32 end, Int32 count, int type, IntPtr indices)
        {
            unsafe
            {
                Delegates.glDrawRangeElementsEXT((int)mode, (UInt32)start, (UInt32)end, (Int32)count, (int)type, (IntPtr)indices);
            }
        }

        public static 
        void glDrawRangeElementsEXT(int mode, Int32 start, Int32 end, Int32 count, int type, IntPtr indices)
        {
            unsafe
            {
                Delegates.glDrawRangeElementsEXT((int)mode, (UInt32)start, (UInt32)end, (Int32)count, (int)type, (IntPtr)indices);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glDrawRangeElementsEXT(int mode, UInt32 start, UInt32 end, Int32 count, int type, [In, Out] object indices)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle indices_ptr = System.Runtime.InteropServices.GCHandle.Alloc(indices, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glDrawRangeElementsEXT((int)mode, (UInt32)start, (UInt32)end, (Int32)count, (int)type, (IntPtr)indices_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    indices_ptr.Free();
                }
            }
        }

        public static 
        void glDrawRangeElementsEXT(int mode, Int32 start, Int32 end, Int32 count, int type, [In, Out] object indices)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle indices_ptr = System.Runtime.InteropServices.GCHandle.Alloc(indices, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glDrawRangeElementsEXT((int)mode, (UInt32)start, (UInt32)end, (Int32)count, (int)type, (IntPtr)indices_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    indices_ptr.Free();
                }
            }
        }

        public static 
        void glApplyTextureEXT(int mode)
        {
            Delegates.glApplyTextureEXT((int)mode);
        }

        public static 
        void glTextureLightEXT(int pname)
        {
            Delegates.glTextureLightEXT((int)pname);
        }

        public static 
        void glTextureMaterialEXT(int face, int mode)
        {
            Delegates.glTextureMaterialEXT((int)face, (int)mode);
        }

        public static 
        void glPixelTransformParameteriEXT(int target, int pname, Int32 param)
        {
            Delegates.glPixelTransformParameteriEXT((int)target, (int)pname, (Int32)param);
        }

        public static 
        void glPixelTransformParameterfEXT(int target, int pname, Single param)
        {
            Delegates.glPixelTransformParameterfEXT((int)target, (int)pname, (Single)param);
        }

        public static 
        void glPixelTransformParameterivEXT(int target, int pname, Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glPixelTransformParameterivEXT((int)target, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glPixelTransformParameterivEXT(int target, int pname, ref Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glPixelTransformParameterivEXT((int)target, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glPixelTransformParameterivEXT(int target, int pname, IntPtr @params)
        {
            unsafe
            {
                Delegates.glPixelTransformParameterivEXT((int)target, (int)pname, (Int32*)@params);
            }
        }

        public static 
        void glPixelTransformParameterfvEXT(int target, int pname, Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glPixelTransformParameterfvEXT((int)target, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glPixelTransformParameterfvEXT(int target, int pname, ref Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glPixelTransformParameterfvEXT((int)target, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glPixelTransformParameterfvEXT(int target, int pname, IntPtr @params)
        {
            unsafe
            {
                Delegates.glPixelTransformParameterfvEXT((int)target, (int)pname, (Single*)@params);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glSecondaryColor3bEXT(SByte red, SByte green, SByte blue)
        {
            Delegates.glSecondaryColor3bEXT((SByte)red, (SByte)green, (SByte)blue);
        }

        public static 
        void glSecondaryColor3bEXT(Byte red, Byte green, Byte blue)
        {
            Delegates.glSecondaryColor3bEXT((SByte)red, (SByte)green, (SByte)blue);
        }

        [System.CLSCompliant(false)]
        public static 
        void glSecondaryColor3bvEXT(SByte[] v)
        {
            unsafe
            {
                fixed (SByte* v_ptr = v)
                {
                    Delegates.glSecondaryColor3bvEXT((SByte*)v_ptr);
                }
            }
        }

        public static 
        void glSecondaryColor3bvEXT(Byte[] v)
        {
            unsafe
            {
                fixed (Byte* v_ptr = v)
                {
                    Delegates.glSecondaryColor3bvEXT((SByte*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glSecondaryColor3bvEXT(ref SByte v)
        {
            unsafe
            {
                fixed (SByte* v_ptr = &v)
                {
                    Delegates.glSecondaryColor3bvEXT((SByte*)v_ptr);
                }
            }
        }

        public static 
        void glSecondaryColor3bvEXT(ref Byte v)
        {
            unsafe
            {
                fixed (Byte* v_ptr = &v)
                {
                    Delegates.glSecondaryColor3bvEXT((SByte*)v_ptr);
                }
            }
        }

        public static 
        void glSecondaryColor3bvEXT(IntPtr v)
        {
            unsafe
            {
                Delegates.glSecondaryColor3bvEXT((SByte*)v);
            }
        }

        public static 
        void glSecondaryColor3dEXT(Double red, Double green, Double blue)
        {
            Delegates.glSecondaryColor3dEXT((Double)red, (Double)green, (Double)blue);
        }

        public static 
        void glSecondaryColor3dvEXT(Double[] v)
        {
            unsafe
            {
                fixed (Double* v_ptr = v)
                {
                    Delegates.glSecondaryColor3dvEXT((Double*)v_ptr);
                }
            }
        }

        public static 
        void glSecondaryColor3dvEXT(ref Double v)
        {
            unsafe
            {
                fixed (Double* v_ptr = &v)
                {
                    Delegates.glSecondaryColor3dvEXT((Double*)v_ptr);
                }
            }
        }

        public static 
        void glSecondaryColor3dvEXT(IntPtr v)
        {
            unsafe
            {
                Delegates.glSecondaryColor3dvEXT((Double*)v);
            }
        }

        public static 
        void glSecondaryColor3fEXT(Single red, Single green, Single blue)
        {
            Delegates.glSecondaryColor3fEXT((Single)red, (Single)green, (Single)blue);
        }

        public static 
        void glSecondaryColor3fvEXT(Single[] v)
        {
            unsafe
            {
                fixed (Single* v_ptr = v)
                {
                    Delegates.glSecondaryColor3fvEXT((Single*)v_ptr);
                }
            }
        }

        public static 
        void glSecondaryColor3fvEXT(ref Single v)
        {
            unsafe
            {
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glSecondaryColor3fvEXT((Single*)v_ptr);
                }
            }
        }

        public static 
        void glSecondaryColor3fvEXT(IntPtr v)
        {
            unsafe
            {
                Delegates.glSecondaryColor3fvEXT((Single*)v);
            }
        }

        public static 
        void glSecondaryColor3iEXT(Int32 red, Int32 green, Int32 blue)
        {
            Delegates.glSecondaryColor3iEXT((Int32)red, (Int32)green, (Int32)blue);
        }

        public static 
        void glSecondaryColor3ivEXT(Int32[] v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = v)
                {
                    Delegates.glSecondaryColor3ivEXT((Int32*)v_ptr);
                }
            }
        }

        public static 
        void glSecondaryColor3ivEXT(ref Int32 v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = &v)
                {
                    Delegates.glSecondaryColor3ivEXT((Int32*)v_ptr);
                }
            }
        }

        public static 
        void glSecondaryColor3ivEXT(IntPtr v)
        {
            unsafe
            {
                Delegates.glSecondaryColor3ivEXT((Int32*)v);
            }
        }

        public static 
        void glSecondaryColor3sEXT(Int16 red, Int16 green, Int16 blue)
        {
            Delegates.glSecondaryColor3sEXT((Int16)red, (Int16)green, (Int16)blue);
        }

        public static 
        void glSecondaryColor3svEXT(Int16[] v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = v)
                {
                    Delegates.glSecondaryColor3svEXT((Int16*)v_ptr);
                }
            }
        }

        public static 
        void glSecondaryColor3svEXT(ref Int16 v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = &v)
                {
                    Delegates.glSecondaryColor3svEXT((Int16*)v_ptr);
                }
            }
        }

        public static 
        void glSecondaryColor3svEXT(IntPtr v)
        {
            unsafe
            {
                Delegates.glSecondaryColor3svEXT((Int16*)v);
            }
        }

        public static 
        void glSecondaryColor3ubEXT(Byte red, Byte green, Byte blue)
        {
            Delegates.glSecondaryColor3ubEXT((Byte)red, (Byte)green, (Byte)blue);
        }

        public static 
        void glSecondaryColor3ubvEXT(Byte[] v)
        {
            unsafe
            {
                fixed (Byte* v_ptr = v)
                {
                    Delegates.glSecondaryColor3ubvEXT((Byte*)v_ptr);
                }
            }
        }

        public static 
        void glSecondaryColor3ubvEXT(ref Byte v)
        {
            unsafe
            {
                fixed (Byte* v_ptr = &v)
                {
                    Delegates.glSecondaryColor3ubvEXT((Byte*)v_ptr);
                }
            }
        }

        public static 
        void glSecondaryColor3ubvEXT(IntPtr v)
        {
            unsafe
            {
                Delegates.glSecondaryColor3ubvEXT((Byte*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glSecondaryColor3uiEXT(UInt32 red, UInt32 green, UInt32 blue)
        {
            Delegates.glSecondaryColor3uiEXT((UInt32)red, (UInt32)green, (UInt32)blue);
        }

        public static 
        void glSecondaryColor3uiEXT(Int32 red, Int32 green, Int32 blue)
        {
            Delegates.glSecondaryColor3uiEXT((UInt32)red, (UInt32)green, (UInt32)blue);
        }

        [System.CLSCompliant(false)]
        public static 
        void glSecondaryColor3uivEXT(UInt32[] v)
        {
            unsafe
            {
                fixed (UInt32* v_ptr = v)
                {
                    Delegates.glSecondaryColor3uivEXT((UInt32*)v_ptr);
                }
            }
        }

        public static 
        void glSecondaryColor3uivEXT(Int32[] v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = v)
                {
                    Delegates.glSecondaryColor3uivEXT((UInt32*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glSecondaryColor3uivEXT(ref UInt32 v)
        {
            unsafe
            {
                fixed (UInt32* v_ptr = &v)
                {
                    Delegates.glSecondaryColor3uivEXT((UInt32*)v_ptr);
                }
            }
        }

        public static 
        void glSecondaryColor3uivEXT(ref Int32 v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = &v)
                {
                    Delegates.glSecondaryColor3uivEXT((UInt32*)v_ptr);
                }
            }
        }

        public static 
        void glSecondaryColor3uivEXT(IntPtr v)
        {
            unsafe
            {
                Delegates.glSecondaryColor3uivEXT((UInt32*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glSecondaryColor3usEXT(UInt16 red, UInt16 green, UInt16 blue)
        {
            Delegates.glSecondaryColor3usEXT((UInt16)red, (UInt16)green, (UInt16)blue);
        }

        public static 
        void glSecondaryColor3usEXT(Int16 red, Int16 green, Int16 blue)
        {
            Delegates.glSecondaryColor3usEXT((UInt16)red, (UInt16)green, (UInt16)blue);
        }

        [System.CLSCompliant(false)]
        public static 
        void glSecondaryColor3usvEXT(UInt16[] v)
        {
            unsafe
            {
                fixed (UInt16* v_ptr = v)
                {
                    Delegates.glSecondaryColor3usvEXT((UInt16*)v_ptr);
                }
            }
        }

        public static 
        void glSecondaryColor3usvEXT(Int16[] v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = v)
                {
                    Delegates.glSecondaryColor3usvEXT((UInt16*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glSecondaryColor3usvEXT(ref UInt16 v)
        {
            unsafe
            {
                fixed (UInt16* v_ptr = &v)
                {
                    Delegates.glSecondaryColor3usvEXT((UInt16*)v_ptr);
                }
            }
        }

        public static 
        void glSecondaryColor3usvEXT(ref Int16 v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = &v)
                {
                    Delegates.glSecondaryColor3usvEXT((UInt16*)v_ptr);
                }
            }
        }

        public static 
        void glSecondaryColor3usvEXT(IntPtr v)
        {
            unsafe
            {
                Delegates.glSecondaryColor3usvEXT((UInt16*)v);
            }
        }

        public static 
        void glSecondaryColorPointerEXT(Int32 size, int type, Int32 stride, IntPtr pointer)
        {
            unsafe
            {
                Delegates.glSecondaryColorPointerEXT((Int32)size, (int)type, (Int32)stride, (IntPtr)pointer);
            }
        }

        public static 
        void glSecondaryColorPointerEXT(Int32 size, int type, Int32 stride, [In, Out] object pointer)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle pointer_ptr = System.Runtime.InteropServices.GCHandle.Alloc(pointer, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glSecondaryColorPointerEXT((Int32)size, (int)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
            }
        }

        public static 
        void glTextureNormalEXT(int mode)
        {
            Delegates.glTextureNormalEXT((int)mode);
        }

        public static 
        void glMultiDrawArraysEXT(int mode, [Out] Int32[] first, [Out] Int32[] count, Int32 primcount)
        {
            unsafe
            {
                fixed (Int32* first_ptr = first)
                fixed (Int32* count_ptr = count)
                {
                    Delegates.glMultiDrawArraysEXT((int)mode, (Int32*)first_ptr, (Int32*)count_ptr, (Int32)primcount);
                }
            }
        }

        public static 
        void glMultiDrawArraysEXT(int mode, [Out] out Int32 first, [Out] out Int32 count, Int32 primcount)
        {
            unsafe
            {
                fixed (Int32* first_ptr = &first)
                fixed (Int32* count_ptr = &count)
                {
                    Delegates.glMultiDrawArraysEXT((int)mode, (Int32*)first_ptr, (Int32*)count_ptr, (Int32)primcount);
                    first = *first_ptr;
                    count = *count_ptr;
                }
            }
        }

        public static 
        void glMultiDrawArraysEXT(int mode, [Out] IntPtr first, [Out] IntPtr count, Int32 primcount)
        {
            unsafe
            {
                Delegates.glMultiDrawArraysEXT((int)mode, (Int32*)first, (Int32*)count, (Int32)primcount);
            }
        }

        public static 
        void glMultiDrawElementsEXT(int mode, Int32[] count, int type, IntPtr indices, Int32 primcount)
        {
            unsafe
            {
                fixed (Int32* count_ptr = count)
                {
                    Delegates.glMultiDrawElementsEXT((int)mode, (Int32*)count_ptr, (int)type, (IntPtr)indices, (Int32)primcount);
                }
            }
        }

        public static 
        void glMultiDrawElementsEXT(int mode, IntPtr count, int type, [In, Out] object indices, Int32 primcount)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle indices_ptr = System.Runtime.InteropServices.GCHandle.Alloc(indices, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glMultiDrawElementsEXT((int)mode, (Int32*)count, (int)type, (IntPtr)indices_ptr.AddrOfPinnedObject(), (Int32)primcount);
                }
                finally
                {
                    indices_ptr.Free();
                }
            }
        }

        public static 
        void glMultiDrawElementsEXT(int mode, ref Int32 count, int type, [In, Out] object indices, Int32 primcount)
        {
            unsafe
            {
                fixed (Int32* count_ptr = &count)
                {
                    System.Runtime.InteropServices.GCHandle indices_ptr = System.Runtime.InteropServices.GCHandle.Alloc(indices, System.Runtime.InteropServices.GCHandleType.Pinned);
                    try
                    {
                        Delegates.glMultiDrawElementsEXT((int)mode, (Int32*)count_ptr, (int)type, (IntPtr)indices_ptr.AddrOfPinnedObject(), (Int32)primcount);
                    }
                    finally
                    {
                        indices_ptr.Free();
                    }
                }
            }
        }

        public static 
        void glFogCoordfEXT(Single coord)
        {
            Delegates.glFogCoordfEXT((Single)coord);
        }

        public static 
        void glFogCoordfvEXT(Single[] coord)
        {
            unsafe
            {
                fixed (Single* coord_ptr = coord)
                {
                    Delegates.glFogCoordfvEXT((Single*)coord_ptr);
                }
            }
        }

        public static 
        void glFogCoordfvEXT(ref Single coord)
        {
            unsafe
            {
                fixed (Single* coord_ptr = &coord)
                {
                    Delegates.glFogCoordfvEXT((Single*)coord_ptr);
                }
            }
        }

        public static 
        void glFogCoordfvEXT(IntPtr coord)
        {
            unsafe
            {
                Delegates.glFogCoordfvEXT((Single*)coord);
            }
        }

        public static 
        void glFogCoorddEXT(Double coord)
        {
            Delegates.glFogCoorddEXT((Double)coord);
        }

        public static 
        void glFogCoorddvEXT(Double[] coord)
        {
            unsafe
            {
                fixed (Double* coord_ptr = coord)
                {
                    Delegates.glFogCoorddvEXT((Double*)coord_ptr);
                }
            }
        }

        public static 
        void glFogCoorddvEXT(ref Double coord)
        {
            unsafe
            {
                fixed (Double* coord_ptr = &coord)
                {
                    Delegates.glFogCoorddvEXT((Double*)coord_ptr);
                }
            }
        }

        public static 
        void glFogCoorddvEXT(IntPtr coord)
        {
            unsafe
            {
                Delegates.glFogCoorddvEXT((Double*)coord);
            }
        }

        public static 
        void glFogCoordPointerEXT(int type, Int32 stride, IntPtr pointer)
        {
            unsafe
            {
                Delegates.glFogCoordPointerEXT((int)type, (Int32)stride, (IntPtr)pointer);
            }
        }

        public static 
        void glFogCoordPointerEXT(int type, Int32 stride, [In, Out] object pointer)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle pointer_ptr = System.Runtime.InteropServices.GCHandle.Alloc(pointer, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glFogCoordPointerEXT((int)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glTangent3bEXT(SByte tx, SByte ty, SByte tz)
        {
            Delegates.glTangent3bEXT((SByte)tx, (SByte)ty, (SByte)tz);
        }

        public static 
        void glTangent3bEXT(Byte tx, Byte ty, Byte tz)
        {
            Delegates.glTangent3bEXT((SByte)tx, (SByte)ty, (SByte)tz);
        }

        [System.CLSCompliant(false)]
        public static 
        void glTangent3bvEXT(SByte[] v)
        {
            unsafe
            {
                fixed (SByte* v_ptr = v)
                {
                    Delegates.glTangent3bvEXT((SByte*)v_ptr);
                }
            }
        }

        public static 
        void glTangent3bvEXT(Byte[] v)
        {
            unsafe
            {
                fixed (Byte* v_ptr = v)
                {
                    Delegates.glTangent3bvEXT((SByte*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glTangent3bvEXT(ref SByte v)
        {
            unsafe
            {
                fixed (SByte* v_ptr = &v)
                {
                    Delegates.glTangent3bvEXT((SByte*)v_ptr);
                }
            }
        }

        public static 
        void glTangent3bvEXT(ref Byte v)
        {
            unsafe
            {
                fixed (Byte* v_ptr = &v)
                {
                    Delegates.glTangent3bvEXT((SByte*)v_ptr);
                }
            }
        }

        public static 
        void glTangent3bvEXT(IntPtr v)
        {
            unsafe
            {
                Delegates.glTangent3bvEXT((SByte*)v);
            }
        }

        public static 
        void glTangent3dEXT(Double tx, Double ty, Double tz)
        {
            Delegates.glTangent3dEXT((Double)tx, (Double)ty, (Double)tz);
        }

        public static 
        void glTangent3dvEXT(Double[] v)
        {
            unsafe
            {
                fixed (Double* v_ptr = v)
                {
                    Delegates.glTangent3dvEXT((Double*)v_ptr);
                }
            }
        }

        public static 
        void glTangent3dvEXT(ref Double v)
        {
            unsafe
            {
                fixed (Double* v_ptr = &v)
                {
                    Delegates.glTangent3dvEXT((Double*)v_ptr);
                }
            }
        }

        public static 
        void glTangent3dvEXT(IntPtr v)
        {
            unsafe
            {
                Delegates.glTangent3dvEXT((Double*)v);
            }
        }

        public static 
        void glTangent3fEXT(Single tx, Single ty, Single tz)
        {
            Delegates.glTangent3fEXT((Single)tx, (Single)ty, (Single)tz);
        }

        public static 
        void glTangent3fvEXT(Single[] v)
        {
            unsafe
            {
                fixed (Single* v_ptr = v)
                {
                    Delegates.glTangent3fvEXT((Single*)v_ptr);
                }
            }
        }

        public static 
        void glTangent3fvEXT(ref Single v)
        {
            unsafe
            {
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glTangent3fvEXT((Single*)v_ptr);
                }
            }
        }

        public static 
        void glTangent3fvEXT(IntPtr v)
        {
            unsafe
            {
                Delegates.glTangent3fvEXT((Single*)v);
            }
        }

        public static 
        void glTangent3iEXT(Int32 tx, Int32 ty, Int32 tz)
        {
            Delegates.glTangent3iEXT((Int32)tx, (Int32)ty, (Int32)tz);
        }

        public static 
        void glTangent3ivEXT(Int32[] v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = v)
                {
                    Delegates.glTangent3ivEXT((Int32*)v_ptr);
                }
            }
        }

        public static 
        void glTangent3ivEXT(ref Int32 v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = &v)
                {
                    Delegates.glTangent3ivEXT((Int32*)v_ptr);
                }
            }
        }

        public static 
        void glTangent3ivEXT(IntPtr v)
        {
            unsafe
            {
                Delegates.glTangent3ivEXT((Int32*)v);
            }
        }

        public static 
        void glTangent3sEXT(Int16 tx, Int16 ty, Int16 tz)
        {
            Delegates.glTangent3sEXT((Int16)tx, (Int16)ty, (Int16)tz);
        }

        public static 
        void glTangent3svEXT(Int16[] v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = v)
                {
                    Delegates.glTangent3svEXT((Int16*)v_ptr);
                }
            }
        }

        public static 
        void glTangent3svEXT(ref Int16 v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = &v)
                {
                    Delegates.glTangent3svEXT((Int16*)v_ptr);
                }
            }
        }

        public static 
        void glTangent3svEXT(IntPtr v)
        {
            unsafe
            {
                Delegates.glTangent3svEXT((Int16*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glBinormal3bEXT(SByte bx, SByte by, SByte bz)
        {
            Delegates.glBinormal3bEXT((SByte)bx, (SByte)by, (SByte)bz);
        }

        public static 
        void glBinormal3bEXT(Byte bx, Byte by, Byte bz)
        {
            Delegates.glBinormal3bEXT((SByte)bx, (SByte)by, (SByte)bz);
        }

        [System.CLSCompliant(false)]
        public static 
        void glBinormal3bvEXT(SByte[] v)
        {
            unsafe
            {
                fixed (SByte* v_ptr = v)
                {
                    Delegates.glBinormal3bvEXT((SByte*)v_ptr);
                }
            }
        }

        public static 
        void glBinormal3bvEXT(Byte[] v)
        {
            unsafe
            {
                fixed (Byte* v_ptr = v)
                {
                    Delegates.glBinormal3bvEXT((SByte*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glBinormal3bvEXT(ref SByte v)
        {
            unsafe
            {
                fixed (SByte* v_ptr = &v)
                {
                    Delegates.glBinormal3bvEXT((SByte*)v_ptr);
                }
            }
        }

        public static 
        void glBinormal3bvEXT(ref Byte v)
        {
            unsafe
            {
                fixed (Byte* v_ptr = &v)
                {
                    Delegates.glBinormal3bvEXT((SByte*)v_ptr);
                }
            }
        }

        public static 
        void glBinormal3bvEXT(IntPtr v)
        {
            unsafe
            {
                Delegates.glBinormal3bvEXT((SByte*)v);
            }
        }

        public static 
        void glBinormal3dEXT(Double bx, Double by, Double bz)
        {
            Delegates.glBinormal3dEXT((Double)bx, (Double)by, (Double)bz);
        }

        public static 
        void glBinormal3dvEXT(Double[] v)
        {
            unsafe
            {
                fixed (Double* v_ptr = v)
                {
                    Delegates.glBinormal3dvEXT((Double*)v_ptr);
                }
            }
        }

        public static 
        void glBinormal3dvEXT(ref Double v)
        {
            unsafe
            {
                fixed (Double* v_ptr = &v)
                {
                    Delegates.glBinormal3dvEXT((Double*)v_ptr);
                }
            }
        }

        public static 
        void glBinormal3dvEXT(IntPtr v)
        {
            unsafe
            {
                Delegates.glBinormal3dvEXT((Double*)v);
            }
        }

        public static 
        void glBinormal3fEXT(Single bx, Single by, Single bz)
        {
            Delegates.glBinormal3fEXT((Single)bx, (Single)by, (Single)bz);
        }

        public static 
        void glBinormal3fvEXT(Single[] v)
        {
            unsafe
            {
                fixed (Single* v_ptr = v)
                {
                    Delegates.glBinormal3fvEXT((Single*)v_ptr);
                }
            }
        }

        public static 
        void glBinormal3fvEXT(ref Single v)
        {
            unsafe
            {
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glBinormal3fvEXT((Single*)v_ptr);
                }
            }
        }

        public static 
        void glBinormal3fvEXT(IntPtr v)
        {
            unsafe
            {
                Delegates.glBinormal3fvEXT((Single*)v);
            }
        }

        public static 
        void glBinormal3iEXT(Int32 bx, Int32 by, Int32 bz)
        {
            Delegates.glBinormal3iEXT((Int32)bx, (Int32)by, (Int32)bz);
        }

        public static 
        void glBinormal3ivEXT(Int32[] v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = v)
                {
                    Delegates.glBinormal3ivEXT((Int32*)v_ptr);
                }
            }
        }

        public static 
        void glBinormal3ivEXT(ref Int32 v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = &v)
                {
                    Delegates.glBinormal3ivEXT((Int32*)v_ptr);
                }
            }
        }

        public static 
        void glBinormal3ivEXT(IntPtr v)
        {
            unsafe
            {
                Delegates.glBinormal3ivEXT((Int32*)v);
            }
        }

        public static 
        void glBinormal3sEXT(Int16 bx, Int16 by, Int16 bz)
        {
            Delegates.glBinormal3sEXT((Int16)bx, (Int16)by, (Int16)bz);
        }

        public static 
        void glBinormal3svEXT(Int16[] v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = v)
                {
                    Delegates.glBinormal3svEXT((Int16*)v_ptr);
                }
            }
        }

        public static 
        void glBinormal3svEXT(ref Int16 v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = &v)
                {
                    Delegates.glBinormal3svEXT((Int16*)v_ptr);
                }
            }
        }

        public static 
        void glBinormal3svEXT(IntPtr v)
        {
            unsafe
            {
                Delegates.glBinormal3svEXT((Int16*)v);
            }
        }

        public static 
        void glTangentPointerEXT(int type, Int32 stride, IntPtr pointer)
        {
            unsafe
            {
                Delegates.glTangentPointerEXT((int)type, (Int32)stride, (IntPtr)pointer);
            }
        }

        public static 
        void glTangentPointerEXT(int type, Int32 stride, [In, Out] object pointer)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle pointer_ptr = System.Runtime.InteropServices.GCHandle.Alloc(pointer, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glTangentPointerEXT((int)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
            }
        }

        public static 
        void glBinormalPointerEXT(int type, Int32 stride, IntPtr pointer)
        {
            unsafe
            {
                Delegates.glBinormalPointerEXT((int)type, (Int32)stride, (IntPtr)pointer);
            }
        }

        public static 
        void glBinormalPointerEXT(int type, Int32 stride, [In, Out] object pointer)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle pointer_ptr = System.Runtime.InteropServices.GCHandle.Alloc(pointer, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glBinormalPointerEXT((int)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
            }
        }

        public static 
        void glBlendFuncSeparateEXT(int sfactorRGB, int dfactorRGB, int sfactorAlpha, int dfactorAlpha)
        {
            Delegates.glBlendFuncSeparateEXT((int)sfactorRGB, (int)dfactorRGB, (int)sfactorAlpha, (int)dfactorAlpha);
        }

        public static 
        void glVertexWeightfEXT(Single weight)
        {
            Delegates.glVertexWeightfEXT((Single)weight);
        }

        public static 
        void glVertexWeightfvEXT(Single[] weight)
        {
            unsafe
            {
                fixed (Single* weight_ptr = weight)
                {
                    Delegates.glVertexWeightfvEXT((Single*)weight_ptr);
                }
            }
        }

        public static 
        void glVertexWeightfvEXT(ref Single weight)
        {
            unsafe
            {
                fixed (Single* weight_ptr = &weight)
                {
                    Delegates.glVertexWeightfvEXT((Single*)weight_ptr);
                }
            }
        }

        public static 
        void glVertexWeightfvEXT(IntPtr weight)
        {
            unsafe
            {
                Delegates.glVertexWeightfvEXT((Single*)weight);
            }
        }

        public static 
        void glVertexWeightPointerEXT(Int32 size, int type, Int32 stride, IntPtr pointer)
        {
            unsafe
            {
                Delegates.glVertexWeightPointerEXT((Int32)size, (int)type, (Int32)stride, (IntPtr)pointer);
            }
        }

        public static 
        void glVertexWeightPointerEXT(Int32 size, int type, Int32 stride, [In, Out] object pointer)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle pointer_ptr = System.Runtime.InteropServices.GCHandle.Alloc(pointer, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glVertexWeightPointerEXT((Int32)size, (int)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
            }
        }

        public static 
        void glSampleMaskEXT(Single value, bool invert)
        {
            Delegates.glSampleMaskEXT((Single)value, (bool)invert);
        }

        public static 
        void glSamplePatternEXT(int pattern)
        {
            Delegates.glSamplePatternEXT((int)pattern);
        }

        public static 
        void glBeginVertexShaderEXT()
        {
            Delegates.glBeginVertexShaderEXT();
        }

        public static 
        void glEndVertexShaderEXT()
        {
            Delegates.glEndVertexShaderEXT();
        }

        [System.CLSCompliant(false)]
        public static 
        void glBindVertexShaderEXT(UInt32 id)
        {
            Delegates.glBindVertexShaderEXT((UInt32)id);
        }

        public static 
        void glBindVertexShaderEXT(Int32 id)
        {
            Delegates.glBindVertexShaderEXT((UInt32)id);
        }

        [System.CLSCompliant(false)]
        public static 
        Int32 glGenVertexShadersEXT(UInt32 range)
        {
            return Delegates.glGenVertexShadersEXT((UInt32)range);
        }

        public static 
        Int32 glGenVertexShadersEXT(Int32 range)
        {
            return Delegates.glGenVertexShadersEXT((UInt32)range);
        }

        [System.CLSCompliant(false)]
        public static 
        void glDeleteVertexShaderEXT(UInt32 id)
        {
            Delegates.glDeleteVertexShaderEXT((UInt32)id);
        }

        public static 
        void glDeleteVertexShaderEXT(Int32 id)
        {
            Delegates.glDeleteVertexShaderEXT((UInt32)id);
        }

        [System.CLSCompliant(false)]
        public static 
        void glShaderOp1EXT(int op, UInt32 res, UInt32 arg1)
        {
            Delegates.glShaderOp1EXT((int)op, (UInt32)res, (UInt32)arg1);
        }

        public static 
        void glShaderOp1EXT(int op, Int32 res, Int32 arg1)
        {
            Delegates.glShaderOp1EXT((int)op, (UInt32)res, (UInt32)arg1);
        }

        [System.CLSCompliant(false)]
        public static 
        void glShaderOp2EXT(int op, UInt32 res, UInt32 arg1, UInt32 arg2)
        {
            Delegates.glShaderOp2EXT((int)op, (UInt32)res, (UInt32)arg1, (UInt32)arg2);
        }

        public static 
        void glShaderOp2EXT(int op, Int32 res, Int32 arg1, Int32 arg2)
        {
            Delegates.glShaderOp2EXT((int)op, (UInt32)res, (UInt32)arg1, (UInt32)arg2);
        }

        [System.CLSCompliant(false)]
        public static 
        void glShaderOp3EXT(int op, UInt32 res, UInt32 arg1, UInt32 arg2, UInt32 arg3)
        {
            Delegates.glShaderOp3EXT((int)op, (UInt32)res, (UInt32)arg1, (UInt32)arg2, (UInt32)arg3);
        }

        public static 
        void glShaderOp3EXT(int op, Int32 res, Int32 arg1, Int32 arg2, Int32 arg3)
        {
            Delegates.glShaderOp3EXT((int)op, (UInt32)res, (UInt32)arg1, (UInt32)arg2, (UInt32)arg3);
        }

        [System.CLSCompliant(false)]
        public static 
        void glSwizzleEXT(UInt32 res, UInt32 @in, int outX, int outY, int outZ, int outW)
        {
            Delegates.glSwizzleEXT((UInt32)res, (UInt32)@in, (int)outX, (int)outY, (int)outZ, (int)outW);
        }

        public static 
        void glSwizzleEXT(Int32 res, Int32 @in, int outX, int outY, int outZ, int outW)
        {
            Delegates.glSwizzleEXT((UInt32)res, (UInt32)@in, (int)outX, (int)outY, (int)outZ, (int)outW);
        }

        [System.CLSCompliant(false)]
        public static 
        void glWriteMaskEXT(UInt32 res, UInt32 @in, int outX, int outY, int outZ, int outW)
        {
            Delegates.glWriteMaskEXT((UInt32)res, (UInt32)@in, (int)outX, (int)outY, (int)outZ, (int)outW);
        }

        public static 
        void glWriteMaskEXT(Int32 res, Int32 @in, int outX, int outY, int outZ, int outW)
        {
            Delegates.glWriteMaskEXT((UInt32)res, (UInt32)@in, (int)outX, (int)outY, (int)outZ, (int)outW);
        }

        [System.CLSCompliant(false)]
        public static 
        void glInsertComponentEXT(UInt32 res, UInt32 src, UInt32 num)
        {
            Delegates.glInsertComponentEXT((UInt32)res, (UInt32)src, (UInt32)num);
        }

        public static 
        void glInsertComponentEXT(Int32 res, Int32 src, Int32 num)
        {
            Delegates.glInsertComponentEXT((UInt32)res, (UInt32)src, (UInt32)num);
        }

        [System.CLSCompliant(false)]
        public static 
        void glExtractComponentEXT(UInt32 res, UInt32 src, UInt32 num)
        {
            Delegates.glExtractComponentEXT((UInt32)res, (UInt32)src, (UInt32)num);
        }

        public static 
        void glExtractComponentEXT(Int32 res, Int32 src, Int32 num)
        {
            Delegates.glExtractComponentEXT((UInt32)res, (UInt32)src, (UInt32)num);
        }

        [System.CLSCompliant(false)]
        public static 
        Int32 glGenSymbolsEXT(int datatype, int storagetype, int range, UInt32 components)
        {
            return Delegates.glGenSymbolsEXT((int)datatype, (int)storagetype, (int)range, (UInt32)components);
        }

        public static 
        Int32 glGenSymbolsEXT(int datatype, int storagetype, int range, Int32 components)
        {
            return Delegates.glGenSymbolsEXT((int)datatype, (int)storagetype, (int)range, (UInt32)components);
        }

        [System.CLSCompliant(false)]
        public static 
        void glSetInvariantEXT(UInt32 id, int type, IntPtr addr)
        {
            unsafe
            {
                Delegates.glSetInvariantEXT((UInt32)id, (int)type, (IntPtr)addr);
            }
        }

        public static 
        void glSetInvariantEXT(Int32 id, int type, IntPtr addr)
        {
            unsafe
            {
                Delegates.glSetInvariantEXT((UInt32)id, (int)type, (IntPtr)addr);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glSetInvariantEXT(UInt32 id, int type, [In, Out] object addr)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle addr_ptr = System.Runtime.InteropServices.GCHandle.Alloc(addr, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glSetInvariantEXT((UInt32)id, (int)type, (IntPtr)addr_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    addr_ptr.Free();
                }
            }
        }

        public static 
        void glSetInvariantEXT(Int32 id, int type, [In, Out] object addr)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle addr_ptr = System.Runtime.InteropServices.GCHandle.Alloc(addr, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glSetInvariantEXT((UInt32)id, (int)type, (IntPtr)addr_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    addr_ptr.Free();
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glSetLocalConstantEXT(UInt32 id, int type, IntPtr addr)
        {
            unsafe
            {
                Delegates.glSetLocalConstantEXT((UInt32)id, (int)type, (IntPtr)addr);
            }
        }

        public static 
        void glSetLocalConstantEXT(Int32 id, int type, IntPtr addr)
        {
            unsafe
            {
                Delegates.glSetLocalConstantEXT((UInt32)id, (int)type, (IntPtr)addr);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glSetLocalConstantEXT(UInt32 id, int type, [In, Out] object addr)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle addr_ptr = System.Runtime.InteropServices.GCHandle.Alloc(addr, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glSetLocalConstantEXT((UInt32)id, (int)type, (IntPtr)addr_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    addr_ptr.Free();
                }
            }
        }

        public static 
        void glSetLocalConstantEXT(Int32 id, int type, [In, Out] object addr)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle addr_ptr = System.Runtime.InteropServices.GCHandle.Alloc(addr, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glSetLocalConstantEXT((UInt32)id, (int)type, (IntPtr)addr_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    addr_ptr.Free();
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVariantbvEXT(UInt32 id, SByte[] addr)
        {
            unsafe
            {
                fixed (SByte* addr_ptr = addr)
                {
                    Delegates.glVariantbvEXT((UInt32)id, (SByte*)addr_ptr);
                }
            }
        }

        public static 
        void glVariantbvEXT(Int32 id, Byte[] addr)
        {
            unsafe
            {
                fixed (Byte* addr_ptr = addr)
                {
                    Delegates.glVariantbvEXT((UInt32)id, (SByte*)addr_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVariantbvEXT(UInt32 id, ref SByte addr)
        {
            unsafe
            {
                fixed (SByte* addr_ptr = &addr)
                {
                    Delegates.glVariantbvEXT((UInt32)id, (SByte*)addr_ptr);
                }
            }
        }

        public static 
        void glVariantbvEXT(Int32 id, ref Byte addr)
        {
            unsafe
            {
                fixed (Byte* addr_ptr = &addr)
                {
                    Delegates.glVariantbvEXT((UInt32)id, (SByte*)addr_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVariantbvEXT(UInt32 id, IntPtr addr)
        {
            unsafe
            {
                Delegates.glVariantbvEXT((UInt32)id, (SByte*)addr);
            }
        }

        public static 
        void glVariantbvEXT(Int32 id, IntPtr addr)
        {
            unsafe
            {
                Delegates.glVariantbvEXT((UInt32)id, (SByte*)addr);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVariantsvEXT(UInt32 id, Int16[] addr)
        {
            unsafe
            {
                fixed (Int16* addr_ptr = addr)
                {
                    Delegates.glVariantsvEXT((UInt32)id, (Int16*)addr_ptr);
                }
            }
        }

        public static 
        void glVariantsvEXT(Int32 id, Int16[] addr)
        {
            unsafe
            {
                fixed (Int16* addr_ptr = addr)
                {
                    Delegates.glVariantsvEXT((UInt32)id, (Int16*)addr_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVariantsvEXT(UInt32 id, ref Int16 addr)
        {
            unsafe
            {
                fixed (Int16* addr_ptr = &addr)
                {
                    Delegates.glVariantsvEXT((UInt32)id, (Int16*)addr_ptr);
                }
            }
        }

        public static 
        void glVariantsvEXT(Int32 id, ref Int16 addr)
        {
            unsafe
            {
                fixed (Int16* addr_ptr = &addr)
                {
                    Delegates.glVariantsvEXT((UInt32)id, (Int16*)addr_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVariantsvEXT(UInt32 id, IntPtr addr)
        {
            unsafe
            {
                Delegates.glVariantsvEXT((UInt32)id, (Int16*)addr);
            }
        }

        public static 
        void glVariantsvEXT(Int32 id, IntPtr addr)
        {
            unsafe
            {
                Delegates.glVariantsvEXT((UInt32)id, (Int16*)addr);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVariantivEXT(UInt32 id, Int32[] addr)
        {
            unsafe
            {
                fixed (Int32* addr_ptr = addr)
                {
                    Delegates.glVariantivEXT((UInt32)id, (Int32*)addr_ptr);
                }
            }
        }

        public static 
        void glVariantivEXT(Int32 id, Int32[] addr)
        {
            unsafe
            {
                fixed (Int32* addr_ptr = addr)
                {
                    Delegates.glVariantivEXT((UInt32)id, (Int32*)addr_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVariantivEXT(UInt32 id, ref Int32 addr)
        {
            unsafe
            {
                fixed (Int32* addr_ptr = &addr)
                {
                    Delegates.glVariantivEXT((UInt32)id, (Int32*)addr_ptr);
                }
            }
        }

        public static 
        void glVariantivEXT(Int32 id, ref Int32 addr)
        {
            unsafe
            {
                fixed (Int32* addr_ptr = &addr)
                {
                    Delegates.glVariantivEXT((UInt32)id, (Int32*)addr_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVariantivEXT(UInt32 id, IntPtr addr)
        {
            unsafe
            {
                Delegates.glVariantivEXT((UInt32)id, (Int32*)addr);
            }
        }

        public static 
        void glVariantivEXT(Int32 id, IntPtr addr)
        {
            unsafe
            {
                Delegates.glVariantivEXT((UInt32)id, (Int32*)addr);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVariantfvEXT(UInt32 id, Single[] addr)
        {
            unsafe
            {
                fixed (Single* addr_ptr = addr)
                {
                    Delegates.glVariantfvEXT((UInt32)id, (Single*)addr_ptr);
                }
            }
        }

        public static 
        void glVariantfvEXT(Int32 id, Single[] addr)
        {
            unsafe
            {
                fixed (Single* addr_ptr = addr)
                {
                    Delegates.glVariantfvEXT((UInt32)id, (Single*)addr_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVariantfvEXT(UInt32 id, ref Single addr)
        {
            unsafe
            {
                fixed (Single* addr_ptr = &addr)
                {
                    Delegates.glVariantfvEXT((UInt32)id, (Single*)addr_ptr);
                }
            }
        }

        public static 
        void glVariantfvEXT(Int32 id, ref Single addr)
        {
            unsafe
            {
                fixed (Single* addr_ptr = &addr)
                {
                    Delegates.glVariantfvEXT((UInt32)id, (Single*)addr_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVariantfvEXT(UInt32 id, IntPtr addr)
        {
            unsafe
            {
                Delegates.glVariantfvEXT((UInt32)id, (Single*)addr);
            }
        }

        public static 
        void glVariantfvEXT(Int32 id, IntPtr addr)
        {
            unsafe
            {
                Delegates.glVariantfvEXT((UInt32)id, (Single*)addr);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVariantdvEXT(UInt32 id, Double[] addr)
        {
            unsafe
            {
                fixed (Double* addr_ptr = addr)
                {
                    Delegates.glVariantdvEXT((UInt32)id, (Double*)addr_ptr);
                }
            }
        }

        public static 
        void glVariantdvEXT(Int32 id, Double[] addr)
        {
            unsafe
            {
                fixed (Double* addr_ptr = addr)
                {
                    Delegates.glVariantdvEXT((UInt32)id, (Double*)addr_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVariantdvEXT(UInt32 id, ref Double addr)
        {
            unsafe
            {
                fixed (Double* addr_ptr = &addr)
                {
                    Delegates.glVariantdvEXT((UInt32)id, (Double*)addr_ptr);
                }
            }
        }

        public static 
        void glVariantdvEXT(Int32 id, ref Double addr)
        {
            unsafe
            {
                fixed (Double* addr_ptr = &addr)
                {
                    Delegates.glVariantdvEXT((UInt32)id, (Double*)addr_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVariantdvEXT(UInt32 id, IntPtr addr)
        {
            unsafe
            {
                Delegates.glVariantdvEXT((UInt32)id, (Double*)addr);
            }
        }

        public static 
        void glVariantdvEXT(Int32 id, IntPtr addr)
        {
            unsafe
            {
                Delegates.glVariantdvEXT((UInt32)id, (Double*)addr);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVariantubvEXT(UInt32 id, Byte[] addr)
        {
            unsafe
            {
                fixed (Byte* addr_ptr = addr)
                {
                    Delegates.glVariantubvEXT((UInt32)id, (Byte*)addr_ptr);
                }
            }
        }

        public static 
        void glVariantubvEXT(Int32 id, Byte[] addr)
        {
            unsafe
            {
                fixed (Byte* addr_ptr = addr)
                {
                    Delegates.glVariantubvEXT((UInt32)id, (Byte*)addr_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVariantubvEXT(UInt32 id, ref Byte addr)
        {
            unsafe
            {
                fixed (Byte* addr_ptr = &addr)
                {
                    Delegates.glVariantubvEXT((UInt32)id, (Byte*)addr_ptr);
                }
            }
        }

        public static 
        void glVariantubvEXT(Int32 id, ref Byte addr)
        {
            unsafe
            {
                fixed (Byte* addr_ptr = &addr)
                {
                    Delegates.glVariantubvEXT((UInt32)id, (Byte*)addr_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVariantubvEXT(UInt32 id, IntPtr addr)
        {
            unsafe
            {
                Delegates.glVariantubvEXT((UInt32)id, (Byte*)addr);
            }
        }

        public static 
        void glVariantubvEXT(Int32 id, IntPtr addr)
        {
            unsafe
            {
                Delegates.glVariantubvEXT((UInt32)id, (Byte*)addr);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVariantusvEXT(UInt32 id, UInt16[] addr)
        {
            unsafe
            {
                fixed (UInt16* addr_ptr = addr)
                {
                    Delegates.glVariantusvEXT((UInt32)id, (UInt16*)addr_ptr);
                }
            }
        }

        public static 
        void glVariantusvEXT(Int32 id, Int16[] addr)
        {
            unsafe
            {
                fixed (Int16* addr_ptr = addr)
                {
                    Delegates.glVariantusvEXT((UInt32)id, (UInt16*)addr_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVariantusvEXT(UInt32 id, ref UInt16 addr)
        {
            unsafe
            {
                fixed (UInt16* addr_ptr = &addr)
                {
                    Delegates.glVariantusvEXT((UInt32)id, (UInt16*)addr_ptr);
                }
            }
        }

        public static 
        void glVariantusvEXT(Int32 id, ref Int16 addr)
        {
            unsafe
            {
                fixed (Int16* addr_ptr = &addr)
                {
                    Delegates.glVariantusvEXT((UInt32)id, (UInt16*)addr_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVariantusvEXT(UInt32 id, IntPtr addr)
        {
            unsafe
            {
                Delegates.glVariantusvEXT((UInt32)id, (UInt16*)addr);
            }
        }

        public static 
        void glVariantusvEXT(Int32 id, IntPtr addr)
        {
            unsafe
            {
                Delegates.glVariantusvEXT((UInt32)id, (UInt16*)addr);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVariantuivEXT(UInt32 id, UInt32[] addr)
        {
            unsafe
            {
                fixed (UInt32* addr_ptr = addr)
                {
                    Delegates.glVariantuivEXT((UInt32)id, (UInt32*)addr_ptr);
                }
            }
        }

        public static 
        void glVariantuivEXT(Int32 id, Int32[] addr)
        {
            unsafe
            {
                fixed (Int32* addr_ptr = addr)
                {
                    Delegates.glVariantuivEXT((UInt32)id, (UInt32*)addr_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVariantuivEXT(UInt32 id, ref UInt32 addr)
        {
            unsafe
            {
                fixed (UInt32* addr_ptr = &addr)
                {
                    Delegates.glVariantuivEXT((UInt32)id, (UInt32*)addr_ptr);
                }
            }
        }

        public static 
        void glVariantuivEXT(Int32 id, ref Int32 addr)
        {
            unsafe
            {
                fixed (Int32* addr_ptr = &addr)
                {
                    Delegates.glVariantuivEXT((UInt32)id, (UInt32*)addr_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVariantuivEXT(UInt32 id, IntPtr addr)
        {
            unsafe
            {
                Delegates.glVariantuivEXT((UInt32)id, (UInt32*)addr);
            }
        }

        public static 
        void glVariantuivEXT(Int32 id, IntPtr addr)
        {
            unsafe
            {
                Delegates.glVariantuivEXT((UInt32)id, (UInt32*)addr);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVariantPointerEXT(UInt32 id, int type, UInt32 stride, IntPtr addr)
        {
            unsafe
            {
                Delegates.glVariantPointerEXT((UInt32)id, (int)type, (UInt32)stride, (IntPtr)addr);
            }
        }

        public static 
        void glVariantPointerEXT(Int32 id, int type, Int32 stride, IntPtr addr)
        {
            unsafe
            {
                Delegates.glVariantPointerEXT((UInt32)id, (int)type, (UInt32)stride, (IntPtr)addr);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVariantPointerEXT(UInt32 id, int type, UInt32 stride, [In, Out] object addr)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle addr_ptr = System.Runtime.InteropServices.GCHandle.Alloc(addr, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glVariantPointerEXT((UInt32)id, (int)type, (UInt32)stride, (IntPtr)addr_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    addr_ptr.Free();
                }
            }
        }

        public static 
        void glVariantPointerEXT(Int32 id, int type, Int32 stride, [In, Out] object addr)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle addr_ptr = System.Runtime.InteropServices.GCHandle.Alloc(addr, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glVariantPointerEXT((UInt32)id, (int)type, (UInt32)stride, (IntPtr)addr_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    addr_ptr.Free();
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glEnableVariantClientStateEXT(UInt32 id)
        {
            Delegates.glEnableVariantClientStateEXT((UInt32)id);
        }

        public static 
        void glEnableVariantClientStateEXT(Int32 id)
        {
            Delegates.glEnableVariantClientStateEXT((UInt32)id);
        }

        [System.CLSCompliant(false)]
        public static 
        void glDisableVariantClientStateEXT(UInt32 id)
        {
            Delegates.glDisableVariantClientStateEXT((UInt32)id);
        }

        public static 
        void glDisableVariantClientStateEXT(Int32 id)
        {
            Delegates.glDisableVariantClientStateEXT((UInt32)id);
        }

        public static 
        Int32 glBindLightParameterEXT(int light, int value)
        {
            return Delegates.glBindLightParameterEXT((int)light, (int)value);
        }

        public static 
        Int32 glBindMaterialParameterEXT(int face, int value)
        {
            return Delegates.glBindMaterialParameterEXT((int)face, (int)value);
        }

        public static 
        Int32 glBindTexGenParameterEXT(int unit, int coord, int value)
        {
            return Delegates.glBindTexGenParameterEXT((int)unit, (int)coord, (int)value);
        }

        public static 
        Int32 glBindTextureUnitParameterEXT(int unit, int value)
        {
            return Delegates.glBindTextureUnitParameterEXT((int)unit, (int)value);
        }

        public static 
        Int32 glBindParameterEXT(int value)
        {
            return Delegates.glBindParameterEXT((int)value);
        }

        [System.CLSCompliant(false)]
        public static 
        bool glIsVariantEnabledEXT(UInt32 id, int cap)
        {
            return Delegates.glIsVariantEnabledEXT((UInt32)id, (int)cap);
        }

        public static 
        bool glIsVariantEnabledEXT(Int32 id, int cap)
        {
            return Delegates.glIsVariantEnabledEXT((UInt32)id, (int)cap);
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetVariantBooleanvEXT(UInt32 id, int value, [Out] bool[] data)
        {
            unsafe
            {
                fixed (bool* data_ptr = data)
                {
                    Delegates.glGetVariantBooleanvEXT((UInt32)id, (int)value, (bool*)data_ptr);
                }
            }
        }

        public static 
        void glGetVariantBooleanvEXT(Int32 id, int value, [Out] bool[] data)
        {
            unsafe
            {
                fixed (bool* data_ptr = data)
                {
                    Delegates.glGetVariantBooleanvEXT((UInt32)id, (int)value, (bool*)data_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetVariantBooleanvEXT(UInt32 id, int value, [Out] out bool data)
        {
            unsafe
            {
                fixed (bool* data_ptr = &data)
                {
                    Delegates.glGetVariantBooleanvEXT((UInt32)id, (int)value, (bool*)data_ptr);
                    data = *data_ptr;
                }
            }
        }

        public static 
        void glGetVariantBooleanvEXT(Int32 id, int value, [Out] out bool data)
        {
            unsafe
            {
                fixed (bool* data_ptr = &data)
                {
                    Delegates.glGetVariantBooleanvEXT((UInt32)id, (int)value, (bool*)data_ptr);
                    data = *data_ptr;
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetVariantBooleanvEXT(UInt32 id, int value, [Out] IntPtr data)
        {
            unsafe
            {
                Delegates.glGetVariantBooleanvEXT((UInt32)id, (int)value, (bool*)data);
            }
        }

        public static 
        void glGetVariantBooleanvEXT(Int32 id, int value, [Out] IntPtr data)
        {
            unsafe
            {
                Delegates.glGetVariantBooleanvEXT((UInt32)id, (int)value, (bool*)data);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetVariantIntegervEXT(UInt32 id, int value, [Out] Int32[] data)
        {
            unsafe
            {
                fixed (Int32* data_ptr = data)
                {
                    Delegates.glGetVariantIntegervEXT((UInt32)id, (int)value, (Int32*)data_ptr);
                }
            }
        }

        public static 
        void glGetVariantIntegervEXT(Int32 id, int value, [Out] Int32[] data)
        {
            unsafe
            {
                fixed (Int32* data_ptr = data)
                {
                    Delegates.glGetVariantIntegervEXT((UInt32)id, (int)value, (Int32*)data_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetVariantIntegervEXT(UInt32 id, int value, [Out] out Int32 data)
        {
            unsafe
            {
                fixed (Int32* data_ptr = &data)
                {
                    Delegates.glGetVariantIntegervEXT((UInt32)id, (int)value, (Int32*)data_ptr);
                    data = *data_ptr;
                }
            }
        }

        public static 
        void glGetVariantIntegervEXT(Int32 id, int value, [Out] out Int32 data)
        {
            unsafe
            {
                fixed (Int32* data_ptr = &data)
                {
                    Delegates.glGetVariantIntegervEXT((UInt32)id, (int)value, (Int32*)data_ptr);
                    data = *data_ptr;
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetVariantIntegervEXT(UInt32 id, int value, [Out] IntPtr data)
        {
            unsafe
            {
                Delegates.glGetVariantIntegervEXT((UInt32)id, (int)value, (Int32*)data);
            }
        }

        public static 
        void glGetVariantIntegervEXT(Int32 id, int value, [Out] IntPtr data)
        {
            unsafe
            {
                Delegates.glGetVariantIntegervEXT((UInt32)id, (int)value, (Int32*)data);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetVariantFloatvEXT(UInt32 id, int value, [Out] Single[] data)
        {
            unsafe
            {
                fixed (Single* data_ptr = data)
                {
                    Delegates.glGetVariantFloatvEXT((UInt32)id, (int)value, (Single*)data_ptr);
                }
            }
        }

        public static 
        void glGetVariantFloatvEXT(Int32 id, int value, [Out] Single[] data)
        {
            unsafe
            {
                fixed (Single* data_ptr = data)
                {
                    Delegates.glGetVariantFloatvEXT((UInt32)id, (int)value, (Single*)data_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetVariantFloatvEXT(UInt32 id, int value, [Out] out Single data)
        {
            unsafe
            {
                fixed (Single* data_ptr = &data)
                {
                    Delegates.glGetVariantFloatvEXT((UInt32)id, (int)value, (Single*)data_ptr);
                    data = *data_ptr;
                }
            }
        }

        public static 
        void glGetVariantFloatvEXT(Int32 id, int value, [Out] out Single data)
        {
            unsafe
            {
                fixed (Single* data_ptr = &data)
                {
                    Delegates.glGetVariantFloatvEXT((UInt32)id, (int)value, (Single*)data_ptr);
                    data = *data_ptr;
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetVariantFloatvEXT(UInt32 id, int value, [Out] IntPtr data)
        {
            unsafe
            {
                Delegates.glGetVariantFloatvEXT((UInt32)id, (int)value, (Single*)data);
            }
        }

        public static 
        void glGetVariantFloatvEXT(Int32 id, int value, [Out] IntPtr data)
        {
            unsafe
            {
                Delegates.glGetVariantFloatvEXT((UInt32)id, (int)value, (Single*)data);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetVariantPointervEXT(UInt32 id, int value, [Out] IntPtr data)
        {
            unsafe
            {
                Delegates.glGetVariantPointervEXT((UInt32)id, (int)value, (IntPtr)data);
            }
        }

        public static 
        void glGetVariantPointervEXT(Int32 id, int value, [Out] IntPtr data)
        {
            unsafe
            {
                Delegates.glGetVariantPointervEXT((UInt32)id, (int)value, (IntPtr)data);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetVariantPointervEXT(UInt32 id, int value, [In, Out] object data)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle data_ptr = System.Runtime.InteropServices.GCHandle.Alloc(data, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glGetVariantPointervEXT((UInt32)id, (int)value, (IntPtr)data_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    data_ptr.Free();
                }
            }
        }

        public static 
        void glGetVariantPointervEXT(Int32 id, int value, [In, Out] object data)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle data_ptr = System.Runtime.InteropServices.GCHandle.Alloc(data, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glGetVariantPointervEXT((UInt32)id, (int)value, (IntPtr)data_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    data_ptr.Free();
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetInvariantBooleanvEXT(UInt32 id, int value, [Out] bool[] data)
        {
            unsafe
            {
                fixed (bool* data_ptr = data)
                {
                    Delegates.glGetInvariantBooleanvEXT((UInt32)id, (int)value, (bool*)data_ptr);
                }
            }
        }

        public static 
        void glGetInvariantBooleanvEXT(Int32 id, int value, [Out] bool[] data)
        {
            unsafe
            {
                fixed (bool* data_ptr = data)
                {
                    Delegates.glGetInvariantBooleanvEXT((UInt32)id, (int)value, (bool*)data_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetInvariantBooleanvEXT(UInt32 id, int value, [Out] out bool data)
        {
            unsafe
            {
                fixed (bool* data_ptr = &data)
                {
                    Delegates.glGetInvariantBooleanvEXT((UInt32)id, (int)value, (bool*)data_ptr);
                    data = *data_ptr;
                }
            }
        }

        public static 
        void glGetInvariantBooleanvEXT(Int32 id, int value, [Out] out bool data)
        {
            unsafe
            {
                fixed (bool* data_ptr = &data)
                {
                    Delegates.glGetInvariantBooleanvEXT((UInt32)id, (int)value, (bool*)data_ptr);
                    data = *data_ptr;
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetInvariantBooleanvEXT(UInt32 id, int value, [Out] IntPtr data)
        {
            unsafe
            {
                Delegates.glGetInvariantBooleanvEXT((UInt32)id, (int)value, (bool*)data);
            }
        }

        public static 
        void glGetInvariantBooleanvEXT(Int32 id, int value, [Out] IntPtr data)
        {
            unsafe
            {
                Delegates.glGetInvariantBooleanvEXT((UInt32)id, (int)value, (bool*)data);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetInvariantIntegervEXT(UInt32 id, int value, [Out] Int32[] data)
        {
            unsafe
            {
                fixed (Int32* data_ptr = data)
                {
                    Delegates.glGetInvariantIntegervEXT((UInt32)id, (int)value, (Int32*)data_ptr);
                }
            }
        }

        public static 
        void glGetInvariantIntegervEXT(Int32 id, int value, [Out] Int32[] data)
        {
            unsafe
            {
                fixed (Int32* data_ptr = data)
                {
                    Delegates.glGetInvariantIntegervEXT((UInt32)id, (int)value, (Int32*)data_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetInvariantIntegervEXT(UInt32 id, int value, [Out] out Int32 data)
        {
            unsafe
            {
                fixed (Int32* data_ptr = &data)
                {
                    Delegates.glGetInvariantIntegervEXT((UInt32)id, (int)value, (Int32*)data_ptr);
                    data = *data_ptr;
                }
            }
        }

        public static 
        void glGetInvariantIntegervEXT(Int32 id, int value, [Out] out Int32 data)
        {
            unsafe
            {
                fixed (Int32* data_ptr = &data)
                {
                    Delegates.glGetInvariantIntegervEXT((UInt32)id, (int)value, (Int32*)data_ptr);
                    data = *data_ptr;
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetInvariantIntegervEXT(UInt32 id, int value, [Out] IntPtr data)
        {
            unsafe
            {
                Delegates.glGetInvariantIntegervEXT((UInt32)id, (int)value, (Int32*)data);
            }
        }

        public static 
        void glGetInvariantIntegervEXT(Int32 id, int value, [Out] IntPtr data)
        {
            unsafe
            {
                Delegates.glGetInvariantIntegervEXT((UInt32)id, (int)value, (Int32*)data);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetInvariantFloatvEXT(UInt32 id, int value, [Out] Single[] data)
        {
            unsafe
            {
                fixed (Single* data_ptr = data)
                {
                    Delegates.glGetInvariantFloatvEXT((UInt32)id, (int)value, (Single*)data_ptr);
                }
            }
        }

        public static 
        void glGetInvariantFloatvEXT(Int32 id, int value, [Out] Single[] data)
        {
            unsafe
            {
                fixed (Single* data_ptr = data)
                {
                    Delegates.glGetInvariantFloatvEXT((UInt32)id, (int)value, (Single*)data_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetInvariantFloatvEXT(UInt32 id, int value, [Out] out Single data)
        {
            unsafe
            {
                fixed (Single* data_ptr = &data)
                {
                    Delegates.glGetInvariantFloatvEXT((UInt32)id, (int)value, (Single*)data_ptr);
                    data = *data_ptr;
                }
            }
        }

        public static 
        void glGetInvariantFloatvEXT(Int32 id, int value, [Out] out Single data)
        {
            unsafe
            {
                fixed (Single* data_ptr = &data)
                {
                    Delegates.glGetInvariantFloatvEXT((UInt32)id, (int)value, (Single*)data_ptr);
                    data = *data_ptr;
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetInvariantFloatvEXT(UInt32 id, int value, [Out] IntPtr data)
        {
            unsafe
            {
                Delegates.glGetInvariantFloatvEXT((UInt32)id, (int)value, (Single*)data);
            }
        }

        public static 
        void glGetInvariantFloatvEXT(Int32 id, int value, [Out] IntPtr data)
        {
            unsafe
            {
                Delegates.glGetInvariantFloatvEXT((UInt32)id, (int)value, (Single*)data);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetLocalConstantBooleanvEXT(UInt32 id, int value, [Out] bool[] data)
        {
            unsafe
            {
                fixed (bool* data_ptr = data)
                {
                    Delegates.glGetLocalConstantBooleanvEXT((UInt32)id, (int)value, (bool*)data_ptr);
                }
            }
        }

        public static 
        void glGetLocalConstantBooleanvEXT(Int32 id, int value, [Out] bool[] data)
        {
            unsafe
            {
                fixed (bool* data_ptr = data)
                {
                    Delegates.glGetLocalConstantBooleanvEXT((UInt32)id, (int)value, (bool*)data_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetLocalConstantBooleanvEXT(UInt32 id, int value, [Out] out bool data)
        {
            unsafe
            {
                fixed (bool* data_ptr = &data)
                {
                    Delegates.glGetLocalConstantBooleanvEXT((UInt32)id, (int)value, (bool*)data_ptr);
                    data = *data_ptr;
                }
            }
        }

        public static 
        void glGetLocalConstantBooleanvEXT(Int32 id, int value, [Out] out bool data)
        {
            unsafe
            {
                fixed (bool* data_ptr = &data)
                {
                    Delegates.glGetLocalConstantBooleanvEXT((UInt32)id, (int)value, (bool*)data_ptr);
                    data = *data_ptr;
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetLocalConstantBooleanvEXT(UInt32 id, int value, [Out] IntPtr data)
        {
            unsafe
            {
                Delegates.glGetLocalConstantBooleanvEXT((UInt32)id, (int)value, (bool*)data);
            }
        }

        public static 
        void glGetLocalConstantBooleanvEXT(Int32 id, int value, [Out] IntPtr data)
        {
            unsafe
            {
                Delegates.glGetLocalConstantBooleanvEXT((UInt32)id, (int)value, (bool*)data);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetLocalConstantIntegervEXT(UInt32 id, int value, [Out] Int32[] data)
        {
            unsafe
            {
                fixed (Int32* data_ptr = data)
                {
                    Delegates.glGetLocalConstantIntegervEXT((UInt32)id, (int)value, (Int32*)data_ptr);
                }
            }
        }

        public static 
        void glGetLocalConstantIntegervEXT(Int32 id, int value, [Out] Int32[] data)
        {
            unsafe
            {
                fixed (Int32* data_ptr = data)
                {
                    Delegates.glGetLocalConstantIntegervEXT((UInt32)id, (int)value, (Int32*)data_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetLocalConstantIntegervEXT(UInt32 id, int value, [Out] out Int32 data)
        {
            unsafe
            {
                fixed (Int32* data_ptr = &data)
                {
                    Delegates.glGetLocalConstantIntegervEXT((UInt32)id, (int)value, (Int32*)data_ptr);
                    data = *data_ptr;
                }
            }
        }

        public static 
        void glGetLocalConstantIntegervEXT(Int32 id, int value, [Out] out Int32 data)
        {
            unsafe
            {
                fixed (Int32* data_ptr = &data)
                {
                    Delegates.glGetLocalConstantIntegervEXT((UInt32)id, (int)value, (Int32*)data_ptr);
                    data = *data_ptr;
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetLocalConstantIntegervEXT(UInt32 id, int value, [Out] IntPtr data)
        {
            unsafe
            {
                Delegates.glGetLocalConstantIntegervEXT((UInt32)id, (int)value, (Int32*)data);
            }
        }

        public static 
        void glGetLocalConstantIntegervEXT(Int32 id, int value, [Out] IntPtr data)
        {
            unsafe
            {
                Delegates.glGetLocalConstantIntegervEXT((UInt32)id, (int)value, (Int32*)data);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetLocalConstantFloatvEXT(UInt32 id, int value, [Out] Single[] data)
        {
            unsafe
            {
                fixed (Single* data_ptr = data)
                {
                    Delegates.glGetLocalConstantFloatvEXT((UInt32)id, (int)value, (Single*)data_ptr);
                }
            }
        }

        public static 
        void glGetLocalConstantFloatvEXT(Int32 id, int value, [Out] Single[] data)
        {
            unsafe
            {
                fixed (Single* data_ptr = data)
                {
                    Delegates.glGetLocalConstantFloatvEXT((UInt32)id, (int)value, (Single*)data_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetLocalConstantFloatvEXT(UInt32 id, int value, [Out] out Single data)
        {
            unsafe
            {
                fixed (Single* data_ptr = &data)
                {
                    Delegates.glGetLocalConstantFloatvEXT((UInt32)id, (int)value, (Single*)data_ptr);
                    data = *data_ptr;
                }
            }
        }

        public static 
        void glGetLocalConstantFloatvEXT(Int32 id, int value, [Out] out Single data)
        {
            unsafe
            {
                fixed (Single* data_ptr = &data)
                {
                    Delegates.glGetLocalConstantFloatvEXT((UInt32)id, (int)value, (Single*)data_ptr);
                    data = *data_ptr;
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetLocalConstantFloatvEXT(UInt32 id, int value, [Out] IntPtr data)
        {
            unsafe
            {
                Delegates.glGetLocalConstantFloatvEXT((UInt32)id, (int)value, (Single*)data);
            }
        }

        public static 
        void glGetLocalConstantFloatvEXT(Int32 id, int value, [Out] IntPtr data)
        {
            unsafe
            {
                Delegates.glGetLocalConstantFloatvEXT((UInt32)id, (int)value, (Single*)data);
            }
        }

        public static 
        void glActiveStencilFaceEXT(int face)
        {
            Delegates.glActiveStencilFaceEXT((int)face);
        }

        public static 
        void glDepthBoundsEXT(Double zmin, Double zmax)
        {
            Delegates.glDepthBoundsEXT((Double)zmin, (Double)zmax);
        }

        public static 
        void glBlendEquationSeparateEXT(int modeRGB, int modeAlpha)
        {
            Delegates.glBlendEquationSeparateEXT((int)modeRGB, (int)modeAlpha);
        }

        [System.CLSCompliant(false)]
        public static 
        bool glIsRenderbufferEXT(UInt32 renderbuffer)
        {
            return Delegates.glIsRenderbufferEXT((UInt32)renderbuffer);
        }

        public static 
        bool glIsRenderbufferEXT(Int32 renderbuffer)
        {
            return Delegates.glIsRenderbufferEXT((UInt32)renderbuffer);
        }

        [System.CLSCompliant(false)]
        public static 
        void glBindRenderbufferEXT(int target, UInt32 renderbuffer)
        {
            Delegates.glBindRenderbufferEXT((int)target, (UInt32)renderbuffer);
        }

        public static 
        void glBindRenderbufferEXT(int target, Int32 renderbuffer)
        {
            Delegates.glBindRenderbufferEXT((int)target, (UInt32)renderbuffer);
        }

        [System.CLSCompliant(false)]
        public static 
        void glDeleteRenderbuffersEXT(Int32 n, UInt32[] renderbuffers)
        {
            unsafe
            {
                fixed (UInt32* renderbuffers_ptr = renderbuffers)
                {
                    Delegates.glDeleteRenderbuffersEXT((Int32)n, (UInt32*)renderbuffers_ptr);
                }
            }
        }

        public static 
        void glDeleteRenderbuffersEXT(Int32 n, Int32[] renderbuffers)
        {
            unsafe
            {
                fixed (Int32* renderbuffers_ptr = renderbuffers)
                {
                    Delegates.glDeleteRenderbuffersEXT((Int32)n, (UInt32*)renderbuffers_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glDeleteRenderbuffersEXT(Int32 n, ref UInt32 renderbuffers)
        {
            unsafe
            {
                fixed (UInt32* renderbuffers_ptr = &renderbuffers)
                {
                    Delegates.glDeleteRenderbuffersEXT((Int32)n, (UInt32*)renderbuffers_ptr);
                }
            }
        }

        public static 
        void glDeleteRenderbuffersEXT(Int32 n, ref Int32 renderbuffers)
        {
            unsafe
            {
                fixed (Int32* renderbuffers_ptr = &renderbuffers)
                {
                    Delegates.glDeleteRenderbuffersEXT((Int32)n, (UInt32*)renderbuffers_ptr);
                }
            }
        }

        public static 
        void glDeleteRenderbuffersEXT(Int32 n, IntPtr renderbuffers)
        {
            unsafe
            {
                Delegates.glDeleteRenderbuffersEXT((Int32)n, (UInt32*)renderbuffers);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGenRenderbuffersEXT(Int32 n, [Out] UInt32[] renderbuffers)
        {
            unsafe
            {
                fixed (UInt32* renderbuffers_ptr = renderbuffers)
                {
                    Delegates.glGenRenderbuffersEXT((Int32)n, (UInt32*)renderbuffers_ptr);
                }
            }
        }

        public static 
        void glGenRenderbuffersEXT(Int32 n, [Out] Int32[] renderbuffers)
        {
            unsafe
            {
                fixed (Int32* renderbuffers_ptr = renderbuffers)
                {
                    Delegates.glGenRenderbuffersEXT((Int32)n, (UInt32*)renderbuffers_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGenRenderbuffersEXT(Int32 n, [Out] out UInt32 renderbuffers)
        {
            unsafe
            {
                fixed (UInt32* renderbuffers_ptr = &renderbuffers)
                {
                    Delegates.glGenRenderbuffersEXT((Int32)n, (UInt32*)renderbuffers_ptr);
                    renderbuffers = *renderbuffers_ptr;
                }
            }
        }

        public static 
        void glGenRenderbuffersEXT(Int32 n, [Out] out Int32 renderbuffers)
        {
            unsafe
            {
                fixed (Int32* renderbuffers_ptr = &renderbuffers)
                {
                    Delegates.glGenRenderbuffersEXT((Int32)n, (UInt32*)renderbuffers_ptr);
                    renderbuffers = *renderbuffers_ptr;
                }
            }
        }

        public static 
        void glGenRenderbuffersEXT(Int32 n, [Out] IntPtr renderbuffers)
        {
            unsafe
            {
                Delegates.glGenRenderbuffersEXT((Int32)n, (UInt32*)renderbuffers);
            }
        }

        public static 
        void glRenderbufferStorageEXT(int target, int internalformat, Int32 width, Int32 height)
        {
            Delegates.glRenderbufferStorageEXT((int)target, (int)internalformat, (Int32)width, (Int32)height);
        }

        public static 
        void glGetRenderbufferParameterivEXT(int target, int pname, [Out] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetRenderbufferParameterivEXT((int)target, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glGetRenderbufferParameterivEXT(int target, int pname, [Out] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetRenderbufferParameterivEXT((int)target, (int)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetRenderbufferParameterivEXT(int target, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetRenderbufferParameterivEXT((int)target, (int)pname, (Int32*)@params);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        bool glIsFramebufferEXT(UInt32 framebuffer)
        {
            return Delegates.glIsFramebufferEXT((UInt32)framebuffer);
        }

        public static 
        bool glIsFramebufferEXT(Int32 framebuffer)
        {
            return Delegates.glIsFramebufferEXT((UInt32)framebuffer);
        }

        [System.CLSCompliant(false)]
        public static 
        void glBindFramebufferEXT(int target, UInt32 framebuffer)
        {
            Delegates.glBindFramebufferEXT((int)target, (UInt32)framebuffer);
        }

        public static 
        void glBindFramebufferEXT(int target, Int32 framebuffer)
        {
            Delegates.glBindFramebufferEXT((int)target, (UInt32)framebuffer);
        }

        [System.CLSCompliant(false)]
        public static 
        void glDeleteFramebuffersEXT(Int32 n, UInt32[] framebuffers)
        {
            unsafe
            {
                fixed (UInt32* framebuffers_ptr = framebuffers)
                {
                    Delegates.glDeleteFramebuffersEXT((Int32)n, (UInt32*)framebuffers_ptr);
                }
            }
        }

        public static 
        void glDeleteFramebuffersEXT(Int32 n, Int32[] framebuffers)
        {
            unsafe
            {
                fixed (Int32* framebuffers_ptr = framebuffers)
                {
                    Delegates.glDeleteFramebuffersEXT((Int32)n, (UInt32*)framebuffers_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glDeleteFramebuffersEXT(Int32 n, ref UInt32 framebuffers)
        {
            unsafe
            {
                fixed (UInt32* framebuffers_ptr = &framebuffers)
                {
                    Delegates.glDeleteFramebuffersEXT((Int32)n, (UInt32*)framebuffers_ptr);
                }
            }
        }

        public static 
        void glDeleteFramebuffersEXT(Int32 n, ref Int32 framebuffers)
        {
            unsafe
            {
                fixed (Int32* framebuffers_ptr = &framebuffers)
                {
                    Delegates.glDeleteFramebuffersEXT((Int32)n, (UInt32*)framebuffers_ptr);
                }
            }
        }

        public static 
        void glDeleteFramebuffersEXT(Int32 n, IntPtr framebuffers)
        {
            unsafe
            {
                Delegates.glDeleteFramebuffersEXT((Int32)n, (UInt32*)framebuffers);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGenFramebuffersEXT(Int32 n, [Out] UInt32[] framebuffers)
        {
            unsafe
            {
                fixed (UInt32* framebuffers_ptr = framebuffers)
                {
                    Delegates.glGenFramebuffersEXT((Int32)n, (UInt32*)framebuffers_ptr);
                }
            }
        }

        public static 
        void glGenFramebuffersEXT(Int32 n, [Out] Int32[] framebuffers)
        {
            unsafe
            {
                fixed (Int32* framebuffers_ptr = framebuffers)
                {
                    Delegates.glGenFramebuffersEXT((Int32)n, (UInt32*)framebuffers_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGenFramebuffersEXT(Int32 n, [Out] out UInt32 framebuffers)
        {
            unsafe
            {
                fixed (UInt32* framebuffers_ptr = &framebuffers)
                {
                    Delegates.glGenFramebuffersEXT((Int32)n, (UInt32*)framebuffers_ptr);
                    framebuffers = *framebuffers_ptr;
                }
            }
        }

        public static 
        void glGenFramebuffersEXT(Int32 n, [Out] out Int32 framebuffers)
        {
            unsafe
            {
                fixed (Int32* framebuffers_ptr = &framebuffers)
                {
                    Delegates.glGenFramebuffersEXT((Int32)n, (UInt32*)framebuffers_ptr);
                    framebuffers = *framebuffers_ptr;
                }
            }
        }

        public static 
        void glGenFramebuffersEXT(Int32 n, [Out] IntPtr framebuffers)
        {
            unsafe
            {
                Delegates.glGenFramebuffersEXT((Int32)n, (UInt32*)framebuffers);
            }
        }

        public static 
        int glCheckFramebufferStatusEXT(int target)
        {
            return Delegates.glCheckFramebufferStatusEXT((int)target);
        }

        [System.CLSCompliant(false)]
        public static 
        void glFramebufferTexture1DEXT(int target, int attachment, int textarget, UInt32 texture, Int32 level)
        {
            Delegates.glFramebufferTexture1DEXT((int)target, (int)attachment, (int)textarget, (UInt32)texture, (Int32)level);
        }

        public static 
        void glFramebufferTexture1DEXT(int target, int attachment, int textarget, Int32 texture, Int32 level)
        {
            Delegates.glFramebufferTexture1DEXT((int)target, (int)attachment, (int)textarget, (UInt32)texture, (Int32)level);
        }

        [System.CLSCompliant(false)]
        public static 
        void glFramebufferTexture2DEXT(int target, int attachment, int textarget, UInt32 texture, Int32 level)
        {
            Delegates.glFramebufferTexture2DEXT((int)target, (int)attachment, (int)textarget, (UInt32)texture, (Int32)level);
        }

        public static 
        void glFramebufferTexture2DEXT(int target, int attachment, int textarget, Int32 texture, Int32 level)
        {
            Delegates.glFramebufferTexture2DEXT((int)target, (int)attachment, (int)textarget, (UInt32)texture, (Int32)level);
        }

        [System.CLSCompliant(false)]
        public static 
        void glFramebufferTexture3DEXT(int target, int attachment, int textarget, UInt32 texture, Int32 level, Int32 zoffset)
        {
            Delegates.glFramebufferTexture3DEXT((int)target, (int)attachment, (int)textarget, (UInt32)texture, (Int32)level, (Int32)zoffset);
        }

        public static 
        void glFramebufferTexture3DEXT(int target, int attachment, int textarget, Int32 texture, Int32 level, Int32 zoffset)
        {
            Delegates.glFramebufferTexture3DEXT((int)target, (int)attachment, (int)textarget, (UInt32)texture, (Int32)level, (Int32)zoffset);
        }

        [System.CLSCompliant(false)]
        public static 
        void glFramebufferRenderbufferEXT(int target, int attachment, int renderbuffertarget, UInt32 renderbuffer)
        {
            Delegates.glFramebufferRenderbufferEXT((int)target, (int)attachment, (int)renderbuffertarget, (UInt32)renderbuffer);
        }

        public static 
        void glFramebufferRenderbufferEXT(int target, int attachment, int renderbuffertarget, Int32 renderbuffer)
        {
            Delegates.glFramebufferRenderbufferEXT((int)target, (int)attachment, (int)renderbuffertarget, (UInt32)renderbuffer);
        }

        public static 
        void glGetFramebufferAttachmentParameterivEXT(int target, int attachment, int pname, [Out] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetFramebufferAttachmentParameterivEXT((int)target, (int)attachment, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glGetFramebufferAttachmentParameterivEXT(int target, int attachment, int pname, [Out] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetFramebufferAttachmentParameterivEXT((int)target, (int)attachment, (int)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetFramebufferAttachmentParameterivEXT(int target, int attachment, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetFramebufferAttachmentParameterivEXT((int)target, (int)attachment, (int)pname, (Int32*)@params);
            }
        }

        public static 
        void glGenerateMipmapEXT(int target)
        {
            Delegates.glGenerateMipmapEXT((int)target);
        }

        [System.CLSCompliant(false)]
        public static 
        void glStencilClearTagEXT(Int32 stencilTagBits, UInt32 stencilClearTag)
        {
            Delegates.glStencilClearTagEXT((Int32)stencilTagBits, (UInt32)stencilClearTag);
        }

        public static 
        void glStencilClearTagEXT(Int32 stencilTagBits, Int32 stencilClearTag)
        {
            Delegates.glStencilClearTagEXT((Int32)stencilTagBits, (UInt32)stencilClearTag);
        }

        public static 
        void glBlitFramebufferEXT(Int32 srcX0, Int32 srcY0, Int32 srcX1, Int32 srcY1, Int32 dstX0, Int32 dstY0, Int32 dstX1, Int32 dstY1, int mask, int filter)
        {
            Delegates.glBlitFramebufferEXT((Int32)srcX0, (Int32)srcY0, (Int32)srcX1, (Int32)srcY1, (Int32)dstX0, (Int32)dstY0, (Int32)dstX1, (Int32)dstY1, (int)mask, (int)filter);
        }

        public static 
        void glRenderbufferStorageMultisampleEXT(int target, Int32 samples, int internalformat, Int32 width, Int32 height)
        {
            Delegates.glRenderbufferStorageMultisampleEXT((int)target, (Int32)samples, (int)internalformat, (Int32)width, (Int32)height);
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetQueryObjecti64vEXT(UInt32 id, int pname, [Out] Int64[] @params)
        {
            unsafe
            {
                fixed (Int64* @params_ptr = @params)
                {
                    Delegates.glGetQueryObjecti64vEXT((UInt32)id, (int)pname, (Int64*)@params_ptr);
                }
            }
        }

        public static 
        void glGetQueryObjecti64vEXT(Int32 id, int pname, [Out] Int64[] @params)
        {
            unsafe
            {
                fixed (Int64* @params_ptr = @params)
                {
                    Delegates.glGetQueryObjecti64vEXT((UInt32)id, (int)pname, (Int64*)@params_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetQueryObjecti64vEXT(UInt32 id, int pname, [Out] out Int64 @params)
        {
            unsafe
            {
                fixed (Int64* @params_ptr = &@params)
                {
                    Delegates.glGetQueryObjecti64vEXT((UInt32)id, (int)pname, (Int64*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetQueryObjecti64vEXT(Int32 id, int pname, [Out] out Int64 @params)
        {
            unsafe
            {
                fixed (Int64* @params_ptr = &@params)
                {
                    Delegates.glGetQueryObjecti64vEXT((UInt32)id, (int)pname, (Int64*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetQueryObjecti64vEXT(UInt32 id, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetQueryObjecti64vEXT((UInt32)id, (int)pname, (Int64*)@params);
            }
        }

        public static 
        void glGetQueryObjecti64vEXT(Int32 id, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetQueryObjecti64vEXT((UInt32)id, (int)pname, (Int64*)@params);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetQueryObjectui64vEXT(UInt32 id, int pname, [Out] UInt64[] @params)
        {
            unsafe
            {
                fixed (UInt64* @params_ptr = @params)
                {
                    Delegates.glGetQueryObjectui64vEXT((UInt32)id, (int)pname, (UInt64*)@params_ptr);
                }
            }
        }

        public static 
        void glGetQueryObjectui64vEXT(Int32 id, int pname, [Out] Int64[] @params)
        {
            unsafe
            {
                fixed (Int64* @params_ptr = @params)
                {
                    Delegates.glGetQueryObjectui64vEXT((UInt32)id, (int)pname, (UInt64*)@params_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetQueryObjectui64vEXT(UInt32 id, int pname, [Out] out UInt64 @params)
        {
            unsafe
            {
                fixed (UInt64* @params_ptr = &@params)
                {
                    Delegates.glGetQueryObjectui64vEXT((UInt32)id, (int)pname, (UInt64*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetQueryObjectui64vEXT(Int32 id, int pname, [Out] out Int64 @params)
        {
            unsafe
            {
                fixed (Int64* @params_ptr = &@params)
                {
                    Delegates.glGetQueryObjectui64vEXT((UInt32)id, (int)pname, (UInt64*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetQueryObjectui64vEXT(UInt32 id, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetQueryObjectui64vEXT((UInt32)id, (int)pname, (UInt64*)@params);
            }
        }

        public static 
        void glGetQueryObjectui64vEXT(Int32 id, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetQueryObjectui64vEXT((UInt32)id, (int)pname, (UInt64*)@params);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glProgramEnvParameters4fvEXT(int target, UInt32 index, Int32 count, Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glProgramEnvParameters4fvEXT((int)target, (UInt32)index, (Int32)count, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glProgramEnvParameters4fvEXT(int target, Int32 index, Int32 count, Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glProgramEnvParameters4fvEXT((int)target, (UInt32)index, (Int32)count, (Single*)@params_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glProgramEnvParameters4fvEXT(int target, UInt32 index, Int32 count, ref Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glProgramEnvParameters4fvEXT((int)target, (UInt32)index, (Int32)count, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glProgramEnvParameters4fvEXT(int target, Int32 index, Int32 count, ref Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glProgramEnvParameters4fvEXT((int)target, (UInt32)index, (Int32)count, (Single*)@params_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glProgramEnvParameters4fvEXT(int target, UInt32 index, Int32 count, IntPtr @params)
        {
            unsafe
            {
                Delegates.glProgramEnvParameters4fvEXT((int)target, (UInt32)index, (Int32)count, (Single*)@params);
            }
        }

        public static 
        void glProgramEnvParameters4fvEXT(int target, Int32 index, Int32 count, IntPtr @params)
        {
            unsafe
            {
                Delegates.glProgramEnvParameters4fvEXT((int)target, (UInt32)index, (Int32)count, (Single*)@params);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glProgramLocalParameters4fvEXT(int target, UInt32 index, Int32 count, Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glProgramLocalParameters4fvEXT((int)target, (UInt32)index, (Int32)count, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glProgramLocalParameters4fvEXT(int target, Int32 index, Int32 count, Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glProgramLocalParameters4fvEXT((int)target, (UInt32)index, (Int32)count, (Single*)@params_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glProgramLocalParameters4fvEXT(int target, UInt32 index, Int32 count, ref Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glProgramLocalParameters4fvEXT((int)target, (UInt32)index, (Int32)count, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glProgramLocalParameters4fvEXT(int target, Int32 index, Int32 count, ref Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glProgramLocalParameters4fvEXT((int)target, (UInt32)index, (Int32)count, (Single*)@params_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glProgramLocalParameters4fvEXT(int target, UInt32 index, Int32 count, IntPtr @params)
        {
            unsafe
            {
                Delegates.glProgramLocalParameters4fvEXT((int)target, (UInt32)index, (Int32)count, (Single*)@params);
            }
        }

        public static 
        void glProgramLocalParameters4fvEXT(int target, Int32 index, Int32 count, IntPtr @params)
        {
            unsafe
            {
                Delegates.glProgramLocalParameters4fvEXT((int)target, (UInt32)index, (Int32)count, (Single*)@params);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glFramebufferTextureEXT(int target, int attachment, UInt32 texture, Int32 level)
        {
            Delegates.glFramebufferTextureEXT((int)target, (int)attachment, (UInt32)texture, (Int32)level);
        }

        public static 
        void glFramebufferTextureEXT(int target, int attachment, Int32 texture, Int32 level)
        {
            Delegates.glFramebufferTextureEXT((int)target, (int)attachment, (UInt32)texture, (Int32)level);
        }

        [System.CLSCompliant(false)]
        public static 
        void glFramebufferTextureLayerEXT(int target, int attachment, UInt32 texture, Int32 level, Int32 layer)
        {
            Delegates.glFramebufferTextureLayerEXT((int)target, (int)attachment, (UInt32)texture, (Int32)level, (Int32)layer);
        }

        public static 
        void glFramebufferTextureLayerEXT(int target, int attachment, Int32 texture, Int32 level, Int32 layer)
        {
            Delegates.glFramebufferTextureLayerEXT((int)target, (int)attachment, (UInt32)texture, (Int32)level, (Int32)layer);
        }

        [System.CLSCompliant(false)]
        public static 
        void glFramebufferTextureFaceEXT(int target, int attachment, UInt32 texture, Int32 level, int face)
        {
            Delegates.glFramebufferTextureFaceEXT((int)target, (int)attachment, (UInt32)texture, (Int32)level, (int)face);
        }

        public static 
        void glFramebufferTextureFaceEXT(int target, int attachment, Int32 texture, Int32 level, int face)
        {
            Delegates.glFramebufferTextureFaceEXT((int)target, (int)attachment, (UInt32)texture, (Int32)level, (int)face);
        }

        [System.CLSCompliant(false)]
        public static 
        void glProgramParameteriEXT(UInt32 program, int pname, Int32 value)
        {
            Delegates.glProgramParameteriEXT((UInt32)program, (int)pname, (Int32)value);
        }

        public static 
        void glProgramParameteriEXT(Int32 program, int pname, Int32 value)
        {
            Delegates.glProgramParameteriEXT((UInt32)program, (int)pname, (Int32)value);
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttribI1iEXT(UInt32 index, Int32 x)
        {
            Delegates.glVertexAttribI1iEXT((UInt32)index, (Int32)x);
        }

        public static 
        void glVertexAttribI1iEXT(Int32 index, Int32 x)
        {
            Delegates.glVertexAttribI1iEXT((UInt32)index, (Int32)x);
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttribI2iEXT(UInt32 index, Int32 x, Int32 y)
        {
            Delegates.glVertexAttribI2iEXT((UInt32)index, (Int32)x, (Int32)y);
        }

        public static 
        void glVertexAttribI2iEXT(Int32 index, Int32 x, Int32 y)
        {
            Delegates.glVertexAttribI2iEXT((UInt32)index, (Int32)x, (Int32)y);
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttribI3iEXT(UInt32 index, Int32 x, Int32 y, Int32 z)
        {
            Delegates.glVertexAttribI3iEXT((UInt32)index, (Int32)x, (Int32)y, (Int32)z);
        }

        public static 
        void glVertexAttribI3iEXT(Int32 index, Int32 x, Int32 y, Int32 z)
        {
            Delegates.glVertexAttribI3iEXT((UInt32)index, (Int32)x, (Int32)y, (Int32)z);
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttribI4iEXT(UInt32 index, Int32 x, Int32 y, Int32 z, Int32 w)
        {
            Delegates.glVertexAttribI4iEXT((UInt32)index, (Int32)x, (Int32)y, (Int32)z, (Int32)w);
        }

        public static 
        void glVertexAttribI4iEXT(Int32 index, Int32 x, Int32 y, Int32 z, Int32 w)
        {
            Delegates.glVertexAttribI4iEXT((UInt32)index, (Int32)x, (Int32)y, (Int32)z, (Int32)w);
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttribI1uiEXT(UInt32 index, UInt32 x)
        {
            Delegates.glVertexAttribI1uiEXT((UInt32)index, (UInt32)x);
        }

        public static 
        void glVertexAttribI1uiEXT(Int32 index, Int32 x)
        {
            Delegates.glVertexAttribI1uiEXT((UInt32)index, (UInt32)x);
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttribI2uiEXT(UInt32 index, UInt32 x, UInt32 y)
        {
            Delegates.glVertexAttribI2uiEXT((UInt32)index, (UInt32)x, (UInt32)y);
        }

        public static 
        void glVertexAttribI2uiEXT(Int32 index, Int32 x, Int32 y)
        {
            Delegates.glVertexAttribI2uiEXT((UInt32)index, (UInt32)x, (UInt32)y);
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttribI3uiEXT(UInt32 index, UInt32 x, UInt32 y, UInt32 z)
        {
            Delegates.glVertexAttribI3uiEXT((UInt32)index, (UInt32)x, (UInt32)y, (UInt32)z);
        }

        public static 
        void glVertexAttribI3uiEXT(Int32 index, Int32 x, Int32 y, Int32 z)
        {
            Delegates.glVertexAttribI3uiEXT((UInt32)index, (UInt32)x, (UInt32)y, (UInt32)z);
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttribI4uiEXT(UInt32 index, UInt32 x, UInt32 y, UInt32 z, UInt32 w)
        {
            Delegates.glVertexAttribI4uiEXT((UInt32)index, (UInt32)x, (UInt32)y, (UInt32)z, (UInt32)w);
        }

        public static 
        void glVertexAttribI4uiEXT(Int32 index, Int32 x, Int32 y, Int32 z, Int32 w)
        {
            Delegates.glVertexAttribI4uiEXT((UInt32)index, (UInt32)x, (UInt32)y, (UInt32)z, (UInt32)w);
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttribI1ivEXT(UInt32 index, Int32[] v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = v)
                {
                    Delegates.glVertexAttribI1ivEXT((UInt32)index, (Int32*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttribI1ivEXT(Int32 index, Int32[] v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = v)
                {
                    Delegates.glVertexAttribI1ivEXT((UInt32)index, (Int32*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttribI1ivEXT(UInt32 index, ref Int32 v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = &v)
                {
                    Delegates.glVertexAttribI1ivEXT((UInt32)index, (Int32*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttribI1ivEXT(Int32 index, ref Int32 v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = &v)
                {
                    Delegates.glVertexAttribI1ivEXT((UInt32)index, (Int32*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttribI1ivEXT(UInt32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttribI1ivEXT((UInt32)index, (Int32*)v);
            }
        }

        public static 
        void glVertexAttribI1ivEXT(Int32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttribI1ivEXT((UInt32)index, (Int32*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttribI2ivEXT(UInt32 index, Int32[] v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = v)
                {
                    Delegates.glVertexAttribI2ivEXT((UInt32)index, (Int32*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttribI2ivEXT(Int32 index, Int32[] v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = v)
                {
                    Delegates.glVertexAttribI2ivEXT((UInt32)index, (Int32*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttribI2ivEXT(UInt32 index, ref Int32 v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = &v)
                {
                    Delegates.glVertexAttribI2ivEXT((UInt32)index, (Int32*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttribI2ivEXT(Int32 index, ref Int32 v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = &v)
                {
                    Delegates.glVertexAttribI2ivEXT((UInt32)index, (Int32*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttribI2ivEXT(UInt32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttribI2ivEXT((UInt32)index, (Int32*)v);
            }
        }

        public static 
        void glVertexAttribI2ivEXT(Int32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttribI2ivEXT((UInt32)index, (Int32*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttribI3ivEXT(UInt32 index, Int32[] v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = v)
                {
                    Delegates.glVertexAttribI3ivEXT((UInt32)index, (Int32*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttribI3ivEXT(Int32 index, Int32[] v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = v)
                {
                    Delegates.glVertexAttribI3ivEXT((UInt32)index, (Int32*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttribI3ivEXT(UInt32 index, ref Int32 v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = &v)
                {
                    Delegates.glVertexAttribI3ivEXT((UInt32)index, (Int32*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttribI3ivEXT(Int32 index, ref Int32 v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = &v)
                {
                    Delegates.glVertexAttribI3ivEXT((UInt32)index, (Int32*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttribI3ivEXT(UInt32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttribI3ivEXT((UInt32)index, (Int32*)v);
            }
        }

        public static 
        void glVertexAttribI3ivEXT(Int32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttribI3ivEXT((UInt32)index, (Int32*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttribI4ivEXT(UInt32 index, Int32[] v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = v)
                {
                    Delegates.glVertexAttribI4ivEXT((UInt32)index, (Int32*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttribI4ivEXT(Int32 index, Int32[] v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = v)
                {
                    Delegates.glVertexAttribI4ivEXT((UInt32)index, (Int32*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttribI4ivEXT(UInt32 index, ref Int32 v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = &v)
                {
                    Delegates.glVertexAttribI4ivEXT((UInt32)index, (Int32*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttribI4ivEXT(Int32 index, ref Int32 v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = &v)
                {
                    Delegates.glVertexAttribI4ivEXT((UInt32)index, (Int32*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttribI4ivEXT(UInt32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttribI4ivEXT((UInt32)index, (Int32*)v);
            }
        }

        public static 
        void glVertexAttribI4ivEXT(Int32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttribI4ivEXT((UInt32)index, (Int32*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttribI1uivEXT(UInt32 index, UInt32[] v)
        {
            unsafe
            {
                fixed (UInt32* v_ptr = v)
                {
                    Delegates.glVertexAttribI1uivEXT((UInt32)index, (UInt32*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttribI1uivEXT(Int32 index, Int32[] v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = v)
                {
                    Delegates.glVertexAttribI1uivEXT((UInt32)index, (UInt32*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttribI1uivEXT(UInt32 index, ref UInt32 v)
        {
            unsafe
            {
                fixed (UInt32* v_ptr = &v)
                {
                    Delegates.glVertexAttribI1uivEXT((UInt32)index, (UInt32*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttribI1uivEXT(Int32 index, ref Int32 v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = &v)
                {
                    Delegates.glVertexAttribI1uivEXT((UInt32)index, (UInt32*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttribI1uivEXT(UInt32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttribI1uivEXT((UInt32)index, (UInt32*)v);
            }
        }

        public static 
        void glVertexAttribI1uivEXT(Int32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttribI1uivEXT((UInt32)index, (UInt32*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttribI2uivEXT(UInt32 index, UInt32[] v)
        {
            unsafe
            {
                fixed (UInt32* v_ptr = v)
                {
                    Delegates.glVertexAttribI2uivEXT((UInt32)index, (UInt32*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttribI2uivEXT(Int32 index, Int32[] v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = v)
                {
                    Delegates.glVertexAttribI2uivEXT((UInt32)index, (UInt32*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttribI2uivEXT(UInt32 index, ref UInt32 v)
        {
            unsafe
            {
                fixed (UInt32* v_ptr = &v)
                {
                    Delegates.glVertexAttribI2uivEXT((UInt32)index, (UInt32*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttribI2uivEXT(Int32 index, ref Int32 v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = &v)
                {
                    Delegates.glVertexAttribI2uivEXT((UInt32)index, (UInt32*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttribI2uivEXT(UInt32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttribI2uivEXT((UInt32)index, (UInt32*)v);
            }
        }

        public static 
        void glVertexAttribI2uivEXT(Int32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttribI2uivEXT((UInt32)index, (UInt32*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttribI3uivEXT(UInt32 index, UInt32[] v)
        {
            unsafe
            {
                fixed (UInt32* v_ptr = v)
                {
                    Delegates.glVertexAttribI3uivEXT((UInt32)index, (UInt32*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttribI3uivEXT(Int32 index, Int32[] v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = v)
                {
                    Delegates.glVertexAttribI3uivEXT((UInt32)index, (UInt32*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttribI3uivEXT(UInt32 index, ref UInt32 v)
        {
            unsafe
            {
                fixed (UInt32* v_ptr = &v)
                {
                    Delegates.glVertexAttribI3uivEXT((UInt32)index, (UInt32*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttribI3uivEXT(Int32 index, ref Int32 v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = &v)
                {
                    Delegates.glVertexAttribI3uivEXT((UInt32)index, (UInt32*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttribI3uivEXT(UInt32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttribI3uivEXT((UInt32)index, (UInt32*)v);
            }
        }

        public static 
        void glVertexAttribI3uivEXT(Int32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttribI3uivEXT((UInt32)index, (UInt32*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttribI4uivEXT(UInt32 index, UInt32[] v)
        {
            unsafe
            {
                fixed (UInt32* v_ptr = v)
                {
                    Delegates.glVertexAttribI4uivEXT((UInt32)index, (UInt32*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttribI4uivEXT(Int32 index, Int32[] v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = v)
                {
                    Delegates.glVertexAttribI4uivEXT((UInt32)index, (UInt32*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttribI4uivEXT(UInt32 index, ref UInt32 v)
        {
            unsafe
            {
                fixed (UInt32* v_ptr = &v)
                {
                    Delegates.glVertexAttribI4uivEXT((UInt32)index, (UInt32*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttribI4uivEXT(Int32 index, ref Int32 v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = &v)
                {
                    Delegates.glVertexAttribI4uivEXT((UInt32)index, (UInt32*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttribI4uivEXT(UInt32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttribI4uivEXT((UInt32)index, (UInt32*)v);
            }
        }

        public static 
        void glVertexAttribI4uivEXT(Int32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttribI4uivEXT((UInt32)index, (UInt32*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttribI4bvEXT(UInt32 index, SByte[] v)
        {
            unsafe
            {
                fixed (SByte* v_ptr = v)
                {
                    Delegates.glVertexAttribI4bvEXT((UInt32)index, (SByte*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttribI4bvEXT(Int32 index, Byte[] v)
        {
            unsafe
            {
                fixed (Byte* v_ptr = v)
                {
                    Delegates.glVertexAttribI4bvEXT((UInt32)index, (SByte*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttribI4bvEXT(UInt32 index, ref SByte v)
        {
            unsafe
            {
                fixed (SByte* v_ptr = &v)
                {
                    Delegates.glVertexAttribI4bvEXT((UInt32)index, (SByte*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttribI4bvEXT(Int32 index, ref Byte v)
        {
            unsafe
            {
                fixed (Byte* v_ptr = &v)
                {
                    Delegates.glVertexAttribI4bvEXT((UInt32)index, (SByte*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttribI4bvEXT(UInt32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttribI4bvEXT((UInt32)index, (SByte*)v);
            }
        }

        public static 
        void glVertexAttribI4bvEXT(Int32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttribI4bvEXT((UInt32)index, (SByte*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttribI4svEXT(UInt32 index, Int16[] v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = v)
                {
                    Delegates.glVertexAttribI4svEXT((UInt32)index, (Int16*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttribI4svEXT(Int32 index, Int16[] v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = v)
                {
                    Delegates.glVertexAttribI4svEXT((UInt32)index, (Int16*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttribI4svEXT(UInt32 index, ref Int16 v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = &v)
                {
                    Delegates.glVertexAttribI4svEXT((UInt32)index, (Int16*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttribI4svEXT(Int32 index, ref Int16 v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = &v)
                {
                    Delegates.glVertexAttribI4svEXT((UInt32)index, (Int16*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttribI4svEXT(UInt32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttribI4svEXT((UInt32)index, (Int16*)v);
            }
        }

        public static 
        void glVertexAttribI4svEXT(Int32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttribI4svEXT((UInt32)index, (Int16*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttribI4ubvEXT(UInt32 index, Byte[] v)
        {
            unsafe
            {
                fixed (Byte* v_ptr = v)
                {
                    Delegates.glVertexAttribI4ubvEXT((UInt32)index, (Byte*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttribI4ubvEXT(Int32 index, Byte[] v)
        {
            unsafe
            {
                fixed (Byte* v_ptr = v)
                {
                    Delegates.glVertexAttribI4ubvEXT((UInt32)index, (Byte*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttribI4ubvEXT(UInt32 index, ref Byte v)
        {
            unsafe
            {
                fixed (Byte* v_ptr = &v)
                {
                    Delegates.glVertexAttribI4ubvEXT((UInt32)index, (Byte*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttribI4ubvEXT(Int32 index, ref Byte v)
        {
            unsafe
            {
                fixed (Byte* v_ptr = &v)
                {
                    Delegates.glVertexAttribI4ubvEXT((UInt32)index, (Byte*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttribI4ubvEXT(UInt32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttribI4ubvEXT((UInt32)index, (Byte*)v);
            }
        }

        public static 
        void glVertexAttribI4ubvEXT(Int32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttribI4ubvEXT((UInt32)index, (Byte*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttribI4usvEXT(UInt32 index, UInt16[] v)
        {
            unsafe
            {
                fixed (UInt16* v_ptr = v)
                {
                    Delegates.glVertexAttribI4usvEXT((UInt32)index, (UInt16*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttribI4usvEXT(Int32 index, Int16[] v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = v)
                {
                    Delegates.glVertexAttribI4usvEXT((UInt32)index, (UInt16*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttribI4usvEXT(UInt32 index, ref UInt16 v)
        {
            unsafe
            {
                fixed (UInt16* v_ptr = &v)
                {
                    Delegates.glVertexAttribI4usvEXT((UInt32)index, (UInt16*)v_ptr);
                }
            }
        }

        public static 
        void glVertexAttribI4usvEXT(Int32 index, ref Int16 v)
        {
            unsafe
            {
                fixed (Int16* v_ptr = &v)
                {
                    Delegates.glVertexAttribI4usvEXT((UInt32)index, (UInt16*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttribI4usvEXT(UInt32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttribI4usvEXT((UInt32)index, (UInt16*)v);
            }
        }

        public static 
        void glVertexAttribI4usvEXT(Int32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glVertexAttribI4usvEXT((UInt32)index, (UInt16*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttribIPointerEXT(UInt32 index, Int32 size, int type, Int32 stride, IntPtr pointer)
        {
            unsafe
            {
                Delegates.glVertexAttribIPointerEXT((UInt32)index, (Int32)size, (int)type, (Int32)stride, (IntPtr)pointer);
            }
        }

        public static 
        void glVertexAttribIPointerEXT(Int32 index, Int32 size, int type, Int32 stride, IntPtr pointer)
        {
            unsafe
            {
                Delegates.glVertexAttribIPointerEXT((UInt32)index, (Int32)size, (int)type, (Int32)stride, (IntPtr)pointer);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glVertexAttribIPointerEXT(UInt32 index, Int32 size, int type, Int32 stride, [In, Out] object pointer)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle pointer_ptr = System.Runtime.InteropServices.GCHandle.Alloc(pointer, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glVertexAttribIPointerEXT((UInt32)index, (Int32)size, (int)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
            }
        }

        public static 
        void glVertexAttribIPointerEXT(Int32 index, Int32 size, int type, Int32 stride, [In, Out] object pointer)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle pointer_ptr = System.Runtime.InteropServices.GCHandle.Alloc(pointer, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glVertexAttribIPointerEXT((UInt32)index, (Int32)size, (int)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetVertexAttribIivEXT(UInt32 index, int pname, [Out] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetVertexAttribIivEXT((UInt32)index, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glGetVertexAttribIivEXT(Int32 index, int pname, [Out] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetVertexAttribIivEXT((UInt32)index, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetVertexAttribIivEXT(UInt32 index, int pname, [Out] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetVertexAttribIivEXT((UInt32)index, (int)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetVertexAttribIivEXT(Int32 index, int pname, [Out] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetVertexAttribIivEXT((UInt32)index, (int)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetVertexAttribIivEXT(UInt32 index, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetVertexAttribIivEXT((UInt32)index, (int)pname, (Int32*)@params);
            }
        }

        public static 
        void glGetVertexAttribIivEXT(Int32 index, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetVertexAttribIivEXT((UInt32)index, (int)pname, (Int32*)@params);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetVertexAttribIuivEXT(UInt32 index, int pname, [Out] UInt32[] @params)
        {
            unsafe
            {
                fixed (UInt32* @params_ptr = @params)
                {
                    Delegates.glGetVertexAttribIuivEXT((UInt32)index, (int)pname, (UInt32*)@params_ptr);
                }
            }
        }

        public static 
        void glGetVertexAttribIuivEXT(Int32 index, int pname, [Out] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetVertexAttribIuivEXT((UInt32)index, (int)pname, (UInt32*)@params_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetVertexAttribIuivEXT(UInt32 index, int pname, [Out] out UInt32 @params)
        {
            unsafe
            {
                fixed (UInt32* @params_ptr = &@params)
                {
                    Delegates.glGetVertexAttribIuivEXT((UInt32)index, (int)pname, (UInt32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetVertexAttribIuivEXT(Int32 index, int pname, [Out] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetVertexAttribIuivEXT((UInt32)index, (int)pname, (UInt32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetVertexAttribIuivEXT(UInt32 index, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetVertexAttribIuivEXT((UInt32)index, (int)pname, (UInt32*)@params);
            }
        }

        public static 
        void glGetVertexAttribIuivEXT(Int32 index, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetVertexAttribIuivEXT((UInt32)index, (int)pname, (UInt32*)@params);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetUniformuivEXT(UInt32 program, Int32 location, [Out] UInt32[] @params)
        {
            unsafe
            {
                fixed (UInt32* @params_ptr = @params)
                {
                    Delegates.glGetUniformuivEXT((UInt32)program, (Int32)location, (UInt32*)@params_ptr);
                }
            }
        }

        public static 
        void glGetUniformuivEXT(Int32 program, Int32 location, [Out] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetUniformuivEXT((UInt32)program, (Int32)location, (UInt32*)@params_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetUniformuivEXT(UInt32 program, Int32 location, [Out] out UInt32 @params)
        {
            unsafe
            {
                fixed (UInt32* @params_ptr = &@params)
                {
                    Delegates.glGetUniformuivEXT((UInt32)program, (Int32)location, (UInt32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetUniformuivEXT(Int32 program, Int32 location, [Out] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetUniformuivEXT((UInt32)program, (Int32)location, (UInt32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetUniformuivEXT(UInt32 program, Int32 location, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetUniformuivEXT((UInt32)program, (Int32)location, (UInt32*)@params);
            }
        }

        public static 
        void glGetUniformuivEXT(Int32 program, Int32 location, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetUniformuivEXT((UInt32)program, (Int32)location, (UInt32*)@params);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glBindFragDataLocationEXT(UInt32 program, UInt32 color, System.String name)
        {
            Delegates.glBindFragDataLocationEXT((UInt32)program, (UInt32)color, (System.String)name);
        }

        public static 
        void glBindFragDataLocationEXT(Int32 program, Int32 color, System.String name)
        {
            Delegates.glBindFragDataLocationEXT((UInt32)program, (UInt32)color, (System.String)name);
        }

        [System.CLSCompliant(false)]
        public static 
        Int32 glGetFragDataLocationEXT(UInt32 program, System.String name)
        {
            return Delegates.glGetFragDataLocationEXT((UInt32)program, (System.String)name);
        }

        public static 
        Int32 glGetFragDataLocationEXT(Int32 program, System.String name)
        {
            return Delegates.glGetFragDataLocationEXT((UInt32)program, (System.String)name);
        }

        [System.CLSCompliant(false)]
        public static 
        void glUniform1uiEXT(Int32 location, UInt32 v0)
        {
            Delegates.glUniform1uiEXT((Int32)location, (UInt32)v0);
        }

        public static 
        void glUniform1uiEXT(Int32 location, Int32 v0)
        {
            Delegates.glUniform1uiEXT((Int32)location, (UInt32)v0);
        }

        [System.CLSCompliant(false)]
        public static 
        void glUniform2uiEXT(Int32 location, UInt32 v0, UInt32 v1)
        {
            Delegates.glUniform2uiEXT((Int32)location, (UInt32)v0, (UInt32)v1);
        }

        public static 
        void glUniform2uiEXT(Int32 location, Int32 v0, Int32 v1)
        {
            Delegates.glUniform2uiEXT((Int32)location, (UInt32)v0, (UInt32)v1);
        }

        [System.CLSCompliant(false)]
        public static 
        void glUniform3uiEXT(Int32 location, UInt32 v0, UInt32 v1, UInt32 v2)
        {
            Delegates.glUniform3uiEXT((Int32)location, (UInt32)v0, (UInt32)v1, (UInt32)v2);
        }

        public static 
        void glUniform3uiEXT(Int32 location, Int32 v0, Int32 v1, Int32 v2)
        {
            Delegates.glUniform3uiEXT((Int32)location, (UInt32)v0, (UInt32)v1, (UInt32)v2);
        }

        [System.CLSCompliant(false)]
        public static 
        void glUniform4uiEXT(Int32 location, UInt32 v0, UInt32 v1, UInt32 v2, UInt32 v3)
        {
            Delegates.glUniform4uiEXT((Int32)location, (UInt32)v0, (UInt32)v1, (UInt32)v2, (UInt32)v3);
        }

        public static 
        void glUniform4uiEXT(Int32 location, Int32 v0, Int32 v1, Int32 v2, Int32 v3)
        {
            Delegates.glUniform4uiEXT((Int32)location, (UInt32)v0, (UInt32)v1, (UInt32)v2, (UInt32)v3);
        }

        [System.CLSCompliant(false)]
        public static 
        void glUniform1uivEXT(Int32 location, Int32 count, UInt32[] value)
        {
            unsafe
            {
                fixed (UInt32* value_ptr = value)
                {
                    Delegates.glUniform1uivEXT((Int32)location, (Int32)count, (UInt32*)value_ptr);
                }
            }
        }

        public static 
        void glUniform1uivEXT(Int32 location, Int32 count, Int32[] value)
        {
            unsafe
            {
                fixed (Int32* value_ptr = value)
                {
                    Delegates.glUniform1uivEXT((Int32)location, (Int32)count, (UInt32*)value_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glUniform1uivEXT(Int32 location, Int32 count, ref UInt32 value)
        {
            unsafe
            {
                fixed (UInt32* value_ptr = &value)
                {
                    Delegates.glUniform1uivEXT((Int32)location, (Int32)count, (UInt32*)value_ptr);
                }
            }
        }

        public static 
        void glUniform1uivEXT(Int32 location, Int32 count, ref Int32 value)
        {
            unsafe
            {
                fixed (Int32* value_ptr = &value)
                {
                    Delegates.glUniform1uivEXT((Int32)location, (Int32)count, (UInt32*)value_ptr);
                }
            }
        }

        public static 
        void glUniform1uivEXT(Int32 location, Int32 count, IntPtr value)
        {
            unsafe
            {
                Delegates.glUniform1uivEXT((Int32)location, (Int32)count, (UInt32*)value);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glUniform2uivEXT(Int32 location, Int32 count, UInt32[] value)
        {
            unsafe
            {
                fixed (UInt32* value_ptr = value)
                {
                    Delegates.glUniform2uivEXT((Int32)location, (Int32)count, (UInt32*)value_ptr);
                }
            }
        }

        public static 
        void glUniform2uivEXT(Int32 location, Int32 count, Int32[] value)
        {
            unsafe
            {
                fixed (Int32* value_ptr = value)
                {
                    Delegates.glUniform2uivEXT((Int32)location, (Int32)count, (UInt32*)value_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glUniform2uivEXT(Int32 location, Int32 count, ref UInt32 value)
        {
            unsafe
            {
                fixed (UInt32* value_ptr = &value)
                {
                    Delegates.glUniform2uivEXT((Int32)location, (Int32)count, (UInt32*)value_ptr);
                }
            }
        }

        public static 
        void glUniform2uivEXT(Int32 location, Int32 count, ref Int32 value)
        {
            unsafe
            {
                fixed (Int32* value_ptr = &value)
                {
                    Delegates.glUniform2uivEXT((Int32)location, (Int32)count, (UInt32*)value_ptr);
                }
            }
        }

        public static 
        void glUniform2uivEXT(Int32 location, Int32 count, IntPtr value)
        {
            unsafe
            {
                Delegates.glUniform2uivEXT((Int32)location, (Int32)count, (UInt32*)value);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glUniform3uivEXT(Int32 location, Int32 count, UInt32[] value)
        {
            unsafe
            {
                fixed (UInt32* value_ptr = value)
                {
                    Delegates.glUniform3uivEXT((Int32)location, (Int32)count, (UInt32*)value_ptr);
                }
            }
        }

        public static 
        void glUniform3uivEXT(Int32 location, Int32 count, Int32[] value)
        {
            unsafe
            {
                fixed (Int32* value_ptr = value)
                {
                    Delegates.glUniform3uivEXT((Int32)location, (Int32)count, (UInt32*)value_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glUniform3uivEXT(Int32 location, Int32 count, ref UInt32 value)
        {
            unsafe
            {
                fixed (UInt32* value_ptr = &value)
                {
                    Delegates.glUniform3uivEXT((Int32)location, (Int32)count, (UInt32*)value_ptr);
                }
            }
        }

        public static 
        void glUniform3uivEXT(Int32 location, Int32 count, ref Int32 value)
        {
            unsafe
            {
                fixed (Int32* value_ptr = &value)
                {
                    Delegates.glUniform3uivEXT((Int32)location, (Int32)count, (UInt32*)value_ptr);
                }
            }
        }

        public static 
        void glUniform3uivEXT(Int32 location, Int32 count, IntPtr value)
        {
            unsafe
            {
                Delegates.glUniform3uivEXT((Int32)location, (Int32)count, (UInt32*)value);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glUniform4uivEXT(Int32 location, Int32 count, UInt32[] value)
        {
            unsafe
            {
                fixed (UInt32* value_ptr = value)
                {
                    Delegates.glUniform4uivEXT((Int32)location, (Int32)count, (UInt32*)value_ptr);
                }
            }
        }

        public static 
        void glUniform4uivEXT(Int32 location, Int32 count, Int32[] value)
        {
            unsafe
            {
                fixed (Int32* value_ptr = value)
                {
                    Delegates.glUniform4uivEXT((Int32)location, (Int32)count, (UInt32*)value_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glUniform4uivEXT(Int32 location, Int32 count, ref UInt32 value)
        {
            unsafe
            {
                fixed (UInt32* value_ptr = &value)
                {
                    Delegates.glUniform4uivEXT((Int32)location, (Int32)count, (UInt32*)value_ptr);
                }
            }
        }

        public static 
        void glUniform4uivEXT(Int32 location, Int32 count, ref Int32 value)
        {
            unsafe
            {
                fixed (Int32* value_ptr = &value)
                {
                    Delegates.glUniform4uivEXT((Int32)location, (Int32)count, (UInt32*)value_ptr);
                }
            }
        }

        public static 
        void glUniform4uivEXT(Int32 location, Int32 count, IntPtr value)
        {
            unsafe
            {
                Delegates.glUniform4uivEXT((Int32)location, (Int32)count, (UInt32*)value);
            }
        }

        public static 
        void glDrawArraysInstancedEXT(int mode, Int32 start, Int32 count, Int32 primcount)
        {
            Delegates.glDrawArraysInstancedEXT((int)mode, (Int32)start, (Int32)count, (Int32)primcount);
        }

        public static 
        void glDrawElementsInstancedEXT(int mode, Int32 count, int type, IntPtr indices, Int32 primcount)
        {
            unsafe
            {
                Delegates.glDrawElementsInstancedEXT((int)mode, (Int32)count, (int)type, (IntPtr)indices, (Int32)primcount);
            }
        }

        public static 
        void glDrawElementsInstancedEXT(int mode, Int32 count, int type, [In, Out] object indices, Int32 primcount)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle indices_ptr = System.Runtime.InteropServices.GCHandle.Alloc(indices, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glDrawElementsInstancedEXT((int)mode, (Int32)count, (int)type, (IntPtr)indices_ptr.AddrOfPinnedObject(), (Int32)primcount);
                }
                finally
                {
                    indices_ptr.Free();
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glTexBufferEXT(int target, int internalformat, UInt32 buffer)
        {
            Delegates.glTexBufferEXT((int)target, (int)internalformat, (UInt32)buffer);
        }

        public static 
        void glTexBufferEXT(int target, int internalformat, Int32 buffer)
        {
            Delegates.glTexBufferEXT((int)target, (int)internalformat, (UInt32)buffer);
        }

        [System.CLSCompliant(false)]
        public static 
        void glColorMaskIndexedEXT(UInt32 index, bool r, bool g, bool b, bool a)
        {
            Delegates.glColorMaskIndexedEXT((UInt32)index, (bool)r, (bool)g, (bool)b, (bool)a);
        }

        public static 
        void glColorMaskIndexedEXT(Int32 index, bool r, bool g, bool b, bool a)
        {
            Delegates.glColorMaskIndexedEXT((UInt32)index, (bool)r, (bool)g, (bool)b, (bool)a);
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetBooleanIndexedvEXT(int target, UInt32 index, [Out] bool[] data)
        {
            unsafe
            {
                fixed (bool* data_ptr = data)
                {
                    Delegates.glGetBooleanIndexedvEXT((int)target, (UInt32)index, (bool*)data_ptr);
                }
            }
        }

        public static 
        void glGetBooleanIndexedvEXT(int target, Int32 index, [Out] bool[] data)
        {
            unsafe
            {
                fixed (bool* data_ptr = data)
                {
                    Delegates.glGetBooleanIndexedvEXT((int)target, (UInt32)index, (bool*)data_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetBooleanIndexedvEXT(int target, UInt32 index, [Out] out bool data)
        {
            unsafe
            {
                fixed (bool* data_ptr = &data)
                {
                    Delegates.glGetBooleanIndexedvEXT((int)target, (UInt32)index, (bool*)data_ptr);
                    data = *data_ptr;
                }
            }
        }

        public static 
        void glGetBooleanIndexedvEXT(int target, Int32 index, [Out] out bool data)
        {
            unsafe
            {
                fixed (bool* data_ptr = &data)
                {
                    Delegates.glGetBooleanIndexedvEXT((int)target, (UInt32)index, (bool*)data_ptr);
                    data = *data_ptr;
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetBooleanIndexedvEXT(int target, UInt32 index, [Out] IntPtr data)
        {
            unsafe
            {
                Delegates.glGetBooleanIndexedvEXT((int)target, (UInt32)index, (bool*)data);
            }
        }

        public static 
        void glGetBooleanIndexedvEXT(int target, Int32 index, [Out] IntPtr data)
        {
            unsafe
            {
                Delegates.glGetBooleanIndexedvEXT((int)target, (UInt32)index, (bool*)data);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetIntegerIndexedvEXT(int target, UInt32 index, [Out] Int32[] data)
        {
            unsafe
            {
                fixed (Int32* data_ptr = data)
                {
                    Delegates.glGetIntegerIndexedvEXT((int)target, (UInt32)index, (Int32*)data_ptr);
                }
            }
        }

        public static 
        void glGetIntegerIndexedvEXT(int target, Int32 index, [Out] Int32[] data)
        {
            unsafe
            {
                fixed (Int32* data_ptr = data)
                {
                    Delegates.glGetIntegerIndexedvEXT((int)target, (UInt32)index, (Int32*)data_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetIntegerIndexedvEXT(int target, UInt32 index, [Out] out Int32 data)
        {
            unsafe
            {
                fixed (Int32* data_ptr = &data)
                {
                    Delegates.glGetIntegerIndexedvEXT((int)target, (UInt32)index, (Int32*)data_ptr);
                    data = *data_ptr;
                }
            }
        }

        public static 
        void glGetIntegerIndexedvEXT(int target, Int32 index, [Out] out Int32 data)
        {
            unsafe
            {
                fixed (Int32* data_ptr = &data)
                {
                    Delegates.glGetIntegerIndexedvEXT((int)target, (UInt32)index, (Int32*)data_ptr);
                    data = *data_ptr;
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetIntegerIndexedvEXT(int target, UInt32 index, [Out] IntPtr data)
        {
            unsafe
            {
                Delegates.glGetIntegerIndexedvEXT((int)target, (UInt32)index, (Int32*)data);
            }
        }

        public static 
        void glGetIntegerIndexedvEXT(int target, Int32 index, [Out] IntPtr data)
        {
            unsafe
            {
                Delegates.glGetIntegerIndexedvEXT((int)target, (UInt32)index, (Int32*)data);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glEnableIndexedEXT(int target, UInt32 index)
        {
            Delegates.glEnableIndexedEXT((int)target, (UInt32)index);
        }

        public static 
        void glEnableIndexedEXT(int target, Int32 index)
        {
            Delegates.glEnableIndexedEXT((int)target, (UInt32)index);
        }

        [System.CLSCompliant(false)]
        public static 
        void glDisableIndexedEXT(int target, UInt32 index)
        {
            Delegates.glDisableIndexedEXT((int)target, (UInt32)index);
        }

        public static 
        void glDisableIndexedEXT(int target, Int32 index)
        {
            Delegates.glDisableIndexedEXT((int)target, (UInt32)index);
        }

        [System.CLSCompliant(false)]
        public static 
        bool glIsEnabledIndexedEXT(int target, UInt32 index)
        {
            return Delegates.glIsEnabledIndexedEXT((int)target, (UInt32)index);
        }

        public static 
        bool glIsEnabledIndexedEXT(int target, Int32 index)
        {
            return Delegates.glIsEnabledIndexedEXT((int)target, (UInt32)index);
        }

        [System.CLSCompliant(false)]
        public static 
        void glUniformBufferEXT(UInt32 program, Int32 location, UInt32 buffer)
        {
            Delegates.glUniformBufferEXT((UInt32)program, (Int32)location, (UInt32)buffer);
        }

        public static 
        void glUniformBufferEXT(Int32 program, Int32 location, Int32 buffer)
        {
            Delegates.glUniformBufferEXT((UInt32)program, (Int32)location, (UInt32)buffer);
        }

        [System.CLSCompliant(false)]
        public static 
        Int32 glGetUniformBufferSizeEXT(UInt32 program, Int32 location)
        {
            return Delegates.glGetUniformBufferSizeEXT((UInt32)program, (Int32)location);
        }

        public static 
        Int32 glGetUniformBufferSizeEXT(Int32 program, Int32 location)
        {
            return Delegates.glGetUniformBufferSizeEXT((UInt32)program, (Int32)location);
        }

        [System.CLSCompliant(false)]
        public static 
        IntPtr glGetUniformOffsetEXT(UInt32 program, Int32 location)
        {
            return Delegates.glGetUniformOffsetEXT((UInt32)program, (Int32)location);
        }

        public static 
        IntPtr glGetUniformOffsetEXT(Int32 program, Int32 location)
        {
            return Delegates.glGetUniformOffsetEXT((UInt32)program, (Int32)location);
        }

        public static 
        void glTexParameterIivEXT(int target, int pname, Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glTexParameterIivEXT((int)target, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glTexParameterIivEXT(int target, int pname, ref Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glTexParameterIivEXT((int)target, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glTexParameterIivEXT(int target, int pname, IntPtr @params)
        {
            unsafe
            {
                Delegates.glTexParameterIivEXT((int)target, (int)pname, (Int32*)@params);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glTexParameterIuivEXT(int target, int pname, UInt32[] @params)
        {
            unsafe
            {
                fixed (UInt32* @params_ptr = @params)
                {
                    Delegates.glTexParameterIuivEXT((int)target, (int)pname, (UInt32*)@params_ptr);
                }
            }
        }

        public static 
        void glTexParameterIuivEXT(int target, int pname, Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glTexParameterIuivEXT((int)target, (int)pname, (UInt32*)@params_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glTexParameterIuivEXT(int target, int pname, ref UInt32 @params)
        {
            unsafe
            {
                fixed (UInt32* @params_ptr = &@params)
                {
                    Delegates.glTexParameterIuivEXT((int)target, (int)pname, (UInt32*)@params_ptr);
                }
            }
        }

        public static 
        void glTexParameterIuivEXT(int target, int pname, ref Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glTexParameterIuivEXT((int)target, (int)pname, (UInt32*)@params_ptr);
                }
            }
        }

        public static 
        void glTexParameterIuivEXT(int target, int pname, IntPtr @params)
        {
            unsafe
            {
                Delegates.glTexParameterIuivEXT((int)target, (int)pname, (UInt32*)@params);
            }
        }

        public static 
        void glGetTexParameterIivEXT(int target, int pname, [Out] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetTexParameterIivEXT((int)target, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glGetTexParameterIivEXT(int target, int pname, [Out] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetTexParameterIivEXT((int)target, (int)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetTexParameterIivEXT(int target, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetTexParameterIivEXT((int)target, (int)pname, (Int32*)@params);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetTexParameterIuivEXT(int target, int pname, [Out] UInt32[] @params)
        {
            unsafe
            {
                fixed (UInt32* @params_ptr = @params)
                {
                    Delegates.glGetTexParameterIuivEXT((int)target, (int)pname, (UInt32*)@params_ptr);
                }
            }
        }

        public static 
        void glGetTexParameterIuivEXT(int target, int pname, [Out] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetTexParameterIuivEXT((int)target, (int)pname, (UInt32*)@params_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetTexParameterIuivEXT(int target, int pname, [Out] out UInt32 @params)
        {
            unsafe
            {
                fixed (UInt32* @params_ptr = &@params)
                {
                    Delegates.glGetTexParameterIuivEXT((int)target, (int)pname, (UInt32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetTexParameterIuivEXT(int target, int pname, [Out] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetTexParameterIuivEXT((int)target, (int)pname, (UInt32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetTexParameterIuivEXT(int target, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetTexParameterIuivEXT((int)target, (int)pname, (UInt32*)@params);
            }
        }

        public static 
        void glClearColorIiEXT(Int32 red, Int32 green, Int32 blue, Int32 alpha)
        {
            Delegates.glClearColorIiEXT((Int32)red, (Int32)green, (Int32)blue, (Int32)alpha);
        }

        [System.CLSCompliant(false)]
        public static 
        void glClearColorIuiEXT(UInt32 red, UInt32 green, UInt32 blue, UInt32 alpha)
        {
            Delegates.glClearColorIuiEXT((UInt32)red, (UInt32)green, (UInt32)blue, (UInt32)alpha);
        }

        public static 
        void glClearColorIuiEXT(Int32 red, Int32 green, Int32 blue, Int32 alpha)
        {
            Delegates.glClearColorIuiEXT((UInt32)red, (UInt32)green, (UInt32)blue, (UInt32)alpha);
        }

        public static 
        void glGetTexFilterFuncSGIS(int target, int filter, [Out] Single[] weights)
        {
            unsafe
            {
                fixed (Single* weights_ptr = weights)
                {
                    Delegates.glGetTexFilterFuncSGIS((int)target, (int)filter, (Single*)weights_ptr);
                }
            }
        }

        public static 
        void glGetTexFilterFuncSGIS(int target, int filter, [Out] out Single weights)
        {
            unsafe
            {
                fixed (Single* weights_ptr = &weights)
                {
                    Delegates.glGetTexFilterFuncSGIS((int)target, (int)filter, (Single*)weights_ptr);
                    weights = *weights_ptr;
                }
            }
        }

        public static 
        void glGetTexFilterFuncSGIS(int target, int filter, [Out] IntPtr weights)
        {
            unsafe
            {
                Delegates.glGetTexFilterFuncSGIS((int)target, (int)filter, (Single*)weights);
            }
        }

        public static 
        void glTexFilterFuncSGIS(int target, int filter, Int32 n, Single[] weights)
        {
            unsafe
            {
                fixed (Single* weights_ptr = weights)
                {
                    Delegates.glTexFilterFuncSGIS((int)target, (int)filter, (Int32)n, (Single*)weights_ptr);
                }
            }
        }

        public static 
        void glTexFilterFuncSGIS(int target, int filter, Int32 n, ref Single weights)
        {
            unsafe
            {
                fixed (Single* weights_ptr = &weights)
                {
                    Delegates.glTexFilterFuncSGIS((int)target, (int)filter, (Int32)n, (Single*)weights_ptr);
                }
            }
        }

        public static 
        void glTexFilterFuncSGIS(int target, int filter, Int32 n, IntPtr weights)
        {
            unsafe
            {
                Delegates.glTexFilterFuncSGIS((int)target, (int)filter, (Int32)n, (Single*)weights);
            }
        }

        public static 
        void glPixelTexGenParameteriSGIS(int pname, Int32 param)
        {
            Delegates.glPixelTexGenParameteriSGIS((int)pname, (Int32)param);
        }

        public static 
        void glPixelTexGenParameterivSGIS(int pname, Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glPixelTexGenParameterivSGIS((int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glPixelTexGenParameterivSGIS(int pname, ref Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glPixelTexGenParameterivSGIS((int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glPixelTexGenParameterivSGIS(int pname, IntPtr @params)
        {
            unsafe
            {
                Delegates.glPixelTexGenParameterivSGIS((int)pname, (Int32*)@params);
            }
        }

        public static 
        void glPixelTexGenParameterfSGIS(int pname, Single param)
        {
            Delegates.glPixelTexGenParameterfSGIS((int)pname, (Single)param);
        }

        public static 
        void glPixelTexGenParameterfvSGIS(int pname, Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glPixelTexGenParameterfvSGIS((int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glPixelTexGenParameterfvSGIS(int pname, ref Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glPixelTexGenParameterfvSGIS((int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glPixelTexGenParameterfvSGIS(int pname, IntPtr @params)
        {
            unsafe
            {
                Delegates.glPixelTexGenParameterfvSGIS((int)pname, (Single*)@params);
            }
        }

        public static 
        void glGetPixelTexGenParameterivSGIS(int pname, [Out] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetPixelTexGenParameterivSGIS((int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glGetPixelTexGenParameterivSGIS(int pname, [Out] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetPixelTexGenParameterivSGIS((int)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetPixelTexGenParameterivSGIS(int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetPixelTexGenParameterivSGIS((int)pname, (Int32*)@params);
            }
        }

        public static 
        void glGetPixelTexGenParameterfvSGIS(int pname, [Out] Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glGetPixelTexGenParameterfvSGIS((int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glGetPixelTexGenParameterfvSGIS(int pname, [Out] out Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glGetPixelTexGenParameterfvSGIS((int)pname, (Single*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetPixelTexGenParameterfvSGIS(int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetPixelTexGenParameterfvSGIS((int)pname, (Single*)@params);
            }
        }

        public static 
        void glTexImage4DSGIS(int target, Int32 level, int internalformat, Int32 width, Int32 height, Int32 depth, Int32 size4d, Int32 border, int format, int type, IntPtr pixels)
        {
            unsafe
            {
                Delegates.glTexImage4DSGIS((int)target, (Int32)level, (int)internalformat, (Int32)width, (Int32)height, (Int32)depth, (Int32)size4d, (Int32)border, (int)format, (int)type, (IntPtr)pixels);
            }
        }

        public static 
        void glTexImage4DSGIS(int target, Int32 level, int internalformat, Int32 width, Int32 height, Int32 depth, Int32 size4d, Int32 border, int format, int type, [In, Out] object pixels)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle pixels_ptr = System.Runtime.InteropServices.GCHandle.Alloc(pixels, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glTexImage4DSGIS((int)target, (Int32)level, (int)internalformat, (Int32)width, (Int32)height, (Int32)depth, (Int32)size4d, (Int32)border, (int)format, (int)type, (IntPtr)pixels_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pixels_ptr.Free();
                }
            }
        }

        public static 
        void glTexSubImage4DSGIS(int target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 zoffset, Int32 woffset, Int32 width, Int32 height, Int32 depth, Int32 size4d, int format, int type, IntPtr pixels)
        {
            unsafe
            {
                Delegates.glTexSubImage4DSGIS((int)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)zoffset, (Int32)woffset, (Int32)width, (Int32)height, (Int32)depth, (Int32)size4d, (int)format, (int)type, (IntPtr)pixels);
            }
        }

        public static 
        void glTexSubImage4DSGIS(int target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 zoffset, Int32 woffset, Int32 width, Int32 height, Int32 depth, Int32 size4d, int format, int type, [In, Out] object pixels)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle pixels_ptr = System.Runtime.InteropServices.GCHandle.Alloc(pixels, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glTexSubImage4DSGIS((int)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)zoffset, (Int32)woffset, (Int32)width, (Int32)height, (Int32)depth, (Int32)size4d, (int)format, (int)type, (IntPtr)pixels_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pixels_ptr.Free();
                }
            }
        }

        public static 
        void glDetailTexFuncSGIS(int target, Int32 n, Single[] points)
        {
            unsafe
            {
                fixed (Single* points_ptr = points)
                {
                    Delegates.glDetailTexFuncSGIS((int)target, (Int32)n, (Single*)points_ptr);
                }
            }
        }

        public static 
        void glDetailTexFuncSGIS(int target, Int32 n, ref Single points)
        {
            unsafe
            {
                fixed (Single* points_ptr = &points)
                {
                    Delegates.glDetailTexFuncSGIS((int)target, (Int32)n, (Single*)points_ptr);
                }
            }
        }

        public static 
        void glDetailTexFuncSGIS(int target, Int32 n, IntPtr points)
        {
            unsafe
            {
                Delegates.glDetailTexFuncSGIS((int)target, (Int32)n, (Single*)points);
            }
        }

        public static 
        void glGetDetailTexFuncSGIS(int target, [Out] Single[] points)
        {
            unsafe
            {
                fixed (Single* points_ptr = points)
                {
                    Delegates.glGetDetailTexFuncSGIS((int)target, (Single*)points_ptr);
                }
            }
        }

        public static 
        void glGetDetailTexFuncSGIS(int target, [Out] out Single points)
        {
            unsafe
            {
                fixed (Single* points_ptr = &points)
                {
                    Delegates.glGetDetailTexFuncSGIS((int)target, (Single*)points_ptr);
                    points = *points_ptr;
                }
            }
        }

        public static 
        void glGetDetailTexFuncSGIS(int target, [Out] IntPtr points)
        {
            unsafe
            {
                Delegates.glGetDetailTexFuncSGIS((int)target, (Single*)points);
            }
        }

        public static 
        void glSharpenTexFuncSGIS(int target, Int32 n, Single[] points)
        {
            unsafe
            {
                fixed (Single* points_ptr = points)
                {
                    Delegates.glSharpenTexFuncSGIS((int)target, (Int32)n, (Single*)points_ptr);
                }
            }
        }

        public static 
        void glSharpenTexFuncSGIS(int target, Int32 n, ref Single points)
        {
            unsafe
            {
                fixed (Single* points_ptr = &points)
                {
                    Delegates.glSharpenTexFuncSGIS((int)target, (Int32)n, (Single*)points_ptr);
                }
            }
        }

        public static 
        void glSharpenTexFuncSGIS(int target, Int32 n, IntPtr points)
        {
            unsafe
            {
                Delegates.glSharpenTexFuncSGIS((int)target, (Int32)n, (Single*)points);
            }
        }

        public static 
        void glGetSharpenTexFuncSGIS(int target, [Out] Single[] points)
        {
            unsafe
            {
                fixed (Single* points_ptr = points)
                {
                    Delegates.glGetSharpenTexFuncSGIS((int)target, (Single*)points_ptr);
                }
            }
        }

        public static 
        void glGetSharpenTexFuncSGIS(int target, [Out] out Single points)
        {
            unsafe
            {
                fixed (Single* points_ptr = &points)
                {
                    Delegates.glGetSharpenTexFuncSGIS((int)target, (Single*)points_ptr);
                    points = *points_ptr;
                }
            }
        }

        public static 
        void glGetSharpenTexFuncSGIS(int target, [Out] IntPtr points)
        {
            unsafe
            {
                Delegates.glGetSharpenTexFuncSGIS((int)target, (Single*)points);
            }
        }

        public static 
        void glSampleMaskSGIS(Single value, bool invert)
        {
            Delegates.glSampleMaskSGIS((Single)value, (bool)invert);
        }

        public static 
        void glSamplePatternSGIS(int pattern)
        {
            Delegates.glSamplePatternSGIS((int)pattern);
        }

        public static 
        void glPointParameterfSGIS(int pname, Single param)
        {
            Delegates.glPointParameterfSGIS((int)pname, (Single)param);
        }

        public static 
        void glPointParameterfvSGIS(int pname, Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glPointParameterfvSGIS((int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glPointParameterfvSGIS(int pname, ref Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glPointParameterfvSGIS((int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glPointParameterfvSGIS(int pname, IntPtr @params)
        {
            unsafe
            {
                Delegates.glPointParameterfvSGIS((int)pname, (Single*)@params);
            }
        }

        public static 
        void glFogFuncSGIS(Int32 n, Single[] points)
        {
            unsafe
            {
                fixed (Single* points_ptr = points)
                {
                    Delegates.glFogFuncSGIS((Int32)n, (Single*)points_ptr);
                }
            }
        }

        public static 
        void glFogFuncSGIS(Int32 n, ref Single points)
        {
            unsafe
            {
                fixed (Single* points_ptr = &points)
                {
                    Delegates.glFogFuncSGIS((Int32)n, (Single*)points_ptr);
                }
            }
        }

        public static 
        void glFogFuncSGIS(Int32 n, IntPtr points)
        {
            unsafe
            {
                Delegates.glFogFuncSGIS((Int32)n, (Single*)points);
            }
        }

        public static 
        void glGetFogFuncSGIS([Out] Single[] points)
        {
            unsafe
            {
                fixed (Single* points_ptr = points)
                {
                    Delegates.glGetFogFuncSGIS((Single*)points_ptr);
                }
            }
        }

        public static 
        void glGetFogFuncSGIS([Out] out Single points)
        {
            unsafe
            {
                fixed (Single* points_ptr = &points)
                {
                    Delegates.glGetFogFuncSGIS((Single*)points_ptr);
                    points = *points_ptr;
                }
            }
        }

        public static 
        void glGetFogFuncSGIS([Out] IntPtr points)
        {
            unsafe
            {
                Delegates.glGetFogFuncSGIS((Single*)points);
            }
        }

        public static 
        void glTextureColorMaskSGIS(bool red, bool green, bool blue, bool alpha)
        {
            Delegates.glTextureColorMaskSGIS((bool)red, (bool)green, (bool)blue, (bool)alpha);
        }

        public static 
        void glColorTableSGI(int target, int internalformat, Int32 width, int format, int type, IntPtr table)
        {
            unsafe
            {
                Delegates.glColorTableSGI((int)target, (int)internalformat, (Int32)width, (int)format, (int)type, (IntPtr)table);
            }
        }

        public static 
        void glColorTableSGI(int target, int internalformat, Int32 width, int format, int type, [In, Out] object table)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle table_ptr = System.Runtime.InteropServices.GCHandle.Alloc(table, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glColorTableSGI((int)target, (int)internalformat, (Int32)width, (int)format, (int)type, (IntPtr)table_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    table_ptr.Free();
                }
            }
        }

        public static 
        void glColorTableParameterfvSGI(int target, int pname, Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glColorTableParameterfvSGI((int)target, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glColorTableParameterfvSGI(int target, int pname, ref Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glColorTableParameterfvSGI((int)target, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glColorTableParameterfvSGI(int target, int pname, IntPtr @params)
        {
            unsafe
            {
                Delegates.glColorTableParameterfvSGI((int)target, (int)pname, (Single*)@params);
            }
        }

        public static 
        void glColorTableParameterivSGI(int target, int pname, Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glColorTableParameterivSGI((int)target, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glColorTableParameterivSGI(int target, int pname, ref Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glColorTableParameterivSGI((int)target, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glColorTableParameterivSGI(int target, int pname, IntPtr @params)
        {
            unsafe
            {
                Delegates.glColorTableParameterivSGI((int)target, (int)pname, (Int32*)@params);
            }
        }

        public static 
        void glCopyColorTableSGI(int target, int internalformat, Int32 x, Int32 y, Int32 width)
        {
            Delegates.glCopyColorTableSGI((int)target, (int)internalformat, (Int32)x, (Int32)y, (Int32)width);
        }

        public static 
        void glGetColorTableSGI(int target, int format, int type, [Out] IntPtr table)
        {
            unsafe
            {
                Delegates.glGetColorTableSGI((int)target, (int)format, (int)type, (IntPtr)table);
            }
        }

        public static 
        void glGetColorTableSGI(int target, int format, int type, [In, Out] object table)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle table_ptr = System.Runtime.InteropServices.GCHandle.Alloc(table, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glGetColorTableSGI((int)target, (int)format, (int)type, (IntPtr)table_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    table_ptr.Free();
                }
            }
        }

        public static 
        void glGetColorTableParameterfvSGI(int target, int pname, [Out] Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glGetColorTableParameterfvSGI((int)target, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glGetColorTableParameterfvSGI(int target, int pname, [Out] out Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glGetColorTableParameterfvSGI((int)target, (int)pname, (Single*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetColorTableParameterfvSGI(int target, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetColorTableParameterfvSGI((int)target, (int)pname, (Single*)@params);
            }
        }

        public static 
        void glGetColorTableParameterivSGI(int target, int pname, [Out] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetColorTableParameterivSGI((int)target, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glGetColorTableParameterivSGI(int target, int pname, [Out] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetColorTableParameterivSGI((int)target, (int)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetColorTableParameterivSGI(int target, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetColorTableParameterivSGI((int)target, (int)pname, (Int32*)@params);
            }
        }

        public static 
        void glPixelTexGenSGIX(int mode)
        {
            Delegates.glPixelTexGenSGIX((int)mode);
        }

        public static 
        void glSpriteParameterfSGIX(int pname, Single param)
        {
            Delegates.glSpriteParameterfSGIX((int)pname, (Single)param);
        }

        public static 
        void glSpriteParameterfvSGIX(int pname, Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glSpriteParameterfvSGIX((int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glSpriteParameterfvSGIX(int pname, ref Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glSpriteParameterfvSGIX((int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glSpriteParameterfvSGIX(int pname, IntPtr @params)
        {
            unsafe
            {
                Delegates.glSpriteParameterfvSGIX((int)pname, (Single*)@params);
            }
        }

        public static 
        void glSpriteParameteriSGIX(int pname, Int32 param)
        {
            Delegates.glSpriteParameteriSGIX((int)pname, (Int32)param);
        }

        public static 
        void glSpriteParameterivSGIX(int pname, Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glSpriteParameterivSGIX((int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glSpriteParameterivSGIX(int pname, ref Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glSpriteParameterivSGIX((int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glSpriteParameterivSGIX(int pname, IntPtr @params)
        {
            unsafe
            {
                Delegates.glSpriteParameterivSGIX((int)pname, (Int32*)@params);
            }
        }

        public static 
        Int32 glGetInstrumentsSGIX()
        {
            return Delegates.glGetInstrumentsSGIX();
        }

        public static 
        void glInstrumentsBufferSGIX(Int32 size, [Out] Int32[] buffer)
        {
            unsafe
            {
                fixed (Int32* buffer_ptr = buffer)
                {
                    Delegates.glInstrumentsBufferSGIX((Int32)size, (Int32*)buffer_ptr);
                }
            }
        }

        public static 
        void glInstrumentsBufferSGIX(Int32 size, [Out] out Int32 buffer)
        {
            unsafe
            {
                fixed (Int32* buffer_ptr = &buffer)
                {
                    Delegates.glInstrumentsBufferSGIX((Int32)size, (Int32*)buffer_ptr);
                    buffer = *buffer_ptr;
                }
            }
        }

        public static 
        void glInstrumentsBufferSGIX(Int32 size, [Out] IntPtr buffer)
        {
            unsafe
            {
                Delegates.glInstrumentsBufferSGIX((Int32)size, (Int32*)buffer);
            }
        }

        public static 
        Int32 glPollInstrumentsSGIX([Out] Int32[] marker_p)
        {
            unsafe
            {
                fixed (Int32* marker_p_ptr = marker_p)
                {
                    return Delegates.glPollInstrumentsSGIX((Int32*)marker_p_ptr);
                }
            }
        }

        public static 
        Int32 glPollInstrumentsSGIX([Out] out Int32 marker_p)
        {
            unsafe
            {
                fixed (Int32* marker_p_ptr = &marker_p)
                {
                    Int32 retval = Delegates.glPollInstrumentsSGIX((Int32*)marker_p_ptr);
                    marker_p = *marker_p_ptr;
                    return retval;
                }
            }
        }

        public static 
        Int32 glPollInstrumentsSGIX([Out] IntPtr marker_p)
        {
            unsafe
            {
                return Delegates.glPollInstrumentsSGIX((Int32*)marker_p);
            }
        }

        public static 
        void glReadInstrumentsSGIX(Int32 marker)
        {
            Delegates.glReadInstrumentsSGIX((Int32)marker);
        }

        public static 
        void glStartInstrumentsSGIX()
        {
            Delegates.glStartInstrumentsSGIX();
        }

        public static 
        void glStopInstrumentsSGIX(Int32 marker)
        {
            Delegates.glStopInstrumentsSGIX((Int32)marker);
        }

        public static 
        void glFrameZoomSGIX(Int32 factor)
        {
            Delegates.glFrameZoomSGIX((Int32)factor);
        }

        public static 
        void glTagSampleBufferSGIX()
        {
            Delegates.glTagSampleBufferSGIX();
        }

        public static 
        void glDeformationMap3dSGIX(int target, Double u1, Double u2, Int32 ustride, Int32 uorder, Double v1, Double v2, Int32 vstride, Int32 vorder, Double w1, Double w2, Int32 wstride, Int32 worder, Double[] points)
        {
            unsafe
            {
                fixed (Double* points_ptr = points)
                {
                    Delegates.glDeformationMap3dSGIX((int)target, (Double)u1, (Double)u2, (Int32)ustride, (Int32)uorder, (Double)v1, (Double)v2, (Int32)vstride, (Int32)vorder, (Double)w1, (Double)w2, (Int32)wstride, (Int32)worder, (Double*)points_ptr);
                }
            }
        }

        public static 
        void glDeformationMap3dSGIX(int target, Double u1, Double u2, Int32 ustride, Int32 uorder, Double v1, Double v2, Int32 vstride, Int32 vorder, Double w1, Double w2, Int32 wstride, Int32 worder, ref Double points)
        {
            unsafe
            {
                fixed (Double* points_ptr = &points)
                {
                    Delegates.glDeformationMap3dSGIX((int)target, (Double)u1, (Double)u2, (Int32)ustride, (Int32)uorder, (Double)v1, (Double)v2, (Int32)vstride, (Int32)vorder, (Double)w1, (Double)w2, (Int32)wstride, (Int32)worder, (Double*)points_ptr);
                }
            }
        }

        public static 
        void glDeformationMap3dSGIX(int target, Double u1, Double u2, Int32 ustride, Int32 uorder, Double v1, Double v2, Int32 vstride, Int32 vorder, Double w1, Double w2, Int32 wstride, Int32 worder, IntPtr points)
        {
            unsafe
            {
                Delegates.glDeformationMap3dSGIX((int)target, (Double)u1, (Double)u2, (Int32)ustride, (Int32)uorder, (Double)v1, (Double)v2, (Int32)vstride, (Int32)vorder, (Double)w1, (Double)w2, (Int32)wstride, (Int32)worder, (Double*)points);
            }
        }

        public static 
        void glDeformationMap3fSGIX(int target, Single u1, Single u2, Int32 ustride, Int32 uorder, Single v1, Single v2, Int32 vstride, Int32 vorder, Single w1, Single w2, Int32 wstride, Int32 worder, Single[] points)
        {
            unsafe
            {
                fixed (Single* points_ptr = points)
                {
                    Delegates.glDeformationMap3fSGIX((int)target, (Single)u1, (Single)u2, (Int32)ustride, (Int32)uorder, (Single)v1, (Single)v2, (Int32)vstride, (Int32)vorder, (Single)w1, (Single)w2, (Int32)wstride, (Int32)worder, (Single*)points_ptr);
                }
            }
        }

        public static 
        void glDeformationMap3fSGIX(int target, Single u1, Single u2, Int32 ustride, Int32 uorder, Single v1, Single v2, Int32 vstride, Int32 vorder, Single w1, Single w2, Int32 wstride, Int32 worder, ref Single points)
        {
            unsafe
            {
                fixed (Single* points_ptr = &points)
                {
                    Delegates.glDeformationMap3fSGIX((int)target, (Single)u1, (Single)u2, (Int32)ustride, (Int32)uorder, (Single)v1, (Single)v2, (Int32)vstride, (Int32)vorder, (Single)w1, (Single)w2, (Int32)wstride, (Int32)worder, (Single*)points_ptr);
                }
            }
        }

        public static 
        void glDeformationMap3fSGIX(int target, Single u1, Single u2, Int32 ustride, Int32 uorder, Single v1, Single v2, Int32 vstride, Int32 vorder, Single w1, Single w2, Int32 wstride, Int32 worder, IntPtr points)
        {
            unsafe
            {
                Delegates.glDeformationMap3fSGIX((int)target, (Single)u1, (Single)u2, (Int32)ustride, (Int32)uorder, (Single)v1, (Single)v2, (Int32)vstride, (Int32)vorder, (Single)w1, (Single)w2, (Int32)wstride, (Int32)worder, (Single*)points);
            }
        }

        public static 
        void glDeformSGIX(int mask)
        {
            Delegates.glDeformSGIX((int)mask);
        }

        public static 
        void glLoadIdentityDeformationMapSGIX(int mask)
        {
            Delegates.glLoadIdentityDeformationMapSGIX((int)mask);
        }

        public static 
        void glReferencePlaneSGIX(Double[] equation)
        {
            unsafe
            {
                fixed (Double* equation_ptr = equation)
                {
                    Delegates.glReferencePlaneSGIX((Double*)equation_ptr);
                }
            }
        }

        public static 
        void glReferencePlaneSGIX(ref Double equation)
        {
            unsafe
            {
                fixed (Double* equation_ptr = &equation)
                {
                    Delegates.glReferencePlaneSGIX((Double*)equation_ptr);
                }
            }
        }

        public static 
        void glReferencePlaneSGIX(IntPtr equation)
        {
            unsafe
            {
                Delegates.glReferencePlaneSGIX((Double*)equation);
            }
        }

        public static 
        void glFlushRasterSGIX()
        {
            Delegates.glFlushRasterSGIX();
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetListParameterfvSGIX(UInt32 list, int pname, [Out] Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glGetListParameterfvSGIX((UInt32)list, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glGetListParameterfvSGIX(Int32 list, int pname, [Out] Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glGetListParameterfvSGIX((UInt32)list, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetListParameterfvSGIX(UInt32 list, int pname, [Out] out Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glGetListParameterfvSGIX((UInt32)list, (int)pname, (Single*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetListParameterfvSGIX(Int32 list, int pname, [Out] out Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glGetListParameterfvSGIX((UInt32)list, (int)pname, (Single*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetListParameterfvSGIX(UInt32 list, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetListParameterfvSGIX((UInt32)list, (int)pname, (Single*)@params);
            }
        }

        public static 
        void glGetListParameterfvSGIX(Int32 list, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetListParameterfvSGIX((UInt32)list, (int)pname, (Single*)@params);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetListParameterivSGIX(UInt32 list, int pname, [Out] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetListParameterivSGIX((UInt32)list, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glGetListParameterivSGIX(Int32 list, int pname, [Out] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetListParameterivSGIX((UInt32)list, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetListParameterivSGIX(UInt32 list, int pname, [Out] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetListParameterivSGIX((UInt32)list, (int)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetListParameterivSGIX(Int32 list, int pname, [Out] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetListParameterivSGIX((UInt32)list, (int)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetListParameterivSGIX(UInt32 list, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetListParameterivSGIX((UInt32)list, (int)pname, (Int32*)@params);
            }
        }

        public static 
        void glGetListParameterivSGIX(Int32 list, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetListParameterivSGIX((UInt32)list, (int)pname, (Int32*)@params);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glListParameterfSGIX(UInt32 list, int pname, Single param)
        {
            Delegates.glListParameterfSGIX((UInt32)list, (int)pname, (Single)param);
        }

        public static 
        void glListParameterfSGIX(Int32 list, int pname, Single param)
        {
            Delegates.glListParameterfSGIX((UInt32)list, (int)pname, (Single)param);
        }

        [System.CLSCompliant(false)]
        public static 
        void glListParameterfvSGIX(UInt32 list, int pname, Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glListParameterfvSGIX((UInt32)list, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glListParameterfvSGIX(Int32 list, int pname, Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glListParameterfvSGIX((UInt32)list, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glListParameterfvSGIX(UInt32 list, int pname, ref Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glListParameterfvSGIX((UInt32)list, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glListParameterfvSGIX(Int32 list, int pname, ref Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glListParameterfvSGIX((UInt32)list, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glListParameterfvSGIX(UInt32 list, int pname, IntPtr @params)
        {
            unsafe
            {
                Delegates.glListParameterfvSGIX((UInt32)list, (int)pname, (Single*)@params);
            }
        }

        public static 
        void glListParameterfvSGIX(Int32 list, int pname, IntPtr @params)
        {
            unsafe
            {
                Delegates.glListParameterfvSGIX((UInt32)list, (int)pname, (Single*)@params);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glListParameteriSGIX(UInt32 list, int pname, Int32 param)
        {
            Delegates.glListParameteriSGIX((UInt32)list, (int)pname, (Int32)param);
        }

        public static 
        void glListParameteriSGIX(Int32 list, int pname, Int32 param)
        {
            Delegates.glListParameteriSGIX((UInt32)list, (int)pname, (Int32)param);
        }

        [System.CLSCompliant(false)]
        public static 
        void glListParameterivSGIX(UInt32 list, int pname, Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glListParameterivSGIX((UInt32)list, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glListParameterivSGIX(Int32 list, int pname, Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glListParameterivSGIX((UInt32)list, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glListParameterivSGIX(UInt32 list, int pname, ref Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glListParameterivSGIX((UInt32)list, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glListParameterivSGIX(Int32 list, int pname, ref Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glListParameterivSGIX((UInt32)list, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glListParameterivSGIX(UInt32 list, int pname, IntPtr @params)
        {
            unsafe
            {
                Delegates.glListParameterivSGIX((UInt32)list, (int)pname, (Int32*)@params);
            }
        }

        public static 
        void glListParameterivSGIX(Int32 list, int pname, IntPtr @params)
        {
            unsafe
            {
                Delegates.glListParameterivSGIX((UInt32)list, (int)pname, (Int32*)@params);
            }
        }

        public static 
        void glFragmentColorMaterialSGIX(int face, int mode)
        {
            Delegates.glFragmentColorMaterialSGIX((int)face, (int)mode);
        }

        public static 
        void glFragmentLightfSGIX(int light, int pname, Single param)
        {
            Delegates.glFragmentLightfSGIX((int)light, (int)pname, (Single)param);
        }

        public static 
        void glFragmentLightfvSGIX(int light, int pname, Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glFragmentLightfvSGIX((int)light, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glFragmentLightfvSGIX(int light, int pname, ref Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glFragmentLightfvSGIX((int)light, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glFragmentLightfvSGIX(int light, int pname, IntPtr @params)
        {
            unsafe
            {
                Delegates.glFragmentLightfvSGIX((int)light, (int)pname, (Single*)@params);
            }
        }

        public static 
        void glFragmentLightiSGIX(int light, int pname, Int32 param)
        {
            Delegates.glFragmentLightiSGIX((int)light, (int)pname, (Int32)param);
        }

        public static 
        void glFragmentLightivSGIX(int light, int pname, Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glFragmentLightivSGIX((int)light, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glFragmentLightivSGIX(int light, int pname, ref Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glFragmentLightivSGIX((int)light, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glFragmentLightivSGIX(int light, int pname, IntPtr @params)
        {
            unsafe
            {
                Delegates.glFragmentLightivSGIX((int)light, (int)pname, (Int32*)@params);
            }
        }

        public static 
        void glFragmentLightModelfSGIX(int pname, Single param)
        {
            Delegates.glFragmentLightModelfSGIX((int)pname, (Single)param);
        }

        public static 
        void glFragmentLightModelfvSGIX(int pname, Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glFragmentLightModelfvSGIX((int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glFragmentLightModelfvSGIX(int pname, ref Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glFragmentLightModelfvSGIX((int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glFragmentLightModelfvSGIX(int pname, IntPtr @params)
        {
            unsafe
            {
                Delegates.glFragmentLightModelfvSGIX((int)pname, (Single*)@params);
            }
        }

        public static 
        void glFragmentLightModeliSGIX(int pname, Int32 param)
        {
            Delegates.glFragmentLightModeliSGIX((int)pname, (Int32)param);
        }

        public static 
        void glFragmentLightModelivSGIX(int pname, Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glFragmentLightModelivSGIX((int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glFragmentLightModelivSGIX(int pname, ref Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glFragmentLightModelivSGIX((int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glFragmentLightModelivSGIX(int pname, IntPtr @params)
        {
            unsafe
            {
                Delegates.glFragmentLightModelivSGIX((int)pname, (Int32*)@params);
            }
        }

        public static 
        void glFragmentMaterialfSGIX(int face, int pname, Single param)
        {
            Delegates.glFragmentMaterialfSGIX((int)face, (int)pname, (Single)param);
        }

        public static 
        void glFragmentMaterialfvSGIX(int face, int pname, Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glFragmentMaterialfvSGIX((int)face, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glFragmentMaterialfvSGIX(int face, int pname, ref Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glFragmentMaterialfvSGIX((int)face, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glFragmentMaterialfvSGIX(int face, int pname, IntPtr @params)
        {
            unsafe
            {
                Delegates.glFragmentMaterialfvSGIX((int)face, (int)pname, (Single*)@params);
            }
        }

        public static 
        void glFragmentMaterialiSGIX(int face, int pname, Int32 param)
        {
            Delegates.glFragmentMaterialiSGIX((int)face, (int)pname, (Int32)param);
        }

        public static 
        void glFragmentMaterialivSGIX(int face, int pname, Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glFragmentMaterialivSGIX((int)face, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glFragmentMaterialivSGIX(int face, int pname, ref Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glFragmentMaterialivSGIX((int)face, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glFragmentMaterialivSGIX(int face, int pname, IntPtr @params)
        {
            unsafe
            {
                Delegates.glFragmentMaterialivSGIX((int)face, (int)pname, (Int32*)@params);
            }
        }

        public static 
        void glGetFragmentLightfvSGIX(int light, int pname, [Out] Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glGetFragmentLightfvSGIX((int)light, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glGetFragmentLightfvSGIX(int light, int pname, [Out] out Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glGetFragmentLightfvSGIX((int)light, (int)pname, (Single*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetFragmentLightfvSGIX(int light, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetFragmentLightfvSGIX((int)light, (int)pname, (Single*)@params);
            }
        }

        public static 
        void glGetFragmentLightivSGIX(int light, int pname, [Out] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetFragmentLightivSGIX((int)light, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glGetFragmentLightivSGIX(int light, int pname, [Out] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetFragmentLightivSGIX((int)light, (int)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetFragmentLightivSGIX(int light, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetFragmentLightivSGIX((int)light, (int)pname, (Int32*)@params);
            }
        }

        public static 
        void glGetFragmentMaterialfvSGIX(int face, int pname, [Out] Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glGetFragmentMaterialfvSGIX((int)face, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glGetFragmentMaterialfvSGIX(int face, int pname, [Out] out Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glGetFragmentMaterialfvSGIX((int)face, (int)pname, (Single*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetFragmentMaterialfvSGIX(int face, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetFragmentMaterialfvSGIX((int)face, (int)pname, (Single*)@params);
            }
        }

        public static 
        void glGetFragmentMaterialivSGIX(int face, int pname, [Out] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetFragmentMaterialivSGIX((int)face, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glGetFragmentMaterialivSGIX(int face, int pname, [Out] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetFragmentMaterialivSGIX((int)face, (int)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetFragmentMaterialivSGIX(int face, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetFragmentMaterialivSGIX((int)face, (int)pname, (Int32*)@params);
            }
        }

        public static 
        void glLightEnviSGIX(int pname, Int32 param)
        {
            Delegates.glLightEnviSGIX((int)pname, (Int32)param);
        }

        [System.CLSCompliant(false)]
        public static 
        void glAsyncMarkerSGIX(UInt32 marker)
        {
            Delegates.glAsyncMarkerSGIX((UInt32)marker);
        }

        public static 
        void glAsyncMarkerSGIX(Int32 marker)
        {
            Delegates.glAsyncMarkerSGIX((UInt32)marker);
        }

        [System.CLSCompliant(false)]
        public static 
        Int32 glFinishAsyncSGIX([Out] UInt32[] markerp)
        {
            unsafe
            {
                fixed (UInt32* markerp_ptr = markerp)
                {
                    return Delegates.glFinishAsyncSGIX((UInt32*)markerp_ptr);
                }
            }
        }

        public static 
        Int32 glFinishAsyncSGIX([Out] Int32[] markerp)
        {
            unsafe
            {
                fixed (Int32* markerp_ptr = markerp)
                {
                    return Delegates.glFinishAsyncSGIX((UInt32*)markerp_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        Int32 glFinishAsyncSGIX([Out] out UInt32 markerp)
        {
            unsafe
            {
                fixed (UInt32* markerp_ptr = &markerp)
                {
                    Int32 retval = Delegates.glFinishAsyncSGIX((UInt32*)markerp_ptr);
                    markerp = *markerp_ptr;
                    return retval;
                }
            }
        }

        public static 
        Int32 glFinishAsyncSGIX([Out] out Int32 markerp)
        {
            unsafe
            {
                fixed (Int32* markerp_ptr = &markerp)
                {
                    Int32 retval = Delegates.glFinishAsyncSGIX((UInt32*)markerp_ptr);
                    markerp = *markerp_ptr;
                    return retval;
                }
            }
        }

        public static 
        Int32 glFinishAsyncSGIX([Out] IntPtr markerp)
        {
            unsafe
            {
                return Delegates.glFinishAsyncSGIX((UInt32*)markerp);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        Int32 glPollAsyncSGIX([Out] UInt32[] markerp)
        {
            unsafe
            {
                fixed (UInt32* markerp_ptr = markerp)
                {
                    return Delegates.glPollAsyncSGIX((UInt32*)markerp_ptr);
                }
            }
        }

        public static 
        Int32 glPollAsyncSGIX([Out] Int32[] markerp)
        {
            unsafe
            {
                fixed (Int32* markerp_ptr = markerp)
                {
                    return Delegates.glPollAsyncSGIX((UInt32*)markerp_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        Int32 glPollAsyncSGIX([Out] out UInt32 markerp)
        {
            unsafe
            {
                fixed (UInt32* markerp_ptr = &markerp)
                {
                    Int32 retval = Delegates.glPollAsyncSGIX((UInt32*)markerp_ptr);
                    markerp = *markerp_ptr;
                    return retval;
                }
            }
        }

        public static 
        Int32 glPollAsyncSGIX([Out] out Int32 markerp)
        {
            unsafe
            {
                fixed (Int32* markerp_ptr = &markerp)
                {
                    Int32 retval = Delegates.glPollAsyncSGIX((UInt32*)markerp_ptr);
                    markerp = *markerp_ptr;
                    return retval;
                }
            }
        }

        public static 
        Int32 glPollAsyncSGIX([Out] IntPtr markerp)
        {
            unsafe
            {
                return Delegates.glPollAsyncSGIX((UInt32*)markerp);
            }
        }

        public static 
        Int32 glGenAsyncMarkersSGIX(Int32 range)
        {
            return Delegates.glGenAsyncMarkersSGIX((Int32)range);
        }

        [System.CLSCompliant(false)]
        public static 
        void glDeleteAsyncMarkersSGIX(UInt32 marker, Int32 range)
        {
            Delegates.glDeleteAsyncMarkersSGIX((UInt32)marker, (Int32)range);
        }

        public static 
        void glDeleteAsyncMarkersSGIX(Int32 marker, Int32 range)
        {
            Delegates.glDeleteAsyncMarkersSGIX((UInt32)marker, (Int32)range);
        }

        [System.CLSCompliant(false)]
        public static 
        bool glIsAsyncMarkerSGIX(UInt32 marker)
        {
            return Delegates.glIsAsyncMarkerSGIX((UInt32)marker);
        }

        public static 
        bool glIsAsyncMarkerSGIX(Int32 marker)
        {
            return Delegates.glIsAsyncMarkerSGIX((UInt32)marker);
        }

        public static 
        void glIglooInterfaceSGIX(int pname, IntPtr @params)
        {
            unsafe
            {
                Delegates.glIglooInterfaceSGIX((int)pname, (IntPtr)@params);
            }
        }

        public static 
        void glIglooInterfaceSGIX(int pname, [In, Out] object @params)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle @params_ptr = System.Runtime.InteropServices.GCHandle.Alloc(@params, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glIglooInterfaceSGIX((int)pname, (IntPtr)@params_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    @params_ptr.Free();
                }
            }
        }

        public static 
        void glImageTransformParameteriHP(int target, int pname, Int32 param)
        {
            Delegates.glImageTransformParameteriHP((int)target, (int)pname, (Int32)param);
        }

        public static 
        void glImageTransformParameterfHP(int target, int pname, Single param)
        {
            Delegates.glImageTransformParameterfHP((int)target, (int)pname, (Single)param);
        }

        public static 
        void glImageTransformParameterivHP(int target, int pname, Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glImageTransformParameterivHP((int)target, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glImageTransformParameterivHP(int target, int pname, ref Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glImageTransformParameterivHP((int)target, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glImageTransformParameterivHP(int target, int pname, IntPtr @params)
        {
            unsafe
            {
                Delegates.glImageTransformParameterivHP((int)target, (int)pname, (Int32*)@params);
            }
        }

        public static 
        void glImageTransformParameterfvHP(int target, int pname, Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glImageTransformParameterfvHP((int)target, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glImageTransformParameterfvHP(int target, int pname, ref Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glImageTransformParameterfvHP((int)target, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glImageTransformParameterfvHP(int target, int pname, IntPtr @params)
        {
            unsafe
            {
                Delegates.glImageTransformParameterfvHP((int)target, (int)pname, (Single*)@params);
            }
        }

        public static 
        void glGetImageTransformParameterivHP(int target, int pname, [Out] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetImageTransformParameterivHP((int)target, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glGetImageTransformParameterivHP(int target, int pname, [Out] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetImageTransformParameterivHP((int)target, (int)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetImageTransformParameterivHP(int target, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetImageTransformParameterivHP((int)target, (int)pname, (Int32*)@params);
            }
        }

        public static 
        void glGetImageTransformParameterfvHP(int target, int pname, [Out] Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glGetImageTransformParameterfvHP((int)target, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glGetImageTransformParameterfvHP(int target, int pname, [Out] out Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glGetImageTransformParameterfvHP((int)target, (int)pname, (Single*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetImageTransformParameterfvHP(int target, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetImageTransformParameterfvHP((int)target, (int)pname, (Single*)@params);
            }
        }

        public static 
        void glHintPGI(int target, Int32 mode)
        {
            Delegates.glHintPGI((int)target, (Int32)mode);
        }

        public static 
        void glVertexPointervINTEL(Int32 size, int type, IntPtr pointer)
        {
            unsafe
            {
                Delegates.glVertexPointervINTEL((Int32)size, (int)type, (IntPtr)pointer);
            }
        }

        public static 
        void glVertexPointervINTEL(Int32 size, int type, [In, Out] object pointer)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle pointer_ptr = System.Runtime.InteropServices.GCHandle.Alloc(pointer, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glVertexPointervINTEL((Int32)size, (int)type, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
            }
        }

        public static 
        void glNormalPointervINTEL(int type, IntPtr pointer)
        {
            unsafe
            {
                Delegates.glNormalPointervINTEL((int)type, (IntPtr)pointer);
            }
        }

        public static 
        void glNormalPointervINTEL(int type, [In, Out] object pointer)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle pointer_ptr = System.Runtime.InteropServices.GCHandle.Alloc(pointer, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glNormalPointervINTEL((int)type, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
            }
        }

        public static 
        void glColorPointervINTEL(Int32 size, int type, IntPtr pointer)
        {
            unsafe
            {
                Delegates.glColorPointervINTEL((Int32)size, (int)type, (IntPtr)pointer);
            }
        }

        public static 
        void glColorPointervINTEL(Int32 size, int type, [In, Out] object pointer)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle pointer_ptr = System.Runtime.InteropServices.GCHandle.Alloc(pointer, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glColorPointervINTEL((Int32)size, (int)type, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
            }
        }

        public static 
        void glTexCoordPointervINTEL(Int32 size, int type, IntPtr pointer)
        {
            unsafe
            {
                Delegates.glTexCoordPointervINTEL((Int32)size, (int)type, (IntPtr)pointer);
            }
        }

        public static 
        void glTexCoordPointervINTEL(Int32 size, int type, [In, Out] object pointer)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle pointer_ptr = System.Runtime.InteropServices.GCHandle.Alloc(pointer, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glTexCoordPointervINTEL((Int32)size, (int)type, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
            }
        }

        public static 
        void glFinishTextureSUNX()
        {
            Delegates.glFinishTextureSUNX();
        }

        [System.CLSCompliant(false)]
        public static 
        void glGlobalAlphaFactorbSUN(SByte factor)
        {
            Delegates.glGlobalAlphaFactorbSUN((SByte)factor);
        }

        public static 
        void glGlobalAlphaFactorbSUN(Byte factor)
        {
            Delegates.glGlobalAlphaFactorbSUN((SByte)factor);
        }

        public static 
        void glGlobalAlphaFactorsSUN(Int16 factor)
        {
            Delegates.glGlobalAlphaFactorsSUN((Int16)factor);
        }

        public static 
        void glGlobalAlphaFactoriSUN(Int32 factor)
        {
            Delegates.glGlobalAlphaFactoriSUN((Int32)factor);
        }

        public static 
        void glGlobalAlphaFactorfSUN(Single factor)
        {
            Delegates.glGlobalAlphaFactorfSUN((Single)factor);
        }

        public static 
        void glGlobalAlphaFactordSUN(Double factor)
        {
            Delegates.glGlobalAlphaFactordSUN((Double)factor);
        }

        public static 
        void glGlobalAlphaFactorubSUN(Byte factor)
        {
            Delegates.glGlobalAlphaFactorubSUN((Byte)factor);
        }

        [System.CLSCompliant(false)]
        public static 
        void glGlobalAlphaFactorusSUN(UInt16 factor)
        {
            Delegates.glGlobalAlphaFactorusSUN((UInt16)factor);
        }

        public static 
        void glGlobalAlphaFactorusSUN(Int16 factor)
        {
            Delegates.glGlobalAlphaFactorusSUN((UInt16)factor);
        }

        [System.CLSCompliant(false)]
        public static 
        void glGlobalAlphaFactoruiSUN(UInt32 factor)
        {
            Delegates.glGlobalAlphaFactoruiSUN((UInt32)factor);
        }

        public static 
        void glGlobalAlphaFactoruiSUN(Int32 factor)
        {
            Delegates.glGlobalAlphaFactoruiSUN((UInt32)factor);
        }

        [System.CLSCompliant(false)]
        public static 
        void glReplacementCodeuiSUN(UInt32 code)
        {
            Delegates.glReplacementCodeuiSUN((UInt32)code);
        }

        public static 
        void glReplacementCodeuiSUN(Int32 code)
        {
            Delegates.glReplacementCodeuiSUN((UInt32)code);
        }

        [System.CLSCompliant(false)]
        public static 
        void glReplacementCodeusSUN(UInt16 code)
        {
            Delegates.glReplacementCodeusSUN((UInt16)code);
        }

        public static 
        void glReplacementCodeusSUN(Int16 code)
        {
            Delegates.glReplacementCodeusSUN((UInt16)code);
        }

        public static 
        void glReplacementCodeubSUN(Byte code)
        {
            Delegates.glReplacementCodeubSUN((Byte)code);
        }

        [System.CLSCompliant(false)]
        public static 
        void glReplacementCodeuivSUN(UInt32[] code)
        {
            unsafe
            {
                fixed (UInt32* code_ptr = code)
                {
                    Delegates.glReplacementCodeuivSUN((UInt32*)code_ptr);
                }
            }
        }

        public static 
        void glReplacementCodeuivSUN(Int32[] code)
        {
            unsafe
            {
                fixed (Int32* code_ptr = code)
                {
                    Delegates.glReplacementCodeuivSUN((UInt32*)code_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glReplacementCodeuivSUN(ref UInt32 code)
        {
            unsafe
            {
                fixed (UInt32* code_ptr = &code)
                {
                    Delegates.glReplacementCodeuivSUN((UInt32*)code_ptr);
                }
            }
        }

        public static 
        void glReplacementCodeuivSUN(ref Int32 code)
        {
            unsafe
            {
                fixed (Int32* code_ptr = &code)
                {
                    Delegates.glReplacementCodeuivSUN((UInt32*)code_ptr);
                }
            }
        }

        public static 
        void glReplacementCodeuivSUN(IntPtr code)
        {
            unsafe
            {
                Delegates.glReplacementCodeuivSUN((UInt32*)code);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glReplacementCodeusvSUN(UInt16[] code)
        {
            unsafe
            {
                fixed (UInt16* code_ptr = code)
                {
                    Delegates.glReplacementCodeusvSUN((UInt16*)code_ptr);
                }
            }
        }

        public static 
        void glReplacementCodeusvSUN(Int16[] code)
        {
            unsafe
            {
                fixed (Int16* code_ptr = code)
                {
                    Delegates.glReplacementCodeusvSUN((UInt16*)code_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glReplacementCodeusvSUN(ref UInt16 code)
        {
            unsafe
            {
                fixed (UInt16* code_ptr = &code)
                {
                    Delegates.glReplacementCodeusvSUN((UInt16*)code_ptr);
                }
            }
        }

        public static 
        void glReplacementCodeusvSUN(ref Int16 code)
        {
            unsafe
            {
                fixed (Int16* code_ptr = &code)
                {
                    Delegates.glReplacementCodeusvSUN((UInt16*)code_ptr);
                }
            }
        }

        public static 
        void glReplacementCodeusvSUN(IntPtr code)
        {
            unsafe
            {
                Delegates.glReplacementCodeusvSUN((UInt16*)code);
            }
        }

        public static 
        void glReplacementCodeubvSUN(Byte[] code)
        {
            unsafe
            {
                fixed (Byte* code_ptr = code)
                {
                    Delegates.glReplacementCodeubvSUN((Byte*)code_ptr);
                }
            }
        }

        public static 
        void glReplacementCodeubvSUN(ref Byte code)
        {
            unsafe
            {
                fixed (Byte* code_ptr = &code)
                {
                    Delegates.glReplacementCodeubvSUN((Byte*)code_ptr);
                }
            }
        }

        public static 
        void glReplacementCodeubvSUN(IntPtr code)
        {
            unsafe
            {
                Delegates.glReplacementCodeubvSUN((Byte*)code);
            }
        }

        public static 
        void glReplacementCodePointerSUN(int type, Int32 stride, IntPtr pointer)
        {
            unsafe
            {
                Delegates.glReplacementCodePointerSUN((int)type, (Int32)stride, (IntPtr)pointer);
            }
        }

        public static 
        void glReplacementCodePointerSUN(int type, Int32 stride, [In, Out] object pointer)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle pointer_ptr = System.Runtime.InteropServices.GCHandle.Alloc(pointer, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glReplacementCodePointerSUN((int)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
            }
        }

        public static 
        void glColor4ubVertex2fSUN(Byte r, Byte g, Byte b, Byte a, Single x, Single y)
        {
            Delegates.glColor4ubVertex2fSUN((Byte)r, (Byte)g, (Byte)b, (Byte)a, (Single)x, (Single)y);
        }

        public static 
        void glColor4ubVertex2fvSUN(Byte[] c, Single[] v)
        {
            unsafe
            {
                fixed (Byte* c_ptr = c)
                fixed (Single* v_ptr = v)
                {
                    Delegates.glColor4ubVertex2fvSUN((Byte*)c_ptr, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glColor4ubVertex2fvSUN(ref Byte c, ref Single v)
        {
            unsafe
            {
                fixed (Byte* c_ptr = &c)
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glColor4ubVertex2fvSUN((Byte*)c_ptr, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glColor4ubVertex2fvSUN(IntPtr c, IntPtr v)
        {
            unsafe
            {
                Delegates.glColor4ubVertex2fvSUN((Byte*)c, (Single*)v);
            }
        }

        public static 
        void glColor4ubVertex3fSUN(Byte r, Byte g, Byte b, Byte a, Single x, Single y, Single z)
        {
            Delegates.glColor4ubVertex3fSUN((Byte)r, (Byte)g, (Byte)b, (Byte)a, (Single)x, (Single)y, (Single)z);
        }

        public static 
        void glColor4ubVertex3fvSUN(Byte[] c, Single[] v)
        {
            unsafe
            {
                fixed (Byte* c_ptr = c)
                fixed (Single* v_ptr = v)
                {
                    Delegates.glColor4ubVertex3fvSUN((Byte*)c_ptr, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glColor4ubVertex3fvSUN(ref Byte c, ref Single v)
        {
            unsafe
            {
                fixed (Byte* c_ptr = &c)
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glColor4ubVertex3fvSUN((Byte*)c_ptr, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glColor4ubVertex3fvSUN(IntPtr c, IntPtr v)
        {
            unsafe
            {
                Delegates.glColor4ubVertex3fvSUN((Byte*)c, (Single*)v);
            }
        }

        public static 
        void glColor3fVertex3fSUN(Single r, Single g, Single b, Single x, Single y, Single z)
        {
            Delegates.glColor3fVertex3fSUN((Single)r, (Single)g, (Single)b, (Single)x, (Single)y, (Single)z);
        }

        public static 
        void glColor3fVertex3fvSUN(Single[] c, Single[] v)
        {
            unsafe
            {
                fixed (Single* c_ptr = c)
                fixed (Single* v_ptr = v)
                {
                    Delegates.glColor3fVertex3fvSUN((Single*)c_ptr, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glColor3fVertex3fvSUN(ref Single c, ref Single v)
        {
            unsafe
            {
                fixed (Single* c_ptr = &c)
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glColor3fVertex3fvSUN((Single*)c_ptr, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glColor3fVertex3fvSUN(IntPtr c, IntPtr v)
        {
            unsafe
            {
                Delegates.glColor3fVertex3fvSUN((Single*)c, (Single*)v);
            }
        }

        public static 
        void glNormal3fVertex3fSUN(Single nx, Single ny, Single nz, Single x, Single y, Single z)
        {
            Delegates.glNormal3fVertex3fSUN((Single)nx, (Single)ny, (Single)nz, (Single)x, (Single)y, (Single)z);
        }

        public static 
        void glNormal3fVertex3fvSUN(Single[] n, Single[] v)
        {
            unsafe
            {
                fixed (Single* n_ptr = n)
                fixed (Single* v_ptr = v)
                {
                    Delegates.glNormal3fVertex3fvSUN((Single*)n_ptr, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glNormal3fVertex3fvSUN(ref Single n, ref Single v)
        {
            unsafe
            {
                fixed (Single* n_ptr = &n)
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glNormal3fVertex3fvSUN((Single*)n_ptr, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glNormal3fVertex3fvSUN(IntPtr n, IntPtr v)
        {
            unsafe
            {
                Delegates.glNormal3fVertex3fvSUN((Single*)n, (Single*)v);
            }
        }

        public static 
        void glColor4fNormal3fVertex3fSUN(Single r, Single g, Single b, Single a, Single nx, Single ny, Single nz, Single x, Single y, Single z)
        {
            Delegates.glColor4fNormal3fVertex3fSUN((Single)r, (Single)g, (Single)b, (Single)a, (Single)nx, (Single)ny, (Single)nz, (Single)x, (Single)y, (Single)z);
        }

        public static 
        void glColor4fNormal3fVertex3fvSUN(Single[] c, Single[] n, Single[] v)
        {
            unsafe
            {
                fixed (Single* c_ptr = c)
                fixed (Single* n_ptr = n)
                fixed (Single* v_ptr = v)
                {
                    Delegates.glColor4fNormal3fVertex3fvSUN((Single*)c_ptr, (Single*)n_ptr, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glColor4fNormal3fVertex3fvSUN(ref Single c, ref Single n, ref Single v)
        {
            unsafe
            {
                fixed (Single* c_ptr = &c)
                fixed (Single* n_ptr = &n)
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glColor4fNormal3fVertex3fvSUN((Single*)c_ptr, (Single*)n_ptr, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glColor4fNormal3fVertex3fvSUN(IntPtr c, IntPtr n, IntPtr v)
        {
            unsafe
            {
                Delegates.glColor4fNormal3fVertex3fvSUN((Single*)c, (Single*)n, (Single*)v);
            }
        }

        public static 
        void glTexCoord2fVertex3fSUN(Single s, Single t, Single x, Single y, Single z)
        {
            Delegates.glTexCoord2fVertex3fSUN((Single)s, (Single)t, (Single)x, (Single)y, (Single)z);
        }

        public static 
        void glTexCoord2fVertex3fvSUN(Single[] tc, Single[] v)
        {
            unsafe
            {
                fixed (Single* tc_ptr = tc)
                fixed (Single* v_ptr = v)
                {
                    Delegates.glTexCoord2fVertex3fvSUN((Single*)tc_ptr, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glTexCoord2fVertex3fvSUN(ref Single tc, ref Single v)
        {
            unsafe
            {
                fixed (Single* tc_ptr = &tc)
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glTexCoord2fVertex3fvSUN((Single*)tc_ptr, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glTexCoord2fVertex3fvSUN(IntPtr tc, IntPtr v)
        {
            unsafe
            {
                Delegates.glTexCoord2fVertex3fvSUN((Single*)tc, (Single*)v);
            }
        }

        public static 
        void glTexCoord4fVertex4fSUN(Single s, Single t, Single p, Single q, Single x, Single y, Single z, Single w)
        {
            Delegates.glTexCoord4fVertex4fSUN((Single)s, (Single)t, (Single)p, (Single)q, (Single)x, (Single)y, (Single)z, (Single)w);
        }

        public static 
        void glTexCoord4fVertex4fvSUN(Single[] tc, Single[] v)
        {
            unsafe
            {
                fixed (Single* tc_ptr = tc)
                fixed (Single* v_ptr = v)
                {
                    Delegates.glTexCoord4fVertex4fvSUN((Single*)tc_ptr, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glTexCoord4fVertex4fvSUN(ref Single tc, ref Single v)
        {
            unsafe
            {
                fixed (Single* tc_ptr = &tc)
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glTexCoord4fVertex4fvSUN((Single*)tc_ptr, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glTexCoord4fVertex4fvSUN(IntPtr tc, IntPtr v)
        {
            unsafe
            {
                Delegates.glTexCoord4fVertex4fvSUN((Single*)tc, (Single*)v);
            }
        }

        public static 
        void glTexCoord2fColor4ubVertex3fSUN(Single s, Single t, Byte r, Byte g, Byte b, Byte a, Single x, Single y, Single z)
        {
            Delegates.glTexCoord2fColor4ubVertex3fSUN((Single)s, (Single)t, (Byte)r, (Byte)g, (Byte)b, (Byte)a, (Single)x, (Single)y, (Single)z);
        }

        public static 
        void glTexCoord2fColor4ubVertex3fvSUN(Single[] tc, Byte[] c, Single[] v)
        {
            unsafe
            {
                fixed (Single* tc_ptr = tc)
                fixed (Byte* c_ptr = c)
                fixed (Single* v_ptr = v)
                {
                    Delegates.glTexCoord2fColor4ubVertex3fvSUN((Single*)tc_ptr, (Byte*)c_ptr, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glTexCoord2fColor4ubVertex3fvSUN(ref Single tc, ref Byte c, ref Single v)
        {
            unsafe
            {
                fixed (Single* tc_ptr = &tc)
                fixed (Byte* c_ptr = &c)
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glTexCoord2fColor4ubVertex3fvSUN((Single*)tc_ptr, (Byte*)c_ptr, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glTexCoord2fColor4ubVertex3fvSUN(IntPtr tc, IntPtr c, IntPtr v)
        {
            unsafe
            {
                Delegates.glTexCoord2fColor4ubVertex3fvSUN((Single*)tc, (Byte*)c, (Single*)v);
            }
        }

        public static 
        void glTexCoord2fColor3fVertex3fSUN(Single s, Single t, Single r, Single g, Single b, Single x, Single y, Single z)
        {
            Delegates.glTexCoord2fColor3fVertex3fSUN((Single)s, (Single)t, (Single)r, (Single)g, (Single)b, (Single)x, (Single)y, (Single)z);
        }

        public static 
        void glTexCoord2fColor3fVertex3fvSUN(Single[] tc, Single[] c, Single[] v)
        {
            unsafe
            {
                fixed (Single* tc_ptr = tc)
                fixed (Single* c_ptr = c)
                fixed (Single* v_ptr = v)
                {
                    Delegates.glTexCoord2fColor3fVertex3fvSUN((Single*)tc_ptr, (Single*)c_ptr, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glTexCoord2fColor3fVertex3fvSUN(ref Single tc, ref Single c, ref Single v)
        {
            unsafe
            {
                fixed (Single* tc_ptr = &tc)
                fixed (Single* c_ptr = &c)
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glTexCoord2fColor3fVertex3fvSUN((Single*)tc_ptr, (Single*)c_ptr, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glTexCoord2fColor3fVertex3fvSUN(IntPtr tc, IntPtr c, IntPtr v)
        {
            unsafe
            {
                Delegates.glTexCoord2fColor3fVertex3fvSUN((Single*)tc, (Single*)c, (Single*)v);
            }
        }

        public static 
        void glTexCoord2fNormal3fVertex3fSUN(Single s, Single t, Single nx, Single ny, Single nz, Single x, Single y, Single z)
        {
            Delegates.glTexCoord2fNormal3fVertex3fSUN((Single)s, (Single)t, (Single)nx, (Single)ny, (Single)nz, (Single)x, (Single)y, (Single)z);
        }

        public static 
        void glTexCoord2fNormal3fVertex3fvSUN(Single[] tc, Single[] n, Single[] v)
        {
            unsafe
            {
                fixed (Single* tc_ptr = tc)
                fixed (Single* n_ptr = n)
                fixed (Single* v_ptr = v)
                {
                    Delegates.glTexCoord2fNormal3fVertex3fvSUN((Single*)tc_ptr, (Single*)n_ptr, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glTexCoord2fNormal3fVertex3fvSUN(ref Single tc, ref Single n, ref Single v)
        {
            unsafe
            {
                fixed (Single* tc_ptr = &tc)
                fixed (Single* n_ptr = &n)
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glTexCoord2fNormal3fVertex3fvSUN((Single*)tc_ptr, (Single*)n_ptr, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glTexCoord2fNormal3fVertex3fvSUN(IntPtr tc, IntPtr n, IntPtr v)
        {
            unsafe
            {
                Delegates.glTexCoord2fNormal3fVertex3fvSUN((Single*)tc, (Single*)n, (Single*)v);
            }
        }

        public static 
        void glTexCoord2fColor4fNormal3fVertex3fSUN(Single s, Single t, Single r, Single g, Single b, Single a, Single nx, Single ny, Single nz, Single x, Single y, Single z)
        {
            Delegates.glTexCoord2fColor4fNormal3fVertex3fSUN((Single)s, (Single)t, (Single)r, (Single)g, (Single)b, (Single)a, (Single)nx, (Single)ny, (Single)nz, (Single)x, (Single)y, (Single)z);
        }

        public static 
        void glTexCoord2fColor4fNormal3fVertex3fvSUN(Single[] tc, Single[] c, Single[] n, Single[] v)
        {
            unsafe
            {
                fixed (Single* tc_ptr = tc)
                fixed (Single* c_ptr = c)
                fixed (Single* n_ptr = n)
                fixed (Single* v_ptr = v)
                {
                    Delegates.glTexCoord2fColor4fNormal3fVertex3fvSUN((Single*)tc_ptr, (Single*)c_ptr, (Single*)n_ptr, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glTexCoord2fColor4fNormal3fVertex3fvSUN(ref Single tc, ref Single c, ref Single n, ref Single v)
        {
            unsafe
            {
                fixed (Single* tc_ptr = &tc)
                fixed (Single* c_ptr = &c)
                fixed (Single* n_ptr = &n)
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glTexCoord2fColor4fNormal3fVertex3fvSUN((Single*)tc_ptr, (Single*)c_ptr, (Single*)n_ptr, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glTexCoord2fColor4fNormal3fVertex3fvSUN(IntPtr tc, IntPtr c, IntPtr n, IntPtr v)
        {
            unsafe
            {
                Delegates.glTexCoord2fColor4fNormal3fVertex3fvSUN((Single*)tc, (Single*)c, (Single*)n, (Single*)v);
            }
        }

        public static 
        void glTexCoord4fColor4fNormal3fVertex4fSUN(Single s, Single t, Single p, Single q, Single r, Single g, Single b, Single a, Single nx, Single ny, Single nz, Single x, Single y, Single z, Single w)
        {
            Delegates.glTexCoord4fColor4fNormal3fVertex4fSUN((Single)s, (Single)t, (Single)p, (Single)q, (Single)r, (Single)g, (Single)b, (Single)a, (Single)nx, (Single)ny, (Single)nz, (Single)x, (Single)y, (Single)z, (Single)w);
        }

        public static 
        void glTexCoord4fColor4fNormal3fVertex4fvSUN(Single[] tc, Single[] c, Single[] n, Single[] v)
        {
            unsafe
            {
                fixed (Single* tc_ptr = tc)
                fixed (Single* c_ptr = c)
                fixed (Single* n_ptr = n)
                fixed (Single* v_ptr = v)
                {
                    Delegates.glTexCoord4fColor4fNormal3fVertex4fvSUN((Single*)tc_ptr, (Single*)c_ptr, (Single*)n_ptr, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glTexCoord4fColor4fNormal3fVertex4fvSUN(ref Single tc, ref Single c, ref Single n, ref Single v)
        {
            unsafe
            {
                fixed (Single* tc_ptr = &tc)
                fixed (Single* c_ptr = &c)
                fixed (Single* n_ptr = &n)
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glTexCoord4fColor4fNormal3fVertex4fvSUN((Single*)tc_ptr, (Single*)c_ptr, (Single*)n_ptr, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glTexCoord4fColor4fNormal3fVertex4fvSUN(IntPtr tc, IntPtr c, IntPtr n, IntPtr v)
        {
            unsafe
            {
                Delegates.glTexCoord4fColor4fNormal3fVertex4fvSUN((Single*)tc, (Single*)c, (Single*)n, (Single*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glReplacementCodeuiVertex3fSUN(UInt32 rc, Single x, Single y, Single z)
        {
            Delegates.glReplacementCodeuiVertex3fSUN((UInt32)rc, (Single)x, (Single)y, (Single)z);
        }

        public static 
        void glReplacementCodeuiVertex3fSUN(Int32 rc, Single x, Single y, Single z)
        {
            Delegates.glReplacementCodeuiVertex3fSUN((UInt32)rc, (Single)x, (Single)y, (Single)z);
        }

        [System.CLSCompliant(false)]
        public static 
        void glReplacementCodeuiVertex3fvSUN(UInt32[] rc, Single[] v)
        {
            unsafe
            {
                fixed (UInt32* rc_ptr = rc)
                fixed (Single* v_ptr = v)
                {
                    Delegates.glReplacementCodeuiVertex3fvSUN((UInt32*)rc_ptr, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glReplacementCodeuiVertex3fvSUN(Int32[] rc, Single[] v)
        {
            unsafe
            {
                fixed (Int32* rc_ptr = rc)
                fixed (Single* v_ptr = v)
                {
                    Delegates.glReplacementCodeuiVertex3fvSUN((UInt32*)rc_ptr, (Single*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glReplacementCodeuiVertex3fvSUN(ref UInt32 rc, ref Single v)
        {
            unsafe
            {
                fixed (UInt32* rc_ptr = &rc)
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glReplacementCodeuiVertex3fvSUN((UInt32*)rc_ptr, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glReplacementCodeuiVertex3fvSUN(ref Int32 rc, ref Single v)
        {
            unsafe
            {
                fixed (Int32* rc_ptr = &rc)
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glReplacementCodeuiVertex3fvSUN((UInt32*)rc_ptr, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glReplacementCodeuiVertex3fvSUN(IntPtr rc, IntPtr v)
        {
            unsafe
            {
                Delegates.glReplacementCodeuiVertex3fvSUN((UInt32*)rc, (Single*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glReplacementCodeuiColor4ubVertex3fSUN(UInt32 rc, Byte r, Byte g, Byte b, Byte a, Single x, Single y, Single z)
        {
            Delegates.glReplacementCodeuiColor4ubVertex3fSUN((UInt32)rc, (Byte)r, (Byte)g, (Byte)b, (Byte)a, (Single)x, (Single)y, (Single)z);
        }

        public static 
        void glReplacementCodeuiColor4ubVertex3fSUN(Int32 rc, Byte r, Byte g, Byte b, Byte a, Single x, Single y, Single z)
        {
            Delegates.glReplacementCodeuiColor4ubVertex3fSUN((UInt32)rc, (Byte)r, (Byte)g, (Byte)b, (Byte)a, (Single)x, (Single)y, (Single)z);
        }

        [System.CLSCompliant(false)]
        public static 
        void glReplacementCodeuiColor4ubVertex3fvSUN(UInt32[] rc, Byte[] c, Single[] v)
        {
            unsafe
            {
                fixed (UInt32* rc_ptr = rc)
                fixed (Byte* c_ptr = c)
                fixed (Single* v_ptr = v)
                {
                    Delegates.glReplacementCodeuiColor4ubVertex3fvSUN((UInt32*)rc_ptr, (Byte*)c_ptr, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glReplacementCodeuiColor4ubVertex3fvSUN(Int32[] rc, Byte[] c, Single[] v)
        {
            unsafe
            {
                fixed (Int32* rc_ptr = rc)
                fixed (Byte* c_ptr = c)
                fixed (Single* v_ptr = v)
                {
                    Delegates.glReplacementCodeuiColor4ubVertex3fvSUN((UInt32*)rc_ptr, (Byte*)c_ptr, (Single*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glReplacementCodeuiColor4ubVertex3fvSUN(ref UInt32 rc, ref Byte c, ref Single v)
        {
            unsafe
            {
                fixed (UInt32* rc_ptr = &rc)
                fixed (Byte* c_ptr = &c)
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glReplacementCodeuiColor4ubVertex3fvSUN((UInt32*)rc_ptr, (Byte*)c_ptr, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glReplacementCodeuiColor4ubVertex3fvSUN(ref Int32 rc, ref Byte c, ref Single v)
        {
            unsafe
            {
                fixed (Int32* rc_ptr = &rc)
                fixed (Byte* c_ptr = &c)
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glReplacementCodeuiColor4ubVertex3fvSUN((UInt32*)rc_ptr, (Byte*)c_ptr, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glReplacementCodeuiColor4ubVertex3fvSUN(IntPtr rc, IntPtr c, IntPtr v)
        {
            unsafe
            {
                Delegates.glReplacementCodeuiColor4ubVertex3fvSUN((UInt32*)rc, (Byte*)c, (Single*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glReplacementCodeuiColor3fVertex3fSUN(UInt32 rc, Single r, Single g, Single b, Single x, Single y, Single z)
        {
            Delegates.glReplacementCodeuiColor3fVertex3fSUN((UInt32)rc, (Single)r, (Single)g, (Single)b, (Single)x, (Single)y, (Single)z);
        }

        public static 
        void glReplacementCodeuiColor3fVertex3fSUN(Int32 rc, Single r, Single g, Single b, Single x, Single y, Single z)
        {
            Delegates.glReplacementCodeuiColor3fVertex3fSUN((UInt32)rc, (Single)r, (Single)g, (Single)b, (Single)x, (Single)y, (Single)z);
        }

        [System.CLSCompliant(false)]
        public static 
        void glReplacementCodeuiColor3fVertex3fvSUN(UInt32[] rc, Single[] c, Single[] v)
        {
            unsafe
            {
                fixed (UInt32* rc_ptr = rc)
                fixed (Single* c_ptr = c)
                fixed (Single* v_ptr = v)
                {
                    Delegates.glReplacementCodeuiColor3fVertex3fvSUN((UInt32*)rc_ptr, (Single*)c_ptr, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glReplacementCodeuiColor3fVertex3fvSUN(Int32[] rc, Single[] c, Single[] v)
        {
            unsafe
            {
                fixed (Int32* rc_ptr = rc)
                fixed (Single* c_ptr = c)
                fixed (Single* v_ptr = v)
                {
                    Delegates.glReplacementCodeuiColor3fVertex3fvSUN((UInt32*)rc_ptr, (Single*)c_ptr, (Single*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glReplacementCodeuiColor3fVertex3fvSUN(ref UInt32 rc, ref Single c, ref Single v)
        {
            unsafe
            {
                fixed (UInt32* rc_ptr = &rc)
                fixed (Single* c_ptr = &c)
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glReplacementCodeuiColor3fVertex3fvSUN((UInt32*)rc_ptr, (Single*)c_ptr, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glReplacementCodeuiColor3fVertex3fvSUN(ref Int32 rc, ref Single c, ref Single v)
        {
            unsafe
            {
                fixed (Int32* rc_ptr = &rc)
                fixed (Single* c_ptr = &c)
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glReplacementCodeuiColor3fVertex3fvSUN((UInt32*)rc_ptr, (Single*)c_ptr, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glReplacementCodeuiColor3fVertex3fvSUN(IntPtr rc, IntPtr c, IntPtr v)
        {
            unsafe
            {
                Delegates.glReplacementCodeuiColor3fVertex3fvSUN((UInt32*)rc, (Single*)c, (Single*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glReplacementCodeuiNormal3fVertex3fSUN(UInt32 rc, Single nx, Single ny, Single nz, Single x, Single y, Single z)
        {
            Delegates.glReplacementCodeuiNormal3fVertex3fSUN((UInt32)rc, (Single)nx, (Single)ny, (Single)nz, (Single)x, (Single)y, (Single)z);
        }

        public static 
        void glReplacementCodeuiNormal3fVertex3fSUN(Int32 rc, Single nx, Single ny, Single nz, Single x, Single y, Single z)
        {
            Delegates.glReplacementCodeuiNormal3fVertex3fSUN((UInt32)rc, (Single)nx, (Single)ny, (Single)nz, (Single)x, (Single)y, (Single)z);
        }

        [System.CLSCompliant(false)]
        public static 
        void glReplacementCodeuiNormal3fVertex3fvSUN(UInt32[] rc, Single[] n, Single[] v)
        {
            unsafe
            {
                fixed (UInt32* rc_ptr = rc)
                fixed (Single* n_ptr = n)
                fixed (Single* v_ptr = v)
                {
                    Delegates.glReplacementCodeuiNormal3fVertex3fvSUN((UInt32*)rc_ptr, (Single*)n_ptr, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glReplacementCodeuiNormal3fVertex3fvSUN(Int32[] rc, Single[] n, Single[] v)
        {
            unsafe
            {
                fixed (Int32* rc_ptr = rc)
                fixed (Single* n_ptr = n)
                fixed (Single* v_ptr = v)
                {
                    Delegates.glReplacementCodeuiNormal3fVertex3fvSUN((UInt32*)rc_ptr, (Single*)n_ptr, (Single*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glReplacementCodeuiNormal3fVertex3fvSUN(ref UInt32 rc, ref Single n, ref Single v)
        {
            unsafe
            {
                fixed (UInt32* rc_ptr = &rc)
                fixed (Single* n_ptr = &n)
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glReplacementCodeuiNormal3fVertex3fvSUN((UInt32*)rc_ptr, (Single*)n_ptr, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glReplacementCodeuiNormal3fVertex3fvSUN(ref Int32 rc, ref Single n, ref Single v)
        {
            unsafe
            {
                fixed (Int32* rc_ptr = &rc)
                fixed (Single* n_ptr = &n)
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glReplacementCodeuiNormal3fVertex3fvSUN((UInt32*)rc_ptr, (Single*)n_ptr, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glReplacementCodeuiNormal3fVertex3fvSUN(IntPtr rc, IntPtr n, IntPtr v)
        {
            unsafe
            {
                Delegates.glReplacementCodeuiNormal3fVertex3fvSUN((UInt32*)rc, (Single*)n, (Single*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glReplacementCodeuiColor4fNormal3fVertex3fSUN(UInt32 rc, Single r, Single g, Single b, Single a, Single nx, Single ny, Single nz, Single x, Single y, Single z)
        {
            Delegates.glReplacementCodeuiColor4fNormal3fVertex3fSUN((UInt32)rc, (Single)r, (Single)g, (Single)b, (Single)a, (Single)nx, (Single)ny, (Single)nz, (Single)x, (Single)y, (Single)z);
        }

        public static 
        void glReplacementCodeuiColor4fNormal3fVertex3fSUN(Int32 rc, Single r, Single g, Single b, Single a, Single nx, Single ny, Single nz, Single x, Single y, Single z)
        {
            Delegates.glReplacementCodeuiColor4fNormal3fVertex3fSUN((UInt32)rc, (Single)r, (Single)g, (Single)b, (Single)a, (Single)nx, (Single)ny, (Single)nz, (Single)x, (Single)y, (Single)z);
        }

        [System.CLSCompliant(false)]
        public static 
        void glReplacementCodeuiColor4fNormal3fVertex3fvSUN(UInt32[] rc, Single[] c, Single[] n, Single[] v)
        {
            unsafe
            {
                fixed (UInt32* rc_ptr = rc)
                fixed (Single* c_ptr = c)
                fixed (Single* n_ptr = n)
                fixed (Single* v_ptr = v)
                {
                    Delegates.glReplacementCodeuiColor4fNormal3fVertex3fvSUN((UInt32*)rc_ptr, (Single*)c_ptr, (Single*)n_ptr, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glReplacementCodeuiColor4fNormal3fVertex3fvSUN(Int32[] rc, Single[] c, Single[] n, Single[] v)
        {
            unsafe
            {
                fixed (Int32* rc_ptr = rc)
                fixed (Single* c_ptr = c)
                fixed (Single* n_ptr = n)
                fixed (Single* v_ptr = v)
                {
                    Delegates.glReplacementCodeuiColor4fNormal3fVertex3fvSUN((UInt32*)rc_ptr, (Single*)c_ptr, (Single*)n_ptr, (Single*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glReplacementCodeuiColor4fNormal3fVertex3fvSUN(ref UInt32 rc, ref Single c, ref Single n, ref Single v)
        {
            unsafe
            {
                fixed (UInt32* rc_ptr = &rc)
                fixed (Single* c_ptr = &c)
                fixed (Single* n_ptr = &n)
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glReplacementCodeuiColor4fNormal3fVertex3fvSUN((UInt32*)rc_ptr, (Single*)c_ptr, (Single*)n_ptr, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glReplacementCodeuiColor4fNormal3fVertex3fvSUN(ref Int32 rc, ref Single c, ref Single n, ref Single v)
        {
            unsafe
            {
                fixed (Int32* rc_ptr = &rc)
                fixed (Single* c_ptr = &c)
                fixed (Single* n_ptr = &n)
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glReplacementCodeuiColor4fNormal3fVertex3fvSUN((UInt32*)rc_ptr, (Single*)c_ptr, (Single*)n_ptr, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glReplacementCodeuiColor4fNormal3fVertex3fvSUN(IntPtr rc, IntPtr c, IntPtr n, IntPtr v)
        {
            unsafe
            {
                Delegates.glReplacementCodeuiColor4fNormal3fVertex3fvSUN((UInt32*)rc, (Single*)c, (Single*)n, (Single*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glReplacementCodeuiTexCoord2fVertex3fSUN(UInt32 rc, Single s, Single t, Single x, Single y, Single z)
        {
            Delegates.glReplacementCodeuiTexCoord2fVertex3fSUN((UInt32)rc, (Single)s, (Single)t, (Single)x, (Single)y, (Single)z);
        }

        public static 
        void glReplacementCodeuiTexCoord2fVertex3fSUN(Int32 rc, Single s, Single t, Single x, Single y, Single z)
        {
            Delegates.glReplacementCodeuiTexCoord2fVertex3fSUN((UInt32)rc, (Single)s, (Single)t, (Single)x, (Single)y, (Single)z);
        }

        [System.CLSCompliant(false)]
        public static 
        void glReplacementCodeuiTexCoord2fVertex3fvSUN(UInt32[] rc, Single[] tc, Single[] v)
        {
            unsafe
            {
                fixed (UInt32* rc_ptr = rc)
                fixed (Single* tc_ptr = tc)
                fixed (Single* v_ptr = v)
                {
                    Delegates.glReplacementCodeuiTexCoord2fVertex3fvSUN((UInt32*)rc_ptr, (Single*)tc_ptr, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glReplacementCodeuiTexCoord2fVertex3fvSUN(Int32[] rc, Single[] tc, Single[] v)
        {
            unsafe
            {
                fixed (Int32* rc_ptr = rc)
                fixed (Single* tc_ptr = tc)
                fixed (Single* v_ptr = v)
                {
                    Delegates.glReplacementCodeuiTexCoord2fVertex3fvSUN((UInt32*)rc_ptr, (Single*)tc_ptr, (Single*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glReplacementCodeuiTexCoord2fVertex3fvSUN(ref UInt32 rc, ref Single tc, ref Single v)
        {
            unsafe
            {
                fixed (UInt32* rc_ptr = &rc)
                fixed (Single* tc_ptr = &tc)
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glReplacementCodeuiTexCoord2fVertex3fvSUN((UInt32*)rc_ptr, (Single*)tc_ptr, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glReplacementCodeuiTexCoord2fVertex3fvSUN(ref Int32 rc, ref Single tc, ref Single v)
        {
            unsafe
            {
                fixed (Int32* rc_ptr = &rc)
                fixed (Single* tc_ptr = &tc)
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glReplacementCodeuiTexCoord2fVertex3fvSUN((UInt32*)rc_ptr, (Single*)tc_ptr, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glReplacementCodeuiTexCoord2fVertex3fvSUN(IntPtr rc, IntPtr tc, IntPtr v)
        {
            unsafe
            {
                Delegates.glReplacementCodeuiTexCoord2fVertex3fvSUN((UInt32*)rc, (Single*)tc, (Single*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN(UInt32 rc, Single s, Single t, Single nx, Single ny, Single nz, Single x, Single y, Single z)
        {
            Delegates.glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN((UInt32)rc, (Single)s, (Single)t, (Single)nx, (Single)ny, (Single)nz, (Single)x, (Single)y, (Single)z);
        }

        public static 
        void glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN(Int32 rc, Single s, Single t, Single nx, Single ny, Single nz, Single x, Single y, Single z)
        {
            Delegates.glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN((UInt32)rc, (Single)s, (Single)t, (Single)nx, (Single)ny, (Single)nz, (Single)x, (Single)y, (Single)z);
        }

        [System.CLSCompliant(false)]
        public static 
        void glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN(UInt32[] rc, Single[] tc, Single[] n, Single[] v)
        {
            unsafe
            {
                fixed (UInt32* rc_ptr = rc)
                fixed (Single* tc_ptr = tc)
                fixed (Single* n_ptr = n)
                fixed (Single* v_ptr = v)
                {
                    Delegates.glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN((UInt32*)rc_ptr, (Single*)tc_ptr, (Single*)n_ptr, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN(Int32[] rc, Single[] tc, Single[] n, Single[] v)
        {
            unsafe
            {
                fixed (Int32* rc_ptr = rc)
                fixed (Single* tc_ptr = tc)
                fixed (Single* n_ptr = n)
                fixed (Single* v_ptr = v)
                {
                    Delegates.glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN((UInt32*)rc_ptr, (Single*)tc_ptr, (Single*)n_ptr, (Single*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN(ref UInt32 rc, ref Single tc, ref Single n, ref Single v)
        {
            unsafe
            {
                fixed (UInt32* rc_ptr = &rc)
                fixed (Single* tc_ptr = &tc)
                fixed (Single* n_ptr = &n)
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN((UInt32*)rc_ptr, (Single*)tc_ptr, (Single*)n_ptr, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN(ref Int32 rc, ref Single tc, ref Single n, ref Single v)
        {
            unsafe
            {
                fixed (Int32* rc_ptr = &rc)
                fixed (Single* tc_ptr = &tc)
                fixed (Single* n_ptr = &n)
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN((UInt32*)rc_ptr, (Single*)tc_ptr, (Single*)n_ptr, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN(IntPtr rc, IntPtr tc, IntPtr n, IntPtr v)
        {
            unsafe
            {
                Delegates.glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN((UInt32*)rc, (Single*)tc, (Single*)n, (Single*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN(UInt32 rc, Single s, Single t, Single r, Single g, Single b, Single a, Single nx, Single ny, Single nz, Single x, Single y, Single z)
        {
            Delegates.glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN((UInt32)rc, (Single)s, (Single)t, (Single)r, (Single)g, (Single)b, (Single)a, (Single)nx, (Single)ny, (Single)nz, (Single)x, (Single)y, (Single)z);
        }

        public static 
        void glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN(Int32 rc, Single s, Single t, Single r, Single g, Single b, Single a, Single nx, Single ny, Single nz, Single x, Single y, Single z)
        {
            Delegates.glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN((UInt32)rc, (Single)s, (Single)t, (Single)r, (Single)g, (Single)b, (Single)a, (Single)nx, (Single)ny, (Single)nz, (Single)x, (Single)y, (Single)z);
        }

        [System.CLSCompliant(false)]
        public static 
        void glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN(UInt32[] rc, Single[] tc, Single[] c, Single[] n, Single[] v)
        {
            unsafe
            {
                fixed (UInt32* rc_ptr = rc)
                fixed (Single* tc_ptr = tc)
                fixed (Single* c_ptr = c)
                fixed (Single* n_ptr = n)
                fixed (Single* v_ptr = v)
                {
                    Delegates.glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN((UInt32*)rc_ptr, (Single*)tc_ptr, (Single*)c_ptr, (Single*)n_ptr, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN(Int32[] rc, Single[] tc, Single[] c, Single[] n, Single[] v)
        {
            unsafe
            {
                fixed (Int32* rc_ptr = rc)
                fixed (Single* tc_ptr = tc)
                fixed (Single* c_ptr = c)
                fixed (Single* n_ptr = n)
                fixed (Single* v_ptr = v)
                {
                    Delegates.glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN((UInt32*)rc_ptr, (Single*)tc_ptr, (Single*)c_ptr, (Single*)n_ptr, (Single*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN(ref UInt32 rc, ref Single tc, ref Single c, ref Single n, ref Single v)
        {
            unsafe
            {
                fixed (UInt32* rc_ptr = &rc)
                fixed (Single* tc_ptr = &tc)
                fixed (Single* c_ptr = &c)
                fixed (Single* n_ptr = &n)
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN((UInt32*)rc_ptr, (Single*)tc_ptr, (Single*)c_ptr, (Single*)n_ptr, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN(ref Int32 rc, ref Single tc, ref Single c, ref Single n, ref Single v)
        {
            unsafe
            {
                fixed (Int32* rc_ptr = &rc)
                fixed (Single* tc_ptr = &tc)
                fixed (Single* c_ptr = &c)
                fixed (Single* n_ptr = &n)
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN((UInt32*)rc_ptr, (Single*)tc_ptr, (Single*)c_ptr, (Single*)n_ptr, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN(IntPtr rc, IntPtr tc, IntPtr c, IntPtr n, IntPtr v)
        {
            unsafe
            {
                Delegates.glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN((UInt32*)rc, (Single*)tc, (Single*)c, (Single*)n, (Single*)v);
            }
        }

        public static 
        void glDrawMeshArraysSUN(int mode, Int32 first, Int32 count, Int32 width)
        {
            Delegates.glDrawMeshArraysSUN((int)mode, (Int32)first, (Int32)count, (Int32)width);
        }

        public static 
        void glBlendFuncSeparateINGR(int sfactorRGB, int dfactorRGB, int sfactorAlpha, int dfactorAlpha)
        {
            Delegates.glBlendFuncSeparateINGR((int)sfactorRGB, (int)dfactorRGB, (int)sfactorAlpha, (int)dfactorAlpha);
        }

        public static 
        void glFlushVertexArrayRangeNV()
        {
            Delegates.glFlushVertexArrayRangeNV();
        }

        public static 
        void glVertexArrayRangeNV(Int32 length, IntPtr pointer)
        {
            unsafe
            {
                Delegates.glVertexArrayRangeNV((Int32)length, (IntPtr)pointer);
            }
        }

        public static 
        void glVertexArrayRangeNV(Int32 length, [In, Out] object pointer)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle pointer_ptr = System.Runtime.InteropServices.GCHandle.Alloc(pointer, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glVertexArrayRangeNV((Int32)length, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
            }
        }

        public static 
        void glCombinerParameterfvNV(int pname, Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glCombinerParameterfvNV((int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glCombinerParameterfvNV(int pname, ref Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glCombinerParameterfvNV((int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glCombinerParameterfvNV(int pname, IntPtr @params)
        {
            unsafe
            {
                Delegates.glCombinerParameterfvNV((int)pname, (Single*)@params);
            }
        }

        public static 
        void glCombinerParameterfNV(int pname, Single param)
        {
            Delegates.glCombinerParameterfNV((int)pname, (Single)param);
        }

        public static 
        void glCombinerParameterivNV(int pname, Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glCombinerParameterivNV((int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glCombinerParameterivNV(int pname, ref Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glCombinerParameterivNV((int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glCombinerParameterivNV(int pname, IntPtr @params)
        {
            unsafe
            {
                Delegates.glCombinerParameterivNV((int)pname, (Int32*)@params);
            }
        }

        public static 
        void glCombinerParameteriNV(int pname, Int32 param)
        {
            Delegates.glCombinerParameteriNV((int)pname, (Int32)param);
        }

        public static 
        void glCombinerInputNV(int stage, int portion, int variable, int input, int mapping, int componentUsage)
        {
            Delegates.glCombinerInputNV((int)stage, (int)portion, (int)variable, (int)input, (int)mapping, (int)componentUsage);
        }

        public static 
        void glCombinerOutputNV(int stage, int portion, int abOutput, int cdOutput, int sumOutput, int scale, int bias, bool abDotProduct, bool cdDotProduct, bool muxSum)
        {
            Delegates.glCombinerOutputNV((int)stage, (int)portion, (int)abOutput, (int)cdOutput, (int)sumOutput, (int)scale, (int)bias, (bool)abDotProduct, (bool)cdDotProduct, (bool)muxSum);
        }

        public static 
        void glFinalCombinerInputNV(int variable, int input, int mapping, int componentUsage)
        {
            Delegates.glFinalCombinerInputNV((int)variable, (int)input, (int)mapping, (int)componentUsage);
        }

        public static 
        void glGetCombinerInputParameterfvNV(int stage, int portion, int variable, int pname, [Out] Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glGetCombinerInputParameterfvNV((int)stage, (int)portion, (int)variable, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glGetCombinerInputParameterfvNV(int stage, int portion, int variable, int pname, [Out] out Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glGetCombinerInputParameterfvNV((int)stage, (int)portion, (int)variable, (int)pname, (Single*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetCombinerInputParameterfvNV(int stage, int portion, int variable, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetCombinerInputParameterfvNV((int)stage, (int)portion, (int)variable, (int)pname, (Single*)@params);
            }
        }

        public static 
        void glGetCombinerInputParameterivNV(int stage, int portion, int variable, int pname, [Out] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetCombinerInputParameterivNV((int)stage, (int)portion, (int)variable, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glGetCombinerInputParameterivNV(int stage, int portion, int variable, int pname, [Out] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetCombinerInputParameterivNV((int)stage, (int)portion, (int)variable, (int)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetCombinerInputParameterivNV(int stage, int portion, int variable, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetCombinerInputParameterivNV((int)stage, (int)portion, (int)variable, (int)pname, (Int32*)@params);
            }
        }

        public static 
        void glGetCombinerOutputParameterfvNV(int stage, int portion, int pname, [Out] Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glGetCombinerOutputParameterfvNV((int)stage, (int)portion, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glGetCombinerOutputParameterfvNV(int stage, int portion, int pname, [Out] out Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glGetCombinerOutputParameterfvNV((int)stage, (int)portion, (int)pname, (Single*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetCombinerOutputParameterfvNV(int stage, int portion, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetCombinerOutputParameterfvNV((int)stage, (int)portion, (int)pname, (Single*)@params);
            }
        }

        public static 
        void glGetCombinerOutputParameterivNV(int stage, int portion, int pname, [Out] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetCombinerOutputParameterivNV((int)stage, (int)portion, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glGetCombinerOutputParameterivNV(int stage, int portion, int pname, [Out] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetCombinerOutputParameterivNV((int)stage, (int)portion, (int)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetCombinerOutputParameterivNV(int stage, int portion, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetCombinerOutputParameterivNV((int)stage, (int)portion, (int)pname, (Int32*)@params);
            }
        }

        public static 
        void glGetFinalCombinerInputParameterfvNV(int variable, int pname, [Out] Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glGetFinalCombinerInputParameterfvNV((int)variable, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glGetFinalCombinerInputParameterfvNV(int variable, int pname, [Out] out Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glGetFinalCombinerInputParameterfvNV((int)variable, (int)pname, (Single*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetFinalCombinerInputParameterfvNV(int variable, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetFinalCombinerInputParameterfvNV((int)variable, (int)pname, (Single*)@params);
            }
        }

        public static 
        void glGetFinalCombinerInputParameterivNV(int variable, int pname, [Out] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetFinalCombinerInputParameterivNV((int)variable, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glGetFinalCombinerInputParameterivNV(int variable, int pname, [Out] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetFinalCombinerInputParameterivNV((int)variable, (int)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetFinalCombinerInputParameterivNV(int variable, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetFinalCombinerInputParameterivNV((int)variable, (int)pname, (Int32*)@params);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glDeleteFencesNV(Int32 n, UInt32[] fences)
        {
            unsafe
            {
                fixed (UInt32* fences_ptr = fences)
                {
                    Delegates.glDeleteFencesNV((Int32)n, (UInt32*)fences_ptr);
                }
            }
        }

        public static 
        void glDeleteFencesNV(Int32 n, Int32[] fences)
        {
            unsafe
            {
                fixed (Int32* fences_ptr = fences)
                {
                    Delegates.glDeleteFencesNV((Int32)n, (UInt32*)fences_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glDeleteFencesNV(Int32 n, ref UInt32 fences)
        {
            unsafe
            {
                fixed (UInt32* fences_ptr = &fences)
                {
                    Delegates.glDeleteFencesNV((Int32)n, (UInt32*)fences_ptr);
                }
            }
        }

        public static 
        void glDeleteFencesNV(Int32 n, ref Int32 fences)
        {
            unsafe
            {
                fixed (Int32* fences_ptr = &fences)
                {
                    Delegates.glDeleteFencesNV((Int32)n, (UInt32*)fences_ptr);
                }
            }
        }

        public static 
        void glDeleteFencesNV(Int32 n, IntPtr fences)
        {
            unsafe
            {
                Delegates.glDeleteFencesNV((Int32)n, (UInt32*)fences);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGenFencesNV(Int32 n, [Out] UInt32[] fences)
        {
            unsafe
            {
                fixed (UInt32* fences_ptr = fences)
                {
                    Delegates.glGenFencesNV((Int32)n, (UInt32*)fences_ptr);
                }
            }
        }

        public static 
        void glGenFencesNV(Int32 n, [Out] Int32[] fences)
        {
            unsafe
            {
                fixed (Int32* fences_ptr = fences)
                {
                    Delegates.glGenFencesNV((Int32)n, (UInt32*)fences_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGenFencesNV(Int32 n, [Out] out UInt32 fences)
        {
            unsafe
            {
                fixed (UInt32* fences_ptr = &fences)
                {
                    Delegates.glGenFencesNV((Int32)n, (UInt32*)fences_ptr);
                    fences = *fences_ptr;
                }
            }
        }

        public static 
        void glGenFencesNV(Int32 n, [Out] out Int32 fences)
        {
            unsafe
            {
                fixed (Int32* fences_ptr = &fences)
                {
                    Delegates.glGenFencesNV((Int32)n, (UInt32*)fences_ptr);
                    fences = *fences_ptr;
                }
            }
        }

        public static 
        void glGenFencesNV(Int32 n, [Out] IntPtr fences)
        {
            unsafe
            {
                Delegates.glGenFencesNV((Int32)n, (UInt32*)fences);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        bool glIsFenceNV(UInt32 fence)
        {
            return Delegates.glIsFenceNV((UInt32)fence);
        }

        public static 
        bool glIsFenceNV(Int32 fence)
        {
            return Delegates.glIsFenceNV((UInt32)fence);
        }

        [System.CLSCompliant(false)]
        public static 
        bool glTestFenceNV(UInt32 fence)
        {
            return Delegates.glTestFenceNV((UInt32)fence);
        }

        public static 
        bool glTestFenceNV(Int32 fence)
        {
            return Delegates.glTestFenceNV((UInt32)fence);
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetFenceivNV(UInt32 fence, int pname, [Out] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetFenceivNV((UInt32)fence, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glGetFenceivNV(Int32 fence, int pname, [Out] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetFenceivNV((UInt32)fence, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetFenceivNV(UInt32 fence, int pname, [Out] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetFenceivNV((UInt32)fence, (int)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetFenceivNV(Int32 fence, int pname, [Out] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetFenceivNV((UInt32)fence, (int)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetFenceivNV(UInt32 fence, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetFenceivNV((UInt32)fence, (int)pname, (Int32*)@params);
            }
        }

        public static 
        void glGetFenceivNV(Int32 fence, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetFenceivNV((UInt32)fence, (int)pname, (Int32*)@params);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glFinishFenceNV(UInt32 fence)
        {
            Delegates.glFinishFenceNV((UInt32)fence);
        }

        public static 
        void glFinishFenceNV(Int32 fence)
        {
            Delegates.glFinishFenceNV((UInt32)fence);
        }

        [System.CLSCompliant(false)]
        public static 
        void glSetFenceNV(UInt32 fence, int condition)
        {
            Delegates.glSetFenceNV((UInt32)fence, (int)condition);
        }

        public static 
        void glSetFenceNV(Int32 fence, int condition)
        {
            Delegates.glSetFenceNV((UInt32)fence, (int)condition);
        }

        [System.CLSCompliant(false)]
        public static 
        void glMapControlPointsNV(int target, UInt32 index, int type, Int32 ustride, Int32 vstride, Int32 uorder, Int32 vorder, bool packed, IntPtr points)
        {
            unsafe
            {
                Delegates.glMapControlPointsNV((int)target, (UInt32)index, (int)type, (Int32)ustride, (Int32)vstride, (Int32)uorder, (Int32)vorder, (bool)packed, (IntPtr)points);
            }
        }

        public static 
        void glMapControlPointsNV(int target, Int32 index, int type, Int32 ustride, Int32 vstride, Int32 uorder, Int32 vorder, bool packed, IntPtr points)
        {
            unsafe
            {
                Delegates.glMapControlPointsNV((int)target, (UInt32)index, (int)type, (Int32)ustride, (Int32)vstride, (Int32)uorder, (Int32)vorder, (bool)packed, (IntPtr)points);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glMapControlPointsNV(int target, UInt32 index, int type, Int32 ustride, Int32 vstride, Int32 uorder, Int32 vorder, bool packed, [In, Out] object points)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle points_ptr = System.Runtime.InteropServices.GCHandle.Alloc(points, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glMapControlPointsNV((int)target, (UInt32)index, (int)type, (Int32)ustride, (Int32)vstride, (Int32)uorder, (Int32)vorder, (bool)packed, (IntPtr)points_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    points_ptr.Free();
                }
            }
        }

        public static 
        void glMapControlPointsNV(int target, Int32 index, int type, Int32 ustride, Int32 vstride, Int32 uorder, Int32 vorder, bool packed, [In, Out] object points)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle points_ptr = System.Runtime.InteropServices.GCHandle.Alloc(points, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glMapControlPointsNV((int)target, (UInt32)index, (int)type, (Int32)ustride, (Int32)vstride, (Int32)uorder, (Int32)vorder, (bool)packed, (IntPtr)points_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    points_ptr.Free();
                }
            }
        }

        public static 
        void glMapParameterivNV(int target, int pname, Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glMapParameterivNV((int)target, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glMapParameterivNV(int target, int pname, ref Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glMapParameterivNV((int)target, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glMapParameterivNV(int target, int pname, IntPtr @params)
        {
            unsafe
            {
                Delegates.glMapParameterivNV((int)target, (int)pname, (Int32*)@params);
            }
        }

        public static 
        void glMapParameterfvNV(int target, int pname, Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glMapParameterfvNV((int)target, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glMapParameterfvNV(int target, int pname, ref Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glMapParameterfvNV((int)target, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glMapParameterfvNV(int target, int pname, IntPtr @params)
        {
            unsafe
            {
                Delegates.glMapParameterfvNV((int)target, (int)pname, (Single*)@params);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetMapControlPointsNV(int target, UInt32 index, int type, Int32 ustride, Int32 vstride, bool packed, [Out] IntPtr points)
        {
            unsafe
            {
                Delegates.glGetMapControlPointsNV((int)target, (UInt32)index, (int)type, (Int32)ustride, (Int32)vstride, (bool)packed, (IntPtr)points);
            }
        }

        public static 
        void glGetMapControlPointsNV(int target, Int32 index, int type, Int32 ustride, Int32 vstride, bool packed, [Out] IntPtr points)
        {
            unsafe
            {
                Delegates.glGetMapControlPointsNV((int)target, (UInt32)index, (int)type, (Int32)ustride, (Int32)vstride, (bool)packed, (IntPtr)points);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetMapControlPointsNV(int target, UInt32 index, int type, Int32 ustride, Int32 vstride, bool packed, [In, Out] object points)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle points_ptr = System.Runtime.InteropServices.GCHandle.Alloc(points, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glGetMapControlPointsNV((int)target, (UInt32)index, (int)type, (Int32)ustride, (Int32)vstride, (bool)packed, (IntPtr)points_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    points_ptr.Free();
                }
            }
        }

        public static 
        void glGetMapControlPointsNV(int target, Int32 index, int type, Int32 ustride, Int32 vstride, bool packed, [In, Out] object points)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle points_ptr = System.Runtime.InteropServices.GCHandle.Alloc(points, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glGetMapControlPointsNV((int)target, (UInt32)index, (int)type, (Int32)ustride, (Int32)vstride, (bool)packed, (IntPtr)points_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    points_ptr.Free();
                }
            }
        }

        public static 
        void glGetMapParameterivNV(int target, int pname, [Out] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetMapParameterivNV((int)target, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glGetMapParameterivNV(int target, int pname, [Out] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetMapParameterivNV((int)target, (int)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetMapParameterivNV(int target, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetMapParameterivNV((int)target, (int)pname, (Int32*)@params);
            }
        }

        public static 
        void glGetMapParameterfvNV(int target, int pname, [Out] Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glGetMapParameterfvNV((int)target, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glGetMapParameterfvNV(int target, int pname, [Out] out Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glGetMapParameterfvNV((int)target, (int)pname, (Single*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetMapParameterfvNV(int target, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetMapParameterfvNV((int)target, (int)pname, (Single*)@params);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetMapAttribParameterivNV(int target, UInt32 index, int pname, [Out] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetMapAttribParameterivNV((int)target, (UInt32)index, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glGetMapAttribParameterivNV(int target, Int32 index, int pname, [Out] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetMapAttribParameterivNV((int)target, (UInt32)index, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetMapAttribParameterivNV(int target, UInt32 index, int pname, [Out] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetMapAttribParameterivNV((int)target, (UInt32)index, (int)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetMapAttribParameterivNV(int target, Int32 index, int pname, [Out] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetMapAttribParameterivNV((int)target, (UInt32)index, (int)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetMapAttribParameterivNV(int target, UInt32 index, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetMapAttribParameterivNV((int)target, (UInt32)index, (int)pname, (Int32*)@params);
            }
        }

        public static 
        void glGetMapAttribParameterivNV(int target, Int32 index, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetMapAttribParameterivNV((int)target, (UInt32)index, (int)pname, (Int32*)@params);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetMapAttribParameterfvNV(int target, UInt32 index, int pname, [Out] Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glGetMapAttribParameterfvNV((int)target, (UInt32)index, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glGetMapAttribParameterfvNV(int target, Int32 index, int pname, [Out] Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glGetMapAttribParameterfvNV((int)target, (UInt32)index, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetMapAttribParameterfvNV(int target, UInt32 index, int pname, [Out] out Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glGetMapAttribParameterfvNV((int)target, (UInt32)index, (int)pname, (Single*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetMapAttribParameterfvNV(int target, Int32 index, int pname, [Out] out Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glGetMapAttribParameterfvNV((int)target, (UInt32)index, (int)pname, (Single*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetMapAttribParameterfvNV(int target, UInt32 index, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetMapAttribParameterfvNV((int)target, (UInt32)index, (int)pname, (Single*)@params);
            }
        }

        public static 
        void glGetMapAttribParameterfvNV(int target, Int32 index, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetMapAttribParameterfvNV((int)target, (UInt32)index, (int)pname, (Single*)@params);
            }
        }

        public static 
        void glEvalMapsNV(int target, int mode)
        {
            Delegates.glEvalMapsNV((int)target, (int)mode);
        }

        public static 
        void glCombinerStageParameterfvNV(int stage, int pname, Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glCombinerStageParameterfvNV((int)stage, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glCombinerStageParameterfvNV(int stage, int pname, ref Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glCombinerStageParameterfvNV((int)stage, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glCombinerStageParameterfvNV(int stage, int pname, IntPtr @params)
        {
            unsafe
            {
                Delegates.glCombinerStageParameterfvNV((int)stage, (int)pname, (Single*)@params);
            }
        }

        public static 
        void glGetCombinerStageParameterfvNV(int stage, int pname, [Out] Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glGetCombinerStageParameterfvNV((int)stage, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glGetCombinerStageParameterfvNV(int stage, int pname, [Out] out Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glGetCombinerStageParameterfvNV((int)stage, (int)pname, (Single*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetCombinerStageParameterfvNV(int stage, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetCombinerStageParameterfvNV((int)stage, (int)pname, (Single*)@params);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        bool glAreProgramsResidentNV(Int32 n, UInt32[] programs, [Out] bool[] residences)
        {
            unsafe
            {
                fixed (UInt32* programs_ptr = programs)
                fixed (bool* residences_ptr = residences)
                {
                    return Delegates.glAreProgramsResidentNV((Int32)n, (UInt32*)programs_ptr, (bool*)residences_ptr);
                }
            }
        }

        public static 
        bool glAreProgramsResidentNV(Int32 n, Int32[] programs, [Out] bool[] residences)
        {
            unsafe
            {
                fixed (Int32* programs_ptr = programs)
                fixed (bool* residences_ptr = residences)
                {
                    return Delegates.glAreProgramsResidentNV((Int32)n, (UInt32*)programs_ptr, (bool*)residences_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        bool glAreProgramsResidentNV(Int32 n, ref UInt32 programs, [Out] out bool residences)
        {
            unsafe
            {
                fixed (UInt32* programs_ptr = &programs)
                fixed (bool* residences_ptr = &residences)
                {
                    bool retval = Delegates.glAreProgramsResidentNV((Int32)n, (UInt32*)programs_ptr, (bool*)residences_ptr);
                    residences = *residences_ptr;
                    return retval;
                }
            }
        }

        public static 
        bool glAreProgramsResidentNV(Int32 n, ref Int32 programs, [Out] out bool residences)
        {
            unsafe
            {
                fixed (Int32* programs_ptr = &programs)
                fixed (bool* residences_ptr = &residences)
                {
                    bool retval = Delegates.glAreProgramsResidentNV((Int32)n, (UInt32*)programs_ptr, (bool*)residences_ptr);
                    residences = *residences_ptr;
                    return retval;
                }
            }
        }

        public static 
        bool glAreProgramsResidentNV(Int32 n, IntPtr programs, [Out] IntPtr residences)
        {
            unsafe
            {
                return Delegates.glAreProgramsResidentNV((Int32)n, (UInt32*)programs, (bool*)residences);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glBindProgramNV(int target, UInt32 id)
        {
            Delegates.glBindProgramNV((int)target, (UInt32)id);
        }

        public static 
        void glBindProgramNV(int target, Int32 id)
        {
            Delegates.glBindProgramNV((int)target, (UInt32)id);
        }

        [System.CLSCompliant(false)]
        public static 
        void glDeleteProgramsNV(Int32 n, UInt32[] programs)
        {
            unsafe
            {
                fixed (UInt32* programs_ptr = programs)
                {
                    Delegates.glDeleteProgramsNV((Int32)n, (UInt32*)programs_ptr);
                }
            }
        }

        public static 
        void glDeleteProgramsNV(Int32 n, Int32[] programs)
        {
            unsafe
            {
                fixed (Int32* programs_ptr = programs)
                {
                    Delegates.glDeleteProgramsNV((Int32)n, (UInt32*)programs_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glDeleteProgramsNV(Int32 n, ref UInt32 programs)
        {
            unsafe
            {
                fixed (UInt32* programs_ptr = &programs)
                {
                    Delegates.glDeleteProgramsNV((Int32)n, (UInt32*)programs_ptr);
                }
            }
        }

        public static 
        void glDeleteProgramsNV(Int32 n, ref Int32 programs)
        {
            unsafe
            {
                fixed (Int32* programs_ptr = &programs)
                {
                    Delegates.glDeleteProgramsNV((Int32)n, (UInt32*)programs_ptr);
                }
            }
        }

        public static 
        void glDeleteProgramsNV(Int32 n, IntPtr programs)
        {
            unsafe
            {
                Delegates.glDeleteProgramsNV((Int32)n, (UInt32*)programs);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glExecuteProgramNV(int target, UInt32 id, Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glExecuteProgramNV((int)target, (UInt32)id, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glExecuteProgramNV(int target, Int32 id, Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glExecuteProgramNV((int)target, (UInt32)id, (Single*)@params_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glExecuteProgramNV(int target, UInt32 id, ref Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glExecuteProgramNV((int)target, (UInt32)id, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glExecuteProgramNV(int target, Int32 id, ref Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glExecuteProgramNV((int)target, (UInt32)id, (Single*)@params_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glExecuteProgramNV(int target, UInt32 id, IntPtr @params)
        {
            unsafe
            {
                Delegates.glExecuteProgramNV((int)target, (UInt32)id, (Single*)@params);
            }
        }

        public static 
        void glExecuteProgramNV(int target, Int32 id, IntPtr @params)
        {
            unsafe
            {
                Delegates.glExecuteProgramNV((int)target, (UInt32)id, (Single*)@params);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGenProgramsNV(Int32 n, [Out] UInt32[] programs)
        {
            unsafe
            {
                fixed (UInt32* programs_ptr = programs)
                {
                    Delegates.glGenProgramsNV((Int32)n, (UInt32*)programs_ptr);
                }
            }
        }

        public static 
        void glGenProgramsNV(Int32 n, [Out] Int32[] programs)
        {
            unsafe
            {
                fixed (Int32* programs_ptr = programs)
                {
                    Delegates.glGenProgramsNV((Int32)n, (UInt32*)programs_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGenProgramsNV(Int32 n, [Out] out UInt32 programs)
        {
            unsafe
            {
                fixed (UInt32* programs_ptr = &programs)
                {
                    Delegates.glGenProgramsNV((Int32)n, (UInt32*)programs_ptr);
                    programs = *programs_ptr;
                }
            }
        }

        public static 
        void glGenProgramsNV(Int32 n, [Out] out Int32 programs)
        {
            unsafe
            {
                fixed (Int32* programs_ptr = &programs)
                {
                    Delegates.glGenProgramsNV((Int32)n, (UInt32*)programs_ptr);
                    programs = *programs_ptr;
                }
            }
        }

        public static 
        void glGenProgramsNV(Int32 n, [Out] IntPtr programs)
        {
            unsafe
            {
                Delegates.glGenProgramsNV((Int32)n, (UInt32*)programs);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetProgramParameterdvNV(int target, UInt32 index, int pname, [Out] Double[] @params)
        {
            unsafe
            {
                fixed (Double* @params_ptr = @params)
                {
                    Delegates.glGetProgramParameterdvNV((int)target, (UInt32)index, (int)pname, (Double*)@params_ptr);
                }
            }
        }

        public static 
        void glGetProgramParameterdvNV(int target, Int32 index, int pname, [Out] Double[] @params)
        {
            unsafe
            {
                fixed (Double* @params_ptr = @params)
                {
                    Delegates.glGetProgramParameterdvNV((int)target, (UInt32)index, (int)pname, (Double*)@params_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetProgramParameterdvNV(int target, UInt32 index, int pname, [Out] out Double @params)
        {
            unsafe
            {
                fixed (Double* @params_ptr = &@params)
                {
                    Delegates.glGetProgramParameterdvNV((int)target, (UInt32)index, (int)pname, (Double*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetProgramParameterdvNV(int target, Int32 index, int pname, [Out] out Double @params)
        {
            unsafe
            {
                fixed (Double* @params_ptr = &@params)
                {
                    Delegates.glGetProgramParameterdvNV((int)target, (UInt32)index, (int)pname, (Double*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetProgramParameterdvNV(int target, UInt32 index, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetProgramParameterdvNV((int)target, (UInt32)index, (int)pname, (Double*)@params);
            }
        }

        public static 
        void glGetProgramParameterdvNV(int target, Int32 index, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetProgramParameterdvNV((int)target, (UInt32)index, (int)pname, (Double*)@params);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetProgramParameterfvNV(int target, UInt32 index, int pname, [Out] Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glGetProgramParameterfvNV((int)target, (UInt32)index, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glGetProgramParameterfvNV(int target, Int32 index, int pname, [Out] Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glGetProgramParameterfvNV((int)target, (UInt32)index, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetProgramParameterfvNV(int target, UInt32 index, int pname, [Out] out Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glGetProgramParameterfvNV((int)target, (UInt32)index, (int)pname, (Single*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetProgramParameterfvNV(int target, Int32 index, int pname, [Out] out Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glGetProgramParameterfvNV((int)target, (UInt32)index, (int)pname, (Single*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetProgramParameterfvNV(int target, UInt32 index, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetProgramParameterfvNV((int)target, (UInt32)index, (int)pname, (Single*)@params);
            }
        }

        public static 
        void glGetProgramParameterfvNV(int target, Int32 index, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetProgramParameterfvNV((int)target, (UInt32)index, (int)pname, (Single*)@params);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetProgramivNV(UInt32 id, int pname, [Out] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetProgramivNV((UInt32)id, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glGetProgramivNV(Int32 id, int pname, [Out] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetProgramivNV((UInt32)id, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetProgramivNV(UInt32 id, int pname, [Out] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetProgramivNV((UInt32)id, (int)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetProgramivNV(Int32 id, int pname, [Out] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetProgramivNV((UInt32)id, (int)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetProgramivNV(UInt32 id, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetProgramivNV((UInt32)id, (int)pname, (Int32*)@params);
            }
        }

        public static 
        void glGetProgramivNV(Int32 id, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetProgramivNV((UInt32)id, (int)pname, (Int32*)@params);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetProgramStringNV(UInt32 id, int pname, [Out] Byte[] program)
        {
            unsafe
            {
                fixed (Byte* program_ptr = program)
                {
                    Delegates.glGetProgramStringNV((UInt32)id, (int)pname, (Byte*)program_ptr);
                }
            }
        }

        public static 
        void glGetProgramStringNV(Int32 id, int pname, [Out] Byte[] program)
        {
            unsafe
            {
                fixed (Byte* program_ptr = program)
                {
                    Delegates.glGetProgramStringNV((UInt32)id, (int)pname, (Byte*)program_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetProgramStringNV(UInt32 id, int pname, [Out] out Byte program)
        {
            unsafe
            {
                fixed (Byte* program_ptr = &program)
                {
                    Delegates.glGetProgramStringNV((UInt32)id, (int)pname, (Byte*)program_ptr);
                    program = *program_ptr;
                }
            }
        }

        public static 
        void glGetProgramStringNV(Int32 id, int pname, [Out] out Byte program)
        {
            unsafe
            {
                fixed (Byte* program_ptr = &program)
                {
                    Delegates.glGetProgramStringNV((UInt32)id, (int)pname, (Byte*)program_ptr);
                    program = *program_ptr;
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetProgramStringNV(UInt32 id, int pname, [Out] IntPtr program)
        {
            unsafe
            {
                Delegates.glGetProgramStringNV((UInt32)id, (int)pname, (Byte*)program);
            }
        }

        public static 
        void glGetProgramStringNV(Int32 id, int pname, [Out] IntPtr program)
        {
            unsafe
            {
                Delegates.glGetProgramStringNV((UInt32)id, (int)pname, (Byte*)program);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetTrackMatrixivNV(int target, UInt32 address, int pname, [Out] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetTrackMatrixivNV((int)target, (UInt32)address, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glGetTrackMatrixivNV(int target, Int32 address, int pname, [Out] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetTrackMatrixivNV((int)target, (UInt32)address, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetTrackMatrixivNV(int target, UInt32 address, int pname, [Out] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetTrackMatrixivNV((int)target, (UInt32)address, (int)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetTrackMatrixivNV(int target, Int32 address, int pname, [Out] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetTrackMatrixivNV((int)target, (UInt32)address, (int)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetTrackMatrixivNV(int target, UInt32 address, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetTrackMatrixivNV((int)target, (UInt32)address, (int)pname, (Int32*)@params);
            }
        }

        public static 
        void glGetTrackMatrixivNV(int target, Int32 address, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetTrackMatrixivNV((int)target, (UInt32)address, (int)pname, (Int32*)@params);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetVertexAttribdvNV(UInt32 index, int pname, [Out] Double[] @params)
        {
            unsafe
            {
                fixed (Double* @params_ptr = @params)
                {
                    Delegates.glGetVertexAttribdvNV((UInt32)index, (int)pname, (Double*)@params_ptr);
                }
            }
        }

        public static 
        void glGetVertexAttribdvNV(Int32 index, int pname, [Out] Double[] @params)
        {
            unsafe
            {
                fixed (Double* @params_ptr = @params)
                {
                    Delegates.glGetVertexAttribdvNV((UInt32)index, (int)pname, (Double*)@params_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetVertexAttribdvNV(UInt32 index, int pname, [Out] out Double @params)
        {
            unsafe
            {
                fixed (Double* @params_ptr = &@params)
                {
                    Delegates.glGetVertexAttribdvNV((UInt32)index, (int)pname, (Double*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetVertexAttribdvNV(Int32 index, int pname, [Out] out Double @params)
        {
            unsafe
            {
                fixed (Double* @params_ptr = &@params)
                {
                    Delegates.glGetVertexAttribdvNV((UInt32)index, (int)pname, (Double*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetVertexAttribdvNV(UInt32 index, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetVertexAttribdvNV((UInt32)index, (int)pname, (Double*)@params);
            }
        }

        public static 
        void glGetVertexAttribdvNV(Int32 index, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetVertexAttribdvNV((UInt32)index, (int)pname, (Double*)@params);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetVertexAttribfvNV(UInt32 index, int pname, [Out] Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glGetVertexAttribfvNV((UInt32)index, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        public static 
        void glGetVertexAttribfvNV(Int32 index, int pname, [Out] Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Delegates.glGetVertexAttribfvNV((UInt32)index, (int)pname, (Single*)@params_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetVertexAttribfvNV(UInt32 index, int pname, [Out] out Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glGetVertexAttribfvNV((UInt32)index, (int)pname, (Single*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetVertexAttribfvNV(Int32 index, int pname, [Out] out Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Delegates.glGetVertexAttribfvNV((UInt32)index, (int)pname, (Single*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetVertexAttribfvNV(UInt32 index, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetVertexAttribfvNV((UInt32)index, (int)pname, (Single*)@params);
            }
        }

        public static 
        void glGetVertexAttribfvNV(Int32 index, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetVertexAttribfvNV((UInt32)index, (int)pname, (Single*)@params);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetVertexAttribivNV(UInt32 index, int pname, [Out] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetVertexAttribivNV((UInt32)index, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        public static 
        void glGetVertexAttribivNV(Int32 index, int pname, [Out] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Delegates.glGetVertexAttribivNV((UInt32)index, (int)pname, (Int32*)@params_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetVertexAttribivNV(UInt32 index, int pname, [Out] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetVertexAttribivNV((UInt32)index, (int)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        public static 
        void glGetVertexAttribivNV(Int32 index, int pname, [Out] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Delegates.glGetVertexAttribivNV((UInt32)index, (int)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetVertexAttribivNV(UInt32 index, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetVertexAttribivNV((UInt32)index, (int)pname, (Int32*)@params);
            }
        }

        public static 
        void glGetVertexAttribivNV(Int32 index, int pname, [Out] IntPtr @params)
        {
            unsafe
            {
                Delegates.glGetVertexAttribivNV((UInt32)index, (int)pname, (Int32*)@params);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetVertexAttribPointervNV(UInt32 index, int pname, [Out] IntPtr pointer)
        {
            unsafe
            {
                Delegates.glGetVertexAttribPointervNV((UInt32)index, (int)pname, (IntPtr)pointer);
            }
        }

        public static 
        void glGetVertexAttribPointervNV(Int32 index, int pname, [Out] IntPtr pointer)
        {
            unsafe
            {
                Delegates.glGetVertexAttribPointervNV((UInt32)index, (int)pname, (IntPtr)pointer);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glGetVertexAttribPointervNV(UInt32 index, int pname, [In, Out] object pointer)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle pointer_ptr = System.Runtime.InteropServices.GCHandle.Alloc(pointer, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glGetVertexAttribPointervNV((UInt32)index, (int)pname, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
            }
        }

        public static 
        void glGetVertexAttribPointervNV(Int32 index, int pname, [In, Out] object pointer)
        {
            unsafe
            {
                System.Runtime.InteropServices.GCHandle pointer_ptr = System.Runtime.InteropServices.GCHandle.Alloc(pointer, System.Runtime.InteropServices.GCHandleType.Pinned);
                try
                {
                    Delegates.glGetVertexAttribPointervNV((UInt32)index, (int)pname, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    pointer_ptr.Free();
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        bool glIsProgramNV(UInt32 id)
        {
            return Delegates.glIsProgramNV((UInt32)id);
        }

        public static 
        bool glIsProgramNV(Int32 id)
        {
            return Delegates.glIsProgramNV((UInt32)id);
        }

        [System.CLSCompliant(false)]
        public static 
        void glLoadProgramNV(int target, UInt32 id, Int32 len, Byte[] program)
        {
            unsafe
            {
                fixed (Byte* program_ptr = program)
                {
                    Delegates.glLoadProgramNV((int)target, (UInt32)id, (Int32)len, (Byte*)program_ptr);
                }
            }
        }

        public static 
        void glLoadProgramNV(int target, Int32 id, Int32 len, Byte[] program)
        {
            unsafe
            {
                fixed (Byte* program_ptr = program)
                {
                    Delegates.glLoadProgramNV((int)target, (UInt32)id, (Int32)len, (Byte*)program_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glLoadProgramNV(int target, UInt32 id, Int32 len, ref Byte program)
        {
            unsafe
            {
                fixed (Byte* program_ptr = &program)
                {
                    Delegates.glLoadProgramNV((int)target, (UInt32)id, (Int32)len, (Byte*)program_ptr);
                }
            }
        }

        public static 
        void glLoadProgramNV(int target, Int32 id, Int32 len, ref Byte program)
        {
            unsafe
            {
                fixed (Byte* program_ptr = &program)
                {
                    Delegates.glLoadProgramNV((int)target, (UInt32)id, (Int32)len, (Byte*)program_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glLoadProgramNV(int target, UInt32 id, Int32 len, IntPtr program)
        {
            unsafe
            {
                Delegates.glLoadProgramNV((int)target, (UInt32)id, (Int32)len, (Byte*)program);
            }
        }

        public static 
        void glLoadProgramNV(int target, Int32 id, Int32 len, IntPtr program)
        {
            unsafe
            {
                Delegates.glLoadProgramNV((int)target, (UInt32)id, (Int32)len, (Byte*)program);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glProgramParameter4dNV(int target, UInt32 index, Double x, Double y, Double z, Double w)
        {
            Delegates.glProgramParameter4dNV((int)target, (UInt32)index, (Double)x, (Double)y, (Double)z, (Double)w);
        }

        public static 
        void glProgramParameter4dNV(int target, Int32 index, Double x, Double y, Double z, Double w)
        {
            Delegates.glProgramParameter4dNV((int)target, (UInt32)index, (Double)x, (Double)y, (Double)z, (Double)w);
        }

        [System.CLSCompliant(false)]
        public static 
        void glProgramParameter4dvNV(int target, UInt32 index, Double[] v)
        {
            unsafe
            {
                fixed (Double* v_ptr = v)
                {
                    Delegates.glProgramParameter4dvNV((int)target, (UInt32)index, (Double*)v_ptr);
                }
            }
        }

        public static 
        void glProgramParameter4dvNV(int target, Int32 index, Double[] v)
        {
            unsafe
            {
                fixed (Double* v_ptr = v)
                {
                    Delegates.glProgramParameter4dvNV((int)target, (UInt32)index, (Double*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glProgramParameter4dvNV(int target, UInt32 index, ref Double v)
        {
            unsafe
            {
                fixed (Double* v_ptr = &v)
                {
                    Delegates.glProgramParameter4dvNV((int)target, (UInt32)index, (Double*)v_ptr);
                }
            }
        }

        public static 
        void glProgramParameter4dvNV(int target, Int32 index, ref Double v)
        {
            unsafe
            {
                fixed (Double* v_ptr = &v)
                {
                    Delegates.glProgramParameter4dvNV((int)target, (UInt32)index, (Double*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glProgramParameter4dvNV(int target, UInt32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glProgramParameter4dvNV((int)target, (UInt32)index, (Double*)v);
            }
        }

        public static 
        void glProgramParameter4dvNV(int target, Int32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glProgramParameter4dvNV((int)target, (UInt32)index, (Double*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glProgramParameter4fNV(int target, UInt32 index, Single x, Single y, Single z, Single w)
        {
            Delegates.glProgramParameter4fNV((int)target, (UInt32)index, (Single)x, (Single)y, (Single)z, (Single)w);
        }

        public static 
        void glProgramParameter4fNV(int target, Int32 index, Single x, Single y, Single z, Single w)
        {
            Delegates.glProgramParameter4fNV((int)target, (UInt32)index, (Single)x, (Single)y, (Single)z, (Single)w);
        }

        [System.CLSCompliant(false)]
        public static 
        void glProgramParameter4fvNV(int target, UInt32 index, Single[] v)
        {
            unsafe
            {
                fixed (Single* v_ptr = v)
                {
                    Delegates.glProgramParameter4fvNV((int)target, (UInt32)index, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glProgramParameter4fvNV(int target, Int32 index, Single[] v)
        {
            unsafe
            {
                fixed (Single* v_ptr = v)
                {
                    Delegates.glProgramParameter4fvNV((int)target, (UInt32)index, (Single*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glProgramParameter4fvNV(int target, UInt32 index, ref Single v)
        {
            unsafe
            {
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glProgramParameter4fvNV((int)target, (UInt32)index, (Single*)v_ptr);
                }
            }
        }

        public static 
        void glProgramParameter4fvNV(int target, Int32 index, ref Single v)
        {
            unsafe
            {
                fixed (Single* v_ptr = &v)
                {
                    Delegates.glProgramParameter4fvNV((int)target, (UInt32)index, (Single*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glProgramParameter4fvNV(int target, UInt32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glProgramParameter4fvNV((int)target, (UInt32)index, (Single*)v);
            }
        }

        public static 
        void glProgramParameter4fvNV(int target, Int32 index, IntPtr v)
        {
            unsafe
            {
                Delegates.glProgramParameter4fvNV((int)target, (UInt32)index, (Single*)v);
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glProgramParameters4dvNV(int target, UInt32 index, UInt32 count, Double[] v)
        {
            unsafe
            {
                fixed (Double* v_ptr = v)
                {
                    Delegates.glProgramParameters4dvNV((int)target, (UInt32)index, (UInt32)count, (Double*)v_ptr);
                }
            }
        }

        public static 
        void glProgramParameters4dvNV(int target, Int32 index, Int32 count, Double[] v)
        {
            unsafe
            {
                fixed (Double* v_ptr = v)
                {
                    Delegates.glProgramParameters4dvNV((int)target, (UInt32)index, (UInt32)count, (Double*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glProgramParameters4dvNV(int target, UInt32 index, UInt32 count, ref Double v)
        {
            unsafe
            {
                fixed (Double* v_ptr = &v)
                {
                    Delegates.glProgramParameters4dvNV((int)target, (UInt32)index, (UInt32)count, (Double*)v_ptr);
                }
            }
        }

        public static 
        void glProgramParameters4dvNV(int target, Int32 index, Int32 count, ref Double v)
        {
            unsafe
            {
                fixed (Double* v_ptr = &v)
                {
                    Delegates.glProgramParameters4dvNV((int)target, (UInt32)index, (UInt32)count, (Double*)v_ptr);
                }
            }
        }

        [System.CLSCompliant(false)]
        public static 
        void glProgramParameters4dvNV(int target, UInt32 index, UInt32 count, IntPtr v)
        {
            unsafe
            {
                Delegates.glProgramParameters4dvNV((int)target, (UInt32)index, (UInt32)count, (Double*)v);
            }
        }

        public static 
        void glProgramParameters4dvNV(int target, Int32 index, Int32 count, IntPtr v)
        {
            unsafe
            {
      