/* file def.h SYMMETRICA */
/* INT should always be 4 byte */
#ifndef DEF_H

/* POSIX says that inttypes.h includes stdint.h */
#include <inttypes.h>
typedef int32_t INT;
typedef uint32_t UINT;

#define PRIINT PRId32
#define SCNINT SCNd32

#define PRIUINT PRIu32
#define SCNUINT SCNu32

#include <stdio.h>
#include <memory.h>
#include <stdlib.h>

#ifndef TITELTEXT
#define TITELTEXT " Thu Feb 26 14:58:10 MET 1998 "
#endif


# define	NO_REDUCE		(INT)0		/*	TPMcD	*/
# define	POWER_REDUCE	(INT)1		/*	TPMcD	*/
# define	STD_BASIS		(INT)2		/*	TPMcD	*/


#ifdef ULTRIX
#define unix
#include <malloc.h>
#endif /* ULTRIX */

#undef TRUE
#undef FALSE
#define REPORT (INT)3
#define TRUE (INT)1
#define FALSE (INT)0

#define OK (INT)0
#define ERROR (INT)-1
#define ERROR_RETRY (INT)-5 /* AK 020294 */
#define ERROR_EXPLAIN (INT)-6 /* AK 250195 */

/* exit values of symmetrica, parameters to exit */
#define ERROR_BACKGROUND (int) 101 /* AK 210297 */ /* error called while in background mode */
#define ERROR_TIMELIMIT (int) 100 /* AK 210297 */ /* time limit */

#define I2PE (INT)1502960 /* 2 equal parameter */
#define not !
#define IMPROPER (INT)1001 /* MD */
#define NONCOMPARABLE (INT)10

#define FIRSTVARINDEX (INT)11125
#define VARTYP (INT)11124
#define LETTERS (INT)11122
#define NUMERICAL (INT)11223

#define EQUAL (INT)300792 /* return value of check_equal_ */
#define NORESULT (INT)20996 /* return value of check_result_ */
#define FREE (char)1
#define NOFREE (char)0

#define t_SQRAD_CYCLO convert_sqrad_cyclo


/* definitionen fuer object.c */
/* NOTE: partition code assumes that there is no unused space in the
 * object struct when an INT is stored. This requires both OBJECTKIND
 * and OBJECTSELF to have a size equal to a machine word. */
typedef intptr_t OBJECTKIND;

#define PRIOBJECTKIND PRIdPTR

typedef union {
	intptr_t ob_INT;
	INT * ob_INTpointer;
	char *ob_charpointer;
	struct bruch *ob_bruch;
	struct graph *ob_graph;
	struct list *ob_list;
	struct longint *ob_longint;
	struct matrix *ob_matrix;
	struct monom *ob_monom;
	struct number *ob_number; /* MD */
	struct partition *ob_partition;
	struct permutation *ob_permutation;
	struct reihe *ob_reihe;
	struct skewpartition *ob_skewpartition;
	struct symchar *ob_symchar;
	struct tableaux *ob_tableaux;
	struct vector *ob_vector;
	} OBJECTSELF;


struct object { OBJECTKIND ob_kind; OBJECTSELF ob_self; };

typedef struct object * OP;

/* die verschiedenen typen */

#define INVISIBLE (OBJECTKIND)-2 /* 110102 */
#define INFREELIST (OBJECTKIND)-1 /* 210995 */
#define EMPTY (OBJECTKIND)0 /* 290590 */
#define INTEGER (OBJECTKIND)1
#define VECTOR (OBJECTKIND)2
#define PARTITION (OBJECTKIND)3
#define BRUCH (OBJECTKIND)4
#define FRACTION (OBJECTKIND)4
#define PERMUTATION (OBJECTKIND)6
#define SKEWPARTITION (OBJECTKIND)7  /* 020488 */
#define TABLEAUX (OBJECTKIND)8  /* 020488 */
#define POLYNOM (OBJECTKIND)9
#define SCHUR (OBJECTKIND)10
#define MATRIX (OBJECTKIND)11
#define AUG_PART (OBJECTKIND)12
#define HOM_SYM (OBJECTKIND)13
#define HOMSYM (OBJECTKIND)13
#define SCHUBERT (OBJECTKIND)14
#define INTEGERVECTOR (OBJECTKIND)15
#define INTEGER_VECTOR (OBJECTKIND)15
#define INTVECTOR (OBJECTKIND)15
#define INT_VECTOR (OBJECTKIND)15
#define KOSTKA (OBJECTKIND)16
#define INTINT (OBJECTKIND)17	/* nur fuer test-zwecke */
#define SYMCHAR (OBJECTKIND)18
#define WORD (OBJECTKIND)19
#define LIST (OBJECTKIND)20 /* 210688 */
#define MONOM (OBJECTKIND)21 /*230688*/
#define LONGINT (OBJECTKIND)22 /* 170888 */
#define GEN_CHAR (OBJECTKIND)23 /* 280888  nur fuer test-zwecke */
#define BINTREE (OBJECTKIND)24 /* 291288 */
#define GRAPH (OBJECTKIND)25 /* 210889 */
#define COMPOSITION (OBJECTKIND)26 /* 300889 */
#define KRANZTYPUS (OBJECTKIND)27 /* 280390 */
#define POW_SYM (OBJECTKIND)28
#define POWSYM (OBJECTKIND)28
#define MONOMIAL (OBJECTKIND)29  /* 090992 */
#define BTREE (OBJECTKIND)30
#define KRANZ (OBJECTKIND)31
#define GRAL (OBJECTKIND)32 /* 200691 */
#define GROUPALGEBRA (OBJECTKIND)32 /* 170693 */
#define ELM_SYM (OBJECTKIND)33  /* 090992 */
#define ELMSYM (OBJECTKIND)33  /* 090992 */
#define FINITEFIELD (OBJECTKIND) 35 /* 250193 */
#define FF (OBJECTKIND) 35 /* 250193 */
#define REIHE (OBJECTKIND) 36 /* 090393 */
#define CHARPARTITION (OBJECTKIND) 37 /* 130593 */ /* internal use */
#define CHAR_AUG_PART (OBJECTKIND) 38 /* 170593 */ /* internal use */
#define INTEGERMATRIX (OBJECTKIND)40 /* AK 141293 */
#define CYCLOTOMIC (OBJECTKIND) 41 /* MD */
#define MONOPOLY (OBJECTKIND) 42 /* MD */
#define SQ_RADICAL (OBJECTKIND) 43 /* MD */
#define BITVECTOR (OBJECTKIND) 44 
#define LAURENT (OBJECTKIND)45
#define SUBSET (OBJECTKIND)47 /* AK 220997 */

#define FASTPOLYNOM (OBJECTKIND)211093
#define EXPONENTPARTITION (OBJECTKIND)240298
#define SKEWTABLEAUX (OBJECTKIND)20398
#define PARTTABLEAUX (OBJECTKIND)10398
#define BARPERM (OBJECTKIND)230695

#define REVERSEPARTITION (OBJECTKIND)150703 /* only for input */


#define PERMVECTOR (OBJECTKIND)180998
#define PERM_VECTOR (OBJECTKIND)180998
#define PERMUTATIONVECTOR (OBJECTKIND)180998
#define PERMUTATION_VECTOR (OBJECTKIND)180998

#define INTEGERBRUCH (OBJECTKIND)220998
#define INTEGER_BRUCH (OBJECTKIND)220998
#define INTEGERFRACTION (OBJECTKIND)220998
#define INTEGER_FRACTION (OBJECTKIND)220998
#define HASHTABLE  (OBJECTKIND)120199

#define QUEUE  (OBJECTKIND)251103

#define GALOISRING (OBJECTKIND)211106

#define ANYTYPE (OBJECTKIND)201201  /* for tracing, checking */
#define INTTYPE (OBJECTKIND)020102  /* for tracing, checking */

#ifdef DGUX
#define signed 
#endif /* DGUX */

#ifdef sun
#define signed 
#endif
#ifdef         hpux
#define signed 
#endif



struct loc
{ 
   INT w2,w1,w0;
   struct loc *nloc;
  };

struct longint
{
   struct loc *floc;
   signed char signum; /* -1,0,+1 */
   INT laenge;
};

#define GANZSIGNUM(x) ((x)->signum) /* AK 051294 */
#define GANZLAENGE(x) ((x)->laenge) 
#define GANZNEG(x) ( (x)->signum = -(x)->signum)




struct ganzdaten
{
   INT basis,basislaenge,auspos,auslaenge,auszz;
   char folgezeichen;
};

struct zahldaten
{
   char ziffer[13];
   INT mehr;
   INT  ziffernzahl;
   struct loc  *fdez;
};


struct vector { OP v_length; OP v_self; };

struct REIHE_variablen {
  INT index;
  INT potenz;
  struct REIHE_variablen *weiter; };

struct REIHE_mon {
  OP coeff;
  struct REIHE_variablen *zeiger;
  struct REIHE_mon *ref; };

struct REIHE_poly {
  INT grad;
  struct REIHE_mon *unten;
  struct REIHE_poly *rechts; };

struct reihe {
  INT exist;
  INT reihenart;        /* Werte: -1,0,1 */
  INT z;                /* bei Operationen pot und transform */
  struct reihe *x,*y;   /* Zeiger auf Ursprung bei Verknuepfung */
  struct reihe *p;      /* zeigt auf Potenzenliste */
  INT (*eingabefkt)(); /* zeiger auf Eingabefunktion */
  char ope;                  /* Operation */
  struct REIHE_poly *infozeig; };  /* Zeiger auf Reihenglieder */


typedef struct reihe* REIHE_zeiger;


struct list { OP l_self; OP l_next; };

struct partition { OBJECTKIND pa_kind; OP pa_self; INT pa_hash;
  /* AK 240901 */ /* hashwert -1 falls nicht berechnet */ };
#define LASTPARTITION 1234
#define EXPONENT (OBJECTKIND)88
#define FROBENIUS (OBJECTKIND)92
#define LASTCOMP 1234L
#define LASTSUBSET 1234L
#define LAST_SUBSET 1234L

struct permutation { OBJECTKIND p_kind; OP p_self; };
#define LASTLEHMERCODE 12L
#define LASTPERMUTATION 13L
#define LAST_PERMUTATION 13L
#define LAST_FF (INT)170194
#define LASTSHUFFLE 12048802L
#define ZYKEL (OBJECTKIND)40888	/* fuer zykelschreibweise */
#define BITREC (OBJECTKIND)230195	/* fuer bitvector rectrice */
#define BAR (OBJECTKIND)25		/* AK 260292 fuer barred perm */
#define BARCYCLE (OBJECTKIND)26		/* AK 260292 fuer barred perm */

struct monom { OP mo_self;  OP mo_koeff;  };

struct bruch { OP b_oben; OP b_unten; INT b_info; };
#define GEKUERZT 40892L
#define NGEKUERZT 408921L

struct matrix { OP m_length; OP m_height; OP m_self; INT m_hash; };
#define SINGULAER 2903884

struct skewpartition { OP spa_gross; OP spa_klein; };

struct tableaux { OP t_umriss;  OP t_self; };

struct symchar{ OP sy_werte; OP sy_parlist; OP sy_dimension; };

struct graph {  OBJECTKIND gr_kind; OP   gr_self; };
#define NACHBARLISTE (OBJECTKIND) 1

typedef struct { OP index, deg, poly, autos; } CYCLO_DATA; /* MD */
typedef struct { OP index, deg, poly; } FIELD_DATA; /* MD */
union data { CYCLO_DATA *c_data; FIELD_DATA *f_data; OP o_data; } ; /* MD */
struct number { OP n_self; union data n_data; };  /* MD */

/* return value fuer insert */
#define INSERTEQ 301288  /* falls eq */
#define INSERTOK 3012881  /* falls insert */

#define BINOMLIMIT 13
extern INT binom_values[BINOMLIMIT][BINOMLIMIT];

#ifdef ALLTRUE
#define INTEGERTRUE 1
#define VECTORTRUE 1
#define PARTTRUE 1
#define PERMTRUE 1
#define LONGINTTRUE 1
#define MATRIXTRUE 1
#define SCHURTRUE 1
#define HOMSYMTRUE 1
#define POWSYMTRUE 1
#define ELMSYMTRUE 1
#define MONOMIALTRUE 1
#define BRUCHTRUE 1
#define CHARTRUE 1
#define KOSTKATRUE 1
#define SCHUBERTTRUE 1
#define SHUFFLETRUE 1
#define SKEWPARTTRUE 1
#define TABLEAUXTRUE 1
#define WORDTRUE 1
#define KRANZTRUE 1
#define BINTREETRUE 1
#define MONOPOLYTRUE 1
#define SQRADTRUE 1
#define CYCLOTRUE 1
#define NUMBERTRUE 1
#define DGTRUE 1
#define WTTRUE 1
#define SABTRUE 1
#define PLETTRUE 1
#define ZONALTRUE 1
#define GRALTRUE 1
#define FFTRUE 1
#define REIHETRUE 1
#define POLYTRUE 1
#define LAURENTTRUE 1
#define GRTRUE 1
#endif

#ifdef FFTRUE
#define VECTORTRUE 1
#endif

#ifdef GRTRUE
#define VECTORTRUE 1
#endif

#ifdef POLYTRUE 
#define VECTORTRUE 1
#endif

#ifdef DGTRUE
#define SABTRUE 1
/* for gl-m reps */
#define MATRIXTRUE 1
#define CHARTRUE 1
#define PARTTRUE 1
#define NUMBERTRUE 1
#define TABLEAUXTRUE 1
#endif

#ifdef ZONALTRUE
#define KOSTKATRUE 1
#define CHARTRUE 1
#define MATRIXTRUE 1
#define POLYTRUE 1
#define PARTTRUE 1
#endif

#ifdef NUMBERTRUE
#define INTEGERTRUE 1
#define BRUCHTRUE 1
#define LISTTRUE 1
#define MONOMTRUE 1
#define SQRADTRUE 1
#define CYCLOTRUE 1
#define MONOPOLYTRUE 1
#endif

#ifdef PLETTRUE
#define SCHURTRUE 1
#define MATRIXTRUE 1
#define TABLEAUXTRUE 1
#define CHARTRUE 1
#endif

#ifdef SKEWPARTTRUE
#define PARTTRUE 1
#endif 

#ifdef KOSTKATRUE
#define MATRIXTRUE 1
#define SCHURTRUE 1
#endif

#ifdef CHARTRUE
#define INTEGERTRUE 1
#define LONGINTTRUE 1
#define VECTORTRUE 1
#define PARTTRUE 1
#define MATRIXTRUE 1
#define SCHURTRUE 1
#define BRUCHTRUE 1
#define KOSTKATRUE 1
#define NUMBERTRUE 1
#define SQRADTRUE 1
#define CYCLOTRUE 1
#define MONOPOLYTRUE 1
#endif

#ifdef SCHUBERTTRUE
#define POLYTRUE 1
#define PARTTRUE 1
#define PERMTRUE 1
#define VECTORTRUE 1
#define INTEGERTRUE 1
#endif


#ifdef TABLEAUXTRUE
#define WORDTRUE 1
#define VECTORTRUE 1
#define MATRIXTRUE 1
#endif

#ifdef SCHURTRUE
#define BINTREETRUE 1
#define POLYTRUE 1
#define PARTTRUE 1
#define PERMTRUE 1
#define INTEGERTRUE 1
#define VECTORTRUE 1
#define SKEWPARTTRUE 1
#endif

#ifdef BINTREETRUE
#define INTEGERTRUE 1
#endif

#ifdef POLYTRUE
#define LISTTRUE 1
#define MONOMTRUE 1
#define VECTORTRUE 1
#endif

#ifdef PERMTRUE
#define PARTTRUE 1
#define INTEGERTRUE 1
#define VECTORTRUE 1
#endif
#ifdef PARTTRUE
#define INTEGERTRUE 1
#define VECTORTRUE 1
#endif

#ifdef VECTORTRUE
#define INTEGERTRUE 1
#endif



extern INT no_mem_check;
extern INT sym_no_results;     /* 0 == stored results will be used */
                        /* 1 == stored results will not be used */
extern OP cons_eins;
extern OP cons_negeins;
extern OP cons_null;
extern OP cons_zwei;
extern OP cons_drei;
extern FILE *texout;
extern INT (*check_time_co)();
extern INT zeilenposition; /* position inside one row of stdout output */
extern INT row_length; /* length of one outputrow */
extern INT tex_row_length; /* length of one tex outputrow */
extern INT integer_format; /* if > 0  number of positions for INTEGER 
				output */
extern INT english_tableau;
extern INT no_banner;
extern INT kuerzen_yn;
extern INT texmath_yn; /* 1 in mathmode */ /* 0 not in mathmode */
extern INT scanoutput_yn; /* 1 no output */ /* 0 bitte output */
extern INT texposition;
extern INT doffset; /* AK 160393 */
extern INT sym_background;
extern INT sym_www;
extern INT sym_timelimit;

extern INT freeall_speicherposition;/* global variable for callocobject/freeall */
extern INT freeall_speichersize;/* global variable for callocobject/freeall */
extern OP *freeall_speicher; /* global variable for callocobject/freeall */


extern int SYM_free();
extern char*  SYM_malloc();
extern char*  SYM_realloc();
extern char*  SYM_calloc();
#define SPEICHERSIZE (INT)10000
extern INT freeall_speichersize_max; /* global variable
                                        for managment of object space */

#ifdef LONGINTTRUE
extern struct ganzdaten gd; /* a global datastructure */
#endif

#define div SYM_div

#define DEF_H


/* from here automatically generated */
extern INT absolute();
extern INT absolute_bruch();
extern INT absolute_integervector();
extern INT absolute_longint();
extern INT absolute_matrix();
extern INT absolute_vector();
extern INT a_charvalue_co();
extern INT a_charvalue();
extern INT add();
extern INT add_adjacency_matrix();
extern INT add_apply();
extern INT add_apply_bruch();
extern INT add_apply_bruch_bruch();
extern INT add_apply_bruch_bruch_pre261101();
extern INT add_apply_bruch_integer();
extern INT add_apply_bruch_scalar();
extern INT add_apply_cyclo();
extern INT add_apply_default();
extern INT add_apply_ff();
extern INT add_apply_gral();
extern INT add_apply_gral_gral();
extern INT add_apply_hashtable();
extern INT add_apply_hashtable();
extern INT add_apply_integer();
extern INT add_apply_integer_bruch();
extern INT add_apply_integer_integer();
extern INT add_apply_integer_longint();
extern INT add_apply_integervector();
extern INT add_apply_laurent();
extern INT add_apply_longint();
extern INT add_apply_longint_integer();
extern INT add_apply_longint_longint();
extern INT add_apply_matrix();
extern INT add_apply_matrix_matrix();
extern INT add_apply_monopoly();
extern INT add_apply_polynom();
extern INT add_apply_polynom_polynom();
extern INT add_apply_polynom_scalar();
extern INT add_apply_polynom_schubert();
extern INT add_apply_reihe();
extern INT add_apply_scalar_bruch();
extern INT add_apply_scalar_polynom();
extern INT add_apply_schubert();
extern INT add_apply_schubert_schubert();
extern INT add_apply_sqrad();
extern INT add_apply_symchar();
extern INT add_apply_symfunc();
extern INT add_apply_symfunc_symfunc();
extern INT add_apply_vector();
extern INT add_bruch();
extern INT add_bruch_bruch();
extern INT add_bruch_integer();
extern INT add_bruch_scalar();
extern INT add_cyclo();
extern INT add_cyclo_cyclo();
extern INT add_elmsym();
extern INT add_elmsym_elmsym();
extern INT add_ff();
extern INT add_galois();
extern INT add_homsym();
extern INT add_homsym_homsym();
extern INT add_integer();
extern INT add_integer_integer();
extern INT add_integer_longint();
extern INT add_integervector();
extern INT addinvers_apply();
extern INT addinvers_apply_bruch();
extern INT addinvers_apply_cyclo();
extern INT addinvers_apply_elmsym();
extern INT addinvers_apply_ff();
extern INT addinvers_apply_galois();
extern INT addinvers_apply_hashtable();
extern INT addinvers_apply_homsym();
extern INT addinvers_apply_integer();
extern INT addinvers_apply_laurent();
extern INT addinvers_apply_longint();
extern INT addinvers_apply_monom();
extern INT addinvers_apply_monomial();
extern INT addinvers_apply_monopoly();
extern INT addinvers_apply_polynom();
extern INT addinvers_apply_powsym();
extern INT addinvers_apply_schur();
extern INT addinvers_apply_sqrad();
extern INT addinvers_apply_symchar();
extern INT addinvers_apply_vector();
extern INT addinvers();
extern INT addinvers_bruch();
extern INT addinvers_cyclo();
extern INT addinvers_ff();
extern INT addinvers_integer();
extern INT addinvers_longint();
extern INT addinvers_matrix();
extern INT addinvers_monom();
extern INT addinvers_monopoly();
extern INT addinvers_polynom();
extern INT addinvers_reihe();
extern INT addinvers_sqrad();
extern INT addinvers_symchar();
extern INT addinvers_vector();
extern INT add_koeff();
extern INT add_laurent();
extern INT add_longint();
extern INT add_longint_integer();
extern INT add_longint_longint();
extern INT add_matrix();
extern INT add_matrix_matrix();
extern INT add_monom();
extern INT add_monomial();
extern INT add_monomial_monomial();
extern INT add_monom_schur();
extern INT add_monopoly();
extern INT add_monopoly_monopoly();
extern INT add_partition();
extern INT add_part_part();
extern INT add_polynom();
extern INT add_polynom_polynom();
extern INT add_powsym();
extern INT add_powsym_powsym();
extern INT add_reihe();
extern INT add_scalar_cyclo();
extern INT add_scalar_monopoly();
extern INT add_scalar_polynom();
extern INT add_scalar_sqrad();
extern INT add_schubert();
extern INT add_schubert_schubert();
extern INT add_schur();
extern INT add_schur_schur();
extern INT add_sqrad();
extern INT add_sqrad_sqrad();
extern INT add_staircase_part();
extern INT add_symchar();
extern INT addtoallvectorelements();
extern INT add_vector();
extern INT ak_make_alt_classes();
extern INT ak_make_alt_partitions();
extern INT ak_plet_phm_integer_partition_();
extern INT all_01_matrices();
extern INT allclasses();
extern INT allclasssums();
extern INT all_codes();
extern INT all_codes();
extern INT all_codes_neu();
extern INT alle_teiler();
extern INT all_inj_codes();
extern INT all_inj_codes();
extern INT all_irred_polynomials();
extern INT allkostka();
extern INT all_lines();
extern INT all_lyndon_words();
extern INT all_orbits_set_rankf();
extern INT all_orbits_set_trace();
extern INT all_orbits_unset_rankf();
extern INT all_orbits_unset_trace();
extern INT all_orbits();
extern INT all_plactic_word();
extern INT all_points();
extern INT all_points_phg();
extern INT all_points_phg();
extern INT all_ppoly();
extern INT all_weintrauben();
extern INT alt_dimension();
extern INT alt_odg_trafo();
extern INT alt_sdg_trafo();
extern INT anfang();
extern INT an_odg();
extern INT an_rz_perm();
extern INT an_sdg();
extern INT an_tafel();
extern INT an_trafo_odg();
extern INT an_trafo_sdg();
extern INT append();
extern INT append_apply();
extern INT append_apply_part();
extern INT append_apply_vector();
extern INT append_behind_matrix_matrix();
extern INT append_below_matrix_matrix();
extern INT append_column_matrix();
extern INT append_part_part();
extern INT append_vector();
extern INT apply_INJDT();
extern INT augpart();
extern INT bar_rectr();
extern INT basis_mod_dg();
extern INT bdg();
extern INT b_d_sc();
extern INT bestimme_D();
extern INT bestimme_D();
extern INT bestimme_fixpunkt();
extern INT bestimme_konjugiertenklasse();
extern INT bestimme_zufallsmatrizen();
extern INT bestimme_zufallsmatrizen();
extern INT b_gk_spa();
extern INT bideterminant();
extern INT bideterminant_tableaux();
extern INT bideterminant_vector();
extern INT bilde_htupel();
extern INT bilde_htupel();
extern INT bin_ggt();
extern INT binom();
extern INT binom_small();
extern INT binom_small();
extern INT binom_small();
extern INT b_i_pa();
extern INT bit();
extern INT bit_longint();
extern INT b_kl_pa();
extern INT b_ksd_n();
extern INT b_ks_o();
extern INT b_ks_pa();
extern INT b_ks_p();
extern INT b_lh_m();
extern INT b_lh_nm();
extern INT b_lhs_m();
extern INT b_l_nv();
extern INT b_ls_v();
extern INT b_l_v();
extern INT b_matrix_tableaux();
extern INT b_ou_b();
extern INT b_o_v();
extern INT b_pa_mon();
extern INT b_pa_s();
extern INT b_perm_vector_kranz();
extern INT brauer_char();
extern INT brouwerlowerbound();
extern INT brouwerupperbound();
extern INT bruch_anfang();
extern INT bruch_ende();
extern INT bruch_not_scalar();
extern INT bru_comp();
extern INT bruhat_comp_perm();
extern INT bruhat_ideal();
extern INT bruhat_ideal_strong();
extern INT bruhat_ideal_weak();
extern INT bruhat_interval_strong();
extern INT bruhat_interval_weak();
extern INT bruhat_rank_function();
extern INT b_scalar_elmsym();
extern INT b_scalar_homsym();
extern INT b_scalar_monomial();
extern INT b_scalar_powsym();
extern INT b_scalar_schur();
extern INT b_sk_mo();
extern INT b_skn_mp();
extern INT b_skn_po();
extern INT b_skn_s();
extern INT b_skn_sch();
extern INT b_sn_e();
extern INT b_sn_h();
extern INT b_sn_l();
extern INT b_sn_mon();
extern INT b_sn_po();
extern INT b_sn_ps();
extern INT b_sn_s();
extern INT b_s_po();
extern INT build_gls_dist();
extern INT build_gls_dist();
extern INT build_lc ();
extern INT build_propab_vector();
extern INT b_us_t();
extern INT b_u_t();
extern INT B_W();
extern INT B_W();
extern INT b_wpd_sc();
extern INT calculate_fixed_point_number();
extern OP callocobject();
extern INT callocobject_anfang();
extern INT callocobject_ende();
extern OP callocobject_fast();
extern OP callocobject_magma();
extern INT cardinality_pgkq();
extern INT cast_apply_barperm();
extern INT cast_apply_bruch();
extern INT cast_apply_elmsym();
extern INT cast_apply_ff();
extern INT cast_apply_homsym();
extern INT cast_apply_integer();
extern INT cast_apply();
extern INT cast_apply_matrix();
extern INT cast_apply_monom();
extern INT cast_apply_monomial();
extern INT cast_apply_monopoly();
extern INT cast_apply_part();
extern INT cast_apply_perm();
extern INT cast_apply_polynom();
extern INT cast_apply_powsym();
extern INT cast_apply_schur();
extern INT cast_apply_schubert();
extern INT cast_apply_tableaux();
extern INT cast_elmsym();
extern INT cast_homsym();
extern INT cast_monomial();
extern INT cast_powsym();
extern INT cast_schur();
extern INT c_AUGPART_PARTITION();
extern INT c_b_o();
extern INT c_b_u();
extern INT c_CHARAUGPART_CHARPARTITION();
extern INT c_CHARPARTITION_CHARAUGPART();
extern INT cc_muir_mms_partition_partition_();
extern INT cc_muir_mms_partition_partition_();
extern INT cc_plet_pes_integer_partition();
extern INT cc_plet_phs_integer_partition();
extern INT cc_plet_pss_integer_partition();
extern INT cc_plet_pss_partition_partition();
extern INT Cdeg();
extern INT c_ff_di();
extern INT c_ff_ip();
extern INT Cgen();
extern INT c_gr_k();
extern INT c_gr_s();
extern INT change_column_ij();
extern INT change_row_ij();
extern INT characteristic_polynom_faster();
extern INT characteristic_polynom();
extern INT characteristic_polynom_superfast();
extern INT characteristik_symchar();
extern INT characteristik_to_symchar();
extern INT character_polynom();
extern INT charakteristik_to_ypolynom();
extern INT charge_tableaux();
extern INT charge_word();
extern INT char_matrix_scalar_product();
extern INT chartafel();
extern INT chartafel_bit();
extern INT chartafel_nonbit();
extern INT chartafel_partvector();
extern INT chartafel_symfunc();
extern INT chartafel_symfunc();
extern INT charvalue_bit ();
extern INT charvalue();
extern INT charvalue_tafel_part();
extern INT check_braid ();
extern INT check_commute ();
extern INT check_equal_2a();
extern INT check_equal_2();
extern INT check_equal_3();
extern INT check_equal_4();
extern INT check_hecke_generators ();
extern INT check_hecke_quadratic ();
extern INT check_longint();
extern INT check_result_0();
extern INT check_result_1();
extern INT check_result_2();
extern INT check_result_3();
extern INT check_result_5();
extern INT check_selforthogonal_generatormatrix();
extern INT check_time();
extern INT check_zeilenposition();
extern INT check_zero_matrix ();
extern INT c_i_i();
extern INT c_ijk_sn();
extern INT c_ijk_sn_tafel();
extern INT c_ij_sn();
extern INT c_i_n_an();
extern INT c_i_n();
extern INT c_kr_g();
extern INT c_kr_v();
extern INT class_bar();
extern INT class_label_glnq_co();
extern INT class_label_glnq();
extern INT class_label();
extern INT class_mult();
extern INT class_mult_part_part();
extern INT class_mult_schurmonom();
extern INT class_mult_schur();
extern INT class();
extern INT class_rep_bar();
extern INT class_rep_kranz();
extern INT class_rep();
extern INT c_l_n();
extern INT clone_size_hashtable();
extern INT c_l_s();
extern INT c_m_h();
extern INT c_m_hash();
extern INT c_m_l();
extern INT c_mo_k();
extern INT c_mo_s();
extern INT c_m_s();
extern INT c_n_d();
extern INT c_n_s();
extern INT co_070295();
extern INT code_mod_into_ord2();
extern INT code_mod_into_ord();
extern INT coeff_of_in();
extern INT c_o_k();
extern INT co_k_dimmod();
extern INT columns_standardise_tableau ();
extern INT column_standardise_tableau ();
extern INT columnwordoftableaux();
extern INT comp();
extern INT comp_bigr_bigr();
extern INT comp_bigr_perm();
extern INT comp_bruch();
extern INT comp_bruch_scalar();
extern INT comp_bv();
extern INT comp_colex_part();
extern INT comp_colex_schurmonom();
extern INT comp_colex_vector();
extern INT comp_cyclo();
extern INT comp_ff();
extern INT comp_galois();
extern INT comp_integer();
extern INT comp_integer_integer();
extern INT comp_integermatrix();
extern INT comp_integervector();
extern INT comp_kranztafel();
extern INT complete_complete_plet();
extern INT complete_schur_plet();
extern INT complex_conjugate();
extern INT comp_lex_perm();
extern INT comp_list();
extern INT comp_list_co();
extern INT comp_longint();
extern INT comp_longint_integer();
extern INT comp_matrix();
extern INT comp_monom();
extern INT comp_monomelmsym();
extern INT comp_monomhomsym();
extern INT comp_monommonomial();
extern INT comp_monompowsym();
extern INT comp_monomschur();
extern INT comp_monomvector_monomvector();
extern INT comp_monopoly();
extern INT comp_number();
extern INT comp_numeric_vector();
extern INT comp_partition();
extern INT comp_partition_partition();
extern INT comp_permutation();
extern INT comp_permutation_pol();
extern INT comp_polynom();
extern INT comp_polynom_scalar();
extern INT comp_reihe();
extern INT comp_skewpartition();
extern INT comp_skewpartition_skewpartition();
extern INT comp_sqrad();
extern INT comp_symchar();
extern INT comp_tableaux();
extern INT compute_complete_with_alphabet();
extern INT compute_elmsym_with_alphabet();
extern INT compute_gl_charvalue();
extern INT compute_gl_c_ijk();
extern INT compute_gl_cl_classorder();
extern INT compute_gl_il_dimension();
extern INT compute_monomial_with_alphabet();
extern INT compute_power_with_alphabet();
extern INT compute_schur();
extern INT compute_schur_with_alphabet_det();
extern INT compute_schur_with_alphabet();
extern INT compute_skewschur_with_alphabet_det();
extern INT compute_zonal_with_alphabet();
extern INT comp_vector();
extern INT comp_word();
extern INT conj_cyclo();
extern INT conj_sqrad();
extern INT conjugate();
extern INT conjugate_elmsym();
extern INT conjugate_homsym();
extern INT conjugate_monomial();
extern INT conjugate_partition();
extern INT conjugate_powsym();
extern INT conjugate_schur();
extern INT conjugate_tableaux();
extern INT conjugation();
extern INT consp_polynom();
extern INT contain_comp_part();
extern INT content();
extern INT content_polynom();
extern INT content_tableaux();
extern INT content_word();
extern INT convert_cyclo_scalar();
extern INT convert_radical_cyclo();
extern INT convert_sqrad_cyclo();
extern INT convert_sqrad_scalar();
extern INT co_polya3_sub();
extern INT co_polya_sub();
extern INT copy();
extern INT copy_bintree();
extern INT copy_bitvector();
extern INT copy_bruch();
extern INT copy_composition();
extern INT copy_elmsym();
extern INT copy_ff();
extern INT copy_galois();
extern INT copy_graph();
extern INT copy_hashtable();
extern INT copy_homsym();
extern INT copy_integer();
extern INT copy_integermatrix();
extern INT copy_integervector();
extern INT copy_kranztypus();
extern INT copy_kranz();
extern INT copy_laurent();
extern INT copy_list();
extern INT copy_longint();
extern INT copy_matrix();
extern INT copy_monom();
extern INT copy_monomial();
extern INT copy_number();
extern INT copy_partition();
extern INT copy_permutation();
extern INT copy_polynom();
extern INT copy_powsym();
extern INT copy_queue();
extern INT copy_reihe();
extern INT copy_schur();
extern INT copy_skewpartition();
extern INT copy_subset();
extern INT copy_symchar();
extern INT copy_tableaux();
extern INT copy_vector();
extern INT copy_word();
extern INT c_o_s();
extern INT Cosinus_eingabe();
extern INT co_table_of_R_nkq();
extern INT co_zykelind_pglkq();
extern INT c_pa_hash();
extern INT c_pa_k();
extern INT c_PARTITION_AUGPART();
extern INT c_pa_s();
extern INT c_p_k();
extern INT c_p_s();
extern INT c_sc_d();
extern INT c_sch_n();
extern INT c_sc_p();
extern INT c_sc_w();
extern INT c_s_n();
extern INT c_spa_g();
extern INT c_spa_k();
extern INT c_t_s();
extern INT c_t_u();
extern INT c_v_i();
extern INT c_v_l();
extern INT c_v_s();
extern INT cycliccodes_poly_matrix();
extern INT cyclic_tafel();
extern INT cyclo_an_tafel();
extern INT cyclo_odg();
extern INT debruijn_all_functions();
extern INT debruijn_inj_functions();
extern INT debugprint();
extern INT debugprint_ff();
extern INT debugprint_longint();
extern INT debugprint_object();
extern INT debugprint_reihe();
extern INT dec();
extern INT dec_integer();
extern INT dec_integervector();
extern INT dec_longint();
extern INT decompose_primepower();
extern INT dec_partition();
extern INT dec_permutation();
extern INT decp_mat();
extern INT decreasingp_vector();
extern INT dec_vector();
extern INT degree_monopoly();
extern INT degree_polynom();
extern INT delete_column_matrix();
extern INT delete_entry_vector();
extern INT delete_row_matrix();
extern INT derivative();
extern INT det270588();
extern INT det();
extern INT det_imm_matrix();
extern INT det_mat_imm();
extern INT det_matrix();
extern INT det_mat_tri();
extern INT dg_mp();
extern INT diagramm_permutation();
extern INT dimension_augpart();
extern INT dimension_bit();
extern INT dimension_mod();
extern INT dimension();
extern INT dimension_partition();
extern INT dimension_schubert();
extern INT dimension_schur();
extern INT dimension_skewpartition();
extern INT dimension_symmetrization();
extern INT dimino();
extern INT display();
extern INT display_schubert();
extern INT distanzdiagramm();
extern INT div();
extern INT div_apply();
extern INT div_apply_integer();
extern INT div_default();
extern INT divdiff();
extern INT divdiff_bar();
extern INT divdiff_perm_schubert();
extern INT divdiff_schubert();
extern INT divideddifference_bar();
extern INT divideddifference();
extern INT divideddiff_lc();
extern INT divideddiff_permutation();
extern INT divideddiff_rz_bar();
extern INT divideddiff_rz();
extern INT dixonwilf_bincodes();
extern INT dixonwilf_primcodes();
extern INT dixonwilf_primcodes();
extern INT dixon_wilf_transversal();
extern INT dom_comp_part();
extern INT double_apply();
extern INT double_apply_default();
extern INT double_apply_longint();
extern INT double_hashtable();
extern INT ds_j_wt();
extern INT durfee_size_part();
extern INT dynamicp();
extern INT dz_i_wt();
extern INT E_eingabe();
extern INT eins();
extern INT eins_default();
extern INT eins_ff();
extern INT eins_ff_given_q();
extern INT eins_galois();
extern INT eins_gr_given_c_d();
extern INT einsp();
extern INT einsp_bitvector();
extern INT einsp_bruch();
extern INT einsp_cyclotomic();
extern INT einsp_ff();
extern INT einsp_galois();
extern INT einsp_integer();
extern INT einsp_integervector();
extern INT einsp_kranz();
extern INT einsp_longint();
extern INT einsp_matrix();
extern INT einsp_monopoly();
extern INT einsp_permutation();
extern INT einsp_polynom();
extern INT einsp_reihe();
extern INT einsp_schubert();
extern INT einsp_sqrad();
extern INT einsp_symchar();
extern INT einsp_symfunc();
extern INT einsp_vector();
extern INT elementarp_permutation();
extern INT elementary_schur_plet();
extern INT embedding_mod_into_ord();
extern INT empty_listp();
extern INT empty_object();
extern INT emptyp();
extern INT ende();
extern INT en_forme();
extern INT enter_list_to_matrix ();
extern INT eq();
extern INT eq_cyclotomic();
extern INT eq_fieldobject_int();
extern INT eq_integer();
extern INT eq_integervector_integervector();
extern INT eq_longint_longint();
extern INT eq_matrix();
extern INT eq_monomsymfunc();
extern INT eq_monomsymfunchash();
extern INT eq_partition();
extern INT eq_partition_partition();
extern INT eq_permutation();
extern INT eq_sqrad();
extern INT equal_2_error();
extern INT equal_parts();
extern INT eq_vector();
extern INT eqv();
extern INT error_during_computation_code();
extern INT error_during_computation();
extern INT error();
extern INT ersetze_zeile();
extern INT euler_phi();
extern INT eval_2schubert();
extern INT eval_char_polynom();
extern INT eval_monopoly();
extern INT eval_polynom_dir_prod();
extern INT eval_polynom();
extern INT even();
extern INT even_integer();
extern INT even_longint();
extern INT even_partition();
extern INT even_permutation();
extern INT exchange_alphabets();
extern INT exor_bitvector_apply();
extern INT Exp_eingabe();
extern INT extended_ggt();
extern INT factorize();
extern INT factorize_integer();
extern INT fakul_longintresult();
extern INT fakul();
extern INT fastrectr();
extern INT fatal_error();
extern INT ferrers();
extern INT ferrers_partition();
extern INT ferrers_skewpartition();
extern INT ff_anfang();
extern INT ff_ende();
extern INT fill_left_down_matrix();
extern INT filter_apply_hashtable();
extern INT filter_apply_list();
extern INT filter_list();
extern OP find_1result_hashtable();
extern OP find_2result_hashtable();
extern OP find ();
extern OP find_bintree();
extern INT find_code_given_nkqd();
extern INT find_code_given_nkqd_gen_tim_bou();
extern OP find_hashtable();
extern INT find_knuth_tab_entry();
extern OP findmax_elmsym();
extern OP findmax_homsym();
extern OP findmax_monomial();
extern OP findmax_powsym();
extern OP findmax_schur();
extern OP findmax_vector();
extern OP findmin_elmsym();
extern OP findmin_homsym();
extern OP findmin_monomial();
extern OP findmin_powsym();
extern OP findmin_schur();
extern OP find_monomial();
extern INT find_non_root_standard_pos ();
extern INT find_non_rowstandard_pos ();
extern OP find_schur();
extern INT find_tab_entry();
extern OP find_teh_integer();
extern OP find_teh_integer();
extern OP find_tem_integer();
extern OP find_tep_integer();
extern OP find_tep_integer();
extern OP find_the_integer();
extern OP find_thm_integer();
extern OP find_thp_integer();
extern OP find_thp_integer();
extern OP find_tme_integer();
extern OP find_tme_integer();
extern OP find_tmh_integer();
extern OP find_tmh_integer();
extern OP find_tmh_integer();
extern OP find_tpe_integer();
extern OP find_tph_integer();
extern OP find_user_bintree();
extern OP find_vector();
extern INT first_bar();
extern INT first_composition();
extern INT first_ff();
extern INT first_ff_given_q();
extern INT first_gfp_vector();
extern INT first_gfp_vector();
extern INT first_gr_given_c_d();
extern INT first();
extern INT first_kranztypus();
extern INT first_lehmercode();
extern INT first_lex_tableaux();
extern INT first_part_EXPONENT();
extern INT first_partition();
extern INT first_part_VECTOR();
extern INT first_perm_n_invers();
extern INT first_permutation();
extern INT first_pgp_vector();
extern INT first_pgp_vector();
extern INT first_prime_factor();
extern INT first_subset();
extern INT first_tableaux();
extern INT first_tab_perm();
extern INT fprint_bintree();
extern INT fprint_bitvector();
extern INT fprint_bm();
extern INT fprint_bruch();
extern INT fprint_ff();
extern INT fprint_graph();
extern INT fprint_hashtable();
extern INT fprint_integer();
extern INT fprint_list();
extern INT fprintln();
extern INT fprint_longint();
extern INT fprint_matrix();
extern INT fprint_monom();
extern INT fprint_number();
extern INT fprint();
extern INT fprint_partition();
extern INT fprint_permutation();
extern INT fprint_queue();
extern INT fprint_reihe();
extern INT fprint_skewpartition();
extern INT fprint_symchar();
extern INT fprint_tableaux();
extern INT fprint_vector();
extern INT freeall();
extern INT freeall_magma();
extern INT free_cyclotomic_parameters ();
extern INT freemonom();
extern INT freepartition();
extern INT free_root_parameters ();
extern INT freeself();
extern INT freeself_bintree();
extern INT freeself_bitvector();
extern INT freeself_bruch();
extern INT freeself_ff();
extern INT freeself_galois();
extern INT freeself_graph();
extern INT freeself_hashtable();
extern INT freeself_integer();
extern INT freeself_integermatrix();
extern INT freeself_integervector();
extern INT freeself_kranz();
extern INT freeself_kranztypus();
extern INT freeself_laurent();
extern INT freeself_list();
extern INT freeself_longint();
extern INT freeself_matrix();
extern INT freeself_monom();
extern INT freeself_number();
extern INT freeself_partition();
extern INT freeself_permutation();
extern INT freeself_reihe();
extern INT freeself_skewpartition();
extern INT freeself_symchar();
extern INT freeself_tableaux();
extern INT freeself_vector();
extern INT free_useful_monopolies ();
extern INT freevectorstruct();
extern INT freevectorstruct();
extern INT frip_latex_matrix_to_table();
extern INT frip_latex_matrix_to_table();
extern INT frip_latex_zykelind();
extern INT frobenius_elmsym();
extern INT frobenius_homsym();
extern INT frobenius_monomial();
extern INT frobenius_powsym();
extern INT frobenius_schur();
extern INT from_loesung_to_generatormatrix();
extern INT from_loesung_to_generatormatrix();
extern INT from_loesung_to_maximaldistanz();
extern INT from_loesung_to_minimaldistanz();
extern INT from_loesung_to_minimaldistanz();
extern INT from_loesung_to_weightenumerator();
extern INT from_loesung_to_weightenumerator();
extern INT fusedmemory();
extern INT galois_anfang();
extern INT galois_ende();
extern INT ganzdiv();
extern INT ganzdiv_apply();
extern INT ganzdiv_apply_integer();
extern INT ganzdiv_apply_longint();
extern INT ganzdiv_apply_longint_integer();
extern INT ganzdiv_apply_longint_longint();
extern INT ganzdiv_integer();
extern INT ganzdiv_integer_integer();
extern INT ganzdiv_integer_longint();
extern INT ganzdiv_longint();
extern INT ganzdiv_longint_integer();
extern INT ganzdiv_longint_longint();
extern INT ganzsquareroot();
extern INT ganzsquareroot_integer();
extern INT ganzsquareroot_longint();
extern INT garnir();
extern INT gauss_form();
extern INT gauss_form();
extern INT gauss_numbers();
extern INT gauss_polynom();
extern INT GaussRecInternal();
extern INT gauss_schubert_polynom();
extern INT gauss_triangular_apply_co();
extern INT gauss_triangular_apply_nodiv();
extern INT gauss_triangular_apply();
extern INT gcd_ex();
extern INT gcd_int_po();
extern INT gcd_mp();
extern INT gcd_mp_lent();
extern INT ge();
extern INT generate_root_tableaux ();
extern INT generate_standard_tableaux ();
extern INT generator_glkq_singer();
extern INT generator_glkq_sn();
extern INT generators_glnq();
extern INT generators_slnq();
extern INT gengroup();
extern INT gen_mat();
extern INT genpoly_QRcode();
extern INT gen_smat();
extern INT get_ax_dist();
extern INT get_bm_ij();
extern INT get_bv_i();
extern INT get_ff_irred();
extern INT get_galois_irred();
extern INT get_incidence();
extern INT get_incidence_caps();
extern INT get_incidence();
extern INT get_incidence_phg();
extern INT get_incidence_set_maxorbits();
extern INT get_index();
extern INT get_level_vector_of_verband();
extern INT get_orb_rep();
extern INT get_perm();
extern INT get_position();
extern INT get_tex_polynom_parameter();
extern INT get_time();
extern INT gewicht_v();
extern INT gewicht_wt();
extern INT Ggen();
extern INT ggt();
extern INT ggt_field_polynom();
extern INT ggt_i();
extern INT ggt_integer();
extern INT ggt_integer_integer();
extern INT ggt_integer_integer_slow();
extern INT ggt_integer_longint();
extern INT ggt_integer_slow();
extern INT ggt_longint();
extern INT ggt_longint_integer();
extern INT ggt_longint_longint();
extern INT ggt_longint_longint_sub();
extern INT ggt_polynom();
extern INT giambelli_matrix();
extern INT gl_character ();
extern INT gl_dimension ();
extern INT glm_B_W();
extern INT glm_B_W();
extern INT glm_get_BV();
extern INT glm_get_BV();
extern INT glm_homtest();
extern INT glmndg();
extern INT glm_sab();
extern INT glm_sab();
extern INT glpdg();
extern INT gl_tableaux ();
extern INT gr();
extern INT gram_schmidt();
extern INT grf_An();
extern INT grf_arb();
extern INT grf_Cn();
extern INT grf_Dn();
extern INT grf_Sn();
extern INT griesmerbound();
extern INT group_gen();
extern INT grouporder_kranz();
extern INT growingorder_schur();
extern INT gt();
extern INT gupta_nm();
extern INT gupta_nm_speicher();
extern INT gupta_tafel();
extern INT half_apply();
extern INT half_apply_longint();
extern INT hall_littlewood();
extern INT hall_littlewood_alt();
extern INT hall_littlewood_dij();
extern INT hall_littlewood_tafel();
extern INT hamming_distance_vector();
extern INT hash();
extern INT hash_ende();
extern INT hash_ff();
extern INT hash_integervector();
extern INT hash_list();
extern INT hash_matrix();
extern INT hash_monompartition();
extern INT hash_partition();
extern INT hash_skewpartition();
extern INT hashv();
extern INT has_one_variable();
extern INT hecke_action_lc_on_lc ();
extern INT hecke_action_perm_on_hecke ();
extern INT hecke_action_perm_on_lc ();
extern INT hecke_add ();
extern INT hecke_dg();
extern INT hecke_generator_reps ();
extern INT hecke_mult ();
extern INT hecke_root_generator_reps ();
extern INT hecke_scale ();
extern INT hfix_in_ww();
extern INT hoch();
extern INT hoch_bruch();
extern INT hoch_bruch_integer();
extern INT hoch_bruch_longint();
extern INT hoch_default();
extern INT hoch_default();
extern INT hoch_integer();
extern INT hoch_integer_integer();
extern INT hoch_integer_longint();
extern INT hoch_longint();
extern INT hoch_longint_integer();
extern INT hoch_longint_longint();
extern INT hoch_pre200902();
extern INT _homtest();
extern INT _homtest();
extern INT hook_diagramm();
extern INT hook_length_augpart();
extern INT hook_length();
extern INT hookp();
extern INT hook_partition();
extern INT hook_part();
extern INT horizontal_sum();
extern INT hplus();
extern INT idempotent();
extern INT immanente_matrix();
extern INT inc();
extern INT inc_bitvector();
extern INT inc_integer();
extern INT inc_longint();
extern INT inc_matrix();
extern INT inc_matrix_column_co();
extern INT inc_matrix_row_co();
extern INT inc_partition();
extern INT inc_permutation();
extern INT inc_reihe();
extern INT inc_tableaux();
extern INT inc_vector();
extern INT inc_vector_co();
extern INT index_galois();
extern INT indexofpart();
extern INT index_vector();
extern INT index_vector_binary();
extern INT inf_bitvector_apply();
extern INT inf_bitvector();
extern INT init_bintree();
extern INT init_cyclo();
extern INT init_elmsym();
extern INT init_galois_global();
extern INT init_hall_littlewood();
extern INT init_hashtable();
extern INT init_homsym();
extern INT init();
extern INT init_kostka();
extern INT init_kranz();
extern INT init_longint();
extern INT init_monomial();
extern INT init_polynom();
extern INT init_powsym();
extern INT init_queue();
extern INT init_reihe();
extern INT init_schur();
extern INT init_size_hashtable();
extern INT init_sqrad();
extern INT innermaxmofn();
extern INT inner_tensor_sc();
extern INT input_glmn();
extern INT input_lc_permutations ();
extern INT input_tableau ();
extern INT insert();
extern INT insert_bintree();
extern INT insert_bt_bt();
extern INT insert_elmsym_hashtable();
extern INT insert_entry_vector();
extern INT insert_hashtable();
extern INT insert_hashtable_hashtable();
extern INT insert_homsym_hashtable();
extern INT insert_list_list_2();
extern INT insert_list_list();
extern INT insert_list();
extern INT insert_monomial_hashtable();
extern INT insert_powsym_hashtable();
extern INT insert_scalar_hashtable();
extern INT insert_schur_hashtable();
extern INT integer_factor();
extern INT integer_factors_to_integer();
extern INT integer_primep();
extern INT integer_primep();
extern INT intlog();
extern INT intlog_int();
extern INT intlog_longint();
extern INT invers();
extern INT invers_apply();
extern INT invers_apply_bruch();
extern INT invers_apply_integer();
extern INT invers_apply_longint();
extern INT invers_apply_ff();
extern INT invers_bar();
extern INT invers_bitvector();
extern INT invers_bruch();
extern INT invers_cyclo();
extern INT inverse_jeudetaquin_tableaux();
extern INT inverse_nilplactic_jeudetaquin_tableaux();
extern INT invers_ff();
extern INT invers_galois();
extern INT invers_integer();
extern INT inversion_matrix_perm();
extern INT invers_kostka_tafel();
extern INT invers_kranz();
extern INT invers_laurent();
extern INT invers_longint();
extern INT invers_matrix();
extern INT invers_monopoly();
extern INT inversordcen();
extern INT invers_permutation();
extern INT invers_polynom();
extern INT invers_POLYNOM();
extern INT invers_sqrad();
extern INT is_graphical();
extern INT is_scalar_polynom();
extern INT is_scalar_reihe();
extern INT is_selfconjugate();
extern INT jacobi();
extern INT jacobitrudimatrix();
extern INT jeudetaquin_tableaux();
extern INT johnson_graph_adjacency_matrix();
extern INT kgv();
extern INT kk_280604 ();
extern INT Kn_adjacency_matrix();
extern INT knuth_row_delete_step();
extern INT knuth_row_insert_step();
extern INT knuth_twoword();
extern INT konj_gral_perm();
extern INT konj_perm_perm();
extern INT konjugation2();
extern INT konjugation();
extern INT konjugierende();
extern INT konjugiertenklassen_glkp();
extern INT konjugiertenklassen_glkp();
extern INT kostka_character();
extern INT kostka_number();
extern INT kostka_number_partition();
extern INT kostka_number_skewpartition();
extern INT kostka_tab();
extern INT kostka_tafel();
extern INT kranztafel();
extern INT kranztypus_charakteristik();
extern INT kranztypus_kranztypus_monom();
extern INT kranztypus_to_matrix();
extern INT kronecker();
extern INT kronecker_product();
extern INT krz();
extern INT kuerzen();
extern INT kuerzen_integer_integer();
extern INT kuerzen_integer_integer();
extern INT kuerzen_integer_longint();
extern INT kuerzen_integer_longint();
extern INT kuerzen_integral();
extern INT kuerzen_longint_integer();
extern INT kuerzen_longint_integer();
extern INT kuerzen_longint_longint();
extern INT kuerzen_longint_longint();
extern INT kung_formel();
extern INT lagrange_polynom();
extern INT last_lehmercode();
extern INT lastof();
extern INT lastof_integervector();
extern INT lastof_partition();
extern INT lastof_skewpartition();
extern INT lastof_vector();
extern INT lastp();
extern INT last_part_EXPONENT();
extern INT last_partition();
extern INT last_part_VECTOR();
extern INT last_permutation();
extern INT lastp_list();
extern INT latex_glm_dar();
extern INT latex_kranztafel();
extern INT latex_line();
extern INT latex_verband();
extern INT latticepword();
extern INT l_complete_complete_plet();
extern INT l_complete_schur_plet();
extern INT ldcf_monopoly();
extern INT ldcf_mp();
extern INT ldrei_neu();
extern INT ldrei_neu_get_zeitlimit();
extern INT ldrei_neu_set_anzahl();
extern INT ldrei_neu_set_keepgls();
extern INT ldrei_neu_set_mckay();
extern INT ldrei_neu_set_zeitlimit();
extern INT le();
extern INT leftkey_wt();
extern INT lehmercode2_permutation();
extern INT lehmercode();
extern INT lehmercode_bar();
extern INT lehmercode_permutation();
extern INT lehmercode_tableaux();
extern INT lehmercode_vector_bar();
extern INT lehmercode_vector();
extern INT l_elementary_schur_plet();
extern INT length();
extern INT length_bar();
extern INT length_bintree();
extern INT length_comp_part();
extern INT length_list();
extern INT length_partition();
extern INT length_permutation();
extern INT length_reihe();
extern INT length_skewpartition();
extern INT length_vector();
extern INT line_of_two_points();
extern INT list_anfang();
extern INT list_ende();
extern INT listp();
extern INT local_anfang();
extern INT local_ende();
extern INT longint_ende();
extern INT l_outerproduct_schur_lrs();
extern INT l_powerproduct_schur_plet();
extern INT l_power_schur_plet();
extern INT l_schur_powerproduct_schur_plet_mult();
extern INT l_schur_power_schur_plet_mult();
extern INT l_schur_schur_plet();
extern INT l_schur_schur_pletbis();
extern INT lt();
extern INT lyndon_orb();
extern INT m_2schubert_wt();
extern INT mahh_hashtable_hashtable_();
extern INT mahh_integer_homsym_();
extern INT mahh_partition_hashtable_();
extern INT make_all_st_tabs();
extern INT make_alt_classes();
extern INT makealtclassreps();
extern INT make_alt_partitions();
extern INT make_coprimes();
extern INT make_cyclotomic_monopoly();
extern INT make_ij_part();
extern INT make_index_coeff_power_cyclo();
extern INT make_index_power_cyclo();
extern INT make_monopoly_sqrad();
extern INT make_neu_partij_schur();
extern INT make_n_id();
extern INT make_n_kelmtrans();
extern INT make_n_transpositionmatrix();
extern INT make_nzykel();
extern INT make_partij_perm();
extern INT make_partij_schur();
extern INT make_real_cycletype();
extern INT make_scalar_cyclo();
extern INT make_scalar_sqrad();
extern INT make_tab_signs();
extern INT make_unitary0_monopoly();
extern INT make_unitary_eins_monopoly();
extern INT makevectorof_class_bar();
extern INT makevectorof_class_rep_bar();
extern INT makevectorof_kranztypus();
extern INT makevectorofpart_EXPONENT();
extern INT makevectorofpart();
extern INT makevectorofperm();
extern INT makevectorofrect_lehmercode();
extern INT makevectorofrect_permutation();
extern INT makevectorofshuffle();
extern INT makevectorofspecht_poly();
extern INT makevectorofsubsets();
extern INT makevectorofsymspecht_poly();
extern INT makevectorofSYT();
extern INT makevectoroftableaux();
extern INT makevectoroftranspositions();
extern INT makevectorofvectors();
extern INT makevectorofwords();
extern INT maple_polynom();
extern INT mapp_hashtable_hashtable_();
extern INT mapp_hashtable_hashtable_();
extern INT matrix_knuth();
extern INT matrix_monom_ypolynom();
extern INT matrixp();
extern INT matrix_to_kranztypus();
extern INT matrix_twoword();
extern INT max();
extern INT max_bar();
extern INT max_degree_reihe();
extern INT maxdegree_schubert();
extern INT max_divideddiff();
extern INT max_integervector();
extern INT max_matrix();
extern INT maxorder_young();
extern INT maxpart_comp_part();
extern INT maxrindexword();
extern INT max_tableaux();
extern INT max_vector();
extern INT m_bar_schubert();
extern INT m_cosinus_reihe();
extern INT m_d_sc();
extern INT mee_elmsym__();
extern INT mee_hashtable__();
extern INT mee_hashtable_hashtable_();
extern INT mee_hashtable_hashtable_();
extern INT mee_hashtable_hashtable_();
extern INT mee_integer__();
extern INT mee_integer_hashtable_();
extern INT mee_integer_hashtable_();
extern INT mee_integer_hashtable_();
extern INT mee_integer_partition_();
extern INT mee_integer_partition_();
extern INT mee_partition__();
extern INT mee_partition__();
extern INT mee_partition_partition_();
extern INT m_eins_reihe();
extern INT memcheck();
extern INT mem_elmsym__();
extern INT mem_ende();
extern INT mem_integer__();
extern INT mem_integer_hashtable_();
extern INT mem_integer_hashtable_();
extern INT mem_integer_hashtable_();
extern INT mem_integer_partition_();
extern INT mem_partition__();
extern INT mem_size();
extern INT mem_size_hashtable();
extern INT mem_size_longint();
extern INT mem_size_matrix();
extern INT mem_size_vector();
extern INT mem_small();
extern INT mes_elmsym__();
extern INT mes_ende();
extern INT mes_hashtable__();
extern INT mes_integer__();
extern INT mes_integer_hashtable_();
extern INT mes_integer_hashtable_();
extern INT mes_integer_partition_();
extern INT mes_integer_partition_();
extern INT mes_integer_partition_();
extern INT mes_partition__();
extern INT mes_partition__();
extern INT m_ff_vector();
extern INT m_forall_monomials_in_a();
extern INT m_forall_monomials_in_ab();
extern INT m_forall_monomials_in_b();
extern INT m_function_reihe();
extern INT m_gk_spa();
extern INT m_gl_alt();
extern INT m_gl_chartafel();
extern INT m_gl_cl();
extern INT m_gl_co();
extern INT m_gl_cr();
extern INT m_gl_cyclic();
extern INT m_gl_first();
extern INT m_gl_ge_cl();
extern INT m_gl_glnq();
extern INT m_gl_go();
extern INT m_gl_hyp();
extern INT m_gl_il();
extern INT m_gl_nc();
extern INT m_gl_next();
extern INT m_gl_sym();
extern INT m_gl_symkranz();
extern INT mhh_hashtable__();
extern INT mhh_hashtable_hashtable_();
extern INT mhh_hashtable_hashtable_();
extern INT mhh_hashtable_hashtable_();
extern INT mhh_homsym__();
extern INT mhh_partition__();
extern INT mhh_partition__();
extern INT mhh_partition_hashtable_();
extern INT mhh_partition_hashtable_();
extern INT mhh_partition_partition_();
extern INT mhm_hashtable__();
extern INT mhm_homsym__();
extern INT mhm_integer__();
extern INT mhm_integer_hashtable_hashtable();
extern INT mhm_integer_partition_hashtable();
extern INT mhm_null__();
extern INT mhm_partition__();
extern INT mhp_co();
extern INT mhp_hashtable__();
extern INT mhp_homsym__();
extern INT mhp_integer__();
extern INT mhp_integer__();
extern INT mhp_integer_hashtable_();
extern INT mhp_integer_hashtable_();
extern INT mhp_integer_hashtable_();
extern INT mhp_integer_hashtable_();
extern INT mhp_integer_partition_();
extern INT mhp_integer_partition_();
extern INT mhp_partition__();
extern INT mhs_hashtable__();
extern INT mhs_homsym__();
extern INT mhs_integer__();
extern INT mhs_integer__();
extern INT mhs_integer_partition_();
extern INT mhs_partition__();
extern INT m_i_elmsym();
extern INT m_i_i();
extern INT m_iindex_iexponent_monom();
extern INT m_iindex_monom();
extern INT m_iindex_monopoly();
extern INT m_il_bv();
extern INT m_ilih_bm();
extern INT m_ilih_m();
extern INT m_ilih_nm();
extern INT m_il_integervector();
extern INT m_il_nbv();
extern INT m_il_nv();
extern INT m_i_longint();
extern INT m_il_pa();
extern INT m_il_p();
extern INT m_il_v();
extern INT min();
extern INT m_index_monom();
extern INT mindist_neu();
extern INT mindist();
extern INT mindist_submatrix();
extern INT minimaldistanz();
extern INT minimaldistanz();
extern INT minimal_extension();
extern INT minimum_distance();
extern INT min_integervector();
extern INT min_matrix();
extern INT min_tableaux();
extern INT m_INTEGER_elmtrans();
extern INT m_INT_elmtrans();
extern INT m_int_pa();
extern INT min_vector();
extern INT m_ioiu_b();
extern INT m_i_pa();
extern INT m_i_powsym();
extern INT m_i_schubert();
extern INT m_i_schur();
extern INT m_i_staircase();
extern INT m_kl_pa();
extern INT m_ksd_n();
extern INT m_ks_pa();
extern INT m_ks_p();
extern INT m_lehmer_schubert_monom_summe();
extern INT m_lehmer_schubert_qpolynom();
extern INT m_lh_m();
extern INT m_lh_nm();
extern INT m_l_nv();
extern INT m_l_p();
extern INT m_l_v();
extern INT m_matrix_tableaux();
extern INT m_matrix_umriss();
extern INT m_merge_partition_partition();
extern INT m_merge_partition_partition();
extern INT m_merge_partition_partition();
extern INT m_merge_partition_partition();
extern INT m_merge_partition_partition();
extern INT m_merge_partition_partition();
extern INT m_merge_partition_partition();
extern INT m_merge_partition_partition();
extern INT mmm___();
extern INT mmm___();
extern INT mmm_ende();
extern INT mmm_hashtable__();
extern INT mmm_hashtable_hashtable_();
extern INT mmm_hashtable_hashtable_();
extern INT mmm_integer__();
extern INT mmm_integer_hashtable_();
extern INT mmm_integer_hashtable_();
extern INT mmm_integer_partition_();
extern INT mmm_integer_partition_();
extern INT mmm_monomial__();
extern INT mmm_null_partition_();
extern INT mmm_null_partition_();
extern INT mmm_partition__();
extern INT mmm_partition_partition_();
extern INT mmm_partition_partition_();
extern INT mmm_partition_partition_();
extern INT mmm_partition_partition_();
extern INT mms___();
extern INT mms_hashtable__();
extern INT mms_hashtable_partition_();
extern INT mms_integer__();
extern INT mms_integer_partition_();
extern INT mms_monomial__();
extern INT mms_null__();
extern INT mms_partition__();
extern INT mms_partition_partition_();
extern INT m_nc_kranz();
extern INT mod();
extern INT mod_apply();
extern INT mod_apply_integer();
extern INT mod_apply_integer_longint();
extern INT mod_apply_longint();
extern INT moddg();
extern INT mod_dg_sbd();
extern INT mod_integer_integer();
extern INT mod_longint_integer();
extern INT mod_longint_integer_via_ganzsquores();
extern INT mod_matrix();
extern INT mod_monom();
extern INT mod_part();
extern INT mod_polynom();
extern INT mod_vector();
extern INT moebius();
extern INT moebius_tafel();
extern INT monom_anfang();
extern INT monom_ende();
extern INT monomial_recursion();
extern INT monomial_recursion();
extern INT monomial_recursion2();
extern INT monomial_recursion2();
extern INT monomial_recursion();
extern INT monom_release();
extern INT m_ou_b();
extern INT move_1result_hashtable();
extern INT move_2result_hashtable();
extern INT m_o_v();
extern INT m_pa_e();
extern INT m_pa_h();
extern INT m_pa_mon();
extern INT m_pa_ps();
extern INT m_part_centralsc();
extern INT m_part_kostkaperm();
extern INT m_part_part_perm();
extern INT m_part_perm();
extern INT m_part_qelm();
extern INT m_part_Qschur();
extern INT m_part_sc();
extern INT m_part_sc_tafel();
extern INT m_part_tableaux();
extern INT m_part_youngsc();
extern INT m_pa_s();
extern INT m_perm_2schubert_monom_summe();
extern INT m_perm_2schubert_operating_monom_summe();
extern INT m_perm_2wt_summe();
extern INT m_perm_paareperm();
extern INT m_perm_reihe();
extern INT m_perm_rz_number();
extern INT m_perm_rz_set();
extern INT m_perm_sch();
extern INT m_perm_schubert_dimension();
extern INT m_perm_schubert_monom_summe();
extern INT m_perm_schubert_qpolynom();
extern INT m_perm_schur();
extern INT m_perm_sdwt_summe();
extern INT m_perm_skwt_summe();
extern INT m_perm_snwt_summe();
extern INT m_perm_tableaux_summe();
extern INT m_perm_wt_summe();
extern INT mp_is_cst();
extern INT mpp___();
extern INT mpp___();
extern INT mpp_ende();
extern INT mpp_hashtable__();
extern INT mpp_hashtable_hashtable_();
extern INT mpp_hashtable_hashtable_();
extern INT mpp_hashtable_hashtable_();
extern INT mpp_hashtable_hashtable_();
extern INT mpp_hashtable_hashtable_();
extern INT mpp_hashtable_hashtable_();
extern INT mpp_hashtable_hashtable_();
extern INT mpp_integer__();
extern INT mpp_integer_hashtable_();
extern INT mpp_integer_hashtable_();
extern INT mpp_integer_partition_();
extern INT mpp_integer_partition_();
extern INT mpp_partition__();
extern INT mpp_partition_partition_();
extern INT mpp_partition_partition_();
extern INT mpp_powsym__();
extern INT mps___();
extern INT mps_ende();
extern INT mps_hashtable__();
extern INT mps_hashtable__();
extern INT mps_hashtable__pre100102();
extern INT mps_integer__();
extern INT mps_integer_partition_();
extern INT mps_integer_partition_();
extern INT mps_integer_partition_();
extern INT mps_null__();
extern INT mps_partition__();
extern INT mps_powsym__();
extern INT m_scalar_bruch();
extern INT m_scalar_elmsym();
extern INT m_scalar_homsym();
extern INT m_scalar_monomial();
extern INT m_scalar_polynom();
extern INT m_scalar_powsym();
extern INT m_scalar_reihe();
extern INT m_scalar_schubert();
extern INT m_scalar_schur();
extern INT m_sinus_reihe();
extern INT m_skewpart_skewperm();
extern INT m_sk_gr();
extern INT m_sk_mo();
extern INT m_skn_mp();
extern INT m_skn_po();
extern INT m_skn_sch();
extern INT m_skn_s();
extern INT m_sn_l();
extern INT m_s_po();
extern INT mss___();
extern INT mss_ende();
extern INT mss_hashtable__();
extern INT mss_hashtable_hashtable_();
extern INT mss_hashtable_hashtable_();
extern INT mss_hashtable_hashtable_maxpart_maxlength();
extern INT mss_hashtable__maxpart_maxlength();
extern INT mss___maxpart_maxlength();
extern INT mss_partition__();
extern INT mss_partition__maxpart_maxlength();
extern INT mss_partition_partition_();
extern INT mss_partition_partition_maxpart_maxlength();
extern INT mss_schur__();
extern INT mss_schur__maxpart_maxlength();
extern INT m_tableaux_polynom();
extern INT m_tableaux_tableauxpair();
extern INT m_T_pol_summe();
extern INT m_T_tableaux_summe();
extern INT m_T_wt_summe();
extern INT mult();
extern INT multadd_apply();
extern INT multadd_apply_default();
extern INT multadd_apply_ff();
extern INT mult_apply();
extern INT mult_apply_bruch();
extern INT mult_apply_bruch_bruch();
extern INT mult_apply_bruch_hashtable();
extern INT mult_apply_bruch_integer();
extern INT mult_apply_bruch_longint();
extern INT mult_apply_bruch_monom();
extern INT mult_apply_bruch_polynom();
extern INT mult_apply_bruch_scalar();
extern INT mult_apply_cyclo();
extern INT mult_apply_default ();
extern INT mult_apply_elmsym();
extern INT mult_apply_elmsym_elmsym();
extern INT mult_apply_ff();
extern INT mult_apply_gral();
extern INT mult_apply_homsym();
extern INT mult_apply_homsym_homsym();
extern INT mult_apply_homsym_schur();
extern INT mult_apply_integer();
extern INT mult_apply_integer_bruch();
extern INT mult_apply_integer_hashtable();
extern INT mult_apply_integer_integer();
extern INT mult_apply_integer_integervector();
extern INT mult_apply_integer_longint();
extern INT mult_apply_integer_matrix();
extern INT mult_apply_integer_monom();
extern INT mult_apply_integer_polynom();
extern INT mult_apply_longint();
extern INT mult_apply_longint_bruch();
extern INT mult_apply_longint_integer();
extern INT mult_apply_longint_longint();
extern INT mult_apply_longint_matrix();
extern INT mult_apply_longint_polynom();
extern INT mult_apply_matrix();
extern INT mult_apply_matrix_matrix();
extern INT mult_apply_monom();
extern INT mult_apply_monomial();
extern INT mult_apply_monomial_monomial();
extern INT mult_apply_monopoly();
extern INT mult_apply_permutation();
extern INT mult_apply_polynom();
extern INT mult_apply_polynom_polynom();
extern INT mult_apply_polynom_scalar();
extern INT mult_apply_powsym();
extern INT mult_apply_powsym_powsym();
extern INT mult_apply_reihe();
extern INT mult_apply_scalar_bruch();
extern INT mult_apply_scalar_cyclo();
extern INT mult_apply_scalar_hashtable();
extern INT mult_apply_scalar_matrix();
extern INT mult_apply_scalar_monom();
extern INT mult_apply_scalar_monopoly();
extern INT mult_apply_scalar_polynom();
extern INT mult_apply_scalar_sqrad();
extern INT mult_apply_scalar_symchar();
extern INT mult_apply_scalar_vector();
extern INT mult_apply_schur();
extern INT mult_apply_schur_schur();
extern INT mult_apply_sqrad();
extern INT mult_apply_symchar();
extern INT mult_apply_vector();
extern INT mult_apply_vector_vector();
extern INT mult_bar_bar();
extern INT mult_bruch();
extern INT mult_bruch_bruch();
extern INT mult_bruch_hashtable();
extern INT mult_bruch_integer();
extern INT mult_bruch_longint();
extern INT mult_cyclo();
extern INT mult_cyclo_cyclo();
extern INT mult_disjunkt_polynom_polynom();
extern INT mult_elmsym();
extern INT mult_elmsym_elmsym();
extern INT mult_elmsym_homsym();
extern INT mult_elmsym_monomial();
extern INT mult_elmsym_powsym();
extern INT mult_elmsym_scalar();
extern INT mult_elmsym_schur();
extern INT mult_ff();
extern INT mult_ff_ff();
extern INT mult_ff_integer();
extern INT mult_galois_galois();
extern INT mult_galois();
extern INT mult_gral();
extern INT mult_gral_gral();
extern INT mult_hashtable_hashtable();
extern INT mult_hashtable_hashtable();
extern INT mult_hashtable_hashtable_faktor();
extern INT mult_hashtable_hashtable_faktor();
extern INT mult_homsym();
extern INT mult_homsym_elmsym();
extern INT mult_homsym_homsym();
extern INT mult_homsym_monomial();
extern INT mult_homsym_powsym();
extern INT mult_homsym_scalar();
extern INT mult_homsym_schur();
extern INT mult_imatrix_imatrix();
extern INT multinom();
extern INT multinom_small();
extern INT mult_integer();
extern INT mult_integer_bruch();
extern INT mult_integer_hashtable();
extern INT mult_integer_integer();
extern INT mult_integer_longint();
extern INT mult_integer_monom();
extern INT multiplicity_part();
extern INT mult_kranz_kranz();
extern INT mult_laurent();
extern INT mult_longint();
extern INT mult_longint_integer();
extern INT mult_longint_integer_via_ganzsmul();
extern INT mult_longint_longint();
extern INT mult_matrix();
extern INT mult_matrix_matrix();
extern INT mult_matrix_vector();
extern INT mult_monom();
extern INT mult_monomial();
extern INT mult_monomial_elmsym();
extern INT mult_monomial_homsym();
extern INT mult_monomial_monomial();
extern INT mult_monomial_powsym();
extern INT mult_monomial_scalar();
extern INT mult_monomial_schur();
extern INT mult_monopoly();
extern INT mult_monopoly_monopoly();
extern INT mult_monopoly_polynom();
extern INT mult_nc_kranz();
extern INT mult_perm_fix();
extern INT mult_permutation();
extern INT mult_polynom();
extern INT mult_polynom_polynom();
extern INT mult_power_schur();
extern INT mult_powsym();
extern INT mult_powsym_elmsym();
extern INT mult_powsym_homsym();
extern INT mult_powsym_monomial();
extern INT mult_powsym_powsym();
extern INT mult_powsym_scalar();
extern INT mult_powsym_schur();
extern INT mult_reihe();
extern INT mult_scalar_cyclo();
extern INT mult_scalar_gral();
extern INT mult_scalar_matrix();
extern INT mult_scalar_monom();
extern INT mult_scalar_monopoly();
extern INT mult_scalar_polynom();
extern INT mult_scalar_schubert();
extern INT mult_scalar_sqrad();
extern INT mult_scalar_symchar();
extern INT mult_scalar_vector();
extern INT mult_schubert_monom();
extern INT mult_schubert_polynom();
extern INT mult_schubert_schubert();
extern INT mult_schubert_variable ();
extern INT mult_schur();
extern INT mult_schur_elmsym();
extern INT mult_schur_homsym();
extern INT mult_schur_monomial();
extern INT mult_schur_powsym();
extern INT mult_schur_scalar();
extern INT mult_schur_schur();
extern INT mult_schur_schur_maxlength();
extern INT mult_schur_schur_maxpart_maxlength();
extern INT mult_schur_schur_maxpart_maxlength();
extern INT mult_sqrad();
extern INT mult_sqrad_sqrad();
extern INT mult_symchar_symchar();
extern INT mult_vector_matrix();
extern INT mult_vector_vector();
extern INT m_umriss_tableaux();
extern INT m_us_t();
extern INT m_u_t();
extern INT m_vcl_kranz();
extern INT m_vco_kranz();
extern INT m_vec_grad_nc_hyp();
extern INT m_vec_poly();
extern INT m_vector_diagonalmatrix();
extern INT m_vector_ff();
extern INT m_vector_graph();
extern INT m_vec_vec_poly();
extern INT m_v_pa();
extern INT m_v_po_mz();
extern INT m_v_s();
extern INT m_word_wt();
extern INT m_wpd_sc();
extern INT m_wt_tableaux();
extern INT m_wttab_tableaux();
extern INT m_wt_wtkontertab();
extern INT m_wt_wttab();
extern INT mx_outerproduct_schur_lrs();
extern INT mx_powerproduct_schur_plet();
extern INT mx_power_schur_plet();
extern INT mx_schur_powerproduct_schur_plet_mult();
extern INT mx_schur_power_schur_plet_mult();
extern INT mx_schur_schur_plet();
extern INT mx_schur_schur_pletbis();
extern INT mxx_null__();
extern INT mxx_null__();
extern INT mxx_null__();
extern INT mxx_null__();
extern INT mxx_null__();
extern INT my_conjugation();
extern INT my_quasinormalform_neu();
extern INT mz_extrahieren();
extern INT mz_vereinfachen();
extern INT nachfolger_young();
extern INT nb_ende();
extern INT ndg();
extern INT negeinsp();
extern INT negeinsp_bruch();
extern INT negeinsp_integer();
extern INT negeinsp_longint();
extern INT negeinsp_polynom();
extern INT negp();
extern INT negp_bruch();
extern INT negp_integer();
extern INT negp_longint();
extern INT negp_polynom();
extern INT neg_sum();
extern INT neq();
extern INT neqparts_partition();
extern INT new_divdiff_bar();
extern INT new_divideddifference_bar();
extern INT new_divideddiff_rz_bar();
extern INT new_orbit();
extern INT newtrans_eins();
extern INT newtrans_lehmer();
extern INT newtrans_limitfunction();
extern INT newtrans_limit_limitfunction();
extern INT newtrans_maxpart_maxlength();
extern INT newtrans_maxpart_maxlength();
extern INT newtrans_maxpart();
extern INT newtrans();
extern INT next_apply_bar();
extern INT next_apply_composition();
extern INT next_apply_ff();
extern INT next_apply_gr();
extern INT next_apply();
extern INT next_apply_partition();
extern INT next_apply_permutation();
extern INT next_apply_subset();
extern INT next_bar();
extern INT next_composition();
extern INT next_ff();
extern INT next_gfp_vector();
extern INT next_gfp_vector();
extern INT next_gr();
extern INT next_kranztypus();
extern INT next_lehmercode();
extern INT next_lex_tableaux();
extern INT next_lex_vector();
extern INT next_part_EXPONENT_apply();
extern INT next_part_EXPONENT();
extern INT next_partition_apply();
extern INT next_partition();
extern INT next_part_VECTOR_apply();
extern INT next_part_VECTOR();
extern INT next_perm_invers();
extern INT next_permutation();
extern INT next_permutation_lex();
extern INT next_pgp_vector();
extern INT next_pgp_vector();
extern INT next_shuffle_part();
extern INT next_shufflepermutation();
extern INT next_shufflevector();
extern INT next_subset();
extern INT next();
extern INT n_fold_kronecker_product();
extern INT no_memory();
extern INT no_orbits_arb();
extern INT normal_laurent();
extern INT not_yet_implemented();
extern INT nth_root_ff_given_q();
extern INT ntopaar_symchar();
extern INT null();
extern INT null_default();
extern INT null_ff();
extern INT null_ff_given_q();
extern INT null_galois();
extern INT null_gr_given_c_d();
extern INT null_object();
extern INT nullp();
extern INT nullp_bitvector();
extern INT nullp_bruch();
extern INT nullp_cyclo();
extern INT nullp_elmsym();
extern INT nullp_ff();
extern INT nullp_galois();
extern INT nullp_homsym();
extern INT nullp_integer();
extern INT nullp_integermatrix();
extern INT nullp_integervector();
extern INT nullp_longint();
extern INT nullp_matrix();
extern INT nullp_monomial();
extern INT nullp_monopoly();
extern INT nullp_polynom();
extern INT nullp_powsym();
extern INT nullp_reihe();
extern INT nullp_schubert();
extern INT nullp_schur();
extern INT nullp_sqrad();
extern INT nullp_symchar();
extern INT nullp_vector();
extern INT number_01_matrices();
extern INT number_nat_matrices();
extern INT number_of_bits();
extern INT numberof_class_kranz();
extern INT number_of_digits();
extern INT numberof_inversionen();
extern INT number_of_irred_poly_of_degree();
extern INT numberofmonomials();
extern INT numberofpart_i();
extern INT numberofpart();
extern INT numberofparts_exact_parts();
extern INT numberofparts_ge();
extern INT numberofparts_le_parts();
extern INT numberofselfconjugatepart();
extern INT numberof_shufflepermutation();
extern INT number_of_subspaces();
extern INT number_of_subspaces();
extern INT numberofvariables();
extern INT nu_v_v_pgp();
extern INT nu_v_v_pgp();
extern INT nxt_ym();
extern INT objectread_bruch();
extern INT objectread_bv();
extern INT objectread_ff();
extern INT objectread();
extern INT objectread_gral();
extern INT objectread_hashtable();
extern INT objectread_integer();
extern INT objectread_list();
extern INT objectread_longint();
extern INT objectread_matrix();
extern INT objectread_monom();
extern INT objectread_monopoly();
extern INT objectread_number();
extern INT objectread_partition();
extern INT objectread_permutation();
extern INT objectread_schur();
extern INT objectread_skewpartition();
extern INT objectread_symchar();
extern INT objectread_tableaux();
extern INT objectread_vector();
extern INT objectwrite_bruch();
extern INT objectwrite_bv();
extern INT objectwrite_ff();
extern INT objectwrite();
extern INT objectwrite_gral();
extern INT objectwrite_hashtable();
extern INT objectwrite_integer();
extern INT objectwrite_list();
extern INT objectwrite_longint();
extern INT objectwrite_matrix();
extern INT objectwrite_monom();
extern INT objectwrite_number();
extern INT objectwrite_partition();
extern INT objectwrite_permutation();
extern INT objectwrite_schur();
extern INT objectwrite_skewpartition();
extern INT objectwrite_symchar();
extern INT objectwrite_tableaux();
extern INT objectwrite_vector();
extern INT odd();
extern INT oddify_longint();
extern INT oddify_longint();
extern INT odd_longint();
extern INT oddpartsp();
extern INT odd_to_strict_part();
extern INT odg();
extern INT old_number_01_matrices();
extern INT operate_gral_polynom();
extern INT operate_perm_bideterminant();
extern INT operate_perm_polynom();
extern INT operate_perm_spaltenmatrix();
extern INT operate_perm_tableaux();
extern INT operate_perm_vector();
extern INT operate_perm_zeilenmatrix();
extern INT orbit();
extern INT orbit_set_max_size();
extern INT orbit_words();
extern INT orblen();
extern INT or_character ();
extern INT ordcen_bar();
extern INT ordcen();
extern INT ordcon_bar();
extern INT ordcon();
extern INT order_class_kranz();
extern INT order_ff();
extern INT order_permutation();
extern INT or_dimension ();
extern INT ordnung_affkq();
extern INT ordnung_glkq();
extern INT or_tableaux ();
extern INT outerproduct_schubert();
extern INT outerproduct_schur();
extern INT outerproduct_schur_limit();
extern INT outerproduct_schur_limitfunction();
extern INT outerproduct_schur_limit_limitfunction();
extern INT outerproduct_schur_lrs();
extern INT p2_schursum();
extern INT p2_schursum();
extern INT part_anfang();
extern INT part_comp();
extern INT part_ende();
extern INT partitionp();
extern INT part_part_skewschur();
extern INT perm_anfang();
extern INT Perm_eingabe();
extern INT perm_ende();
extern INT perm_matrix();
extern INT perm_matrix_p();
extern INT perm_tableaux();
extern INT permutation_matrix();
extern INT permutationp();
extern INT permutationsdarstellung_matrix_pgl();
extern INT permutationsdarstellung_matrix_pgl();
extern INT perm_weintraube();
extern INT pes___();
extern INT pes___();
extern INT pes_elmsym__();
extern INT pes_ende();
extern INT pes_hashtable__();
extern INT pes_integer__();
extern INT pes_integer_hashtable_();
extern INT pes_integer_hashtable_();
extern INT pes_integer_partition_();
extern INT pes_integer_partition_();
extern INT pes_null__();
extern INT pes_null_partition_();
extern INT pes_null_partition_();
extern INT pes_partition__();
extern INT pfact();
extern INT pfaffian_matrix();
extern INT pgcd();
extern INT phm___();
extern INT phm___();
extern INT phm_ende();
extern INT phm_hashtable__();
extern INT phm_hashtable_hashtable_();
extern INT phm_homsym__();
extern INT phm_integer__();
extern INT phm_integer_hashtable_();
extern INT phm_integer_hashtable_();
extern INT phm_integer_integer_();
extern INT phm_integer_integer_();
extern INT phm_integer_partition_();
extern INT phm_integer_partition_();
extern INT phm_null__();
extern INT phm_null_partition_();
extern INT phm_null_partition_();
extern INT phm_partition__();
extern INT p_hook_diagramm();
extern INT p_hook_weight();
extern INT phs___();
extern INT phs___();
extern INT phs___();
extern INT phs_ende();
extern INT phs_hashtable__();
extern INT phs_homsym__();
extern INT phs_integer__();
extern INT phs_integer_hashtable_();
extern INT phs_integer_hashtable_();
extern INT phs_integer_partition_();
extern INT phs_integer_partition_();
extern INT phs_null__();
extern INT phs_null_partition_();
extern INT phs_partition__();
extern INT pictex_skwt_liste();
extern INT pictex_snwt_liste();
extern INT pictex_wt();
extern INT pictex_wt_liste();
extern INT pictex_wt_liste_co();
extern INT planep();
extern INT plane_tableau();
extern INT plaziere_verband();
extern INT plet_elmsym_elmsym();
extern INT plet_elmsym_homsym();
extern INT plet_elmsym_monomial();
extern INT plet_elmsym_powsym();
extern INT plet_elmsym_schur();
extern INT plet_homsym_elmsym();
extern INT plet_homsym_homsym();
extern INT plet_homsym_monomial();
extern INT plet_homsym_monomial_via_ppm();
extern INT plet_homsym_powsym();
extern INT plet_homsym_schur();
extern INT plethysm();
extern INT plethysm_schur_monomial();
extern INT plethysm_schur_schur();
extern INT plet_monomial_elmsym();
extern INT plet_monomial_homsym();
extern INT plet_monomial_monomial();
extern INT plet_monomial_powsym();
extern INT plet_monomial_schur();
extern INT plet_powsym_elmsym();
extern INT plet_powsym_homsym();
extern INT plet_powsym_monomial();
extern INT plet_powsym_powsym();
extern INT plet_powsym_schur();
extern INT plet_powsym_schur_via_ppm();
extern INT plet_schur_elmsym();
extern INT plet_schur_elmsym_pre101201();
extern INT plet_schur_homsym();
extern INT plet_schur_monomial();
extern INT plet_schur_monomial_new();
extern INT plet_schur_powsym();
extern INT plet_schur_schur();
extern INT plet_schur_schur_pol();
extern INT plet_schur_schur_via_phs();
extern INT pl_j_wt();
extern INT pn_character ();
extern INT pn_dimension ();
extern INT pn_tableaux ();
extern INT point();
extern INT pol_sd_wt();
extern INT pol_sn_wt();
extern INT pol_wt();
extern INT polya1_sub();
extern INT polya2_sub();
extern INT polya3_sub();
extern INT polya_const_sub();
extern INT polya_multi_const_sub();
extern INT polya_multi_sub();
extern INT polya_n_sub();
extern INT polya_sub();
extern OP pop();
extern INT posp();
extern INT posp_bruch();
extern INT posp_integer();
extern INT posp_longint();
extern INT posp_polynom();
extern INT posp_vector();
extern INT pos_sum();
extern INT powerproduct_schur_plet();
extern INT power_schur_plet();
extern INT power_schur_plet_old();
extern INT ppe___();
extern INT ppe___();
extern INT ppe___();
extern INT ppe___();
extern INT ppe___();
extern INT ppe___();
extern INT ppe_ende();
extern INT ppe_hashtable__();
extern INT ppe_hashtable_hashtable_();
extern INT ppe_integer__();
extern INT ppe_integer_hashtable_();
extern INT ppe_integer_hashtable_();
extern INT ppe_integer_integer_();
extern INT ppe_integer_partition_();
extern INT ppe_integer_partition_();
extern INT ppe_null__();
extern INT ppe_null_partition_();
extern INT ppe_null_partition_();
extern INT ppe_partition__();
extern INT ppe_powsym__();
extern INT pph___();
extern INT pph___();
extern INT pph___();
extern INT pph___();
extern INT pph___();
extern INT pph___();
extern INT pph_ende();
extern INT pph_hashtable__();
extern INT pph_hashtable_hashtable_();
extern INT pph_integer__();
extern INT pph_integer_hashtable_();
extern INT pph_integer_hashtable_();
extern INT pph_integer_integer_();
extern INT pph_integer_integer_();
extern INT pph_integer_partition_();
extern INT pph_integer_partition_();
extern INT pph_null__();
extern INT pph_null_partition_();
extern INT pph_null_partition_();
extern INT pph_partition__();
extern INT pph_powsym__();
extern INT ppm___();
extern INT ppm___();
extern INT ppm___();
extern INT ppm___();
extern INT ppm___();
extern INT ppm_ende();
extern INT ppm_hashtable__();
extern INT ppm_hashtable_hashtable_();
extern INT ppm_integer__();
extern INT ppm_integer_hashtable_();
extern INT ppm_integer_hashtable_();
extern INT ppm_integer_integer_();
extern INT ppm_integer_integer_();
extern INT ppm_integer_partition_();
extern INT ppm_integer_partition_();
extern INT ppm_null__();
extern INT ppm_null_partition_();
extern INT ppm_null_partition_();
extern INT ppm_partition__();
extern INT ppm_powsym__();
extern INT ppp___();
extern INT ppp___();
extern INT ppp___();
extern INT ppp___();
extern INT ppp_ende();
extern INT ppp_hashtable__();
extern INT ppp_hashtable_hashtable_();
extern INT ppp_integer__();
extern INT ppp_integer_hashtable_();
extern INT ppp_integer_hashtable_();
extern INT ppp_integer_partition_();
extern INT ppp_integer_partition_();
extern INT ppp_null__();
extern INT ppp_null_partition_();
extern INT ppp_null_partition_();
extern INT ppp_partition__();
extern INT ppp_powsym__();
extern INT pps___();
extern INT pps_ende();
extern INT pps_hashtable__();
extern INT pps_hashtable_hashtable_();
extern INT pps_integer__();
extern INT pps_null__();
extern INT pps_null_partition_();
extern INT pps_null_partition_();
extern INT pps_partition__();
extern INT pps_powsym__();
extern INT prepartdom();
extern INT primep();
extern INT primep_ff();
extern INT prime_power_p();
extern INT primitive_element_ff_given_q();
extern INT primitive_element_ff();
extern INT print_cyclo_data();
extern INT print_cyclo_list();
extern INT print_cyclo_table();
extern INT printeingabe();
extern INT println_bm();
extern INT println();
extern INT println_schub_lehmer();
extern INT printobjectkind();
extern INT print();
extern INT print_schubert_difference();
extern INT print_stat_hashtable();
extern INT print_time();
extern INT print_type();
extern INT pr_j_wt();
extern INT p_root_part();
extern INT p_root_schur();
extern INT prsym();
extern INT p_schursum();
extern INT p_schursum();
extern INT psh___();
extern INT psh_ende();
extern INT psh_hashtable__();
extern INT psh_integer__();
extern INT psh_integer_homsym_();
extern INT psh_null__();
extern INT psh_partition__();
extern INT psh_partition__();
extern INT psh_partition_homsym_();
extern INT psh_partition_partition_();
extern INT psh_schur__();
extern INT psl_apply_i_integer();
extern INT psl_apply_i_longint();
extern INT psl_apply_longint();
extern INT psm___();
extern INT psm_ende();
extern INT p_splitpart();
extern INT p_splitpart2();
extern INT p_splitpart();
extern INT psr_apply_i_integer();
extern INT psr_apply_i_longint();
extern INT pss___();
extern INT pss___();
extern INT pss_ende();
extern INT pss_hashtable__();
extern INT pss_hashtable_hashtable_();
extern INT pss_integer__();
extern INT pss_integer_hashtable_();
extern INT pss_integer_hashtable_();
extern INT pss_integer_integer_();
extern INT pss_integer_integer_();
extern INT pss_integer_partition_();
extern INT pss_integer_partition_();
extern INT pss_integer_schur_();
extern INT pss_null__();
extern INT pss_null_partition_();
extern INT pss_null_partition_();
extern INT pss_partition__();
extern INT pss_partition_hashtable_();
extern INT pss_partition_partition_();
extern INT pss_partition_partition_();
extern INT pss_partition_schur_();
extern INT pss_partition_schur_();
extern INT pss_schur__();
extern INT pss_schur__();
extern INT P_symmetrized_bideterminant();
extern INT push();
extern INT put_exactlength_limit_schur();
extern INT put_length_limit_schur();
extern INT q_core();
extern INT q_core_sign();
extern INT qdimension();
extern INT qdimension_schubert();
extern INT qsort_vector();
extern INT quadraticp();
extern INT quadratic_remainders();
extern INT quasi_normal_form();
extern INT quasinormalform();
extern INT quasi_normal_form();
extern INT quores();
extern INT quores_integer();
extern INT quores_longint();
extern INT quores_monopoly();
extern INT quores_monopoly_pre300402();
extern INT raise_power_monopoly();
extern INT random_adjacency_matrix();
extern INT random_bar();
extern INT random_bruch();
extern INT random_bv();
extern INT random_char_ff();
extern INT random_ff();
extern INT random_ff_given_q();
extern INT random_generator_diag_subgroup();
extern INT random_generator_sk_subgroup();
extern INT random_generator_small_glkq_singersubgroup();
extern INT random_gral();
extern INT random_gr_given_c_d();
extern INT random_integer();
extern INT random_integervector();
extern INT random_kranz();
extern INT random_longint();
extern INT random_monom();
extern INT random_part_EXPONENT();
extern INT random_partition_exponent();
extern INT random_partition();
extern INT random_permutation();
extern INT random_polynom();
extern INT random_reihe();
extern INT random_subgroup_glk_grcd_2gen();
extern INT random_subgroup_glk_grcd_cyclic();
extern INT random_subgroup_glk_grcd_diagonal();
extern INT random_subgroup_glk_grcd();
extern INT random_subgroup_glk_grcd_smaller_k();
extern INT random_subgroup_glk_grcd_stabilizer();
extern INT random_subgroup_glkq();
extern INT random_subgroup_glkq_1gen();
extern INT random_subgroup_glkq_2gen();
extern INT random_subgroup_glkq_2gen();
extern INT random_subgroup_glkq_3gen();
extern INT random_subgroup_glkq_3gen();
extern INT random_subgroup_glkq_block();
extern INT random_subgroup_glkq_cyclic();
extern INT random_subgroup_glkq_cyclic();
extern INT random_subgroup_glkq_diagonal();
extern INT random_subgroup_glkq_diagonal();
extern INT random_subgroup_glkq();
extern INT random_subgroup_glkq_perm_cyclic();
extern INT random_subgroup_glkq_perm_cyclic();
extern INT random_subgroup_glkq_perm_diagonal();
extern INT random_subgroup_glkq_perm();
extern INT random_subgroup_glkq_prim();
extern INT random_subgroup_glkq_prim();
extern INT random_subgroup_glkq_smaller_k();
extern INT random_subgroup_glkq_smaller_k();
extern INT random_subgroup_glkq_upper_cyclic();
extern INT random_subgroup_glkq_upper_cyclic();
extern INT random_word();
extern INT rank();
extern INT rank_ff();
extern INT rank_k_subset();
extern INT rank_line();
extern INT rank_permutation();
extern INT rank_point();
extern INT red_dia_perm();
extern INT redf_cap();
extern INT redf_cap_hoch();
extern INT redf_cup();
extern INT redf_cup_hoch();
extern INT reduce_ff();
extern INT reduce_inner_tensor_sc();
extern INT reduce_nc();
extern INT reduce_nc_kranz();
extern INT reduceninpaar();
extern INT reduce_symchar();
extern INT reduce_symchar_tafel();
extern INT reell_gram_schmidt();
extern INT reell_gram_schmidt();
extern INT release_numbers();
extern INT remove_hook();
extern INT remove_mp_qnumber_fac ();
extern INT removepartij();
extern INT remove_part_integer();
extern INT remove_part_part();
extern INT remove_vec_qnumber ();
extern INT remove_zero_terms();
extern INT reorder_hall_littlewood();
extern INT reorder_schur();
extern INT reorder_vector();
extern INT reorder_vector_apply();
extern INT represent_hecke_element ();
extern INT reset_basis();
extern INT reset_saving();
extern INT reverse_bitvector();
extern INT reverse_vector();
extern INT rg_factorize();
extern INT rg_order_ff();
extern INT rg_quasi_normal_form();
extern INT rh_test();
extern INT ribbon_matrix();
extern INT ribbon_partition();
extern INT rightkey_wt();
extern INT rindexword_sub();
extern INT rindexword();
extern INT rm_rindex();
extern INT root_dimension ();
extern INT root_normalise_monopoly ();
extern INT root_represent_hecke_action ();
extern INT root_standardise_cold_tableaux_list ();
extern INT row_column_matrices();
extern INT rowwordoftableaux();
extern INT R_roftableaux();
extern INT runtime();
extern INT rz();
extern INT rz_bar();
extern INT rz_Dn();
extern INT rz_lehmercode_bar();
extern INT rz_lehmercode();
extern INT rz_perm();
extern INT sab();
extern INT sab_input();
extern INT S_a_rofword();
extern INT save_cyclo_list();
extern INT Sbar_nkq_maxgrad();
extern INT Sbar_nkq_maxgrad();
extern INT s_b_i();
extern INT s_bm_hi();
extern INT s_bm_li();
extern OP s_b_o();
extern INT s_b_oi();
extern OP s_b_u();
extern INT s_b_ui();
extern INT s_bv_li();
extern INT scalarp();
extern INT scalarproduct();
extern INT scalarproduct_bar_schubert();
extern INT scalarproduct_elmsym();
extern INT scalarproduct_homsym();
extern INT scalarproduct_homsym_monomial();
extern INT scalarproduct_monomial();
extern INT scalarproduct_nc();
extern INT scalarproduct_powsym();
extern INT scalarproduct_powsym_powsym();
extern INT scalarproduct_schubert();
extern INT scalarproduct_schur();
extern INT scalarproduct_schur_schur();
extern INT scalarproduct_symchar();
extern INT scalarproduct_vector();
extern INT scale_monopoly();
extern INT scan_bar();
extern INT scan_bitvector();
extern INT scan_bruch();
extern INT scan_cyclo();
extern INT scan_elmsym();
extern INT scan_exponentpartition();
extern INT scan_fastpolynom();
extern INT scan_ff();
extern INT scan_galois();
extern INT scan_gl_nc();
extern INT scan_gral();
extern INT scan_homsym();
extern INT scan_integerbruch();
extern INT scan_integer();
extern INT scan_integermatrix();
extern INT scan_integervector();
extern INT scan();
extern INT scan_kostka();
extern INT scan_kranz();
extern INT scan_laurent();
extern INT scan_list();
extern INT scan_longint();
extern INT scan_matrix();
extern INT scan_monom();
extern INT scan_monomial();
extern INT scan_monopoly();
extern INT scan_nc_kranz();
extern OBJECTKIND scanobjectkind();
extern INT scan_partition();
extern INT scan_parttableaux();
extern INT scan_permutation();
extern INT scan_permutation_cycle();
extern INT scan_permvector();
extern INT scan_polynom();
extern INT scan_powsym();
extern INT scan_printeingabe();
extern INT scan_reihe();
extern INT scan_reversepartition();
extern INT scan_schubert();
extern INT scan_schur();
extern INT scan_skewpartition();
extern INT scan_skewsymmetric_matrix();
extern INT scan_skewtableaux();
extern INT scan_sqrad();
extern INT scan_symchar();
extern INT scan_tableaux();
extern INT scan_vector();
extern INT scan_word();
extern INT schensted_row_delete_step();
extern INT schensted_row_insert_step();
extern INT schen_word();
extern INT schicht_print();
extern INT schnitt_mat();
extern INT schnitt_schur();
extern INT schubertp();
extern INT schur_ende();
extern INT schur_part_skewschur();
extern INT schur_powerproduct_schur_plet_mult();
extern INT schur_power_schur_plet_mult();
extern INT schur_schur_pletbis();
extern INT schur_schur_plet();
extern INT sdg();
extern INT sd_i_wt();
extern INT Sd_wt();
extern INT select_coeff_polynom();
extern INT select_coeff_reihe();
extern INT select_column();
extern INT select_column_tableaux();
extern INT select_degree_reihe();
extern OP select_i();
extern INT select_row();
extern INT select_row_tableaux();
extern INT set_bm_ij();
extern INT set_bv_i();
extern INT set_cyclotomic_parameters ();
extern INT set_lo_nopoint();
extern INT set_root_parameters ();
extern INT set_tex_polynom_parameter();
extern INT setup_numbers();
extern INT set_useful_monopolies ();
extern OP s_ff_c();
extern INT s_ff_ci();
extern INT s_ff_di();
extern INT s_ff_ii();
extern OBJECTKIND s_gr_k();
extern OP s_gr_kn();
extern OP s_gr_kni();
extern OP s_gr_koor();
extern OP s_gr_koori();
extern OP s_gr_na();
extern OP s_gr_nai();
extern OP s_gr_s();
extern OP s_gr_xkoori();
extern OP s_gr_ykoori();
extern INT signum();
extern INT signum_permutation();
extern INT s_i_i();
extern INT singularp();
extern INT Sinus_eingabe();
extern INT s_i_wt();
extern INT skewpartitionp();
extern INT skewplane_plane();
extern INT skip_comment();
extern INT skip_integer();
extern INT skip();
extern INT s_ki_wt();
extern OP s_kr_g();
extern OP s_kr_gi();
extern OP s_kr_gl();
extern INT s_kr_gli();
extern OP s_kr_i();
extern OP s_kr_v();
extern INT Sk_wt();
extern OP s_lc_poly();
extern OP s_l_n();
extern OP s_l_s();
extern OP s_m_h();
extern INT s_m_hash();
extern INT s_m_hi();
extern OP s_m_ij();
extern INT s_m_iji();
extern OP s_m_l();
extern INT s_m_li();
extern OP s_mo_k();
extern INT s_mo_ki();
extern OP s_mo_s();
extern OP s_mo_si();
extern INT s_mo_sii();
extern OP s_mo_sl();
extern INT s_mo_sli();
extern OP s_m_s();
extern OP s_mz_po();
extern OP s_mz_v();
extern OP s_mz_vi();
extern INT s_mz_vii();
extern INT sn_character ();
extern OP s_n_d();
extern OP s_n_dcd();
extern OP s_n_dci();
extern OP s_n_dcp();
extern INT sn_dimension ();
extern INT s_ni_wt();
extern INT S_nkq_maxgrad();
extern INT S_nkq_maxgrad();
extern OP s_n_s();
extern INT sn_tableaux ();
extern INT sn_weintraube();
extern INT Sn_wt();
extern INT so_character ();
extern INT so_dimension ();
extern OBJECTKIND s_o_k();
extern INT SYM_sort();
extern INT sort_rows_tableaux_apply();
extern INT sort_vector();
extern OBJECTSELF s_o_s();
extern INT so_tableaux ();
extern INT s_pa_hash();
extern OP s_pa_i();
extern INT s_pa_ii();
extern OBJECTKIND s_pa_k();
extern OP s_pa_l();
extern INT s_pa_li();
extern INT spaltenanfang();
extern INT spaltenende();
extern INT spalten_summe();
extern OP s_pa_s();
extern INT sp_br();
extern INT sp_character ();
extern INT sp_dimension ();
extern INT specht_dg();
extern INT specht_irred_characteristik();
extern INT specht_m_part_sc();
extern INT specht_poly();
extern INT specht_powersum();
extern INT special_eq();
extern INT special_mult_apply_homsym_homsym();
extern INT speicher_anfang();
extern INT speicher_ende();
extern OP s_p_i();
extern INT s_p_ii();
extern INT spin_tableaux_character ();
extern OBJECTKIND s_p_k();
extern OP s_p_l();
extern INT s_p_li();
extern INT split_hashtable();
extern INT split();
extern INT splitpart();
extern INT splitpart();
extern INT splitpart();
extern OP s_po_k();
extern INT s_po_ki();
extern OP s_po_n();
extern OP s_po_s();
extern OP s_po_si();
extern INT s_po_sii();
extern OP s_po_sl();
extern INT s_po_sli();
extern INT sprint_ff();
extern INT sprint_integer();
extern INT sprint_integervector();
extern INT sprint_longint();
extern INT sprint_partition();
extern INT sprint_permutation();
extern INT sprint_skewpartition();
extern INT sprint();
extern INT sprint_vector();
extern OP s_p_s();
extern INT sp_tableaux ();
extern INT square_apply();
extern INT square_apply_integer();
extern INT square_apply_longint();
extern INT square_free_part_0();
extern INT square_free_part();
extern INT squareroot();
extern INT squareroot_bruch();
extern INT squareroot_integer();
extern INT squareroot_longint();
extern INT S_rofword();
extern INT sscan_bar();
extern INT sscan_bitvector();
extern INT sscan_elmsym();
extern INT sscan_homsym();
extern INT sscan_integer();
extern INT sscan_integervector();
extern INT sscan_longint();
extern INT sscan_partition();
extern INT sscan_permutation();
extern INT sscan_permvector();
extern INT sscan_reversepartition();
extern INT sscan_schur();
extern INT sscan();
extern INT sscan_word();
extern OP s_sc_d();
extern INT s_sc_di();
extern OP s_sch_k();
extern INT s_sch_ki();
extern OP s_sch_n();
extern OP s_sch_s();
extern OP s_sch_si();
extern INT s_sch_sii();
extern OP s_sch_sl();
extern INT s_sch_sli();
extern OP s_sc_p();
extern OP s_sc_pi();
extern INT s_sc_pli();
extern OP s_sc_w();
extern OP s_sc_wi();
extern INT s_sc_wii();
extern INT s_sc_wli();
extern OP s_s_k();
extern INT s_s_ki();
extern OP s_s_n();
extern OP s_spa_g();
extern OP s_spa_gi();
extern INT s_spa_gii();
extern INT s_spa_gli();
extern OP s_spa_k();
extern OP s_spa_ki();
extern INT s_spa_kii();
extern INT s_spa_kli();
extern OP s_s_s();
extern OP s_s_si();
extern INT s_s_sii();
extern OP s_s_sl();
extern INT s_s_sli();
extern INT standardise_cold_tableaux_list ();
extern INT standardise_cyclo();
extern INT standardp();
extern INT starpart();
extern INT starting_bar_schubert();
extern INT start_longint();
extern INT starttableaux();
extern INT std_perm();
extern OP s_t_h();
extern INT s_t_hi();
extern OP s_t_ij();
extern INT s_t_iji();
extern INT stirling_first_tafel();
extern INT stirling_numbers_second_kind_vector();
extern INT stirling_second_number_kostka();
extern INT stirling_second_number();
extern INT stirling_second_number_tafel();
extern INT stirling_second_tafel();
extern OP s_t_l();
extern INT s_t_li();
extern INT store_result_0();
extern INT store_result_1();
extern INT store_result_2();
extern INT store_result_3();
extern INT store_result_4();
extern INT store_result_5();
extern INT strictp();
extern INT strict_to_odd_part();
extern INT strong_check_barp();
extern INT strong_check_permutationp();
extern INT strong_generators();
extern OP s_t_s();
extern OP s_t_u();
extern OP s_t_ug();
extern INT s_t_ugii();
extern INT s_t_ugli();
extern OP s_t_ui();
extern INT s_t_uii();
extern OP s_t_uk();
extern INT s_t_ukii();
extern INT s_t_ukli();
extern OP s_t_ul();
extern INT s_t_uli();
extern OP s_t_us();
extern INT sub();
extern INT sub_apply();
extern INT sub_comp_bv();
extern INT sub_comp_part();
extern INT sub_default();
extern INT sub_part_part();
extern INT substitute_one_matrix ();
extern INT substitute_one_monopoly ();
extern INT SYM_sum();
extern INT sum_integervector();
extern INT sum_matrix();
extern INT sum_vector();
extern INT sup_bitvector_apply();
extern INT sup_bitvector();
extern OP s_v_i();
extern INT s_v_ii();
extern OP s_v_l();
extern INT s_v_li();
extern OP s_v_s();
extern INT swap();
extern OP s_w_i();
extern INT s_w_ii();
extern OP s_w_l();
extern INT s_w_li();
extern OP s_w_s();
extern INT S_wt();
extern INT s_x_nu_to_ypolynom();
extern INT symchar_hoch_n();
extern INT SYMMETRICA_bricknumber();
extern INT SYMMETRICA_EH();
extern INT SYMMETRICA_EM();
extern INT SYMMETRICA_EP();
extern INT SYMMETRICA_ES();
extern INT SYMMETRICA_HE();
extern INT SYMMETRICA_HM();
extern INT SYMMETRICA_HP();
extern INT SYMMETRICA_HS();
extern INT SYMMETRICA_ME();
extern INT SYMMETRICA_MH();
extern INT SYMMETRICA_MP();
extern INT SYMMETRICA_MS();
extern INT SYMMETRICA_PE();
extern INT SYMMETRICA_PH();
extern INT SYMMETRICA_PM();
extern INT SYMMETRICA_PS();
extern INT SYMMETRICA_SE();
extern INT SYMMETRICA_SH();
extern INT SYMMETRICA_SM();
extern INT SYMMETRICA_SP();
extern INT symmetricp();
extern INT symmetricp_i();
extern INT symmetricp_matrix();
extern INT t_2SCHUBERT_POLYNOM();
extern INT tab_anfang();
extern INT tab_ende();
extern INT tab_funk();
extern INT tableaux_character ();
extern INT tableauxp();
extern INT table_of_gauss_numbers();
extern INT table_of_Rbar_nkq();
extern INT table_of_R_nkq();
extern INT table_of_Sbar_nkq();
extern INT table_of_S_nkq();
extern INT table_of_Tbar_nkq();
extern INT table_of_T_nkq();
extern INT table_of_W_nkq();
extern INT tab_wt();
extern INT t_augpart_part();
extern INT t_BAR_BARCYCLE();
extern INT t_BARCYCLE_BAR();
extern INT t_bar_doubleperm();
extern INT Tbar_nkq_file();
extern INT Tbar_nkq_maxgrad();
extern INT Tbar_nkq_maxgrad();
extern INT t_BINTREE_ELMSYM();
extern INT t_BINTREE_ELMSYM_apply();
extern INT t_BINTREE_GRAL();
extern INT t_BINTREE_HOMSYM();
extern INT t_BINTREE_HOMSYM_apply();
extern INT t_BINTREE_LIST();
extern INT t_BINTREE_MONOMIAL();
extern INT t_BINTREE_MONOMIAL_apply();
extern INT t_BINTREE_POLYNOM();
extern INT t_BINTREE_POLYNOM_apply();
extern INT t_BINTREE_POWSYM();
extern INT t_BINTREE_POWSYM_apply();
extern INT t_BINTREE_SCHUBERT();
extern INT t_BINTREE_SCHUR();
extern INT t_BINTREE_SCHUR_apply();
extern INT t_BINTREE_VECTOR();
extern INT t_BIT_VECTOR();
extern INT t_BITVECTOR_INTVECTOR();
extern INT t_BRUCH_LAURENT();
extern INT teh_elmsym__faktor();
extern INT teh_ende();
extern INT teh___faktor();
extern INT teh_hashtable__faktor();
extern INT teh_integer__faktor();
extern INT teh_integer__faktor();
extern INT teh_partition__faktor();
extern INT teh_partition__faktor_pre290102();
extern INT t_ELMSYM_ELMSYM();
extern INT t_ELMSYM_HASHTABLE();
extern INT t_ELMSYM_HOMSYM();
extern INT t_ELMSYM_MONOMIAL();
extern INT t_ELMSYM_POWSYM();
extern INT t_ELMSYM_SCHUR();
extern INT t_ELMSYM_SCHUR_pre041201();
extern INT tem_ende();
extern INT tem_integer__faktor();
extern INT tem_integer__faktor();
extern INT tem_partition__faktor();
extern INT tep_elmsym__faktor();
extern INT tep_ende();
extern INT tep___faktor();
extern INT tep___faktor();
extern INT tep___faktor();
extern INT tep___faktor();
extern INT tep___faktor();
extern INT tep___faktor();
extern INT tep_hashtable__faktor();
extern INT tep_integer__faktor();
extern INT tep_integer__faktor();
extern INT tep_integer__faktor();
extern INT tep_partition__faktor();
extern INT tep_partition__faktor_pre040202();
extern INT tes_elmsym__faktor();
extern INT tes___faktor();
extern INT tes_hashtable__faktor();
extern INT tes_integer__faktor();
extern INT tes_integer__faktor();
extern INT tes_partition__faktor();
extern INT test_bintree();
extern INT test_brc();
extern INT test_bruch();
extern INT test_callocobject();
extern INT test_dcp();
extern INT test_integer();
extern INT test_kostka();
extern INT test_list();
extern INT test_longint();
extern INT test_matrix();
extern INT test_mdg();
extern INT test_ndg();
extern INT test_number();
extern INT test_object();
extern INT test_perm();
extern INT test_plet();
extern INT test_poly();
extern INT test_schubert();
extern INT test_schur();
extern INT test_symchar();
extern INT test_word();
extern INT tex_2schubert_monom_summe();
extern INT tex_bruch();
extern INT tex_cyclo();
extern INT tex_dia_wt();
extern INT tex_hall_littlewood();
extern INT tex_hecke_monopoly();
extern INT tex_integer();
extern INT tex_kostka();
extern INT tex_lc();
extern INT tex_list();
extern INT tex_longint();
extern INT tex_matrix_co();
extern INT tex_matrix();
extern INT tex_monom();
extern INT tex_monom_plus();
extern INT tex_monopoly();
extern INT tex();
extern INT tex_partition();
extern INT tex_permutation();
extern INT tex_polynom();
extern INT t_EXPONENT_VECTOR();
extern INT t_EXPONENT_VECTOR_apply();
extern INT tex_rz();
extern INT tex_schubert();
extern INT tex_schur();
extern INT tex_sqrad();
extern INT tex_symchar();
extern INT tex_tableaux();
extern INT tex_vector();
extern INT tex_weintraube();
extern INT t_forall_monomials_in_a();
extern INT t_FROBENIUS_VECTOR();
extern INT t_galois_polynom();
extern INT t_HASHTABLE_ELMSYM();
extern INT t_HASHTABLE_ELMSYM_apply();
extern INT t_HASHTABLE_HOMSYM();
extern INT t_HASHTABLE_HOMSYM_apply();
extern INT t_HASHTABLE_MONOMIAL();
extern INT t_HASHTABLE_MONOMIAL_apply();
extern INT t_HASHTABLE_POLYNOM();
extern INT t_HASHTABLE_POLYNOM_apply();
extern INT t_HASHTABLE_POLYNOM_apply();
extern INT t_HASHTABLE_POWSYM();
extern INT t_HASHTABLE_POWSYM_apply();
extern INT t_HASHTABLE_SCHUR();
extern INT t_HASHTABLE_SCHUR_apply();
extern INT t_HASHTABLE_VECTOR();
extern INT the_integer__faktor();
extern INT the_integer__faktor();
extern INT thm_ende();
extern INT thm_integer__faktor();
extern INT thm_integer__faktor();
extern INT thm_partition__faktor();
extern INT t_HOMSYM_ELMSYM();
extern INT t_HOMSYM_HASHTABLE();
extern INT t_HOMSYM_HOMSYM();
extern INT t_HOMSYM_MONOMIAL();
extern INT t_HOMSYM_POWSYM();
extern INT t_HOMSYM_SCHUR();
extern INT thp_ende();
extern INT thp___faktor();
extern INT thp___faktor();
extern INT thp___faktor();
extern INT thp___faktor();
extern INT thp___faktor();
extern INT thp___faktor();
extern INT thp_homsym__faktor();
extern INT thp_integer__faktor();
extern INT thp_integer__faktor();
extern INT thp_integer__faktor();
extern INT thp_partition__faktor();
extern INT thp_partition__faktor_pre300102();
extern INT tidy();
extern INT t_INTEGER_FF();
extern INT t_INTEGER_LAURENT();
extern INT t_int_longint();
extern INT t_INTVECTOR_BITVECTOR();
extern INT t_INTVECTOR_UCHAR();
extern INT t_j_wt();
extern INT t_LAURENT_OBJ();
extern INT t_LIST_POLYNOM();
extern INT t_LIST_VECTOR();
extern INT t_longint_int();
extern INT t_loop_partition();
extern INT t_loop_partition();
extern INT tl_set_index_inc();
extern INT tl_set_max_numb();
extern INT tl_set_prime();
extern INT t_MA_MONOPOLY_MA_POLYNOM();
extern INT tme_ende();
extern INT tme___faktor();
extern INT tme___faktor();
extern INT tme_hashtable__faktor();
extern INT tme_integer__faktor();
extern INT tme_integer__faktor();
extern INT tme_monomial__faktor();
extern INT tme_monomial__faktor();
extern INT tme_partition__faktor();
extern INT tmh_ende();
extern INT tmh___faktor();
extern INT tmh___faktor();
extern INT tmh_integer__faktor();
extern INT tmh_integer__faktor();
extern INT tmh_integer__faktor();
extern INT tmh_integer__faktor();
extern INT tmh_monomial__faktor();
extern INT tmh_partition__faktor();
extern INT t_MONOMIAL_ELMSYM();
extern INT t_MONOMIAL_HASHTABLE();
extern INT t_MONOMIAL_HOMSYM();
extern INT t_MONOMIAL_MONOMIAL();
extern INT t_MONOMIAL_POWSYM();
extern INT t_MONOMIAL_SCHUR();
extern INT t_MONOPOLY_LAURENT();
extern INT t_MONOPOLY_POLYNOM();
extern INT tmp___faktor();
extern INT tmp___faktor();
extern INT tmp___faktor();
extern INT tmp___faktor();
extern INT tmp_integer__faktor();
extern INT tmp_int__faktor();
extern INT tmp_monomial__faktor();
extern INT tmp_monomial__faktor();
extern INT tmp_partition__faktor();
extern INT T_nkq_file();
extern INT T_nkq_maxgrad();
extern INT T_nkq_maxgrad_erweitert();
extern INT T_nkq_maxgrad_erweitert();
extern INT T_nkq_maxgrad();
extern INT t_OBJ_LAURENT();
extern INT t_PARTITION_AUGPART();
extern INT tpe___faktor();
extern INT tpe_hashtable__faktor();
extern INT tpe_integer__faktor();
extern INT tpe_partition__faktor();
extern INT tpe_partition__faktor_pre300102();
extern INT tpe_powsym__faktor();
extern INT t_PERMUTATION_SCHUBERT();
extern INT tph___faktor();
extern INT tph_hashtable__faktor();
extern INT tph_integer__faktor();
extern INT tph_partition__faktor();
extern INT tph_partition__faktor_pre300102();
extern INT tph_powsym__faktor();
extern INT tpm___faktor();
extern INT tpm_hashtable__faktor();
extern INT tpm_integer__faktor();
extern INT tpm_partition__faktor();
extern INT tpm_powsym__faktor();
extern INT t_POLYNOM_ELMSYM();
extern INT t_polynom_galois();
extern INT t_POLYNOM_LAURENT();
extern INT t_POLYNOM_MONOMIAL();
extern INT t_POLYNOM_MONOPOLY();
extern INT t_POLYNOM_POWER();
extern INT t_POLYNOM_SCHUBERT();
extern INT t_POLYNOM_SCHUR();
extern INT t_POLYNOM_T();
extern INT t_POWSYM_ELMSYM();
extern INT t_POWSYM_HASHTABLE();
extern INT t_POWSYM_HOMSYM();
extern INT t_POWSYM_MONOMIAL();
extern INT t_POWSYM_POWSYM();
extern INT t_POWSYM_SCHUR();
extern INT t_productexponent();
extern INT t_productexponent();
extern INT t_productexponent();
extern INT t_productexponent();
extern INT t_productexponent();
extern INT t_productexponent();
extern INT tps___faktor();
extern INT trace();
extern INT trace_matrix();
extern INT trafo_check();
extern INT trans2formlist();
extern INT transform_apply_list();
extern INT transformlist();
extern INT trans_index_monopoly_cyclo();
extern INT transpose();
extern INT transpose_matrix();
extern INT transpose_second_matrix();
extern INT t_REIHE_POLYNOM();
extern INT t_SCHUBERT_POLYNOM();
extern INT t_SCHUBERT_SCHUR();
extern INT t_SCHUR_ELMSYM();
extern INT t_SCHUR_HASHTABLE();
extern INT t_SCHUR_HOMSYM();
extern INT t_schur_jacobi_trudi();
extern INT t_SCHUR_MONOMIAL();
extern INT t_SCHUR_MONOMIAL_pre211101();
extern INT t_schur_naegelsbach();
extern INT t_SCHUR_POWSYM();
extern INT t_SCHUR_SCHUR();
extern INT t_SCHUR_SYMCHAR();
extern INT tse___faktor();
extern INT tse___faktor();
extern INT tse___faktor_slow();
extern INT tse_integer__faktor();
extern INT tse_partition__faktor();
extern INT tse_partition__faktor_pre040202();
extern INT tse_schur__faktor();
extern INT tsh_eval_jt();
extern INT tsh___faktor();
extern INT tsh___faktor();
extern INT tsh_hashtable__faktor();
extern INT tsh_integer__faktor();
extern INT tsh_integer__faktor();
extern INT tsh_jt();
extern INT tsh_partition__faktor();
extern INT tsh_partition__faktor_pre240102();
extern INT tsh_partition__faktor_pre310102();
extern INT tsh_schur__faktor();
extern INT tsm___faktor();
extern INT tsm_integer__faktor();
extern INT tsm_partition__faktor();
extern INT tsm_schur__faktor();
extern INT tsm_schur__faktor();
extern INT tsp___faktor();
extern INT tsp___faktor();
extern INT tsp___faktor();
extern INT tsp___faktor();
extern INT tsp___faktor();
extern INT tsp_integer__faktor();
extern INT t_splitpart();
extern INT t_splitpart();
extern INT t_splitpart();
extern INT t_splitpart();
extern INT t_splitpart();
extern INT t_splitpart();
extern INT tsp_partition__faktor();
extern INT tsp_schur__faktor();
extern INT tsp_schur__faktor();
extern INT t_UCHAR_INTVECTOR();
extern INT t_VECTOR_BIT();
extern INT t_VECTOR_BITREC();
extern INT t_VECTOR_EXPONENT();
extern INT t_VECTOR_FROB();
extern INT t_VECTOR_FROBENIUS();
extern INT t_VECTOR_LIST();
extern INT t_VECTOR_POLYNOM();
extern INT t_VECTOR_ZYKEL();
extern INT t_vperm_zperm();
extern INT T_weintraube();
extern INT twoword_knuth();
extern INT twoword_matrix();
extern INT txx_null__faktor();
extern INT txx_null__faktor();
extern INT typusorder();
extern INT t_zperm_vperm();
extern INT t_ZYKEL_VECTOR();
extern INT UD_permutation();
extern INT umriss_tableaux();
extern INT unimodalp();
extern INT unitp_galois();
extern INT unrank_degree_permutation();
extern INT unrank_given_q_ff();
extern INT unrank_given_qk_point();
extern INT unrank_k_subset();
extern INT unrank_permutation();
extern INT unrank_subset();
extern INT unset_bm_ij();
extern INT unset_bv_i();
extern INT usersort_vector();
extern INT vander();
extern INT variety_poly();
extern INT vec_anfang();
extern INT vec_ende();
extern INT vec_mat_mult();
extern INT vec_mat_mult();
extern INT vectorofzerodivisors_galois();
extern INT vectorp();
extern INT vertikal_sum();
extern INT vexillaryp();
extern INT vexillaryp_permutation();
extern INT vminus_hecke();
extern INT vminus_tabloid();
extern INT vminus();
extern INT vorgaenger_bruhat();
extern INT vorgaenger_bruhat_strong();
extern INT vorgaenger_bruhat_weak();
extern INT vorgaenger_young();
extern INT vorgaenger_young_skewpartition();
extern INT weight();
extern INT weight_augpart();
extern INT weight_partition();
extern INT weight_skewpartition();
extern INT weight_tableaux();
extern INT weight_vector();
extern INT weintraube_monom();
extern INT weintrauben_polynom();
extern INT weintraube_vector();
extern INT werte_Polynom_aus();
extern INT werte_Polynom_aus();
extern INT wert();
extern INT which_part();
extern INT W_nkq_maxgrad();
extern INT W_nkq_maxgrad();
extern INT wordoftableaux();
extern INT word_schen();
extern INT word_tableaux();
extern INT word_wt();
extern INT wrong_type_oneparameter();
extern INT wrong_type_twoparameter();
extern INT wt_liste_gewicht();
extern INT wt_word();
extern INT ym_min();
extern INT young_alt_scalar_tafel();
extern INT young_character();
extern INT young_ideal();
extern INT youngp();
extern INT young_polynom();
extern INT young_scalar_tafel();
extern INT young_tafel();
extern INT zeilenanfang();
extern INT zeilenende();
extern INT zeilen_summe();
extern INT zentralprim();
extern INT zerlege_nk_codes();
extern INT zerlege_nk_codes();
extern INT zykeldarstellung_matrix();
extern INT zykeldarstellung_matrix_red();
extern INT zykelind_aff1Zn();
extern INT zykelind_affkq();
extern INT zykelind_affkzn();
extern INT zykelind_An();
extern INT zykelind_arb();
extern INT zykelind_centralizer();
extern INT zykelind_Cn();
extern INT zykelind_cube();
extern INT zykelind_cube_edges();
extern INT zykelind_cube_edges_extended();
extern INT zykelind_cube_extended();
extern INT zykelind_cube_faces();
extern INT zykelind_cube_faces_extended();
extern INT zykelind_cube_vertices();
extern INT zykelind_cube_vertices_extended();
extern INT zykelind_dec();
extern INT zykelind_dec_apply();
extern INT zykelind_dir_prod();
extern INT zykelind_dir_prod_apply();
extern INT zykelind_dir_summ();
extern INT zykelind_dir_summ_apply();
extern INT zykelind_Dn();
extern INT zykelind_dodecahedron();
extern INT zykelind_dodecahedron_edges();
extern INT zykelind_dodecahedron_edges_extended();
extern INT zykelind_dodecahedron_extended();
extern INT zykelind_dodecahedron_faces();
extern INT zykelind_dodecahedron_faces_extended();
extern INT zykelind_dodecahedron_vertices();
extern INT zykelind_dodecahedron_vertices_extended();
extern INT zykelind_exponentiation();
extern INT zykelind_glkq();
extern INT zykelind_glkzn();
extern INT zykelind_hoch_dir_prod();
extern INT zykelind_hoch_dir_summ();
extern INT zykelind_inc();
extern INT zykelind_kranz();
extern INT zykelind_on_2sets();
extern INT zykelind_on_ksubsets();
extern INT zykelind_on_ktuples();
extern INT zykelind_on_ktuples_injective();
extern INT zykelind_on_pairs();
extern INT zykelind_on_pairs_disjunkt();
extern INT zykelind_on_pairs_oriented();
extern INT zykelind_on_pairs_reduced();
extern INT zykelind_on_power_set();
extern INT zykelind_pglkq();
extern INT zykelind_plethysm();
extern INT zykelind_Sn();
extern INT zykelind_stabilizer_part();
extern INT zykelind_superp_lin_dir_graphs();
extern INT zykelind_test();
extern INT zykelind_tetraeder();
extern INT zykelind_tetraeder_edges();
extern INT zykelind_tetraeder_edges_extended();
extern INT zykelind_tetraeder_extended();
extern INT zykelind_tetraeder_faces();
extern INT zykelind_tetraeder_faces_extended();
extern INT zykelind_tetraeder_vertices();
extern INT zykelind_tetraeder_vertices_extended();
extern INT zykeltyp();
extern INT zykeltyp_hoch_n();
extern INT zykeltyp_permutation();
extern INT zykeltyp_pi_hoch();
#endif
