/*
 * Decompiled with CFR 0.152.
 */
package adql.translator;

import adql.db.DBColumn;
import adql.db.DBIdentifier;
import adql.db.DBTable;
import adql.db.DBTableAlias;
import adql.db.DBType;
import adql.db.exception.UnresolvedJoinException;
import adql.db.region.Region;
import adql.parser.grammar.ParseException;
import adql.query.ADQLList;
import adql.query.ADQLObject;
import adql.query.ADQLOrder;
import adql.query.ADQLQuery;
import adql.query.ADQLSet;
import adql.query.ClauseADQL;
import adql.query.ClauseConstraints;
import adql.query.ClauseSelect;
import adql.query.ColumnReference;
import adql.query.IdentifierField;
import adql.query.SelectAllColumns;
import adql.query.SelectItem;
import adql.query.SetOperation;
import adql.query.WithItem;
import adql.query.constraint.ADQLConstraint;
import adql.query.constraint.Between;
import adql.query.constraint.Comparison;
import adql.query.constraint.ConstraintsGroup;
import adql.query.constraint.Exists;
import adql.query.constraint.In;
import adql.query.constraint.IsNull;
import adql.query.constraint.NotConstraint;
import adql.query.from.ADQLJoin;
import adql.query.from.ADQLTable;
import adql.query.from.FromContent;
import adql.query.operand.ADQLColumn;
import adql.query.operand.ADQLOperand;
import adql.query.operand.Concatenation;
import adql.query.operand.NegativeOperand;
import adql.query.operand.NumericConstant;
import adql.query.operand.Operation;
import adql.query.operand.StringConstant;
import adql.query.operand.WrappedOperand;
import adql.query.operand.function.ADQLFunction;
import adql.query.operand.function.InUnitFunction;
import adql.query.operand.function.MathFunction;
import adql.query.operand.function.SQLFunction;
import adql.query.operand.function.SQLFunctionType;
import adql.query.operand.function.UserDefinedFunction;
import adql.query.operand.function.cast.CastFunction;
import adql.query.operand.function.conditional.CoalesceFunction;
import adql.query.operand.function.geometry.AreaFunction;
import adql.query.operand.function.geometry.BoxFunction;
import adql.query.operand.function.geometry.CentroidFunction;
import adql.query.operand.function.geometry.CircleFunction;
import adql.query.operand.function.geometry.ContainsFunction;
import adql.query.operand.function.geometry.DistanceFunction;
import adql.query.operand.function.geometry.ExtractCoord;
import adql.query.operand.function.geometry.ExtractCoordSys;
import adql.query.operand.function.geometry.GeometryFunction;
import adql.query.operand.function.geometry.IntersectsFunction;
import adql.query.operand.function.geometry.PointFunction;
import adql.query.operand.function.geometry.PolygonFunction;
import adql.query.operand.function.geometry.RegionFunction;
import adql.query.operand.function.string.LowerFunction;
import adql.query.operand.function.string.UpperFunction;
import adql.translator.ADQLTranslator;
import adql.translator.TranslationException;
import java.util.Iterator;

public abstract class JDBCTranslator
implements ADQLTranslator {
    public abstract boolean isCaseSensitive(IdentifierField var1);

    public String getQualifiedSchemaName(DBTable table) {
        if (table == null || table.getDBSchemaName() == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        if (table.getDBCatalogName() != null) {
            this.appendIdentifier(buf, table.getDBCatalogName(), IdentifierField.CATALOG).append('.');
        }
        this.appendIdentifier(buf, table.getDBSchemaName(), IdentifierField.SCHEMA);
        return buf.toString();
    }

    public String getQualifiedTableName(DBTable table) {
        return this.getTableName(table, true);
    }

    public String getTableName(DBTable table, boolean withSchema) {
        if (table == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        if (withSchema) {
            buf.append(this.getQualifiedSchemaName(table));
            if (buf.length() > 0) {
                buf.append('.');
            }
        }
        this.appendIdentifier(buf, table.getDBName(), IdentifierField.TABLE);
        return buf.toString();
    }

    public String getColumnName(DBColumn column) {
        return column == null ? "" : this.appendIdentifier(new StringBuffer(), column.getDBName(), IdentifierField.COLUMN).toString();
    }

    public final StringBuffer appendIdentifier(StringBuffer str, String id, IdentifierField field) {
        return this.appendIdentifier(str, id, this.isCaseSensitive(field));
    }

    public StringBuffer appendIdentifier(StringBuffer str, String id, boolean caseSensitive) {
        if (caseSensitive && !DBIdentifier.isDelimited(id)) {
            return str.append(DBIdentifier.denormalize(id, true));
        }
        return str.append(id);
    }

    @Override
    public String translate(ADQLObject obj) throws TranslationException {
        if (obj instanceof ADQLQuery) {
            return this.translate((ADQLQuery)obj);
        }
        if (obj instanceof ADQLList) {
            return this.translate((ADQLList)obj);
        }
        if (obj instanceof SelectItem) {
            return this.translate((SelectItem)obj);
        }
        if (obj instanceof ColumnReference) {
            return this.translate((ColumnReference)obj);
        }
        if (obj instanceof ADQLTable) {
            return this.translate((ADQLTable)obj);
        }
        if (obj instanceof ADQLJoin) {
            return this.translate((ADQLJoin)obj);
        }
        if (obj instanceof ADQLOperand) {
            return this.translate((ADQLOperand)obj);
        }
        if (obj instanceof ADQLConstraint) {
            return this.translate((ADQLConstraint)obj);
        }
        if (obj instanceof WithItem) {
            return this.translate((WithItem)obj);
        }
        return obj.toADQL();
    }

    @Override
    public String translate(ADQLSet set) throws TranslationException {
        if (set instanceof ADQLQuery) {
            return this.translate((ADQLQuery)set);
        }
        if (set instanceof SetOperation) {
            return this.translate((SetOperation)set);
        }
        return set.toADQL();
    }

    @Override
    public String translate(ADQLQuery query) throws TranslationException {
        StringBuffer sql = new StringBuffer();
        if (!query.getWith().isEmpty()) {
            sql.append(this.translate(query.getWith())).append('\n');
        }
        sql.append(this.translate(query.getSelect()));
        sql.append("\nFROM ").append(this.translate(query.getFrom()));
        if (!query.getWhere().isEmpty()) {
            sql.append('\n').append(this.translate(query.getWhere()));
        }
        if (!query.getGroupBy().isEmpty()) {
            sql.append('\n').append(this.translate((ADQLList<? extends ADQLObject>)query.getGroupBy()));
        }
        if (!query.getHaving().isEmpty()) {
            sql.append('\n').append(this.translate(query.getHaving()));
        }
        if (!query.getOrderBy().isEmpty()) {
            sql.append('\n').append(this.translate((ADQLList<? extends ADQLObject>)query.getOrderBy()));
        }
        if (query.hasLimit()) {
            sql.append("\nLIMIT ").append(query.getLimit());
        }
        if (query.getOffset() != null) {
            sql.append("\nOFFSET ").append(query.getOffset().getValue());
        }
        return sql.toString();
    }

    @Override
    public String translate(SetOperation set) throws TranslationException {
        boolean extendedSetExp;
        StringBuffer sql = new StringBuffer();
        if (!set.getWith().isEmpty()) {
            sql.append(this.translate(set.getWith())).append('\n');
        }
        boolean bl = extendedSetExp = set.getLeftSet() instanceof SetOperation || set.getLeftSet().hasLimit() || !set.getLeftSet().getWith().isEmpty() || !set.getLeftSet().getOrderBy().isEmpty() || set.getLeftSet().getOffset() != null;
        if (extendedSetExp) {
            sql.append('(');
        }
        sql.append(this.translate(set.getLeftSet()));
        if (extendedSetExp) {
            sql.append(')');
        }
        sql.append('\n');
        sql.append((Object)set.getOperation());
        if (set.isWithDuplicates()) {
            sql.append(" ALL");
        }
        sql.append('\n');
        boolean bl2 = extendedSetExp = set.getRightSet() instanceof SetOperation || set.getRightSet().hasLimit() || !set.getRightSet().getWith().isEmpty() || !set.getRightSet().getOrderBy().isEmpty() || set.getRightSet().getOffset() != null;
        if (extendedSetExp) {
            sql.append('(');
        }
        sql.append(this.translate(set.getRightSet()));
        if (extendedSetExp) {
            sql.append(')');
        }
        if (!set.getOrderBy().isEmpty()) {
            sql.append('\n').append(this.translate((ADQLList<? extends ADQLObject>)set.getOrderBy()));
        }
        if (set.getOffset() != null) {
            sql.append("\nOFFSET ").append(set.getOffset().getValue());
        }
        return sql.toString();
    }

    @Override
    public String translate(ADQLList<? extends ADQLObject> list) throws TranslationException {
        if (list instanceof ClauseSelect) {
            return this.translate((ClauseSelect)list);
        }
        if (list instanceof ClauseConstraints) {
            return this.translate((ClauseConstraints)list);
        }
        if (list instanceof Concatenation) {
            return this.getDefaultADQLList(list, false);
        }
        return this.getDefaultADQLList(list);
    }

    protected final String getDefaultADQLList(ADQLList<? extends ADQLObject> list) throws TranslationException {
        return this.getDefaultADQLList(list, true);
    }

    protected String getDefaultADQLList(ADQLList<? extends ADQLObject> list, boolean withNamePrefix) throws TranslationException {
        String sql = list.getName() == null || !withNamePrefix ? "" : list.getName() + " ";
        for (int i = 0; i < list.size(); ++i) {
            sql = sql + (i == 0 ? "" : " " + list.getSeparator(i) + " ") + this.translate(list.get(i));
        }
        return sql;
    }

    @Override
    public String translate(ClauseADQL<WithItem> clause) throws TranslationException {
        return this.getDefaultADQLList(clause);
    }

    @Override
    public String translate(ClauseSelect clause) throws TranslationException {
        String sql = null;
        for (int i = 0; i < clause.size(); ++i) {
            sql = i == 0 ? clause.getName() + (clause.distinctColumns() ? " DISTINCT" : "") : sql + " " + clause.getSeparator(i);
            sql = sql + " " + this.translate((SelectItem)clause.get(i));
        }
        return sql;
    }

    @Override
    public String translate(ClauseConstraints clause) throws TranslationException {
        if (clause instanceof ConstraintsGroup) {
            return "(" + this.getDefaultADQLList(clause) + ")";
        }
        return this.getDefaultADQLList(clause);
    }

    @Override
    public String translate(WithItem item) throws TranslationException {
        StringBuffer translation = new StringBuffer();
        if (item.getDBLink() != null) {
            this.appendIdentifier(translation, item.getDBLink().isCaseSensitive() ? item.getDBLink().getDBName() : item.getDBLink().getDBName().toLowerCase(), true);
        } else {
            this.appendIdentifier(translation, item.isLabelCaseSensitive() ? item.getLabel() : item.getLabel().toLowerCase(), true);
        }
        translation.append(" AS (\n").append(this.translate(item.getQuery())).append("\n)");
        return translation.toString();
    }

    @Override
    public String translate(SelectItem item) throws TranslationException {
        if (item instanceof SelectAllColumns) {
            return this.translate((SelectAllColumns)item);
        }
        StringBuffer translation = new StringBuffer(this.translate(item.getOperand()));
        if (item.hasAlias()) {
            translation.append(" AS ");
            this.appendIdentifier(translation, item.isCaseSensitive() ? item.getAlias() : item.getAlias().toLowerCase(), true);
        } else {
            translation.append(" AS ");
            this.appendIdentifier(translation, item.getName(), true);
        }
        return translation.toString();
    }

    @Override
    public String translate(SelectAllColumns item) throws TranslationException {
        Iterable<DBColumn> dbCols = null;
        if (item.getAdqlTable() != null && item.getAdqlTable().getDBLink() != null) {
            ADQLTable table = item.getAdqlTable();
            dbCols = table.getDBLink();
        } else if (item.getQuery() != null) {
            try {
                dbCols = item.getQuery().getFrom().getDBColumns();
            }
            catch (UnresolvedJoinException pe) {
                throw new TranslationException("Due to a join problem, the ADQL to SQL translation can not be completed!", pe);
            }
        }
        if (dbCols != null) {
            StringBuffer cols = new StringBuffer();
            for (DBColumn col : dbCols) {
                if (cols.length() > 0) {
                    cols.append(" , ");
                }
                if (col.getTable() != null) {
                    if (col.getTable() instanceof DBTableAlias) {
                        cols.append(this.getTableName(col.getTable(), false)).append('.');
                    } else {
                        cols.append(this.getQualifiedTableName(col.getTable())).append('.');
                    }
                }
                this.appendIdentifier(cols, col.getDBName(), IdentifierField.COLUMN);
                cols.append(" AS ");
                this.appendIdentifier(cols, col.isCaseSensitive() ? col.getADQLName() : col.getADQLName().toLowerCase(), true);
            }
            return cols.length() > 0 ? cols.toString() : item.toADQL();
        }
        return item.toADQL();
    }

    @Override
    public String translate(ColumnReference ref) throws TranslationException {
        return this.getDefaultColumnReference(ref);
    }

    protected String getDefaultColumnReference(ColumnReference ref) throws TranslationException {
        return "" + ref.getColumnIndex();
    }

    @Override
    public String translate(ADQLOrder order) throws TranslationException {
        if (order.getColumnReference() != null) {
            return this.translate(order.getColumnReference()) + (order.isDescSorting() ? " DESC" : " ASC");
        }
        return this.translate(order.getExpression()) + (order.isDescSorting() ? " DESC" : " ASC");
    }

    @Override
    public String translate(FromContent content) throws TranslationException {
        if (content instanceof ADQLTable) {
            return this.translate((ADQLTable)content);
        }
        if (content instanceof ADQLJoin) {
            return this.translate((ADQLJoin)content);
        }
        return content.toADQL();
    }

    @Override
    public String translate(ADQLTable table) throws TranslationException {
        StringBuffer sql = new StringBuffer();
        if (table.isSubQuery()) {
            sql.append('(').append(this.translate(table.getSubQuery())).append(')');
        } else if (table.getDBLink() != null) {
            if (table.getDBLink() instanceof DBTableAlias) {
                sql.append(this.getQualifiedTableName(((DBTableAlias)table.getDBLink()).getOriginTable()));
            } else {
                sql.append(this.getQualifiedTableName(table.getDBLink()));
            }
        } else {
            sql.append(table.getFullTableName());
        }
        if (table.hasAlias()) {
            sql.append(" AS ");
            if (table.getDBLink() != null) {
                this.appendIdentifier(sql, table.getDBLink().isCaseSensitive() ? table.getDBLink().getDBName() : table.getDBLink().getDBName().toLowerCase(), true);
            } else {
                this.appendIdentifier(sql, table.isCaseSensitive(IdentifierField.ALIAS) ? table.getAlias() : table.getAlias().toLowerCase(), true);
            }
        }
        return sql.toString();
    }

    @Override
    public String translate(ADQLJoin join) throws TranslationException {
        StringBuffer sql = new StringBuffer(this.translate(join.getLeftTable()));
        if (join.isNatural()) {
            sql.append(" NATURAL");
        }
        sql.append(' ').append(join.getJoinType()).append(' ').append(this.translate(join.getRightTable())).append(' ');
        if (!join.isNatural()) {
            if (join.getJoinCondition() != null) {
                sql.append(this.translate(join.getJoinCondition()));
            } else if (join.hasJoinedColumns()) {
                StringBuffer cols = new StringBuffer();
                Iterator<ADQLColumn> it = join.getJoinedColumns();
                while (it.hasNext()) {
                    ADQLColumn item = it.next();
                    if (cols.length() > 0) {
                        cols.append(", ");
                    }
                    if (item.getDBLink() == null) {
                        this.appendIdentifier(cols, item.getColumnName(), item.isCaseSensitive(IdentifierField.COLUMN));
                        continue;
                    }
                    this.appendIdentifier(cols, item.getDBLink().getDBName(), IdentifierField.COLUMN);
                }
                sql.append("USING (").append(cols).append(')');
            }
        }
        return sql.toString();
    }

    @Override
    public String translate(ADQLOperand op) throws TranslationException {
        if (op instanceof ADQLColumn) {
            return this.translate((ADQLColumn)op);
        }
        if (op instanceof Concatenation) {
            return this.translate((Concatenation)op);
        }
        if (op instanceof NegativeOperand) {
            return this.translate((NegativeOperand)op);
        }
        if (op instanceof NumericConstant) {
            return this.translate((NumericConstant)op);
        }
        if (op instanceof StringConstant) {
            return this.translate((StringConstant)op);
        }
        if (op instanceof WrappedOperand) {
            return this.translate((WrappedOperand)op);
        }
        if (op instanceof Operation) {
            return this.translate((Operation)op);
        }
        if (op instanceof ADQLFunction) {
            return this.translate((ADQLFunction)op);
        }
        return op.toADQL();
    }

    @Override
    public String translate(ADQLColumn column) throws TranslationException {
        if (column.getDBLink() != null) {
            DBColumn dbCol = column.getDBLink();
            StringBuffer colName = new StringBuffer();
            if (dbCol.getTable() != null && dbCol.getTable().getDBName() != null) {
                colName.append(this.getQualifiedTableName(dbCol.getTable())).append('.');
            } else if (column.getTableName() != null) {
                colName = column.getFullColumnPrefix().append('.');
            }
            this.appendIdentifier(colName, dbCol.getDBName(), IdentifierField.COLUMN);
            return colName.toString();
        }
        return column.getFullColumnName();
    }

    @Override
    public String translate(Concatenation concat) throws TranslationException {
        return this.translate((ADQLList<? extends ADQLObject>)concat);
    }

    @Override
    public String translate(NegativeOperand negOp) throws TranslationException {
        return "-" + this.translate(negOp.getOperand());
    }

    @Override
    public String translate(NumericConstant numConst) throws TranslationException {
        if (numConst.isHexadecimal()) {
            try {
                int nbDigits = numConst.getValue().length() - 2;
                if (nbDigits <= 8) {
                    return "" + Integer.parseUnsignedInt(numConst.getValue().substring(2), 16);
                }
                return "" + Long.parseUnsignedLong(numConst.getValue().substring(2), 16);
            }
            catch (NumberFormatException nfe) {
                throw new TranslationException("Impossible to evaluate the given hexadecimal expression: \"" + numConst.getValue() + "\"!", nfe);
            }
        }
        return numConst.getValue();
    }

    @Override
    public String translate(StringConstant strConst) throws TranslationException {
        return "'" + strConst.getValue().replaceAll("'", "''") + "'";
    }

    @Override
    public String translate(WrappedOperand op) throws TranslationException {
        return "(" + this.translate(op.getOperand()) + ")";
    }

    @Override
    public String translate(Operation op) throws TranslationException {
        return "(" + this.translate(op.getLeftOperand()) + op.getOperation().toADQL() + this.translate(op.getRightOperand()) + ")";
    }

    @Override
    public String translate(ADQLConstraint cons) throws TranslationException {
        if (cons instanceof Comparison) {
            return this.translate((Comparison)cons);
        }
        if (cons instanceof Between) {
            return this.translate((Between)cons);
        }
        if (cons instanceof Exists) {
            return this.translate((Exists)cons);
        }
        if (cons instanceof In) {
            return this.translate((In)cons);
        }
        if (cons instanceof IsNull) {
            return this.translate((IsNull)cons);
        }
        if (cons instanceof NotConstraint) {
            return this.translate((NotConstraint)cons);
        }
        return cons.toADQL();
    }

    @Override
    public String translate(Comparison comp) throws TranslationException {
        return this.translate(comp.getLeftOperand()) + " " + comp.getOperator().toADQL() + " " + this.translate(comp.getRightOperand());
    }

    @Override
    public String translate(Between comp) throws TranslationException {
        return this.translate(comp.getLeftOperand()) + " " + comp.getName() + " " + this.translate(comp.getMinOperand()) + " AND " + this.translate(comp.getMaxOperand());
    }

    @Override
    public String translate(Exists exists) throws TranslationException {
        return "EXISTS(" + this.translate(exists.getSubQuery()) + ")";
    }

    @Override
    public String translate(In in) throws TranslationException {
        return this.translate(in.getOperand()) + " " + in.getName() + " (" + (in.hasSubQuery() ? this.translate(in.getSubQuery()) : this.translate(in.getValuesList())) + ")";
    }

    @Override
    public String translate(IsNull isNull) throws TranslationException {
        return this.translate(isNull.getColumn()) + " " + isNull.getName();
    }

    @Override
    public String translate(NotConstraint notCons) throws TranslationException {
        return "NOT " + this.translate(notCons.getConstraint());
    }

    @Override
    public String translate(ADQLFunction fct) throws TranslationException {
        if (fct instanceof GeometryFunction) {
            return this.translate((GeometryFunction)fct);
        }
        if (fct instanceof MathFunction) {
            return this.translate((MathFunction)fct);
        }
        if (fct instanceof SQLFunction) {
            return this.translate((SQLFunction)fct);
        }
        if (fct instanceof UserDefinedFunction) {
            return this.translate((UserDefinedFunction)fct);
        }
        if (fct instanceof LowerFunction) {
            return this.translate((LowerFunction)fct);
        }
        if (fct instanceof UpperFunction) {
            return this.translate((UpperFunction)fct);
        }
        if (fct instanceof InUnitFunction) {
            return this.translate((InUnitFunction)fct);
        }
        if (fct instanceof CastFunction) {
            return this.translate((CastFunction)fct);
        }
        return this.getDefaultADQLFunction(fct);
    }

    public final String getDefaultADQLFunction(ADQLFunction fct) throws TranslationException {
        StringBuilder sql = new StringBuilder(fct.getName());
        sql.append('(');
        for (int i = 0; i < fct.getNbParameters(); ++i) {
            if (i > 0) {
                sql.append(',').append(' ');
            }
            sql.append(this.translate(fct.getParameter(i)));
        }
        sql.append(')');
        return sql.toString();
    }

    @Override
    public String translate(SQLFunction fct) throws TranslationException {
        if (fct.getType() == SQLFunctionType.COUNT_ALL) {
            return "COUNT(" + (fct.isDistinct() ? "DISTINCT " : "") + "*)";
        }
        return fct.getName() + "(" + (fct.isDistinct() ? "DISTINCT " : "") + this.translate(fct.getParameter(0)) + ")";
    }

    @Override
    public String translate(MathFunction fct) throws TranslationException {
        return this.getDefaultADQLFunction(fct);
    }

    @Override
    public String translate(UserDefinedFunction fct) throws TranslationException {
        String tr = fct.translate(this);
        if (tr == null) {
            return this.getDefaultADQLFunction(fct);
        }
        return tr;
    }

    @Override
    public String translate(LowerFunction fct) throws TranslationException {
        return this.getDefaultADQLFunction(fct);
    }

    @Override
    public String translate(UpperFunction fct) throws TranslationException {
        return this.getDefaultADQLFunction(fct);
    }

    public final String getDefaultCastFunction(CastFunction fct) throws TranslationException {
        StringBuilder sql = new StringBuilder(fct.getName());
        sql.append('(');
        sql.append(fct.getValue() == null ? "NULL" : this.translate(fct.getValue()));
        sql.append(" AS ");
        DBType returnType = fct.getTargetType().getReturnType();
        if (returnType != null) {
            sql.append(this.convertTypeToDB(returnType));
        } else {
            sql.append(fct.getTargetType().toADQL());
        }
        sql.append(')');
        return sql.toString();
    }

    @Override
    public String translate(CastFunction fct) throws TranslationException {
        if (fct.getFunctionTranslator() != null) {
            return fct.getFunctionTranslator().translate(fct, this);
        }
        return this.getDefaultCastFunction(fct);
    }

    @Override
    public String translate(CoalesceFunction fct) throws TranslationException {
        return this.getDefaultADQLFunction(fct);
    }

    @Override
    public String translate(GeometryFunction fct) throws TranslationException {
        if (fct instanceof AreaFunction) {
            return this.translate((AreaFunction)fct);
        }
        if (fct instanceof BoxFunction) {
            return this.translate((BoxFunction)fct);
        }
        if (fct instanceof CentroidFunction) {
            return this.translate((CentroidFunction)fct);
        }
        if (fct instanceof CircleFunction) {
            return this.translate((CircleFunction)fct);
        }
        if (fct instanceof ContainsFunction) {
            return this.translate((ContainsFunction)fct);
        }
        if (fct instanceof DistanceFunction) {
            return this.translate((DistanceFunction)fct);
        }
        if (fct instanceof ExtractCoord) {
            return this.translate((ExtractCoord)fct);
        }
        if (fct instanceof ExtractCoordSys) {
            return this.translate((ExtractCoordSys)fct);
        }
        if (fct instanceof IntersectsFunction) {
            return this.translate((IntersectsFunction)fct);
        }
        if (fct instanceof PointFunction) {
            return this.translate((PointFunction)fct);
        }
        if (fct instanceof PolygonFunction) {
            return this.translate((PolygonFunction)fct);
        }
        if (fct instanceof RegionFunction) {
            return this.translate((RegionFunction)fct);
        }
        return this.getDefaultADQLFunction(fct);
    }

    @Override
    public String translate(RegionFunction fct) throws TranslationException {
        if (fct != null && fct.getParameter(0) != null) {
            if (!fct.isExtendedRegionExpression() && fct.getParameter(0) instanceof StringConstant) {
                String regionStr = ((StringConstant)fct.getParameter(0)).getValue();
                try {
                    Region region = Region.parse(regionStr);
                    return this.translate(region.toGeometry());
                }
                catch (ParseException pe) {
                    throw new TranslationException("Unsupported region serialization!", pe);
                }
            }
            return this.getDefaultADQLFunction(fct);
        }
        throw new TranslationException("Missing REGION function (or its parameter) to translate!");
    }

    @Override
    public String translate(GeometryFunction.GeometryValue<? extends GeometryFunction> geomValue) throws TranslationException {
        return this.translate(geomValue.getValue());
    }

    public abstract DBType convertTypeFromDB(int var1, String var2, String var3, String[] var4);

    public abstract String convertTypeToDB(DBType var1);

    public abstract Region translateGeometryFromDB(Object var1) throws ParseException;

    public abstract Object translateGeometryToDB(Region var1) throws ParseException;
}

