use crate::os::raw::c_int;

mod fs;
pub mod sockets;
pub use self::fs::*;
// `solid_types.h`
pub use super::itron::abi::{E_TMOUT, ER, ER_ID, ID};

pub const SOLID_ERR_NOTFOUND: ER = -1000;
pub const SOLID_ERR_NOTSUPPORTED: ER = -1001;
pub const SOLID_ERR_EBADF: ER = -1002;
pub const SOLID_ERR_INVALIDCONTENT: ER = -1003;
pub const SOLID_ERR_NOTUSED: ER = -1004;
pub const SOLID_ERR_ALREADYUSED: ER = -1005;
pub const SOLID_ERR_OUTOFBOUND: ER = -1006;
pub const SOLID_ERR_BADSEQUENCE: ER = -1007;
pub const SOLID_ERR_UNKNOWNDEVICE: ER = -1008;
pub const SOLID_ERR_BUSY: ER = -1009;
pub const SOLID_ERR_TIMEOUT: ER = -1010;
pub const SOLID_ERR_INVALIDACCESS: ER = -1011;
pub const SOLID_ERR_NOTREADY: ER = -1012;

// `solid_rtc.h`
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SOLID_RTC_TIME {
    pub tm_sec: c_int,
    pub tm_min: c_int,
    pub tm_hour: c_int,
    pub tm_mday: c_int,
    pub tm_mon: c_int,
    pub tm_year: c_int,
    pub tm_wday: c_int,
}

unsafe extern "C" {
    pub fn SOLID_RTC_ReadTime(time: *mut SOLID_RTC_TIME) -> c_int;
}

// `solid_log.h`
unsafe extern "C" {
    pub fn SOLID_LOG_write(s: *const u8, l: usize);
}

// `solid_mem.h`
unsafe extern "C" {
    pub fn SOLID_TLS_AddDestructor(id: i32, dtor: unsafe extern "C" fn(*mut u8));
}

// `solid_rng.h`
unsafe extern "C" {
    pub fn SOLID_RNG_SampleRandomBytes(buffer: *mut u8, length: usize) -> c_int;
}

// `rwlock.h`
unsafe extern "C" {
    pub fn rwl_loc_rdl(id: ID) -> ER;
    pub fn rwl_loc_wrl(id: ID) -> ER;
    pub fn rwl_ploc_rdl(id: ID) -> ER;
    pub fn rwl_ploc_wrl(id: ID) -> ER;
    pub fn rwl_unl_rwl(id: ID) -> ER;
    pub fn rwl_acre_rwl() -> ER_ID;
    pub fn rwl_del_rwl(id: ID) -> ER;
}
