# -*- encoding:utf-8; warn-indent:false; frozen_string_literal: true  -*-

# line 1 "lib/parser/lexer.rl"

# line 3 "lib/parser/lexer.rl"
#
# === BEFORE YOU START ===
#
# Read the Ruby Hacking Guide chapter 11, available in English at
# http://whitequark.org/blog/2013/04/01/ruby-hacking-guide-ch-11-finite-state-lexer/
#
# Remember two things about Ragel scanners:
#
#   1) Longest match wins.
#
#   2) If two matches have the same length, the first
#      in source code wins.
#
# General rules of making Ragel and Bison happy:
#
#  * `p` (position) and `@te` contain the index of the character
#    they're pointing to ("current"), plus one. `@ts` contains the index
#    of the corresponding character. The code for extracting matched token is:
#
#       @source_buffer.slice(@ts...@te)
#
#  * If your input is `foooooooobar` and the rule is:
#
#       'f' 'o'+
#
#    the result will be:
#
#       foooooooobar
#       ^ ts=0   ^ p=te=9
#
#  * A Ragel lexer action should not emit more than one token, unless
#    you know what you are doing.
#
#  * All Ragel commands (fnext, fgoto, ...) end with a semicolon.
#
#  * If an action emits the token and transitions to another state, use
#    these Ragel commands:
#
#       emit($whatever)
#       fnext $next_state; fbreak;
#
#    If you perform `fgoto` in an action which does not emit a token nor
#    rewinds the stream pointer, the parser's side-effectful,
#    context-sensitive lookahead actions will break in a hard to detect
#    and debug way.
#
#  * If an action does not emit a token:
#
#       fgoto $next_state;
#
#  * If an action features lookbehind, i.e. matches characters with the
#    intent of passing them to another action:
#
#       p = @ts - 1
#       fgoto $next_state;
#
#    or, if the lookbehind consists of a single character:
#
#       fhold; fgoto $next_state;
#
#  * Ragel merges actions. So, if you have `e_lparen = '(' %act` and
#    `c_lparen = '('` and a lexer action `e_lparen | c_lparen`, the result
#    _will_ invoke the action `act`.
#
#    e_something stands for "something with **e**mbedded action".
#
#  * EOF is explicit and is matched by `c_eof`. If you want to introspect
#    the state of the lexer, add this rule to the state:
#
#       c_eof => do_eof;
#
#  * If you proceed past EOF, the lexer will complain:
#
#       NoMethodError: undefined method `ord' for nil:NilClass
#

class Parser::Lexer

  
# line 85 "lib/parser/lexer.rb"
class << self
	attr_accessor :_lex_trans_keys
	private :_lex_trans_keys, :_lex_trans_keys=
end
self._lex_trans_keys = [
	0, 0, 101, 101, 103, 103, 
	105, 105, 110, 110, 69, 
	69, 78, 78, 68, 68, 
	95, 95, 95, 95, 0, 26, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 45, 
	0, 77, 0, 77, 0, 92, 
	0, 26, 0, 26, 0, 
	45, 0, 99, 0, 26, 
	67, 99, 45, 45, 0, 92, 
	0, 77, 0, 102, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 45, 0, 77, 
	0, 77, 0, 92, 0, 
	26, 0, 26, 0, 45, 
	0, 99, 0, 26, 67, 99, 
	45, 45, 0, 92, 0, 
	77, 0, 102, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 26, 0, 
	127, 58, 58, 58, 58, 
	0, 127, 58, 58, 60, 60, 
	62, 62, 10, 10, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 115, 115, 
	99, 99, 117, 117, 101, 101, 
	108, 116, 101, 101, 115, 
	115, 115, 115, 105, 105, 
	108, 108, 105, 105, 108, 108, 
	58, 58, 0, 127, 10, 
	10, 0, 127, 9, 92, 
	10, 10, 9, 92, 58, 58, 
	98, 98, 101, 101, 103, 
	103, 105, 105, 110, 110, 
	0, 122, 61, 61, 9, 92, 
	9, 92, 9, 92, 9, 
	92, 9, 92, 10, 10, 
	0, 127, 0, 127, 61, 126, 
	93, 93, 0, 127, 0, 
	127, 10, 10, 34, 34, 
	10, 10, 39, 39, 0, 127, 
	10, 96, 96, 96, 0, 
	45, 0, 77, 0, 77, 
	0, 92, 0, 26, 0, 26, 
	0, 45, 0, 99, 0, 
	26, 67, 99, 45, 45, 
	0, 92, 0, 77, 0, 102, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 58, 58, 58, 58, 
	0, 127, 43, 57, 48, 
	57, 48, 57, 48, 57, 
	48, 57, 115, 115, 99, 99, 
	117, 117, 101, 101, 99, 
	99, 117, 117, 101, 101, 
	0, 127, 58, 58, 9, 92, 
	9, 92, 9, 92, 9, 
	92, 9, 92, 9, 92, 
	60, 60, 10, 10, 9, 92, 
	9, 92, 10, 10, 10, 
	10, 10, 10, 10, 10, 
	46, 46, 0, 95, 9, 32, 
	0, 0, 10, 10, 10, 
	10, 98, 98, 9, 32, 
	10, 10, 95, 95, 0, 92, 
	9, 32, 36, 123, 0, 
	127, 48, 57, 0, 127, 
	0, 120, 0, 0, 0, 0, 
	48, 55, 48, 55, 0, 
	0, 0, 0, 0, 92, 
	0, 0, 0, 0, 0, 0, 
	0, 92, 45, 45, 0, 
	0, 0, 0, 0, 0, 
	0, 92, 0, 45, 0, 92, 
	0, 92, 0, 0, 0, 
	0, 0, 92, 0, 45, 
	10, 10, 0, 92, 48, 123, 
	48, 102, 48, 102, 48, 
	102, 0, 0, 0, 125, 
	0, 125, 0, 0, 0, 125, 
	0, 0, 0, 125, 0, 
	125, 0, 125, 0, 125, 
	0, 0, 0, 125, 0, 125, 
	0, 125, 0, 125, 0, 
	125, 0, 125, 0, 0, 
	0, 0, 48, 102, 0, 0, 
	0, 92, 36, 123, 0, 
	127, 48, 57, 0, 127, 
	0, 120, 0, 0, 0, 0, 
	48, 55, 48, 55, 0, 
	0, 0, 0, 0, 92, 
	0, 0, 0, 0, 0, 0, 
	0, 92, 45, 45, 0, 
	0, 0, 0, 0, 0, 
	0, 92, 0, 45, 0, 92, 
	0, 92, 0, 0, 0, 
	0, 0, 92, 0, 45, 
	10, 10, 0, 92, 48, 123, 
	48, 102, 48, 102, 48, 
	102, 0, 0, 0, 125, 
	0, 125, 0, 0, 0, 125, 
	0, 0, 0, 125, 0, 
	125, 0, 125, 0, 125, 
	0, 0, 0, 125, 0, 125, 
	0, 125, 0, 125, 0, 
	125, 0, 125, 0, 0, 
	0, 0, 48, 102, 0, 0, 
	0, 92, 9, 32, 0, 
	26, 0, 92, 0, 26, 
	0, 35, 36, 123, 0, 127, 
	48, 57, 0, 127, 0, 
	26, 0, 35, 9, 32, 
	36, 123, 0, 127, 48, 57, 
	0, 127, 0, 32, 9, 
	32, 65, 122, 65, 122, 
	36, 64, 0, 127, 48, 57, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 9, 32, 
	0, 0, 61, 126, 10, 10, 
	10, 10, 0, 127, 0, 
	127, 48, 57, 115, 115, 
	38, 38, 42, 42, 64, 64, 
	58, 58, 60, 61, 62, 
	62, 61, 126, 61, 61, 
	61, 62, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	93, 93, 10, 10, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 124, 
	124, 0, 127, 0, 127, 
	9, 32, 10, 10, 10, 10, 
	10, 10, 0, 0, 0, 
	127, 0, 127, 61, 61, 
	0, 0, 9, 32, 0, 0, 
	61, 126, 10, 10, 10, 
	10, 38, 38, 42, 42, 
	64, 64, 60, 61, 62, 62, 
	61, 126, 61, 61, 61, 
	62, 0, 127, 93, 93, 
	10, 10, 124, 124, 0, 126, 
	0, 127, 0, 61, 9, 
	61, 9, 61, 0, 0, 
	9, 61, 9, 62, 46, 46, 
	46, 46, 58, 58, 9, 
	32, 0, 0, 0, 127, 
	0, 0, 9, 124, 0, 0, 
	10, 10, 10, 10, 0, 
	0, 9, 61, 58, 58, 
	60, 60, 62, 62, 9, 32, 
	10, 10, 0, 127, 102, 
	102, 101, 101, 110, 110, 
	104, 104, 0, 127, 0, 127, 
	0, 127, 0, 0, 0, 
	127, 10, 10, 0, 123, 
	9, 32, 10, 10, 10, 10, 
	10, 10, 0, 0, 111, 
	111, 0, 0, 0, 127, 
	0, 127, 9, 32, 0, 0, 
	10, 10, 10, 10, 10, 
	10, 0, 0, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 58, 61, 0, 0, 
	61, 126, 61, 61, 0, 
	0, 0, 0, 0, 0, 
	9, 32, 61, 61, 9, 32, 
	61, 126, 10, 10, 10, 
	10, 65, 122, 0, 122, 
	38, 61, 0, 0, 42, 61, 
	61, 61, 9, 92, 9, 
	92, 9, 92, 46, 46, 
	46, 46, 0, 26, 0, 127, 
	0, 127, 61, 61, 0, 
	0, 61, 126, 61, 62, 
	0, 0, 0, 0, 0, 0, 
	0, 0, 61, 126, 0, 
	127, 48, 57, 38, 38, 
	42, 42, 64, 64, 60, 61, 
	62, 62, 61, 61, 61, 
	62, 0, 127, 48, 57, 
	0, 127, 124, 124, 64, 64, 
	60, 61, 0, 0, 10, 
	34, 10, 39, 96, 96, 
	62, 62, 61, 126, 61, 62, 
	0, 122, 0, 0, 0, 
	127, 0, 127, 0, 120, 
	0, 0, 0, 0, 48, 55, 
	48, 55, 0, 0, 0, 
	0, 0, 92, 0, 0, 
	0, 0, 0, 0, 0, 92, 
	45, 45, 0, 0, 0, 
	0, 0, 0, 0, 92, 
	0, 45, 0, 92, 0, 92, 
	0, 0, 0, 0, 0, 
	92, 0, 45, 10, 10, 
	0, 92, 48, 123, 48, 102, 
	48, 102, 48, 102, 0, 
	0, 0, 125, 0, 125, 
	0, 0, 0, 125, 0, 0, 
	0, 125, 0, 125, 0, 
	125, 0, 125, 0, 0, 
	0, 125, 0, 125, 0, 125, 
	0, 125, 0, 125, 0, 
	125, 0, 125, 0, 125, 
	0, 125, 0, 125, 0, 125, 
	0, 125, 0, 125, 0, 
	125, 0, 125, 0, 125, 
	0, 125, 0, 125, 0, 125, 
	0, 0, 0, 0, 48, 
	102, 0, 0, 0, 127, 
	0, 127, 0, 127, 0, 0, 
	10, 10, 0, 0, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 61, 126, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 0, 61, 
	124, 0, 92, 9, 32, 
	0, 0, 10, 10, 10, 10, 
	10, 10, 0, 0, 0, 
	127, 0, 127, 9, 32, 
	0, 0, 10, 10, 10, 10, 
	10, 10, 0, 0, 0, 
	127, 0, 127, 61, 61, 
	0, 0, 9, 32, 0, 0, 
	61, 126, 10, 10, 10, 
	10, 0, 127, 0, 127, 
	48, 57, 61, 61, 38, 61, 
	0, 0, 0, 0, 42, 
	61, 61, 62, 46, 57, 
	46, 46, 10, 10, 48, 101, 
	48, 95, 46, 120, 48, 
	114, 43, 57, 48, 105, 
	102, 102, 0, 0, 101, 105, 
	0, 0, 0, 0, 48, 
	114, 48, 114, 48, 114, 
	48, 114, 105, 114, 102, 102, 
	0, 0, 101, 105, 115, 
	115, 0, 0, 0, 0, 
	48, 114, 48, 114, 48, 114, 
	48, 114, 48, 114, 48, 
	114, 48, 114, 48, 114, 
	46, 114, 48, 114, 46, 114, 
	48, 114, 58, 58, 60, 
	61, 62, 62, 61, 126, 
	61, 61, 61, 62, 0, 127, 
	0, 127, 0, 0, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 0, 10, 10, 0, 
	0, 0, 0, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 9, 92, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 0, 61, 124, 
	0, 0, 9, 92, 9, 92, 
	9, 92, 10, 10, 46, 
	46, 10, 10, 10, 61, 
	10, 10, 10, 101, 10, 110, 
	10, 100, 10, 10, 0
]

class << self
	attr_accessor :_lex_key_spans
	private :_lex_key_spans, :_lex_key_spans=
end
self._lex_key_spans = [
	0, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 27, 128, 128, 128, 128, 46, 
	78, 78, 93, 27, 27, 46, 100, 27, 
	33, 1, 93, 78, 103, 128, 128, 128, 
	128, 46, 78, 78, 93, 27, 27, 46, 
	100, 27, 33, 1, 93, 78, 103, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 27, 128, 1, 1, 
	128, 1, 1, 1, 1, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 1, 
	1, 1, 1, 9, 1, 1, 1, 1, 
	1, 1, 1, 1, 128, 1, 128, 84, 
	1, 84, 1, 1, 1, 1, 1, 1, 
	123, 1, 84, 84, 84, 84, 84, 1, 
	128, 128, 66, 1, 128, 128, 1, 1, 
	1, 1, 128, 87, 1, 46, 78, 78, 
	93, 27, 27, 46, 100, 27, 33, 1, 
	93, 78, 103, 128, 128, 128, 128, 128, 
	128, 1, 1, 128, 15, 10, 10, 10, 
	10, 1, 1, 1, 1, 1, 1, 1, 
	128, 1, 84, 84, 84, 84, 84, 84, 
	1, 1, 84, 84, 1, 1, 1, 1, 
	1, 96, 24, 0, 1, 1, 1, 24, 
	1, 1, 93, 24, 88, 128, 10, 128, 
	121, 0, 0, 8, 8, 0, 0, 93, 
	0, 0, 0, 93, 1, 0, 0, 0, 
	93, 46, 93, 93, 0, 0, 93, 46, 
	1, 93, 76, 55, 55, 55, 0, 126, 
	126, 0, 126, 0, 126, 126, 126, 126, 
	0, 126, 126, 126, 126, 126, 126, 0, 
	0, 55, 0, 93, 88, 128, 10, 128, 
	121, 0, 0, 8, 8, 0, 0, 93, 
	0, 0, 0, 93, 1, 0, 0, 0, 
	93, 46, 93, 93, 0, 0, 93, 46, 
	1, 93, 76, 55, 55, 55, 0, 126, 
	126, 0, 126, 0, 126, 126, 126, 126, 
	0, 126, 126, 126, 126, 126, 126, 0, 
	0, 55, 0, 93, 24, 27, 93, 27, 
	36, 88, 128, 10, 128, 27, 36, 24, 
	88, 128, 10, 128, 33, 24, 58, 58, 
	29, 128, 10, 128, 128, 128, 128, 24, 
	0, 66, 1, 1, 128, 128, 10, 1, 
	1, 1, 1, 1, 2, 1, 66, 1, 
	2, 128, 128, 128, 128, 128, 128, 128, 
	1, 1, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 1, 128, 128, 
	24, 1, 1, 1, 0, 128, 128, 1, 
	0, 24, 0, 66, 1, 1, 1, 1, 
	1, 2, 1, 66, 1, 2, 128, 1, 
	1, 1, 127, 128, 62, 53, 53, 0, 
	53, 54, 1, 1, 1, 24, 0, 128, 
	0, 116, 0, 1, 1, 0, 53, 1, 
	1, 1, 24, 1, 128, 1, 1, 1, 
	1, 128, 128, 128, 0, 128, 1, 124, 
	24, 1, 1, 1, 0, 1, 0, 128, 
	128, 24, 0, 1, 1, 1, 0, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 4, 0, 66, 1, 0, 0, 0, 
	24, 1, 24, 66, 1, 1, 58, 123, 
	24, 0, 20, 1, 84, 84, 84, 1, 
	1, 27, 128, 128, 1, 0, 66, 2, 
	0, 0, 0, 0, 66, 128, 10, 1, 
	1, 1, 2, 1, 1, 2, 128, 10, 
	128, 1, 1, 2, 0, 25, 30, 1, 
	1, 66, 2, 123, 0, 128, 128, 121, 
	0, 0, 8, 8, 0, 0, 93, 0, 
	0, 0, 93, 1, 0, 0, 0, 93, 
	46, 93, 93, 0, 0, 93, 46, 1, 
	93, 76, 55, 55, 55, 0, 126, 126, 
	0, 126, 0, 126, 126, 126, 126, 0, 
	126, 126, 126, 126, 126, 126, 126, 126, 
	126, 126, 126, 126, 126, 126, 126, 126, 
	126, 126, 126, 0, 0, 55, 0, 128, 
	128, 128, 0, 1, 0, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 66, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 0, 64, 93, 24, 
	0, 1, 1, 1, 0, 128, 128, 24, 
	0, 1, 1, 1, 0, 128, 128, 1, 
	0, 24, 0, 66, 1, 1, 128, 128, 
	10, 1, 24, 0, 0, 20, 2, 12, 
	1, 1, 54, 48, 75, 67, 15, 58, 
	1, 0, 5, 0, 0, 67, 67, 67, 
	67, 10, 1, 0, 5, 1, 0, 0, 
	67, 67, 67, 67, 67, 67, 67, 67, 
	69, 67, 69, 67, 1, 2, 1, 66, 
	1, 2, 128, 128, 0, 128, 128, 128, 
	128, 128, 128, 0, 1, 0, 0, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 84, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 0, 64, 
	0, 84, 84, 84, 1, 1, 1, 52, 
	1, 92, 101, 91, 1
]

class << self
	attr_accessor :_lex_index_offsets
	private :_lex_index_offsets, :_lex_index_offsets=
end
self._lex_index_offsets = [
	0, 0, 2, 4, 6, 8, 10, 12, 
	14, 16, 18, 46, 175, 304, 433, 562, 
	609, 688, 767, 861, 889, 917, 964, 1065, 
	1093, 1127, 1129, 1223, 1302, 1406, 1535, 1664, 
	1793, 1922, 1969, 2048, 2127, 2221, 2249, 2277, 
	2324, 2425, 2453, 2487, 2489, 2583, 2662, 2766, 
	2895, 3024, 3153, 3282, 3411, 3540, 3669, 3798, 
	3927, 4056, 4185, 4314, 4443, 4471, 4600, 4602, 
	4604, 4733, 4735, 4737, 4739, 4741, 4870, 4999, 
	5128, 5257, 5386, 5515, 5644, 5773, 5902, 6031, 
	6160, 6289, 6418, 6547, 6676, 6805, 6934, 7063, 
	7065, 7067, 7069, 7071, 7081, 7083, 7085, 7087, 
	7089, 7091, 7093, 7095, 7097, 7226, 7228, 7357, 
	7442, 7444, 7529, 7531, 7533, 7535, 7537, 7539, 
	7541, 7665, 7667, 7752, 7837, 7922, 8007, 8092, 
	8094, 8223, 8352, 8419, 8421, 8550, 8679, 8681, 
	8683, 8685, 8687, 8816, 8904, 8906, 8953, 9032, 
	9111, 9205, 9233, 9261, 9308, 9409, 9437, 9471, 
	9473, 9567, 9646, 9750, 9879, 10008, 10137, 10266, 
	10395, 10524, 10526, 10528, 10657, 10673, 10684, 10695, 
	10706, 10717, 10719, 10721, 10723, 10725, 10727, 10729, 
	10731, 10860, 10862, 10947, 11032, 11117, 11202, 11287, 
	11372, 11374, 11376, 11461, 11546, 11548, 11550, 11552, 
	11554, 11556, 11653, 11678, 11679, 11681, 11683, 11685, 
	11710, 11712, 11714, 11808, 11833, 11922, 12051, 12062, 
	12191, 12313, 12314, 12315, 12324, 12333, 12334, 12335, 
	12429, 12430, 12431, 12432, 12526, 12528, 12529, 12530, 
	12531, 12625, 12672, 12766, 12860, 12861, 12862, 12956, 
	13003, 13005, 13099, 13176, 13232, 13288, 13344, 13345, 
	13472, 13599, 13600, 13727, 13728, 13855, 13982, 14109, 
	14236, 14237, 14364, 14491, 14618, 14745, 14872, 14999, 
	15000, 15001, 15057, 15058, 15152, 15241, 15370, 15381, 
	15510, 15632, 15633, 15634, 15643, 15652, 15653, 15654, 
	15748, 15749, 15750, 15751, 15845, 15847, 15848, 15849, 
	15850, 15944, 15991, 16085, 16179, 16180, 16181, 16275, 
	16322, 16324, 16418, 16495, 16551, 16607, 16663, 16664, 
	16791, 16918, 16919, 17046, 17047, 17174, 17301, 17428, 
	17555, 17556, 17683, 17810, 17937, 18064, 18191, 18318, 
	18319, 18320, 18376, 18377, 18471, 18496, 18524, 18618, 
	18646, 18683, 18772, 18901, 18912, 19041, 19069, 19106, 
	19131, 19220, 19349, 19360, 19489, 19523, 19548, 19607, 
	19666, 19696, 19825, 19836, 19965, 20094, 20223, 20352, 
	20377, 20378, 20445, 20447, 20449, 20578, 20707, 20718, 
	20720, 20722, 20724, 20726, 20728, 20731, 20733, 20800, 
	20802, 20805, 20934, 21063, 21192, 21321, 21450, 21579, 
	21708, 21710, 21712, 21841, 21970, 22099, 22228, 22357, 
	22486, 22615, 22744, 22873, 23002, 23131, 23260, 23389, 
	23518, 23647, 23776, 23905, 24034, 24163, 24292, 24421, 
	24550, 24679, 24808, 24937, 25066, 25195, 25324, 25453, 
	25582, 25711, 25840, 25969, 26098, 26227, 26356, 26485, 
	26614, 26743, 26872, 27001, 27130, 27259, 27388, 27517, 
	27646, 27775, 27904, 28033, 28162, 28291, 28420, 28549, 
	28678, 28807, 28936, 29065, 29194, 29323, 29452, 29581, 
	29710, 29839, 29968, 30097, 30226, 30355, 30484, 30613, 
	30742, 30871, 31000, 31129, 31258, 31387, 31516, 31645, 
	31774, 31903, 32032, 32161, 32290, 32419, 32421, 32550, 
	32679, 32704, 32706, 32708, 32710, 32711, 32840, 32969, 
	32971, 32972, 32997, 32998, 33065, 33067, 33069, 33071, 
	33073, 33075, 33078, 33080, 33147, 33149, 33152, 33281, 
	33283, 33285, 33287, 33415, 33544, 33607, 33661, 33715, 
	33716, 33770, 33825, 33827, 33829, 33831, 33856, 33857, 
	33986, 33987, 34104, 34105, 34107, 34109, 34110, 34164, 
	34166, 34168, 34170, 34195, 34197, 34326, 34328, 34330, 
	34332, 34334, 34463, 34592, 34721, 34722, 34851, 34853, 
	34978, 35003, 35005, 35007, 35009, 35010, 35012, 35013, 
	35142, 35271, 35296, 35297, 35299, 35301, 35303, 35304, 
	35433, 35562, 35691, 35820, 35949, 36078, 36207, 36336, 
	36465, 36594, 36723, 36852, 36981, 37110, 37239, 37368, 
	37497, 37626, 37631, 37632, 37699, 37701, 37702, 37703, 
	37704, 37729, 37731, 37756, 37823, 37825, 37827, 37886, 
	38010, 38035, 38036, 38057, 38059, 38144, 38229, 38314, 
	38316, 38318, 38346, 38475, 38604, 38606, 38607, 38674, 
	38677, 38678, 38679, 38680, 38681, 38748, 38877, 38888, 
	38890, 38892, 38894, 38897, 38899, 38901, 38904, 39033, 
	39044, 39173, 39175, 39177, 39180, 39181, 39207, 39238, 
	39240, 39242, 39309, 39312, 39436, 39437, 39566, 39695, 
	39817, 39818, 39819, 39828, 39837, 39838, 39839, 39933, 
	39934, 39935, 39936, 40030, 40032, 40033, 40034, 40035, 
	40129, 40176, 40270, 40364, 40365, 40366, 40460, 40507, 
	40509, 40603, 40680, 40736, 40792, 40848, 40849, 40976, 
	41103, 41104, 41231, 41232, 41359, 41486, 41613, 41740, 
	41741, 41868, 41995, 42122, 42249, 42376, 42503, 42630, 
	42757, 42884, 43011, 43138, 43265, 43392, 43519, 43646, 
	43773, 43900, 44027, 44154, 44155, 44156, 44212, 44213, 
	44342, 44471, 44600, 44601, 44603, 44604, 44733, 44862, 
	44991, 45120, 45249, 45378, 45507, 45636, 45765, 45894, 
	46023, 46152, 46281, 46410, 46539, 46668, 46797, 46926, 
	47055, 47184, 47313, 47442, 47571, 47700, 47829, 47958, 
	48087, 48216, 48345, 48474, 48603, 48732, 48861, 48990, 
	49119, 49248, 49377, 49506, 49635, 49764, 49893, 50022, 
	50151, 50280, 50409, 50538, 50667, 50796, 50925, 51054, 
	51183, 51312, 51441, 51570, 51699, 51828, 51957, 52086, 
	52215, 52344, 52473, 52540, 52669, 52798, 52927, 53056, 
	53185, 53314, 53443, 53572, 53701, 53830, 53959, 54088, 
	54217, 54346, 54475, 54604, 54733, 54862, 54991, 55120, 
	55249, 55378, 55507, 55636, 55765, 55766, 55831, 55925, 
	55950, 55951, 55953, 55955, 55957, 55958, 56087, 56216, 
	56241, 56242, 56244, 56246, 56248, 56249, 56378, 56507, 
	56509, 56510, 56535, 56536, 56603, 56605, 56607, 56736, 
	56865, 56876, 56878, 56903, 56904, 56905, 56926, 56929, 
	56942, 56944, 56946, 57001, 57050, 57126, 57194, 57210, 
	57269, 57271, 57272, 57278, 57279, 57280, 57348, 57416, 
	57484, 57552, 57563, 57565, 57566, 57572, 57574, 57575, 
	57576, 57644, 57712, 57780, 57848, 57916, 57984, 58052, 
	58120, 58190, 58258, 58328, 58396, 58398, 58401, 58403, 
	58470, 58472, 58475, 58604, 58733, 58734, 58863, 58992, 
	59121, 59250, 59379, 59508, 59509, 59511, 59512, 59513, 
	59642, 59771, 59900, 60029, 60158, 60287, 60416, 60545, 
	60674, 60803, 60932, 61061, 61190, 61319, 61448, 61577, 
	61706, 61835, 61964, 62093, 62222, 62351, 62480, 62609, 
	62738, 62867, 62996, 63125, 63254, 63383, 63512, 63641, 
	63770, 63899, 64028, 64157, 64286, 64371, 64500, 64629, 
	64758, 64887, 65016, 65145, 65274, 65403, 65532, 65661, 
	65790, 65919, 66048, 66177, 66306, 66435, 66564, 66693, 
	66822, 66951, 67080, 67209, 67338, 67467, 67596, 67725, 
	67854, 67983, 68112, 68241, 68370, 68499, 68628, 68757, 
	68886, 69015, 69144, 69273, 69402, 69531, 69660, 69789, 
	69918, 70047, 70176, 70305, 70434, 70563, 70692, 70821, 
	70950, 71079, 71208, 71337, 71466, 71595, 71724, 71853, 
	71982, 72111, 72240, 72369, 72498, 72627, 72756, 72757, 
	72822, 72823, 72908, 72993, 73078, 73080, 73082, 73084, 
	73137, 73139, 73232, 73334, 73426
]

class << self
	attr_accessor :_lex_indicies
	private :_lex_indicies, :_lex_indicies=
end
self._lex_indicies = [
	1, 0, 2, 0, 3, 0, 4, 0, 
	5, 0, 6, 0, 7, 0, 8, 0, 
	9, 0, 10, 0, 0, 0, 10, 0, 
	0, 0, 0, 0, 11, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 10, 0, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 14, 
	14, 12, 14, 12, 14, 14, 12, 12, 
	14, 14, 14, 15, 14, 14, 16, 16, 
	16, 16, 16, 16, 16, 16, 16, 16, 
	14, 14, 14, 14, 14, 14, 14, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 12, 14, 12, 12, 13, 14, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 12, 12, 12, 14, 12, 13, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 14, 
	14, 14, 14, 14, 14, 14, 14, 14, 
	14, 12, 12, 12, 12, 12, 12, 12, 
	14, 14, 14, 14, 14, 14, 14, 14, 
	14, 14, 14, 14, 14, 14, 14, 14, 
	14, 14, 14, 14, 14, 14, 14, 14, 
	14, 14, 12, 12, 12, 12, 14, 12, 
	14, 14, 14, 14, 14, 14, 14, 14, 
	14, 14, 14, 14, 14, 14, 14, 14, 
	14, 14, 14, 14, 14, 14, 14, 14, 
	14, 14, 12, 12, 12, 12, 12, 14, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	17, 17, 17, 17, 17, 17, 17, 17, 
	17, 17, 12, 12, 12, 12, 12, 12, 
	18, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 12, 12, 12, 12, 13, 
	12, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 12, 12, 12, 12, 12, 
	13, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 17, 17, 17, 17, 17, 17, 17, 
	17, 17, 17, 12, 12, 12, 12, 12, 
	12, 12, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 12, 12, 12, 12, 
	13, 12, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 12, 12, 12, 12, 
	12, 13, 19, 20, 20, 20, 19, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 19, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 21, 
	20, 19, 22, 22, 22, 19, 22, 22, 
	22, 22, 22, 23, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 19, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 24, 22, 
	19, 22, 22, 22, 19, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 19, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 25, 22, 19, 
	26, 26, 26, 19, 26, 26, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 19, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 26, 26, 27, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 28, 26, 19, 29, 29, 
	29, 19, 29, 29, 29, 29, 29, 30, 
	29, 29, 29, 29, 29, 29, 29, 29, 
	29, 29, 29, 29, 29, 29, 29, 19, 
	29, 19, 29, 29, 29, 19, 29, 29, 
	29, 29, 29, 29, 29, 29, 29, 29, 
	29, 29, 29, 29, 29, 29, 29, 29, 
	29, 29, 29, 19, 29, 19, 20, 20, 
	20, 19, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 19, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 31, 20, 19, 32, 32, 32, 
	19, 32, 32, 32, 32, 32, 33, 32, 
	32, 32, 32, 32, 32, 32, 32, 32, 
	32, 32, 32, 32, 32, 32, 19, 32, 
	32, 32, 32, 32, 32, 32, 32, 32, 
	32, 32, 32, 32, 32, 32, 32, 32, 
	32, 32, 32, 32, 32, 32, 32, 32, 
	32, 32, 32, 32, 32, 32, 32, 32, 
	32, 32, 32, 32, 32, 32, 32, 34, 
	32, 32, 32, 32, 32, 32, 32, 32, 
	32, 32, 32, 32, 32, 32, 32, 32, 
	32, 32, 32, 32, 32, 32, 32, 32, 
	35, 32, 32, 32, 32, 32, 32, 36, 
	32, 19, 32, 32, 32, 19, 32, 32, 
	32, 32, 32, 32, 32, 32, 32, 32, 
	32, 32, 32, 32, 32, 32, 32, 32, 
	32, 32, 32, 19, 32, 37, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 38, 19, 38, 
	19, 19, 39, 39, 39, 19, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 19, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	40, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 41, 39, 19, 
	22, 22, 22, 19, 22, 22, 22, 22, 
	22, 23, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 19, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 25, 22, 19, 42, 
	42, 42, 19, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	19, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	42, 42, 42, 42, 42, 42, 42, 43, 
	43, 43, 43, 43, 43, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 43, 
	43, 43, 43, 43, 43, 42, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 46, 
	46, 44, 46, 44, 46, 46, 44, 44, 
	46, 46, 46, 47, 46, 46, 48, 48, 
	48, 48, 48, 48, 48, 48, 48, 48, 
	46, 46, 46, 46, 46, 46, 46, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 44, 46, 44, 44, 45, 46, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 44, 44, 44, 46, 44, 45, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 44, 44, 44, 44, 44, 44, 44, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 44, 44, 44, 44, 46, 44, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 44, 44, 44, 44, 44, 46, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	49, 49, 49, 49, 49, 49, 49, 49, 
	49, 49, 44, 44, 44, 44, 44, 44, 
	50, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 44, 44, 44, 44, 45, 
	44, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 44, 44, 44, 44, 44, 
	45, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 49, 49, 49, 49, 49, 49, 49, 
	49, 49, 49, 44, 44, 44, 44, 44, 
	44, 44, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 44, 44, 44, 44, 
	45, 44, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 44, 44, 44, 44, 
	44, 45, 51, 52, 52, 52, 51, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 51, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 53, 
	52, 51, 54, 54, 54, 51, 54, 54, 
	54, 54, 54, 55, 54, 54, 54, 54, 
	54, 54, 54, 54, 54, 54, 54, 54, 
	54, 54, 54, 51, 54, 54, 54, 54, 
	54, 54, 54, 54, 54, 54, 54, 54, 
	54, 54, 54, 54, 54, 54, 54, 54, 
	54, 54, 54, 54, 54, 54, 54, 54, 
	54, 54, 54, 54, 54, 54, 54, 54, 
	54, 54, 54, 54, 54, 54, 54, 54, 
	54, 54, 54, 54, 54, 54, 56, 54, 
	51, 54, 54, 54, 51, 54, 54, 54, 
	54, 54, 54, 54, 54, 54, 54, 54, 
	54, 54, 54, 54, 54, 54, 54, 54, 
	54, 54, 51, 54, 54, 54, 54, 54, 
	54, 54, 54, 54, 54, 54, 54, 54, 
	54, 54, 54, 54, 54, 54, 54, 54, 
	54, 54, 54, 54, 54, 54, 54, 54, 
	54, 54, 54, 54, 54, 54, 54, 54, 
	54, 54, 54, 54, 54, 54, 54, 54, 
	54, 54, 54, 54, 54, 57, 54, 51, 
	58, 58, 58, 51, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 51, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 59, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 60, 58, 51, 61, 61, 
	61, 51, 61, 61, 61, 61, 61, 62, 
	61, 61, 61, 61, 61, 61, 61, 61, 
	61, 61, 61, 61, 61, 61, 61, 51, 
	61, 51, 61, 61, 61, 51, 61, 61, 
	61, 61, 61, 61, 61, 61, 61, 61, 
	61, 61, 61, 61, 61, 61, 61, 61, 
	61, 61, 61, 51, 61, 51, 52, 52, 
	52, 51, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 51, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 63, 52, 51, 64, 64, 64, 
	51, 64, 64, 64, 64, 64, 65, 64, 
	64, 64, 64, 64, 64, 64, 64, 64, 
	64, 64, 64, 64, 64, 64, 51, 64, 
	64, 64, 64, 64, 64, 64, 64, 64, 
	64, 64, 64, 64, 64, 64, 64, 64, 
	64, 64, 64, 64, 64, 64, 64, 64, 
	64, 64, 64, 64, 64, 64, 64, 64, 
	64, 64, 64, 64, 64, 64, 64, 66, 
	64, 64, 64, 64, 64, 64, 64, 64, 
	64, 64, 64, 64, 64, 64, 64, 64, 
	64, 64, 64, 64, 64, 64, 64, 64, 
	67, 64, 64, 64, 64, 64, 64, 68, 
	64, 51, 64, 64, 64, 51, 64, 64, 
	64, 64, 64, 64, 64, 64, 64, 64, 
	64, 64, 64, 64, 64, 64, 64, 64, 
	64, 64, 64, 51, 64, 69, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 70, 51, 70, 
	51, 51, 71, 71, 71, 51, 71, 71, 
	71, 71, 71, 71, 71, 71, 71, 71, 
	71, 71, 71, 71, 71, 71, 71, 71, 
	71, 71, 71, 51, 71, 71, 71, 71, 
	71, 71, 71, 71, 71, 71, 71, 71, 
	71, 71, 71, 71, 71, 71, 71, 71, 
	71, 71, 71, 71, 71, 71, 71, 71, 
	71, 71, 71, 71, 71, 71, 71, 71, 
	72, 71, 71, 71, 71, 71, 71, 71, 
	71, 71, 71, 71, 71, 71, 71, 71, 
	71, 71, 71, 71, 71, 71, 71, 71, 
	71, 71, 71, 71, 71, 73, 71, 51, 
	54, 54, 54, 51, 54, 54, 54, 54, 
	54, 55, 54, 54, 54, 54, 54, 54, 
	54, 54, 54, 54, 54, 54, 54, 54, 
	54, 51, 54, 54, 54, 54, 54, 54, 
	54, 54, 54, 54, 54, 54, 54, 54, 
	54, 54, 54, 54, 54, 54, 54, 54, 
	54, 54, 54, 54, 54, 54, 54, 54, 
	54, 54, 54, 54, 54, 54, 54, 54, 
	54, 54, 54, 54, 54, 54, 54, 54, 
	54, 54, 54, 54, 57, 54, 51, 74, 
	74, 74, 51, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	51, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	74, 74, 74, 74, 74, 74, 74, 75, 
	75, 75, 75, 75, 75, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 75, 
	75, 75, 75, 75, 75, 74, 76, 76, 
	76, 76, 76, 76, 76, 76, 76, 76, 
	76, 76, 76, 76, 76, 76, 76, 76, 
	76, 76, 76, 76, 76, 76, 76, 76, 
	76, 76, 76, 76, 76, 76, 76, 78, 
	78, 76, 78, 76, 78, 78, 76, 76, 
	78, 78, 78, 79, 78, 78, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	78, 78, 78, 78, 78, 78, 78, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 76, 78, 76, 76, 77, 78, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 76, 76, 76, 78, 76, 77, 76, 
	76, 76, 76, 76, 76, 76, 76, 76, 
	76, 76, 76, 76, 76, 76, 76, 76, 
	76, 76, 76, 76, 76, 76, 76, 76, 
	76, 76, 76, 76, 76, 76, 76, 76, 
	76, 76, 76, 76, 76, 76, 76, 76, 
	76, 76, 76, 76, 76, 76, 76, 78, 
	78, 78, 78, 78, 78, 78, 78, 78, 
	78, 76, 76, 76, 76, 76, 76, 76, 
	78, 78, 78, 78, 78, 78, 78, 78, 
	78, 78, 78, 78, 78, 78, 78, 78, 
	78, 78, 78, 78, 78, 78, 78, 78, 
	78, 78, 76, 76, 76, 76, 78, 76, 
	78, 78, 78, 78, 78, 78, 78, 78, 
	78, 78, 78, 78, 78, 78, 78, 78, 
	78, 78, 78, 78, 78, 78, 78, 78, 
	78, 78, 76, 76, 76, 76, 76, 78, 
	76, 76, 76, 76, 76, 76, 76, 76, 
	76, 76, 76, 76, 76, 76, 76, 76, 
	76, 76, 76, 76, 76, 76, 76, 76, 
	76, 76, 76, 76, 76, 76, 76, 76, 
	76, 76, 76, 76, 76, 76, 76, 76, 
	76, 76, 76, 76, 76, 76, 76, 76, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 76, 76, 76, 76, 76, 76, 
	82, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 76, 76, 76, 76, 77, 
	76, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 76, 76, 76, 76, 76, 
	77, 76, 76, 76, 76, 76, 76, 76, 
	76, 76, 76, 76, 76, 76, 76, 76, 
	76, 76, 76, 76, 76, 76, 76, 76, 
	76, 76, 76, 76, 76, 76, 76, 76, 
	76, 76, 76, 76, 76, 76, 76, 76, 
	76, 76, 76, 76, 76, 76, 76, 76, 
	76, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 76, 76, 76, 76, 76, 
	76, 76, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 76, 76, 76, 76, 
	77, 76, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 76, 76, 76, 76, 
	76, 77, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 85, 85, 83, 85, 83, 
	85, 85, 83, 83, 85, 85, 85, 86, 
	85, 85, 87, 87, 87, 87, 87, 87, 
	87, 87, 87, 87, 85, 85, 85, 85, 
	85, 85, 85, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 83, 85, 83, 
	83, 84, 85, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 83, 83, 83, 
	85, 83, 84, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 85, 85, 85, 85, 85, 
	85, 85, 85, 85, 85, 83, 83, 83, 
	83, 83, 83, 83, 85, 85, 85, 85, 
	85, 85, 85, 85, 85, 85, 85, 85, 
	85, 85, 85, 85, 85, 85, 85, 85, 
	85, 85, 85, 85, 85, 85, 83, 83, 
	83, 83, 85, 83, 85, 85, 85, 85, 
	85, 85, 85, 85, 85, 85, 85, 85, 
	85, 85, 85, 85, 85, 85, 85, 85, 
	85, 85, 85, 85, 85, 85, 83, 83, 
	83, 83, 83, 85, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 83, 83, 
	83, 83, 83, 83, 89, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 83, 
	83, 83, 83, 84, 83, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 83, 
	83, 83, 83, 83, 84, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 83, 
	83, 83, 83, 83, 83, 83, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	83, 83, 83, 83, 84, 83, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	83, 83, 83, 83, 83, 84, 92, 92, 
	92, 92, 92, 92, 92, 92, 92, 92, 
	92, 92, 92, 92, 92, 92, 92, 92, 
	92, 92, 92, 92, 92, 92, 92, 92, 
	92, 92, 92, 92, 92, 92, 92, 91, 
	91, 92, 91, 92, 91, 91, 92, 92, 
	91, 91, 91, 93, 91, 91, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 94, 
	91, 91, 91, 91, 91, 91, 91, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 92, 91, 92, 92, 90, 91, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 92, 92, 92, 91, 92, 90, 92, 
	92, 92, 92, 92, 92, 92, 92, 92, 
	92, 92, 92, 92, 92, 92, 92, 92, 
	92, 92, 92, 92, 92, 92, 92, 92, 
	92, 92, 92, 92, 92, 92, 92, 92, 
	92, 92, 92, 92, 92, 92, 92, 92, 
	92, 92, 92, 92, 92, 92, 92, 91, 
	91, 91, 91, 91, 91, 91, 91, 91, 
	91, 92, 92, 92, 92, 92, 92, 92, 
	91, 91, 91, 91, 91, 91, 91, 91, 
	91, 91, 91, 91, 91, 91, 91, 91, 
	91, 91, 91, 91, 91, 91, 91, 91, 
	91, 91, 92, 92, 92, 92, 91, 92, 
	91, 91, 91, 91, 91, 91, 91, 91, 
	91, 91, 91, 91, 91, 91, 91, 91, 
	91, 91, 91, 91, 91, 91, 91, 91, 
	91, 91, 92, 92, 92, 92, 92, 91, 
	92, 92, 92, 92, 92, 92, 92, 92, 
	92, 92, 92, 92, 92, 92, 92, 92, 
	92, 92, 92, 92, 92, 92, 92, 92, 
	92, 92, 92, 92, 92, 92, 92, 92, 
	92, 92, 92, 92, 92, 92, 92, 92, 
	92, 92, 92, 92, 92, 92, 92, 92, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 92, 92, 92, 92, 92, 92, 
	96, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 92, 92, 92, 92, 95, 
	92, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 92, 92, 92, 92, 92, 
	95, 92, 92, 92, 92, 92, 92, 92, 
	92, 92, 92, 92, 92, 92, 92, 92, 
	92, 92, 92, 92, 92, 92, 92, 92, 
	92, 92, 92, 92, 92, 92, 92, 92, 
	92, 92, 92, 92, 92, 92, 92, 92, 
	92, 92, 92, 92, 92, 92, 92, 92, 
	92, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 92, 92, 92, 92, 92, 
	92, 92, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 92, 92, 92, 92, 
	97, 92, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 92, 92, 92, 92, 
	92, 97, 98, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 98, 98, 98, 98, 
	98, 98, 98, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 98, 98, 98, 
	98, 99, 98, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 98, 98, 98, 
	98, 98, 99, 100, 101, 101, 101, 100, 
	101, 101, 101, 101, 101, 101, 101, 101, 
	101, 101, 101, 101, 101, 101, 101, 101, 
	101, 101, 101, 101, 101, 100, 101, 102, 
	102, 102, 102, 102, 102, 102, 102, 102, 
	102, 102, 102, 102, 102, 102, 102, 102, 
	102, 102, 102, 102, 102, 102, 102, 102, 
	102, 102, 102, 102, 102, 102, 102, 102, 
	104, 102, 102, 102, 102, 102, 102, 102, 
	102, 102, 102, 102, 102, 102, 102, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 105, 102, 102, 102, 102, 104, 102, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 102, 102, 102, 102, 103, 102, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 102, 102, 102, 102, 102, 103, 
	105, 102, 102, 106, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 109, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 110, 107, 
	107, 107, 107, 109, 107, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 107, 
	107, 107, 107, 108, 107, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 107, 
	107, 107, 107, 107, 108, 110, 107, 112, 
	111, 113, 111, 114, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 116, 111, 
	116, 116, 116, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 116, 111, 111, 
	111, 111, 117, 118, 111, 119, 111, 120, 
	121, 122, 123, 124, 117, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 125, 
	111, 126, 122, 127, 128, 111, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	129, 130, 122, 131, 115, 111, 115, 115, 
	115, 115, 115, 115, 115, 115, 132, 115, 
	115, 115, 115, 115, 115, 115, 115, 133, 
	115, 115, 134, 115, 135, 115, 115, 115, 
	136, 137, 111, 131, 111, 115, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 138, 
	111, 138, 138, 138, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 138, 111, 
	111, 111, 111, 139, 140, 111, 141, 111, 
	142, 143, 144, 145, 146, 139, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	147, 111, 148, 144, 149, 150, 111, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 151, 152, 144, 113, 108, 111, 108, 
	108, 108, 108, 108, 108, 108, 108, 153, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	154, 108, 108, 155, 108, 156, 108, 108, 
	108, 157, 158, 111, 113, 111, 108, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	109, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 110, 111, 111, 111, 111, 109, 111, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 111, 111, 111, 111, 108, 111, 
	108, 108, 108, 108, 108, 159, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 111, 111, 111, 111, 111, 108, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 109, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 110, 111, 111, 111, 111, 109, 
	111, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 111, 111, 111, 111, 108, 
	111, 108, 108, 108, 108, 160, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 111, 111, 111, 111, 111, 
	108, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 109, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 110, 111, 111, 111, 111, 
	109, 111, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 111, 111, 111, 111, 
	108, 111, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 161, 108, 108, 108, 
	108, 108, 108, 108, 111, 111, 111, 111, 
	111, 108, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 109, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 110, 111, 111, 111, 
	111, 109, 111, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 111, 111, 111, 
	111, 108, 111, 108, 108, 162, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 111, 111, 111, 
	111, 111, 108, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 109, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 110, 111, 111, 
	111, 111, 109, 111, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 111, 111, 
	111, 111, 108, 111, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	163, 108, 108, 108, 108, 108, 111, 111, 
	111, 111, 111, 108, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 109, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 110, 111, 
	111, 111, 111, 109, 111, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 111, 
	111, 111, 111, 108, 111, 108, 108, 108, 
	108, 159, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 111, 
	111, 111, 111, 111, 108, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 109, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 110, 
	111, 111, 111, 111, 109, 111, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	111, 111, 111, 111, 108, 111, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 164, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	111, 111, 111, 111, 111, 108, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 109, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	110, 111, 111, 111, 111, 109, 111, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 111, 111, 111, 111, 108, 111, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 165, 108, 108, 108, 108, 108, 
	108, 108, 166, 108, 108, 108, 108, 108, 
	108, 111, 111, 111, 111, 111, 108, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	109, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 110, 111, 111, 111, 111, 109, 111, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 111, 111, 111, 111, 108, 111, 
	108, 108, 108, 108, 167, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 111, 111, 111, 111, 111, 108, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 109, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 110, 111, 111, 111, 111, 109, 
	111, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 111, 111, 111, 111, 108, 
	111, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 168, 108, 108, 108, 108, 
	108, 108, 108, 111, 111, 111, 111, 111, 
	108, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 109, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 110, 111, 111, 111, 111, 
	109, 111, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 111, 111, 111, 111, 
	108, 111, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 159, 108, 108, 108, 
	108, 108, 108, 108, 111, 111, 111, 111, 
	111, 108, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 109, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 110, 111, 111, 111, 
	111, 109, 111, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 111, 111, 111, 
	111, 108, 111, 108, 108, 108, 108, 108, 
	108, 108, 108, 169, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 111, 111, 111, 
	111, 111, 108, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 109, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 110, 111, 111, 
	111, 111, 109, 111, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 111, 111, 
	111, 111, 108, 111, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 159, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 111, 111, 
	111, 111, 111, 108, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 109, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 110, 111, 
	111, 111, 111, 109, 111, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 111, 
	111, 111, 111, 108, 111, 108, 108, 108, 
	108, 108, 108, 108, 170, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 111, 
	111, 111, 111, 111, 108, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 109, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 110, 
	111, 111, 111, 111, 109, 111, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	111, 111, 111, 111, 108, 111, 108, 108, 
	108, 108, 108, 108, 108, 108, 171, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	111, 111, 111, 111, 111, 108, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 109, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	110, 111, 111, 111, 111, 109, 111, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 111, 111, 111, 111, 108, 111, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 163, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 111, 111, 111, 111, 111, 108, 173, 
	172, 174, 172, 175, 172, 144, 172, 176, 
	172, 172, 172, 172, 172, 172, 172, 177, 
	172, 178, 172, 179, 172, 144, 172, 180, 
	172, 144, 172, 181, 172, 175, 172, 183, 
	182, 184, 184, 184, 184, 184, 184, 184, 
	184, 184, 186, 184, 186, 186, 186, 184, 
	184, 184, 184, 184, 184, 184, 184, 184, 
	184, 184, 184, 184, 184, 184, 184, 184, 
	184, 186, 184, 184, 184, 184, 184, 184, 
	184, 187, 184, 184, 184, 184, 184, 184, 
	184, 184, 184, 184, 184, 184, 184, 184, 
	184, 184, 184, 184, 184, 184, 184, 184, 
	184, 184, 185, 185, 185, 185, 185, 185, 
	185, 185, 185, 185, 185, 185, 185, 185, 
	185, 185, 185, 185, 185, 185, 185, 185, 
	185, 185, 185, 185, 184, 188, 184, 184, 
	185, 184, 185, 185, 185, 189, 185, 185, 
	185, 185, 185, 185, 185, 185, 185, 185, 
	185, 185, 185, 185, 185, 185, 185, 185, 
	185, 185, 185, 185, 184, 184, 184, 184, 
	184, 185, 190, 184, 184, 184, 184, 184, 
	184, 184, 184, 184, 184, 192, 184, 192, 
	192, 192, 184, 184, 184, 184, 184, 184, 
	184, 184, 184, 184, 184, 184, 184, 184, 
	184, 184, 184, 184, 192, 184, 184, 184, 
	184, 184, 184, 184, 193, 184, 184, 184, 
	184, 184, 184, 184, 184, 184, 184, 184, 
	184, 184, 184, 184, 184, 184, 184, 184, 
	184, 184, 184, 184, 184, 191, 191, 191, 
	191, 191, 191, 191, 191, 191, 191, 191, 
	191, 191, 191, 191, 191, 191, 191, 191, 
	191, 191, 191, 191, 191, 191, 191, 184, 
	194, 184, 184, 191, 184, 191, 191, 191, 
	195, 191, 191, 191, 191, 191, 191, 191, 
	191, 191, 191, 191, 191, 191, 191, 191, 
	191, 191, 191, 191, 191, 191, 191, 184, 
	184, 184, 184, 184, 191, 197, 196, 197, 
	197, 197, 196, 196, 196, 196, 196, 196, 
	196, 196, 196, 196, 196, 196, 196, 196, 
	196, 196, 196, 196, 197, 196, 196, 196, 
	196, 196, 196, 196, 198, 196, 196, 196, 
	196, 196, 196, 196, 196, 196, 196, 196, 
	196, 196, 196, 196, 196, 196, 196, 196, 
	196, 196, 196, 196, 196, 196, 196, 196, 
	196, 196, 196, 196, 196, 196, 196, 196, 
	196, 196, 196, 196, 196, 196, 196, 196, 
	196, 196, 196, 196, 196, 196, 196, 196, 
	199, 196, 200, 196, 201, 196, 201, 201, 
	201, 196, 196, 196, 196, 196, 196, 196, 
	196, 196, 196, 196, 196, 196, 196, 196, 
	196, 196, 196, 201, 196, 196, 196, 196, 
	196, 196, 196, 202, 196, 196, 196, 196, 
	196, 196, 196, 196, 196, 196, 196, 196, 
	196, 196, 196, 196, 196, 196, 196, 196, 
	196, 196, 196, 196, 196, 196, 196, 196, 
	196, 196, 196, 196, 196, 196, 196, 196, 
	196, 196, 196, 196, 196, 196, 196, 196, 
	196, 196, 196, 196, 196, 196, 196, 203, 
	196, 204, 205, 207, 206, 208, 206, 209, 
	206, 210, 206, 211, 206, 212, 213, 213, 
	213, 212, 213, 213, 213, 213, 213, 213, 
	213, 213, 213, 213, 213, 213, 213, 213, 
	213, 213, 213, 213, 213, 213, 213, 212, 
	213, 213, 213, 213, 213, 213, 213, 213, 
	213, 213, 213, 213, 213, 213, 213, 213, 
	213, 213, 213, 213, 213, 213, 213, 213, 
	213, 213, 213, 213, 213, 213, 213, 213, 
	213, 213, 213, 213, 213, 213, 214, 214, 
	214, 214, 214, 214, 214, 214, 214, 214, 
	214, 214, 214, 214, 214, 214, 214, 214, 
	214, 214, 214, 214, 214, 214, 214, 214, 
	213, 213, 213, 213, 213, 213, 214, 214, 
	214, 214, 214, 214, 214, 214, 214, 214, 
	214, 214, 214, 214, 214, 214, 214, 214, 
	214, 214, 214, 214, 214, 214, 214, 214, 
	213, 215, 204, 216, 217, 216, 216, 216, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 216, 204, 204, 218, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 219, 219, 219, 219, 219, 219, 
	219, 219, 219, 219, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 220, 204, 
	221, 222, 221, 221, 221, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 221, 
	204, 204, 223, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 224, 
	224, 224, 224, 224, 224, 224, 224, 224, 
	224, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 225, 204, 227, 228, 227, 
	227, 227, 226, 226, 226, 226, 226, 226, 
	226, 226, 226, 226, 226, 226, 226, 226, 
	226, 226, 226, 226, 227, 226, 226, 229, 
	226, 226, 226, 226, 226, 226, 226, 226, 
	226, 226, 226, 226, 230, 230, 230, 230, 
	230, 230, 230, 230, 230, 230, 226, 226, 
	226, 226, 226, 226, 226, 226, 226, 226, 
	226, 226, 226, 226, 226, 226, 226, 226, 
	226, 226, 226, 226, 226, 226, 226, 226, 
	226, 226, 226, 226, 226, 226, 226, 226, 
	231, 226, 233, 234, 233, 233, 233, 232, 
	232, 232, 232, 232, 232, 232, 232, 232, 
	232, 232, 232, 232, 232, 232, 232, 232, 
	232, 233, 232, 232, 235, 232, 232, 232, 
	232, 232, 232, 232, 232, 232, 232, 232, 
	232, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 232, 232, 232, 232, 232, 
	232, 232, 232, 232, 232, 232, 232, 232, 
	232, 232, 232, 232, 232, 232, 232, 232, 
	232, 232, 232, 232, 232, 232, 232, 232, 
	232, 232, 232, 232, 232, 237, 232, 233, 
	238, 233, 233, 233, 232, 232, 232, 232, 
	232, 232, 232, 232, 232, 232, 232, 232, 
	232, 232, 232, 232, 232, 232, 233, 232, 
	232, 235, 232, 232, 232, 232, 232, 232, 
	232, 232, 232, 232, 232, 232, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	232, 232, 232, 232, 232, 232, 232, 232, 
	232, 232, 232, 232, 232, 232, 232, 232, 
	232, 232, 232, 232, 232, 232, 232, 232, 
	232, 232, 232, 232, 232, 232, 232, 232, 
	232, 232, 237, 232, 217, 204, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 241, 
	241, 239, 241, 239, 241, 241, 239, 239, 
	241, 241, 241, 242, 241, 241, 243, 243, 
	243, 243, 243, 243, 243, 243, 243, 243, 
	241, 241, 241, 241, 241, 241, 241, 240, 
	240, 240, 240, 240, 240, 240, 240, 240, 
	240, 240, 240, 240, 240, 240, 240, 240, 
	240, 240, 240, 240, 240, 240, 240, 240, 
	240, 239, 241, 239, 239, 240, 241, 240, 
	240, 240, 240, 240, 240, 240, 240, 240, 
	240, 240, 240, 240, 240, 240, 240, 240, 
	240, 240, 240, 240, 240, 240, 240, 240, 
	240, 239, 239, 239, 241, 239, 240, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 241, 
	241, 241, 241, 241, 241, 241, 241, 241, 
	241, 239, 239, 239, 239, 239, 239, 239, 
	241, 241, 241, 241, 241, 241, 241, 241, 
	241, 241, 241, 241, 241, 241, 241, 241, 
	241, 241, 241, 241, 241, 241, 241, 241, 
	241, 241, 239, 239, 239, 239, 241, 239, 
	241, 241, 241, 241, 241, 241, 241, 241, 
	241, 241, 241, 241, 241, 241, 241, 241, 
	241, 241, 241, 241, 241, 241, 241, 241, 
	241, 241, 239, 239, 239, 239, 239, 241, 
	244, 241, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 241, 239, 244, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 246, 
	239, 239, 239, 239, 247, 239, 239, 239, 
	239, 239, 248, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 215, 239, 239, 239, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	239, 239, 239, 239, 245, 249, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	239, 239, 239, 248, 239, 245, 251, 251, 
	251, 251, 251, 251, 251, 251, 251, 251, 
	252, 251, 251, 251, 251, 251, 251, 251, 
	251, 251, 251, 251, 251, 251, 251, 251, 
	251, 251, 251, 251, 251, 251, 251, 251, 
	251, 251, 251, 251, 251, 251, 251, 251, 
	251, 251, 251, 251, 251, 251, 250, 250, 
	250, 250, 250, 250, 250, 250, 250, 250, 
	251, 251, 251, 251, 251, 251, 251, 250, 
	250, 250, 250, 250, 250, 250, 250, 250, 
	250, 250, 250, 250, 250, 250, 250, 250, 
	250, 250, 250, 250, 250, 250, 250, 250, 
	250, 251, 251, 251, 251, 250, 251, 250, 
	250, 250, 250, 250, 250, 250, 250, 250, 
	250, 250, 250, 250, 250, 250, 250, 250, 
	250, 250, 250, 250, 250, 250, 250, 250, 
	250, 251, 251, 251, 251, 251, 250, 254, 
	253, 257, 256, 252, 251, 257, 258, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 246, 239, 239, 239, 239, 247, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 239, 239, 239, 239, 245, 249, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 239, 239, 239, 239, 239, 245, 
	260, 259, 259, 259, 259, 259, 259, 259, 
	259, 259, 259, 259, 259, 259, 259, 259, 
	259, 259, 259, 259, 259, 259, 259, 259, 
	259, 259, 259, 259, 259, 259, 259, 259, 
	259, 259, 259, 259, 259, 259, 259, 259, 
	259, 259, 259, 259, 259, 259, 259, 259, 
	259, 259, 259, 259, 259, 259, 259, 259, 
	259, 259, 259, 259, 259, 259, 259, 259, 
	259, 259, 259, 259, 259, 259, 259, 259, 
	259, 259, 259, 259, 259, 259, 259, 259, 
	259, 259, 259, 259, 259, 259, 257, 259, 
	257, 260, 261, 262, 262, 262, 261, 262, 
	262, 262, 262, 262, 262, 262, 262, 262, 
	262, 262, 262, 262, 262, 262, 262, 262, 
	262, 262, 262, 262, 261, 262, 262, 262, 
	262, 262, 262, 262, 262, 262, 262, 262, 
	262, 262, 262, 262, 262, 262, 262, 263, 
	262, 261, 264, 264, 264, 261, 264, 264, 
	264, 264, 264, 265, 264, 264, 264, 264, 
	264, 264, 264, 264, 264, 264, 264, 264, 
	264, 264, 264, 261, 264, 264, 264, 264, 
	264, 264, 264, 264, 264, 264, 264, 264, 
	264, 264, 264, 264, 264, 264, 264, 264, 
	264, 264, 264, 264, 264, 264, 264, 264, 
	264, 264, 264, 264, 264, 264, 264, 264, 
	264, 264, 264, 264, 264, 264, 264, 264, 
	264, 264, 264, 264, 264, 264, 266, 264, 
	261, 264, 264, 264, 261, 264, 264, 264, 
	264, 264, 264, 264, 264, 264, 264, 264, 
	264, 264, 264, 264, 264, 264, 264, 264, 
	264, 264, 261, 264, 264, 264, 264, 264, 
	264, 264, 264, 264, 264, 264, 264, 264, 
	264, 264, 264, 264, 264, 264, 264, 264, 
	264, 264, 264, 264, 264, 264, 264, 264, 
	264, 264, 264, 264, 264, 264, 264, 264, 
	264, 264, 264, 264, 264, 264, 264, 264, 
	264, 264, 264, 264, 264, 267, 264, 261, 
	268, 268, 268, 261, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 261, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 269, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 270, 268, 261, 271, 271, 
	271, 261, 271, 271, 271, 271, 271, 272, 
	271, 271, 271, 271, 271, 271, 271, 271, 
	271, 271, 271, 271, 271, 271, 271, 261, 
	271, 261, 271, 271, 271, 261, 271, 271, 
	271, 271, 271, 271, 271, 271, 271, 271, 
	271, 271, 271, 271, 271, 271, 271, 271, 
	271, 271, 271, 261, 271, 261, 262, 262, 
	262, 261, 262, 262, 262, 262, 262, 262, 
	262, 262, 262, 262, 262, 262, 262, 262, 
	262, 262, 262, 262, 262, 262, 262, 261, 
	262, 262, 262, 262, 262, 262, 262, 262, 
	262, 262, 262, 262, 262, 262, 262, 262, 
	262, 262, 273, 262, 261, 274, 274, 274, 
	261, 274, 274, 274, 274, 274, 275, 274, 
	274, 274, 274, 274, 274, 274, 274, 274, 
	274, 274, 274, 274, 274, 274, 261, 274, 
	274, 274, 274, 274, 274, 274, 274, 274, 
	274, 274, 274, 274, 274, 274, 274, 274, 
	274, 274, 274, 274, 274, 274, 274, 274, 
	274, 274, 274, 274, 274, 274, 274, 274, 
	274, 274, 274, 274, 274, 274, 274, 276, 
	274, 274, 274, 274, 274, 274, 274, 274, 
	274, 274, 274, 274, 274, 274, 274, 274, 
	274, 274, 274, 274, 274, 274, 274, 274, 
	277, 274, 274, 274, 274, 274, 274, 278, 
	274, 261, 274, 274, 274, 261, 274, 274, 
	274, 274, 274, 274, 274, 274, 274, 274, 
	274, 274, 274, 274, 274, 274, 274, 274, 
	274, 274, 274, 261, 274, 279, 261, 261, 
	261, 261, 261, 261, 261, 261, 261, 261, 
	261, 261, 261, 261, 261, 261, 261, 261, 
	261, 261, 261, 261, 261, 261, 261, 261, 
	261, 261, 261, 261, 261, 280, 261, 280, 
	261, 261, 281, 281, 281, 261, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 261, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	282, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 283, 281, 261, 
	264, 264, 264, 261, 264, 264, 264, 264, 
	264, 265, 264, 264, 264, 264, 264, 264, 
	264, 264, 264, 264, 264, 264, 264, 264, 
	264, 261, 264, 264, 264, 264, 264, 264, 
	264, 264, 264, 264, 264, 264, 264, 264, 
	264, 264, 264, 264, 264, 264, 264, 264, 
	264, 264, 264, 264, 264, 264, 264, 264, 
	264, 264, 264, 264, 264, 264, 264, 264, 
	264, 264, 264, 264, 264, 264, 264, 264, 
	264, 264, 264, 264, 267, 264, 261, 284, 
	284, 284, 261, 284, 284, 284, 284, 284, 
	284, 284, 284, 284, 284, 284, 284, 284, 
	284, 284, 284, 284, 284, 284, 284, 284, 
	261, 284, 284, 284, 284, 284, 284, 284, 
	284, 284, 284, 284, 284, 284, 284, 284, 
	284, 284, 284, 284, 284, 284, 285, 285, 
	285, 285, 285, 285, 285, 285, 285, 285, 
	284, 284, 284, 284, 284, 284, 284, 285, 
	285, 285, 285, 285, 285, 284, 284, 284, 
	284, 284, 284, 284, 284, 284, 284, 284, 
	284, 284, 284, 284, 284, 284, 284, 284, 
	284, 284, 284, 284, 284, 284, 284, 285, 
	285, 285, 285, 285, 285, 284, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 287, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	288, 204, 204, 289, 204, 287, 204, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 204, 204, 204, 204, 286, 204, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 204, 204, 204, 204, 204, 286, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	287, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 288, 239, 239, 289, 239, 287, 239, 
	286, 286, 286, 286, 286, 286, 290, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 239, 239, 239, 239, 286, 239, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 239, 239, 239, 239, 239, 286, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 287, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 288, 239, 239, 289, 239, 287, 
	239, 286, 286, 286, 286, 286, 286, 286, 
	286, 291, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 239, 239, 239, 239, 286, 
	239, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 239, 239, 239, 239, 239, 
	286, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 287, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 288, 239, 239, 289, 239, 
	287, 239, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 292, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 239, 239, 239, 239, 
	286, 239, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 239, 239, 239, 239, 
	239, 286, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 287, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 288, 239, 239, 289, 
	239, 287, 239, 286, 286, 286, 292, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 239, 239, 239, 
	239, 286, 239, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 239, 239, 239, 
	239, 239, 286, 293, 293, 293, 293, 293, 
	293, 293, 293, 293, 293, 293, 293, 293, 
	293, 293, 293, 293, 293, 293, 293, 293, 
	293, 293, 293, 293, 293, 293, 293, 293, 
	293, 293, 293, 293, 295, 293, 293, 293, 
	293, 293, 293, 293, 293, 293, 293, 293, 
	293, 293, 293, 294, 294, 294, 294, 294, 
	294, 294, 294, 294, 294, 296, 293, 293, 
	293, 293, 295, 293, 294, 294, 294, 294, 
	294, 294, 294, 294, 294, 294, 294, 294, 
	294, 294, 294, 294, 294, 294, 294, 294, 
	294, 294, 294, 294, 294, 294, 293, 293, 
	293, 293, 294, 293, 294, 294, 294, 294, 
	294, 294, 294, 294, 294, 294, 294, 294, 
	294, 294, 294, 294, 294, 294, 294, 294, 
	294, 294, 294, 294, 294, 294, 293, 293, 
	293, 293, 293, 294, 296, 293, 293, 297, 
	298, 298, 298, 298, 298, 298, 298, 298, 
	298, 298, 298, 298, 298, 298, 298, 298, 
	298, 298, 298, 298, 298, 298, 298, 298, 
	298, 298, 298, 298, 298, 298, 298, 298, 
	298, 298, 298, 298, 298, 298, 298, 298, 
	298, 298, 298, 298, 298, 298, 298, 298, 
	299, 299, 299, 299, 299, 299, 299, 299, 
	299, 299, 298, 298, 298, 298, 298, 298, 
	298, 299, 299, 299, 299, 299, 299, 299, 
	299, 299, 299, 299, 299, 299, 299, 299, 
	299, 299, 299, 299, 299, 299, 299, 299, 
	299, 299, 299, 298, 298, 298, 298, 299, 
	298, 299, 299, 299, 299, 299, 299, 299, 
	299, 299, 299, 299, 299, 299, 299, 299, 
	299, 299, 299, 299, 299, 299, 299, 299, 
	299, 299, 299, 298, 298, 298, 298, 298, 
	299, 301, 300, 301, 300, 300, 302, 302, 
	302, 302, 302, 302, 302, 302, 302, 302, 
	300, 302, 302, 302, 302, 302, 302, 302, 
	302, 302, 302, 300, 303, 303, 303, 303, 
	303, 303, 303, 303, 303, 303, 300, 305, 
	305, 305, 305, 305, 305, 305, 305, 305, 
	305, 304, 306, 306, 306, 306, 306, 306, 
	306, 306, 306, 306, 304, 308, 307, 309, 
	307, 310, 307, 311, 307, 313, 312, 314, 
	312, 315, 312, 298, 298, 298, 298, 298, 
	298, 298, 298, 298, 298, 298, 298, 298, 
	298, 298, 298, 298, 298, 298, 298, 298, 
	298, 298, 298, 298, 298, 298, 298, 298, 
	298, 298, 298, 298, 298, 298, 298, 298, 
	298, 298, 298, 298, 298, 298, 298, 298, 
	298, 298, 298, 316, 316, 316, 316, 316, 
	316, 316, 316, 316, 316, 298, 298, 298, 
	298, 298, 298, 298, 316, 316, 316, 316, 
	316, 316, 316, 316, 316, 316, 316, 316, 
	316, 316, 316, 316, 316, 316, 316, 316, 
	316, 316, 316, 316, 316, 316, 298, 298, 
	298, 298, 316, 298, 316, 316, 316, 316, 
	316, 316, 316, 316, 316, 316, 316, 316, 
	316, 316, 316, 316, 316, 316, 316, 316, 
	316, 316, 316, 316, 316, 316, 298, 298, 
	298, 298, 298, 316, 317, 304, 318, 319, 
	318, 318, 318, 304, 304, 304, 304, 304, 
	304, 304, 304, 304, 304, 304, 304, 304, 
	304, 304, 304, 304, 304, 318, 304, 304, 
	320, 304, 304, 304, 304, 304, 304, 304, 
	304, 304, 304, 304, 304, 304, 304, 304, 
	304, 304, 304, 304, 304, 304, 304, 304, 
	304, 321, 304, 304, 304, 304, 304, 304, 
	304, 304, 304, 304, 304, 304, 304, 304, 
	304, 304, 304, 304, 304, 304, 304, 304, 
	304, 304, 304, 304, 304, 304, 304, 304, 
	304, 322, 304, 323, 324, 323, 323, 323, 
	304, 304, 304, 304, 304, 304, 304, 304, 
	304, 304, 304, 304, 304, 304, 304, 304, 
	304, 304, 323, 304, 304, 325, 304, 304, 
	304, 304, 304, 304, 304, 304, 304, 304, 
	304, 304, 304, 304, 304, 304, 304, 304, 
	304, 304, 304, 304, 304, 304, 326, 304, 
	304, 304, 304, 304, 304, 304, 304, 304, 
	304, 304, 304, 304, 304, 304, 304, 304, 
	304, 304, 304, 304, 304, 304, 304, 304, 
	304, 304, 304, 304, 304, 304, 327, 304, 
	329, 330, 329, 329, 329, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 329, 
	328, 328, 331, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 332, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 328, 328, 328, 328, 328, 
	328, 328, 328, 333, 328, 335, 336, 335, 
	335, 335, 334, 334, 334, 334, 334, 334, 
	334, 334, 334, 334, 334, 334, 334, 334, 
	334, 334, 334, 334, 335, 334, 334, 337, 
	334, 334, 334, 334, 334, 334, 334, 334, 
	334, 334, 334, 334, 334, 334, 334, 334, 
	334, 334, 334, 334, 334, 334, 334, 334, 
	338, 334, 334, 334, 334, 334, 334, 334, 
	334, 334, 334, 334, 334, 334, 334, 334, 
	334, 334, 334, 334, 334, 334, 334, 334, 
	334, 334, 334, 334, 334, 334, 334, 334, 
	339, 334, 335, 336, 335, 335, 335, 334, 
	334, 334, 334, 334, 334, 334, 334, 334, 
	334, 334, 334, 334, 334, 334, 334, 334, 
	334, 335, 334, 334, 337, 334, 334, 334, 
	334, 334, 334, 334, 334, 334, 334, 334, 
	334, 334, 334, 334, 334, 334, 334, 334, 
	334, 334, 334, 334, 334, 340, 334, 334, 
	334, 334, 334, 334, 334, 334, 334, 334, 
	334, 334, 334, 334, 334, 334, 334, 334, 
	334, 334, 334, 334, 334, 334, 334, 334, 
	334, 334, 334, 334, 334, 339, 334, 335, 
	341, 335, 335, 335, 334, 334, 334, 334, 
	334, 334, 334, 334, 334, 334, 334, 334, 
	334, 334, 334, 334, 334, 334, 335, 334, 
	334, 337, 334, 334, 334, 334, 334, 334, 
	334, 334, 334, 334, 334, 334, 334, 334, 
	334, 334, 334, 334, 334, 334, 334, 334, 
	334, 334, 338, 334, 334, 334, 334, 334, 
	334, 334, 334, 334, 334, 334, 334, 334, 
	334, 334, 334, 334, 334, 334, 334, 334, 
	334, 334, 334, 334, 334, 334, 334, 334, 
	334, 334, 339, 334, 342, 304, 319, 304, 
	344, 345, 344, 344, 344, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 344, 
	343, 343, 346, 343, 343, 347, 343, 343, 
	343, 343, 343, 343, 343, 348, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 349, 343, 351, 345, 351, 
	351, 351, 350, 350, 350, 350, 350, 350, 
	350, 350, 350, 350, 350, 350, 350, 350, 
	350, 350, 350, 350, 351, 350, 350, 346, 
	350, 350, 350, 350, 350, 350, 350, 350, 
	350, 350, 350, 350, 350, 350, 350, 350, 
	350, 350, 350, 350, 350, 350, 350, 350, 
	350, 350, 350, 350, 350, 350, 350, 350, 
	350, 350, 350, 350, 350, 350, 350, 350, 
	350, 350, 350, 350, 350, 350, 350, 350, 
	350, 350, 350, 350, 350, 350, 350, 350, 
	349, 350, 354, 353, 356, 355, 357, 352, 
	358, 352, 359, 343, 361, 360, 360, 360, 
	361, 360, 360, 360, 360, 362, 363, 362, 
	362, 362, 360, 360, 360, 360, 360, 360, 
	360, 360, 360, 360, 360, 360, 361, 360, 
	360, 360, 360, 360, 362, 360, 360, 364, 
	360, 360, 360, 360, 360, 360, 360, 360, 
	360, 360, 360, 360, 360, 360, 360, 360, 
	360, 360, 360, 360, 360, 360, 360, 360, 
	360, 365, 360, 360, 360, 360, 360, 360, 
	360, 360, 360, 360, 360, 360, 360, 360, 
	360, 360, 360, 360, 360, 360, 360, 360, 
	360, 360, 360, 360, 360, 360, 360, 360, 
	366, 360, 360, 367, 360, 362, 368, 362, 
	362, 362, 368, 368, 368, 368, 368, 368, 
	368, 368, 368, 368, 368, 368, 368, 368, 
	368, 368, 368, 368, 362, 368, 369, 370, 
	371, 372, 373, 375, 374, 377, 378, 377, 
	377, 377, 376, 376, 376, 376, 376, 376, 
	376, 376, 376, 376, 376, 376, 376, 376, 
	376, 376, 376, 376, 377, 376, 363, 374, 
	379, 374, 381, 380, 380, 380, 381, 380, 
	380, 380, 380, 382, 383, 382, 382, 382, 
	380, 380, 380, 380, 380, 380, 380, 380, 
	380, 380, 380, 380, 381, 380, 380, 380, 
	380, 380, 382, 380, 380, 384, 380, 380, 
	380, 380, 380, 380, 380, 380, 380, 380, 
	380, 380, 380, 380, 380, 380, 380, 380, 
	380, 380, 380, 380, 380, 380, 380, 380, 
	380, 380, 380, 380, 380, 380, 380, 380, 
	380, 380, 380, 380, 380, 380, 380, 380, 
	380, 380, 380, 380, 380, 380, 380, 380, 
	380, 380, 380, 380, 380, 380, 385, 380, 
	382, 386, 382, 382, 382, 386, 386, 386, 
	386, 386, 386, 386, 386, 386, 386, 386, 
	386, 386, 386, 386, 386, 386, 386, 382, 
	386, 388, 387, 387, 387, 387, 387, 387, 
	387, 387, 387, 387, 387, 387, 387, 387, 
	387, 387, 387, 387, 387, 387, 387, 387, 
	387, 387, 387, 387, 387, 389, 387, 387, 
	387, 387, 387, 387, 387, 387, 387, 387, 
	387, 387, 387, 387, 387, 387, 387, 387, 
	387, 387, 387, 387, 387, 387, 387, 387, 
	387, 387, 387, 387, 387, 387, 387, 387, 
	387, 387, 387, 387, 387, 387, 387, 387, 
	387, 387, 387, 387, 387, 387, 387, 387, 
	387, 387, 387, 387, 387, 387, 387, 387, 
	390, 387, 391, 391, 391, 391, 391, 391, 
	391, 391, 391, 391, 391, 391, 391, 391, 
	391, 391, 391, 391, 391, 391, 391, 391, 
	391, 391, 391, 391, 391, 391, 391, 391, 
	391, 391, 391, 391, 391, 391, 391, 391, 
	391, 391, 391, 391, 391, 391, 391, 391, 
	391, 391, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 391, 391, 391, 391, 
	391, 391, 391, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 391, 391, 391, 
	391, 13, 391, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 391, 391, 391, 
	391, 391, 13, 16, 16, 16, 16, 16, 
	16, 16, 16, 16, 16, 391, 392, 392, 
	392, 392, 392, 392, 392, 392, 392, 392, 
	392, 392, 392, 392, 392, 392, 392, 392, 
	392, 392, 392, 392, 392, 392, 392, 392, 
	392, 392, 392, 392, 392, 392, 392, 392, 
	392, 392, 392, 392, 392, 392, 392, 392, 
	392, 392, 392, 392, 392, 392, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	392, 392, 392, 392, 392, 392, 392, 17, 
	17, 17, 17, 17, 17, 17, 17, 17, 
	17, 17, 17, 17, 17, 17, 17, 17, 
	17, 17, 17, 17, 17, 17, 17, 17, 
	17, 392, 392, 392, 392, 17, 392, 17, 
	17, 17, 17, 17, 17, 17, 17, 17, 
	17, 17, 17, 17, 17, 17, 17, 17, 
	17, 17, 17, 17, 17, 17, 17, 17, 
	17, 392, 392, 392, 392, 392, 17, 395, 
	394, 394, 394, 395, 394, 394, 394, 394, 
	394, 394, 394, 394, 394, 394, 394, 394, 
	394, 394, 394, 394, 394, 394, 394, 394, 
	394, 395, 394, 394, 394, 394, 394, 394, 
	394, 394, 394, 394, 394, 394, 394, 394, 
	394, 394, 394, 394, 394, 394, 394, 396, 
	396, 396, 396, 396, 396, 396, 396, 394, 
	394, 394, 394, 394, 394, 394, 394, 394, 
	394, 394, 397, 394, 394, 394, 394, 394, 
	394, 394, 394, 394, 398, 394, 394, 394, 
	394, 394, 394, 394, 394, 394, 394, 394, 
	394, 394, 394, 394, 394, 394, 394, 394, 
	394, 394, 399, 394, 394, 394, 394, 394, 
	394, 394, 394, 394, 394, 394, 394, 394, 
	394, 394, 394, 394, 400, 394, 394, 401, 
	394, 402, 403, 405, 405, 405, 405, 405, 
	405, 405, 405, 404, 406, 406, 406, 406, 
	406, 406, 406, 406, 404, 404, 407, 407, 
	39, 39, 39, 407, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 407, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 40, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 408, 39, 409, 410, 411, 
	411, 39, 39, 39, 411, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 411, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 40, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 412, 39, 38, 411, 
	413, 414, 415, 415, 26, 26, 26, 415, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 26, 415, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 27, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 416, 
	26, 411, 20, 20, 20, 411, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 411, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 417, 20, 
	407, 26, 26, 26, 407, 26, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 407, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 27, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 28, 26, 407, 418, 
	418, 418, 407, 418, 418, 418, 418, 418, 
	418, 418, 418, 418, 418, 418, 418, 418, 
	418, 418, 418, 418, 418, 418, 418, 418, 
	407, 418, 418, 418, 418, 418, 418, 418, 
	418, 418, 418, 418, 418, 418, 418, 418, 
	418, 418, 418, 418, 418, 418, 418, 418, 
	418, 418, 418, 418, 418, 418, 418, 418, 
	418, 418, 418, 418, 418, 418, 418, 418, 
	418, 418, 418, 418, 418, 418, 418, 418, 
	418, 418, 418, 418, 418, 418, 418, 418, 
	418, 418, 418, 418, 418, 418, 418, 418, 
	418, 418, 419, 418, 420, 421, 421, 418, 
	418, 418, 421, 418, 418, 418, 418, 418, 
	418, 418, 418, 418, 418, 418, 418, 418, 
	418, 418, 418, 418, 418, 418, 418, 418, 
	421, 418, 418, 418, 418, 418, 418, 418, 
	418, 418, 418, 418, 418, 418, 418, 418, 
	418, 418, 418, 418, 418, 418, 418, 418, 
	418, 418, 418, 418, 418, 418, 418, 418, 
	418, 418, 418, 418, 418, 418, 418, 418, 
	418, 418, 418, 418, 418, 418, 418, 418, 
	418, 418, 418, 418, 418, 418, 418, 418, 
	418, 418, 418, 418, 418, 418, 418, 418, 
	418, 418, 422, 418, 421, 20, 20, 20, 
	421, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 421, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 417, 20, 423, 421, 421, 26, 26, 
	26, 421, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 421, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 27, 26, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 
	26, 28, 26, 425, 425, 425, 425, 425, 
	425, 425, 425, 425, 425, 424, 424, 424, 
	424, 424, 424, 424, 425, 425, 425, 425, 
	425, 425, 424, 424, 424, 424, 424, 424, 
	424, 424, 424, 424, 424, 424, 424, 424, 
	424, 424, 424, 424, 424, 424, 424, 424, 
	424, 424, 424, 424, 425, 425, 425, 425, 
	425, 425, 424, 424, 424, 424, 424, 424, 
	424, 424, 424, 424, 424, 424, 424, 424, 
	424, 424, 424, 424, 424, 424, 426, 424, 
	427, 427, 427, 427, 427, 427, 427, 427, 
	427, 427, 424, 424, 424, 424, 424, 424, 
	424, 427, 427, 427, 427, 427, 427, 424, 
	424, 424, 424, 424, 424, 424, 424, 424, 
	424, 424, 424, 424, 424, 424, 424, 424, 
	424, 424, 424, 424, 424, 424, 424, 424, 
	424, 427, 427, 427, 427, 427, 427, 424, 
	428, 428, 428, 428, 428, 428, 428, 428, 
	428, 428, 424, 424, 424, 424, 424, 424, 
	424, 428, 428, 428, 428, 428, 428, 424, 
	424, 424, 424, 424, 424, 424, 424, 424, 
	424, 424, 424, 424, 424, 424, 424, 424, 
	424, 424, 424, 424, 424, 424, 424, 424, 
	424, 428, 428, 428, 428, 428, 428, 424, 
	429, 429, 429, 429, 429, 429, 429, 429, 
	429, 429, 424, 424, 424, 424, 424, 424, 
	424, 429, 429, 429, 429, 429, 429, 424, 
	424, 424, 424, 424, 424, 424, 424, 424, 
	424, 424, 424, 424, 424, 424, 424, 424, 
	424, 424, 424, 424, 424, 424, 424, 424, 
	424, 429, 429, 429, 429, 429, 429, 424, 
	430, 433, 432, 432, 432, 433, 432, 432, 
	432, 432, 434, 432, 432, 432, 432, 432, 
	432, 432, 432, 432, 432, 432, 432, 432, 
	432, 432, 432, 433, 432, 432, 432, 432, 
	432, 434, 432, 432, 432, 432, 432, 432, 
	432, 432, 432, 432, 432, 432, 432, 432, 
	432, 435, 435, 435, 435, 435, 435, 435, 
	435, 435, 435, 432, 432, 432, 432, 432, 
	432, 432, 435, 435, 435, 435, 435, 435, 
	432, 432, 432, 432, 432, 432, 432, 432, 
	432, 432, 432, 432, 432, 432, 432, 432, 
	432, 432, 432, 432, 432, 432, 432, 432, 
	432, 432, 435, 435, 435, 435, 435, 435, 
	432, 432, 432, 432, 432, 432, 432, 432, 
	432, 432, 432, 432, 432, 432, 432, 432, 
	432, 432, 432, 432, 432, 432, 436, 432, 
	433, 432, 432, 432, 433, 432, 432, 432, 
	432, 431, 432, 432, 432, 432, 432, 432, 
	432, 432, 432, 432, 432, 432, 432, 432, 
	432, 432, 433, 432, 432, 432, 432, 432, 
	431, 432, 432, 432, 432, 432, 432, 432, 
	432, 432, 432, 432, 432, 432, 432, 432, 
	437, 437, 437, 437, 437, 437, 437, 437, 
	437, 437, 432, 432, 432, 432, 432, 432, 
	432, 437, 437, 437, 437, 437, 437, 432, 
	432, 432, 432, 432, 432, 432, 432, 432, 
	432, 432, 432, 432, 432, 432, 432, 432, 
	432, 432, 432, 432, 432, 432, 432, 432, 
	432, 437, 437, 437, 437, 437, 437, 432, 
	432, 432, 432, 432, 432, 432, 432, 432, 
	432, 432, 432, 432, 432, 432, 432, 432, 
	432, 432, 432, 432, 432, 438, 432, 431, 
	433, 437, 437, 437, 433, 437, 437, 437, 
	437, 431, 437, 437, 437, 437, 437, 437, 
	437, 437, 437, 437, 437, 437, 437, 437, 
	437, 437, 433, 437, 437, 437, 437, 437, 
	431, 437, 437, 437, 437, 437, 437, 437, 
	437, 437, 437, 437, 437, 437, 437, 437, 
	437, 437, 437, 437, 437, 437, 437, 437, 
	437, 437, 437, 437, 437, 437, 437, 437, 
	437, 437, 437, 437, 437, 437, 437, 437, 
	437, 437, 437, 437, 437, 437, 437, 437, 
	437, 437, 437, 437, 437, 437, 437, 437, 
	437, 437, 437, 437, 437, 437, 437, 437, 
	437, 437, 437, 437, 437, 437, 437, 437, 
	437, 437, 437, 437, 437, 437, 437, 437, 
	437, 437, 437, 437, 437, 437, 437, 437, 
	437, 437, 437, 437, 437, 431, 437, 439, 
	433, 440, 440, 440, 433, 440, 440, 440, 
	440, 434, 440, 440, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	440, 440, 433, 440, 440, 440, 440, 440, 
	434, 440, 440, 440, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	435, 435, 435, 435, 435, 435, 435, 435, 
	435, 435, 440, 440, 440, 440, 440, 440, 
	440, 435, 435, 435, 435, 435, 435, 440, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	440, 435, 435, 435, 435, 435, 435, 440, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 431, 440, 433, 
	440, 440, 440, 433, 440, 440, 440, 440, 
	431, 440, 440, 440, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	440, 433, 440, 440, 440, 440, 440, 431, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 440, 440, 437, 
	437, 437, 437, 437, 437, 437, 437, 437, 
	437, 440, 440, 440, 440, 440, 440, 440, 
	437, 437, 437, 437, 437, 437, 440, 440, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	437, 437, 437, 437, 437, 437, 440, 440, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	440, 440, 440, 440, 433, 440, 433, 440, 
	440, 440, 433, 440, 440, 440, 440, 441, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	433, 440, 440, 440, 440, 440, 441, 440, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 440, 442, 442, 
	442, 442, 442, 442, 442, 442, 442, 442, 
	440, 440, 440, 440, 440, 440, 440, 442, 
	442, 442, 442, 442, 442, 440, 440, 440, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 440, 440, 442, 
	442, 442, 442, 442, 442, 440, 440, 440, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	440, 440, 440, 443, 440, 433, 440, 440, 
	440, 433, 440, 440, 440, 440, 441, 440, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 440, 440, 433, 
	440, 440, 440, 440, 440, 441, 440, 440, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 435, 435, 435, 
	435, 435, 435, 435, 435, 435, 435, 440, 
	440, 440, 440, 440, 440, 440, 435, 435, 
	435, 435, 435, 435, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 440, 435, 435, 
	435, 435, 435, 435, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	440, 440, 443, 440, 444, 433, 440, 440, 
	440, 433, 440, 440, 440, 440, 441, 440, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 440, 440, 433, 
	440, 440, 440, 440, 440, 441, 440, 440, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 445, 445, 445, 
	445, 445, 445, 445, 445, 445, 445, 440, 
	440, 440, 440, 440, 440, 440, 445, 445, 
	445, 445, 445, 445, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 440, 445, 445, 
	445, 445, 445, 445, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	440, 440, 443, 440, 433, 440, 440, 440, 
	433, 440, 440, 440, 440, 441, 440, 440, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 440, 433, 440, 
	440, 440, 440, 440, 441, 440, 440, 440, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	440, 440, 440, 440, 446, 446, 446, 446, 
	446, 446, 446, 446, 446, 446, 440, 440, 
	440, 440, 440, 440, 440, 446, 446, 446, 
	446, 446, 446, 440, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 446, 446, 446, 
	446, 446, 446, 440, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	440, 443, 440, 433, 440, 440, 440, 433, 
	440, 440, 440, 440, 441, 440, 440, 440, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 433, 440, 440, 
	440, 440, 440, 441, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	440, 440, 440, 447, 447, 447, 447, 447, 
	447, 447, 447, 447, 447, 440, 440, 440, 
	440, 440, 440, 440, 447, 447, 447, 447, 
	447, 447, 440, 440, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	440, 440, 440, 440, 447, 447, 447, 447, 
	447, 447, 440, 440, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	443, 440, 433, 440, 440, 440, 433, 440, 
	440, 440, 440, 441, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	440, 440, 440, 440, 433, 440, 440, 440, 
	440, 440, 441, 440, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	440, 440, 448, 448, 448, 448, 448, 448, 
	448, 448, 448, 448, 440, 440, 440, 440, 
	440, 440, 440, 448, 448, 448, 448, 448, 
	448, 440, 440, 440, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	440, 440, 440, 448, 448, 448, 448, 448, 
	448, 440, 440, 440, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 440, 440, 443, 
	440, 433, 440, 440, 440, 433, 440, 440, 
	440, 440, 441, 440, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	440, 440, 440, 433, 440, 440, 440, 440, 
	440, 441, 440, 440, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	440, 449, 449, 449, 449, 449, 449, 449, 
	449, 449, 449, 440, 440, 440, 440, 440, 
	440, 440, 449, 449, 449, 449, 449, 449, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	440, 440, 449, 449, 449, 449, 449, 449, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 440, 443, 440, 
	433, 440, 440, 440, 433, 440, 440, 440, 
	440, 431, 440, 440, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	440, 440, 433, 440, 440, 440, 440, 440, 
	431, 440, 440, 440, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	449, 449, 449, 449, 449, 449, 449, 449, 
	449, 449, 440, 440, 440, 440, 440, 440, 
	440, 449, 449, 449, 449, 449, 449, 440, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	440, 449, 449, 449, 449, 449, 449, 440, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 440, 440, 440, 
	440, 440, 440, 440, 440, 431, 440, 450, 
	451, 453, 453, 453, 453, 453, 453, 453, 
	453, 453, 453, 452, 452, 452, 452, 452, 
	452, 452, 453, 453, 453, 453, 453, 453, 
	452, 452, 452, 452, 452, 452, 452, 452, 
	452, 452, 452, 452, 452, 452, 452, 452, 
	452, 452, 452, 452, 452, 452, 452, 452, 
	452, 452, 453, 453, 453, 453, 453, 453, 
	452, 452, 455, 454, 454, 454, 455, 454, 
	454, 454, 454, 454, 456, 454, 454, 454, 
	454, 454, 454, 454, 454, 454, 454, 454, 
	454, 454, 454, 454, 455, 454, 454, 454, 
	454, 454, 454, 454, 454, 457, 454, 454, 
	454, 454, 454, 454, 454, 454, 454, 454, 
	454, 454, 454, 454, 454, 454, 454, 454, 
	454, 454, 454, 454, 454, 454, 454, 454, 
	454, 454, 454, 454, 454, 454, 454, 454, 
	454, 454, 454, 454, 454, 454, 454, 454, 
	454, 454, 454, 454, 454, 454, 454, 454, 
	454, 454, 454, 454, 454, 454, 458, 454, 
	460, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 461, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 462, 
	459, 463, 463, 463, 463, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 463, 463, 463, 463, 463, 
	463, 463, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 463, 463, 463, 463, 
	45, 463, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 463, 463, 463, 463, 
	463, 45, 48, 48, 48, 48, 48, 48, 
	48, 48, 48, 48, 463, 464, 464, 464, 
	464, 464, 464, 464, 464, 464, 464, 464, 
	464, 464, 464, 464, 464, 464, 464, 464, 
	464, 464, 464, 464, 464, 464, 464, 464, 
	464, 464, 464, 464, 464, 464, 464, 464, 
	464, 464, 464, 464, 464, 464, 464, 464, 
	464, 464, 464, 464, 464, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 464, 
	464, 464, 464, 464, 464, 464, 49, 49, 
	49, 49, 49, 49, 49, 49, 49, 49, 
	49, 49, 49, 49, 49, 49, 49, 49, 
	49, 49, 49, 49, 49, 49, 49, 49, 
	464, 464, 464, 464, 49, 464, 49, 49, 
	49, 49, 49, 49, 49, 49, 49, 49, 
	49, 49, 49, 49, 49, 49, 49, 49, 
	49, 49, 49, 49, 49, 49, 49, 49, 
	464, 464, 464, 464, 464, 49, 467, 466, 
	466, 466, 467, 466, 466, 466, 466, 466, 
	466, 466, 466, 466, 466, 466, 466, 466, 
	466, 466, 466, 466, 466, 466, 466, 466, 
	467, 466, 466, 466, 466, 466, 466, 466, 
	466, 466, 466, 466, 466, 466, 466, 466, 
	466, 466, 466, 466, 466, 466, 468, 468, 
	468, 468, 468, 468, 468, 468, 466, 466, 
	466, 466, 466, 466, 466, 466, 466, 466, 
	466, 469, 466, 466, 466, 466, 466, 466, 
	466, 466, 466, 470, 466, 466, 466, 466, 
	466, 466, 466, 466, 466, 466, 466, 466, 
	466, 466, 466, 466, 466, 466, 466, 466, 
	466, 471, 466, 466, 466, 466, 466, 466, 
	466, 466, 466, 466, 466, 466, 466, 466, 
	466, 466, 466, 472, 466, 466, 473, 466, 
	474, 475, 477, 477, 477, 477, 477, 477, 
	477, 477, 476, 478, 478, 478, 478, 478, 
	478, 478, 478, 476, 476, 479, 479, 71, 
	71, 71, 479, 71, 71, 71, 71, 71, 
	71, 71, 71, 71, 71, 71, 71, 71, 
	71, 71, 71, 71, 71, 71, 71, 71, 
	479, 71, 71, 71, 71, 71, 71, 71, 
	71, 71, 71, 71, 71, 71, 71, 71, 
	71, 71, 71, 71, 71, 71, 71, 71, 
	71, 71, 71, 71, 71, 71, 71, 71, 
	71, 71, 71, 71, 71, 72, 71, 71, 
	71, 71, 71, 71, 71, 71, 71, 71, 
	71, 71, 71, 71, 71, 71, 71, 71, 
	71, 71, 71, 71, 71, 71, 71, 71, 
	71, 71, 480, 71, 481, 482, 483, 483, 
	71, 71, 71, 483, 71, 71, 71, 71, 
	71, 71, 71, 71, 71, 71, 71, 71, 
	71, 71, 71, 71, 71, 71, 71, 71, 
	71, 483, 71, 71, 71, 71, 71, 71, 
	71, 71, 71, 71, 71, 71, 71, 71, 
	71, 71, 71, 71, 71, 71, 71, 71, 
	71, 71, 71, 71, 71, 71, 71, 71, 
	71, 71, 71, 71, 71, 71, 72, 71, 
	71, 71, 71, 71, 71, 71, 71, 71, 
	71, 71, 71, 71, 71, 71, 71, 71, 
	71, 71, 71, 71, 71, 71, 71, 71, 
	71, 71, 71, 484, 71, 70, 483, 485, 
	486, 487, 487, 58, 58, 58, 487, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 487, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 59, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 488, 58, 
	483, 52, 52, 52, 483, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 483, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 489, 52, 479, 
	58, 58, 58, 479, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 479, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 59, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 60, 58, 479, 490, 490, 
	490, 479, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 479, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 491, 490, 492, 493, 493, 490, 490, 
	490, 493, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 493, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 494, 490, 493, 52, 52, 52, 493, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 493, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	489, 52, 495, 493, 493, 58, 58, 58, 
	493, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 493, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 59, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	58, 58, 58, 58, 58, 58, 58, 58, 
	60, 58, 497, 497, 497, 497, 497, 497, 
	497, 497, 497, 497, 496, 496, 496, 496, 
	496, 496, 496, 497, 497, 497, 497, 497, 
	497, 496, 496, 496, 496, 496, 496, 496, 
	496, 496, 496, 496, 496, 496, 496, 496, 
	496, 496, 496, 496, 496, 496, 496, 496, 
	496, 496, 496, 497, 497, 497, 497, 497, 
	497, 496, 496, 496, 496, 496, 496, 496, 
	496, 496, 496, 496, 496, 496, 496, 496, 
	496, 496, 496, 496, 496, 498, 496, 499, 
	499, 499, 499, 499, 499, 499, 499, 499, 
	499, 496, 496, 496, 496, 496, 496, 496, 
	499, 499, 499, 499, 499, 499, 496, 496, 
	496, 496, 496, 496, 496, 496, 496, 496, 
	496, 496, 496, 496, 496, 496, 496, 496, 
	496, 496, 496, 496, 496, 496, 496, 496, 
	499, 499, 499, 499, 499, 499, 496, 500, 
	500, 500, 500, 500, 500, 500, 500, 500, 
	500, 496, 496, 496, 496, 496, 496, 496, 
	500, 500, 500, 500, 500, 500, 496, 496, 
	496, 496, 496, 496, 496, 496, 496, 496, 
	496, 496, 496, 496, 496, 496, 496, 496, 
	496, 496, 496, 496, 496, 496, 496, 496, 
	500, 500, 500, 500, 500, 500, 496, 501, 
	501, 501, 501, 501, 501, 501, 501, 501, 
	501, 496, 496, 496, 496, 496, 496, 496, 
	501, 501, 501, 501, 501, 501, 496, 496, 
	496, 496, 496, 496, 496, 496, 496, 496, 
	496, 496, 496, 496, 496, 496, 496, 496, 
	496, 496, 496, 496, 496, 496, 496, 496, 
	501, 501, 501, 501, 501, 501, 496, 502, 
	505, 504, 504, 504, 505, 504, 504, 504, 
	504, 506, 504, 504, 504, 504, 504, 504, 
	504, 504, 504, 504, 504, 504, 504, 504, 
	504, 504, 505, 504, 504, 504, 504, 504, 
	506, 504, 504, 504, 504, 504, 504, 504, 
	504, 504, 504, 504, 504, 504, 504, 504, 
	507, 507, 507, 507, 507, 507, 507, 507, 
	507, 507, 504, 504, 504, 504, 504, 504, 
	504, 507, 507, 507, 507, 507, 507, 504, 
	504, 504, 504, 504, 504, 504, 504, 504, 
	504, 504, 504, 504, 504, 504, 504, 504, 
	504, 504, 504, 504, 504, 504, 504, 504, 
	504, 507, 507, 507, 507, 507, 507, 504, 
	504, 504, 504, 504, 504, 504, 504, 504, 
	504, 504, 504, 504, 504, 504, 504, 504, 
	504, 504, 504, 504, 504, 508, 504, 505, 
	504, 504, 504, 505, 504, 504, 504, 504, 
	503, 504, 504, 504, 504, 504, 504, 504, 
	504, 504, 504, 504, 504, 504, 504, 504, 
	504, 505, 504, 504, 504, 504, 504, 503, 
	504, 504, 504, 504, 504, 504, 504, 504, 
	504, 504, 504, 504, 504, 504, 504, 509, 
	509, 509, 509, 509, 509, 509, 509, 509, 
	509, 504, 504, 504, 504, 504, 504, 504, 
	509, 509, 509, 509, 509, 509, 504, 504, 
	504, 504, 504, 504, 504, 504, 504, 504, 
	504, 504, 504, 504, 504, 504, 504, 504, 
	504, 504, 504, 504, 504, 504, 504, 504, 
	509, 509, 509, 509, 509, 509, 504, 504, 
	504, 504, 504, 504, 504, 504, 504, 504, 
	504, 504, 504, 504, 504, 504, 504, 504, 
	504, 504, 504, 504, 510, 504, 503, 505, 
	509, 509, 509, 505, 509, 509, 509, 509, 
	503, 509, 509, 509, 509, 509, 509, 509, 
	509, 509, 509, 509, 509, 509, 509, 509, 
	509, 505, 509, 509, 509, 509, 509, 503, 
	509, 509, 509, 509, 509, 509, 509, 509, 
	509, 509, 509, 509, 509, 509, 509, 509, 
	509, 509, 509, 509, 509, 509, 509, 509, 
	509, 509, 509, 509, 509, 509, 509, 509, 
	509, 509, 509, 509, 509, 509, 509, 509, 
	509, 509, 509, 509, 509, 509, 509, 509, 
	509, 509, 509, 509, 509, 509, 509, 509, 
	509, 509, 509, 509, 509, 509, 509, 509, 
	509, 509, 509, 509, 509, 509, 509, 509, 
	509, 509, 509, 509, 509, 509, 509, 509, 
	509, 509, 509, 509, 509, 509, 509, 509, 
	509, 509, 509, 509, 503, 509, 511, 505, 
	512, 512, 512, 505, 512, 512, 512, 512, 
	506, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 505, 512, 512, 512, 512, 512, 506, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 507, 
	507, 507, 507, 507, 507, 507, 507, 507, 
	507, 512, 512, 512, 512, 512, 512, 512, 
	507, 507, 507, 507, 507, 507, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	507, 507, 507, 507, 507, 507, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 503, 512, 505, 512, 
	512, 512, 505, 512, 512, 512, 512, 503, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	505, 512, 512, 512, 512, 512, 503, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 509, 509, 
	509, 509, 509, 509, 509, 509, 509, 509, 
	512, 512, 512, 512, 512, 512, 512, 509, 
	509, 509, 509, 509, 509, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 509, 
	509, 509, 509, 509, 509, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 505, 512, 505, 512, 512, 
	512, 505, 512, 512, 512, 512, 513, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 505, 
	512, 512, 512, 512, 512, 513, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 514, 514, 514, 
	514, 514, 514, 514, 514, 514, 514, 512, 
	512, 512, 512, 512, 512, 512, 514, 514, 
	514, 514, 514, 514, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 514, 514, 
	514, 514, 514, 514, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 515, 512, 505, 512, 512, 512, 
	505, 512, 512, 512, 512, 513, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 505, 512, 
	512, 512, 512, 512, 513, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 507, 507, 507, 507, 
	507, 507, 507, 507, 507, 507, 512, 512, 
	512, 512, 512, 512, 512, 507, 507, 507, 
	507, 507, 507, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 507, 507, 507, 
	507, 507, 507, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 515, 512, 516, 505, 512, 512, 512, 
	505, 512, 512, 512, 512, 513, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 505, 512, 
	512, 512, 512, 512, 513, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 517, 517, 517, 517, 
	517, 517, 517, 517, 517, 517, 512, 512, 
	512, 512, 512, 512, 512, 517, 517, 517, 
	517, 517, 517, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 517, 517, 517, 
	517, 517, 517, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 515, 512, 505, 512, 512, 512, 505, 
	512, 512, 512, 512, 513, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 505, 512, 512, 
	512, 512, 512, 513, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 518, 518, 518, 518, 518, 
	518, 518, 518, 518, 518, 512, 512, 512, 
	512, 512, 512, 512, 518, 518, 518, 518, 
	518, 518, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 518, 518, 518, 518, 
	518, 518, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	515, 512, 505, 512, 512, 512, 505, 512, 
	512, 512, 512, 513, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 505, 512, 512, 512, 
	512, 512, 513, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 519, 519, 519, 519, 519, 519, 
	519, 519, 519, 519, 512, 512, 512, 512, 
	512, 512, 512, 519, 519, 519, 519, 519, 
	519, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 519, 519, 519, 519, 519, 
	519, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 515, 
	512, 505, 512, 512, 512, 505, 512, 512, 
	512, 512, 513, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 505, 512, 512, 512, 512, 
	512, 513, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 520, 520, 520, 520, 520, 520, 520, 
	520, 520, 520, 512, 512, 512, 512, 512, 
	512, 512, 520, 520, 520, 520, 520, 520, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 520, 520, 520, 520, 520, 520, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 515, 512, 
	505, 512, 512, 512, 505, 512, 512, 512, 
	512, 513, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 505, 512, 512, 512, 512, 512, 
	513, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	521, 521, 521, 521, 521, 521, 521, 521, 
	521, 521, 512, 512, 512, 512, 512, 512, 
	512, 521, 521, 521, 521, 521, 521, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 521, 521, 521, 521, 521, 521, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 515, 512, 505, 
	512, 512, 512, 505, 512, 512, 512, 512, 
	503, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 505, 512, 512, 512, 512, 512, 503, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 521, 
	521, 521, 521, 521, 521, 521, 521, 521, 
	521, 512, 512, 512, 512, 512, 512, 512, 
	521, 521, 521, 521, 521, 521, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	521, 521, 521, 521, 521, 521, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 503, 512, 522, 523, 
	525, 525, 525, 525, 525, 525, 525, 525, 
	525, 525, 524, 524, 524, 524, 524, 524, 
	524, 525, 525, 525, 525, 525, 525, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 525, 525, 525, 525, 525, 525, 524, 
	524, 527, 526, 526, 526, 527, 526, 526, 
	526, 526, 528, 529, 528, 528, 528, 526, 
	526, 526, 526, 526, 526, 526, 526, 526, 
	526, 526, 526, 527, 526, 526, 526, 526, 
	526, 528, 526, 526, 526, 526, 526, 526, 
	526, 526, 526, 526, 526, 526, 526, 526, 
	526, 526, 526, 526, 526, 526, 526, 526, 
	526, 526, 526, 526, 526, 526, 526, 526, 
	526, 526, 526, 526, 526, 526, 526, 526, 
	526, 526, 526, 526, 526, 526, 526, 526, 
	526, 526, 526, 526, 526, 526, 526, 526, 
	526, 526, 526, 526, 526, 530, 526, 528, 
	531, 528, 528, 528, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 528, 531, 
	532, 533, 533, 533, 532, 533, 533, 533, 
	533, 533, 533, 533, 533, 533, 533, 533, 
	533, 533, 533, 533, 533, 533, 533, 533, 
	533, 533, 532, 533, 535, 534, 534, 534, 
	535, 534, 534, 534, 534, 534, 536, 534, 
	534, 534, 534, 534, 534, 534, 534, 534, 
	534, 534, 534, 534, 534, 534, 535, 534, 
	534, 534, 534, 534, 534, 534, 534, 534, 
	534, 534, 534, 534, 534, 534, 534, 534, 
	534, 534, 534, 534, 534, 534, 534, 534, 
	534, 534, 534, 534, 534, 534, 534, 534, 
	534, 534, 534, 534, 534, 534, 534, 534, 
	534, 534, 534, 534, 534, 534, 534, 534, 
	534, 534, 534, 534, 534, 534, 534, 534, 
	534, 534, 534, 534, 534, 534, 534, 534, 
	537, 534, 538, 539, 539, 539, 538, 539, 
	539, 539, 539, 539, 540, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 538, 539, 542, 541, 
	541, 541, 542, 541, 541, 541, 541, 541, 
	543, 541, 541, 541, 541, 541, 541, 541, 
	541, 541, 541, 541, 541, 541, 541, 541, 
	542, 541, 541, 541, 541, 541, 541, 541, 
	541, 544, 541, 546, 545, 545, 545, 545, 
	545, 545, 545, 545, 545, 545, 545, 545, 
	545, 545, 545, 545, 545, 545, 545, 545, 
	545, 545, 545, 545, 545, 545, 545, 547, 
	545, 545, 545, 545, 545, 545, 545, 545, 
	545, 545, 545, 545, 545, 545, 545, 545, 
	545, 545, 545, 545, 545, 545, 545, 545, 
	545, 545, 545, 545, 545, 545, 545, 545, 
	545, 545, 545, 545, 545, 545, 545, 545, 
	545, 545, 545, 545, 545, 545, 545, 545, 
	545, 545, 545, 545, 545, 545, 545, 545, 
	545, 545, 548, 545, 549, 549, 549, 549, 
	549, 549, 549, 549, 549, 549, 549, 549, 
	549, 549, 549, 549, 549, 549, 549, 549, 
	549, 549, 549, 549, 549, 549, 549, 549, 
	549, 549, 549, 549, 549, 549, 549, 549, 
	549, 549, 549, 549, 549, 549, 549, 549, 
	549, 549, 549, 549, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 549, 549, 
	549, 549, 549, 549, 549, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 549, 
	549, 549, 549, 77, 549, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 549, 
	549, 549, 549, 549, 77, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 549, 
	550, 550, 550, 550, 550, 550, 550, 550, 
	550, 550, 550, 550, 550, 550, 550, 550, 
	550, 550, 550, 550, 550, 550, 550, 550, 
	550, 550, 550, 550, 550, 550, 550, 550, 
	550, 550, 550, 550, 550, 550, 550, 550, 
	550, 550, 550, 550, 550, 550, 550, 550, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 550, 550, 550, 550, 550, 550, 
	550, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 550, 550, 550, 550, 81, 
	550, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 550, 550, 550, 550, 550, 
	81, 552, 551, 551, 551, 552, 551, 551, 
	551, 551, 551, 553, 551, 551, 551, 551, 
	551, 551, 551, 551, 551, 551, 551, 551, 
	551, 551, 551, 552, 551, 555, 554, 554, 
	554, 555, 554, 554, 554, 554, 556, 557, 
	556, 556, 556, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 555, 
	554, 554, 554, 554, 554, 556, 554, 554, 
	558, 554, 556, 559, 556, 556, 556, 559, 
	559, 559, 559, 559, 559, 559, 559, 559, 
	559, 559, 559, 559, 559, 559, 559, 559, 
	559, 556, 559, 561, 560, 560, 560, 560, 
	560, 560, 560, 560, 560, 560, 560, 560, 
	560, 560, 560, 560, 560, 560, 560, 560, 
	560, 560, 560, 560, 560, 560, 560, 562, 
	560, 560, 560, 560, 560, 560, 560, 560, 
	560, 560, 560, 560, 560, 560, 560, 560, 
	560, 560, 560, 560, 560, 560, 560, 560, 
	560, 560, 560, 560, 560, 560, 560, 560, 
	560, 560, 560, 560, 560, 560, 560, 560, 
	560, 560, 560, 560, 560, 560, 560, 560, 
	560, 560, 560, 560, 560, 560, 560, 560, 
	560, 560, 563, 560, 564, 564, 564, 564, 
	564, 564, 564, 564, 564, 564, 564, 564, 
	564, 564, 564, 564, 564, 564, 564, 564, 
	564, 564, 564, 564, 564, 564, 564, 564, 
	564, 564, 564, 564, 564, 564, 564, 564, 
	564, 564, 564, 564, 564, 564, 564, 564, 
	564, 564, 564, 564, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 564, 564, 
	564, 564, 564, 564, 564, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 564, 
	564, 564, 564, 84, 564, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 564, 
	564, 564, 564, 564, 84, 87, 87, 87, 
	87, 87, 87, 87, 87, 87, 87, 564, 
	565, 565, 565, 565, 565, 565, 565, 565, 
	565, 565, 565, 565, 565, 565, 565, 565, 
	565, 565, 565, 565, 565, 565, 565, 565, 
	565, 565, 565, 565, 565, 565, 565, 565, 
	565, 565, 565, 565, 565, 565, 565, 565, 
	565, 565, 565, 565, 565, 565, 565, 565, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	84, 84, 565, 565, 565, 565, 565, 565, 
	565, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 565, 565, 565, 565, 88, 
	565, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 565, 565, 565, 565, 565, 
	88, 567, 566, 566, 566, 567, 566, 566, 
	566, 566, 568, 569, 568, 568, 568, 566, 
	566, 566, 566, 566, 566, 566, 566, 566, 
	566, 566, 566, 567, 566, 566, 566, 566, 
	566, 568, 566, 568, 570, 568, 568, 568, 
	570, 570, 570, 570, 570, 570, 570, 570, 
	570, 570, 570, 570, 570, 570, 570, 570, 
	570, 570, 568, 570, 572, 572, 572, 572, 
	572, 572, 572, 572, 572, 572, 572, 572, 
	572, 572, 572, 572, 572, 572, 572, 572, 
	572, 572, 572, 572, 572, 572, 571, 571, 
	571, 571, 571, 571, 572, 572, 572, 572, 
	572, 572, 572, 572, 572, 572, 572, 572, 
	572, 572, 572, 572, 572, 572, 572, 572, 
	572, 572, 572, 572, 572, 572, 571, 572, 
	572, 572, 572, 572, 572, 572, 572, 572, 
	572, 572, 572, 572, 572, 572, 572, 572, 
	572, 572, 572, 572, 572, 572, 572, 572, 
	572, 573, 573, 573, 573, 573, 573, 572, 
	572, 572, 572, 572, 572, 572, 572, 572, 
	572, 572, 572, 572, 572, 572, 572, 572, 
	572, 572, 572, 572, 572, 572, 572, 572, 
	572, 573, 574, 92, 92, 92, 92, 92, 
	92, 92, 92, 92, 92, 92, 92, 92, 
	92, 92, 92, 92, 92, 92, 92, 92, 
	92, 92, 92, 92, 92, 92, 575, 92, 
	576, 576, 576, 576, 576, 576, 576, 576, 
	576, 576, 576, 576, 576, 576, 576, 576, 
	576, 576, 576, 576, 576, 576, 576, 576, 
	576, 576, 576, 576, 576, 576, 576, 576, 
	576, 576, 576, 576, 576, 576, 576, 576, 
	576, 576, 576, 576, 576, 576, 576, 576, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 576, 576, 576, 576, 576, 576, 
	576, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 576, 576, 576, 576, 90, 
	576, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 576, 576, 576, 576, 576, 
	90, 94, 94, 94, 94, 94, 94, 94, 
	94, 94, 94, 576, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 577, 577, 
	577, 577, 577, 577, 577, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 577, 
	577, 577, 577, 95, 577, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 577, 
	577, 577, 577, 577, 95, 578, 578, 578, 
	578, 578, 578, 578, 578, 578, 578, 578, 
	578, 578, 578, 578, 578, 578, 578, 578, 
	578, 578, 578, 578, 578, 578, 578, 578, 
	578, 578, 578, 578, 578, 578, 578, 578, 
	578, 578, 578, 578, 578, 578, 578, 578, 
	578, 578, 578, 578, 578, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 578, 
	578, 578, 578, 578, 578, 578, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	578, 578, 578, 578, 97, 578, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	578, 578, 578, 578, 578, 97, 580, 581, 
	581, 581, 580, 581, 581, 581, 581, 582, 
	583, 582, 582, 582, 581, 581, 581, 581, 
	581, 581, 581, 581, 581, 581, 581, 581, 
	580, 581, 581, 581, 581, 581, 582, 584, 
	581, 585, 586, 587, 588, 581, 581, 581, 
	589, 590, 581, 590, 581, 591, 581, 581, 
	581, 581, 581, 581, 581, 581, 581, 581, 
	592, 581, 593, 594, 595, 581, 581, 596, 
	597, 596, 596, 598, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 599, 600, 581, 591, 601, 591, 602, 
	603, 604, 605, 606, 607, 579, 579, 608, 
	579, 579, 579, 609, 610, 611, 579, 579, 
	612, 613, 614, 615, 579, 616, 579, 617, 
	579, 581, 618, 581, 590, 581, 579, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	620, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 619, 619, 619, 620, 619, 620, 619, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 619, 619, 619, 619, 579, 619, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 619, 619, 619, 619, 619, 579, 
	582, 621, 582, 582, 582, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 582, 
	621, 622, 591, 623, 623, 591, 623, 623, 
	623, 623, 623, 623, 623, 623, 623, 623, 
	623, 623, 623, 623, 623, 623, 623, 623, 
	623, 623, 623, 623, 623, 623, 623, 623, 
	623, 623, 623, 623, 623, 623, 623, 623, 
	623, 623, 623, 623, 623, 623, 623, 623, 
	623, 623, 623, 623, 623, 623, 623, 623, 
	623, 623, 623, 623, 623, 623, 623, 623, 
	623, 623, 623, 591, 623, 624, 625, 626, 
	627, 628, 628, 628, 628, 628, 628, 628, 
	628, 628, 628, 628, 628, 628, 628, 628, 
	628, 628, 628, 628, 628, 628, 628, 628, 
	628, 628, 628, 628, 628, 628, 628, 628, 
	628, 628, 99, 99, 628, 99, 628, 99, 
	99, 628, 628, 99, 99, 99, 630, 99, 
	99, 631, 631, 631, 631, 631, 631, 631, 
	631, 631, 631, 99, 99, 99, 99, 99, 
	99, 99, 629, 629, 629, 629, 629, 629, 
	629, 629, 629, 629, 629, 629, 629, 629, 
	629, 629, 629, 629, 629, 629, 629, 629, 
	629, 629, 629, 629, 628, 99, 628, 628, 
	629, 99, 629, 629, 629, 629, 629, 629, 
	629, 629, 629, 629, 629, 629, 629, 629, 
	629, 629, 629, 629, 629, 629, 629, 629, 
	629, 629, 629, 629, 628, 628, 628, 99, 
	628, 629, 632, 632, 632, 632, 632, 632, 
	632, 632, 632, 632, 632, 632, 632, 632, 
	632, 632, 632, 632, 632, 632, 632, 632, 
	632, 632, 632, 632, 632, 632, 632, 632, 
	632, 632, 632, 632, 632, 632, 632, 632, 
	632, 632, 632, 632, 632, 632, 632, 632, 
	632, 632, 629, 629, 629, 629, 629, 629, 
	629, 629, 629, 629, 632, 632, 632, 632, 
	632, 632, 632, 629, 629, 629, 629, 629, 
	629, 629, 629, 629, 629, 629, 629, 629, 
	629, 629, 629, 629, 629, 629, 629, 629, 
	629, 629, 629, 629, 629, 632, 632, 632, 
	632, 629, 632, 629, 629, 629, 629, 629, 
	629, 629, 629, 629, 629, 629, 629, 629, 
	629, 629, 629, 629, 629, 629, 629, 629, 
	629, 629, 629, 629, 629, 632, 632, 632, 
	632, 632, 629, 631, 631, 631, 631, 631, 
	631, 631, 631, 631, 631, 632, 633, 623, 
	591, 623, 591, 623, 591, 623, 635, 634, 
	591, 636, 623, 591, 623, 637, 591, 628, 
	628, 628, 628, 628, 628, 628, 628, 628, 
	628, 628, 628, 628, 628, 628, 628, 628, 
	628, 628, 628, 628, 628, 628, 628, 628, 
	628, 628, 628, 628, 628, 628, 628, 628, 
	628, 628, 628, 628, 628, 628, 628, 628, 
	628, 628, 628, 628, 628, 628, 628, 628, 
	628, 628, 628, 628, 628, 628, 628, 628, 
	628, 628, 628, 628, 628, 628, 591, 628, 
	591, 623, 591, 591, 623, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 620, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 619, 
	619, 619, 620, 619, 620, 619, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	619, 619, 619, 619, 596, 619, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	619, 619, 619, 619, 619, 596, 638, 638, 
	638, 638, 638, 638, 638, 638, 638, 638, 
	638, 638, 638, 638, 638, 638, 638, 638, 
	638, 638, 638, 638, 638, 638, 638, 638, 
	638, 638, 638, 638, 638, 638, 638, 620, 
	638, 638, 638, 638, 638, 638, 638, 638, 
	638, 638, 638, 638, 638, 638, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	638, 638, 638, 620, 638, 620, 638, 596, 
	596, 596, 596, 639, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 638, 638, 638, 638, 596, 638, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 638, 638, 638, 638, 638, 596, 638, 
	638, 638, 638, 638, 638, 638, 638, 638, 
	638, 638, 638, 638, 638, 638, 638, 638, 
	638, 638, 638, 638, 638, 638, 638, 638, 
	638, 638, 638, 638, 638, 638, 638, 638, 
	620, 638, 638, 638, 638, 638, 638, 638, 
	638, 638, 638, 638, 638, 638, 638, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 638, 638, 638, 620, 638, 620, 638, 
	596, 596, 596, 596, 596, 596, 640, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 638, 638, 638, 638, 596, 638, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 638, 638, 638, 638, 638, 596, 
	638, 638, 638, 638, 638, 638, 638, 638, 
	638, 638, 638, 638, 638, 638, 638, 638, 
	638, 638, 638, 638, 638, 638, 638, 638, 
	638, 638, 638, 638, 638, 638, 638, 638, 
	638, 620, 638, 638, 638, 638, 638, 638, 
	638, 638, 638, 638, 638, 638, 638, 638, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 638, 638, 638, 620, 638, 620, 
	638, 596, 596, 596, 596, 596, 596, 596, 
	596, 641, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 638, 638, 638, 638, 596, 
	638, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 638, 638, 638, 638, 638, 
	596, 638, 638, 638, 638, 638, 638, 638, 
	638, 638, 638, 638, 638, 638, 638, 638, 
	638, 638, 638, 638, 638, 638, 638, 638, 
	638, 638, 638, 638, 638, 638, 638, 638, 
	638, 638, 620, 638, 638, 638, 638, 638, 
	638, 638, 638, 638, 638, 638, 638, 638, 
	638, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 638, 638, 638, 620, 638, 
	620, 638, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 642, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 638, 638, 638, 638, 
	596, 638, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 638, 638, 638, 638, 
	638, 596, 638, 638, 638, 638, 638, 638, 
	638, 638, 638, 638, 638, 638, 638, 638, 
	638, 638, 638, 638, 638, 638, 638, 638, 
	638, 638, 638, 638, 638, 638, 638, 638, 
	638, 638, 638, 620, 638, 638, 638, 638, 
	638, 638, 638, 638, 638, 638, 638, 638, 
	638, 638, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 638, 638, 638, 620, 
	638, 620, 638, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	643, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 638, 638, 638, 
	638, 596, 638, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 638, 638, 638, 
	638, 638, 596, 638, 638, 638, 638, 638, 
	638, 638, 638, 638, 638, 638, 638, 638, 
	638, 638, 638, 638, 638, 638, 638, 638, 
	638, 638, 638, 638, 638, 638, 638, 638, 
	638, 638, 638, 638, 620, 638, 638, 638, 
	638, 638, 638, 638, 638, 638, 638, 638, 
	638, 638, 638, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 638, 638, 638, 
	620, 638, 620, 638, 596, 596, 596, 642, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 638, 638, 
	638, 638, 596, 638, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 638, 638, 
	638, 638, 638, 596, 637, 628, 583, 628, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 620, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 644, 644, 644, 620, 644, 620, 
	644, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 644, 644, 644, 644, 645, 
	644, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 644, 644, 644, 644, 644, 
	579, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 620, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 644, 644, 644, 620, 644, 
	620, 644, 579, 579, 579, 579, 646, 647, 
	579, 579, 579, 579, 579, 648, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 644, 644, 644, 644, 
	579, 644, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 644, 644, 644, 644, 
	644, 579, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 620, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 644, 644, 644, 620, 
	644, 620, 644, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	649, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 644, 644, 644, 
	644, 579, 644, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 644, 644, 644, 
	644, 644, 579, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 620, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 644, 644, 644, 
	620, 644, 620, 644, 579, 579, 650, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 644, 644, 
	644, 644, 579, 644, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 644, 644, 
	644, 644, 644, 579, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 620, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 644, 644, 
	644, 620, 644, 620, 644, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 651, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 644, 
	644, 644, 644, 579, 644, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 644, 
	644, 644, 644, 644, 579, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 620, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 644, 
	644, 644, 620, 644, 620, 644, 579, 579, 
	579, 652, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	644, 644, 644, 644, 579, 644, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	644, 644, 644, 644, 644, 579, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 620, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	644, 644, 644, 620, 644, 620, 644, 579, 
	579, 579, 579, 579, 579, 579, 579, 653, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 644, 644, 644, 644, 579, 644, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 644, 644, 644, 644, 644, 579, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	620, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 644, 644, 644, 620, 644, 620, 644, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 654, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 644, 644, 644, 644, 579, 644, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 644, 644, 644, 644, 644, 579, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 620, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 644, 644, 644, 620, 644, 620, 
	644, 579, 579, 579, 579, 579, 579, 655, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 644, 644, 644, 644, 579, 
	644, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 644, 644, 644, 644, 644, 
	579, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 620, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 644, 644, 644, 620, 644, 
	620, 644, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 644, 644, 644, 644, 
	656, 644, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 644, 644, 644, 644, 
	644, 579, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 620, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 644, 644, 644, 620, 
	644, 620, 644, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 644, 644, 644, 
	644, 657, 644, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 644, 644, 644, 
	644, 644, 579, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 620, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 644, 644, 644, 
	620, 644, 620, 644, 579, 579, 579, 579, 
	579, 579, 579, 579, 658, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 644, 644, 
	644, 644, 579, 644, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 644, 644, 
	644, 644, 644, 579, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 620, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 644, 644, 
	644, 620, 644, 620, 644, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	659, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 644, 
	644, 644, 644, 579, 644, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 644, 
	644, 644, 644, 644, 579, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 620, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 644, 
	644, 644, 620, 644, 620, 644, 579, 579, 
	579, 579, 655, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	644, 644, 644, 644, 579, 644, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	644, 644, 644, 644, 644, 579, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 620, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	644, 644, 644, 620, 644, 620, 644, 579, 
	579, 579, 579, 579, 579, 579, 579, 660, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 644, 644, 644, 644, 579, 644, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 644, 644, 644, 644, 644, 579, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	620, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 644, 644, 644, 620, 644, 620, 644, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 659, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 644, 644, 644, 644, 579, 644, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 644, 644, 644, 644, 644, 579, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 620, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 644, 644, 644, 620, 644, 620, 
	644, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 644, 644, 644, 644, 579, 
	644, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 661, 579, 662, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 644, 644, 644, 644, 644, 
	579, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 620, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 644, 644, 644, 620, 644, 
	620, 644, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 644, 644, 644, 644, 
	579, 644, 579, 579, 579, 579, 579, 579, 
	579, 579, 663, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 644, 644, 644, 644, 
	644, 579, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 620, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 644, 644, 644, 620, 
	644, 620, 644, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 644, 644, 644, 
	644, 579, 644, 664, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 644, 644, 644, 
	644, 644, 579, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 620, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 644, 644, 644, 
	620, 644, 620, 644, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 644, 644, 
	644, 644, 579, 644, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 657, 579, 
	579, 579, 579, 579, 579, 579, 644, 644, 
	644, 644, 644, 579, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 620, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 644, 644, 
	644, 620, 644, 620, 644, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 644, 
	644, 644, 644, 579, 644, 579, 579, 579, 
	657, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 644, 
	644, 644, 644, 644, 579, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 620, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 644, 
	644, 644, 620, 644, 620, 644, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	644, 644, 644, 644, 579, 644, 579, 579, 
	579, 579, 665, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 666, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	644, 644, 644, 644, 644, 579, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 620, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	644, 644, 644, 620, 644, 620, 644, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 644, 644, 644, 644, 579, 644, 579, 
	579, 579, 579, 579, 579, 667, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 644, 644, 644, 644, 644, 579, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	620, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 644, 644, 644, 620, 644, 620, 644, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 644, 644, 644, 644, 579, 644, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	668, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 644, 644, 644, 644, 644, 579, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 620, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 644, 644, 644, 620, 644, 620, 
	644, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 644, 644, 644, 644, 579, 
	644, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 657, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 644, 644, 644, 644, 644, 
	579, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 620, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 644, 644, 644, 620, 644, 
	620, 644, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 644, 644, 644, 644, 
	579, 644, 579, 579, 579, 579, 669, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 644, 644, 644, 644, 
	644, 579, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 620, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 644, 644, 644, 620, 
	644, 620, 644, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 644, 644, 644, 
	644, 579, 644, 670, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 644, 644, 644, 
	644, 644, 579, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 620, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 644, 644, 644, 
	620, 644, 620, 644, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 644, 644, 
	644, 644, 579, 644, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 657, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 644, 644, 
	644, 644, 644, 579, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 620, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 644, 644, 
	644, 620, 644, 620, 644, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 644, 
	644, 644, 644, 579, 644, 671, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	672, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 644, 
	644, 644, 644, 644, 579, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 620, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 644, 
	644, 644, 620, 644, 620, 644, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	644, 644, 644, 644, 579, 644, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	673, 579, 579, 579, 579, 579, 579, 579, 
	644, 644, 644, 644, 644, 579, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 620, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	644, 644, 644, 620, 644, 620, 644, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 644, 644, 644, 644, 579, 644, 579, 
	579, 579, 579, 657, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 644, 644, 644, 644, 644, 579, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	620, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 644, 644, 644, 620, 644, 620, 644, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 644, 644, 644, 644, 579, 644, 
	674, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 644, 644, 644, 644, 644, 579, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 620, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 644, 644, 644, 620, 644, 620, 
	644, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 644, 644, 644, 644, 579, 
	644, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 664, 579, 579, 579, 579, 
	579, 579, 579, 644, 644, 644, 644, 644, 
	579, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 620, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 644, 644, 644, 620, 644, 
	620, 644, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 644, 644, 644, 644, 
	579, 644, 579, 579, 579, 579, 675, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	657, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 644, 644, 644, 644, 
	644, 579, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 620, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 644, 644, 644, 620, 
	644, 620, 644, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 644, 644, 644, 
	644, 579, 644, 579, 579, 579, 579, 579, 
	676, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 644, 644, 644, 
	644, 644, 579, 677, 677, 677, 677, 677, 
	677, 677, 677, 677, 677, 677, 677, 677, 
	677, 677, 677, 677, 677, 677, 677, 677, 
	677, 677, 677, 677, 677, 677, 677, 677, 
	677, 677, 677, 677, 620, 677, 677, 677, 
	677, 677, 677, 677, 677, 677, 677, 677, 
	677, 677, 677, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 677, 677, 677, 
	620, 677, 620, 677, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 677, 677, 
	677, 677, 579, 677, 579, 579, 579, 579, 
	579, 579, 579, 579, 678, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 677, 677, 
	677, 677, 677, 579, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 620, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 644, 644, 
	644, 620, 644, 620, 644, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 644, 
	644, 644, 644, 579, 644, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 679, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 644, 
	644, 644, 644, 644, 579, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 620, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 644, 
	644, 644, 620, 644, 620, 644, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	644, 644, 644, 644, 579, 644, 579, 579, 
	579, 579, 680, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	644, 644, 644, 644, 644, 579, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 620, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	644, 644, 644, 620, 644, 620, 644, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 644, 644, 644, 644, 579, 644, 579, 
	579, 579, 681, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 644, 644, 644, 644, 644, 579, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	620, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 644, 644, 644, 620, 644, 682, 644, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 644, 644, 644, 644, 579, 644, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 644, 644, 644, 644, 644, 579, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 620, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 644, 644, 644, 620, 644, 620, 
	644, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 644, 644, 644, 644, 579, 
	644, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 683, 579, 684, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 644, 644, 644, 644, 644, 
	579, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 620, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 644, 644, 644, 620, 644, 
	620, 644, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 644, 644, 644, 644, 
	579, 644, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 685, 579, 579, 579, 
	579, 579, 579, 579, 644, 644, 644, 644, 
	644, 579, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 620, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 644, 644, 644, 620, 
	644, 620, 644, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 644, 644, 644, 
	644, 579, 644, 579, 579, 579, 579, 657, 
	579, 579, 579, 686, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 644, 644, 644, 
	644, 644, 579, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 620, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 644, 644, 644, 
	620, 644, 620, 644, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 644, 644, 
	644, 644, 579, 644, 579, 579, 579, 579, 
	579, 657, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 644, 644, 
	644, 644, 644, 579, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 620, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 644, 644, 
	644, 620, 644, 620, 644, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 644, 
	644, 644, 644, 579, 644, 579, 579, 579, 
	657, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 687, 
	579, 579, 579, 579, 579, 579, 579, 644, 
	644, 644, 644, 644, 579, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 620, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 644, 
	644, 644, 620, 644, 620, 644, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	644, 644, 644, 644, 579, 644, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 688, 579, 579, 579, 579, 579, 
	644, 644, 644, 644, 644, 579, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 620, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	644, 644, 644, 620, 644, 620, 644, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 644, 644, 644, 644, 579, 644, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	673, 579, 579, 579, 579, 579, 579, 579, 
	579, 644, 644, 644, 644, 644, 579, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	620, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 644, 644, 644, 620, 644, 620, 644, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 644, 644, 644, 644, 579, 644, 
	689, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 611, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 644, 644, 644, 644, 644, 579, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 620, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 644, 644, 644, 620, 644, 620, 
	644, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 644, 644, 644, 644, 579, 
	644, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 671, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 644, 644, 644, 644, 644, 
	579, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 620, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 644, 644, 644, 620, 644, 
	620, 644, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 644, 644, 644, 644, 
	579, 644, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 657, 579, 579, 579, 579, 
	579, 579, 579, 579, 644, 644, 644, 644, 
	644, 579, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 620, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 644, 644, 644, 620, 
	644, 620, 644, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 644, 644, 644, 
	644, 579, 644, 579, 579, 579, 579, 579, 
	657, 579, 579, 579, 579, 579, 579, 579, 
	657, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 644, 644, 644, 
	644, 644, 579, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 620, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 644, 644, 644, 
	620, 644, 620, 644, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 644, 644, 
	644, 644, 579, 644, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 690, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 644, 644, 
	644, 644, 644, 579, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 620, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 644, 644, 
	644, 620, 644, 620, 644, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 644, 
	644, 644, 644, 579, 644, 579, 579, 579, 
	691, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 644, 
	644, 644, 644, 644, 579, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 620, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 644, 
	644, 644, 620, 644, 620, 644, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	644, 644, 644, 644, 579, 644, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 692, 579, 579, 579, 579, 579, 
	644, 644, 644, 644, 644, 579, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 620, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	644, 644, 644, 620, 644, 620, 644, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 644, 644, 644, 644, 579, 644, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 673, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 644, 644, 644, 644, 644, 579, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	620, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 644, 644, 644, 620, 644, 620, 644, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 644, 644, 644, 644, 579, 644, 
	579, 579, 579, 579, 693, 579, 579, 579, 
	694, 579, 579, 579, 579, 579, 695, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 644, 644, 644, 644, 644, 579, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 620, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 644, 644, 644, 620, 644, 620, 
	644, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 644, 644, 644, 644, 579, 
	644, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	695, 579, 579, 644, 644, 644, 644, 644, 
	579, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 620, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 644, 644, 644, 620, 644, 
	620, 644, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 644, 644, 644, 644, 
	579, 644, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 657, 579, 579, 
	579, 579, 579, 579, 644, 644, 644, 644, 
	644, 579, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 620, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 644, 644, 644, 620, 
	644, 620, 644, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 644, 644, 644, 
	644, 579, 644, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 657, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 644, 644, 644, 
	644, 644, 579, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 620, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 644, 644, 644, 
	620, 644, 620, 644, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 644, 644, 
	644, 644, 579, 644, 579, 579, 579, 579, 
	696, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 644, 644, 
	644, 644, 644, 579, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 620, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 644, 644, 
	644, 620, 644, 620, 644, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 644, 
	644, 644, 644, 579, 644, 579, 579, 579, 
	697, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 698, 
	699, 579, 579, 579, 579, 579, 579, 644, 
	644, 644, 644, 644, 579, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 620, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 644, 
	644, 644, 620, 644, 620, 644, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	644, 644, 644, 644, 579, 644, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 657, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	644, 644, 644, 644, 644, 579, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 620, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	644, 644, 644, 620, 644, 620, 644, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 644, 644, 644, 644, 579, 644, 579, 
	579, 700, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 644, 644, 644, 644, 644, 579, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	620, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 644, 644, 644, 620, 644, 620, 644, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 644, 644, 644, 644, 579, 644, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 673, 579, 579, 579, 
	579, 579, 644, 644, 644, 644, 644, 579, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 620, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 644, 644, 644, 620, 644, 620, 
	644, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 644, 644, 644, 644, 579, 
	644, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 701, 579, 579, 702, 579, 579, 
	579, 579, 579, 644, 644, 644, 644, 644, 
	579, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 620, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 644, 644, 644, 620, 644, 
	620, 644, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 644, 644, 644, 644, 
	579, 644, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 657, 579, 644, 644, 644, 644, 
	644, 579, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 620, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 644, 644, 644, 620, 
	644, 620, 644, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 644, 644, 644, 
	644, 579, 644, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 668, 579, 579, 579, 
	579, 579, 579, 579, 579, 644, 644, 644, 
	644, 644, 579, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 620, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 644, 644, 644, 
	620, 644, 620, 644, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 644, 644, 
	644, 644, 579, 644, 579, 579, 579, 579, 
	703, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	704, 579, 579, 579, 579, 579, 644, 644, 
	644, 644, 644, 579, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 620, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 644, 644, 
	644, 620, 644, 620, 644, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 644, 
	644, 644, 644, 579, 644, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	686, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 644, 
	644, 644, 644, 644, 579, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 620, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 644, 
	644, 644, 620, 644, 620, 644, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	644, 644, 644, 644, 579, 644, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 705, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	644, 644, 644, 644, 644, 579, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 620, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	644, 644, 644, 620, 644, 620, 644, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 644, 644, 644, 644, 579, 644, 579, 
	579, 579, 579, 611, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 644, 644, 644, 644, 644, 579, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	620, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 644, 644, 644, 620, 644, 620, 644, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 644, 644, 644, 644, 579, 644, 
	579, 579, 579, 579, 579, 579, 579, 706, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 700, 579, 579, 579, 579, 579, 579, 
	579, 579, 644, 644, 644, 644, 644, 579, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 620, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 644, 644, 644, 620, 644, 620, 
	644, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 644, 644, 644, 644, 579, 
	644, 579, 579, 579, 579, 668, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 644, 644, 644, 644, 644, 
	579, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 620, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 644, 644, 644, 620, 644, 
	620, 644, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 644, 644, 644, 644, 
	579, 644, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 707, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 644, 644, 644, 644, 
	644, 579, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 620, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 644, 644, 644, 620, 
	644, 620, 644, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 644, 644, 644, 
	644, 579, 644, 579, 579, 579, 708, 579, 
	579, 579, 579, 579, 579, 579, 709, 579, 
	579, 579, 579, 579, 579, 579, 710, 579, 
	579, 579, 579, 579, 579, 644, 644, 644, 
	644, 644, 579, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 620, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 644, 644, 644, 
	620, 644, 620, 644, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 644, 644, 
	644, 644, 579, 644, 579, 579, 579, 579, 
	686, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 644, 644, 
	644, 644, 644, 579, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 620, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 644, 644, 
	644, 620, 644, 620, 644, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 644, 
	644, 644, 644, 579, 644, 579, 579, 579, 
	579, 674, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 644, 
	644, 644, 644, 644, 579, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 620, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 644, 
	644, 644, 620, 644, 620, 644, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	644, 644, 644, 644, 579, 644, 579, 579, 
	579, 579, 579, 579, 579, 579, 694, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	644, 644, 644, 644, 644, 579, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 620, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	644, 644, 644, 620, 644, 620, 644, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 644, 644, 644, 644, 579, 644, 579, 
	579, 579, 579, 579, 579, 579, 711, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 644, 644, 644, 644, 644, 579, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	620, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 644, 644, 644, 620, 644, 620, 644, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 644, 644, 644, 644, 579, 644, 
	579, 579, 579, 579, 668, 579, 579, 579, 
	692, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 644, 644, 644, 644, 644, 579, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 620, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 644, 644, 644, 620, 644, 620, 
	644, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 644, 644, 644, 644, 579, 
	644, 579, 579, 579, 579, 579, 579, 579, 
	579, 712, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 644, 644, 644, 644, 644, 
	579, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 620, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 644, 644, 644, 620, 644, 
	620, 644, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 644, 644, 644, 644, 
	579, 644, 579, 579, 579, 579, 713, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 644, 644, 644, 644, 
	644, 579, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 644, 620, 644, 644, 644, 644, 
	644, 644, 644, 644, 644, 644, 644, 644, 
	644, 644, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 644, 644, 644, 620, 
	644, 620, 644, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 644, 644, 644, 
	644, 579, 644, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 579, 662, 579, 
	579, 579, 579, 579, 579, 579, 579, 579, 
	579, 579, 579, 579, 579, 644, 644, 644, 
	644, 644, 579, 591, 623, 715, 716, 716, 
	716, 715, 716, 716, 716, 716, 717, 716, 
	717, 717, 717, 716, 716, 716, 716, 716, 
	716, 716, 716, 716, 716, 716, 716, 715, 
	716, 716, 716, 716, 716, 717, 716, 716, 
	718, 716, 716, 716, 716, 716, 716, 716, 
	716, 716, 716, 716, 716, 716, 716, 716, 
	716, 716, 716, 716, 716, 716, 716, 716, 
	716, 716, 716, 716, 716, 716, 714, 714, 
	714, 714, 714, 714, 714, 714, 714, 714, 
	714, 714, 714, 714, 714, 714, 714, 714, 
	714, 714, 714, 714, 714, 714, 714, 714, 
	716, 719, 716, 716, 714, 716, 714, 714, 
	714, 714, 714, 714, 714, 714, 714, 714, 
	714, 714, 714, 714, 714, 714, 714, 714, 
	714, 714, 714, 714, 714, 714, 714, 714, 
	716, 716, 716, 716, 716, 714, 720, 720, 
	720, 720, 720, 720, 720, 720, 720, 720, 
	720, 720, 720, 720, 720, 720, 720, 720, 
	720, 720, 720, 720, 720, 720, 720, 720, 
	720, 720, 720, 720, 720, 720, 720, 104, 
	720, 720, 720, 720, 720, 720, 720, 720, 
	720, 720, 720, 720, 720, 720, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	105, 720, 720, 720, 720, 104, 720, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 720, 720, 720, 720, 103, 720, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 720, 720, 720, 720, 720, 103, 717, 
	721, 717, 717, 717, 721, 721, 721, 721, 
	721, 721, 721, 721, 721, 721, 721, 721, 
	721, 721, 721, 721, 721, 721, 717, 721, 
	722, 723, 724, 725, 726, 720, 727, 729, 
	730, 730, 730, 729, 730, 730, 730, 730, 
	731, 732, 731, 731, 731, 730, 730, 730, 
	730, 730, 730, 730, 730, 730, 730, 730, 
	730, 729, 730, 730, 730, 730, 730, 731, 
	733, 730, 734, 730, 735, 736, 730, 730, 
	730, 737, 738, 730, 738, 730, 735, 730, 
	730, 730, 730, 730, 730, 730, 730, 730, 
	730, 730, 730, 739, 740, 741, 730, 730, 
	742, 742, 742, 742, 742, 742, 742, 742, 
	742, 742, 742, 742, 742, 742, 742, 742, 
	742, 742, 742, 742, 742, 742, 742, 742, 
	742, 742, 743, 744, 730, 735, 728, 735, 
	728, 728, 728, 728, 728, 728, 728, 728, 
	728, 728, 728, 728, 728, 728, 728, 728, 
	728, 728, 728, 728, 728, 728, 728, 728, 
	728, 728, 730, 745, 730, 738, 730, 728, 
	746, 746, 746, 746, 746, 746, 746, 746, 
	746, 746, 746, 746, 746, 746, 746, 746, 
	746, 746, 746, 746, 746, 746, 746, 746, 
	746, 746, 746, 746, 746, 746, 746, 746, 
	746, 747, 746, 746, 746, 746, 746, 746, 
	746, 746, 746, 746, 746, 746, 746, 746, 
	728, 728, 728, 728, 728, 728, 728, 728, 
	728, 728, 746, 746, 746, 746, 746, 747, 
	746, 728, 728, 728, 728, 728, 728, 728, 
	728, 728, 728, 728, 728, 728, 728, 728, 
	728, 728, 728, 728, 728, 728, 728, 728, 
	728, 728, 728, 746, 746, 746, 746, 728, 
	746, 728, 728, 728, 728, 728, 728, 728, 
	728, 728, 728, 728, 728, 728, 728, 728, 
	728, 728, 728, 728, 728, 728, 728, 728, 
	728, 728, 728, 746, 746, 746, 746, 746, 
	728, 749, 748, 750, 731, 751, 731, 731, 
	731, 751, 751, 751, 751, 751, 751, 751, 
	751, 751, 751, 751, 751, 751, 751, 751, 
	751, 751, 751, 731, 751, 752, 735, 753, 
	753, 735, 753, 753, 753, 753, 753, 753, 
	753, 753, 753, 753, 753, 753, 753, 753, 
	753, 753, 753, 753, 753, 753, 753, 753, 
	753, 753, 753, 753, 753, 753, 753, 753, 
	753, 753, 753, 753, 753, 753, 753, 753, 
	753, 753, 753, 753, 753, 753, 753, 753, 
	753, 753, 753, 753, 753, 753, 753, 753, 
	753, 753, 753, 753, 753, 753, 753, 735, 
	753, 754, 755, 756, 757, 735, 753, 735, 
	753, 735, 753, 735, 758, 753, 735, 753, 
	760, 735, 759, 759, 759, 759, 759, 759, 
	759, 759, 759, 759, 759, 759, 759, 759, 
	759, 759, 759, 759, 759, 759, 759, 759, 
	759, 759, 759, 759, 759, 759, 759, 759, 
	759, 759, 759, 759, 759, 759, 759, 759, 
	759, 759, 759, 759, 759, 759, 759, 759, 
	759, 759, 759, 759, 759, 759, 759, 759, 
	759, 759, 759, 759, 759, 759, 759, 759, 
	759, 735, 759, 735, 753, 735, 735, 753, 
	761, 761, 761, 761, 761, 761, 761, 761, 
	761, 761, 761, 761, 761, 761, 761, 761, 
	761, 761, 761, 761, 761, 761, 761, 761, 
	761, 761, 761, 761, 761, 761, 761, 761, 
	761, 747, 761, 761, 761, 761, 761, 761, 
	761, 761, 761, 761, 761, 761, 761, 761, 
	742, 742, 742, 742, 742, 742, 742, 742, 
	742, 742, 761, 761, 761, 761, 761, 747, 
	761, 742, 742, 742, 742, 742, 742, 742, 
	742, 742, 742, 742, 742, 742, 742, 742, 
	742, 742, 742, 742, 742, 742, 742, 742, 
	742, 742, 742, 761, 761, 761, 761, 742, 
	761, 742, 742, 742, 742, 742, 742, 742, 
	742, 742, 742, 742, 742, 742, 742, 742, 
	742, 742, 742, 742, 742, 742, 742, 742, 
	742, 742, 742, 761, 761, 761, 761, 761, 
	742, 760, 759, 732, 759, 735, 753, 763, 
	762, 762, 762, 763, 762, 762, 762, 762, 
	764, 765, 764, 764, 764, 762, 762, 762, 
	762, 762, 762, 762, 762, 762, 762, 762, 
	762, 763, 762, 762, 762, 762, 762, 764, 
	762, 762, 766, 762, 113, 767, 762, 768, 
	762, 769, 113, 144, 770, 146, 113, 762, 
	762, 762, 762, 762, 762, 762, 762, 762, 
	762, 771, 762, 772, 144, 773, 774, 762, 
	762, 762, 762, 762, 762, 762, 762, 762, 
	762, 762, 762, 762, 762, 762, 762, 762, 
	762, 762, 762, 762, 762, 762, 762, 762, 
	762, 762, 144, 775, 144, 113, 762, 762, 
	762, 762, 762, 762, 762, 762, 762, 762, 
	776, 762, 762, 762, 762, 762, 762, 762, 
	762, 777, 762, 762, 778, 762, 779, 762, 
	762, 762, 157, 158, 762, 113, 762, 780, 
	780, 780, 780, 780, 780, 780, 780, 780, 
	764, 780, 764, 764, 764, 780, 780, 780, 
	780, 780, 780, 780, 780, 780, 780, 780, 
	780, 780, 780, 780, 780, 780, 780, 764, 
	780, 780, 780, 780, 139, 140, 780, 141, 
	780, 142, 143, 144, 145, 146, 139, 780, 
	780, 780, 780, 780, 780, 780, 780, 780, 
	780, 147, 780, 148, 144, 149, 150, 780, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 151, 152, 144, 113, 108, 780, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	153, 108, 108, 108, 108, 108, 108, 108, 
	108, 154, 108, 108, 155, 108, 156, 108, 
	108, 108, 157, 158, 780, 113, 780, 108, 
	781, 782, 782, 782, 781, 782, 782, 782, 
	782, 144, 783, 144, 144, 144, 782, 782, 
	782, 782, 782, 782, 782, 782, 782, 782, 
	782, 782, 781, 782, 782, 782, 782, 782, 
	144, 782, 782, 782, 782, 782, 782, 782, 
	782, 782, 782, 782, 782, 782, 782, 782, 
	782, 782, 782, 782, 782, 782, 782, 782, 
	782, 782, 782, 782, 782, 144, 782, 144, 
	783, 144, 144, 144, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 144, 107, 
	107, 107, 107, 107, 113, 107, 107, 107, 
	107, 107, 107, 107, 144, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 144, 107, 144, 783, 144, 
	144, 144, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 144, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 144, 107, 784, 144, 783, 144, 144, 
	144, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 144, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 786, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	144, 785, 144, 783, 144, 144, 144, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 144, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 144, 144, 
	107, 787, 781, 144, 781, 789, 788, 791, 
	792, 791, 791, 791, 790, 790, 790, 790, 
	790, 790, 790, 790, 790, 790, 790, 790, 
	790, 790, 790, 790, 790, 790, 791, 790, 
	793, 781, 781, 781, 781, 781, 781, 781, 
	781, 781, 781, 781, 781, 781, 781, 781, 
	781, 781, 781, 781, 781, 781, 781, 781, 
	781, 781, 781, 781, 781, 781, 781, 781, 
	781, 781, 109, 781, 781, 781, 781, 781, 
	781, 781, 781, 781, 781, 781, 781, 781, 
	781, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 110, 781, 781, 781, 781, 
	109, 781, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 781, 781, 781, 781, 
	108, 781, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 781, 781, 781, 781, 
	781, 108, 794, 144, 783, 144, 144, 144, 
	781, 781, 781, 781, 781, 781, 781, 781, 
	781, 781, 781, 781, 781, 781, 781, 781, 
	781, 781, 144, 781, 781, 781, 781, 781, 
	781, 781, 781, 781, 781, 781, 781, 781, 
	781, 781, 781, 781, 781, 781, 781, 781, 
	781, 781, 781, 781, 781, 781, 781, 144, 
	781, 781, 781, 781, 781, 781, 781, 781, 
	781, 781, 781, 781, 781, 781, 781, 781, 
	781, 781, 781, 781, 781, 781, 781, 781, 
	781, 781, 781, 781, 781, 781, 781, 781, 
	781, 781, 781, 781, 781, 781, 781, 781, 
	781, 781, 781, 781, 781, 781, 781, 781, 
	781, 781, 781, 781, 781, 781, 781, 781, 
	781, 781, 781, 781, 781, 781, 113, 781, 
	795, 796, 797, 798, 799, 800, 144, 783, 
	144, 144, 144, 781, 781, 781, 781, 781, 
	781, 781, 781, 781, 781, 781, 781, 781, 
	781, 781, 781, 781, 781, 144, 781, 781, 
	781, 781, 781, 781, 781, 781, 781, 113, 
	781, 781, 781, 781, 781, 781, 781, 781, 
	781, 781, 781, 781, 781, 781, 781, 781, 
	781, 781, 144, 781, 144, 788, 113, 801, 
	113, 801, 802, 803, 802, 802, 802, 790, 
	790, 790, 790, 790, 790, 790, 790, 790, 
	790, 790, 790, 790, 790, 790, 790, 790, 
	790, 802, 790, 804, 801, 805, 805, 805, 
	805, 805, 805, 805, 805, 805, 116, 805, 
	116, 116, 116, 805, 805, 805, 805, 805, 
	805, 805, 805, 805, 805, 805, 805, 805, 
	805, 805, 805, 805, 805, 116, 805, 805, 
	805, 805, 117, 118, 805, 119, 805, 120, 
	121, 122, 123, 124, 117, 805, 805, 805, 
	805, 805, 805, 805, 805, 805, 805, 125, 
	805, 126, 122, 127, 128, 805, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	129, 130, 122, 131, 115, 805, 115, 115, 
	115, 115, 115, 115, 115, 115, 132, 115, 
	115, 115, 115, 115, 115, 115, 115, 133, 
	115, 115, 134, 115, 135, 115, 115, 115, 
	136, 137, 805, 131, 805, 115, 144, 801, 
	806, 801, 807, 801, 808, 801, 809, 183, 
	183, 183, 809, 183, 183, 183, 183, 810, 
	183, 810, 810, 810, 183, 183, 183, 183, 
	183, 183, 183, 183, 183, 183, 183, 183, 
	809, 183, 183, 183, 183, 183, 810, 183, 
	183, 183, 183, 183, 183, 183, 183, 183, 
	183, 183, 183, 183, 183, 183, 183, 183, 
	183, 183, 183, 183, 183, 183, 183, 183, 
	183, 183, 183, 183, 183, 183, 183, 185, 
	185, 185, 185, 185, 185, 185, 185, 185, 
	185, 185, 185, 185, 185, 185, 185, 185, 
	185, 185, 185, 185, 185, 185, 185, 185, 
	185, 183, 811, 183, 183, 185, 183, 185, 
	185, 185, 189, 185, 185, 185, 185, 185, 
	185, 185, 185, 185, 185, 185, 185, 185, 
	185, 185, 185, 185, 185, 185, 185, 185, 
	185, 183, 183, 183, 183, 183, 185, 182, 
	182, 182, 182, 182, 182, 182, 182, 182, 
	182, 182, 182, 182, 182, 182, 182, 182, 
	182, 182, 182, 182, 182, 182, 182, 182, 
	182, 182, 182, 182, 182, 182, 182, 182, 
	812, 182, 182, 182, 182, 182, 182, 182, 
	182, 182, 182, 182, 182, 182, 182, 185, 
	185, 185, 185, 185, 185, 185, 185, 185, 
	185, 183, 182, 182, 182, 182, 812, 182, 
	185, 185, 185, 185, 185, 185, 185, 185, 
	185, 185, 185, 185, 185, 185, 185, 185, 
	185, 185, 185, 185, 185, 185, 185, 185, 
	185, 185, 182, 182, 182, 182, 185, 182, 
	185, 185, 185, 185, 185, 185, 185, 185, 
	185, 185, 185, 185, 185, 185, 185, 185, 
	185, 185, 185, 185, 185, 185, 185, 185, 
	185, 185, 182, 182, 182, 182, 182, 185, 
	813, 813, 813, 813, 813, 813, 813, 813, 
	813, 186, 813, 186, 186, 186, 813, 813, 
	813, 813, 813, 813, 813, 813, 813, 813, 
	813, 813, 813, 813, 813, 813, 813, 813, 
	186, 813, 813, 813, 813, 813, 813, 813, 
	187, 813, 813, 813, 813, 813, 813, 813, 
	813, 813, 813, 813, 813, 813, 813, 813, 
	813, 813, 813, 813, 813, 813, 813, 813, 
	813, 185, 185, 185, 185, 185, 185, 185, 
	185, 185, 185, 185, 185, 185, 185, 185, 
	185, 185, 185, 185, 185, 185, 185, 185, 
	185, 185, 185, 813, 188, 813, 813, 185, 
	813, 185, 185, 185, 189, 185, 185, 185, 
	185, 185, 185, 185, 185, 185, 185, 185, 
	185, 185, 185, 185, 185, 185, 185, 185, 
	185, 185, 185, 813, 813, 813, 813, 813, 
	185, 814, 813, 813, 813, 813, 813, 813, 
	813, 813, 813, 813, 813, 813, 813, 813, 
	813, 813, 813, 813, 813, 813, 813, 813, 
	813, 813, 813, 813, 813, 813, 813, 813, 
	813, 813, 813, 812, 813, 813, 813, 813, 
	813, 813, 813, 813, 813, 813, 813, 813, 
	813, 813, 185, 185, 185, 185, 185, 185, 
	185, 185, 185, 185, 183, 813, 813, 813, 
	813, 812, 813, 185, 185, 185, 185, 185, 
	185, 185, 185, 185, 185, 185, 185, 185, 
	185, 185, 185, 185, 185, 185, 185, 185, 
	185, 185, 185, 185, 185, 813, 813, 813, 
	813, 185, 813, 185, 185, 185, 185, 185, 
	185, 185, 185, 185, 185, 185, 185, 185, 
	185, 815, 185, 185, 185, 185, 185, 185, 
	185, 185, 185, 185, 185, 813, 813, 813, 
	813, 813, 185, 190, 813, 817, 816, 816, 
	816, 817, 816, 816, 816, 816, 818, 816, 
	818, 818, 818, 816, 816, 816, 816, 816, 
	816, 816, 816, 816, 816, 816, 816, 817, 
	816, 816, 816, 816, 816, 818, 816, 816, 
	819, 816, 816, 816, 816, 816, 816, 816, 
	816, 816, 816, 816, 816, 816, 816, 816, 
	816, 816, 816, 816, 816, 816, 816, 816, 
	816, 816, 816, 816, 816, 816, 816, 816, 
	816, 816, 816, 816, 816, 816, 816, 816, 
	816, 816, 816, 816, 816, 816, 816, 816, 
	816, 816, 816, 816, 816, 816, 816, 816, 
	816, 820, 816, 816, 816, 816, 816, 816, 
	816, 821, 816, 816, 816, 816, 816, 816, 
	816, 816, 816, 816, 816, 816, 816, 816, 
	816, 816, 816, 816, 816, 816, 816, 816, 
	822, 816, 818, 823, 818, 818, 818, 823, 
	823, 823, 823, 823, 823, 823, 823, 823, 
	823, 823, 823, 823, 823, 823, 823, 823, 
	823, 818, 823, 824, 825, 826, 827, 829, 
	828, 830, 831, 828, 832, 834, 835, 835, 
	835, 834, 835, 835, 835, 835, 836, 837, 
	836, 836, 836, 835, 835, 835, 835, 835, 
	835, 835, 835, 835, 835, 835, 835, 834, 
	835, 835, 835, 835, 835, 836, 835, 835, 
	838, 835, 835, 835, 835, 835, 835, 835, 
	835, 835, 835, 835, 835, 835, 835, 835, 
	835, 835, 835, 835, 835, 835, 835, 835, 
	835, 835, 835, 835, 835, 835, 833, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	835, 839, 835, 835, 833, 835, 833, 833, 
	833, 833, 833, 833, 833, 833, 840, 833, 
	833, 833, 833, 833, 833, 833, 833, 841, 
	833, 833, 842, 833, 843, 833, 833, 833, 
	835, 835, 835, 835, 835, 833, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 833, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	844, 844, 844, 844, 844, 844, 844, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 844, 844, 844, 844, 833, 844, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 844, 844, 844, 844, 844, 833, 836, 
	845, 836, 836, 836, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 836, 845, 
	846, 847, 848, 849, 850, 852, 851, 853, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 854, 854, 854, 854, 854, 854, 
	854, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 854, 854, 854, 854, 833, 
	854, 833, 833, 833, 833, 833, 855, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 854, 854, 854, 854, 854, 
	833, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 854, 854, 854, 854, 854, 
	854, 854, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 833, 854, 854, 854, 854, 
	833, 854, 833, 833, 833, 833, 856, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 833, 854, 854, 854, 854, 
	854, 833, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 833, 854, 854, 854, 854, 
	854, 854, 854, 833, 833, 833, 833, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 833, 833, 854, 854, 854, 
	854, 833, 854, 833, 833, 833, 833, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 833, 833, 857, 833, 833, 
	833, 833, 833, 833, 833, 854, 854, 854, 
	854, 854, 833, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 833, 833, 833, 833, 833, 
	833, 833, 833, 833, 833, 854, 854, 854, 
	854, 854, 854, 854, 833, 833, 833, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 833, 833, 833, 854, 854, 
	854, 854, 833, 854, 833, 833, 858, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 833, 833, 833, 854, 854, 
	854, 854, 854, 833, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 833, 833, 833, 833, 
	833, 833, 833, 833, 833, 833, 854, 854, 
	854, 854, 854, 854, 854, 833, 833, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 833, 833, 833, 833, 854, 
	854, 854, 854, 833, 854, 833, 833, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 859, 833, 833, 833, 833, 833, 854, 
	854, 854, 854, 854, 833, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 833, 833, 833, 
	833, 833, 833, 833, 833, 833, 833, 854, 
	854, 854, 854, 854, 854, 854, 833, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	854, 854, 854, 854, 833, 854, 833, 833, 
	833, 833, 855, 833, 833, 833, 833, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	854, 854, 854, 854, 854, 833, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 833, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	854, 854, 854, 854, 854, 854, 854, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 854, 854, 854, 854, 833, 854, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 833, 860, 833, 833, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 854, 854, 854, 854, 854, 833, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 854, 854, 854, 854, 854, 854, 854, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 854, 854, 854, 854, 833, 854, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 861, 833, 833, 833, 833, 
	833, 833, 833, 862, 833, 833, 833, 833, 
	833, 833, 854, 854, 854, 854, 854, 833, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 854, 854, 854, 854, 854, 854, 
	854, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 854, 854, 854, 854, 833, 
	854, 833, 833, 833, 833, 863, 833, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 854, 854, 854, 854, 854, 
	833, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 854, 854, 854, 854, 854, 
	854, 854, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 833, 854, 854, 854, 854, 
	833, 854, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 833, 864, 833, 833, 833, 
	833, 833, 833, 833, 854, 854, 854, 854, 
	854, 833, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 833, 854, 854, 854, 854, 
	854, 854, 854, 833, 833, 833, 833, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 833, 833, 854, 854, 854, 
	854, 833, 854, 833, 833, 833, 833, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 833, 833, 855, 833, 833, 
	833, 833, 833, 833, 833, 854, 854, 854, 
	854, 854, 833, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 833, 833, 833, 833, 833, 
	833, 833, 833, 833, 833, 854, 854, 854, 
	854, 854, 854, 854, 833, 833, 833, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 833, 833, 833, 854, 854, 
	854, 854, 833, 854, 833, 833, 833, 833, 
	833, 833, 833, 833, 865, 833, 833, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 833, 833, 833, 854, 854, 
	854, 854, 854, 833, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 833, 833, 833, 833, 
	833, 833, 833, 833, 833, 833, 854, 854, 
	854, 854, 854, 854, 854, 833, 833, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 833, 833, 833, 833, 854, 
	854, 854, 854, 833, 854, 833, 833, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	855, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 833, 833, 833, 833, 854, 
	854, 854, 854, 854, 833, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 833, 833, 833, 
	833, 833, 833, 833, 833, 833, 833, 854, 
	854, 854, 854, 854, 854, 854, 833, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	854, 854, 854, 854, 833, 854, 833, 833, 
	833, 833, 833, 833, 833, 866, 833, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	854, 854, 854, 854, 854, 833, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 833, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	854, 854, 854, 854, 854, 854, 854, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 854, 854, 854, 854, 833, 854, 833, 
	833, 833, 833, 833, 833, 833, 833, 867, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 854, 854, 854, 854, 854, 833, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 854, 
	854, 854, 854, 854, 854, 854, 854, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 854, 854, 854, 854, 854, 854, 854, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 854, 854, 854, 854, 833, 854, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 833, 859, 833, 833, 833, 833, 
	833, 833, 833, 833, 833, 833, 833, 833, 
	833, 833, 854, 854, 854, 854, 854, 833, 
	869, 215, 215, 215, 869, 215, 215, 215, 
	215, 870, 871, 870, 870, 870, 215, 215, 
	215, 215, 215, 215, 215, 215, 215, 215, 
	215, 215, 869, 215, 215, 215, 215, 215, 
	870, 872, 215, 873, 215, 874, 875, 215, 
	876, 215, 877, 878, 215, 879, 880, 881, 
	215, 215, 215, 215, 215, 215, 215, 215, 
	215, 215, 882, 215, 883, 884, 885, 886, 
	215, 887, 888, 887, 887, 889, 887, 887, 
	887, 887, 887, 887, 887, 887, 887, 887, 
	887, 887, 887, 887, 887, 887, 887, 887, 
	887, 887, 887, 890, 891, 215, 892, 893, 
	215, 894, 895, 896, 897, 898, 899, 868, 
	868, 900, 868, 868, 868, 901, 902, 903, 
	868, 868, 904, 905, 906, 907, 868, 908, 
	868, 909, 868, 910, 911, 215, 892, 215, 
	868, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 913, 912, 913, 913, 913, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 913, 287, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 288, 912, 912, 289, 912, 
	287, 912, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 912, 914, 912, 912, 
	868, 912, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 912, 912, 912, 912, 
	912, 868, 916, 915, 915, 917, 915, 918, 
	920, 921, 919, 919, 919, 919, 919, 919, 
	919, 919, 919, 919, 919, 919, 919, 919, 
	919, 919, 919, 919, 919, 919, 919, 919, 
	919, 919, 919, 919, 919, 919, 919, 919, 
	919, 919, 919, 919, 919, 919, 919, 919, 
	919, 919, 919, 919, 919, 919, 919, 919, 
	919, 919, 919, 919, 919, 919, 919, 919, 
	919, 919, 919, 919, 919, 919, 919, 919, 
	919, 922, 919, 924, 923, 925, 926, 927, 
	870, 928, 870, 870, 870, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 928, 
	928, 928, 928, 928, 928, 928, 928, 870, 
	928, 930, 929, 932, 933, 932, 932, 932, 
	931, 931, 931, 931, 931, 931, 931, 931, 
	931, 931, 931, 931, 931, 931, 931, 931, 
	931, 931, 932, 931, 215, 934, 934, 934, 
	934, 934, 934, 934, 934, 934, 934, 934, 
	934, 934, 934, 934, 934, 934, 934, 934, 
	934, 934, 934, 934, 934, 934, 934, 934, 
	934, 934, 934, 934, 934, 934, 934, 934, 
	934, 934, 934, 934, 934, 934, 934, 934, 
	934, 934, 934, 934, 934, 934, 934, 934, 
	934, 934, 934, 934, 934, 934, 934, 934, 
	934, 934, 934, 934, 934, 215, 934, 935, 
	936, 937, 938, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 940, 940, 940, 
	940, 940, 940, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 940, 942, 213, 
	213, 213, 942, 213, 213, 213, 213, 213, 
	213, 213, 213, 213, 213, 213, 213, 213, 
	213, 213, 213, 213, 213, 213, 213, 213, 
	942, 213, 213, 213, 213, 213, 213, 213, 
	213, 213, 213, 213, 213, 213, 213, 213, 
	213, 213, 213, 213, 213, 213, 213, 213, 
	213, 213, 213, 213, 213, 213, 213, 213, 
	213, 213, 213, 213, 213, 213, 213, 214, 
	214, 214, 214, 214, 214, 214, 214, 214, 
	214, 214, 214, 214, 214, 214, 214, 214, 
	214, 214, 214, 214, 214, 214, 214, 214, 
	214, 213, 213, 213, 213, 213, 213, 214, 
	214, 214, 214, 214, 214, 214, 214, 214, 
	214, 214, 214, 214, 214, 214, 214, 214, 
	214, 214, 214, 214, 214, 214, 214, 214, 
	214, 213, 944, 943, 943, 943, 943, 943, 
	943, 943, 943, 943, 943, 943, 943, 943, 
	943, 943, 943, 943, 943, 943, 943, 943, 
	943, 215, 943, 945, 947, 946, 946, 946, 
	946, 946, 946, 946, 946, 946, 946, 946, 
	946, 946, 946, 946, 946, 946, 946, 215, 
	946, 215, 204, 216, 217, 216, 216, 216, 
	943, 943, 943, 943, 943, 943, 943, 943, 
	943, 943, 943, 943, 943, 943, 943, 943, 
	943, 943, 216, 943, 943, 218, 943, 943, 
	943, 943, 943, 943, 943, 943, 943, 943, 
	943, 943, 219, 219, 219, 219, 219, 219, 
	219, 219, 219, 219, 943, 943, 943, 215, 
	943, 943, 943, 943, 943, 943, 943, 943, 
	943, 943, 943, 943, 943, 943, 943, 943, 
	943, 943, 943, 943, 943, 943, 943, 943, 
	943, 943, 943, 943, 943, 943, 220, 943, 
	233, 234, 233, 233, 233, 232, 232, 232, 
	232, 232, 232, 232, 232, 232, 232, 232, 
	232, 232, 232, 232, 232, 232, 232, 233, 
	232, 232, 235, 232, 232, 232, 232, 232, 
	232, 232, 232, 232, 232, 232, 232, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 232, 232, 232, 232, 232, 232, 232, 
	232, 232, 232, 232, 232, 232, 232, 232, 
	232, 232, 232, 232, 232, 232, 232, 232, 
	232, 232, 232, 232, 232, 232, 232, 232, 
	232, 232, 232, 237, 232, 216, 217, 216, 
	216, 216, 943, 943, 943, 943, 943, 943, 
	943, 943, 943, 943, 943, 943, 943, 943, 
	943, 943, 943, 943, 216, 943, 943, 218, 
	943, 943, 943, 943, 943, 943, 943, 943, 
	943, 943, 943, 943, 219, 219, 219, 219, 
	219, 219, 219, 219, 219, 219, 943, 943, 
	943, 215, 215, 943, 943, 943, 943, 943, 
	943, 943, 943, 943, 943, 943, 943, 943, 
	943, 943, 943, 943, 943, 943, 943, 943, 
	943, 943, 943, 943, 943, 943, 943, 943, 
	220, 943, 949, 934, 951, 950, 934, 952, 
	952, 952, 934, 952, 952, 952, 952, 952, 
	952, 952, 952, 952, 952, 952, 952, 952, 
	952, 952, 952, 952, 952, 952, 952, 952, 
	934, 952, 934, 934, 934, 934, 934, 934, 
	934, 934, 934, 934, 934, 934, 934, 934, 
	934, 934, 934, 934, 934, 934, 934, 934, 
	934, 934, 934, 934, 934, 934, 934, 934, 
	934, 934, 934, 954, 955, 934, 956, 241, 
	957, 955, 934, 934, 958, 959, 934, 959, 
	934, 241, 934, 934, 934, 934, 934, 934, 
	934, 934, 934, 934, 960, 934, 961, 962, 
	963, 934, 964, 953, 953, 953, 953, 953, 
	953, 953, 953, 953, 953, 953, 953, 953, 
	953, 953, 953, 953, 953, 953, 953, 953, 
	953, 953, 953, 953, 953, 965, 934, 934, 
	241, 953, 241, 953, 953, 953, 953, 953, 
	953, 953, 953, 953, 953, 953, 953, 953, 
	953, 953, 953, 953, 953, 953, 953, 953, 
	953, 953, 953, 953, 953, 934, 966, 934, 
	967, 934, 953, 968, 968, 968, 968, 968, 
	968, 968, 968, 968, 968, 968, 968, 968, 
	968, 968, 968, 968, 968, 968, 968, 968, 
	968, 968, 968, 968, 968, 968, 968, 968, 
	968, 968, 968, 968, 969, 968, 968, 968, 
	968, 968, 968, 968, 968, 968, 968, 968, 
	968, 968, 968, 953, 953, 953, 953, 953, 
	953, 953, 953, 953, 953, 968, 968, 968, 
	970, 968, 969, 968, 953, 953, 953, 953, 
	953, 953, 953, 953, 953, 953, 953, 953, 
	953, 953, 953, 953, 953, 953, 953, 953, 
	953, 953, 953, 953, 953, 953, 968, 968, 
	968, 968, 953, 968, 953, 953, 953, 953, 
	953, 953, 953, 953, 953, 953, 953, 953, 
	953, 953, 953, 953, 953, 953, 953, 953, 
	953, 953, 953, 953, 953, 953, 968, 968, 
	968, 968, 968, 953, 972, 971, 973, 975, 
	976, 974, 974, 974, 974, 974, 974, 974, 
	974, 974, 974, 974, 974, 974, 974, 974, 
	974, 974, 974, 974, 974, 974, 974, 974, 
	974, 974, 974, 974, 974, 974, 974, 974, 
	974, 974, 974, 974, 974, 974, 974, 974, 
	974, 974, 974, 974, 974, 974, 974, 974, 
	974, 974, 974, 974, 974, 974, 974, 974, 
	974, 974, 974, 974, 974, 974, 974, 974, 
	977, 974, 979, 980, 978, 981, 982, 983, 
	984, 241, 968, 968, 985, 968, 968, 968, 
	968, 968, 968, 968, 968, 968, 968, 968, 
	968, 968, 968, 968, 968, 968, 968, 968, 
	968, 968, 968, 968, 968, 968, 968, 968, 
	968, 968, 968, 968, 968, 968, 968, 968, 
	968, 968, 968, 968, 968, 968, 968, 968, 
	968, 968, 968, 968, 968, 968, 968, 968, 
	968, 968, 968, 968, 968, 968, 968, 968, 
	968, 968, 241, 968, 968, 968, 968, 968, 
	968, 968, 968, 968, 968, 968, 968, 968, 
	968, 968, 968, 968, 968, 968, 968, 968, 
	968, 968, 968, 968, 968, 968, 968, 968, 
	968, 968, 968, 968, 968, 968, 968, 968, 
	968, 968, 968, 968, 968, 968, 968, 968, 
	968, 968, 968, 968, 240, 240, 240, 240, 
	240, 240, 240, 240, 240, 240, 968, 968, 
	968, 968, 968, 968, 968, 240, 240, 240, 
	240, 240, 240, 240, 240, 240, 240, 240, 
	240, 240, 240, 240, 240, 240, 240, 240, 
	240, 240, 240, 240, 240, 240, 240, 968, 
	968, 968, 968, 240, 968, 240, 240, 240, 
	240, 240, 240, 240, 240, 240, 240, 240, 
	240, 240, 240, 240, 240, 240, 240, 240, 
	240, 240, 240, 240, 240, 240, 240, 968, 
	968, 968, 968, 968, 240, 243, 243, 243, 
	243, 243, 243, 243, 243, 243, 243, 968, 
	986, 968, 241, 968, 241, 968, 241, 987, 
	968, 241, 968, 241, 968, 241, 241, 968, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	988, 988, 988, 988, 988, 988, 988, 988, 
	990, 990, 990, 990, 990, 990, 990, 990, 
	990, 990, 988, 988, 988, 988, 988, 988, 
	991, 989, 989, 989, 989, 989, 989, 989, 
	989, 989, 989, 989, 989, 989, 989, 989, 
	989, 989, 989, 989, 989, 989, 989, 989, 
	989, 989, 989, 988, 988, 988, 988, 989, 
	988, 989, 989, 989, 989, 989, 989, 989, 
	989, 989, 989, 989, 989, 989, 989, 989, 
	989, 989, 989, 989, 989, 989, 989, 989, 
	989, 989, 989, 988, 988, 988, 988, 988, 
	989, 993, 993, 993, 993, 993, 993, 993, 
	993, 993, 993, 992, 994, 994, 994, 994, 
	994, 994, 994, 994, 994, 994, 994, 994, 
	994, 994, 994, 994, 994, 994, 994, 994, 
	994, 994, 994, 994, 994, 994, 994, 994, 
	994, 994, 994, 994, 994, 994, 994, 994, 
	994, 994, 994, 994, 994, 994, 994, 994, 
	994, 994, 994, 994, 996, 996, 996, 996, 
	996, 996, 996, 996, 996, 996, 994, 994, 
	994, 994, 994, 994, 994, 995, 995, 995, 
	995, 995, 995, 995, 995, 995, 995, 995, 
	995, 995, 995, 995, 995, 995, 995, 995, 
	995, 995, 995, 995, 995, 995, 995, 994, 
	994, 994, 994, 995, 994, 995, 995, 995, 
	995, 995, 995, 995, 995, 995, 995, 995, 
	995, 995, 995, 995, 995, 995, 995, 995, 
	995, 995, 995, 995, 995, 995, 995, 994, 
	994, 994, 994, 994, 995, 986, 968, 985, 
	968, 997, 998, 934, 999, 256, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 257, 246, 258, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	247, 247, 247, 247, 257, 247, 257, 260, 
	215, 934, 892, 215, 934, 934, 934, 934, 
	934, 934, 934, 934, 934, 934, 934, 934, 
	934, 934, 934, 934, 934, 934, 934, 934, 
	934, 934, 934, 934, 934, 934, 934, 934, 
	934, 934, 934, 934, 934, 934, 934, 934, 
	934, 934, 934, 934, 934, 934, 934, 934, 
	934, 934, 934, 934, 934, 934, 934, 934, 
	934, 934, 934, 934, 934, 934, 934, 934, 
	934, 934, 934, 215, 934, 215, 944, 934, 
	1003, 1002, 1002, 1002, 1003, 1002, 1002, 1002, 
	1002, 1004, 1005, 1004, 1004, 1004, 1002, 1002, 
	1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002, 
	1002, 1002, 1003, 1002, 1002, 1002, 1002, 1002, 
	1004, 1002, 1002, 1002, 1002, 1002, 1002, 1002, 
	1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002, 
	1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002, 
	1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002, 
	1002, 1006, 1006, 1006, 1006, 1006, 1006, 1006, 
	1006, 1006, 1006, 1006, 1006, 1006, 1006, 1006, 
	1006, 1006, 1006, 1006, 1006, 1006, 1006, 1006, 
	1006, 1006, 1006, 1002, 1007, 1002, 1002, 1006, 
	1002, 1006, 1006, 1006, 1006, 1006, 1006, 1006, 
	1006, 1006, 1006, 1006, 1006, 1006, 1006, 1006, 
	1006, 1006, 1006, 1006, 1006, 1006, 1006, 1006, 
	1006, 1006, 1006, 1002, 1008, 1008, 1008, 1008, 
	1008, 1008, 1008, 1008, 1008, 1008, 1008, 1008, 
	1008, 1008, 1008, 1008, 1008, 1008, 1008, 1008, 
	1008, 1008, 1008, 1008, 1008, 1008, 1008, 1008, 
	1008, 1008, 1008, 1008, 1008, 1008, 1008, 1008, 
	1008, 1008, 1008, 1008, 1008, 1008, 1008, 1008, 
	1008, 1008, 1008, 1008, 1008, 1008, 1008, 1008, 
	1008, 1008, 1008, 1008, 1008, 1008, 1008, 1008, 
	1008, 1008, 1008, 1008, 1008, 1008, 1009, 1009, 
	1009, 1009, 1009, 1009, 1009, 1009, 1009, 1009, 
	1009, 1009, 1009, 1009, 1009, 1009, 1009, 1009, 
	1009, 1009, 1009, 1009, 1009, 1009, 1009, 1009, 
	1008, 1008, 1008, 1008, 1009, 1008, 1009, 1009, 
	1009, 1009, 1009, 1009, 1009, 1009, 1009, 1009, 
	1009, 1009, 1009, 1009, 1009, 1009, 1009, 1009, 
	1009, 1009, 1009, 1009, 1009, 1009, 1009, 1009, 
	1008, 1008, 1008, 1008, 1008, 1009, 1010, 1010, 
	1010, 1010, 1010, 1010, 1010, 1010, 1010, 1010, 
	1010, 1010, 1010, 1010, 1010, 1010, 1010, 1010, 
	1010, 1010, 1010, 1010, 1010, 1010, 1010, 1010, 
	1010, 1010, 1010, 1010, 1010, 1010, 1010, 1010, 
	1010, 1010, 1010, 1010, 1010, 1010, 1010, 1010, 
	1010, 1010, 1010, 1010, 1010, 1010, 1011, 1011, 
	1011, 1011, 1011, 1011, 1011, 1011, 1011, 1011, 
	1010, 1010, 1010, 1010, 1010, 1010, 1010, 1011, 
	1011, 1011, 1011, 1011, 1011, 1011, 1011, 1011, 
	1011, 1011, 1011, 1011, 1011, 1011, 1011, 1011, 
	1011, 1011, 1011, 1011, 1011, 1011, 1011, 1011, 
	1011, 1010, 1010, 1010, 1010, 1011, 1010, 1011, 
	1011, 1011, 1011, 1011, 1011, 1011, 1011, 1011, 
	1011, 1011, 1011, 1011, 1011, 1011, 1011, 1011, 
	1011, 1011, 1011, 1011, 1011, 1011, 1011, 1011, 
	1011, 1010, 1010, 1010, 1010, 1010, 1011, 1014, 
	1013, 1013, 1013, 1014, 1013, 1013, 1013, 1013, 
	1013, 1013, 1013, 1013, 1013, 1013, 1013, 1013, 
	1013, 1013, 1013, 1013, 1013, 1013, 1013, 1013, 
	1013, 1014, 1013, 1013, 1013, 1013, 1013, 1013, 
	1013, 1013, 1013, 1013, 1013, 1013, 1013, 1013, 
	1013, 1013, 1013, 1013, 1013, 1013, 1013, 1015, 
	1015, 1015, 1015, 1015, 1015, 1015, 1015, 1013, 
	1013, 1013, 1013, 1013, 1013, 1013, 1013, 1013, 
	1013, 1013, 1016, 1013, 1013, 1013, 1013, 1013, 
	1013, 1013, 1013, 1013, 1017, 1013, 1013, 1013, 
	1013, 1013, 1013, 1013, 1013, 1013, 1013, 1013, 
	1013, 1013, 1013, 1013, 1013, 1013, 1013, 1013, 
	1013, 1013, 1018, 1013, 1013, 1013, 1013, 1013, 
	1013, 1013, 1013, 1013, 1013, 1013, 1013, 1013, 
	1013, 1013, 1013, 1013, 1019, 1013, 1013, 1020, 
	1013, 1021, 1022, 1024, 1024, 1024, 1024, 1024, 
	1024, 1024, 1024, 1023, 1025, 1025, 1025, 1025, 
	1025, 1025, 1025, 1025, 1023, 1023, 1026, 1026, 
	281, 281, 281, 1026, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 1026, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 282, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 1027, 281, 1028, 1029, 1030, 
	1030, 281, 281, 281, 1030, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 1030, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 282, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 281, 281, 281, 281, 
	281, 281, 281, 281, 1031, 281, 280, 1030, 
	1032, 1033, 1034, 1034, 268, 268, 268, 1034, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 1034, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 269, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 1035, 
	268, 1030, 262, 262, 262, 1030, 262, 262, 
	262, 262, 262, 262, 262, 262, 262, 262, 
	262, 262, 262, 262, 262, 262, 262, 262, 
	262, 262, 262, 1030, 262, 262, 262, 262, 
	262, 262, 262, 262, 262, 262, 262, 262, 
	262, 262, 262, 262, 262, 262, 1036, 262, 
	1026, 268, 268, 268, 1026, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 1026, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 269, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 270, 268, 1026, 1037, 
	1037, 1037, 1026, 1037, 1037, 1037, 1037, 1037, 
	1037, 1037, 1037, 1037, 1037, 1037, 1037, 1037, 
	1037, 1037, 1037, 1037, 1037, 1037, 1037, 1037, 
	1026, 1037, 1037, 1037, 1037, 1037, 1037, 1037, 
	1037, 1037, 1037, 1037, 1037, 1037, 1037, 1037, 
	1037, 1037, 1037, 1037, 1037, 1037, 1037, 1037, 
	1037, 1037, 1037, 1037, 1037, 1037, 1037, 1037, 
	1037, 1037, 1037, 1037, 1037, 1037, 1037, 1037, 
	1037, 1037, 1037, 1037, 1037, 1037, 1037, 1037, 
	1037, 1037, 1037, 1037, 1037, 1037, 1037, 1037, 
	1037, 1037, 1037, 1037, 1037, 1037, 1037, 1037, 
	1037, 1037, 1038, 1037, 1039, 1040, 1040, 1037, 
	1037, 1037, 1040, 1037, 1037, 1037, 1037, 1037, 
	1037, 1037, 1037, 1037, 1037, 1037, 1037, 1037, 
	1037, 1037, 1037, 1037, 1037, 1037, 1037, 1037, 
	1040, 1037, 1037, 1037, 1037, 1037, 1037, 1037, 
	1037, 1037, 1037, 1037, 1037, 1037, 1037, 1037, 
	1037, 1037, 1037, 1037, 1037, 1037, 1037, 1037, 
	1037, 1037, 1037, 1037, 1037, 1037, 1037, 1037, 
	1037, 1037, 1037, 1037, 1037, 1037, 1037, 1037, 
	1037, 1037, 1037, 1037, 1037, 1037, 1037, 1037, 
	1037, 1037, 1037, 1037, 1037, 1037, 1037, 1037, 
	1037, 1037, 1037, 1037, 1037, 1037, 1037, 1037, 
	1037, 1037, 1041, 1037, 1040, 262, 262, 262, 
	1040, 262, 262, 262, 262, 262, 262, 262, 
	262, 262, 262, 262, 262, 262, 262, 262, 
	262, 262, 262, 262, 262, 262, 1040, 262, 
	262, 262, 262, 262, 262, 262, 262, 262, 
	262, 262, 262, 262, 262, 262, 262, 262, 
	262, 1036, 262, 1042, 1040, 1040, 268, 268, 
	268, 1040, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 1040, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 269, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 270, 268, 1044, 1044, 1044, 1044, 1044, 
	1044, 1044, 1044, 1044, 1044, 1043, 1043, 1043, 
	1043, 1043, 1043, 1043, 1044, 1044, 1044, 1044, 
	1044, 1044, 1043, 1043, 1043, 1043, 1043, 1043, 
	1043, 1043, 1043, 1043, 1043, 1043, 1043, 1043, 
	1043, 1043, 1043, 1043, 1043, 1043, 1043, 1043, 
	1043, 1043, 1043, 1043, 1044, 1044, 1044, 1044, 
	1044, 1044, 1043, 1043, 1043, 1043, 1043, 1043, 
	1043, 1043, 1043, 1043, 1043, 1043, 1043, 1043, 
	1043, 1043, 1043, 1043, 1043, 1043, 1045, 1043, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1043, 1043, 1043, 1043, 1043, 1043, 
	1043, 1046, 1046, 1046, 1046, 1046, 1046, 1043, 
	1043, 1043, 1043, 1043, 1043, 1043, 1043, 1043, 
	1043, 1043, 1043, 1043, 1043, 1043, 1043, 1043, 
	1043, 1043, 1043, 1043, 1043, 1043, 1043, 1043, 
	1043, 1046, 1046, 1046, 1046, 1046, 1046, 1043, 
	1047, 1047, 1047, 1047, 1047, 1047, 1047, 1047, 
	1047, 1047, 1043, 1043, 1043, 1043, 1043, 1043, 
	1043, 1047, 1047, 1047, 1047, 1047, 1047, 1043, 
	1043, 1043, 1043, 1043, 1043, 1043, 1043, 1043, 
	1043, 1043, 1043, 1043, 1043, 1043, 1043, 1043, 
	1043, 1043, 1043, 1043, 1043, 1043, 1043, 1043, 
	1043, 1047, 1047, 1047, 1047, 1047, 1047, 1043, 
	1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048, 
	1048, 1048, 1043, 1043, 1043, 1043, 1043, 1043, 
	1043, 1048, 1048, 1048, 1048, 1048, 1048, 1043, 
	1043, 1043, 1043, 1043, 1043, 1043, 1043, 1043, 
	1043, 1043, 1043, 1043, 1043, 1043, 1043, 1043, 
	1043, 1043, 1043, 1043, 1043, 1043, 1043, 1043, 
	1043, 1048, 1048, 1048, 1048, 1048, 1048, 1043, 
	1049, 1052, 1051, 1051, 1051, 1052, 1051, 1051, 
	1051, 1051, 1053, 1051, 1051, 1051, 1051, 1051, 
	1051, 1051, 1051, 1051, 1051, 1051, 1051, 1051, 
	1051, 1051, 1051, 1052, 1051, 1051, 1051, 1051, 
	1051, 1053, 1051, 1051, 1051, 1051, 1051, 1051, 
	1051, 1051, 1051, 1051, 1051, 1051, 1051, 1051, 
	1051, 1054, 1054, 1054, 1054, 1054, 1054, 1054, 
	1054, 1054, 1054, 1051, 1051, 1051, 1051, 1051, 
	1051, 1051, 1054, 1054, 1054, 1054, 1054, 1054, 
	1051, 1051, 1051, 1051, 1051, 1051, 1051, 1051, 
	1051, 1051, 1051, 1051, 1051, 1051, 1051, 1051, 
	1051, 1051, 1051, 1051, 1051, 1051, 1051, 1051, 
	1051, 1051, 1054, 1054, 1054, 1054, 1054, 1054, 
	1051, 1051, 1051, 1051, 1051, 1051, 1051, 1051, 
	1051, 1051, 1051, 1051, 1051, 1051, 1051, 1051, 
	1051, 1051, 1051, 1051, 1051, 1051, 1055, 1051, 
	1052, 1051, 1051, 1051, 1052, 1051, 1051, 1051, 
	1051, 1050, 1051, 1051, 1051, 1051, 1051, 1051, 
	1051, 1051, 1051, 1051, 1051, 1051, 1051, 1051, 
	1051, 1051, 1052, 1051, 1051, 1051, 1051, 1051, 
	1050, 1051, 1051, 1051, 1051, 1051, 1051, 1051, 
	1051, 1051, 1051, 1051, 1051, 1051, 1051, 1051, 
	1056, 1056, 1056, 1056, 1056, 1056, 1056, 1056, 
	1056, 1056, 1051, 1051, 1051, 1051, 1051, 1051, 
	1051, 1056, 1056, 1056, 1056, 1056, 1056, 1051, 
	1051, 1051, 1051, 1051, 1051, 1051, 1051, 1051, 
	1051, 1051, 1051, 1051, 1051, 1051, 1051, 1051, 
	1051, 1051, 1051, 1051, 1051, 1051, 1051, 1051, 
	1051, 1056, 1056, 1056, 1056, 1056, 1056, 1051, 
	1051, 1051, 1051, 1051, 1051, 1051, 1051, 1051, 
	1051, 1051, 1051, 1051, 1051, 1051, 1051, 1051, 
	1051, 1051, 1051, 1051, 1051, 1057, 1051, 1050, 
	1052, 1056, 1056, 1056, 1052, 1056, 1056, 1056, 
	1056, 1050, 1056, 1056, 1056, 1056, 1056, 1056, 
	1056, 1056, 1056, 1056, 1056, 1056, 1056, 1056, 
	1056, 1056, 1052, 1056, 1056, 1056, 1056, 1056, 
	1050, 1056, 1056, 1056, 1056, 1056, 1056, 1056, 
	1056, 1056, 1056, 1056, 1056, 1056, 1056, 1056, 
	1056, 1056, 1056, 1056, 1056, 1056, 1056, 1056, 
	1056, 1056, 1056, 1056, 1056, 1056, 1056, 1056, 
	1056, 1056, 1056, 1056, 1056, 1056, 1056, 1056, 
	1056, 1056, 1056, 1056, 1056, 1056, 1056, 1056, 
	1056, 1056, 1056, 1056, 1056, 1056, 1056, 1056, 
	1056, 1056, 1056, 1056, 1056, 1056, 1056, 1056, 
	1056, 1056, 1056, 1056, 1056, 1056, 1056, 1056, 
	1056, 1056, 1056, 1056, 1056, 1056, 1056, 1056, 
	1056, 1056, 1056, 1056, 1056, 1056, 1056, 1056, 
	1056, 1056, 1056, 1056, 1056, 1050, 1056, 1058, 
	1052, 1059, 1059, 1059, 1052, 1059, 1059, 1059, 
	1059, 1053, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1052, 1059, 1059, 1059, 1059, 1059, 
	1053, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1060, 1060, 1060, 1060, 1060, 1060, 1060, 1060, 
	1060, 1060, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1060, 1060, 1060, 1060, 1060, 1060, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1060, 1060, 1060, 1060, 1060, 1060, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1050, 1059, 1052, 
	1059, 1059, 1059, 1052, 1059, 1059, 1059, 1059, 
	1050, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1052, 1059, 1059, 1059, 1059, 1059, 1050, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1056, 
	1056, 1056, 1056, 1056, 1056, 1056, 1056, 1056, 
	1056, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1056, 1056, 1056, 1056, 1056, 1056, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1056, 1056, 1056, 1056, 1056, 1056, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1052, 1059, 1052, 1059, 
	1059, 1059, 1052, 1059, 1059, 1059, 1059, 1061, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1052, 1059, 1059, 1059, 1059, 1059, 1061, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1062, 1062, 
	1062, 1062, 1062, 1062, 1062, 1062, 1062, 1062, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1062, 
	1062, 1062, 1062, 1062, 1062, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1062, 
	1062, 1062, 1062, 1062, 1062, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1063, 1059, 1052, 1059, 1059, 
	1059, 1052, 1059, 1059, 1059, 1059, 1061, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1052, 
	1059, 1059, 1059, 1059, 1059, 1061, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1060, 1060, 1060, 
	1060, 1060, 1060, 1060, 1060, 1060, 1060, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1060, 1060, 
	1060, 1060, 1060, 1060, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1060, 1060, 
	1060, 1060, 1060, 1060, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1063, 1059, 1064, 1052, 1059, 1059, 
	1059, 1052, 1059, 1059, 1059, 1059, 1061, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1052, 
	1059, 1059, 1059, 1059, 1059, 1061, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1065, 1065, 1065, 
	1065, 1065, 1065, 1065, 1065, 1065, 1065, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1065, 1065, 
	1065, 1065, 1065, 1065, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1065, 1065, 
	1065, 1065, 1065, 1065, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1063, 1059, 1052, 1059, 1059, 1059, 
	1052, 1059, 1059, 1059, 1059, 1061, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1052, 1059, 
	1059, 1059, 1059, 1059, 1061, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1066, 1066, 1066, 1066, 
	1066, 1066, 1066, 1066, 1066, 1066, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1066, 1066, 1066, 
	1066, 1066, 1066, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1066, 1066, 1066, 
	1066, 1066, 1066, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1063, 1059, 1052, 1059, 1059, 1059, 1052, 
	1059, 1059, 1059, 1059, 1061, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1052, 1059, 1059, 
	1059, 1059, 1059, 1061, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1067, 1067, 1067, 1067, 1067, 
	1067, 1067, 1067, 1067, 1067, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1067, 1067, 1067, 1067, 
	1067, 1067, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1067, 1067, 1067, 1067, 
	1067, 1067, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1063, 1059, 1052, 1059, 1059, 1059, 1052, 1059, 
	1059, 1059, 1059, 1061, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1052, 1059, 1059, 1059, 
	1059, 1059, 1061, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1068, 1068, 1068, 1068, 1068, 1068, 
	1068, 1068, 1068, 1068, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1068, 1068, 1068, 1068, 1068, 
	1068, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1068, 1068, 1068, 1068, 1068, 
	1068, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1063, 
	1059, 1052, 1059, 1059, 1059, 1052, 1059, 1059, 
	1059, 1059, 1061, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1052, 1059, 1059, 1059, 1059, 
	1059, 1061, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1069, 1069, 1069, 1069, 1069, 1069, 1069, 
	1069, 1069, 1069, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1069, 1069, 1069, 1069, 1069, 1069, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1069, 1069, 1069, 1069, 1069, 1069, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1063, 1059, 
	1052, 1059, 1059, 1059, 1052, 1059, 1059, 1059, 
	1059, 1050, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1052, 1059, 1059, 1059, 1059, 1059, 
	1050, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1069, 1069, 1069, 1069, 1069, 1069, 1069, 1069, 
	1069, 1069, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1069, 1069, 1069, 1069, 1069, 1069, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1069, 1069, 1069, 1069, 1069, 1069, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1050, 1059, 1052, 
	1059, 1059, 1059, 1052, 1059, 1059, 1059, 1059, 
	1070, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1052, 1059, 1059, 1059, 1059, 1059, 1070, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1071, 
	1071, 1071, 1071, 1071, 1071, 1071, 1071, 1071, 
	1071, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1071, 1071, 1071, 1071, 1071, 1071, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1071, 1071, 1071, 1071, 1071, 1071, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1063, 1059, 1052, 1059, 
	1059, 1059, 1052, 1059, 1059, 1059, 1059, 1070, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1052, 1059, 1059, 1059, 1059, 1059, 1070, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1072, 1072, 
	1072, 1072, 1072, 1072, 1072, 1072, 1072, 1072, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1072, 
	1072, 1072, 1072, 1072, 1072, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1072, 
	1072, 1072, 1072, 1072, 1072, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1063, 1059, 1052, 1059, 1059, 
	1059, 1052, 1059, 1059, 1059, 1059, 1070, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1052, 
	1059, 1059, 1059, 1059, 1059, 1070, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1073, 1073, 1073, 
	1073, 1073, 1073, 1073, 1073, 1073, 1073, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1073, 1073, 
	1073, 1073, 1073, 1073, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1073, 1073, 
	1073, 1073, 1073, 1073, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1050, 1059, 1052, 1059, 1059, 1059, 
	1052, 1059, 1059, 1059, 1059, 1070, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1052, 1059, 
	1059, 1059, 1059, 1059, 1070, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1074, 1074, 1074, 1074, 
	1074, 1074, 1074, 1074, 1074, 1074, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1074, 1074, 1074, 
	1074, 1074, 1074, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1074, 1074, 1074, 
	1074, 1074, 1074, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1050, 1059, 1052, 1059, 1059, 1059, 1052, 
	1059, 1059, 1059, 1059, 1070, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1052, 1059, 1059, 
	1059, 1059, 1059, 1070, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1075, 1075, 1075, 1075, 1075, 
	1075, 1075, 1075, 1075, 1075, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1075, 1075, 1075, 1075, 
	1075, 1075, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1075, 1075, 1075, 1075, 
	1075, 1075, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1050, 1059, 1052, 1059, 1059, 1059, 1052, 1059, 
	1059, 1059, 1059, 1070, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1052, 1059, 1059, 1059, 
	1059, 1059, 1070, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1076, 1076, 1076, 1076, 1076, 1076, 
	1076, 1076, 1076, 1076, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1076, 1076, 1076, 1076, 1076, 
	1076, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1076, 1076, 1076, 1076, 1076, 
	1076, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1050, 
	1059, 1052, 1059, 1059, 1059, 1052, 1059, 1059, 
	1059, 1059, 1070, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1052, 1059, 1059, 1059, 1059, 
	1059, 1070, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1077, 1077, 1077, 1077, 1077, 1077, 1077, 
	1077, 1077, 1077, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1077, 1077, 1077, 1077, 1077, 1077, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1077, 1077, 1077, 1077, 1077, 1077, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1050, 1059, 
	1052, 1059, 1059, 1059, 1052, 1059, 1059, 1059, 
	1059, 1070, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1052, 1059, 1059, 1059, 1059, 1059, 
	1070, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1069, 1069, 1069, 1069, 1069, 1069, 1069, 1069, 
	1069, 1069, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1069, 1069, 1069, 1069, 1069, 1069, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1069, 1069, 1069, 1069, 1069, 1069, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1050, 1059, 1052, 
	1059, 1059, 1059, 1052, 1059, 1059, 1059, 1059, 
	1070, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1052, 1059, 1059, 1059, 1059, 1059, 1070, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1078, 
	1078, 1078, 1078, 1078, 1078, 1078, 1078, 1078, 
	1078, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1078, 1078, 1078, 1078, 1078, 1078, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1078, 1078, 1078, 1078, 1078, 1078, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1063, 1059, 1052, 1059, 
	1059, 1059, 1052, 1059, 1059, 1059, 1059, 1070, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1052, 1059, 1059, 1059, 1059, 1059, 1070, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1079, 1079, 
	1079, 1079, 1079, 1079, 1079, 1079, 1079, 1079, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1079, 
	1079, 1079, 1079, 1079, 1079, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1079, 
	1079, 1079, 1079, 1079, 1079, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1063, 1059, 1052, 1059, 1059, 
	1059, 1052, 1059, 1059, 1059, 1059, 1070, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1052, 
	1059, 1059, 1059, 1059, 1059, 1070, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1080, 1080, 1080, 
	1080, 1080, 1080, 1080, 1080, 1080, 1080, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1080, 1080, 
	1080, 1080, 1080, 1080, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1080, 1080, 
	1080, 1080, 1080, 1080, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1063, 1059, 1052, 1059, 1059, 1059, 
	1052, 1059, 1059, 1059, 1059, 1070, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1052, 1059, 
	1059, 1059, 1059, 1059, 1070, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1081, 1081, 1081, 1081, 
	1081, 1081, 1081, 1081, 1081, 1081, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1081, 1081, 1081, 
	1081, 1081, 1081, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1081, 1081, 1081, 
	1081, 1081, 1081, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1063, 1059, 1052, 1059, 1059, 1059, 1052, 
	1059, 1059, 1059, 1059, 1070, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1052, 1059, 1059, 
	1059, 1059, 1059, 1070, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1069, 1069, 1069, 1069, 1069, 
	1069, 1069, 1069, 1069, 1069, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1069, 1069, 1069, 1069, 
	1069, 1069, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1069, 1069, 1069, 1069, 
	1069, 1069, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 
	1063, 1059, 1082, 1083, 1085, 1085, 1085, 1085, 
	1085, 1085, 1085, 1085, 1085, 1085, 1084, 1084, 
	1084, 1084, 1084, 1084, 1084, 1085, 1085, 1085, 
	1085, 1085, 1085, 1084, 1084, 1084, 1084, 1084, 
	1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
	1084, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 
	1084, 1084, 1084, 1084, 1084, 1085, 1085, 1085, 
	1085, 1085, 1085, 1084, 1084, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 287, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 288, 
	204, 204, 289, 204, 287, 204, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	204, 204, 204, 204, 286, 204, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	204, 204, 204, 204, 204, 286, 934, 934, 
	934, 934, 934, 934, 934, 934, 934, 934, 
	934, 934, 934, 934, 934, 934, 934, 934, 
	934, 934, 934, 934, 934, 934, 934, 934, 
	934, 934, 934, 934, 934, 934, 934, 287, 
	934, 934, 934, 934, 934, 934, 934, 934, 
	934, 934, 934, 934, 934, 934, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	288, 934, 934, 289, 934, 287, 934, 286, 
	286, 286, 286, 1086, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 934, 934, 934, 934, 286, 934, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 934, 934, 934, 934, 934, 286, 934, 
	934, 934, 934, 934, 934, 934, 934, 934, 
	934, 934, 934, 934, 934, 934, 934, 934, 
	934, 934, 934, 934, 934, 934, 934, 934, 
	934, 934, 934, 934, 934, 934, 934, 934, 
	287, 934, 934, 934, 934, 934, 934, 934, 
	934, 934, 934, 934, 934, 934, 934, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 288, 934, 934, 289, 934, 287, 934, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 1087, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 934, 934, 934, 934, 286, 934, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 934, 934, 934, 934, 934, 286, 
	1088, 1089, 934, 929, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 913, 912, 913, 
	913, 913, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 913, 287, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 288, 912, 
	912, 289, 912, 287, 912, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 912, 
	914, 912, 912, 1090, 912, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 912, 
	912, 912, 912, 912, 868, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 913, 912, 
	913, 913, 913, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 913, 287, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 288, 
	912, 912, 289, 912, 287, 912, 868, 868, 
	868, 868, 1091, 1092, 868, 868, 868, 868, 
	868, 1093, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	912, 914, 912, 912, 868, 912, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	912, 912, 912, 912, 912, 868, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 913, 
	912, 913, 913, 913, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 913, 287, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	288, 912, 912, 289, 912, 287, 912, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 1094, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 912, 914, 912, 912, 868, 912, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 912, 912, 912, 912, 912, 868, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	913, 912, 913, 913, 913, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 913, 
	287, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 288, 912, 912, 289, 912, 287, 912, 
	868, 868, 1095, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 912, 914, 912, 912, 868, 912, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 912, 912, 912, 912, 912, 868, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 913, 912, 913, 913, 913, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	913, 287, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 288, 912, 912, 289, 912, 287, 
	912, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 1096, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 912, 914, 912, 912, 868, 
	912, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 912, 912, 912, 912, 912, 
	868, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 913, 912, 913, 913, 913, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 913, 287, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 288, 912, 912, 289, 912, 
	287, 912, 868, 868, 868, 1097, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 912, 914, 912, 912, 
	868, 912, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 912, 912, 912, 912, 
	912, 868, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 913, 912, 913, 913, 913, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 913, 287, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 288, 912, 912, 289, 
	912, 287, 912, 868, 868, 868, 868, 868, 
	868, 868, 868, 1098, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 912, 914, 912, 
	912, 868, 912, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 912, 912, 912, 
	912, 912, 868, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 913, 912, 913, 913, 
	913, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 913, 287, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 288, 912, 912, 
	289, 912, 287, 912, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 1099, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 912, 914, 
	912, 912, 868, 912, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 912, 912, 
	912, 912, 912, 868, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 913, 912, 913, 
	913, 913, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 913, 287, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 288, 912, 
	912, 289, 912, 287, 912, 868, 868, 868, 
	868, 868, 868, 1100, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 912, 
	914, 912, 912, 868, 912, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 912, 
	912, 912, 912, 912, 868, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 913, 912, 
	913, 913, 913, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 913, 287, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 288, 
	912, 912, 289, 912, 287, 912, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	912, 914, 912, 912, 1101, 912, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	912, 912, 912, 912, 912, 868, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 913, 
	912, 913, 913, 913, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 913, 287, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	288, 912, 912, 289, 912, 287, 912, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 912, 914, 912, 912, 1102, 912, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 912, 912, 912, 912, 912, 868, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	287, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 288, 204, 204, 289, 204, 287, 204, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 204, 204, 204, 204, 868, 204, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 204, 204, 204, 204, 204, 868, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 913, 912, 913, 913, 913, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	913, 287, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 288, 912, 912, 289, 912, 287, 
	912, 868, 868, 868, 868, 868, 868, 868, 
	868, 1103, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 912, 914, 912, 912, 868, 
	912, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 912, 912, 912, 912, 912, 
	868, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 913, 912, 913, 913, 913, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 913, 287, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 288, 912, 912, 289, 912, 
	287, 912, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 1104, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 912, 914, 912, 912, 
	868, 912, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 912, 912, 912, 912, 
	912, 868, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 913, 912, 913, 913, 913, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 913, 287, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 288, 912, 912, 289, 
	912, 287, 912, 868, 868, 868, 868, 1100, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 912, 914, 912, 
	912, 868, 912, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 912, 912, 912, 
	912, 912, 868, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 913, 912, 913, 913, 
	913, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 913, 287, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 288, 912, 912, 
	289, 912, 287, 912, 868, 868, 868, 868, 
	868, 868, 868, 868, 1105, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 912, 914, 
	912, 912, 868, 912, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 912, 912, 
	912, 912, 912, 868, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 913, 912, 913, 
	913, 913, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 913, 287, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 288, 912, 
	912, 289, 912, 287, 912, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 1104, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 912, 
	914, 912, 912, 868, 912, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 912, 
	912, 912, 912, 912, 868, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 913, 912, 
	913, 913, 913, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 913, 287, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 288, 
	912, 912, 289, 912, 287, 912, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	912, 914, 912, 912, 868, 912, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 1106, 868, 1107, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	912, 912, 912, 912, 912, 868, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 913, 
	912, 913, 913, 913, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 913, 287, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	288, 912, 912, 289, 912, 287, 912, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 912, 914, 912, 912, 868, 912, 868, 
	868, 868, 868, 868, 868, 868, 868, 1108, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 912, 912, 912, 912, 912, 868, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	913, 912, 913, 913, 913, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 913, 
	287, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 288, 912, 912, 289, 912, 287, 912, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 912, 914, 912, 912, 868, 912, 
	1109, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 912, 912, 912, 912, 912, 868, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 913, 912, 913, 913, 913, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	913, 287, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 288, 912, 912, 289, 912, 287, 
	912, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 912, 914, 912, 912, 868, 
	912, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 1102, 868, 868, 868, 868, 
	868, 868, 868, 912, 912, 912, 912, 912, 
	868, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 913, 912, 913, 913, 913, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 913, 287, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 288, 912, 912, 289, 912, 
	287, 912, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 912, 914, 912, 912, 
	868, 912, 868, 868, 868, 1102, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 912, 912, 912, 912, 
	912, 868, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 913, 912, 913, 913, 913, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 913, 287, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 288, 912, 912, 289, 
	912, 287, 912, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 912, 914, 912, 
	912, 868, 912, 868, 868, 868, 868, 1110, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 1111, 868, 868, 868, 
	868, 868, 868, 868, 868, 912, 912, 912, 
	912, 912, 868, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 913, 912, 913, 913, 
	913, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 913, 287, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 288, 912, 912, 
	289, 912, 287, 912, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 912, 914, 
	912, 912, 868, 912, 868, 868, 868, 868, 
	868, 868, 1112, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 912, 912, 
	912, 912, 912, 868, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 913, 912, 913, 
	913, 913, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 913, 287, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 288, 912, 
	912, 289, 912, 287, 912, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 912, 
	914, 912, 912, 868, 912, 868, 868, 868, 
	868, 868, 868, 868, 868, 1113, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 912, 
	912, 912, 912, 912, 868, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 913, 912, 
	913, 913, 913, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 913, 287, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 288, 
	912, 912, 289, 912, 287, 912, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	912, 914, 912, 912, 868, 912, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 1102, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	912, 912, 912, 912, 912, 868, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 913, 
	912, 913, 913, 913, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 913, 287, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	288, 912, 912, 289, 912, 287, 912, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 912, 914, 912, 912, 868, 912, 868, 
	868, 868, 868, 1114, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 912, 912, 912, 912, 912, 868, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	913, 912, 913, 913, 913, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 913, 
	287, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 288, 912, 912, 289, 912, 287, 912, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 912, 914, 912, 912, 868, 912, 
	1115, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 912, 912, 912, 912, 912, 868, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 913, 912, 913, 913, 913, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	913, 287, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 288, 912, 912, 289, 912, 287, 
	912, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 912, 914, 912, 912, 868, 
	912, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 1102, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 912, 912, 912, 912, 912, 
	868, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 913, 912, 913, 913, 913, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 913, 287, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 288, 912, 912, 289, 912, 
	287, 912, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 912, 914, 912, 912, 
	868, 912, 1116, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 1117, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 912, 912, 912, 912, 
	912, 868, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 913, 912, 913, 913, 913, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 913, 287, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 288, 912, 912, 289, 
	912, 287, 912, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 912, 914, 912, 
	912, 868, 912, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 1118, 868, 868, 
	868, 868, 868, 868, 868, 912, 912, 912, 
	912, 912, 868, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 913, 912, 913, 913, 
	913, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 913, 287, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 288, 912, 912, 
	289, 912, 287, 912, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 912, 914, 
	912, 912, 868, 912, 868, 868, 868, 868, 
	1102, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 912, 912, 
	912, 912, 912, 868, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 913, 912, 913, 
	913, 913, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 913, 287, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 288, 912, 
	912, 289, 912, 287, 912, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 912, 
	914, 912, 912, 868, 912, 1119, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 912, 
	912, 912, 912, 912, 868, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 913, 912, 
	913, 913, 913, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 913, 287, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 288, 
	912, 912, 289, 912, 287, 912, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	912, 914, 912, 912, 868, 912, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	1109, 868, 868, 868, 868, 868, 868, 868, 
	912, 912, 912, 912, 912, 868, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 913, 
	912, 913, 913, 913, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 913, 287, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	288, 912, 912, 289, 912, 287, 912, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 912, 914, 912, 912, 868, 912, 868, 
	868, 868, 868, 1120, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 1102, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 912, 912, 912, 912, 912, 868, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	913, 912, 913, 913, 913, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 913, 
	287, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 288, 912, 912, 289, 912, 287, 912, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 912, 914, 912, 912, 868, 912, 
	868, 868, 868, 868, 868, 1102, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 912, 912, 912, 912, 912, 868, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 913, 912, 913, 913, 913, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	913, 287, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 288, 912, 912, 289, 912, 287, 
	912, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 912, 914, 912, 912, 868, 
	912, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 1121, 868, 1122, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 912, 912, 912, 912, 912, 
	868, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 913, 912, 913, 913, 913, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 913, 287, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 288, 912, 912, 289, 912, 
	287, 912, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 912, 914, 912, 912, 
	868, 912, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 1123, 868, 868, 868, 
	868, 868, 868, 868, 912, 912, 912, 912, 
	912, 868, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 913, 912, 913, 913, 913, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 913, 287, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 288, 912, 912, 289, 
	912, 287, 912, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 912, 914, 912, 
	912, 868, 912, 868, 868, 868, 868, 1102, 
	868, 868, 868, 1120, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 912, 912, 912, 
	912, 912, 868, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 913, 912, 913, 913, 
	913, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 913, 287, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 288, 912, 912, 
	289, 912, 287, 912, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 912, 914, 
	912, 912, 868, 912, 868, 868, 868, 1102, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 1124, 868, 
	868, 868, 868, 868, 868, 868, 912, 912, 
	912, 912, 912, 868, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 913, 912, 913, 
	913, 913, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 913, 287, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 288, 912, 
	912, 289, 912, 287, 912, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 912, 
	914, 912, 912, 868, 912, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 1125, 868, 868, 868, 868, 868, 912, 
	912, 912, 912, 912, 868, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 913, 912, 
	913, 913, 913, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 913, 287, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 288, 
	912, 912, 289, 912, 287, 912, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	912, 914, 912, 912, 868, 912, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 1118, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	912, 912, 912, 912, 912, 868, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 913, 
	912, 913, 913, 913, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 913, 287, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	288, 912, 912, 289, 912, 287, 912, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 912, 914, 912, 912, 868, 912, 1126, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 903, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 912, 912, 912, 912, 912, 868, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	913, 912, 913, 913, 913, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 913, 
	287, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 288, 912, 912, 289, 912, 287, 912, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 912, 914, 912, 912, 868, 912, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 1116, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 912, 912, 912, 912, 912, 868, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 913, 912, 913, 913, 913, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	913, 287, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 288, 912, 912, 289, 912, 287, 
	912, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 912, 914, 912, 912, 868, 
	912, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 1102, 868, 868, 868, 868, 868, 
	868, 868, 868, 912, 912, 912, 912, 912, 
	868, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 913, 912, 913, 913, 913, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 913, 287, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 288, 912, 912, 289, 912, 
	287, 912, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 912, 914, 912, 912, 
	868, 912, 868, 868, 868, 868, 868, 1127, 
	868, 868, 868, 868, 868, 868, 868, 1102, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 912, 912, 912, 912, 
	912, 868, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 913, 912, 913, 913, 913, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 913, 287, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 288, 912, 912, 289, 
	912, 287, 912, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 912, 914, 912, 
	912, 868, 912, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 1128, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 912, 912, 912, 
	912, 912, 868, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 913, 912, 913, 913, 
	913, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 913, 287, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 288, 912, 912, 
	289, 912, 287, 912, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 912, 914, 
	912, 912, 868, 912, 868, 868, 868, 1129, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 912, 912, 
	912, 912, 912, 868, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 913, 912, 913, 
	913, 913, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 913, 287, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 288, 912, 
	912, 289, 912, 287, 912, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 912, 
	914, 912, 912, 868, 912, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 1130, 868, 868, 868, 868, 868, 912, 
	912, 912, 912, 912, 868, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 913, 912, 
	913, 913, 913, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 913, 287, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 288, 
	912, 912, 289, 912, 287, 912, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	912, 914, 912, 912, 868, 912, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 1118, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	912, 912, 912, 912, 912, 868, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 913, 
	912, 913, 913, 913, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 913, 287, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	288, 912, 912, 289, 912, 287, 912, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 912, 914, 912, 912, 868, 912, 868, 
	868, 868, 868, 1131, 868, 868, 868, 1132, 
	868, 868, 868, 868, 868, 1133, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 912, 912, 912, 912, 912, 868, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	913, 912, 913, 913, 913, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 913, 
	287, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 288, 912, 912, 289, 912, 287, 912, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 912, 914, 912, 912, 868, 912, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 1133, 
	868, 868, 912, 912, 912, 912, 912, 868, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 913, 912, 913, 913, 913, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	913, 287, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 288, 912, 912, 289, 912, 287, 
	912, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 912, 914, 912, 912, 868, 
	912, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 1102, 868, 868, 868, 
	868, 868, 868, 912, 912, 912, 912, 912, 
	868, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 913, 912, 913, 913, 913, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 913, 287, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 288, 912, 912, 289, 912, 
	287, 912, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 912, 914, 912, 912, 
	868, 912, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 1102, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 912, 912, 912, 912, 
	912, 868, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 913, 912, 913, 913, 913, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 913, 287, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 288, 912, 912, 289, 
	912, 287, 912, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 912, 914, 912, 
	912, 868, 912, 868, 868, 868, 868, 1134, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 912, 912, 912, 
	912, 912, 868, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 913, 912, 913, 913, 
	913, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 913, 287, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 288, 912, 912, 
	289, 912, 287, 912, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 912, 914, 
	912, 912, 868, 912, 868, 868, 868, 1135, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 1136, 1137, 
	868, 868, 868, 868, 868, 868, 912, 912, 
	912, 912, 912, 868, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 913, 912, 913, 
	913, 913, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 913, 287, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 288, 912, 
	912, 289, 912, 287, 912, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 912, 
	914, 912, 912, 868, 912, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 1102, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 912, 
	912, 912, 912, 912, 868, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 913, 912, 
	913, 913, 913, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 913, 287, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 288, 
	912, 912, 289, 912, 287, 912, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	912, 914, 912, 912, 868, 912, 868, 868, 
	1138, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	912, 912, 912, 912, 912, 868, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 913, 
	912, 913, 913, 913, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 913, 287, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	288, 912, 912, 289, 912, 287, 912, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 912, 914, 912, 912, 868, 912, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 1139, 868, 868, 868, 868, 
	868, 912, 912, 912, 912, 912, 868, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	913, 912, 913, 913, 913, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 913, 
	287, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 288, 912, 912, 289, 912, 287, 912, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 912, 914, 912, 912, 868, 912, 
	868, 868, 868, 868, 1140, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 912, 912, 912, 912, 912, 868, 
	1141, 1141, 1141, 1141, 1141, 1141, 1141, 1141, 
	1141, 1141, 1141, 1141, 1141, 1141, 1141, 1141, 
	1141, 1141, 1141, 1141, 1141, 1141, 1141, 1141, 
	1141, 1141, 1141, 1141, 1141, 1141, 1141, 1141, 
	1141, 1143, 1141, 1141, 1141, 1141, 1141, 1141, 
	1141, 1141, 1141, 1141, 1141, 1141, 1141, 1141, 
	1142, 1142, 1142, 1142, 1142, 1142, 1142, 1142, 
	1142, 1142, 1144, 1141, 1141, 1145, 1141, 1143, 
	1141, 1142, 1142, 1142, 1142, 1142, 1142, 1142, 
	1142, 1142, 1142, 1142, 1142, 1142, 1142, 1142, 
	1142, 1142, 1142, 1142, 1142, 1142, 1142, 1142, 
	1142, 1142, 1142, 1141, 1141, 1141, 1141, 1142, 
	1141, 1142, 1142, 1142, 1142, 1142, 1142, 1142, 
	1142, 1142, 1142, 1142, 1142, 1142, 1142, 1142, 
	1142, 1142, 1142, 1142, 1142, 1142, 1142, 1142, 
	1142, 1142, 1142, 1141, 1141, 1141, 1141, 1141, 
	1142, 920, 1146, 919, 919, 919, 919, 919, 
	919, 919, 919, 919, 919, 919, 919, 919, 
	919, 919, 919, 919, 919, 919, 919, 919, 
	919, 919, 919, 919, 919, 919, 919, 919, 
	919, 919, 919, 919, 919, 919, 919, 919, 
	919, 919, 919, 919, 919, 919, 919, 919, 
	919, 919, 919, 919, 919, 919, 919, 919, 
	919, 919, 919, 919, 919, 919, 919, 919, 
	919, 919, 922, 919, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 913, 912, 913, 
	913, 913, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 913, 287, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 288, 912, 
	912, 289, 912, 287, 912, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 912, 
	914, 912, 912, 868, 912, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 1147, 868, 
	868, 1148, 868, 868, 868, 868, 868, 912, 
	912, 912, 912, 912, 868, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 913, 912, 
	913, 913, 913, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 913, 287, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 288, 
	912, 912, 289, 912, 287, 912, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	912, 914, 912, 912, 868, 912, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 1102, 868, 
	912, 912, 912, 912, 912, 868, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 913, 
	912, 913, 913, 913, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 913, 287, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	288, 912, 912, 289, 912, 287, 912, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 912, 914, 912, 912, 868, 912, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	1113, 868, 868, 868, 868, 868, 868, 868, 
	868, 912, 912, 912, 912, 912, 868, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	913, 912, 913, 913, 913, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 913, 
	287, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 288, 912, 912, 289, 912, 287, 912, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 912, 914, 912, 912, 868, 912, 
	868, 868, 868, 868, 1149, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 1150, 868, 868, 868, 
	868, 868, 912, 912, 912, 912, 912, 868, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 913, 912, 913, 913, 913, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	913, 287, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 288, 912, 912, 289, 912, 287, 
	912, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 912, 914, 912, 912, 868, 
	912, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 1120, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 912, 912, 912, 912, 912, 
	868, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 913, 912, 913, 913, 913, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 913, 287, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 288, 912, 912, 289, 912, 
	287, 912, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 912, 914, 912, 912, 
	868, 912, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 1151, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 912, 912, 912, 912, 
	912, 868, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 913, 912, 913, 913, 913, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 913, 287, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 288, 912, 912, 289, 
	912, 287, 912, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 912, 914, 912, 
	912, 868, 912, 868, 868, 868, 868, 903, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 912, 912, 912, 
	912, 912, 868, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 913, 912, 913, 913, 
	913, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 913, 287, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 288, 912, 912, 
	289, 912, 287, 912, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 912, 914, 
	912, 912, 868, 912, 868, 868, 868, 868, 
	868, 868, 868, 1152, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 1153, 868, 868, 
	868, 868, 868, 868, 868, 868, 912, 912, 
	912, 912, 912, 868, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 913, 912, 913, 
	913, 913, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 913, 287, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 288, 912, 
	912, 289, 912, 287, 912, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 912, 
	914, 912, 912, 868, 912, 868, 868, 868, 
	868, 1113, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 912, 
	912, 912, 912, 912, 868, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 913, 912, 
	913, 913, 913, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 913, 287, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 288, 
	912, 912, 289, 912, 287, 912, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	912, 914, 912, 912, 868, 912, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 1118, 868, 868, 868, 868, 868, 
	912, 912, 912, 912, 912, 868, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 913, 
	912, 913, 913, 913, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 913, 287, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	288, 912, 912, 289, 912, 287, 912, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 912, 914, 912, 912, 868, 912, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 1154, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 912, 912, 912, 912, 912, 868, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	913, 912, 913, 913, 913, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 913, 
	287, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 288, 912, 912, 289, 912, 287, 912, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 912, 914, 912, 912, 868, 912, 
	868, 868, 868, 1155, 868, 868, 868, 868, 
	868, 868, 868, 1156, 868, 868, 868, 868, 
	868, 868, 868, 1157, 868, 868, 868, 868, 
	868, 868, 912, 912, 912, 912, 912, 868, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 913, 912, 913, 913, 913, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	913, 287, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 288, 912, 912, 289, 912, 287, 
	912, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 912, 914, 912, 912, 868, 
	912, 868, 868, 868, 868, 1120, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 912, 912, 912, 912, 912, 
	868, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 913, 912, 913, 913, 913, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 913, 287, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 288, 912, 912, 289, 912, 
	287, 912, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 912, 914, 912, 912, 
	868, 912, 868, 868, 868, 868, 1158, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 912, 912, 912, 912, 
	912, 868, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 913, 912, 913, 913, 913, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 913, 287, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 288, 912, 912, 289, 
	912, 287, 912, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 912, 914, 912, 
	912, 868, 912, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 1159, 868, 868, 
	868, 868, 868, 868, 868, 912, 912, 912, 
	912, 912, 868, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 913, 912, 913, 913, 
	913, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 913, 287, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 288, 912, 912, 
	289, 912, 287, 912, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 912, 914, 
	912, 912, 868, 912, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 1127, 868, 
	868, 868, 868, 868, 868, 868, 912, 912, 
	912, 912, 912, 868, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 913, 912, 913, 
	913, 913, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 913, 287, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 288, 912, 
	912, 289, 912, 287, 912, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 912, 
	914, 912, 912, 868, 912, 868, 868, 868, 
	868, 868, 868, 868, 868, 1160, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 912, 
	912, 912, 912, 912, 868, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 913, 912, 
	913, 913, 913, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 913, 287, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 288, 
	912, 912, 289, 912, 287, 912, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	912, 914, 912, 912, 868, 912, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 1127, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	912, 912, 912, 912, 912, 868, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 913, 
	912, 913, 913, 913, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 913, 287, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	288, 912, 912, 289, 912, 287, 912, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 912, 914, 912, 912, 868, 912, 868, 
	868, 868, 868, 868, 868, 868, 1161, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 912, 912, 912, 912, 912, 868, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	913, 912, 913, 913, 913, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 913, 
	287, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 288, 912, 912, 289, 912, 287, 912, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 912, 914, 912, 912, 868, 912, 
	868, 868, 868, 868, 1113, 868, 868, 868, 
	1162, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 912, 912, 912, 912, 912, 868, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 913, 912, 913, 913, 913, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	913, 287, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 288, 912, 912, 289, 912, 287, 
	912, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 912, 914, 912, 912, 868, 
	912, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 1163, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 912, 912, 912, 912, 912, 
	868, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 913, 912, 913, 913, 913, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 913, 287, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 288, 912, 912, 289, 912, 
	287, 912, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 912, 914, 912, 912, 
	868, 912, 868, 868, 868, 868, 1127, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 912, 912, 912, 912, 
	912, 868, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 913, 912, 913, 913, 913, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 913, 287, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 288, 912, 912, 289, 
	912, 287, 912, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 912, 914, 912, 
	912, 868, 912, 868, 868, 868, 868, 868, 
	868, 868, 868, 1164, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 912, 912, 912, 
	912, 912, 868, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 913, 912, 913, 913, 
	913, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 913, 287, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 288, 912, 912, 
	289, 912, 287, 912, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 912, 914, 
	912, 912, 868, 912, 868, 868, 868, 868, 
	1165, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 912, 912, 
	912, 912, 912, 868, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 913, 912, 913, 
	913, 913, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 913, 287, 912, 912, 
	912, 912, 912, 912, 912, 912, 912, 912, 
	912, 912, 912, 912, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 288, 912, 
	912, 289, 912, 287, 912, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 912, 
	914, 912, 912, 868, 912, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	1107, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 912, 
	912, 912, 912, 912, 868, 1166, 215, 934, 
	934, 934, 934, 934, 934, 934, 934, 934, 
	934, 934, 934, 934, 934, 934, 934, 934, 
	934, 934, 934, 934, 934, 934, 934, 934, 
	934, 934, 934, 934, 934, 934, 934, 934, 
	934, 934, 934, 934, 934, 934, 934, 934, 
	934, 934, 934, 934, 934, 934, 934, 934, 
	934, 934, 934, 934, 934, 934, 934, 934, 
	934, 934, 934, 934, 934, 1167, 934, 1169, 
	1168, 1168, 1168, 1169, 1168, 1168, 1168, 1168, 
	1170, 1171, 1170, 1170, 1170, 1168, 1168, 1168, 
	1168, 1168, 1168, 1168, 1168, 1168, 1168, 1168, 
	1168, 1169, 1168, 1168, 1168, 1168, 1168, 1170, 
	1168, 1168, 1172, 1168, 1168, 1168, 1168, 1168, 
	1168, 1168, 1168, 1168, 1168, 1168, 1168, 1168, 
	1168, 1168, 1168, 1168, 1168, 1168, 1168, 1168, 
	1168, 1168, 1168, 1168, 1168, 1168, 1168, 1168, 
	1168, 1168, 1168, 1168, 1168, 1168, 1168, 1168, 
	1168, 1168, 1168, 1168, 1168, 1168, 1168, 1168, 
	1168, 1168, 1168, 1168, 1168, 1168, 1168, 1168, 
	1168, 1168, 1168, 1173, 1168, 1170, 1174, 1170, 
	1170, 1170, 1174, 1174, 1174, 1174, 1174, 1174, 
	1174, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 
	1174, 1174, 1174, 1174, 1170, 1174, 1175, 1176, 
	1177, 1178, 1179, 1181, 1180, 1182, 1184, 1185, 
	1185, 1185, 1184, 1185, 1185, 1185, 1185, 1186, 
	1187, 1186, 1186, 1186, 1185, 1185, 1185, 1185, 
	1185, 1185, 1185, 1185, 1185, 1185, 1185, 1185, 
	1184, 1185, 1185, 1185, 1185, 1185, 1186, 1185, 
	1188, 1189, 1185, 1185, 1185, 1188, 1185, 1185, 
	1185, 1185, 1185, 1185, 1185, 1185, 1185, 1185, 
	1185, 1185, 1185, 1185, 1185, 1185, 1185, 1185, 
	1185, 1185, 1185, 1185, 1185, 1185, 1185, 1183, 
	1183, 1183, 1183, 1183, 1183, 1183, 1183, 1183, 
	1183, 1183, 1183, 1183, 1183, 1183, 1183, 1183, 
	1183, 1183, 1183, 1183, 1183, 1183, 1183, 1183, 
	1183, 1185, 1190, 1185, 1185, 1183, 1185, 1183, 
	1183, 1183, 1183, 1183, 1183, 1183, 1183, 1183, 
	1183, 1183, 1183, 1183, 1183, 1183, 1183, 1183, 
	1183, 1183, 1183, 1183, 1183, 1183, 1183, 1183, 
	1183, 1185, 1185, 1185, 1185, 1185, 1183, 1191, 
	1191, 1191, 1191, 1191, 1191, 1191, 1191, 1191, 
	1191, 1191, 1191, 1191, 1191, 1191, 1191, 1191, 
	1191, 1191, 1191, 1191, 1191, 1191, 1191, 1191, 
	1191, 1191, 1191, 1191, 1191, 1191, 1191, 1191, 
	295, 1191, 1191, 1191, 1191, 1191, 1191, 1191, 
	1191, 1191, 1191, 1191, 1191, 1191, 1191, 294, 
	294, 294, 294, 294, 294, 294, 294, 294, 
	294, 296, 1191, 1191, 1191, 1191, 295, 1191, 
	294, 294, 294, 294, 294, 294, 294, 294, 
	294, 294, 294, 294, 294, 294, 294, 294, 
	294, 294, 294, 294, 294, 294, 294, 294, 
	294, 294, 1191, 1191, 1191, 1191, 294, 1191, 
	294, 294, 294, 294, 294, 294, 294, 294, 
	294, 294, 294, 294, 294, 294, 294, 294, 
	294, 294, 294, 294, 294, 294, 294, 294, 
	294, 294, 1191, 1191, 1191, 1191, 1191, 294, 
	1186, 1192, 1186, 1186, 1186, 1192, 1192, 1192, 
	1192, 1192, 1192, 1192, 1192, 1192, 1192, 1192, 
	1192, 1192, 1192, 1192, 1192, 1192, 1192, 1186, 
	1192, 1193, 1194, 1195, 1196, 1197, 1198, 1191, 
	1199, 1201, 1202, 1202, 1202, 1201, 1202, 1202, 
	1202, 1202, 1203, 1204, 1203, 1203, 1203, 1202, 
	1202, 1202, 1202, 1202, 1202, 1202, 1202, 1202, 
	1202, 1202, 1202, 1201, 1202, 1202, 1202, 1202, 
	1202, 1203, 1205, 1206, 1207, 1208, 1209, 1210, 
	1206, 1211, 1212, 1213, 1209, 1214, 1215, 1216, 
	1209, 1217, 1218, 1218, 1218, 1218, 1218, 1218, 
	1218, 1218, 1218, 1219, 1220, 1221, 1222, 1223, 
	1224, 1225, 1226, 1227, 1226, 1226, 1228, 1226, 
	1226, 1226, 1226, 1226, 1226, 1226, 1226, 1226, 
	1226, 1226, 1226, 1226, 1226, 1226, 1226, 1226, 
	1226, 1226, 1226, 1226, 1229, 1230, 1231, 1209, 
	1232, 1206, 1233, 1234, 1235, 1236, 1237, 1238, 
	1200, 1200, 1239, 1200, 1200, 1200, 1240, 1241, 
	1242, 1200, 1200, 1243, 1244, 1245, 1246, 1200, 
	1247, 1200, 1248, 1200, 1249, 1250, 1251, 1252, 
	1202, 1200, 304, 304, 304, 304, 304, 304, 
	304, 304, 304, 304, 304, 304, 304, 304, 
	304, 304, 304, 304, 304, 304, 304, 304, 
	304, 304, 304, 304, 304, 304, 304, 304, 
	304, 304, 304, 1253, 304, 304, 304, 304, 
	304, 304, 304, 304, 304, 304, 304, 304, 
	304, 304, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 304, 304, 304, 304, 
	304, 1253, 304, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 304, 304, 304, 
	304, 1200, 304, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 304, 304, 304, 
	304, 304, 1200, 1255, 1254, 1256, 1203, 1257, 
	1203, 1203, 1203, 1257, 1257, 1257, 1257, 1257, 
	1257, 1257, 1257, 1257, 1257, 1257, 1257, 1257, 
	1257, 1257, 1257, 1257, 1257, 1203, 1257, 1258, 
	1260, 1259, 1259, 1259, 1259, 1259, 1259, 1259, 
	1259, 1259, 1259, 1259, 1259, 1259, 1259, 1259, 
	1259, 1259, 1259, 1259, 1259, 1259, 1259, 1259, 
	1259, 1259, 1259, 1259, 1259, 1259, 1259, 1259, 
	1259, 1259, 1259, 1259, 1259, 1259, 1259, 1259, 
	1259, 1259, 1259, 1259, 1259, 1259, 1259, 1259, 
	1259, 1259, 1259, 1259, 1259, 1259, 1259, 1259, 
	1259, 1259, 1259, 1259, 1259, 1259, 1259, 1259, 
	1259, 1260, 1259, 1261, 1262, 1263, 1264, 1265, 
	1265, 1265, 1265, 1265, 1265, 1265, 1265, 1265, 
	1265, 1265, 1265, 1265, 1265, 1265, 1265, 1265, 
	1265, 1265, 1265, 1265, 1265, 1265, 1265, 1265, 
	1265, 1265, 1265, 1265, 1265, 1265, 1265, 1265, 
	299, 299, 1265, 299, 1265, 299, 299, 1265, 
	1265, 299, 299, 299, 1266, 299, 299, 1267, 
	1267, 1267, 1267, 1267, 1267, 1267, 1267, 1267, 
	1267, 299, 299, 299, 299, 299, 299, 299, 
	316, 316, 316, 316, 316, 316, 316, 316, 
	316, 316, 316, 316, 316, 316, 316, 316, 
	316, 316, 316, 316, 316, 316, 316, 316, 
	316, 316, 1265, 299, 1265, 1265, 316, 299, 
	316, 316, 316, 316, 316, 316, 316, 316, 
	316, 316, 316, 316, 316, 316, 316, 316, 
	316, 316, 316, 316, 316, 316, 316, 316, 
	316, 316, 1265, 1265, 1265, 299, 1265, 316, 
	1268, 1268, 1268, 1268, 1268, 1268, 1268, 1268, 
	1268, 1268, 1268, 1268, 1268, 1268, 1268, 1268, 
	1268, 1268, 1268, 1268, 1268, 1268, 1268, 1268, 
	1268, 1268, 1268, 1268, 1268, 1268, 1268, 1268, 
	1268, 1268, 1268, 1268, 1268, 1268, 1268, 1268, 
	1268, 1268, 1268, 1268, 1268, 1268, 1268, 1268, 
	316, 316, 316, 316, 316, 316, 316, 316, 
	316, 316, 1268, 1268, 1268, 1268, 1268, 1268, 
	1268, 316, 316, 316, 316, 316, 316, 316, 
	316, 316, 316, 316, 316, 316, 316, 316, 
	316, 316, 316, 316, 316, 316, 316, 316, 
	316, 316, 316, 1268, 1268, 1268, 1268, 316, 
	1268, 316, 316, 316, 316, 316, 316, 316, 
	316, 316, 316, 316, 316, 316, 316, 316, 
	316, 316, 316, 316, 316, 316, 316, 316, 
	316, 316, 316, 1268, 1268, 1268, 1268, 1268, 
	316, 1267, 1267, 1267, 1267, 1267, 1267, 1267, 
	1267, 1267, 1267, 1268, 1269, 304, 1209, 1270, 
	1270, 1270, 1270, 1270, 1270, 1270, 1271, 1270, 
	1270, 1270, 1270, 1270, 1270, 1270, 1270, 1270, 
	1270, 1270, 1270, 1270, 1270, 1269, 1270, 1272, 
	1273, 1209, 1274, 1274, 1274, 1274, 1274, 1274, 
	1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 
	1274, 1274, 1274, 1274, 1269, 1274, 1269, 1275, 
	1270, 1277, 1276, 303, 303, 303, 303, 303, 
	303, 303, 303, 303, 303, 1276, 1279, 1278, 
	1280, 1278, 303, 303, 303, 303, 303, 303, 
	303, 303, 303, 303, 1281, 1281, 1281, 1281, 
	1281, 1281, 1281, 1281, 1281, 1281, 1281, 1282, 
	1281, 1281, 1281, 1281, 1281, 1281, 1281, 1281, 
	1281, 1281, 1281, 1281, 1281, 1281, 1281, 1281, 
	1281, 1281, 1281, 1281, 1281, 1281, 1281, 1281, 
	1281, 1283, 1281, 1281, 1281, 1281, 1281, 1282, 
	1281, 302, 302, 302, 302, 302, 302, 302, 
	302, 302, 302, 1281, 1281, 1281, 1281, 1281, 
	1281, 1281, 1281, 1281, 1281, 1281, 1281, 1281, 
	1281, 1281, 1281, 1281, 1281, 1281, 1281, 1281, 
	1281, 1281, 1281, 1281, 1281, 1281, 1281, 1281, 
	1281, 1281, 1281, 1281, 1281, 1281, 1281, 1281, 
	301, 1281, 1285, 1284, 1286, 1286, 1286, 1286, 
	1286, 1286, 1286, 1286, 1286, 1286, 1284, 1284, 
	1284, 1284, 1284, 1284, 1284, 1284, 1287, 1284, 
	1288, 1289, 1284, 1284, 1284, 1284, 1284, 1284, 
	1284, 1284, 1284, 1290, 1284, 1284, 1284, 1284, 
	1284, 1284, 1284, 1284, 1291, 1284, 1284, 1284, 
	1284, 1284, 1284, 1292, 1284, 1284, 1287, 1284, 
	1288, 1289, 1284, 1284, 1284, 1293, 1284, 1284, 
	1284, 1284, 1284, 1290, 1284, 1284, 1294, 1284, 
	1284, 1284, 1284, 1284, 1291, 1284, 305, 305, 
	305, 305, 305, 305, 305, 305, 305, 305, 
	1295, 1295, 1295, 1295, 1295, 1295, 1295, 1295, 
	1295, 1295, 1295, 1296, 1295, 1295, 1295, 1295, 
	1295, 1295, 1295, 1295, 1295, 1295, 1295, 1295, 
	1295, 1295, 1295, 1295, 1295, 1295, 1295, 1295, 
	1295, 1295, 1295, 1295, 1295, 1297, 1295, 1295, 
	1295, 1295, 1295, 1296, 1295, 1295, 1295, 1298, 
	1295, 1295, 1295, 1295, 1295, 1295, 1295, 1295, 
	1299, 1295, 1300, 304, 1300, 304, 304, 306, 
	306, 306, 306, 306, 306, 306, 306, 306, 
	306, 304, 306, 306, 306, 306, 306, 306, 
	306, 306, 306, 306, 1301, 1301, 1301, 1301, 
	1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 
	1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 
	1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 
	1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 
	1301, 1300, 1301, 1301, 1301, 1301, 1301, 1301, 
	1301, 1301, 1301, 1302, 1301, 1304, 1303, 1305, 
	1307, 1306, 1306, 1306, 1308, 1306, 1309, 1310, 
	1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286, 
	1286, 1286, 1284, 1284, 1284, 1284, 1284, 1284, 
	1284, 1284, 1284, 1284, 1284, 1284, 1284, 1284, 
	1284, 1284, 1284, 1284, 1284, 1284, 1284, 1284, 
	1284, 1284, 1284, 1284, 1284, 1284, 1284, 1284, 
	1284, 1284, 1284, 1284, 1284, 1284, 1284, 1292, 
	1284, 1284, 1284, 1284, 1284, 1284, 1284, 1284, 
	1284, 1293, 1284, 1284, 1284, 1284, 1284, 1284, 
	1284, 1284, 1294, 1284, 1311, 1311, 1311, 1311, 
	1311, 1311, 1311, 1311, 1311, 1311, 1284, 1284, 
	1284, 1284, 1284, 1284, 1284, 1284, 1284, 1284, 
	1284, 1284, 1284, 1284, 1284, 1284, 1284, 1284, 
	1284, 1284, 1284, 1284, 1284, 1284, 1284, 1284, 
	1284, 1284, 1284, 1284, 1284, 1284, 1284, 1284, 
	1284, 1284, 1284, 1312, 1284, 1284, 1284, 1284, 
	1284, 1284, 1284, 1284, 1284, 1293, 1284, 1284, 
	1284, 1284, 1284, 1284, 1284, 1284, 1294, 1284, 
	1314, 1314, 1314, 1314, 1314, 1314, 1314, 1314, 
	1314, 1314, 1313, 1313, 1313, 1313, 1313, 1313, 
	1313, 1313, 1313, 1313, 1313, 1313, 1313, 1313, 
	1313, 1313, 1313, 1313, 1313, 1313, 1313, 1313, 
	1313, 1313, 1313, 1313, 1313, 1313, 1313, 1313, 
	1313, 1313, 1313, 1313, 1313, 1313, 1313, 1315, 
	1313, 1313, 1313, 1313, 1313, 1313, 1313, 1313, 
	1313, 1316, 1313, 1313, 1313, 1313, 1313, 1313, 
	1313, 1313, 1317, 1313, 1314, 1314, 1314, 1314, 
	1314, 1314, 1314, 1314, 1314, 1314, 1313, 1313, 
	1313, 1313, 1313, 1313, 1313, 1313, 1313, 1313, 
	1313, 1313, 1313, 1313, 1313, 1313, 1313, 1313, 
	1313, 1313, 1313, 1313, 1313, 1313, 1313, 1313, 
	1313, 1313, 1313, 1313, 1313, 1313, 1313, 1313, 
	1313, 1313, 1313, 1318, 1313, 1313, 1313, 1313, 
	1313, 1313, 1313, 1313, 1313, 1316, 1313, 1313, 
	1313, 1313, 1313, 1313, 1313, 1313, 1317, 1313, 
	1316, 1313, 1313, 1313, 1313, 1313, 1313, 1313, 
	1313, 1317, 1313, 1320, 1319, 1321, 1323, 1322, 
	1322, 1322, 1324, 1322, 1326, 1325, 1327, 1328, 
	1330, 1330, 1329, 1329, 1329, 1329, 1329, 1329, 
	1329, 1329, 1329, 1329, 1329, 1329, 1329, 1329, 
	1329, 1329, 1329, 1329, 1329, 1329, 1329, 1329, 
	1329, 1329, 1329, 1329, 1329, 1329, 1329, 1329, 
	1329, 1329, 1329, 1329, 1329, 1329, 1329, 1329, 
	1329, 1329, 1329, 1329, 1329, 1329, 1329, 1331, 
	1329, 1329, 1329, 1329, 1329, 1329, 1329, 1329, 
	1329, 1332, 1329, 1329, 1329, 1329, 1329, 1329, 
	1329, 1329, 1333, 1329, 1334, 1334, 1313, 1313, 
	1313, 1313, 1313, 1313, 1313, 1313, 1313, 1313, 
	1313, 1313, 1313, 1313, 1313, 1313, 1313, 1313, 
	1313, 1313, 1313, 1313, 1313, 1313, 1313, 1313, 
	1313, 1313, 1313, 1313, 1313, 1313, 1313, 1313, 
	1313, 1313, 1313, 1313, 1313, 1313, 1313, 1313, 
	1313, 1313, 1313, 1335, 1313, 1313, 1313, 1313, 
	1313, 1313, 1313, 1313, 1313, 1316, 1313, 1313, 
	1313, 1313, 1313, 1313, 1313, 1313, 1317, 1313, 
	1334, 1334, 1313, 1313, 1313, 1313, 1313, 1313, 
	1313, 1313, 1313, 1313, 1313, 1313, 1313, 1313, 
	1313, 1313, 1313, 1313, 1313, 1313, 1313, 1313, 
	1313, 1313, 1313, 1313, 1313, 1313, 1313, 1313, 
	1313, 1313, 1313, 1313, 1313, 1313, 1313, 1313, 
	1313, 1313, 1313, 1313, 1313, 1313, 1313, 1318, 
	1313, 1313, 1313, 1313, 1313, 1313, 1313, 1313, 
	1313, 1316, 1313, 1313, 1313, 1313, 1313, 1313, 
	1313, 1313, 1317, 1313, 1337, 1337, 1337, 1337, 
	1337, 1337, 1337, 1337, 1337, 1337, 1336, 1336, 
	1336, 1336, 1336, 1336, 1336, 1336, 1336, 1336, 
	1336, 1336, 1336, 1336, 1336, 1336, 1336, 1336, 
	1336, 1336, 1336, 1336, 1336, 1336, 1336, 1336, 
	1336, 1336, 1336, 1336, 1336, 1336, 1336, 1336, 
	1336, 1336, 1336, 1338, 1336, 1336, 1336, 1336, 
	1336, 1336, 1336, 1336, 1336, 1339, 1336, 1336, 
	1336, 1336, 1336, 1336, 1336, 1336, 1340, 1336, 
	1342, 1342, 1342, 1342, 1342, 1342, 1342, 1342, 
	1342, 1342, 1341, 1341, 1341, 1341, 1341, 1341, 
	1341, 1341, 1341, 1341, 1341, 1341, 1341, 1341, 
	1341, 1341, 1341, 1341, 1341, 1341, 1341, 1341, 
	1341, 1341, 1341, 1341, 1341, 1341, 1341, 1341, 
	1341, 1341, 1341, 1341, 1341, 1341, 1341, 1343, 
	1341, 1341, 1341, 1341, 1341, 1341, 1341, 1341, 
	1341, 1344, 1341, 1341, 1341, 1341, 1341, 1341, 
	1341, 1341, 1345, 1341, 1347, 1347, 1347, 1347, 
	1347, 1347, 1347, 1347, 1347, 1347, 1346, 1346, 
	1346, 1346, 1346, 1346, 1346, 1347, 1347, 1347, 
	1347, 1347, 1347, 1346, 1346, 1346, 1346, 1346, 
	1346, 1346, 1346, 1346, 1346, 1346, 1346, 1346, 
	1346, 1346, 1346, 1346, 1346, 1346, 1346, 1346, 
	1346, 1346, 1346, 1348, 1346, 1347, 1347, 1347, 
	1347, 1347, 1347, 1346, 1346, 1349, 1346, 1346, 
	1346, 1346, 1346, 1346, 1346, 1346, 1350, 1346, 
	1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351, 
	1351, 1351, 1313, 1313, 1313, 1313, 1313, 1313, 
	1313, 1351, 1351, 1351, 1351, 1351, 1351, 1313, 
	1313, 1313, 1313, 1313, 1313, 1313, 1313, 1313, 
	1313, 1313, 1313, 1313, 1313, 1313, 1313, 1313, 
	1313, 1313, 1313, 1313, 1313, 1313, 1313, 1352, 
	1313, 1351, 1351, 1351, 1351, 1351, 1351, 1313, 
	1313, 1316, 1313, 1313, 1313, 1313, 1313, 1313, 
	1313, 1313, 1317, 1313, 1351, 1351, 1351, 1351, 
	1351, 1351, 1351, 1351, 1351, 1351, 1313, 1313, 
	1313, 1313, 1313, 1313, 1313, 1351, 1351, 1351, 
	1351, 1351, 1351, 1313, 1313, 1313, 1313, 1313, 
	1313, 1313, 1313, 1313, 1313, 1313, 1313, 1313, 
	1313, 1313, 1313, 1313, 1313, 1313, 1313, 1313, 
	1313, 1313, 1313, 1318, 1313, 1351, 1351, 1351, 
	1351, 1351, 1351, 1313, 1313, 1316, 1313, 1313, 
	1313, 1313, 1313, 1313, 1313, 1313, 1317, 1313, 
	1354, 1353, 1355, 1355, 1355, 1355, 1355, 1355, 
	1355, 1355, 1355, 1355, 1353, 1353, 1353, 1353, 
	1353, 1353, 1353, 1353, 1353, 1353, 1353, 1356, 
	1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 
	1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 
	1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 
	1353, 1357, 1353, 1353, 1353, 1353, 1353, 1356, 
	1353, 1353, 1353, 1358, 1353, 1353, 1353, 1353, 
	1353, 1353, 1353, 1353, 1359, 1353, 1360, 1360, 
	1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 
	1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 
	1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 
	1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 
	1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 
	1353, 1353, 1353, 1353, 1353, 1361, 1353, 1353, 
	1353, 1353, 1353, 1353, 1353, 1353, 1353, 1358, 
	1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 
	1359, 1353, 1362, 1313, 1363, 1363, 1363, 1363, 
	1363, 1363, 1363, 1363, 1363, 1363, 1313, 1313, 
	1313, 1313, 1313, 1313, 1313, 1313, 1313, 1313, 
	1313, 1364, 1313, 1313, 1313, 1313, 1313, 1313, 
	1313, 1313, 1313, 1313, 1313, 1313, 1313, 1313, 
	1313, 1313, 1313, 1313, 1313, 1313, 1313, 1313, 
	1313, 1313, 1313, 1365, 1313, 1313, 1313, 1313, 
	1313, 1364, 1313, 1313, 1313, 1316, 1313, 1313, 
	1313, 1313, 1313, 1313, 1313, 1313, 1317, 1313, 
	1363, 1363, 1363, 1363, 1363, 1363, 1363, 1363, 
	1363, 1363, 1313, 1313, 1313, 1313, 1313, 1313, 
	1313, 1313, 1313, 1313, 1313, 1313, 1313, 1313, 
	1313, 1313, 1313, 1313, 1313, 1313, 1313, 1313, 
	1313, 1313, 1313, 1313, 1313, 1313, 1313, 1313, 
	1313, 1313, 1313, 1313, 1313, 1313, 1313, 1318, 
	1313, 1313, 1313, 1313, 1313, 1313, 1313, 1313, 
	1313, 1316, 1313, 1313, 1313, 1313, 1313, 1313, 
	1313, 1313, 1317, 1313, 1271, 1278, 1209, 1366, 
	1270, 1260, 1270, 1367, 1368, 1278, 1278, 1278, 
	1278, 1278, 1278, 1278, 1278, 1278, 1278, 1278, 
	1278, 1278, 1278, 1278, 1278, 1278, 1278, 1278, 
	1278, 1278, 1278, 1278, 1278, 1278, 1278, 1278, 
	1278, 1278, 1278, 1278, 1278, 1278, 1278, 1278, 
	1278, 1278, 1278, 1278, 1278, 1278, 1278, 1278, 
	1278, 1278, 1278, 1278, 1278, 1278, 1278, 1278, 
	1278, 1278, 1278, 1278, 1278, 1278, 1278, 1278, 
	1278, 1278, 1278, 1278, 1260, 1278, 1260, 1270, 
	1260, 1209, 1270, 1265, 1265, 1265, 1265, 1265, 
	1265, 1265, 1265, 1265, 1265, 1265, 1265, 1265, 
	1265, 1265, 1265, 1265, 1265, 1265, 1265, 1265, 
	1265, 1265, 1265, 1265, 1265, 1265, 1265, 1265, 
	1265, 1265, 1265, 1265, 1265, 1265, 1265, 1265, 
	1265, 1265, 1265, 1265, 1265, 1265, 1265, 1265, 
	1265, 1265, 1265, 316, 316, 316, 316, 316, 
	316, 316, 316, 316, 316, 1265, 1265, 1265, 
	1265, 1265, 1265, 1369, 316, 316, 316, 316, 
	316, 316, 316, 316, 316, 316, 316, 316, 
	316, 316, 316, 316, 316, 316, 316, 316, 
	316, 316, 316, 316, 316, 316, 1265, 1265, 
	1265, 1265, 316, 1265, 316, 316, 316, 316, 
	316, 316, 316, 316, 316, 316, 316, 316, 
	316, 316, 316, 316, 316, 316, 316, 316, 
	316, 316, 316, 316, 316, 316, 1265, 1265, 
	1265, 1265, 1265, 316, 304, 304, 304, 304, 
	304, 304, 304, 304, 304, 304, 304, 304, 
	304, 304, 304, 304, 304, 304, 304, 304, 
	304, 304, 304, 304, 304, 304, 304, 304, 
	304, 304, 304, 304, 304, 1253, 304, 304, 
	304, 304, 304, 304, 304, 304, 304, 304, 
	304, 304, 304, 304, 1226, 1226, 1226, 1226, 
	1226, 1226, 1226, 1226, 1226, 1226, 1370, 304, 
	304, 304, 304, 1253, 304, 1226, 1226, 1226, 
	1226, 1226, 1226, 1226, 1226, 1226, 1226, 1226, 
	1226, 1226, 1226, 1226, 1226, 1226, 1226, 1226, 
	1226, 1226, 1226, 1226, 1226, 1226, 1226, 304, 
	304, 304, 304, 1226, 304, 1226, 1226, 1226, 
	1226, 1226, 1226, 1226, 1226, 1226, 1226, 1226, 
	1226, 1226, 1226, 1226, 1226, 1226, 1226, 1226, 
	1226, 1226, 1226, 1226, 1226, 1226, 1226, 304, 
	304, 304, 304, 304, 1226, 1371, 1372, 1372, 
	1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 
	1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 
	1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 
	1372, 1372, 1372, 1372, 1372, 1372, 1372, 1253, 
	1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 
	1372, 1372, 1372, 1372, 1372, 1372, 1226, 1226, 
	1226, 1226, 1226, 1226, 1226, 1226, 1226, 1226, 
	1370, 1372, 1372, 1372, 1372, 1253, 1372, 1226, 
	1226, 1226, 1226, 1373, 1226, 1226, 1226, 1226, 
	1226, 1226, 1226, 1226, 1226, 1226, 1226, 1226, 
	1226, 1226, 1226, 1226, 1226, 1226, 1226, 1226, 
	1226, 1372, 1372, 1372, 1372, 1226, 1372, 1226, 
	1226, 1226, 1226, 1226, 1226, 1226, 1226, 1226, 
	1226, 1226, 1226, 1226, 1226, 1226, 1226, 1226, 
	1226, 1226, 1226, 1226, 1226, 1226, 1226, 1226, 
	1226, 1372, 1372, 1372, 1372, 1372, 1226, 1372, 
	1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 
	1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 
	1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 
	1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 
	1253, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 
	1372, 1372, 1372, 1372, 1372, 1372, 1372, 1226, 
	1226, 1226, 1226, 1226, 1226, 1226, 1226, 1226, 
	1226, 1370, 1372, 1372, 1372, 1372, 1253, 1372, 
	1226, 1226, 1226, 1226, 1226, 1226, 1374, 1226, 
	1226, 1226, 1226, 1226, 1226, 1226, 1226, 1226, 
	1226, 1226, 1226, 1226, 1226, 1226, 1226, 1226, 
	1226, 1226, 1372, 1372, 1372, 1372, 1226, 1372, 
	1226, 1226, 1226, 1226, 1226, 1226, 1226, 1226, 
	1226, 1226, 1226, 1226, 1226, 1226, 1226, 1226, 
	1226, 1226, 1226, 1226, 1226, 1226, 1226, 1226, 
	1226, 1226, 1372, 1372, 1372, 1372, 1372, 1226, 
	1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 
	1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 
	1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 
	1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 
	1372, 1253, 1372, 1372, 1372, 1372, 1372, 1372, 
	1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 
	1226, 1226, 1226, 1226, 1226, 1226, 1226, 1226, 
	1226, 1226, 1370, 1372, 1372, 1372, 1372, 1253, 
	1372, 1226, 1226, 1226, 1226, 1226, 1226, 1226, 
	1226, 1375, 1226, 1226, 1226, 1226, 1226, 1226, 
	1226, 1226, 1226, 1226, 1226, 1226, 1226, 1226, 
	1226, 1226, 1226, 1372, 1372, 1372, 1372, 1226, 
	1372, 1226, 1226, 1226, 1226, 1226, 1226, 1226, 
	1226, 1226, 1226, 1226, 1226, 1226, 1226, 1226, 
	1226, 1226, 1226, 1226, 1226, 1226, 1226, 1226, 
	1226, 1226, 1226, 1372, 1372, 1372, 1372, 1372, 
	1226, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 
	1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 
	1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 
	1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 
	1372, 1372, 1253, 1372, 1372, 1372, 1372, 1372, 
	1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 
	1372, 1226, 1226, 1226, 1226, 1226, 1226, 1226, 
	1226, 1226, 1226, 1370, 1372, 1372, 1372, 1372, 
	1253, 1372, 1226, 1226, 1226, 1226, 1226, 1226, 
	1226, 1226, 1226, 1226, 1226, 1226, 1226, 1376, 
	1226, 1226, 1226, 1226, 1226, 1226, 1226, 1226, 
	1226, 1226, 1226, 1226, 1372, 1372, 1372, 1372, 
	1226, 1372, 1226, 1226, 1226, 1226, 1226, 1226, 
	1226, 1226, 1226, 1226, 1226, 1226, 1226, 1226, 
	1226, 1226, 1226, 1226, 1226, 1226, 1226, 1226, 
	1226, 1226, 1226, 1226, 1372, 1372, 1372, 1372, 
	1372, 1226, 1372, 1372, 1372, 1372, 1372, 1372, 
	1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 
	1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 
	1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 
	1372, 1372, 1372, 1253, 1372, 1372, 1372, 1372, 
	1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 
	1372, 1372, 1226, 1226, 1226, 1226, 1226, 1226, 
	1226, 1226, 1226, 1226, 1370, 1372, 1372, 1372, 
	1372, 1253, 1372, 1226, 1226, 1226, 1226, 1226, 
	1226, 1226, 1226, 1226, 1226, 1226, 1226, 1226, 
	1377, 1226, 1226, 1226, 1226, 1226, 1226, 1226, 
	1226, 1226, 1226, 1226, 1226, 1372, 1372, 1372, 
	1372, 1226, 1372, 1226, 1226, 1226, 1226, 1226, 
	1226, 1226, 1226, 1226, 1226, 1226, 1226, 1226, 
	1226, 1226, 1226, 1226, 1226, 1226, 1226, 1226, 
	1226, 1226, 1226, 1226, 1226, 1372, 1372, 1372, 
	1372, 1372, 1226, 1372, 1372, 1372, 1372, 1372, 
	1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 
	1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 
	1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 
	1372, 1372, 1372, 1372, 1253, 1372, 1372, 1372, 
	1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 
	1372, 1372, 1372, 1226, 1226, 1226, 1226, 1226, 
	1226, 1226, 1226, 1226, 1226, 1370, 1372, 1372, 
	1372, 1372, 1253, 1372, 1226, 1226, 1226, 1376, 
	1226, 1226, 1226, 1226, 1226, 1226, 1226, 1226, 
	1226, 1226, 1226, 1226, 1226, 1226, 1226, 1226, 
	1226, 1226, 1226, 1226, 1226, 1226, 1372, 1372, 
	1372, 1372, 1226, 1372, 1226, 1226, 1226, 1226, 
	1226, 1226, 1226, 1226, 1226, 1226, 1226, 1226, 
	1226, 1226, 1226, 1226, 1226, 1226, 1226, 1226, 
	1226, 1226, 1226, 1226, 1226, 1226, 1372, 1372, 
	1372, 1372, 1372, 1226, 1378, 1380, 1379, 1381, 
	1382, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1253, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1383, 1383, 1383, 1383, 1383, 
	1253, 1383, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1383, 1383, 1383, 1383, 
	1384, 1383, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1383, 1383, 1383, 1383, 
	1383, 1200, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1253, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1383, 1383, 1383, 1383, 
	1383, 1253, 1383, 1200, 1200, 1200, 1200, 1385, 
	1386, 1200, 1200, 1200, 1200, 1200, 1387, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1383, 1383, 1383, 
	1383, 1200, 1383, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1383, 1383, 1383, 
	1383, 1383, 1200, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1253, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1383, 1383, 1383, 
	1383, 1383, 1253, 1383, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1388, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1383, 1383, 
	1383, 1383, 1200, 1383, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1383, 1383, 
	1383, 1383, 1383, 1200, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1253, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1383, 1383, 
	1383, 1383, 1383, 1253, 1383, 1200, 1200, 1389, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1383, 
	1383, 1383, 1383, 1200, 1383, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1383, 
	1383, 1383, 1383, 1383, 1200, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1253, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1383, 
	1383, 1383, 1383, 1383, 1253, 1383, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1390, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1383, 1383, 1383, 1383, 1200, 1383, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1383, 1383, 1383, 1383, 1383, 1200, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1253, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1383, 1383, 1383, 1383, 1383, 1253, 1383, 1200, 
	1200, 1200, 1391, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1383, 1383, 1383, 1383, 1200, 1383, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1383, 1383, 1383, 1383, 1383, 1200, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1253, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1383, 1383, 1383, 1383, 1383, 1253, 1383, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1392, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1383, 1383, 1383, 1383, 1200, 1383, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1383, 1383, 1383, 1383, 1383, 1200, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1253, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1383, 1383, 1383, 1383, 1383, 1253, 
	1383, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1393, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1383, 1383, 1383, 1383, 1200, 
	1383, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1383, 1383, 1383, 1383, 1383, 
	1200, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1253, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1383, 1383, 1383, 1383, 1383, 
	1253, 1383, 1200, 1200, 1200, 1200, 1200, 1200, 
	1394, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1383, 1383, 1383, 1383, 
	1200, 1383, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1383, 1383, 1383, 1383, 
	1383, 1200, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1253, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1383, 1383, 1383, 1383, 
	1383, 1253, 1383, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1383, 1383, 1383, 
	1383, 1395, 1383, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1383, 1383, 1383, 
	1383, 1383, 1200, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1253, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1383, 1383, 1383, 
	1383, 1383, 1253, 1383, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1383, 1383, 
	1383, 1383, 1396, 1383, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1383, 1383, 
	1383, 1383, 1383, 1200, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1253, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1383, 1383, 
	1383, 1383, 1383, 1253, 1383, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1397, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1383, 
	1383, 1383, 1383, 1200, 1383, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1383, 
	1383, 1383, 1383, 1383, 1200, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1253, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1383, 
	1383, 1383, 1383, 1383, 1253, 1383, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1398, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1383, 1383, 1383, 1383, 1200, 1383, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1383, 1383, 1383, 1383, 1383, 1200, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1253, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1383, 1383, 1383, 1383, 1383, 1253, 1383, 1200, 
	1200, 1200, 1200, 1399, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1383, 1383, 1383, 1383, 1200, 1383, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1383, 1383, 1383, 1383, 1383, 1200, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1253, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1383, 1383, 1383, 1383, 1383, 1253, 1383, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1383, 1383, 1383, 1383, 1400, 1383, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1383, 1383, 1383, 1383, 1383, 1200, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1253, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1383, 1383, 1383, 1383, 1383, 1253, 
	1383, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1383, 1383, 1383, 1383, 1401, 
	1383, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1383, 1383, 1383, 1383, 1383, 
	1200, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1253, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1383, 1383, 1383, 1383, 1383, 
	1253, 1383, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1402, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1383, 1383, 1383, 1383, 
	1200, 1383, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1383, 1383, 1383, 1383, 
	1383, 1200, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1253, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1383, 1383, 1383, 1383, 
	1383, 1253, 1383, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1398, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1383, 1383, 1383, 
	1383, 1200, 1383, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1383, 1383, 1383, 
	1383, 1383, 1200, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1253, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1383, 1383, 1383, 
	1383, 1383, 1253, 1383, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1383, 1383, 
	1383, 1383, 1200, 1383, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1403, 
	1200, 1404, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1383, 1383, 
	1383, 1383, 1383, 1200, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1253, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1383, 1383, 
	1383, 1383, 1383, 1253, 1383, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1383, 
	1383, 1383, 1383, 1200, 1383, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1405, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1383, 
	1383, 1383, 1383, 1383, 1200, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1253, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1383, 
	1383, 1383, 1383, 1383, 1253, 1383, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1383, 1383, 1383, 1383, 1200, 1383, 1406, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1383, 1383, 1383, 1383, 1383, 1200, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1253, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1383, 1383, 1383, 1383, 1383, 1253, 1383, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1383, 1383, 1383, 1383, 1200, 1383, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1407, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1383, 1383, 1383, 1383, 1383, 1200, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1253, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1383, 1383, 1383, 1383, 1383, 1253, 1383, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1383, 1383, 1383, 1383, 1200, 1383, 
	1200, 1200, 1200, 1408, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1383, 1383, 1383, 1383, 1383, 1200, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1253, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1383, 1383, 1383, 1383, 1383, 1253, 
	1383, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1383, 1383, 1383, 1383, 1200, 
	1383, 1200, 1200, 1200, 1200, 1409, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1410, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1383, 1383, 1383, 1383, 1383, 
	1200, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1253, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1383, 1383, 1383, 1383, 1383, 
	1253, 1383, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1383, 1383, 1383, 1383, 
	1200, 1383, 1200, 1200, 1200, 1200, 1200, 1200, 
	1411, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1383, 1383, 1383, 1383, 
	1383, 1200, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1253, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1383, 1383, 1383, 1383, 
	1383, 1253, 1383, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1383, 1383, 1383, 
	1383, 1200, 1383, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1412, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1383, 1383, 1383, 
	1383, 1383, 1200, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1253, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1383, 1383, 1383, 
	1383, 1383, 1253, 1383, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1383, 1383, 
	1383, 1383, 1200, 1383, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1408, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1383, 1383, 
	1383, 1383, 1383, 1200, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1253, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1383, 1383, 
	1383, 1383, 1383, 1253, 1383, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1383, 
	1383, 1383, 1383, 1200, 1383, 1200, 1200, 1200, 
	1200, 1413, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1383, 
	1383, 1383, 1383, 1383, 1200, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1253, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1383, 
	1383, 1383, 1383, 1383, 1253, 1383, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1383, 1383, 1383, 1383, 1200, 1383, 1414, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1383, 1383, 1383, 1383, 1383, 1200, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1253, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1383, 1383, 1383, 1383, 1383, 1253, 1383, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1383, 1383, 1383, 1383, 1200, 1383, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1415, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1383, 1383, 1383, 1383, 1383, 1200, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1253, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1383, 1383, 1383, 1383, 1383, 1253, 1383, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1383, 1383, 1383, 1383, 1200, 1383, 
	1416, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1417, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1383, 1383, 1383, 1383, 1383, 1200, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1253, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1383, 1383, 1383, 1383, 1383, 1253, 
	1383, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1383, 1383, 1383, 1383, 1200, 
	1383, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1418, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1383, 1383, 1383, 1383, 1383, 
	1200, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1253, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1383, 1383, 1383, 1383, 1383, 
	1253, 1383, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1383, 1383, 1383, 1383, 
	1200, 1383, 1200, 1200, 1200, 1200, 1408, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1383, 1383, 1383, 1383, 
	1383, 1200, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1253, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1383, 1383, 1383, 1383, 
	1383, 1253, 1383, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1383, 1383, 1383, 
	1383, 1200, 1383, 1419, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1383, 1383, 1383, 
	1383, 1383, 1200, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1253, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1383, 1383, 1383, 
	1383, 1383, 1253, 1383, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1383, 1383, 
	1383, 1383, 1200, 1383, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1420, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1383, 1383, 
	1383, 1383, 1383, 1200, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1253, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1383, 1383, 
	1383, 1383, 1383, 1253, 1383, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1383, 
	1383, 1383, 1383, 1200, 1383, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1421, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1383, 
	1383, 1383, 1383, 1383, 1200, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 318, 319, 
	318, 318, 318, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 318, 1253, 1422, 
	320, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1422, 
	1422, 321, 1422, 1422, 1253, 1422, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1422, 322, 1422, 1422, 1200, 1422, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1422, 1422, 1422, 1422, 1422, 1200, 335, 336, 
	335, 335, 335, 334, 334, 334, 334, 334, 
	334, 334, 334, 334, 334, 334, 334, 334, 
	334, 334, 334, 334, 334, 335, 334, 334, 
	337, 334, 334, 334, 334, 334, 334, 334, 
	334, 334, 334, 334, 334, 334, 334, 334, 
	334, 334, 334, 334, 334, 334, 334, 334, 
	334, 340, 334, 334, 334, 334, 334, 334, 
	334, 334, 334, 334, 334, 334, 334, 334, 
	334, 334, 334, 334, 334, 334, 334, 334, 
	334, 334, 334, 334, 334, 334, 334, 334, 
	334, 339, 334, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1253, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1383, 1383, 1383, 
	1383, 1383, 1253, 1383, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1383, 1383, 
	1383, 1383, 1200, 1383, 1200, 1200, 1200, 1200, 
	1424, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1425, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1383, 1383, 
	1383, 1383, 1383, 1200, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1253, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1383, 1383, 
	1383, 1383, 1383, 1253, 1383, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1383, 
	1383, 1383, 1383, 1200, 1383, 1200, 1200, 1200, 
	1200, 1200, 1426, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1383, 
	1383, 1383, 1383, 1383, 1200, 1427, 1427, 1427, 
	1427, 1427, 1427, 1427, 1427, 1427, 1427, 1427, 
	1427, 1427, 1427, 1427, 1427, 1427, 1427, 1427, 
	1427, 1427, 1427, 1427, 1427, 1427, 1427, 1427, 
	1427, 1427, 1427, 1427, 1427, 1427, 1253, 1427, 
	1427, 1427, 1427, 1427, 1427, 1427, 1427, 1427, 
	1427, 1427, 1427, 1427, 1427, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1427, 
	1427, 1427, 1427, 1427, 1253, 1427, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1427, 1427, 1427, 1427, 1200, 1427, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1428, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1427, 1427, 1427, 1427, 1427, 1200, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1253, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1383, 1383, 1383, 1383, 1383, 1253, 1383, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1383, 1383, 1383, 1383, 1200, 1383, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1429, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1383, 1383, 1383, 1383, 1383, 1200, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1253, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1383, 1383, 1383, 1383, 1383, 1253, 1383, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1383, 1383, 1383, 1383, 1200, 1383, 
	1200, 1200, 1200, 1200, 1430, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1383, 1383, 1383, 1383, 1383, 1200, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1253, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1383, 1383, 1383, 1383, 1383, 1253, 
	1383, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1383, 1383, 1383, 1383, 1200, 
	1383, 1200, 1200, 1200, 1431, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1383, 1383, 1383, 1383, 1383, 
	1200, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1253, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1383, 1383, 1383, 1383, 1383, 
	1432, 1383, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1383, 1383, 1383, 1383, 
	1200, 1383, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1383, 1383, 1383, 1383, 
	1383, 1200, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1253, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1383, 1383, 1383, 1383, 
	1383, 1253, 1383, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1383, 1383, 1383, 
	1383, 1200, 1383, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1433, 1200, 
	1434, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1383, 1383, 1383, 
	1383, 1383, 1200, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1253, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1383, 1383, 1383, 
	1383, 1383, 1253, 1383, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1383, 1383, 
	1383, 1383, 1200, 1383, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1435, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1383, 1383, 
	1383, 1383, 1383, 1200, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1253, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1383, 1383, 
	1383, 1383, 1383, 1253, 1383, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1383, 
	1383, 1383, 1383, 1200, 1383, 1200, 1200, 1200, 
	1200, 1408, 1200, 1200, 1200, 1436, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1383, 
	1383, 1383, 1383, 1383, 1200, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1253, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1383, 
	1383, 1383, 1383, 1383, 1253, 1383, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1383, 1383, 1383, 1383, 1200, 1383, 1200, 1200, 
	1200, 1200, 1200, 1408, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1383, 1383, 1383, 1383, 1383, 1200, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1253, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1383, 1383, 1383, 1383, 1383, 1253, 1383, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1383, 1383, 1383, 1383, 1200, 1383, 1200, 
	1200, 1200, 1401, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1437, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1383, 1383, 1383, 1383, 1383, 1200, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1253, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1383, 1383, 1383, 1383, 1383, 1253, 1383, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1383, 1383, 1383, 1383, 1200, 1383, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1438, 1200, 1200, 1200, 
	1200, 1200, 1383, 1383, 1383, 1383, 1383, 1200, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1253, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1383, 1383, 1383, 1383, 1383, 1253, 
	1383, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1383, 1383, 1383, 1383, 1200, 
	1383, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1418, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1383, 1383, 1383, 1383, 1383, 
	1200, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1253, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1383, 1383, 1383, 1383, 1383, 
	1253, 1383, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1383, 1383, 1383, 1383, 
	1200, 1383, 1439, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1242, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1383, 1383, 1383, 1383, 
	1383, 1200, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1253, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1383, 1383, 1383, 1383, 
	1383, 1253, 1383, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1383, 1383, 1383, 
	1383, 1200, 1383, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1440, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1383, 1383, 1383, 
	1383, 1383, 1200, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1253, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1383, 1383, 1383, 
	1383, 1383, 1253, 1383, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1383, 1383, 
	1383, 1383, 1200, 1383, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1441, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1383, 1383, 
	1383, 1383, 1383, 1200, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1253, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1383, 1383, 
	1383, 1383, 1383, 1253, 1383, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1383, 
	1383, 1383, 1383, 1200, 1383, 1200, 1200, 1200, 
	1200, 1401, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1383, 
	1383, 1383, 1383, 1383, 1200, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1253, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1383, 
	1383, 1383, 1383, 1383, 1253, 1383, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1383, 1383, 1383, 1383, 1200, 1383, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1408, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1383, 1383, 1383, 1383, 1383, 1200, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1253, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1383, 1383, 1383, 1383, 1383, 1253, 1383, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1383, 1383, 1383, 1383, 1200, 1383, 1200, 
	1200, 1200, 1200, 1200, 1442, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1408, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1383, 1383, 1383, 1383, 1383, 1200, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1253, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1383, 1383, 1383, 1383, 1383, 1253, 1383, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1383, 1383, 1383, 1383, 1200, 1383, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1443, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1383, 1383, 1383, 1383, 1383, 1200, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1253, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1383, 1383, 1383, 1383, 1383, 1253, 
	1383, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1383, 1383, 1383, 1383, 1200, 
	1383, 1200, 1200, 1200, 1444, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1383, 1383, 1383, 1383, 1383, 
	1200, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1253, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1383, 1383, 1383, 1383, 1383, 
	1253, 1383, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1383, 1383, 1383, 1383, 
	1200, 1383, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1445, 1200, 
	1200, 1200, 1200, 1200, 1383, 1383, 1383, 1383, 
	1383, 1200, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1253, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1383, 1383, 1383, 1383, 
	1383, 1253, 1383, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1383, 1383, 1383, 
	1383, 1200, 1383, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1418, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1383, 1383, 1383, 
	1383, 1383, 1200, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1253, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1383, 1383, 1383, 
	1383, 1383, 1253, 1383, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1383, 1383, 
	1383, 1383, 1200, 1383, 1200, 1200, 1200, 1200, 
	1446, 1200, 1200, 1200, 1447, 1200, 1200, 1200, 
	1200, 1200, 1448, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1383, 1383, 
	1383, 1383, 1383, 1200, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1253, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1383, 1383, 
	1383, 1383, 1383, 1253, 1383, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1383, 
	1383, 1383, 1383, 1200, 1383, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1449, 1200, 1200, 1383, 
	1383, 1383, 1383, 1383, 1200, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1253, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1383, 
	1383, 1383, 1383, 1383, 1253, 1383, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1383, 1383, 1383, 1383, 1200, 1383, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1415, 1200, 1200, 1200, 1200, 1200, 1200, 
	1383, 1383, 1383, 1383, 1383, 1200, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1253, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1383, 1383, 1383, 1383, 1383, 1253, 1383, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1383, 1383, 1383, 1383, 1200, 1383, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1401, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1383, 1383, 1383, 1383, 1383, 1200, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1253, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1383, 1383, 1383, 1383, 1383, 1253, 1383, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1383, 1383, 1383, 1383, 1200, 1383, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1450, 1200, 1200, 1200, 1200, 
	1200, 1200, 1383, 1383, 1383, 1383, 1383, 1200, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1253, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1383, 1383, 1383, 1383, 1383, 1253, 
	1383, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1383, 1383, 1383, 1383, 1200, 
	1383, 1200, 1200, 1200, 1200, 1451, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1383, 1383, 1383, 1383, 1383, 
	1200, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1253, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1383, 1383, 1383, 1383, 1383, 
	1253, 1383, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1383, 1383, 1383, 1383, 
	1200, 1383, 1200, 1200, 1200, 1452, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1453, 1454, 1200, 1200, 
	1200, 1200, 1200, 1200, 1383, 1383, 1383, 1383, 
	1383, 1200, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1253, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1383, 1383, 1383, 1383, 
	1383, 1253, 1383, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1383, 1383, 1383, 
	1383, 1200, 1383, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1401, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1383, 1383, 1383, 
	1383, 1383, 1200, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1253, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1383, 1383, 1383, 
	1383, 1383, 1253, 1383, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1383, 1383, 
	1383, 1383, 1200, 1383, 1200, 1200, 1455, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1383, 1383, 
	1383, 1383, 1383, 1200, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1253, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1383, 1383, 
	1383, 1383, 1383, 1253, 1383, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1383, 
	1383, 1383, 1383, 1200, 1383, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1456, 1200, 1200, 1200, 1200, 1200, 1383, 
	1383, 1383, 1383, 1383, 1200, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1253, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1383, 
	1383, 1383, 1383, 1383, 1253, 1383, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1383, 1383, 1383, 1383, 1200, 1383, 1200, 1200, 
	1200, 1200, 1442, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1383, 1383, 1383, 1383, 1383, 1200, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1253, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1383, 1383, 1383, 1383, 1383, 1253, 1383, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1383, 1383, 1383, 1383, 1200, 1383, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1457, 1200, 1200, 1458, 1200, 1200, 1200, 1200, 
	1200, 1383, 1383, 1383, 1383, 1383, 1200, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1253, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1383, 1383, 1383, 1383, 1383, 1253, 1383, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1383, 1383, 1383, 1383, 1200, 1383, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1401, 1200, 1383, 1383, 1383, 1383, 1383, 1200, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1253, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1383, 1383, 1383, 1383, 1383, 1253, 
	1383, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1383, 1383, 1383, 1383, 1200, 
	1383, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1459, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1383, 1383, 1383, 1383, 1383, 
	1200, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1253, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1383, 1383, 1383, 1383, 1383, 
	1253, 1383, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1383, 1383, 1383, 1383, 
	1200, 1383, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1415, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1383, 1383, 1383, 1383, 
	1383, 1200, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1253, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1383, 1383, 1383, 1383, 
	1383, 1253, 1383, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1383, 1383, 1383, 
	1383, 1200, 1383, 1200, 1200, 1200, 1200, 1460, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1461, 
	1200, 1200, 1200, 1200, 1200, 1383, 1383, 1383, 
	1383, 1383, 1200, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1253, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1383, 1383, 1383, 
	1383, 1383, 1253, 1383, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1383, 1383, 
	1383, 1383, 1200, 1383, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1462, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1383, 1383, 
	1383, 1383, 1383, 1200, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1253, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1383, 1383, 
	1383, 1383, 1383, 1253, 1383, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1383, 
	1383, 1383, 1383, 1200, 1383, 1200, 1200, 1200, 
	1200, 1200, 1401, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1383, 
	1383, 1383, 1383, 1383, 1200, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1253, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1383, 
	1383, 1383, 1383, 1383, 1253, 1383, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1383, 1383, 1383, 1383, 1200, 1383, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1463, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1383, 1383, 1383, 1383, 1383, 1200, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1253, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1383, 1383, 1383, 1383, 1383, 1253, 1383, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1383, 1383, 1383, 1383, 1200, 1383, 1200, 
	1200, 1200, 1200, 1464, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1383, 1383, 1383, 1383, 1383, 1200, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1253, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1383, 1383, 1383, 1383, 1383, 1253, 1383, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1383, 1383, 1383, 1383, 1200, 1383, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1450, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1383, 1383, 1383, 1383, 1383, 1200, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1253, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1383, 1383, 1383, 1383, 1383, 1253, 
	1383, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1383, 1383, 1383, 1383, 1200, 
	1383, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1465, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1466, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1383, 1383, 1383, 1383, 1383, 
	1200, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1253, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1383, 1383, 1383, 1383, 1383, 
	1253, 1383, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1383, 1383, 1383, 1383, 
	1200, 1383, 1200, 1200, 1200, 1200, 1412, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1383, 1383, 1383, 1383, 
	1383, 1200, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1253, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1383, 1383, 1383, 1383, 
	1383, 1253, 1383, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1383, 1383, 1383, 
	1383, 1200, 1383, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1441, 
	1200, 1200, 1200, 1200, 1200, 1383, 1383, 1383, 
	1383, 1383, 1200, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1253, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1383, 1383, 1383, 
	1383, 1383, 1253, 1383, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1383, 1383, 
	1383, 1383, 1200, 1383, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1467, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1383, 1383, 
	1383, 1383, 1383, 1200, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1253, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1383, 1383, 
	1383, 1383, 1383, 1253, 1383, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1383, 
	1383, 1383, 1383, 1200, 1383, 1200, 1200, 1200, 
	1468, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1469, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1470, 1200, 1200, 1200, 1200, 1200, 1200, 1383, 
	1383, 1383, 1383, 1383, 1200, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1253, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1383, 
	1383, 1383, 1383, 1383, 1253, 1383, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1383, 1383, 1383, 1383, 1200, 1383, 1200, 1200, 
	1200, 1200, 1471, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1383, 1383, 1383, 1383, 1383, 1200, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1253, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1383, 1383, 1383, 1383, 1383, 1253, 1383, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1383, 1383, 1383, 1383, 1200, 1383, 1200, 
	1200, 1200, 1200, 1200, 1407, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1383, 1383, 1383, 1383, 1383, 1200, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1253, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1383, 1383, 1383, 1383, 1383, 1253, 1383, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1383, 1383, 1383, 1383, 1200, 1383, 
	1200, 1200, 1200, 1200, 1472, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1383, 1383, 1383, 1383, 1383, 1200, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1253, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1383, 1383, 1383, 1383, 1383, 1253, 
	1383, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1383, 1383, 1383, 1383, 1200, 
	1383, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1473, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1383, 1383, 1383, 1383, 1383, 
	1200, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1253, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1383, 1383, 1383, 1383, 1383, 
	1253, 1383, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1383, 1383, 1383, 1383, 
	1200, 1383, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1442, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1383, 1383, 1383, 1383, 
	1383, 1200, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1253, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1383, 1383, 1383, 1383, 
	1383, 1253, 1383, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1383, 1383, 1383, 
	1383, 1200, 1383, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1474, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1383, 1383, 1383, 
	1383, 1383, 1200, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1253, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1383, 1383, 1383, 
	1383, 1383, 1253, 1383, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1383, 1383, 
	1383, 1383, 1200, 1383, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1442, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1383, 1383, 
	1383, 1383, 1383, 1200, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1253, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1383, 1383, 
	1383, 1383, 1383, 1253, 1383, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1383, 
	1383, 1383, 1383, 1200, 1383, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1475, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1383, 
	1383, 1383, 1383, 1383, 1200, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1253, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1383, 
	1383, 1383, 1383, 1383, 1253, 1383, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1383, 1383, 1383, 1383, 1200, 1383, 1200, 1200, 
	1200, 1200, 1412, 1200, 1200, 1200, 1476, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1383, 1383, 1383, 1383, 1383, 1200, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1253, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1383, 1383, 1383, 1383, 1383, 1253, 1383, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1383, 1383, 1383, 1383, 1200, 1383, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1477, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1383, 1383, 1383, 1383, 1383, 1200, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1253, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1383, 1383, 1383, 1383, 1383, 1253, 1383, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1383, 1383, 1383, 1383, 1200, 1383, 
	1200, 1200, 1200, 1200, 1442, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1383, 1383, 1383, 1383, 1383, 1200, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1253, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1383, 1383, 1383, 1383, 1383, 1253, 
	1383, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1383, 1383, 1383, 1383, 1200, 
	1383, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1478, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1383, 1383, 1383, 1383, 1383, 
	1200, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1253, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1383, 1383, 1383, 1383, 1383, 
	1253, 1383, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1383, 1383, 1383, 1383, 
	1200, 1383, 1200, 1200, 1200, 1200, 1479, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1383, 1383, 1383, 1383, 
	1383, 1200, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1253, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1383, 1383, 1383, 1383, 
	1383, 1253, 1383, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1383, 1383, 1383, 
	1383, 1200, 1383, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1480, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1383, 1383, 1383, 
	1383, 1383, 1200, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1253, 1383, 1383, 1383, 
	1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383, 
	1383, 1383, 1383, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1383, 1383, 1383, 
	1383, 1383, 1253, 1383, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1383, 1383, 
	1383, 1383, 1200, 1383, 1200, 1200, 1200, 1450, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1383, 1383, 
	1383, 1383, 1383, 1200, 1481, 1269, 1259, 1259, 
	1259, 1259, 1259, 1259, 1259, 1259, 1259, 1259, 
	1259, 1259, 1259, 1259, 1259, 1259, 1259, 1259, 
	1259, 1259, 1259, 1259, 1259, 1259, 1259, 1259, 
	1259, 1259, 1259, 1259, 1259, 1259, 1259, 1259, 
	1259, 1259, 1259, 1259, 1259, 1259, 1259, 1259, 
	1259, 1259, 1259, 1259, 1259, 1259, 1259, 1259, 
	1259, 1259, 1259, 1259, 1259, 1259, 1259, 1259, 
	1259, 1259, 1259, 1259, 1209, 1259, 1482, 1484, 
	1483, 1484, 1484, 1484, 1483, 1483, 1483, 1483, 
	1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 
	1483, 1483, 1483, 1483, 1483, 1483, 1484, 1483, 
	1483, 1485, 1483, 1483, 1486, 1483, 1483, 1483, 
	1483, 1483, 1483, 1483, 348, 1483, 1483, 1483, 
	1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 
	1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 
	1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 
	1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 
	1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 
	1483, 1483, 1487, 1483, 344, 345, 344, 344, 
	344, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 
	1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 
	1488, 1488, 1488, 344, 1488, 1488, 346, 1488, 
	1488, 347, 1488, 1488, 1488, 1488, 1488, 1488, 
	1488, 348, 1488, 1488, 1488, 1488, 1488, 1488, 
	1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 
	1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 
	1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 
	1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 
	1488, 1488, 1488, 1488, 1488, 1488, 1488, 349, 
	1488, 351, 1489, 351, 351, 351, 1489, 1489, 
	1489, 1489, 1489, 1489, 1489, 1489, 1489, 1489, 
	1489, 1489, 1489, 1489, 1489, 1489, 1489, 1489, 
	351, 1489, 1489, 346, 1489, 1489, 1489, 1489, 
	1489, 1489, 1489, 1489, 1489, 1489, 1489, 1489, 
	1489, 1489, 1489, 1489, 1489, 1489, 1489, 1489, 
	1489, 1489, 1489, 1489, 1489, 1489, 1489, 1489, 
	1489, 1489, 1489, 1489, 1489, 1489, 1489, 1489, 
	1489, 1489, 1489, 1489, 1489, 1489, 1489, 1489, 
	1489, 1489, 1489, 1489, 1489, 1489, 1489, 1489, 
	1489, 1489, 1489, 1489, 349, 1489, 354, 353, 
	359, 1488, 357, 1488, 1491, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1492, 
	1490, 1491, 1490, 1491, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1494, 1490, 
	1491, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1495, 1490, 1491, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1490, 1490, 1490, 1490, 1490, 1490, 1490, 1490, 
	1496, 1490, 1498, 1496, 0
]

class << self
	attr_accessor :_lex_trans_targs
	private :_lex_trans_targs, :_lex_trans_targs=
end
self._lex_trans_targs = [
	185, 2, 3, 4, 191, 6, 7, 8, 
	9, 10, 185, 185, 194, 197, 194, 12, 
	198, 199, 14, 194, 206, 207, 210, 211, 
	217, 212, 213, 214, 19, 215, 216, 219, 
	221, 222, 223, 224, 225, 25, 18, 208, 
	209, 27, 248, 249, 251, 253, 251, 30, 
	254, 255, 32, 251, 262, 263, 266, 267, 
	273, 268, 269, 270, 37, 271, 272, 275, 
	277, 278, 279, 280, 281, 43, 36, 264, 
	265, 45, 304, 305, 312, 314, 312, 48, 
	315, 316, 50, 318, 321, 318, 52, 322, 
	323, 54, 329, 328, 0, 56, 330, 331, 
	58, 332, 333, 333, 333, 333, 446, 61, 
	62, 63, 446, 474, 64, 65, 474, 474, 
	478, 478, 69, 64, 70, 476, 477, 479, 
	480, 478, 474, 481, 482, 484, 66, 67, 
	485, 486, 68, 478, 71, 72, 77, 84, 
	488, 489, 70, 476, 477, 479, 480, 478, 
	474, 481, 482, 484, 66, 67, 485, 486, 
	68, 71, 72, 77, 84, 488, 489, 487, 
	73, 74, 75, 76, 78, 79, 82, 80, 
	81, 83, 85, 86, 474, 88, 89, 90, 
	92, 95, 93, 94, 96, 98, 505, 505, 
	505, 506, 100, 508, 101, 509, 102, 506, 
	100, 508, 101, 509, 543, 103, 543, 104, 
	105, 103, 543, 104, 543, 543, 543, 108, 
	109, 110, 111, 554, 543, 543, 559, 543, 
	114, 115, 116, 543, 119, 114, 115, 116, 
	543, 119, 117, 117, 115, 116, 565, 118, 
	117, 117, 115, 116, 565, 118, 115, 543, 
	581, 543, 121, 582, 588, 125, 597, 598, 
	130, 131, 125, 126, 596, 126, 596, 543, 
	127, 128, 129, 599, 132, 543, 613, 614, 
	617, 618, 624, 619, 620, 621, 137, 622, 
	623, 626, 628, 629, 630, 631, 632, 143, 
	136, 615, 616, 145, 668, 669, 147, 545, 
	106, 547, 149, 150, 671, 773, 152, 153, 
	154, 773, 781, 781, 781, 157, 803, 802, 
	781, 805, 807, 781, 162, 163, 164, 811, 
	781, 166, 167, 822, 791, 844, 170, 171, 
	172, 176, 177, 170, 171, 172, 176, 177, 
	173, 173, 171, 172, 174, 175, 173, 173, 
	171, 172, 174, 175, 892, 171, 781, 961, 
	178, 963, 180, 184, 961, 182, 961, 179, 
	961, 181, 963, 181, 963, 183, 963, 961, 
	185, 185, 186, 187, 188, 190, 192, 193, 
	185, 185, 185, 189, 185, 189, 185, 1, 
	185, 185, 185, 5, 194, 194, 195, 194, 
	196, 200, 194, 194, 11, 13, 194, 194, 
	194, 194, 201, 202, 203, 15, 21, 26, 
	226, 28, 194, 194, 194, 204, 205, 194, 
	16, 194, 194, 194, 17, 194, 194, 194, 
	20, 218, 220, 22, 194, 194, 23, 24, 
	194, 227, 231, 228, 229, 230, 194, 194, 
	232, 233, 236, 238, 247, 234, 235, 194, 
	237, 239, 241, 240, 194, 242, 243, 244, 
	245, 246, 194, 194, 194, 250, 251, 251, 
	251, 252, 256, 251, 29, 31, 251, 251, 
	251, 251, 257, 258, 259, 33, 39, 44, 
	282, 46, 251, 251, 251, 260, 261, 251, 
	34, 251, 251, 251, 35, 251, 251, 251, 
	38, 274, 276, 40, 251, 251, 41, 42, 
	251, 283, 287, 284, 285, 286, 251, 251, 
	288, 289, 292, 294, 303, 290, 291, 251, 
	293, 295, 297, 296, 251, 298, 299, 300, 
	301, 302, 251, 251, 251, 306, 307, 307, 
	308, 307, 309, 307, 307, 307, 310, 310, 
	310, 311, 310, 310, 310, 312, 312, 312, 
	313, 312, 47, 49, 312, 312, 312, 317, 
	317, 317, 318, 318, 319, 318, 320, 318, 
	318, 51, 53, 318, 318, 318, 324, 324, 
	325, 324, 324, 326, 327, 326, 55, 57, 
	328, 328, 328, 334, 333, 333, 335, 336, 
	337, 338, 340, 343, 344, 345, 346, 333, 
	347, 348, 350, 352, 353, 354, 358, 360, 
	361, 362, 378, 383, 390, 395, 402, 409, 
	412, 413, 417, 411, 421, 429, 433, 435, 
	440, 442, 445, 333, 333, 333, 333, 333, 
	333, 339, 333, 339, 333, 341, 59, 342, 
	333, 60, 333, 333, 349, 351, 333, 355, 
	356, 357, 353, 359, 333, 363, 364, 373, 
	376, 365, 366, 367, 368, 369, 370, 371, 
	372, 334, 374, 375, 377, 379, 382, 380, 
	381, 384, 387, 385, 386, 388, 389, 391, 
	393, 392, 394, 396, 397, 333, 398, 399, 
	400, 401, 333, 403, 406, 404, 405, 407, 
	408, 410, 414, 415, 416, 418, 420, 419, 
	422, 423, 424, 426, 425, 427, 428, 430, 
	431, 432, 434, 436, 437, 438, 439, 441, 
	443, 444, 447, 446, 446, 448, 449, 451, 
	446, 446, 446, 450, 446, 450, 452, 446, 
	454, 453, 453, 457, 458, 459, 460, 453, 
	462, 463, 464, 465, 467, 469, 470, 471, 
	472, 473, 453, 455, 453, 456, 453, 453, 
	453, 453, 453, 461, 453, 461, 466, 453, 
	468, 453, 474, 474, 475, 490, 491, 477, 
	493, 494, 481, 495, 496, 497, 498, 499, 
	501, 502, 503, 504, 474, 474, 474, 474, 
	474, 474, 478, 483, 474, 474, 474, 474, 
	474, 474, 474, 474, 474, 492, 474, 492, 
	474, 474, 474, 474, 500, 474, 87, 91, 
	97, 505, 507, 510, 99, 505, 505, 506, 
	511, 511, 512, 513, 515, 517, 518, 511, 
	511, 514, 511, 514, 511, 516, 511, 511, 
	511, 520, 519, 519, 521, 522, 523, 525, 
	527, 528, 533, 540, 519, 519, 519, 519, 
	524, 519, 524, 519, 526, 519, 519, 520, 
	529, 530, 531, 532, 534, 535, 538, 536, 
	537, 539, 541, 542, 544, 543, 552, 553, 
	555, 556, 558, 560, 561, 562, 564, 566, 
	567, 569, 570, 595, 601, 602, 603, 671, 
	672, 673, 674, 675, 563, 677, 694, 699, 
	706, 711, 713, 719, 722, 723, 727, 721, 
	731, 742, 746, 749, 757, 761, 764, 765, 
	543, 103, 104, 543, 106, 546, 543, 543, 
	548, 550, 551, 543, 549, 543, 543, 543, 
	543, 543, 107, 543, 543, 543, 543, 543, 
	557, 543, 557, 543, 543, 112, 543, 543, 
	113, 543, 543, 563, 543, 568, 543, 543, 
	543, 571, 580, 543, 120, 583, 584, 585, 
	543, 586, 122, 589, 590, 123, 593, 594, 
	543, 572, 574, 543, 573, 543, 543, 575, 
	578, 579, 543, 576, 577, 543, 543, 543, 
	543, 543, 543, 587, 543, 581, 591, 592, 
	543, 591, 543, 581, 591, 124, 600, 543, 
	543, 543, 604, 543, 543, 543, 605, 607, 
	543, 606, 543, 606, 543, 608, 609, 610, 
	133, 139, 144, 633, 146, 543, 543, 543, 
	611, 612, 543, 134, 543, 543, 543, 135, 
	543, 543, 543, 138, 625, 627, 140, 543, 
	543, 141, 142, 543, 634, 638, 635, 636, 
	637, 543, 543, 639, 640, 643, 654, 667, 
	641, 642, 543, 644, 645, 646, 648, 647, 
	543, 649, 650, 651, 652, 653, 655, 662, 
	656, 657, 658, 659, 660, 661, 663, 664, 
	665, 666, 543, 543, 543, 670, 148, 151, 
	543, 676, 678, 679, 689, 692, 680, 681, 
	682, 683, 684, 685, 686, 687, 688, 690, 
	691, 693, 695, 698, 696, 697, 700, 703, 
	701, 702, 704, 705, 707, 709, 708, 710, 
	712, 714, 716, 715, 717, 718, 720, 688, 
	724, 725, 726, 728, 730, 729, 732, 733, 
	734, 739, 735, 736, 737, 543, 544, 545, 
	106, 738, 550, 740, 741, 743, 744, 745, 
	747, 748, 750, 751, 752, 755, 753, 754, 
	756, 758, 759, 760, 762, 763, 543, 563, 
	766, 766, 767, 768, 769, 771, 766, 766, 
	766, 770, 766, 770, 766, 772, 766, 774, 
	773, 773, 775, 776, 773, 777, 779, 773, 
	773, 773, 773, 778, 773, 778, 780, 773, 
	782, 781, 781, 785, 786, 787, 781, 788, 
	790, 793, 794, 795, 796, 797, 781, 798, 
	799, 804, 832, 836, 781, 837, 839, 841, 
	781, 842, 843, 845, 849, 851, 852, 854, 
	855, 873, 878, 885, 893, 900, 907, 912, 
	913, 917, 911, 922, 932, 938, 941, 950, 
	954, 958, 959, 960, 793, 783, 781, 784, 
	781, 781, 781, 781, 781, 781, 789, 781, 
	789, 781, 155, 792, 781, 781, 781, 781, 
	781, 781, 781, 781, 781, 800, 781, 801, 
	781, 781, 156, 158, 781, 159, 813, 824, 
	827, 806, 828, 829, 814, 818, 820, 781, 
	806, 159, 808, 810, 160, 781, 808, 781, 
	809, 781, 781, 161, 812, 781, 781, 815, 
	817, 781, 815, 816, 818, 820, 817, 781, 
	819, 781, 781, 821, 823, 781, 165, 781, 
	781, 781, 825, 817, 818, 820, 825, 826, 
	781, 815, 817, 818, 820, 781, 815, 817, 
	818, 820, 781, 830, 817, 818, 820, 830, 
	831, 781, 159, 832, 806, 833, 818, 820, 
	834, 817, 159, 834, 806, 835, 838, 840, 
	781, 168, 169, 781, 781, 846, 847, 848, 
	843, 850, 781, 781, 853, 781, 781, 781, 
	856, 857, 866, 871, 858, 859, 860, 861, 
	862, 863, 864, 865, 782, 867, 868, 869, 
	870, 782, 872, 874, 877, 875, 876, 782, 
	782, 879, 882, 880, 881, 883, 884, 782, 
	886, 888, 887, 889, 890, 891, 781, 781, 
	894, 782, 895, 781, 896, 897, 898, 899, 
	783, 901, 904, 902, 903, 905, 906, 908, 
	909, 910, 782, 914, 915, 916, 918, 920, 
	921, 919, 782, 923, 924, 925, 928, 926, 
	927, 929, 930, 931, 933, 935, 934, 936, 
	937, 939, 940, 942, 943, 945, 948, 944, 
	946, 947, 949, 951, 952, 953, 955, 956, 
	957, 781, 781, 961, 962, 964, 965, 966, 
	961, 961, 968, 967, 969, 967, 970, 971, 
	972, 967, 967
]

class << self
	attr_accessor :_lex_trans_actions
	private :_lex_trans_actions, :_lex_trans_actions=
end
self._lex_trans_actions = [
	1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 2, 3, 4, 0, 5, 0, 
	0, 0, 0, 6, 0, 7, 0, 8, 
	0, 7, 0, 0, 0, 0, 8, 7, 
	0, 8, 0, 7, 7, 0, 0, 0, 
	0, 0, 0, 0, 9, 0, 10, 0, 
	0, 0, 0, 11, 0, 7, 0, 8, 
	0, 7, 0, 0, 0, 0, 8, 7, 
	0, 8, 0, 7, 7, 0, 0, 0, 
	0, 0, 0, 0, 12, 0, 13, 0, 
	0, 0, 0, 14, 0, 15, 0, 0, 
	0, 0, 0, 16, 0, 0, 0, 0, 
	0, 0, 17, 18, 19, 20, 21, 0, 
	0, 0, 22, 23, 0, 0, 24, 25, 
	26, 27, 28, 29, 29, 30, 31, 29, 
	32, 31, 33, 31, 29, 29, 30, 29, 
	34, 29, 29, 35, 29, 29, 29, 29, 
	29, 29, 0, 36, 37, 0, 38, 37, 
	39, 37, 0, 0, 36, 0, 40, 0, 
	0, 0, 0, 0, 0, 0, 0, 27, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 41, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 42, 43, 
	44, 45, 0, 0, 0, 45, 28, 46, 
	29, 29, 29, 46, 47, 0, 48, 0, 
	28, 29, 49, 29, 50, 51, 52, 0, 
	0, 0, 0, 0, 53, 54, 0, 55, 
	0, 28, 0, 56, 0, 29, 57, 29, 
	58, 29, 59, 60, 61, 60, 62, 60, 
	0, 63, 64, 63, 65, 63, 66, 67, 
	0, 68, 0, 0, 0, 0, 69, 69, 
	0, 0, 70, 70, 71, 0, 28, 72, 
	0, 0, 0, 69, 0, 73, 0, 7, 
	0, 8, 0, 7, 0, 0, 0, 0, 
	8, 7, 0, 8, 0, 7, 7, 0, 
	0, 0, 0, 0, 0, 0, 0, 74, 
	0, 0, 0, 0, 74, 75, 0, 0, 
	0, 76, 77, 78, 79, 0, 7, 7, 
	80, 81, 81, 82, 0, 0, 0, 0, 
	83, 0, 0, 0, 0, 0, 0, 28, 
	0, 0, 0, 29, 57, 29, 29, 29, 
	59, 60, 61, 60, 60, 60, 0, 63, 
	64, 63, 63, 63, 84, 66, 85, 86, 
	0, 87, 0, 88, 89, 0, 90, 0, 
	91, 59, 92, 0, 93, 28, 94, 95, 
	98, 99, 0, 28, 0, 7, 0, 7, 
	100, 101, 102, 59, 103, 0, 104, 0, 
	105, 106, 107, 0, 108, 109, 0, 110, 
	7, 7, 111, 112, 0, 0, 113, 114, 
	115, 116, 117, 117, 117, 117, 117, 117, 
	117, 117, 118, 119, 120, 0, 0, 121, 
	0, 122, 123, 124, 0, 125, 126, 127, 
	0, 7, 0, 0, 128, 129, 0, 28, 
	130, 0, 0, 0, 0, 0, 131, 132, 
	0, 0, 0, 0, 0, 0, 0, 133, 
	0, 0, 0, 0, 134, 0, 0, 0, 
	0, 0, 135, 136, 137, 0, 138, 139, 
	140, 7, 7, 141, 0, 0, 142, 143, 
	144, 145, 117, 117, 117, 117, 117, 117, 
	117, 117, 146, 147, 148, 0, 0, 149, 
	0, 150, 151, 152, 0, 153, 154, 155, 
	0, 7, 0, 0, 156, 157, 0, 28, 
	158, 0, 0, 0, 0, 0, 159, 160, 
	0, 0, 0, 0, 0, 0, 0, 161, 
	0, 0, 0, 0, 162, 0, 0, 0, 
	0, 0, 163, 164, 165, 0, 166, 167, 
	0, 168, 0, 169, 170, 171, 172, 173, 
	174, 0, 175, 176, 177, 178, 179, 180, 
	7, 181, 0, 0, 182, 183, 184, 185, 
	186, 187, 188, 189, 0, 190, 7, 191, 
	192, 0, 0, 193, 194, 195, 196, 197, 
	0, 198, 199, 200, 0, 201, 0, 0, 
	202, 203, 204, 205, 206, 207, 0, 28, 
	0, 0, 7, 7, 0, 0, 0, 208, 
	0, 0, 0, 0, 209, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 210, 211, 212, 213, 214, 
	215, 59, 216, 0, 217, 0, 0, 0, 
	218, 0, 219, 220, 0, 0, 221, 0, 
	0, 0, 222, 0, 223, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 222, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 224, 0, 0, 
	0, 0, 225, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 7, 226, 227, 0, 0, 0, 
	228, 229, 230, 59, 231, 0, 28, 232, 
	0, 233, 234, 0, 28, 0, 0, 235, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 236, 0, 237, 0, 238, 239, 
	240, 241, 242, 59, 243, 0, 0, 244, 
	0, 245, 246, 247, 248, 28, 0, 27, 
	0, 0, 27, 0, 0, 0, 0, 0, 
	0, 7, 7, 7, 249, 250, 251, 252, 
	253, 254, 255, 0, 256, 257, 258, 259, 
	260, 261, 262, 263, 264, 59, 265, 0, 
	266, 267, 268, 269, 270, 271, 0, 0, 
	0, 272, 7, 7, 0, 273, 274, 275, 
	276, 277, 0, 0, 0, 0, 0, 278, 
	279, 59, 280, 0, 281, 28, 282, 283, 
	284, 285, 286, 287, 0, 28, 0, 0, 
	0, 0, 0, 0, 288, 289, 290, 291, 
	59, 292, 0, 293, 28, 294, 295, 296, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 297, 298, 0, 8, 
	0, 0, 7, 299, 0, 0, 299, 299, 
	0, 0, 7, 300, 0, 300, 0, 300, 
	300, 300, 0, 0, 300, 297, 297, 297, 
	297, 297, 297, 297, 297, 297, 297, 297, 
	297, 297, 297, 297, 297, 297, 0, 0, 
	301, 302, 302, 303, 304, 0, 305, 306, 
	0, 74, 0, 307, 0, 308, 309, 310, 
	311, 312, 29, 313, 314, 315, 316, 317, 
	59, 318, 0, 319, 320, 0, 321, 322, 
	0, 323, 324, 299, 325, 0, 326, 327, 
	328, 0, 0, 329, 0, 0, 0, 0, 
	330, 0, 0, 0, 0, 0, 0, 0, 
	331, 0, 0, 332, 0, 333, 334, 0, 
	0, 0, 335, 0, 0, 336, 337, 338, 
	339, 340, 341, 0, 342, 343, 343, 0, 
	344, 0, 345, 346, 346, 0, 0, 347, 
	348, 349, 0, 350, 351, 352, 0, 7, 
	353, 354, 355, 0, 356, 117, 117, 117, 
	117, 117, 117, 117, 117, 357, 358, 359, 
	0, 0, 360, 0, 361, 362, 363, 0, 
	364, 365, 366, 0, 7, 0, 0, 367, 
	368, 0, 28, 369, 0, 0, 0, 0, 
	0, 370, 371, 0, 0, 0, 0, 0, 
	0, 0, 372, 0, 0, 0, 0, 0, 
	373, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 374, 375, 376, 0, 0, 0, 
	377, 28, 297, 297, 297, 297, 297, 297, 
	297, 297, 297, 297, 297, 297, 74, 297, 
	297, 297, 297, 297, 297, 297, 297, 297, 
	297, 297, 297, 297, 297, 297, 297, 297, 
	297, 297, 297, 297, 297, 297, 297, 378, 
	297, 297, 297, 297, 297, 297, 297, 297, 
	297, 297, 297, 297, 379, 380, 381, 382, 
	383, 383, 379, 297, 297, 297, 297, 297, 
	297, 297, 297, 297, 297, 297, 297, 297, 
	297, 297, 297, 297, 297, 297, 384, 385, 
	386, 387, 0, 28, 0, 0, 388, 389, 
	390, 59, 391, 0, 392, 28, 393, 7, 
	394, 395, 0, 28, 396, 0, 0, 397, 
	398, 399, 400, 59, 401, 0, 28, 402, 
	403, 404, 405, 0, 28, 0, 406, 0, 
	7, 407, 0, 0, 0, 0, 408, 0, 
	0, 409, 409, 0, 410, 0, 0, 0, 
	411, 7, 412, 412, 412, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 413, 414, 415, 0, 
	416, 417, 418, 419, 420, 421, 59, 422, 
	0, 423, 0, 0, 424, 425, 426, 427, 
	428, 429, 430, 431, 432, 0, 433, 0, 
	434, 435, 0, 0, 436, 437, 438, 0, 
	0, 439, 0, 0, 438, 440, 440, 441, 
	442, 0, 443, 444, 0, 445, 446, 447, 
	0, 448, 449, 0, 0, 450, 451, 438, 
	438, 452, 0, 0, 453, 453, 0, 454, 
	0, 455, 456, 7, 0, 457, 0, 458, 
	459, 460, 461, 461, 462, 462, 0, 0, 
	463, 464, 464, 465, 465, 466, 467, 467, 
	468, 468, 469, 470, 470, 471, 471, 0, 
	0, 472, 473, 474, 475, 476, 477, 477, 
	474, 476, 478, 409, 479, 0, 0, 0, 
	480, 0, 0, 481, 482, 412, 412, 412, 
	483, 412, 484, 485, 28, 486, 487, 488, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 489, 0, 0, 0, 
	0, 483, 0, 0, 0, 0, 0, 490, 
	491, 0, 0, 0, 0, 0, 0, 492, 
	0, 0, 0, 0, 0, 491, 493, 494, 
	0, 495, 0, 496, 0, 0, 0, 0, 
	497, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 498, 0, 0, 0, 0, 0, 
	0, 0, 497, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 499, 500, 501, 502, 502, 88, 502, 
	503, 504, 0, 505, 0, 506, 0, 0, 
	0, 507, 508
]

class << self
	attr_accessor :_lex_to_state_actions
	private :_lex_to_state_actions, :_lex_to_state_actions=
end
self._lex_to_state_actions = [
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 96, 0, 0, 0, 0, 0, 0, 
	0, 0, 96, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 96, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 96, 0, 0, 96, 0, 
	96, 0, 0, 0, 0, 96, 96, 0, 
	0, 0, 0, 0, 96, 0, 96, 0, 
	96, 0, 0, 0, 0, 96, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 96, 0, 
	0, 0, 0, 0, 0, 96, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 96, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 96, 0, 0, 0, 0, 0, 96, 
	0, 0, 0, 0, 0, 0, 0, 96, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 96, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 96, 0, 
	0, 0, 0, 0, 0, 96, 0, 0, 
	0, 0, 0, 0, 0, 96, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 96, 0, 0, 0, 0, 0, 96, 
	0, 0, 0, 0, 0
]

class << self
	attr_accessor :_lex_from_state_actions
	private :_lex_from_state_actions, :_lex_from_state_actions=
end
self._lex_from_state_actions = [
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 97, 0, 0, 0, 0, 0, 0, 
	0, 0, 97, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 97, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 97, 0, 0, 97, 0, 
	97, 0, 0, 0, 0, 97, 97, 0, 
	0, 0, 0, 0, 97, 0, 97, 0, 
	97, 0, 0, 0, 0, 97, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 97, 0, 
	0, 0, 0, 0, 0, 97, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 97, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 97, 0, 0, 0, 0, 0, 97, 
	0, 0, 0, 0, 0, 0, 0, 97, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 97, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 97, 0, 
	0, 0, 0, 0, 0, 97, 0, 0, 
	0, 0, 0, 0, 0, 97, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 97, 0, 0, 0, 0, 0, 97, 
	0, 0, 0, 0, 0
]

class << self
	attr_accessor :_lex_eof_trans
	private :_lex_eof_trans, :_lex_eof_trans=
end
self._lex_eof_trans = [
	0, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 13, 13, 13, 13, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 45, 45, 45, 
	45, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 77, 
	77, 77, 77, 84, 84, 84, 84, 0, 
	0, 0, 0, 99, 101, 103, 103, 103, 
	108, 108, 112, 112, 112, 112, 112, 112, 
	112, 112, 112, 112, 112, 112, 112, 112, 
	112, 112, 112, 112, 112, 112, 112, 173, 
	173, 173, 173, 173, 173, 173, 173, 173, 
	173, 173, 173, 183, 185, 185, 185, 197, 
	197, 197, 205, 207, 207, 207, 207, 207, 
	213, 205, 205, 205, 205, 205, 205, 205, 
	240, 240, 240, 240, 240, 240, 205, 256, 
	205, 256, 240, 240, 205, 262, 262, 262, 
	262, 262, 262, 262, 262, 262, 262, 262, 
	262, 262, 262, 205, 240, 240, 240, 240, 
	294, 294, 294, 299, 301, 301, 301, 305, 
	305, 308, 308, 308, 308, 313, 313, 313, 
	299, 305, 305, 305, 305, 305, 305, 305, 
	305, 305, 344, 351, 353, 353, 353, 353, 
	344, 0, 369, 370, 371, 373, 375, 377, 
	375, 375, 0, 387, 388, 392, 392, 393, 
	394, 403, 404, 405, 405, 405, 408, 408, 
	410, 411, 412, 412, 412, 414, 415, 416, 
	416, 412, 408, 408, 421, 422, 422, 422, 
	422, 422, 425, 425, 425, 425, 431, 432, 
	432, 432, 432, 440, 432, 432, 432, 432, 
	445, 432, 432, 432, 432, 432, 432, 451, 
	452, 453, 453, 0, 460, 464, 464, 465, 
	466, 475, 476, 477, 477, 477, 480, 480, 
	482, 483, 484, 484, 484, 486, 487, 488, 
	488, 484, 480, 480, 493, 494, 494, 494, 
	494, 494, 497, 497, 497, 497, 503, 504, 
	504, 504, 504, 512, 504, 504, 504, 504, 
	517, 504, 504, 504, 504, 504, 504, 523, 
	524, 525, 525, 0, 532, 533, 0, 539, 
	0, 546, 550, 550, 551, 0, 0, 560, 
	561, 565, 565, 566, 0, 571, 0, 574, 
	0, 577, 577, 578, 579, 0, 620, 622, 
	623, 624, 625, 627, 629, 633, 633, 624, 
	624, 624, 624, 635, 624, 624, 629, 624, 
	624, 620, 639, 639, 639, 639, 639, 639, 
	629, 629, 645, 645, 645, 645, 645, 645, 
	645, 645, 645, 645, 645, 645, 645, 645, 
	645, 645, 645, 645, 645, 645, 645, 645, 
	645, 645, 645, 645, 645, 645, 645, 645, 
	645, 645, 645, 645, 645, 678, 645, 645, 
	645, 645, 645, 645, 645, 645, 645, 645, 
	645, 645, 645, 645, 645, 645, 645, 645, 
	645, 645, 645, 645, 645, 645, 645, 645, 
	645, 645, 645, 645, 645, 645, 645, 645, 
	645, 645, 645, 645, 645, 645, 645, 645, 
	645, 645, 645, 645, 645, 624, 0, 721, 
	722, 723, 725, 721, 728, 0, 747, 749, 
	751, 752, 753, 754, 755, 757, 754, 754, 
	754, 754, 754, 760, 754, 754, 762, 760, 
	760, 754, 0, 781, 782, 108, 108, 785, 
	786, 108, 782, 782, 789, 791, 794, 782, 
	795, 782, 796, 797, 799, 801, 782, 789, 
	802, 802, 791, 802, 806, 802, 802, 802, 
	802, 0, 183, 814, 815, 814, 814, 0, 
	824, 825, 827, 829, 831, 829, 833, 0, 
	845, 846, 847, 848, 850, 852, 854, 855, 
	855, 855, 855, 855, 855, 855, 855, 855, 
	855, 855, 855, 855, 855, 855, 855, 0, 
	913, 916, 919, 920, 924, 926, 927, 928, 
	929, 930, 932, 935, 936, 938, 940, 943, 
	944, 946, 947, 205, 944, 949, 944, 935, 
	951, 935, 935, 969, 972, 974, 975, 979, 
	982, 983, 984, 985, 969, 969, 969, 969, 
	969, 969, 969, 969, 969, 969, 989, 993, 
	995, 969, 969, 935, 1000, 1001, 1001, 1001, 
	935, 935, 935, 1002, 1009, 1009, 1011, 1013, 
	1022, 1023, 1024, 1024, 1024, 1027, 1027, 1029, 
	1030, 1031, 1031, 1031, 1033, 1034, 1035, 1035, 
	1031, 1027, 1027, 1040, 1041, 1041, 1041, 1041, 
	1041, 1044, 1044, 1044, 1044, 1050, 1051, 1051, 
	1051, 1051, 1059, 1051, 1051, 1051, 1051, 1065, 
	1051, 1051, 1051, 1051, 1051, 1051, 1051, 1051, 
	1051, 1051, 1051, 1051, 1051, 1051, 1051, 1051, 
	1051, 1051, 1051, 1083, 1084, 1085, 1085, 205, 
	935, 935, 1089, 935, 930, 913, 913, 913, 
	913, 913, 913, 913, 913, 913, 913, 913, 
	205, 913, 913, 913, 913, 913, 913, 913, 
	913, 913, 913, 913, 913, 913, 913, 913, 
	913, 913, 913, 913, 913, 913, 913, 913, 
	913, 913, 913, 913, 913, 913, 913, 913, 
	913, 913, 913, 913, 913, 913, 913, 913, 
	913, 913, 913, 913, 913, 913, 913, 913, 
	913, 1142, 920, 913, 913, 913, 913, 913, 
	913, 913, 913, 913, 913, 913, 913, 913, 
	913, 913, 913, 913, 913, 913, 913, 913, 
	913, 913, 913, 913, 1167, 935, 0, 1175, 
	1176, 1177, 1179, 1181, 1183, 0, 1192, 1193, 
	1194, 1195, 1197, 1192, 1200, 0, 305, 1255, 
	1257, 1258, 1259, 1260, 1262, 1264, 1266, 1269, 
	1269, 305, 1271, 1273, 1274, 1275, 1271, 1277, 
	1279, 1279, 1282, 1282, 1285, 1296, 305, 1302, 
	1304, 1306, 1307, 1310, 1311, 1285, 1285, 1314, 
	1314, 1314, 1320, 1322, 1323, 1326, 1328, 1329, 
	1330, 1314, 1314, 1337, 1342, 1347, 1314, 1314, 
	1354, 1354, 1314, 1314, 1279, 1271, 1271, 1279, 
	1271, 1271, 1266, 305, 1372, 1373, 1373, 1373, 
	1373, 1373, 1373, 1379, 1266, 1382, 1383, 1384, 
	1384, 1384, 1384, 1384, 1384, 1384, 1384, 1384, 
	1384, 1384, 1384, 1384, 1384, 1384, 1384, 1384, 
	1384, 1384, 1384, 1384, 1384, 1384, 1384, 1384, 
	1384, 1384, 1384, 1384, 1384, 1384, 1384, 1384, 
	1384, 1384, 1384, 1423, 1424, 1384, 1384, 1428, 
	1384, 1384, 1384, 1384, 1384, 1384, 1384, 1384, 
	1384, 1384, 1384, 1384, 1384, 1384, 1384, 1384, 
	1384, 1384, 1384, 1384, 1384, 1384, 1384, 1384, 
	1384, 1384, 1384, 1384, 1384, 1384, 1384, 1384, 
	1384, 1384, 1384, 1384, 1384, 1384, 1384, 1384, 
	1384, 1384, 1384, 1384, 1384, 1384, 1384, 1384, 
	1384, 1384, 1384, 1384, 1384, 1384, 1384, 1384, 
	1384, 1384, 1384, 1384, 1384, 1384, 1482, 1260, 
	1483, 0, 1489, 1490, 1489, 1489, 1489, 0, 
	1494, 1494, 1494, 1494, 1498
]

class << self
	attr_accessor :lex_start
end
self.lex_start = 185;
class << self
	attr_accessor :lex_error
end
self.lex_error = 0;

class << self
	attr_accessor :lex_en_interp_words
end
self.lex_en_interp_words = 194;
class << self
	attr_accessor :lex_en_interp_string
end
self.lex_en_interp_string = 251;
class << self
	attr_accessor :lex_en_plain_words
end
self.lex_en_plain_words = 307;
class << self
	attr_accessor :lex_en_plain_string
end
self.lex_en_plain_string = 310;
class << self
	attr_accessor :lex_en_interp_backslash_delimited
end
self.lex_en_interp_backslash_delimited = 312;
class << self
	attr_accessor :lex_en_plain_backslash_delimited
end
self.lex_en_plain_backslash_delimited = 317;
class << self
	attr_accessor :lex_en_interp_backslash_delimited_words
end
self.lex_en_interp_backslash_delimited_words = 318;
class << self
	attr_accessor :lex_en_plain_backslash_delimited_words
end
self.lex_en_plain_backslash_delimited_words = 324;
class << self
	attr_accessor :lex_en_regexp_modifiers
end
self.lex_en_regexp_modifiers = 326;
class << self
	attr_accessor :lex_en_expr_variable
end
self.lex_en_expr_variable = 328;
class << self
	attr_accessor :lex_en_expr_fname
end
self.lex_en_expr_fname = 333;
class << self
	attr_accessor :lex_en_expr_endfn
end
self.lex_en_expr_endfn = 446;
class << self
	attr_accessor :lex_en_expr_dot
end
self.lex_en_expr_dot = 453;
class << self
	attr_accessor :lex_en_expr_arg
end
self.lex_en_expr_arg = 474;
class << self
	attr_accessor :lex_en_expr_cmdarg
end
self.lex_en_expr_cmdarg = 505;
class << self
	attr_accessor :lex_en_expr_endarg
end
self.lex_en_expr_endarg = 511;
class << self
	attr_accessor :lex_en_expr_mid
end
self.lex_en_expr_mid = 519;
class << self
	attr_accessor :lex_en_expr_beg
end
self.lex_en_expr_beg = 543;
class << self
	attr_accessor :lex_en_expr_labelarg
end
self.lex_en_expr_labelarg = 766;
class << self
	attr_accessor :lex_en_expr_value
end
self.lex_en_expr_value = 773;
class << self
	attr_accessor :lex_en_expr_end
end
self.lex_en_expr_end = 781;
class << self
	attr_accessor :lex_en_leading_dot
end
self.lex_en_leading_dot = 961;
class << self
	attr_accessor :lex_en_line_comment
end
self.lex_en_line_comment = 967;
class << self
	attr_accessor :lex_en_line_begin
end
self.lex_en_line_begin = 185;


# line 82 "lib/parser/lexer.rl"
  # %

  ESCAPES = {
    ?a.ord => "\a", ?b.ord  => "\b", ?e.ord => "\e", ?f.ord => "\f",
    ?n.ord => "\n", ?r.ord  => "\r", ?s.ord => "\s", ?t.ord => "\t",
    ?v.ord => "\v", ?\\.ord => "\\"
  }.freeze

  REGEXP_META_CHARACTERS = Regexp.union(*"\\$()*+.<>?[]^{|}".chars).freeze

  attr_reader   :source_buffer

  attr_accessor :diagnostics
  attr_accessor :static_env
  attr_accessor :force_utf32

  attr_accessor :cond, :cmdarg, :in_kwarg, :context, :command_start

  attr_accessor :tokens, :comments

  def initialize(version)
    @version    = version
    @static_env = nil
    @context    = nil

    @tokens     = nil
    @comments   = nil

    reset
  end

  def reset(reset_state=true)
    # Ragel state:
    if reset_state
      # Unit tests set state prior to resetting lexer.
      @cs     = self.class.lex_en_line_begin

      @cond   = StackState.new('cond')
      @cmdarg = StackState.new('cmdarg')
      @cond_stack   = []
      @cmdarg_stack = []
    end

    @force_utf32   = false # Set to true by some tests

    @source_pts    = nil # @source as a codepoint array

    @p             = 0   # stream position (saved manually in #advance)
    @ts            = nil # token start
    @te            = nil # token end
    @act           = 0   # next action

    @stack         = []  # state stack
    @top           = 0   # state stack top pointer

    # Lexer state:
    @token_queue   = []
    @literal_stack = []

    @eq_begin_s    = nil # location of last encountered =begin
    @sharp_s       = nil # location of last encountered #

    @newline_s     = nil # location of last encountered newline

    @num_base      = nil # last numeric base
    @num_digits_s  = nil # starting position of numeric digits
    @num_suffix_s  = nil # starting position of numeric suffix
    @num_xfrm      = nil # numeric suffix-induced transformation

    @escape_s      = nil # starting position of current sequence
    @escape        = nil # last escaped sequence, as string

    @herebody_s    = nil # starting position of current heredoc line

    # Ruby 1.9 ->() lambdas emit a distinct token if do/{ is
    # encountered after a matching closing parenthesis.
    @paren_nest    = 0
    @lambda_stack  = []

    # After encountering the closing line of <<~SQUIGGLY_HEREDOC,
    # we store the indentation level and give it out to the parser
    # on request. It is not possible to infer indentation level just
    # from the AST because escape sequences such as `\ ` or `\t` are
    # expanded inside the lexer, but count as non-whitespace for
    # indentation purposes.
    @dedent_level  = nil

    # If the lexer is in `command state' (aka expr_value)
    # at the entry to #advance, it will transition to expr_cmdarg
    # instead of expr_arg at certain points.
    @command_start = true

    # True at the end of "def foo a:"
    @in_kwarg      = false

    # State before =begin / =end block comment
    @cs_before_block_comment = self.class.lex_en_line_begin
  end

  def source_buffer=(source_buffer)
    @source_buffer = source_buffer

    if @source_buffer
      source = @source_buffer.source

      if source.encoding == Encoding::UTF_8
        @source_pts = source.unpack('U*')
      else
        @source_pts = source.unpack('C*')
      end

      if @source_pts[0] == 0xfeff
        # Skip byte order mark.
        @p = 1
      end
    else
      @source_pts = nil
    end
  end

  def encoding
    @source_buffer.source.encoding
  end

  LEX_STATES = {
    :line_begin    => lex_en_line_begin,
    :expr_dot      => lex_en_expr_dot,
    :expr_fname    => lex_en_expr_fname,
    :expr_value    => lex_en_expr_value,
    :expr_beg      => lex_en_expr_beg,
    :expr_mid      => lex_en_expr_mid,
    :expr_arg      => lex_en_expr_arg,
    :expr_cmdarg   => lex_en_expr_cmdarg,
    :expr_end      => lex_en_expr_end,
    :expr_endarg   => lex_en_expr_endarg,
    :expr_endfn    => lex_en_expr_endfn,
    :expr_labelarg => lex_en_expr_labelarg,

    :interp_string => lex_en_interp_string,
    :interp_words  => lex_en_interp_words,
    :plain_string  => lex_en_plain_string,
    :plain_words   => lex_en_plain_string,
  }

  def state
    LEX_STATES.invert.fetch(@cs, @cs)
  end

  def state=(state)
    @cs = LEX_STATES.fetch(state)
  end

  def push_cmdarg
    @cmdarg_stack.push(@cmdarg)
    @cmdarg = StackState.new("cmdarg.#{@cmdarg_stack.count}")
  end

  def pop_cmdarg
    @cmdarg = @cmdarg_stack.pop
  end

  def push_cond
    @cond_stack.push(@cond)
    @cond = StackState.new("cond.#{@cond_stack.count}")
  end

  def pop_cond
    @cond = @cond_stack.pop
  end

  def dedent_level
    # We erase @dedent_level as a precaution to avoid accidentally
    # using a stale value.
    dedent_level, @dedent_level = @dedent_level, nil
    dedent_level
  end

  # Return next token: [type, value].
  def advance
    if @token_queue.any?
      return @token_queue.shift
    end

    # Ugly, but dependent on Ragel output. Consider refactoring it somehow.
    klass = self.class
    _lex_trans_keys         = klass.send :_lex_trans_keys
    _lex_key_spans          = klass.send :_lex_key_spans
    _lex_index_offsets      = klass.send :_lex_index_offsets
    _lex_indicies           = klass.send :_lex_indicies
    _lex_trans_targs        = klass.send :_lex_trans_targs
    _lex_trans_actions      = klass.send :_lex_trans_actions
    _lex_to_state_actions   = klass.send :_lex_to_state_actions
    _lex_from_state_actions = klass.send :_lex_from_state_actions
    _lex_eof_trans          = klass.send :_lex_eof_trans

    pe = @source_pts.size + 2
    p, eof = @p, pe

    cmd_state = @command_start
    @command_start = false

    
# line 10989 "lib/parser/lexer.rb"
begin
	testEof = false
	_slen, _trans, _keys, _inds, _acts, _nacts = nil
	_goto_level = 0
	_resume = 10
	_eof_trans = 15
	_again = 20
	_test_eof = 30
	_out = 40
	while true
	if _goto_level <= 0
	if p == pe
		_goto_level = _test_eof
		next
	end
	if  @cs == 0
		_goto_level = _out
		next
	end
	end
	if _goto_level <= _resume
	case _lex_from_state_actions[ @cs] 
	when 97 then
# line 1 "NONE"
		begin
 @ts = p
		end
# line 11017 "lib/parser/lexer.rb"
	end
	_keys =  @cs << 1
	_inds = _lex_index_offsets[ @cs]
	_slen = _lex_key_spans[ @cs]
	_wide = ( (@source_pts[p] || 0))
	_trans = if (   _slen > 0 && 
			_lex_trans_keys[_keys] <= _wide && 
			_wide <= _lex_trans_keys[_keys + 1] 
		    ) then
			_lex_indicies[ _inds + _wide - _lex_trans_keys[_keys] ] 
		 else 
			_lex_indicies[ _inds + _slen ]
		 end
	end
	if _goto_level <= _eof_trans
	 @cs = _lex_trans_targs[_trans]
	if _lex_trans_actions[_trans] != 0
	case _lex_trans_actions[_trans]
	when 28 then
# line 499 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
	when 117 then
# line 815 "lib/parser/lexer.rl"
		begin

    @escape_s = p
    @escape   = nil
  		end
	when 29 then
# line 855 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
	when 59 then
# line 1215 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
	when 63 then
# line 1218 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
	when 304 then
# line 1259 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 36 then
# line 1540 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 38 then
# line 1556 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 40 then
# line 1584 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 70 then
# line 1776 "lib/parser/lexer.rl"
		begin
 heredoc_e      = p 		end
	when 343 then
# line 1868 "lib/parser/lexer.rl"
		begin
 tm = p - 1; diag_msg = :ivar_name 		end
	when 346 then
# line 1869 "lib/parser/lexer.rl"
		begin
 tm = p - 2; diag_msg = :cvar_name 		end
	when 354 then
# line 1889 "lib/parser/lexer.rl"
		begin
 @escape = nil 		end
	when 383 then
# line 1978 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 302 then
# line 2066 "lib/parser/lexer.rl"
		begin
 ident_tok = tok; ident_ts = @ts; ident_te = @te; 		end
	when 470 then
# line 2252 "lib/parser/lexer.rl"
		begin
 @num_base = 16; @num_digits_s = p 		end
	when 464 then
# line 2253 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = p 		end
	when 467 then
# line 2254 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = p 		end
	when 461 then
# line 2255 "lib/parser/lexer.rl"
		begin
 @num_base = 2;  @num_digits_s = p 		end
	when 476 then
# line 2256 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = @ts 		end
	when 438 then
# line 2257 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = @ts 		end
	when 453 then
# line 2258 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 446 then
# line 2315 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 443 then
# line 2316 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 88 then
# line 2504 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 7 then
# line 1 "NONE"
		begin
 @te = p+1
		end
	when 113 then
# line 1092 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DBEG, '#{'.freeze)

    if current_literal.heredoc?
      current_literal.saved_herebody_s = @herebody_s
      @herebody_s = nil
    end

    current_literal.start_interp_brace
    @command_start = true
     @cs = 773;
    	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 5 then
# line 1018 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 328
		_goto_level = _again
		next
	end

   end
		end
	when 109 then
# line 943 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 108 then
# line 864 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 766;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 115 then
# line 1034 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    if @version >= 27
      literal.extend_string(tok, @ts, @te)
    else
      message = tok.start_with?('#@@') ? :cvar_name : :ivar_name
      diagnostic :error, message, { :name => tok(@ts + 1, @te) }, range(@ts + 1, @te)
    end
   end
		end
	when 114 then
# line 1018 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 328
		_goto_level = _again
		next
	end

   end
		end
	when 111 then
# line 1005 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    literal.extend_space @ts, @te
   end
		end
	when 112 then
# line 864 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 766;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 6 then
# line 888 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 4 then
# line 864 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 766;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 142 then
# line 1092 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DBEG, '#{'.freeze)

    if current_literal.heredoc?
      current_literal.saved_herebody_s = @herebody_s
      @herebody_s = nil
    end

    current_literal.start_interp_brace
    @command_start = true
     @cs = 773;
    	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 10 then
# line 1018 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 328
		_goto_level = _again
		next
	end

   end
		end
	when 139 then
# line 943 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 138 then
# line 864 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 766;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 144 then
# line 1034 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    if @version >= 27
      literal.extend_string(tok, @ts, @te)
    else
      message = tok.start_with?('#@@') ? :cvar_name : :ivar_name
      diagnostic :error, message, { :name => tok(@ts + 1, @te) }, range(@ts + 1, @te)
    end
   end
		end
	when 143 then
# line 1018 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 328
		_goto_level = _again
		next
	end

   end
		end
	when 141 then
# line 864 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 766;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 11 then
# line 888 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 9 then
# line 864 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 766;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 167 then
# line 943 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 166 then
# line 864 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 766;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 169 then
# line 1005 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    literal.extend_space @ts, @te
   end
		end
	when 170 then
# line 864 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 766;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 173 then
# line 943 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 172 then
# line 864 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 766;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 175 then
# line 864 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 766;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 182 then
# line 1092 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DBEG, '#{'.freeze)

    if current_literal.heredoc?
      current_literal.saved_herebody_s = @herebody_s
      @herebody_s = nil
    end

    current_literal.start_interp_brace
    @command_start = true
     @cs = 773;
    	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 13 then
# line 1018 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 328
		_goto_level = _again
		next
	end

   end
		end
	when 179 then
# line 943 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 178 then
# line 864 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 766;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 184 then
# line 1034 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    if @version >= 27
      literal.extend_string(tok, @ts, @te)
    else
      message = tok.start_with?('#@@') ? :cvar_name : :ivar_name
      diagnostic :error, message, { :name => tok(@ts + 1, @te) }, range(@ts + 1, @te)
    end
   end
		end
	when 183 then
# line 1018 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 328
		_goto_level = _again
		next
	end

   end
		end
	when 181 then
# line 864 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 766;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 12 then
# line 864 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 766;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 186 then
# line 943 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 185 then
# line 864 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 766;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 193 then
# line 1092 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DBEG, '#{'.freeze)

    if current_literal.heredoc?
      current_literal.saved_herebody_s = @herebody_s
      @herebody_s = nil
    end

    current_literal.start_interp_brace
    @command_start = true
     @cs = 773;
    	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 15 then
# line 1018 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 328
		_goto_level = _again
		next
	end

   end
		end
	when 189 then
# line 943 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 188 then
# line 864 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 766;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 195 then
# line 1034 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    if @version >= 27
      literal.extend_string(tok, @ts, @te)
    else
      message = tok.start_with?('#@@') ? :cvar_name : :ivar_name
      diagnostic :error, message, { :name => tok(@ts + 1, @te) }, range(@ts + 1, @te)
    end
   end
		end
	when 194 then
# line 1018 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 328
		_goto_level = _again
		next
	end

   end
		end
	when 191 then
# line 1005 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    literal.extend_space @ts, @te
   end
		end
	when 192 then
# line 864 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 766;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 14 then
# line 864 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 766;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 197 then
# line 943 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 196 then
# line 864 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 766;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 199 then
# line 1005 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    literal.extend_space @ts, @te
   end
		end
	when 200 then
# line 1189 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tREGEXP_OPT, tok(@ts, @te - 1), @ts, @te - 1)
        p = p - 1;
        	begin
		 @cs = 781
		_goto_level = _again
		next
	end

       end
		end
	when 201 then
# line 1176 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        unknown_options = tok.scan(/[^imxouesn]/)
        if unknown_options.any?
          diagnostic :error, :regexp_options,
                     { :options => unknown_options.join }
        end

        emit(:tREGEXP_OPT)
         @cs = 781;
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 16 then
# line 1328 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        if    tok =~ /^\$([1-9][0-9]*)$/
          emit(:tNTH_REF, tok(@ts + 1).to_i)
        elsif tok =~ /^\$([&`'+])$/
          emit(:tBACK_REF)
        else
          emit(:tGVAR)
        end

         @cs = (stack_pop); 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 202 then
# line 1328 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if    tok =~ /^\$([1-9][0-9]*)$/
          emit(:tNTH_REF, tok(@ts + 1).to_i)
        elsif tok =~ /^\$([&`'+])$/
          emit(:tBACK_REF)
        else
          emit(:tGVAR)
        end

         @cs = (stack_pop); 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 204 then
# line 1341 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if tok =~ /^@@[0-9]/
          diagnostic :error, :cvar_name, { :name => tok }
        end

        emit(:tCVAR)
         @cs = (stack_pop); 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 203 then
# line 1351 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if tok =~ /^@[0-9]/
          diagnostic :error, :ivar_name, { :name => tok }
        end

        emit(:tIVAR)
         @cs = (stack_pop); 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 225 then
# line 1372 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_table(KEYWORDS_BEGIN);
            @cs = 446; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 211 then
# line 1380 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit(:tIDENTIFIER)
            @cs = 446; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 18 then
# line 1384 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = @ts - 1
            @cs = 781; 	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 328
		_goto_level = _again
		next
	end
  end
		end
	when 208 then
# line 1393 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_table(PUNCTUATION)
            @cs = 446; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 220 then
# line 1397 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; p = p - 1; 	begin
		 @cs = 781
		_goto_level = _again
		next
	end
  end
		end
	when 20 then
# line 1403 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        if version?(23)
          type, delimiter = tok[0..-2], tok[-1].chr
          	begin
		 @cs = (push_literal(type, delimiter, @ts))
		_goto_level = _again
		next
	end

        else
          p = @ts - 1
          	begin
		 @cs = 781
		_goto_level = _again
		next
	end

        end
       end
		end
	when 207 then
# line 1416 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 781
		_goto_level = _again
		next
	end
  end
		end
	when 206 then
# line 525 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 224 then
# line 1372 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(KEYWORDS_BEGIN);
            @cs = 446; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 221 then
# line 1376 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tCONSTANT)
            @cs = 446; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 223 then
# line 1380 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tIDENTIFIER)
            @cs = 446; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 218 then
# line 1384 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
            @cs = 781; 	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 328
		_goto_level = _again
		next
	end
  end
		end
	when 214 then
# line 1393 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(PUNCTUATION)
            @cs = 446; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 219 then
# line 1400 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 543
		_goto_level = _again
		next
	end
  end
		end
	when 212 then
# line 1413 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 217 then
# line 1416 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 781
		_goto_level = _again
		next
	end
  end
		end
	when 19 then
# line 1393 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  emit_table(PUNCTUATION)
            @cs = 446; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 17 then
# line 1416 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  p = p - 1; 	begin
		 @cs = 781
		_goto_level = _again
		next
	end
  end
		end
	when 210 then
# line 1 "NONE"
		begin
	case  @act
	when 43 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS_BEGIN);
            @cs = 446; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 44 then
	begin begin p = (( @te))-1; end
 emit(:tCONSTANT)
            @cs = 446; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 45 then
	begin begin p = (( @te))-1; end
 emit(:tIDENTIFIER)
            @cs = 446; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
end 
			end
	when 22 then
# line 1428 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit(:tLABEL, tok(@ts, @te - 2), @ts, @te - 1)
           p = p - 1;  @cs = 766; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 227 then
# line 1434 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 781
		_goto_level = _again
		next
	end
  end
		end
	when 226 then
# line 525 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 229 then
# line 1431 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 228 then
# line 1434 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 781
		_goto_level = _again
		next
	end
  end
		end
	when 21 then
# line 1434 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  p = p - 1; 	begin
		 @cs = 781
		_goto_level = _again
		next
	end
  end
		end
	when 235 then
# line 1460 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_table(PUNCTUATION)
            @cs = 474; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 234 then
# line 1466 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 781
		_goto_level = _again
		next
	end
  end
		end
	when 233 then
# line 525 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 245 then
# line 1445 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tCONSTANT)
            @cs = (arg_or_cmdarg(cmd_state)); 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 236 then
# line 1449 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tIDENTIFIER)
            @cs = (arg_or_cmdarg(cmd_state)); 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 241 then
# line 1460 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(PUNCTUATION)
            @cs = 474; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 239 then
# line 1463 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 244 then
# line 1466 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 781
		_goto_level = _again
		next
	end
  end
		end
	when 268 then
# line 1526 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        # Unlike expr_beg as invoked in the next rule, do not warn
        p = @ts - 1
        	begin
		 @cs = 781
		_goto_level = _again
		next
	end

       end
		end
	when 251 then
# line 1544 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        if tok(tm, tm + 1) == '/'.freeze
          # Ambiguous regexp literal.
          diagnostic :warning, :ambiguous_literal, nil, range(tm, tm + 1)
        end

        p = tm - 1
        	begin
		 @cs = 543
		_goto_level = _again
		next
	end

       end
		end
	when 257 then
# line 1568 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; p = p - 1; 	begin
		 @cs = 543
		_goto_level = _again
		next
	end
  end
		end
	when 24 then
# line 1576 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = @ts - 1; 	begin
		 @cs = 543
		_goto_level = _again
		next
	end
  end
		end
	when 259 then
# line 1585 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = tm - 1; 	begin
		 @cs = 781
		_goto_level = _again
		next
	end
  end
		end
	when 39 then
# line 1596 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        p = @ts - 1
        	begin
		 @cs = 781
		_goto_level = _again
		next
	end

       end
		end
	when 246 then
# line 1610 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 543
		_goto_level = _again
		next
	end
  end
		end
	when 247 then
# line 525 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 258 then
# line 1535 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 543
		_goto_level = _again
		next
	end
  end
		end
	when 254 then
# line 1557 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        diagnostic :warning, :ambiguous_prefix, { :prefix => tok(tm, @te) },
                   range(tm, @te)

        p = tm - 1
        	begin
		 @cs = 543
		_goto_level = _again
		next
	end

       end
		end
	when 256 then
# line 1573 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 543
		_goto_level = _again
		next
	end
  end
		end
	when 250 then
# line 1596 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        p = @ts - 1
        	begin
		 @cs = 781
		_goto_level = _again
		next
	end

       end
		end
	when 249 then
# line 1601 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 267 then
# line 1610 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 543
		_goto_level = _again
		next
	end
  end
		end
	when 25 then
# line 1601 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
		end
	when 41 then
# line 1610 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  p = p - 1; 	begin
		 @cs = 543
		_goto_level = _again
		next
	end
  end
		end
	when 23 then
# line 1 "NONE"
		begin
	case  @act
	when 71 then
	begin begin p = (( @te))-1; end

        if tok(tm, tm + 1) == '/'.freeze
          # Ambiguous regexp literal.
          diagnostic :warning, :ambiguous_literal, nil, range(tm, tm + 1)
        end

        p = tm - 1
        	begin
		 @cs = 543
		_goto_level = _again
		next
	end

      end
	when 72 then
	begin begin p = (( @te))-1; end

        diagnostic :warning, :ambiguous_prefix, { :prefix => tok(tm, @te) },
                   range(tm, @te)

        p = tm - 1
        	begin
		 @cs = 543
		_goto_level = _again
		next
	end

      end
	when 77 then
	begin begin p = (( @te))-1; end

        p = @ts - 1
        	begin
		 @cs = 781
		_goto_level = _again
		next
	end

      end
	else
	begin begin p = (( @te))-1; end
end
end 
			end
	when 43 then
# line 1646 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = @ts - 1
           	begin
		 @cs = 474
		_goto_level = _again
		next
	end
  end
		end
	when 272 then
# line 525 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 273 then
# line 1646 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
           	begin
		 @cs = 474
		_goto_level = _again
		next
	end
  end
		end
	when 44 then
# line 1646 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  p = @ts - 1
           	begin
		 @cs = 474
		_goto_level = _again
		next
	end
  end
		end
	when 42 then
# line 1 "NONE"
		begin
	case  @act
	when 84 then
	begin begin p = (( @te))-1; end

        if @cond.active?
          emit(:kDO_COND, 'do'.freeze, @te - 2, @te)
        else
          emit(:kDO, 'do'.freeze, @te - 2, @te)
        end
         @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 85 then
	begin begin p = (( @te))-1; end
 p = @ts - 1
           	begin
		 @cs = 474
		_goto_level = _again
		next
	end
 end
end 
			end
	when 283 then
# line 1682 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_do(true)
            @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 276 then
# line 1688 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 781
		_goto_level = _again
		next
	end
  end
		end
	when 277 then
# line 525 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 278 then
# line 1685 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 281 then
# line 1688 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 781
		_goto_level = _again
		next
	end
  end
		end
	when 287 then
# line 1712 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 543
		_goto_level = _again
		next
	end
  end
		end
	when 286 then
# line 525 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 295 then
# line 1704 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1; 	begin
		 @cs = 543
		_goto_level = _again
		next
	end
  end
		end
	when 289 then
# line 1706 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 293 then
# line 1712 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 543
		_goto_level = _again
		next
	end
  end
		end
	when 288 then
# line 1 "NONE"
		begin
	case  @act
	when 92 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 543; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 93 then
	begin begin p = (( @te))-1; end
 p = @ts - 1; 	begin
		 @cs = 543
		_goto_level = _again
		next
	end
 end
end 
			end
	when 56 then
# line 1727 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tUNARY_NUM, tok(@ts, @ts + 1), @ts, @ts + 1)
        p = p - 1;  @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 328 then
# line 1744 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        type = delimiter = tok[0].chr
        p = p - 1; 	begin
		 @cs = (push_literal(type, delimiter, @ts))
		_goto_level = _again
		next
	end

       end
		end
	when 320 then
# line 1751 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        type, delimiter = @source_buffer.slice(@ts).chr, tok[-1].chr
        	begin
		 @cs = (push_literal(type, delimiter, @ts))
		_goto_level = _again
		next
	end

       end
		end
	when 54 then
# line 1758 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        type, delimiter = tok[0..-2], tok[-1].chr
        	begin
		 @cs = (push_literal(type, delimiter, @ts))
		_goto_level = _again
		next
	end

       end
		end
	when 341 then
# line 1833 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        p = p - 1; p = p - 1;
        emit(:tSYMBEG, tok(@ts, @ts + 1), @ts, @ts + 1)
        	begin
		 @cs = 333
		_goto_level = _again
		next
	end

       end
		end
	when 329 then
# line 1841 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        type, delimiter = tok, tok[-1].chr
        	begin
		 @cs = (push_literal(type, delimiter, @ts))
		_goto_level = _again
		next
	end

       end
		end
	when 340 then
# line 1849 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tSYMBOL, tok(@ts + 1, @ts + 2))
         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 68 then
# line 1863 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tSYMBOL, tok(@ts + 1), @ts)
         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 351 then
# line 1904 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        escape = { " "  => '\s', "\r" => '\r', "\n" => '\n', "\t" => '\t',
                   "\v" => '\v', "\f" => '\f' }[@source_buffer.slice(@ts + 1)]
        diagnostic :warning, :invalid_escape_use, { :escape => escape }, range

        p = @ts - 1
        	begin
		 @cs = 781
		_goto_level = _again
		next
	end

       end
		end
	when 350 then
# line 1914 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        diagnostic :fatal, :incomplete_escape, nil, range(@ts, @ts + 1)
       end
		end
	when 330 then
# line 1973 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_table(PUNCTUATION_BEGIN)
           	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 51 then
# line 1994 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        p = p - 1;

        if version?(18)
          ident = tok(@ts, @te - 2)

          emit((@source_buffer.slice(@ts) =~ /[A-Z]/) ? :tCONSTANT : :tIDENTIFIER,
               ident, @ts, @te - 2)
          p = p - 1; # continue as a symbol

          if !@static_env.nil? && @static_env.declared?(ident)
             @cs = 781;
          else
             @cs = (arg_or_cmdarg(cmd_state));
          end
        else
          emit(:tLABEL, tok(@ts, @te - 2), @ts, @te - 1)
           @cs = 766;
        end

        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 327 then
# line 2032 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        if @version >= 28
          if @lambda_stack.any? && @lambda_stack.last + 1 == @paren_nest
            # To reject `->(...)` like `->...`
            emit(:tDOT3)
          else
            emit(:tBDOT3)
          end
        elsif @version >= 27
          emit(:tBDOT3)
        else
          emit(:tDOT3)
        end

         @cs = 543; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 48 then
# line 2068 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tIDENTIFIER, ident_tok, ident_ts, ident_te)
        p = ident_te - 1

        if !@static_env.nil? && @static_env.declared?(ident_tok) && @version < 25
           @cs = 446;
        else
           @cs = 505;
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 314 then
# line 2087 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        p = @ts - 1
        @cs_before_block_comment = @cs
        	begin
		 @cs = 185
		_goto_level = _again
		next
	end

       end
		end
	when 55 then
# line 2103 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = @ts - 1; 	begin
		 @cs = 781
		_goto_level = _again
		next
	end
  end
		end
	when 298 then
# line 525 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 325 then
# line 1727 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tUNARY_NUM, tok(@ts, @ts + 1), @ts, @ts + 1)
        p = p - 1;  @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 324 then
# line 1734 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tSTAR, '*'.freeze)
           	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 321 then
# line 1758 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        type, delimiter = tok[0..-2], tok[-1].chr
        	begin
		 @cs = (push_literal(type, delimiter, @ts))
		_goto_level = _again
		next
	end

       end
		end
	when 319 then
# line 1764 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        diagnostic :fatal, :string_eof, nil, range(@ts, @ts + 1)
       end
		end
	when 348 then
# line 1824 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        diagnostic :error, :unterminated_heredoc_id, nil, range(@ts, @ts + 1)
       end
		end
	when 331 then
# line 1863 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1), @ts)
         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 344 then
# line 1871 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if @version >= 27
          diagnostic :error, diag_msg, { name: tok(tm, @te) }, range(tm, @te)
        else
          emit(:tCOLON, tok(@ts, @ts + 1), @ts, @ts + 1)
          p = @ts
        end

         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 349 then
# line 1914 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        diagnostic :fatal, :incomplete_escape, nil, range(@ts, @ts + 1)
       end
		end
	when 355 then
# line 1920 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        p = @ts - 1
        	begin
		 @cs = 781
		_goto_level = _again
		next
	end

       end
		end
	when 322 then
# line 1973 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(PUNCTUATION_BEGIN)
           	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 326 then
# line 2021 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if @version >= 27
          emit(:tBDOT2)
        else
          emit(:tDOT2)
        end

         @cs = 543; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 301 then
# line 1313 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    emit(:tIDENTIFIER)

    if !@static_env.nil? && @static_env.declared?(tok)
       @cs = 446; 	begin
		p += 1
		_goto_level = _out
		next
	end

    else
       @cs = (arg_or_cmdarg(cmd_state)); 	begin
		p += 1
		_goto_level = _out
		next
	end

    end
   end
		end
	when 311 then
# line 2084 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 313 then
# line 2087 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        p = @ts - 1
        @cs_before_block_comment = @cs
        	begin
		 @cs = 185
		_goto_level = _again
		next
	end

       end
		end
	when 316 then
# line 2103 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1; 	begin
		 @cs = 781
		_goto_level = _again
		next
	end
  end
		end
	when 53 then
# line 1764 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
        diagnostic :fatal, :string_eof, nil, range(@ts, @ts + 1)
       end
		end
	when 72 then
# line 1824 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
        diagnostic :error, :unterminated_heredoc_id, nil, range(@ts, @ts + 1)
       end
		end
	when 73 then
# line 1891 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 47 then
# line 1313 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
    emit(:tIDENTIFIER)

    if !@static_env.nil? && @static_env.declared?(tok)
       @cs = 446; 	begin
		p += 1
		_goto_level = _out
		next
	end

    else
       @cs = (arg_or_cmdarg(cmd_state)); 	begin
		p += 1
		_goto_level = _out
		next
	end

    end
   end
		end
	when 52 then
# line 2084 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
		end
	when 67 then
# line 2103 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  p = @ts - 1; 	begin
		 @cs = 781
		_goto_level = _again
		next
	end
  end
		end
	when 50 then
# line 1 "NONE"
		begin
	case  @act
	when 98 then
	begin begin p = (( @te))-1; end

        emit(:tUNARY_NUM, tok(@ts, @ts + 1), @ts, @ts + 1)
        p = p - 1;  @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 105 then
	begin begin p = (( @te))-1; end

        diagnostic :error, :unterminated_heredoc_id, nil, range(@ts, @ts + 1)
      end
	when 116 then
	begin begin p = (( @te))-1; end

        if @version >= 27
          emit(:tPIPE, tok(@ts, @ts + 1), @ts, @ts + 1)
          p = p - 1;
           @cs = 543; 	begin
		p += 1
		_goto_level = _out
		next
	end

        else
          p -= 2
          	begin
		 @cs = 781
		_goto_level = _again
		next
	end

        end
      end
	when 120 then
	begin begin p = (( @te))-1; end
 emit_table(PUNCTUATION_BEGIN)
           	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 121 then
	begin begin p = (( @te))-1; end
 emit(:kRESCUE, 'rescue'.freeze, @ts, tm)
           p = tm - 1
            @cs = 519; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 122 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS_BEGIN)
           @command_start = true
            @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 126 then
	begin begin p = (( @te))-1; end
 p = @ts - 1
           	begin
		 @cs = 781
		_goto_level = _again
		next
	end
 end
	when 127 then
	begin begin p = (( @te))-1; end

    emit(:tIDENTIFIER)

    if !@static_env.nil? && @static_env.declared?(tok)
       @cs = 446; 	begin
		p += 1
		_goto_level = _out
		next
	end

    else
       @cs = (arg_or_cmdarg(cmd_state)); 	begin
		p += 1
		_goto_level = _out
		next
	end

    end
  end
	when 131 then
	begin begin p = (( @te))-1; end
 p = @ts - 1; 	begin
		 @cs = 781
		_goto_level = _again
		next
	end
 end
end 
			end
	when 386 then
# line 2123 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 543
		_goto_level = _again
		next
	end
  end
		end
	when 387 then
# line 525 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 388 then
# line 2111 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 392 then
# line 2123 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 543
		_goto_level = _again
		next
	end
  end
		end
	when 76 then
# line 2133 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = @ts - 1
           	begin
		 @cs = 781
		_goto_level = _again
		next
	end
  end
		end
	when 396 then
# line 2138 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        	begin
		 @cs = (push_literal(tok, tok, @ts))
		_goto_level = _again
		next
	end

       end
		end
	when 395 then
# line 2148 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 543
		_goto_level = _again
		next
	end
  end
		end
	when 394 then
# line 525 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 398 then
# line 2142 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 397 then
# line 2148 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 543
		_goto_level = _again
		next
	end
  end
		end
	when 75 then
# line 2148 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  p = p - 1; 	begin
		 @cs = 543
		_goto_level = _again
		next
	end
  end
		end
	when 431 then
# line 2159 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tLAMBDA, '->'.freeze, @ts, @ts + 2)

        @lambda_stack.push @paren_nest
         @cs = 446; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 85 then
# line 2200 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit(:kCLASS, 'class'.freeze, @ts, @ts + 5)
           emit(:tLSHFT, '<<'.freeze,    @te - 2, @te)
            @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 406 then
# line 2336 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        type, delimiter = tok, tok[-1].chr
        	begin
		 @cs = (push_literal(type, delimiter, @ts, nil, false, false, true))
		_goto_level = _again
		next
	end

       end
		end
	when 78 then
# line 2354 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = @ts - 1; 	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 328
		_goto_level = _again
		next
	end
  end
		end
	when 427 then
# line 2361 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_table(PUNCTUATION)
            @cs = 453; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 480 then
# line 2385 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit_table(PUNCTUATION)
        	begin
		 @cs = 773
		_goto_level = _again
		next
	end

       end
		end
	when 420 then
# line 2394 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit_table(PUNCTUATION);
         @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 425 then
# line 2429 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit(:tOP_ASGN, tok(@ts, @te - 1))
            @cs = 543; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 411 then
# line 2433 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit(:tEH, '?'.freeze)
            @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 408 then
# line 2452 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_table(PUNCTUATION)
            @cs = 543; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 410 then
# line 2465 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit(:tSEMI, ';'.freeze)
           @command_start = true
            @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 485 then
# line 2469 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        diagnostic :error, :bare_backslash, nil, range(@ts, @ts + 1)
        p = p - 1;
       end
		end
	when 405 then
# line 2475 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        diagnostic :fatal, :unexpected, { :character => tok.inspect[1..-2] }
       end
		end
	when 404 then
# line 525 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 496 then
# line 2196 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(KEYWORDS)
            @cs = 333; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 494 then
# line 2200 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:kCLASS, 'class'.freeze, @ts, @ts + 5)
           emit(:tLSHFT, '<<'.freeze,    @te - 2, @te)
            @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 493 then
# line 2211 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(KEYWORDS)
           @command_start = true
            @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 435 then
# line 2286 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        diagnostic :error, :no_dot_digit_literal
       end
		end
	when 482 then
# line 2346 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tCONSTANT)
            @cs = (arg_or_cmdarg(cmd_state)); 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 424 then
# line 2354 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1; 	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 328
		_goto_level = _again
		next
	end
  end
		end
	when 432 then
# line 2361 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(PUNCTUATION)
            @cs = 453; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 488 then
# line 1313 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    emit(:tIDENTIFIER)

    if !@static_env.nil? && @static_env.declared?(tok)
       @cs = 446; 	begin
		p += 1
		_goto_level = _out
		next
	end

    else
       @cs = (arg_or_cmdarg(cmd_state)); 	begin
		p += 1
		_goto_level = _out
		next
	end

    end
   end
		end
	when 430 then
# line 2385 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit_table(PUNCTUATION)
        	begin
		 @cs = 773
		_goto_level = _again
		next
	end

       end
		end
	when 426 then
# line 2394 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit_table(PUNCTUATION);
         @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 419 then
# line 2400 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(PUNCTUATION)
            @cs = 543; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 433 then
# line 2452 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(PUNCTUATION)
            @cs = 543; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 417 then
# line 2459 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 423 then
# line 2475 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        diagnostic :fatal, :unexpected, { :character => tok.inspect[1..-2] }
       end
		end
	when 83 then
# line 2259 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 79 then
# line 2286 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
        diagnostic :error, :no_dot_digit_literal
       end
		end
	when 82 then
# line 2318 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 77 then
# line 2475 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
        diagnostic :fatal, :unexpected, { :character => tok.inspect[1..-2] }
       end
		end
	when 80 then
# line 1 "NONE"
		begin
	case  @act
	when 144 then
	begin begin p = (( @te))-1; end

        if @lambda_stack.last == @paren_nest
          @lambda_stack.pop

          if tok == '{'.freeze
            emit(:tLAMBEG, '{'.freeze)
          else # 'do'
            emit(:kDO_LAMBDA, 'do'.freeze)
          end
        else
          if tok == '{'.freeze
            emit(:tLCURLY, '{'.freeze)
          else # 'do'
            emit_do
          end
        end
        if tok == '{'.freeze
          @paren_nest += 1
        end
        @command_start = true

         @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 145 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 333; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 146 then
	begin begin p = (( @te))-1; end
 emit(:kCLASS, 'class'.freeze, @ts, @ts + 5)
           emit(:tLSHFT, '<<'.freeze,    @te - 2, @te)
            @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 147 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 543; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 148 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
           @command_start = true
            @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 149 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 519; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 150 then
	begin begin p = (( @te))-1; end

        emit_table(KEYWORDS)

        if version?(18) && tok == 'not'.freeze
           @cs = 543; 	begin
		p += 1
		_goto_level = _out
		next
	end

        else
           @cs = 474; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
      end
	when 151 then
	begin begin p = (( @te))-1; end

        if version?(18)
          emit(:tIDENTIFIER)

          unless !@static_env.nil? && @static_env.declared?(tok)
             @cs = (arg_or_cmdarg(cmd_state));
          end
        else
          emit(:k__ENCODING__, '__ENCODING__'.freeze)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 152 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
           	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 153 then
	begin begin p = (( @te))-1; end

        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 155 then
	begin begin p = (( @te))-1; end

        if version?(18, 19, 20)
          diagnostic :error,
                     :trailing_in_number, { :character => tok(@te - 1, @te) },
                     range(@te - 1, @te)
        else
          emit(:tINTEGER, tok(@ts, @te - 1).to_i, @ts, @te - 1)
          p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
      end
	when 156 then
	begin begin p = (( @te))-1; end

        if version?(18, 19, 20)
          diagnostic :error,
                     :trailing_in_number, { :character => tok(@te - 1, @te) },
                     range(@te - 1, @te)
        else
          emit(:tFLOAT, tok(@ts, @te - 1).to_f, @ts, @te - 1)
          p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
      end
	when 157 then
	begin begin p = (( @te))-1; end

        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 159 then
	begin begin p = (( @te))-1; end
 emit(:tCONSTANT)
            @cs = (arg_or_cmdarg(cmd_state)); 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 163 then
	begin begin p = (( @te))-1; end

    emit(:tIDENTIFIER)

    if !@static_env.nil? && @static_env.declared?(tok)
       @cs = 446; 	begin
		p += 1
		_goto_level = _out
		next
	end

    else
       @cs = (arg_or_cmdarg(cmd_state)); 	begin
		p += 1
		_goto_level = _out
		next
	end

    end
  end
	when 164 then
	begin begin p = (( @te))-1; end

        if tm == @te
          # Suffix was consumed, e.g. foo!
          emit(:tFID)
        else
          # Suffix was not consumed, e.g. foo!=
          emit(:tIDENTIFIER, tok(@ts, tm), @ts, tm)
          p = tm - 1
        end
         @cs = 474; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 166 then
	begin begin p = (( @te))-1; end

        emit_table(PUNCTUATION);
         @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 167 then
	begin begin p = (( @te))-1; end
 emit_table(PUNCTUATION)
            @cs = 543; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
end 
			end
	when 95 then
# line 2505 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = tm - 1; 	begin
		 @cs = 781
		_goto_level = _again
		next
	end
  end
		end
	when 501 then
# line 2508 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit(:tNL, nil, @newline_s, @newline_s + 1)
           p = p - 1;  @cs = 185; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 504 then
# line 2491 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if @version < 27
          # Ruby before 2.7 doesn't support comments before leading dot.
          # If a line after "a" starts with a comment then "a" is a self-contained statement.
          # So in that case we emit a special tNL token and start reading the
          # next line as a separate statement.
          #
          # Note: block comments before leading dot are not supported on any version of Ruby.
          emit(:tNL, nil, @newline_s, @newline_s + 1)
          p = p - 1;  @cs = 185; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
       end
		end
	when 503 then
# line 2508 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tNL, nil, @newline_s, @newline_s + 1)
           p = p - 1;  @cs = 185; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 90 then
# line 2491 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
        if @version < 27
          # Ruby before 2.7 doesn't support comments before leading dot.
          # If a line after "a" starts with a comment then "a" is a self-contained statement.
          # So in that case we emit a special tNL token and start reading the
          # next line as a separate statement.
          #
          # Note: block comments before leading dot are not supported on any version of Ruby.
          emit(:tNL, nil, @newline_s, @newline_s + 1)
          p = p - 1;  @cs = 185; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
       end
		end
	when 86 then
# line 2508 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  emit(:tNL, nil, @newline_s, @newline_s + 1)
           p = p - 1;  @cs = 185; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 91 then
# line 1 "NONE"
		begin
	case  @act
	when 180 then
	begin begin p = (( @te))-1; end

        if @version < 27
          # Ruby before 2.7 doesn't support comments before leading dot.
          # If a line after "a" starts with a comment then "a" is a self-contained statement.
          # So in that case we emit a special tNL token and start reading the
          # next line as a separate statement.
          #
          # Note: block comments before leading dot are not supported on any version of Ruby.
          emit(:tNL, nil, @newline_s, @newline_s + 1)
          p = p - 1;  @cs = 185; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
      end
	when 182 then
	begin begin p = (( @te))-1; end
 emit(:tNL, nil, @newline_s, @newline_s + 1)
           p = p - 1;  @cs = 185; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
end 
			end
	when 507 then
# line 2518 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit_comment(@eq_begin_s, @te)
        	begin
		 @cs = (@cs_before_block_comment)
		_goto_level = _again
		next
	end

       end
		end
	when 506 then
# line 2526 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        diagnostic :fatal, :embedded_document, nil,
                   range(@eq_begin_s, @eq_begin_s + '=begin'.length)
       end
		end
	when 106 then
# line 2536 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  @eq_begin_s = @ts
           	begin
		 @cs = 967
		_goto_level = _again
		next
	end
  end
		end
	when 2 then
# line 2540 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = pe - 3  end
		end
	when 98 then
# line 2543 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  cmd_state = true; p = p - 1; 	begin
		 @cs = 773
		_goto_level = _again
		next
	end
  end
		end
	when 99 then
# line 525 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 100 then
# line 2533 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 105 then
# line 2536 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  @eq_begin_s = @ts
           	begin
		 @cs = 967
		_goto_level = _again
		next
	end
  end
		end
	when 104 then
# line 2543 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  cmd_state = true; p = p - 1; 	begin
		 @cs = 773
		_goto_level = _again
		next
	end
  end
		end
	when 1 then
# line 2543 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  cmd_state = true; p = p - 1; 	begin
		 @cs = 773
		_goto_level = _again
		next
	end
  end
		end
	when 66 then
# line 499 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 1218 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
	when 110 then
# line 499 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 943 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 140 then
# line 499 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 943 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 168 then
# line 499 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 943 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 174 then
# line 499 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 943 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 180 then
# line 499 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 943 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 187 then
# line 499 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 943 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 190 then
# line 499 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 943 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 198 then
# line 499 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 943 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 269 then
# line 499 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 1526 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        # Unlike expr_beg as invoked in the next rule, do not warn
        p = @ts - 1
        	begin
		 @cs = 781
		_goto_level = _again
		next
	end

       end
		end
	when 260 then
# line 499 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 1585 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = tm - 1; 	begin
		 @cs = 781
		_goto_level = _again
		next
	end
  end
		end
	when 252 then
# line 499 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 1596 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        p = @ts - 1
        	begin
		 @cs = 781
		_goto_level = _again
		next
	end

       end
		end
	when 352 then
# line 499 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 1904 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        escape = { " "  => '\s', "\r" => '\r', "\n" => '\n', "\t" => '\t',
                   "\v" => '\v', "\f" => '\f' }[@source_buffer.slice(@ts + 1)]
        diagnostic :warning, :invalid_escape_use, { :escape => escape }, range

        p = @ts - 1
        	begin
		 @cs = 781
		_goto_level = _again
		next
	end

       end
		end
	when 315 then
# line 499 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 2087 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        p = @ts - 1
        @cs_before_block_comment = @cs
        	begin
		 @cs = 185
		_goto_level = _again
		next
	end

       end
		end
	when 434 then
# line 499 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 2441 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        if @paren_nest == 0
          diagnostic :warning, :triple_dot_at_eol, nil, range(@ts, @te - 1)
        end

        emit(:tDOT3, '...'.freeze, @ts, @te - 1)
        p = p - 1;
         @cs = 543; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 508 then
# line 499 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 2518 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit_comment(@eq_begin_s, @te)
        	begin
		 @cs = (@cs_before_block_comment)
		_goto_level = _again
		next
	end

       end
		end
	when 505 then
# line 499 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 2523 "lib/parser/lexer.rl"
		begin
 @te = p+1
		end
	when 107 then
# line 499 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 2536 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  @eq_begin_s = @ts
           	begin
		 @cs = 967
		_goto_level = _again
		next
	end
  end
		end
	when 3 then
# line 499 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 2540 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = pe - 3  end
		end
	when 456 then
# line 633 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tRATIONAL,  Rational(chars)) } 		end
# line 2259 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 454 then
# line 634 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tIMAGINARY, Complex(0, chars)) } 		end
# line 2259 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 459 then
# line 635 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tIMAGINARY, Complex(0, Rational(chars))) } 		end
# line 2259 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 457 then
# line 636 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars, @ts, @te - 2); p -= 2 } 		end
# line 2259 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 455 then
# line 637 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars, @ts, @te - 2); p -= 2 } 		end
# line 2259 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 458 then
# line 638 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars, @ts, @te - 6); p -= 6 } 		end
# line 2259 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 447 then
# line 642 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tIMAGINARY, Complex(0, Float(chars))) } 		end
# line 2318 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 448 then
# line 643 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tFLOAT,     Float(chars), @ts, @te - 2); p -= 2 } 		end
# line 2318 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 449 then
# line 647 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tRATIONAL,  Rational(chars)) } 		end
# line 2318 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 451 then
# line 648 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tIMAGINARY, Complex(0, Rational(chars))) } 		end
# line 2318 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 450 then
# line 649 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tFLOAT,     Float(chars), @ts, @te - 6); p -= 6 } 		end
# line 2318 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 134 then
# line 664 "lib/parser/lexer.rl"
		begin

    @escape = ""

    codepoints  = tok(@escape_s + 2, p - 1)
    codepoint_s = @escape_s + 2

    if @version < 24
      if codepoints.start_with?(" ") || codepoints.start_with?("\t")
        diagnostic :fatal, :invalid_unicode_escape, nil,
          range(@escape_s + 2, @escape_s + 3)
      end

      if spaces_p = codepoints.index(/[ \t]{2}/)
        diagnostic :fatal, :invalid_unicode_escape, nil,
          range(codepoint_s + spaces_p + 1, codepoint_s + spaces_p + 2)
      end

      if codepoints.end_with?(" ") || codepoints.end_with?("\t")
        diagnostic :fatal, :invalid_unicode_escape, nil, range(p - 1, p)
      end
    end

    codepoints.scan(/([0-9a-fA-F]+)|([ \t]+)/).each do |(codepoint_str, spaces)|
      if spaces
        codepoint_s += spaces.length
      else
        codepoint = codepoint_str.to_i(16)

        if codepoint >= 0x110000
          diagnostic :error, :unicode_point_too_large, nil,
                     range(codepoint_s, codepoint_s + codepoint_str.length)
          break
        end

        @escape     += codepoint.chr(Encoding::UTF_8)
        codepoint_s += codepoint_str.length
      end
    end
  		end
# line 888 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 162 then
# line 664 "lib/parser/lexer.rl"
		begin

    @escape = ""

    codepoints  = tok(@escape_s + 2, p - 1)
    codepoint_s = @escape_s + 2

    if @version < 24
      if codepoints.start_with?(" ") || codepoints.start_with?("\t")
        diagnostic :fatal, :invalid_unicode_escape, nil,
          range(@escape_s + 2, @escape_s + 3)
      end

      if spaces_p = codepoints.index(/[ \t]{2}/)
        diagnostic :fatal, :invalid_unicode_escape, nil,
          range(codepoint_s + spaces_p + 1, codepoint_s + spaces_p + 2)
      end

      if codepoints.end_with?(" ") || codepoints.end_with?("\t")
        diagnostic :fatal, :invalid_unicode_escape, nil, range(p - 1, p)
      end
    end

    codepoints.scan(/([0-9a-fA-F]+)|([ \t]+)/).each do |(codepoint_str, spaces)|
      if spaces
        codepoint_s += spaces.length
      else
        codepoint = codepoint_str.to_i(16)

        if codepoint >= 0x110000
          diagnostic :error, :unicode_point_too_large, nil,
                     range(codepoint_s, codepoint_s + codepoint_str.length)
          break
        end

        @escape     += codepoint.chr(Encoding::UTF_8)
        codepoint_s += codepoint_str.length
      end
    end
  		end
# line 888 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 373 then
# line 664 "lib/parser/lexer.rl"
		begin

    @escape = ""

    codepoints  = tok(@escape_s + 2, p - 1)
    codepoint_s = @escape_s + 2

    if @version < 24
      if codepoints.start_with?(" ") || codepoints.start_with?("\t")
        diagnostic :fatal, :invalid_unicode_escape, nil,
          range(@escape_s + 2, @escape_s + 3)
      end

      if spaces_p = codepoints.index(/[ \t]{2}/)
        diagnostic :fatal, :invalid_unicode_escape, nil,
          range(codepoint_s + spaces_p + 1, codepoint_s + spaces_p + 2)
      end

      if codepoints.end_with?(" ") || codepoints.end_with?("\t")
        diagnostic :fatal, :invalid_unicode_escape, nil, range(p - 1, p)
      end
    end

    codepoints.scan(/([0-9a-fA-F]+)|([ \t]+)/).each do |(codepoint_str, spaces)|
      if spaces
        codepoint_s += spaces.length
      else
        codepoint = codepoint_str.to_i(16)

        if codepoint >= 0x110000
          diagnostic :error, :unicode_point_too_large, nil,
                     range(codepoint_s, codepoint_s + codepoint_str.length)
          break
        end

        @escape     += codepoint.chr(Encoding::UTF_8)
        codepoint_s += codepoint_str.length
      end
    end
  		end
# line 1891 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 118 then
# line 704 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 888 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 146 then
# line 704 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 888 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 357 then
# line 704 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 1891 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 121 then
# line 711 "lib/parser/lexer.rl"
		begin

    diagnostic :fatal, :invalid_escape
  		end
# line 888 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 149 then
# line 711 "lib/parser/lexer.rl"
		begin

    diagnostic :fatal, :invalid_escape
  		end
# line 888 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 360 then
# line 711 "lib/parser/lexer.rl"
		begin

    diagnostic :fatal, :invalid_escape
  		end
# line 1891 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 123 then
# line 738 "lib/parser/lexer.rl"
		begin
 @escape = "\x7f" 		end
# line 888 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 151 then
# line 738 "lib/parser/lexer.rl"
		begin
 @escape = "\x7f" 		end
# line 888 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 362 then
# line 738 "lib/parser/lexer.rl"
		begin
 @escape = "\x7f" 		end
# line 1891 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 120 then
# line 745 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(@escape_s, p).to_i(8) % 0x100) 		end
# line 888 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 148 then
# line 745 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(@escape_s, p).to_i(8) % 0x100) 		end
# line 888 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 359 then
# line 745 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(@escape_s, p).to_i(8) % 0x100) 		end
# line 1891 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 137 then
# line 749 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(@escape_s + 1, p).to_i(16)) 		end
# line 888 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 165 then
# line 749 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(@escape_s + 1, p).to_i(16)) 		end
# line 888 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 376 then
# line 749 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(@escape_s + 1, p).to_i(16)) 		end
# line 1891 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 136 then
# line 753 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_hex_escape, nil, range(@escape_s - 1, p + 2)
      		end
# line 888 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 164 then
# line 753 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_hex_escape, nil, range(@escape_s - 1, p + 2)
      		end
# line 888 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 375 then
# line 753 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_hex_escape, nil, range(@escape_s - 1, p + 2)
      		end
# line 1891 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 131 then
# line 759 "lib/parser/lexer.rl"
		begin
 @escape = tok(@escape_s + 1, p).to_i(16).chr(Encoding::UTF_8) 		end
# line 888 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 159 then
# line 759 "lib/parser/lexer.rl"
		begin
 @escape = tok(@escape_s + 1, p).to_i(16).chr(Encoding::UTF_8) 		end
# line 888 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 370 then
# line 759 "lib/parser/lexer.rl"
		begin
 @escape = tok(@escape_s + 1, p).to_i(16).chr(Encoding::UTF_8) 		end
# line 1891 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 130 then
# line 763 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
      		end
# line 888 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 158 then
# line 763 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
      		end
# line 888 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 369 then
# line 763 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
      		end
# line 1891 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 135 then
# line 769 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
      		end
# line 888 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 163 then
# line 769 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
      		end
# line 888 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 374 then
# line 769 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
      		end
# line 1891 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 132 then
# line 783 "lib/parser/lexer.rl"
		begin

          diagnostic :fatal, :unterminated_unicode, nil, range(p - 1, p)
        		end
# line 888 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 160 then
# line 783 "lib/parser/lexer.rl"
		begin

          diagnostic :fatal, :unterminated_unicode, nil, range(p - 1, p)
        		end
# line 888 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 371 then
# line 783 "lib/parser/lexer.rl"
		begin

          diagnostic :fatal, :unterminated_unicode, nil, range(p - 1, p)
        		end
# line 1891 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 119 then
# line 809 "lib/parser/lexer.rl"
		begin

      diagnostic :fatal, :escape_eof, nil, range(p - 1, p)
    		end
# line 888 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 147 then
# line 809 "lib/parser/lexer.rl"
		begin

      diagnostic :fatal, :escape_eof, nil, range(p - 1, p)
    		end
# line 888 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 358 then
# line 809 "lib/parser/lexer.rl"
		begin

      diagnostic :fatal, :escape_eof, nil, range(p - 1, p)
    		end
# line 1891 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 171 then
# line 815 "lib/parser/lexer.rl"
		begin

    @escape_s = p
    @escape   = nil
  		end
# line 888 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 176 then
# line 815 "lib/parser/lexer.rl"
		begin

    @escape_s = p
    @escape   = nil
  		end
# line 888 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 57 then
# line 855 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 499 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
	when 30 then
# line 855 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1540 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 32 then
# line 855 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1556 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 34 then
# line 855 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1584 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 213 then
# line 855 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1413 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 232 then
# line 855 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1431 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 240 then
# line 855 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1463 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 33 then
# line 855 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1596 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        p = @ts - 1
        	begin
		 @cs = 781
		_goto_level = _again
		next
	end

       end
		end
	when 271 then
# line 855 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1601 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 263 then
# line 855 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1607 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 781
		_goto_level = _again
		next
	end
  end
		end
	when 282 then
# line 855 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1685 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 294 then
# line 855 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1706 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 290 then
# line 855 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1709 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 781
		_goto_level = _again
		next
	end
  end
		end
	when 58 then
# line 855 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1727 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tUNARY_NUM, tok(@ts, @ts + 1), @ts, @ts + 1)
        p = p - 1;  @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 49 then
# line 855 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 2068 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tIDENTIFIER, ident_tok, ident_ts, ident_te)
        p = ident_te - 1

        if !@static_env.nil? && @static_env.declared?(ident_tok) && @version < 25
           @cs = 446;
        else
           @cs = 505;
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 312 then
# line 855 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 2084 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 393 then
# line 855 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 2111 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 389 then
# line 855 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 2114 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
      if @in_kwarg
        p = p - 1; 	begin
		 @cs = 781
		_goto_level = _again
		next
	end

      else
        	begin
		 @cs = 185
		_goto_level = _again
		next
	end

      end
     end
		end
	when 402 then
# line 855 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 2142 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 399 then
# line 855 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 2145 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  	begin
		 @cs = 185
		_goto_level = _again
		next
	end
  end
		end
	when 486 then
# line 855 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 2459 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 418 then
# line 855 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 2462 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  	begin
		 @cs = 961
		_goto_level = _again
		next
	end
  end
		end
	when 101 then
# line 855 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 2533 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 262 then
# line 1057 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    current_literal = literal
    if current_literal
      current_literal.start_interp_brace
    end
  		end
# line 1507 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if @lambda_stack.last == @paren_nest
          @lambda_stack.pop
          emit(:tLAMBEG, '{'.freeze, @te - 1, @te)
        else
          emit(:tLCURLY, '{'.freeze, @te - 1, @te)
        end
        @command_start = true
        @paren_nest += 1
         @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 284 then
# line 1057 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    current_literal = literal
    if current_literal
      current_literal.start_interp_brace
    end
  		end
# line 1669 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if @lambda_stack.last == @paren_nest
          @lambda_stack.pop
          emit(:tLAMBEG, '{'.freeze)
        else
          emit(:tLBRACE_ARG, '{'.freeze)
        end
        @paren_nest += 1
        @command_start = true
         @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 384 then
# line 1057 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    current_literal = literal
    if current_literal
      current_literal.start_interp_brace
    end
  		end
# line 1949 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if @lambda_stack.last == @paren_nest
          @lambda_stack.pop
          @command_start = true
          emit(:tLAMBEG, '{'.freeze)
        else
          emit(:tLBRACE, '{'.freeze)
        end
        @paren_nest += 1
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 499 then
# line 1057 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    current_literal = literal
    if current_literal
      current_literal.start_interp_brace
    end
  		end
# line 2167 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if @lambda_stack.last == @paren_nest
          @lambda_stack.pop

          if tok == '{'.freeze
            emit(:tLAMBEG, '{'.freeze)
          else # 'do'
            emit(:kDO_LAMBDA, 'do'.freeze)
          end
        else
          if tok == '{'.freeze
            emit(:tLCURLY, '{'.freeze)
          else # 'do'
            emit_do
          end
        end
        if tok == '{'.freeze
          @paren_nest += 1
        end
        @command_start = true

         @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 500 then
# line 1066 "lib/parser/lexer.rl"
		begin

    current_literal = literal
    if current_literal
      if current_literal.end_interp_brace_and_try_closing
        if version?(18, 19)
          emit(:tRCURLY, '}'.freeze, p - 1, p)
          @cond.lexpop
          @cmdarg.lexpop
        else
          emit(:tSTRING_DEND, '}'.freeze, p - 1, p)
        end

        if current_literal.saved_herebody_s
          @herebody_s = current_literal.saved_herebody_s
        end


        p = p - 1;
         @cs = (next_state_for_literal(current_literal));
        	begin
		p += 1
		_goto_level = _out
		next
	end

      end
    end

    @paren_nest -= 1
  		end
# line 2404 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit_table(PUNCTUATION)

        if @version < 24
          @cond.lexpop
          @cmdarg.lexpop
        else
          @cond.pop
          @cmdarg.pop
        end

        if tok == '}'.freeze || tok == ']'.freeze
          if @version >= 25
             @cs = 781;
          else
             @cs = 511;
          end
        else # )
          # fnext expr_endfn; ?
        end

        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 60 then
# line 1215 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1218 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
	when 64 then
# line 1218 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 499 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
	when 216 then
# line 1218 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1413 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 231 then
# line 1218 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1431 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 243 then
# line 1218 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1463 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 265 then
# line 1218 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1604 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  	begin
		 @cs = 781
		_goto_level = _again
		next
	end
  end
		end
	when 280 then
# line 1218 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1685 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 292 then
# line 1218 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1706 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 318 then
# line 1218 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2084 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 391 then
# line 1218 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2111 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 401 then
# line 1218 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2142 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 422 then
# line 1218 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2459 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 103 then
# line 1218 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2533 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 237 then
# line 1259 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1453 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tFID, tok(@ts, tm), @ts, tm)
            @cs = (arg_or_cmdarg(cmd_state)); p = tm - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 332 then
# line 1259 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1855 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 303 then
# line 1259 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 2057 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
           	begin
		 @cs = 781
		_goto_level = _again
		next
	end
  end
		end
	when 415 then
# line 1259 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1 "NONE"
		begin
	case  @act
	when 144 then
	begin begin p = (( @te))-1; end

        if @lambda_stack.last == @paren_nest
          @lambda_stack.pop

          if tok == '{'.freeze
            emit(:tLAMBEG, '{'.freeze)
          else # 'do'
            emit(:kDO_LAMBDA, 'do'.freeze)
          end
        else
          if tok == '{'.freeze
            emit(:tLCURLY, '{'.freeze)
          else # 'do'
            emit_do
          end
        end
        if tok == '{'.freeze
          @paren_nest += 1
        end
        @command_start = true

         @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 145 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 333; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 146 then
	begin begin p = (( @te))-1; end
 emit(:kCLASS, 'class'.freeze, @ts, @ts + 5)
           emit(:tLSHFT, '<<'.freeze,    @te - 2, @te)
            @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 147 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 543; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 148 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
           @command_start = true
            @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 149 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 519; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 150 then
	begin begin p = (( @te))-1; end

        emit_table(KEYWORDS)

        if version?(18) && tok == 'not'.freeze
           @cs = 543; 	begin
		p += 1
		_goto_level = _out
		next
	end

        else
           @cs = 474; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
      end
	when 151 then
	begin begin p = (( @te))-1; end

        if version?(18)
          emit(:tIDENTIFIER)

          unless !@static_env.nil? && @static_env.declared?(tok)
             @cs = (arg_or_cmdarg(cmd_state));
          end
        else
          emit(:k__ENCODING__, '__ENCODING__'.freeze)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 152 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
           	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 153 then
	begin begin p = (( @te))-1; end

        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 155 then
	begin begin p = (( @te))-1; end

        if version?(18, 19, 20)
          diagnostic :error,
                     :trailing_in_number, { :character => tok(@te - 1, @te) },
                     range(@te - 1, @te)
        else
          emit(:tINTEGER, tok(@ts, @te - 1).to_i, @ts, @te - 1)
          p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
      end
	when 156 then
	begin begin p = (( @te))-1; end

        if version?(18, 19, 20)
          diagnostic :error,
                     :trailing_in_number, { :character => tok(@te - 1, @te) },
                     range(@te - 1, @te)
        else
          emit(:tFLOAT, tok(@ts, @te - 1).to_f, @ts, @te - 1)
          p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
      end
	when 157 then
	begin begin p = (( @te))-1; end

        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 159 then
	begin begin p = (( @te))-1; end
 emit(:tCONSTANT)
            @cs = (arg_or_cmdarg(cmd_state)); 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 163 then
	begin begin p = (( @te))-1; end

    emit(:tIDENTIFIER)

    if !@static_env.nil? && @static_env.declared?(tok)
       @cs = 446; 	begin
		p += 1
		_goto_level = _out
		next
	end

    else
       @cs = (arg_or_cmdarg(cmd_state)); 	begin
		p += 1
		_goto_level = _out
		next
	end

    end
  end
	when 164 then
	begin begin p = (( @te))-1; end

        if tm == @te
          # Suffix was consumed, e.g. foo!
          emit(:tFID)
        else
          # Suffix was not consumed, e.g. foo!=
          emit(:tIDENTIFIER, tok(@ts, tm), @ts, tm)
          p = tm - 1
        end
         @cs = 474; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 166 then
	begin begin p = (( @te))-1; end

        emit_table(PUNCTUATION);
         @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 167 then
	begin begin p = (( @te))-1; end
 emit_table(PUNCTUATION)
            @cs = 543; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
end 
			end
	when 238 then
# line 1260 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1453 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tFID, tok(@ts, tm), @ts, tm)
            @cs = (arg_or_cmdarg(cmd_state)); p = tm - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 333 then
# line 1260 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1855 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 305 then
# line 1260 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 2057 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
           	begin
		 @cs = 781
		_goto_level = _again
		next
	end
  end
		end
	when 416 then
# line 1260 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 2368 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if tm == @te
          # Suffix was consumed, e.g. foo!
          emit(:tFID)
        else
          # Suffix was not consumed, e.g. foo!=
          emit(:tIDENTIFIER, tok(@ts, tm), @ts, tm)
          p = tm - 1
        end
         @cs = 474; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 334 then
# line 1265 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1855 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 306 then
# line 1265 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 2057 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
           	begin
		 @cs = 781
		_goto_level = _again
		next
	end
  end
		end
	when 335 then
# line 1266 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1855 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 307 then
# line 1266 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 2057 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
           	begin
		 @cs = 781
		_goto_level = _again
		next
	end
  end
		end
	when 339 then
# line 1267 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1855 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 310 then
# line 1267 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 2057 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
           	begin
		 @cs = 781
		_goto_level = _again
		next
	end
  end
		end
	when 338 then
# line 1268 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1855 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 309 then
# line 1268 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1 "NONE"
		begin
	case  @act
	when 98 then
	begin begin p = (( @te))-1; end

        emit(:tUNARY_NUM, tok(@ts, @ts + 1), @ts, @ts + 1)
        p = p - 1;  @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 105 then
	begin begin p = (( @te))-1; end

        diagnostic :error, :unterminated_heredoc_id, nil, range(@ts, @ts + 1)
      end
	when 116 then
	begin begin p = (( @te))-1; end

        if @version >= 27
          emit(:tPIPE, tok(@ts, @ts + 1), @ts, @ts + 1)
          p = p - 1;
           @cs = 543; 	begin
		p += 1
		_goto_level = _out
		next
	end

        else
          p -= 2
          	begin
		 @cs = 781
		_goto_level = _again
		next
	end

        end
      end
	when 120 then
	begin begin p = (( @te))-1; end
 emit_table(PUNCTUATION_BEGIN)
           	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 121 then
	begin begin p = (( @te))-1; end
 emit(:kRESCUE, 'rescue'.freeze, @ts, tm)
           p = tm - 1
            @cs = 519; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 122 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS_BEGIN)
           @command_start = true
            @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 126 then
	begin begin p = (( @te))-1; end
 p = @ts - 1
           	begin
		 @cs = 781
		_goto_level = _again
		next
	end
 end
	when 127 then
	begin begin p = (( @te))-1; end

    emit(:tIDENTIFIER)

    if !@static_env.nil? && @static_env.declared?(tok)
       @cs = 446; 	begin
		p += 1
		_goto_level = _out
		next
	end

    else
       @cs = (arg_or_cmdarg(cmd_state)); 	begin
		p += 1
		_goto_level = _out
		next
	end

    end
  end
	when 131 then
	begin begin p = (( @te))-1; end
 p = @ts - 1; 	begin
		 @cs = 781
		_goto_level = _again
		next
	end
 end
end 
			end
	when 336 then
# line 1269 "lib/parser/lexer.rl"
		begin
 tm = p - 3 		end
# line 1855 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 308 then
# line 1269 "lib/parser/lexer.rl"
		begin
 tm = p - 3 		end
# line 2057 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
           	begin
		 @cs = 781
		_goto_level = _again
		next
	end
  end
		end
	when 337 then
# line 1274 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1855 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 481 then
# line 1279 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 2350 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tCONSTANT, tok(@ts, tm), @ts, tm)
           p = tm - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 261 then
# line 1285 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    @paren_nest += 1
  		end
# line 1501 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tLBRACK, '['.freeze, @te - 1, @te)
            @cs = 543; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 377 then
# line 1285 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    @paren_nest += 1
  		end
# line 1963 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tLBRACK, '['.freeze)
           	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 484 then
# line 1285 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    @paren_nest += 1
  		end
# line 2437 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tLBRACK2, '['.freeze)
            @cs = 543; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 487 then
# line 1291 "lib/parser/lexer.rl"
		begin

    @paren_nest -= 1
  		end
# line 2404 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit_table(PUNCTUATION)

        if @version < 24
          @cond.lexpop
          @cmdarg.lexpop
        else
          @cond.pop
          @cmdarg.pop
        end

        if tok == '}'.freeze || tok == ']'.freeze
          if @version >= 25
             @cs = 781;
          else
             @cs = 511;
          end
        else # )
          # fnext expr_endfn; ?
        end

        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 253 then
# line 1298 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    @paren_nest += 1

    if version?(18)
      @command_start = true
    end
  		end
# line 1482 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if version?(18)
          emit(:tLPAREN2, '('.freeze, @te - 1, @te)
           @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end

        else
          emit(:tLPAREN_ARG, '('.freeze, @te - 1, @te)
           @cs = 543; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
       end
		end
	when 266 then
# line 1298 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    @paren_nest += 1

    if version?(18)
      @command_start = true
    end
  		end
# line 1495 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tLPAREN2, '('.freeze)
            @cs = 543; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 274 then
# line 1298 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    @paren_nest += 1

    if version?(18)
      @command_start = true
    end
  		end
# line 1623 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tLPAREN_ARG, '('.freeze, @te - 1, @te)
        if version?(18)
           @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end

        else
           @cs = 543; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
       end
		end
	when 323 then
# line 1298 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    @paren_nest += 1

    if version?(18)
      @command_start = true
    end
  		end
# line 1968 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tLPAREN, '('.freeze)
           	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 428 then
# line 1298 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    @paren_nest += 1

    if version?(18)
      @command_start = true
    end
  		end
# line 2400 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(PUNCTUATION)
            @cs = 543; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 429 then
# line 1308 "lib/parser/lexer.rl"
		begin

    @paren_nest -= 1
  		end
# line 2404 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit_table(PUNCTUATION)

        if @version < 24
          @cond.lexpop
          @cmdarg.lexpop
        else
          @cond.pop
          @cmdarg.pop
        end

        if tok == '}'.freeze || tok == ']'.freeze
          if @version >= 25
             @cs = 781;
          else
             @cs = 511;
          end
        else # )
          # fnext expr_endfn; ?
        end

        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 71 then
# line 1776 "lib/parser/lexer.rl"
		begin
 heredoc_e      = p 		end
# line 499 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
	when 347 then
# line 1777 "lib/parser/lexer.rl"
		begin
 new_herebody_s = p 		end
# line 1778 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        tok(@ts, heredoc_e) =~ /^<<(-?)(~?)(["'`]?)(.*)\3$/m

        indent      = !$1.empty? || !$2.empty?
        dedent_body = !$2.empty?
        type        =  $3.empty? ? '<<"'.freeze : ('<<'.freeze + $3)
        delimiter   =  $4

        if @version >= 27
          if delimiter.count("\n") > 0 || delimiter.count("\r") > 0
            diagnostic :error, :unterminated_heredoc_id, nil, range(@ts, @ts + 1)
          end
        elsif @version >= 24
          if delimiter.count("\n") > 0
            if delimiter.end_with?("\n")
              diagnostic :warning, :heredoc_id_ends_with_nl, nil, range(@ts, @ts + 1)
              delimiter = delimiter.rstrip
            else
              diagnostic :fatal, :heredoc_id_has_newline, nil, range(@ts, @ts + 1)
            end
          end
        end

        if dedent_body && version?(18, 19, 20, 21, 22)
          emit(:tLSHFT, '<<'.freeze, @ts, @ts + 2)
          p = @ts + 1
           @cs = 543; 	begin
		p += 1
		_goto_level = _out
		next
	end

        else
           @cs = (push_literal(type, delimiter, @ts, heredoc_e, indent, dedent_body));

          @herebody_s ||= new_herebody_s
          p = @herebody_s - 1
        end
       end
		end
	when 342 then
# line 1868 "lib/parser/lexer.rl"
		begin
 tm = p - 1; diag_msg = :ivar_name 		end
# line 1871 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if @version >= 27
          diagnostic :error, diag_msg, { name: tok(tm, @te) }, range(tm, @te)
        else
          emit(:tCOLON, tok(@ts, @ts + 1), @ts, @ts + 1)
          p = @ts
        end

         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 345 then
# line 1869 "lib/parser/lexer.rl"
		begin
 tm = p - 2; diag_msg = :cvar_name 		end
# line 1871 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if @version >= 27
          diagnostic :error, diag_msg, { name: tok(tm, @te) }, range(tm, @te)
        else
          emit(:tCOLON, tok(@ts, @ts + 1), @ts, @ts + 1)
          p = @ts
        end

         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 353 then
# line 1889 "lib/parser/lexer.rl"
		begin
 @escape = nil 		end
# line 1891 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 380 then
# line 1978 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1979 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:kRESCUE, 'rescue'.freeze, @ts, tm)
           p = tm - 1
            @cs = 519; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 471 then
# line 2252 "lib/parser/lexer.rl"
		begin
 @num_base = 16; @num_digits_s = p 		end
# line 2258 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 465 then
# line 2253 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = p 		end
# line 2258 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 468 then
# line 2254 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = p 		end
# line 2258 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 462 then
# line 2255 "lib/parser/lexer.rl"
		begin
 @num_base = 2;  @num_digits_s = p 		end
# line 2258 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 477 then
# line 2256 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = @ts 		end
# line 2258 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 440 then
# line 2257 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = @ts 		end
# line 2258 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 478 then
# line 2258 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 632 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
	when 89 then
# line 2504 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 2505 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = tm - 1; 	begin
		 @cs = 781
		_goto_level = _again
		next
	end
  end
		end
	when 8 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 499 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
	when 444 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2316 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 222 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1372 "lib/parser/lexer.rl"
		begin
 @act = 43;		end
	when 209 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1376 "lib/parser/lexer.rl"
		begin
 @act = 44;		end
	when 205 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1380 "lib/parser/lexer.rl"
		begin
 @act = 45;		end
	when 26 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1544 "lib/parser/lexer.rl"
		begin
 @act = 71;		end
	when 255 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1557 "lib/parser/lexer.rl"
		begin
 @act = 72;		end
	when 27 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1596 "lib/parser/lexer.rl"
		begin
 @act = 77;		end
	when 248 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1601 "lib/parser/lexer.rl"
		begin
 @act = 78;		end
	when 275 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1633 "lib/parser/lexer.rl"
		begin
 @act = 84;		end
	when 45 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1646 "lib/parser/lexer.rl"
		begin
 @act = 85;		end
	when 296 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1700 "lib/parser/lexer.rl"
		begin
 @act = 92;		end
	when 285 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1704 "lib/parser/lexer.rl"
		begin
 @act = 93;		end
	when 69 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1824 "lib/parser/lexer.rl"
		begin
 @act = 105;		end
	when 385 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1932 "lib/parser/lexer.rl"
		begin
 @act = 116;		end
	when 299 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1973 "lib/parser/lexer.rl"
		begin
 @act = 120;		end
	when 379 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1979 "lib/parser/lexer.rl"
		begin
 @act = 121;		end
	when 378 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1985 "lib/parser/lexer.rl"
		begin
 @act = 122;		end
	when 74 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2057 "lib/parser/lexer.rl"
		begin
 @act = 126;		end
	when 297 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1313 "lib/parser/lexer.rl"
		begin
 @act = 127;		end
	when 300 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2103 "lib/parser/lexer.rl"
		begin
 @act = 131;		end
	when 495 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2167 "lib/parser/lexer.rl"
		begin
 @act = 144;		end
	when 490 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2196 "lib/parser/lexer.rl"
		begin
 @act = 145;		end
	when 498 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2206 "lib/parser/lexer.rl"
		begin
 @act = 147;		end
	when 491 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2211 "lib/parser/lexer.rl"
		begin
 @act = 148;		end
	when 492 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2216 "lib/parser/lexer.rl"
		begin
 @act = 149;		end
	when 497 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2220 "lib/parser/lexer.rl"
		begin
 @act = 150;		end
	when 489 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2231 "lib/parser/lexer.rl"
		begin
 @act = 151;		end
	when 483 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2245 "lib/parser/lexer.rl"
		begin
 @act = 152;		end
	when 409 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2259 "lib/parser/lexer.rl"
		begin
 @act = 153;		end
	when 442 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2303 "lib/parser/lexer.rl"
		begin
 @act = 156;		end
	when 81 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2318 "lib/parser/lexer.rl"
		begin
 @act = 157;		end
	when 412 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2346 "lib/parser/lexer.rl"
		begin
 @act = 159;		end
	when 403 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1313 "lib/parser/lexer.rl"
		begin
 @act = 163;		end
	when 414 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2368 "lib/parser/lexer.rl"
		begin
 @act = 164;		end
	when 407 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2394 "lib/parser/lexer.rl"
		begin
 @act = 166;		end
	when 413 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2400 "lib/parser/lexer.rl"
		begin
 @act = 167;		end
	when 87 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2491 "lib/parser/lexer.rl"
		begin
 @act = 180;		end
	when 502 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2508 "lib/parser/lexer.rl"
		begin
 @act = 182;		end
	when 177 then
# line 499 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 943 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
# line 815 "lib/parser/lexer.rl"
		begin

    @escape_s = p
    @escape   = nil
  		end
	when 124 then
# line 704 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 723 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 888 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 152 then
# line 704 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 723 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 888 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 363 then
# line 704 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 723 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 1891 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 129 then
# line 704 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 727 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 888 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 157 then
# line 704 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 727 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 888 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 368 then
# line 704 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 727 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 1891 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 122 then
# line 715 "lib/parser/lexer.rl"
		begin

    @escape = @source_buffer.slice(p - 1).chr

    if @version >= 27 && ((0..8).include?(@escape.ord) || (14..31).include?(@escape.ord))
      diagnostic :fatal, :invalid_escape
    end
  		end
# line 723 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 888 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 150 then
# line 715 "lib/parser/lexer.rl"
		begin

    @escape = @source_buffer.slice(p - 1).chr

    if @version >= 27 && ((0..8).include?(@escape.ord) || (14..31).include?(@escape.ord))
      diagnostic :fatal, :invalid_escape
    end
  		end
# line 723 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 888 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 361 then
# line 715 "lib/parser/lexer.rl"
		begin

    @escape = @source_buffer.slice(p - 1).chr

    if @version >= 27 && ((0..8).include?(@escape.ord) || (14..31).include?(@escape.ord))
      diagnostic :fatal, :invalid_escape
    end
  		end
# line 723 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 1891 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 128 then
# line 715 "lib/parser/lexer.rl"
		begin

    @escape = @source_buffer.slice(p - 1).chr

    if @version >= 27 && ((0..8).include?(@escape.ord) || (14..31).include?(@escape.ord))
      diagnostic :fatal, :invalid_escape
    end
  		end
# line 727 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 888 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 156 then
# line 715 "lib/parser/lexer.rl"
		begin

    @escape = @source_buffer.slice(p - 1).chr

    if @version >= 27 && ((0..8).include?(@escape.ord) || (14..31).include?(@escape.ord))
      diagnostic :fatal, :invalid_escape
    end
  		end
# line 727 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 888 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 367 then
# line 715 "lib/parser/lexer.rl"
		begin

    @escape = @source_buffer.slice(p - 1).chr

    if @version >= 27 && ((0..8).include?(@escape.ord) || (14..31).include?(@escape.ord))
      diagnostic :fatal, :invalid_escape
    end
  		end
# line 727 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 1891 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 126 then
# line 738 "lib/parser/lexer.rl"
		begin
 @escape = "\x7f" 		end
# line 727 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 888 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 154 then
# line 738 "lib/parser/lexer.rl"
		begin
 @escape = "\x7f" 		end
# line 727 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 888 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 365 then
# line 738 "lib/parser/lexer.rl"
		begin
 @escape = "\x7f" 		end
# line 727 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 1891 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 133 then
# line 769 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
      		end
# line 783 "lib/parser/lexer.rl"
		begin

          diagnostic :fatal, :unterminated_unicode, nil, range(p - 1, p)
        		end
# line 888 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 161 then
# line 769 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
      		end
# line 783 "lib/parser/lexer.rl"
		begin

          diagnostic :fatal, :unterminated_unicode, nil, range(p - 1, p)
        		end
# line 888 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 372 then
# line 769 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
      		end
# line 783 "lib/parser/lexer.rl"
		begin

          diagnostic :fatal, :unterminated_unicode, nil, range(p - 1, p)
        		end
# line 1891 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 116 then
# line 815 "lib/parser/lexer.rl"
		begin

    @escape_s = p
    @escape   = nil
  		end
# line 809 "lib/parser/lexer.rl"
		begin

      diagnostic :fatal, :escape_eof, nil, range(p - 1, p)
    		end
# line 888 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 145 then
# line 815 "lib/parser/lexer.rl"
		begin

    @escape_s = p
    @escape   = nil
  		end
# line 809 "lib/parser/lexer.rl"
		begin

      diagnostic :fatal, :escape_eof, nil, range(p - 1, p)
    		end
# line 888 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 356 then
# line 815 "lib/parser/lexer.rl"
		begin

    @escape_s = p
    @escape   = nil
  		end
# line 809 "lib/parser/lexer.rl"
		begin

      diagnostic :fatal, :escape_eof, nil, range(p - 1, p)
    		end
# line 1891 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 61 then
# line 1215 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1218 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 499 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
	when 215 then
# line 1215 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1218 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1413 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 230 then
# line 1215 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1218 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1431 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 242 then
# line 1215 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1218 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1463 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 264 then
# line 1215 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1218 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1604 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  	begin
		 @cs = 781
		_goto_level = _again
		next
	end
  end
		end
	when 279 then
# line 1215 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1218 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1685 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 291 then
# line 1215 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1218 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1706 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 317 then
# line 1215 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1218 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2084 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 390 then
# line 1215 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1218 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2111 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 400 then
# line 1215 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1218 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2142 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 421 then
# line 1215 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1218 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2459 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 102 then
# line 1215 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1218 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2533 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 473 then
# line 2256 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = @ts 		end
# line 2258 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 632 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
	when 437 then
# line 2257 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = @ts 		end
# line 2258 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 632 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
	when 452 then
# line 2258 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 632 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2259 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 445 then
# line 2315 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 641 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tFLOAT,     Float(chars)) } 		end
# line 2318 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 441 then
# line 2316 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 641 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tFLOAT,     Float(chars)) } 		end
# line 2318 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 270 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 499 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 1601 "lib/parser/lexer.rl"
		begin
 @act = 78;		end
	when 35 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 855 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1596 "lib/parser/lexer.rl"
		begin
 @act = 77;		end
	when 46 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 855 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1646 "lib/parser/lexer.rl"
		begin
 @act = 85;		end
	when 94 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 855 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 2491 "lib/parser/lexer.rl"
		begin
 @act = 180;		end
	when 65 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1218 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1727 "lib/parser/lexer.rl"
		begin
 @act = 98;		end
	when 84 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1218 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2200 "lib/parser/lexer.rl"
		begin
 @act = 146;		end
	when 93 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1218 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2491 "lib/parser/lexer.rl"
		begin
 @act = 180;		end
	when 37 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1556 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1557 "lib/parser/lexer.rl"
		begin
 @act = 72;		end
	when 382 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1978 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 2057 "lib/parser/lexer.rl"
		begin
 @act = 126;		end
	when 381 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1978 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1313 "lib/parser/lexer.rl"
		begin
 @act = 127;		end
	when 474 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2256 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = @ts 		end
# line 2259 "lib/parser/lexer.rl"
		begin
 @act = 153;		end
	when 127 then
# line 704 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 723 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 727 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 888 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 155 then
# line 704 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 723 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 727 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 888 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 366 then
# line 704 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 723 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 727 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 1891 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 125 then
# line 715 "lib/parser/lexer.rl"
		begin

    @escape = @source_buffer.slice(p - 1).chr

    if @version >= 27 && ((0..8).include?(@escape.ord) || (14..31).include?(@escape.ord))
      diagnostic :fatal, :invalid_escape
    end
  		end
# line 723 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 727 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 888 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 153 then
# line 715 "lib/parser/lexer.rl"
		begin

    @escape = @source_buffer.slice(p - 1).chr

    if @version >= 27 && ((0..8).include?(@escape.ord) || (14..31).include?(@escape.ord))
      diagnostic :fatal, :invalid_escape
    end
  		end
# line 723 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 727 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 888 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 364 then
# line 715 "lib/parser/lexer.rl"
		begin

    @escape = @source_buffer.slice(p - 1).chr

    if @version >= 27 && ((0..8).include?(@escape.ord) || (14..31).include?(@escape.ord))
      diagnostic :fatal, :invalid_escape
    end
  		end
# line 723 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 727 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 1891 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 781; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 469 then
# line 2252 "lib/parser/lexer.rl"
		begin
 @num_base = 16; @num_digits_s = p 		end
# line 2258 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 632 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2259 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 463 then
# line 2253 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = p 		end
# line 2258 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 632 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2259 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 466 then
# line 2254 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = p 		end
# line 2258 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 632 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2259 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 460 then
# line 2255 "lib/parser/lexer.rl"
		begin
 @num_base = 2;  @num_digits_s = p 		end
# line 2258 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 632 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2259 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 472 then
# line 2256 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = @ts 		end
# line 2258 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 632 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2259 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 436 then
# line 2257 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = @ts 		end
# line 2258 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 632 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2259 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 31 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 855 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1556 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1557 "lib/parser/lexer.rl"
		begin
 @act = 72;		end
	when 62 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1215 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1218 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1727 "lib/parser/lexer.rl"
		begin
 @act = 98;		end
	when 92 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1215 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1218 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2491 "lib/parser/lexer.rl"
		begin
 @act = 180;		end
	when 479 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2258 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 632 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2291 "lib/parser/lexer.rl"
		begin
 @act = 155;		end
	when 475 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2256 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = @ts 		end
# line 2258 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 632 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2291 "lib/parser/lexer.rl"
		begin
 @act = 155;		end
	when 439 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2257 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = @ts 		end
# line 2258 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 632 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2291 "lib/parser/lexer.rl"
		begin
 @act = 155;		end
# line 23524 "lib/parser/lexer.rb"
	end
	end
	end
	if _goto_level <= _again
	case _lex_to_state_actions[ @cs] 
	when 96 then
# line 1 "NONE"
		begin
 @ts = nil;		end
# line 23534 "lib/parser/lexer.rb"
	end

	if  @cs == 0
		_goto_level = _out
		next
	end
	p += 1
	if p != pe
		_goto_level = _resume
		next
	end
	end
	if _goto_level <= _test_eof
	if p == eof
	if _lex_eof_trans[ @cs] > 0
		_trans = _lex_eof_trans[ @cs] - 1;
		_goto_level = _eof_trans
		next;
	end
	end

	end
	if _goto_level <= _out
		break
	end
end
	end

# line 284 "lib/parser/lexer.rl"
    # %

    # Ragel creates a local variable called `testEof` but it doesn't use
    # it in any assignment. This dead code is here to swallow the warning.
    # It has no runtime cost because Ruby doesn't produce any instructions from it.
    if false
      testEof
    end

    @p = p

    if @token_queue.any?
      @token_queue.shift
    elsif @cs == klass.lex_error
      [ false, [ '$error'.freeze, range(p - 1, p) ] ]
    else
      eof = @source_pts.size
      [ false, [ '$eof'.freeze,   range(eof, eof) ] ]
    end
  end

  protected

  def eof_codepoint?(point)
    [0x04, 0x1a, 0x00].include? point
  end

  def version?(*versions)
    versions.include?(@version)
  end

  def stack_pop
    @top -= 1
    @stack[@top]
  end

  def encode_escape(ord)
    ord.chr.force_encoding(@source_buffer.source.encoding)
  end

  def tok(s = @ts, e = @te)
    @source_buffer.slice(s...e)
  end

  def range(s = @ts, e = @te)
    Parser::Source::Range.new(@source_buffer, s, e)
  end

  def emit(type, value = tok, s = @ts, e = @te)
    token = [ type, [ value, range(s, e) ] ]

    @token_queue.push(token)

    @tokens.push(token) if @tokens

    token
  end

  def emit_table(table, s = @ts, e = @te)
    value = tok(s, e)

    emit(table[value], value, s, e)
  end

  def emit_do(do_block=false)
    if @cond.active?
      emit(:kDO_COND, 'do'.freeze)
    elsif @cmdarg.active? || do_block
      emit(:kDO_BLOCK, 'do'.freeze)
    else
      emit(:kDO, 'do'.freeze)
    end
  end

  def arg_or_cmdarg(cmd_state)
    if cmd_state
      self.class.lex_en_expr_cmdarg
    else
      self.class.lex_en_expr_arg
    end
  end

  def emit_comment(s = @ts, e = @te)
    if @comments
      @comments.push(Parser::Source::Comment.new(range(s, e)))
    end

    if @tokens
      @tokens.push([ :tCOMMENT, [ tok(s, e), range(s, e) ] ])
    end

    nil
  end

  def diagnostic(type, reason, arguments=nil, location=range, highlights=[])
    @diagnostics.process(
        Parser::Diagnostic.new(type, reason, arguments, location, highlights))
  end

  #
  # === LITERAL STACK ===
  #

  def push_literal(*args)
    new_literal = Literal.new(self, *args)
    @literal_stack.push(new_literal)
    next_state_for_literal(new_literal)
  end

  def next_state_for_literal(literal)
    if literal.words? && literal.backslash_delimited?
      if literal.interpolate?
        self.class.lex_en_interp_backslash_delimited_words
      else
        self.class.lex_en_plain_backslash_delimited_words
      end
    elsif literal.words? && !literal.backslash_delimited?
      if literal.interpolate?
        self.class.lex_en_interp_words
      else
        self.class.lex_en_plain_words
      end
    elsif !literal.words? && literal.backslash_delimited?
      if literal.interpolate?
        self.class.lex_en_interp_backslash_delimited
      else
        self.class.lex_en_plain_backslash_delimited
      end
    else
      if literal.interpolate?
        self.class.lex_en_interp_string
      else
        self.class.lex_en_plain_string
      end
    end
  end

  def literal
    @literal_stack.last
  end

  def pop_literal
    old_literal = @literal_stack.pop

    @dedent_level = old_literal.dedent_level

    if old_literal.type == :tREGEXP_BEG
      # Fetch modifiers.
      self.class.lex_en_regexp_modifiers
    else
      self.class.lex_en_expr_end
    end
  end

  # Mapping of strings to parser tokens.

  PUNCTUATION = {
    '='   => :tEQL,     '&'   => :tAMPER2,  '|'   => :tPIPE,
    '!'   => :tBANG,    '^'   => :tCARET,   '+'   => :tPLUS,
    '-'   => :tMINUS,   '*'   => :tSTAR2,   '/'   => :tDIVIDE,
    '%'   => :tPERCENT, '~'   => :tTILDE,   ','   => :tCOMMA,
    ';'   => :tSEMI,    '.'   => :tDOT,     '..'  => :tDOT2,
    '...' => :tDOT3,    '['   => :tLBRACK2, ']'   => :tRBRACK,
    '('   => :tLPAREN2, ')'   => :tRPAREN,  '?'   => :tEH,
    ':'   => :tCOLON,   '&&'  => :tANDOP,   '||'  => :tOROP,
    '-@'  => :tUMINUS,  '+@'  => :tUPLUS,   '~@'  => :tTILDE,
    '**'  => :tPOW,     '->'  => :tLAMBDA,  '=~'  => :tMATCH,
    '!~'  => :tNMATCH,  '=='  => :tEQ,      '!='  => :tNEQ,
    '>'   => :tGT,      '>>'  => :tRSHFT,   '>='  => :tGEQ,
    '<'   => :tLT,      '<<'  => :tLSHFT,   '<='  => :tLEQ,
    '=>'  => :tASSOC,   '::'  => :tCOLON2,  '===' => :tEQQ,
    '<=>' => :tCMP,     '[]'  => :tAREF,    '[]=' => :tASET,
    '{'   => :tLCURLY,  '}'   => :tRCURLY,  '`'   => :tBACK_REF2,
    '!@'  => :tBANG,    '&.'  => :tANDDOT,
  }

  PUNCTUATION_BEGIN = {
    '&'   => :tAMPER,   '*'   => :tSTAR,    '**'  => :tDSTAR,
    '+'   => :tUPLUS,   '-'   => :tUMINUS,  '::'  => :tCOLON3,
    '('   => :tLPAREN,  '{'   => :tLBRACE,  '['   => :tLBRACK,
  }

  KEYWORDS = {
    'if'     => :kIF_MOD,      'unless'   => :kUNLESS_MOD,
    'while'  => :kWHILE_MOD,   'until'    => :kUNTIL_MOD,
    'rescue' => :kRESCUE_MOD,  'defined?' => :kDEFINED,
    'BEGIN'  => :klBEGIN,      'END'      => :klEND,
  }

  KEYWORDS_BEGIN = {
    'if'     => :kIF,          'unless'   => :kUNLESS,
    'while'  => :kWHILE,       'until'    => :kUNTIL,
    'rescue' => :kRESCUE,      'defined?' => :kDEFINED,
    'BEGIN'  => :klBEGIN,      'END'      => :klEND,
  }

  %w(class module def undef begin end then elsif else ensure case when
     for break next redo retry in do return yield super self nil true
     false and or not alias __FILE__ __LINE__ __ENCODING__).each do |keyword|
    KEYWORDS_BEGIN[keyword] = KEYWORDS[keyword] = :"k#{keyword.upcase}"
  end

  
# line 2548 "lib/parser/lexer.rl"

  # %
end
