# Copyright 2015 Google Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

require 'date'
require 'google/apis/core/base_service'
require 'google/apis/core/json_representation'
require 'google/apis/core/hashable'
require 'google/apis/errors'

module Google
  module Apis
    module CloudsearchV1
      
      class BooleanOperatorOptions
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class BooleanPropertyOptions
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class CheckAccessResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class CompositeFilter
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class CustomerIndexStats
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class CustomerQueryStats
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class CustomerSessionStats
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class CustomerUserStats
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class DataSource
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class DataSourceIndexStats
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class DataSourceRestriction
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class Date
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class DateOperatorOptions
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class DatePropertyOptions
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class DateValues
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class DebugOptions
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class DeleteQueueItemsRequest
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class DisplayedProperty
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class DoubleOperatorOptions
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class DoublePropertyOptions
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class DoubleValues
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class DriveFollowUpRestrict
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class DriveLocationRestrict
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class DriveMimeTypeRestrict
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class DriveTimeSpanRestrict
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class EmailAddress
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class EnumOperatorOptions
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class EnumPropertyOptions
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class EnumValuePair
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class EnumValues
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ErrorInfo
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ErrorMessage
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class FacetBucket
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class FacetOptions
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class FacetResult
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class FieldViolation
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class Filter
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class FilterOptions
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class FreshnessOptions
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GSuitePrincipal
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GetCustomerIndexStatsResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GetCustomerQueryStatsResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GetCustomerSessionStatsResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GetCustomerUserStatsResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GetDataSourceIndexStatsResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GetSearchApplicationQueryStatsResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GetSearchApplicationSessionStatsResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GetSearchApplicationUserStatsResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GmailActionRestrict
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GmailAttachmentRestrict
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GmailFolderRestrict
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GmailIntelligentRestrict
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GmailTimeRestrict
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class HtmlOperatorOptions
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class HtmlPropertyOptions
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class HtmlValues
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class IndexItemOptions
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class IndexItemRequest
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class IntegerOperatorOptions
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class IntegerPropertyOptions
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class IntegerValues
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class Interaction
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class Item
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ItemAcl
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ItemContent
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ItemCountByStatus
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ItemMetadata
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ItemStatus
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ItemStructuredData
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ListDataSourceResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ListItemNamesForUnmappedIdentityResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ListItemsResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ListQuerySourcesResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ListSearchApplicationsResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ListUnmappedIdentitiesResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class MatchRange
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class Media
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class Metadata
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class Metaline
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class Name
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class NamedProperty
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ObjectDefinition
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ObjectDisplayOptions
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ObjectOptions
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ObjectPropertyOptions
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ObjectValues
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class Operation
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class PeopleSuggestion
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class Person
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class Photo
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class PollItemsRequest
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class PollItemsResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class Principal
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ProcessingError
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class PropertyDefinition
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class PropertyDisplayOptions
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class PushItem
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class PushItemRequest
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class QueryCountByStatus
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class QueryInterpretation
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class QueryInterpretationOptions
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class QueryItem
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class QueryOperator
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class QuerySource
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class QuerySuggestion
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class RepositoryError
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class RequestOptions
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ResetSearchApplicationRequest
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ResponseDebugInfo
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class RestrictItem
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ResultCounts
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ResultDebugInfo
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ResultDisplayField
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ResultDisplayLine
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ResultDisplayMetadata
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class RetrievalImportance
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class Schema
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ScoringConfig
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class SearchApplication
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class SearchApplicationQueryStats
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class SearchApplicationSessionStats
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class SearchApplicationUserStats
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class SearchItemsByViewUrlRequest
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class SearchItemsByViewUrlResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class SearchQualityMetadata
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class SearchRequest
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class SearchResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class SearchResult
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class Snippet
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class SortOptions
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class Source
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class SourceConfig
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class SourceCrowdingConfig
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class SourceResultCount
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class SourceScoringConfig
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class SpellResult
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class StartUploadItemRequest
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class Status
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class StructuredDataObject
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class StructuredResult
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class SuggestRequest
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class SuggestResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class SuggestResult
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class TextOperatorOptions
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class TextPropertyOptions
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class TextValues
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class TimestampOperatorOptions
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class TimestampPropertyOptions
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class TimestampValues
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class UnmappedIdentity
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class UnreserveItemsRequest
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class UpdateDataSourceRequest
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class UpdateSchemaRequest
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class UploadItemRef
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class Value
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ValueFilter
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class BooleanOperatorOptions
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :operator_name, as: 'operatorName'
        end
      end
      
      class BooleanPropertyOptions
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :operator_options, as: 'operatorOptions', class: Google::Apis::CloudsearchV1::BooleanOperatorOptions, decorator: Google::Apis::CloudsearchV1::BooleanOperatorOptions::Representation
      
        end
      end
      
      class CheckAccessResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :has_access, as: 'hasAccess'
        end
      end
      
      class CompositeFilter
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :logic_operator, as: 'logicOperator'
          collection :sub_filters, as: 'subFilters', class: Google::Apis::CloudsearchV1::Filter, decorator: Google::Apis::CloudsearchV1::Filter::Representation
      
        end
      end
      
      class CustomerIndexStats
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :date, as: 'date', class: Google::Apis::CloudsearchV1::Date, decorator: Google::Apis::CloudsearchV1::Date::Representation
      
          collection :item_count_by_status, as: 'itemCountByStatus', class: Google::Apis::CloudsearchV1::ItemCountByStatus, decorator: Google::Apis::CloudsearchV1::ItemCountByStatus::Representation
      
        end
      end
      
      class CustomerQueryStats
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :date, as: 'date', class: Google::Apis::CloudsearchV1::Date, decorator: Google::Apis::CloudsearchV1::Date::Representation
      
          collection :query_count_by_status, as: 'queryCountByStatus', class: Google::Apis::CloudsearchV1::QueryCountByStatus, decorator: Google::Apis::CloudsearchV1::QueryCountByStatus::Representation
      
        end
      end
      
      class CustomerSessionStats
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :date, as: 'date', class: Google::Apis::CloudsearchV1::Date, decorator: Google::Apis::CloudsearchV1::Date::Representation
      
          property :search_sessions_count, :numeric_string => true, as: 'searchSessionsCount'
        end
      end
      
      class CustomerUserStats
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :date, as: 'date', class: Google::Apis::CloudsearchV1::Date, decorator: Google::Apis::CloudsearchV1::Date::Representation
      
          property :one_day_active_users_count, :numeric_string => true, as: 'oneDayActiveUsersCount'
          property :seven_days_active_users_count, :numeric_string => true, as: 'sevenDaysActiveUsersCount'
          property :thirty_days_active_users_count, :numeric_string => true, as: 'thirtyDaysActiveUsersCount'
        end
      end
      
      class DataSource
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :disable_modifications, as: 'disableModifications'
          property :disable_serving, as: 'disableServing'
          property :display_name, as: 'displayName'
          collection :indexing_service_accounts, as: 'indexingServiceAccounts'
          collection :items_visibility, as: 'itemsVisibility', class: Google::Apis::CloudsearchV1::GSuitePrincipal, decorator: Google::Apis::CloudsearchV1::GSuitePrincipal::Representation
      
          property :name, as: 'name'
          collection :operation_ids, as: 'operationIds'
          property :short_name, as: 'shortName'
        end
      end
      
      class DataSourceIndexStats
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :date, as: 'date', class: Google::Apis::CloudsearchV1::Date, decorator: Google::Apis::CloudsearchV1::Date::Representation
      
          collection :item_count_by_status, as: 'itemCountByStatus', class: Google::Apis::CloudsearchV1::ItemCountByStatus, decorator: Google::Apis::CloudsearchV1::ItemCountByStatus::Representation
      
        end
      end
      
      class DataSourceRestriction
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :filter_options, as: 'filterOptions', class: Google::Apis::CloudsearchV1::FilterOptions, decorator: Google::Apis::CloudsearchV1::FilterOptions::Representation
      
          property :source, as: 'source', class: Google::Apis::CloudsearchV1::Source, decorator: Google::Apis::CloudsearchV1::Source::Representation
      
        end
      end
      
      class Date
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :day, as: 'day'
          property :month, as: 'month'
          property :year, as: 'year'
        end
      end
      
      class DateOperatorOptions
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :greater_than_operator_name, as: 'greaterThanOperatorName'
          property :less_than_operator_name, as: 'lessThanOperatorName'
          property :operator_name, as: 'operatorName'
        end
      end
      
      class DatePropertyOptions
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :operator_options, as: 'operatorOptions', class: Google::Apis::CloudsearchV1::DateOperatorOptions, decorator: Google::Apis::CloudsearchV1::DateOperatorOptions::Representation
      
        end
      end
      
      class DateValues
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :values, as: 'values', class: Google::Apis::CloudsearchV1::Date, decorator: Google::Apis::CloudsearchV1::Date::Representation
      
        end
      end
      
      class DebugOptions
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :enable_debugging, as: 'enableDebugging'
        end
      end
      
      class DeleteQueueItemsRequest
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :connector_name, as: 'connectorName'
          property :debug_options, as: 'debugOptions', class: Google::Apis::CloudsearchV1::DebugOptions, decorator: Google::Apis::CloudsearchV1::DebugOptions::Representation
      
          property :queue, as: 'queue'
        end
      end
      
      class DisplayedProperty
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :property_name, as: 'propertyName'
        end
      end
      
      class DoubleOperatorOptions
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :operator_name, as: 'operatorName'
        end
      end
      
      class DoublePropertyOptions
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :operator_options, as: 'operatorOptions', class: Google::Apis::CloudsearchV1::DoubleOperatorOptions, decorator: Google::Apis::CloudsearchV1::DoubleOperatorOptions::Representation
      
        end
      end
      
      class DoubleValues
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :values, as: 'values'
        end
      end
      
      class DriveFollowUpRestrict
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :type, as: 'type'
        end
      end
      
      class DriveLocationRestrict
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :type, as: 'type'
        end
      end
      
      class DriveMimeTypeRestrict
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :type, as: 'type'
        end
      end
      
      class DriveTimeSpanRestrict
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :type, as: 'type'
        end
      end
      
      class EmailAddress
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :email_address, as: 'emailAddress'
        end
      end
      
      class EnumOperatorOptions
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :operator_name, as: 'operatorName'
        end
      end
      
      class EnumPropertyOptions
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :operator_options, as: 'operatorOptions', class: Google::Apis::CloudsearchV1::EnumOperatorOptions, decorator: Google::Apis::CloudsearchV1::EnumOperatorOptions::Representation
      
          property :ordered_ranking, as: 'orderedRanking'
          collection :possible_values, as: 'possibleValues', class: Google::Apis::CloudsearchV1::EnumValuePair, decorator: Google::Apis::CloudsearchV1::EnumValuePair::Representation
      
        end
      end
      
      class EnumValuePair
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :integer_value, as: 'integerValue'
          property :string_value, as: 'stringValue'
        end
      end
      
      class EnumValues
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :values, as: 'values'
        end
      end
      
      class ErrorInfo
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :error_messages, as: 'errorMessages', class: Google::Apis::CloudsearchV1::ErrorMessage, decorator: Google::Apis::CloudsearchV1::ErrorMessage::Representation
      
        end
      end
      
      class ErrorMessage
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :error_message, as: 'errorMessage'
          property :source, as: 'source', class: Google::Apis::CloudsearchV1::Source, decorator: Google::Apis::CloudsearchV1::Source::Representation
      
        end
      end
      
      class FacetBucket
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :count, as: 'count'
          property :percentage, as: 'percentage'
          property :value, as: 'value', class: Google::Apis::CloudsearchV1::Value, decorator: Google::Apis::CloudsearchV1::Value::Representation
      
        end
      end
      
      class FacetOptions
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :num_facet_buckets, as: 'numFacetBuckets'
          property :object_type, as: 'objectType'
          property :operator_name, as: 'operatorName'
          property :source_name, as: 'sourceName'
        end
      end
      
      class FacetResult
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :buckets, as: 'buckets', class: Google::Apis::CloudsearchV1::FacetBucket, decorator: Google::Apis::CloudsearchV1::FacetBucket::Representation
      
          property :object_type, as: 'objectType'
          property :operator_name, as: 'operatorName'
          property :source_name, as: 'sourceName'
        end
      end
      
      class FieldViolation
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :description, as: 'description'
          property :field, as: 'field'
        end
      end
      
      class Filter
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :composite_filter, as: 'compositeFilter', class: Google::Apis::CloudsearchV1::CompositeFilter, decorator: Google::Apis::CloudsearchV1::CompositeFilter::Representation
      
          property :value_filter, as: 'valueFilter', class: Google::Apis::CloudsearchV1::ValueFilter, decorator: Google::Apis::CloudsearchV1::ValueFilter::Representation
      
        end
      end
      
      class FilterOptions
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :filter, as: 'filter', class: Google::Apis::CloudsearchV1::Filter, decorator: Google::Apis::CloudsearchV1::Filter::Representation
      
          property :object_type, as: 'objectType'
        end
      end
      
      class FreshnessOptions
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :freshness_duration, as: 'freshnessDuration'
          property :freshness_property, as: 'freshnessProperty'
        end
      end
      
      class GSuitePrincipal
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :gsuite_domain, as: 'gsuiteDomain'
          property :gsuite_group_email, as: 'gsuiteGroupEmail'
          property :gsuite_user_email, as: 'gsuiteUserEmail'
        end
      end
      
      class GetCustomerIndexStatsResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :stats, as: 'stats', class: Google::Apis::CloudsearchV1::CustomerIndexStats, decorator: Google::Apis::CloudsearchV1::CustomerIndexStats::Representation
      
        end
      end
      
      class GetCustomerQueryStatsResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :stats, as: 'stats', class: Google::Apis::CloudsearchV1::CustomerQueryStats, decorator: Google::Apis::CloudsearchV1::CustomerQueryStats::Representation
      
        end
      end
      
      class GetCustomerSessionStatsResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :stats, as: 'stats', class: Google::Apis::CloudsearchV1::CustomerSessionStats, decorator: Google::Apis::CloudsearchV1::CustomerSessionStats::Representation
      
        end
      end
      
      class GetCustomerUserStatsResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :stats, as: 'stats', class: Google::Apis::CloudsearchV1::CustomerUserStats, decorator: Google::Apis::CloudsearchV1::CustomerUserStats::Representation
      
        end
      end
      
      class GetDataSourceIndexStatsResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :stats, as: 'stats', class: Google::Apis::CloudsearchV1::DataSourceIndexStats, decorator: Google::Apis::CloudsearchV1::DataSourceIndexStats::Representation
      
        end
      end
      
      class GetSearchApplicationQueryStatsResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :stats, as: 'stats', class: Google::Apis::CloudsearchV1::SearchApplicationQueryStats, decorator: Google::Apis::CloudsearchV1::SearchApplicationQueryStats::Representation
      
        end
      end
      
      class GetSearchApplicationSessionStatsResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :stats, as: 'stats', class: Google::Apis::CloudsearchV1::SearchApplicationSessionStats, decorator: Google::Apis::CloudsearchV1::SearchApplicationSessionStats::Representation
      
        end
      end
      
      class GetSearchApplicationUserStatsResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :stats, as: 'stats', class: Google::Apis::CloudsearchV1::SearchApplicationUserStats, decorator: Google::Apis::CloudsearchV1::SearchApplicationUserStats::Representation
      
        end
      end
      
      class GmailActionRestrict
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :type, as: 'type'
        end
      end
      
      class GmailAttachmentRestrict
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :type, as: 'type'
        end
      end
      
      class GmailFolderRestrict
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :type, as: 'type'
        end
      end
      
      class GmailIntelligentRestrict
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :type, as: 'type'
        end
      end
      
      class GmailTimeRestrict
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :type, as: 'type'
        end
      end
      
      class HtmlOperatorOptions
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :operator_name, as: 'operatorName'
        end
      end
      
      class HtmlPropertyOptions
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :operator_options, as: 'operatorOptions', class: Google::Apis::CloudsearchV1::HtmlOperatorOptions, decorator: Google::Apis::CloudsearchV1::HtmlOperatorOptions::Representation
      
          property :retrieval_importance, as: 'retrievalImportance', class: Google::Apis::CloudsearchV1::RetrievalImportance, decorator: Google::Apis::CloudsearchV1::RetrievalImportance::Representation
      
        end
      end
      
      class HtmlValues
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :values, as: 'values'
        end
      end
      
      class IndexItemOptions
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :allow_unknown_gsuite_principals, as: 'allowUnknownGsuitePrincipals'
        end
      end
      
      class IndexItemRequest
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :connector_name, as: 'connectorName'
          property :debug_options, as: 'debugOptions', class: Google::Apis::CloudsearchV1::DebugOptions, decorator: Google::Apis::CloudsearchV1::DebugOptions::Representation
      
          property :index_item_options, as: 'indexItemOptions', class: Google::Apis::CloudsearchV1::IndexItemOptions, decorator: Google::Apis::CloudsearchV1::IndexItemOptions::Representation
      
          property :item, as: 'item', class: Google::Apis::CloudsearchV1::Item, decorator: Google::Apis::CloudsearchV1::Item::Representation
      
          property :mode, as: 'mode'
        end
      end
      
      class IntegerOperatorOptions
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :greater_than_operator_name, as: 'greaterThanOperatorName'
          property :less_than_operator_name, as: 'lessThanOperatorName'
          property :operator_name, as: 'operatorName'
        end
      end
      
      class IntegerPropertyOptions
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :maximum_value, :numeric_string => true, as: 'maximumValue'
          property :minimum_value, :numeric_string => true, as: 'minimumValue'
          property :operator_options, as: 'operatorOptions', class: Google::Apis::CloudsearchV1::IntegerOperatorOptions, decorator: Google::Apis::CloudsearchV1::IntegerOperatorOptions::Representation
      
          property :ordered_ranking, as: 'orderedRanking'
        end
      end
      
      class IntegerValues
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :values, as: 'values'
        end
      end
      
      class Interaction
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :interaction_time, as: 'interactionTime'
          property :principal, as: 'principal', class: Google::Apis::CloudsearchV1::Principal, decorator: Google::Apis::CloudsearchV1::Principal::Representation
      
          property :type, as: 'type'
        end
      end
      
      class Item
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :acl, as: 'acl', class: Google::Apis::CloudsearchV1::ItemAcl, decorator: Google::Apis::CloudsearchV1::ItemAcl::Representation
      
          property :content, as: 'content', class: Google::Apis::CloudsearchV1::ItemContent, decorator: Google::Apis::CloudsearchV1::ItemContent::Representation
      
          property :item_type, as: 'itemType'
          property :metadata, as: 'metadata', class: Google::Apis::CloudsearchV1::ItemMetadata, decorator: Google::Apis::CloudsearchV1::ItemMetadata::Representation
      
          property :name, as: 'name'
          property :payload, :base64 => true, as: 'payload'
          property :queue, as: 'queue'
          property :status, as: 'status', class: Google::Apis::CloudsearchV1::ItemStatus, decorator: Google::Apis::CloudsearchV1::ItemStatus::Representation
      
          property :structured_data, as: 'structuredData', class: Google::Apis::CloudsearchV1::ItemStructuredData, decorator: Google::Apis::CloudsearchV1::ItemStructuredData::Representation
      
          property :version, :base64 => true, as: 'version'
        end
      end
      
      class ItemAcl
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :acl_inheritance_type, as: 'aclInheritanceType'
          collection :denied_readers, as: 'deniedReaders', class: Google::Apis::CloudsearchV1::Principal, decorator: Google::Apis::CloudsearchV1::Principal::Representation
      
          property :inherit_acl_from, as: 'inheritAclFrom'
          collection :owners, as: 'owners', class: Google::Apis::CloudsearchV1::Principal, decorator: Google::Apis::CloudsearchV1::Principal::Representation
      
          collection :readers, as: 'readers', class: Google::Apis::CloudsearchV1::Principal, decorator: Google::Apis::CloudsearchV1::Principal::Representation
      
        end
      end
      
      class ItemContent
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :content_data_ref, as: 'contentDataRef', class: Google::Apis::CloudsearchV1::UploadItemRef, decorator: Google::Apis::CloudsearchV1::UploadItemRef::Representation
      
          property :content_format, as: 'contentFormat'
          property :hash_prop, as: 'hash'
          property :inline_content, :base64 => true, as: 'inlineContent'
        end
      end
      
      class ItemCountByStatus
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :count, :numeric_string => true, as: 'count'
          property :status_code, as: 'statusCode'
        end
      end
      
      class ItemMetadata
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :container_name, as: 'containerName'
          property :content_language, as: 'contentLanguage'
          property :create_time, as: 'createTime'
          property :hash_prop, as: 'hash'
          collection :interactions, as: 'interactions', class: Google::Apis::CloudsearchV1::Interaction, decorator: Google::Apis::CloudsearchV1::Interaction::Representation
      
          collection :keywords, as: 'keywords'
          property :mime_type, as: 'mimeType'
          property :object_type, as: 'objectType'
          property :search_quality_metadata, as: 'searchQualityMetadata', class: Google::Apis::CloudsearchV1::SearchQualityMetadata, decorator: Google::Apis::CloudsearchV1::SearchQualityMetadata::Representation
      
          property :source_repository_url, as: 'sourceRepositoryUrl'
          property :title, as: 'title'
          property :update_time, as: 'updateTime'
        end
      end
      
      class ItemStatus
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :code, as: 'code'
          collection :processing_errors, as: 'processingErrors', class: Google::Apis::CloudsearchV1::ProcessingError, decorator: Google::Apis::CloudsearchV1::ProcessingError::Representation
      
          collection :repository_errors, as: 'repositoryErrors', class: Google::Apis::CloudsearchV1::RepositoryError, decorator: Google::Apis::CloudsearchV1::RepositoryError::Representation
      
        end
      end
      
      class ItemStructuredData
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :hash_prop, as: 'hash'
          property :object, as: 'object', class: Google::Apis::CloudsearchV1::StructuredDataObject, decorator: Google::Apis::CloudsearchV1::StructuredDataObject::Representation
      
        end
      end
      
      class ListDataSourceResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :next_page_token, as: 'nextPageToken'
          collection :sources, as: 'sources', class: Google::Apis::CloudsearchV1::DataSource, decorator: Google::Apis::CloudsearchV1::DataSource::Representation
      
        end
      end
      
      class ListItemNamesForUnmappedIdentityResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :item_names, as: 'itemNames'
          property :next_page_token, as: 'nextPageToken'
        end
      end
      
      class ListItemsResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :items, as: 'items', class: Google::Apis::CloudsearchV1::Item, decorator: Google::Apis::CloudsearchV1::Item::Representation
      
          property :next_page_token, as: 'nextPageToken'
        end
      end
      
      class ListQuerySourcesResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :next_page_token, as: 'nextPageToken'
          collection :sources, as: 'sources', class: Google::Apis::CloudsearchV1::QuerySource, decorator: Google::Apis::CloudsearchV1::QuerySource::Representation
      
        end
      end
      
      class ListSearchApplicationsResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :next_page_token, as: 'nextPageToken'
          collection :search_applications, as: 'searchApplications', class: Google::Apis::CloudsearchV1::SearchApplication, decorator: Google::Apis::CloudsearchV1::SearchApplication::Representation
      
        end
      end
      
      class ListUnmappedIdentitiesResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :next_page_token, as: 'nextPageToken'
          collection :unmapped_identities, as: 'unmappedIdentities', class: Google::Apis::CloudsearchV1::UnmappedIdentity, decorator: Google::Apis::CloudsearchV1::UnmappedIdentity::Representation
      
        end
      end
      
      class MatchRange
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :end, as: 'end'
          property :start, as: 'start'
        end
      end
      
      class Media
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :resource_name, as: 'resourceName'
        end
      end
      
      class Metadata
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :create_time, as: 'createTime'
          property :display_options, as: 'displayOptions', class: Google::Apis::CloudsearchV1::ResultDisplayMetadata, decorator: Google::Apis::CloudsearchV1::ResultDisplayMetadata::Representation
      
          collection :fields, as: 'fields', class: Google::Apis::CloudsearchV1::NamedProperty, decorator: Google::Apis::CloudsearchV1::NamedProperty::Representation
      
          property :mime_type, as: 'mimeType'
          property :object_type, as: 'objectType'
          property :owner, as: 'owner', class: Google::Apis::CloudsearchV1::Person, decorator: Google::Apis::CloudsearchV1::Person::Representation
      
          property :source, as: 'source', class: Google::Apis::CloudsearchV1::Source, decorator: Google::Apis::CloudsearchV1::Source::Representation
      
          property :update_time, as: 'updateTime'
        end
      end
      
      class Metaline
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :properties, as: 'properties', class: Google::Apis::CloudsearchV1::DisplayedProperty, decorator: Google::Apis::CloudsearchV1::DisplayedProperty::Representation
      
        end
      end
      
      class Name
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :display_name, as: 'displayName'
        end
      end
      
      class NamedProperty
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :boolean_value, as: 'booleanValue'
          property :date_values, as: 'dateValues', class: Google::Apis::CloudsearchV1::DateValues, decorator: Google::Apis::CloudsearchV1::DateValues::Representation
      
          property :double_values, as: 'doubleValues', class: Google::Apis::CloudsearchV1::DoubleValues, decorator: Google::Apis::CloudsearchV1::DoubleValues::Representation
      
          property :enum_values, as: 'enumValues', class: Google::Apis::CloudsearchV1::EnumValues, decorator: Google::Apis::CloudsearchV1::EnumValues::Representation
      
          property :html_values, as: 'htmlValues', class: Google::Apis::CloudsearchV1::HtmlValues, decorator: Google::Apis::CloudsearchV1::HtmlValues::Representation
      
          property :integer_values, as: 'integerValues', class: Google::Apis::CloudsearchV1::IntegerValues, decorator: Google::Apis::CloudsearchV1::IntegerValues::Representation
      
          property :name, as: 'name'
          property :object_values, as: 'objectValues', class: Google::Apis::CloudsearchV1::ObjectValues, decorator: Google::Apis::CloudsearchV1::ObjectValues::Representation
      
          property :text_values, as: 'textValues', class: Google::Apis::CloudsearchV1::TextValues, decorator: Google::Apis::CloudsearchV1::TextValues::Representation
      
          property :timestamp_values, as: 'timestampValues', class: Google::Apis::CloudsearchV1::TimestampValues, decorator: Google::Apis::CloudsearchV1::TimestampValues::Representation
      
        end
      end
      
      class ObjectDefinition
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :name, as: 'name'
          property :options, as: 'options', class: Google::Apis::CloudsearchV1::ObjectOptions, decorator: Google::Apis::CloudsearchV1::ObjectOptions::Representation
      
          collection :property_definitions, as: 'propertyDefinitions', class: Google::Apis::CloudsearchV1::PropertyDefinition, decorator: Google::Apis::CloudsearchV1::PropertyDefinition::Representation
      
        end
      end
      
      class ObjectDisplayOptions
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :metalines, as: 'metalines', class: Google::Apis::CloudsearchV1::Metaline, decorator: Google::Apis::CloudsearchV1::Metaline::Representation
      
          property :object_display_label, as: 'objectDisplayLabel'
        end
      end
      
      class ObjectOptions
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :display_options, as: 'displayOptions', class: Google::Apis::CloudsearchV1::ObjectDisplayOptions, decorator: Google::Apis::CloudsearchV1::ObjectDisplayOptions::Representation
      
          property :freshness_options, as: 'freshnessOptions', class: Google::Apis::CloudsearchV1::FreshnessOptions, decorator: Google::Apis::CloudsearchV1::FreshnessOptions::Representation
      
        end
      end
      
      class ObjectPropertyOptions
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :subobject_properties, as: 'subobjectProperties', class: Google::Apis::CloudsearchV1::PropertyDefinition, decorator: Google::Apis::CloudsearchV1::PropertyDefinition::Representation
      
        end
      end
      
      class ObjectValues
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :values, as: 'values', class: Google::Apis::CloudsearchV1::StructuredDataObject, decorator: Google::Apis::CloudsearchV1::StructuredDataObject::Representation
      
        end
      end
      
      class Operation
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :done, as: 'done'
          property :error, as: 'error', class: Google::Apis::CloudsearchV1::Status, decorator: Google::Apis::CloudsearchV1::Status::Representation
      
          hash :metadata, as: 'metadata'
          property :name, as: 'name'
          hash :response, as: 'response'
        end
      end
      
      class PeopleSuggestion
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :person, as: 'person', class: Google::Apis::CloudsearchV1::Person, decorator: Google::Apis::CloudsearchV1::Person::Representation
      
        end
      end
      
      class Person
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :email_addresses, as: 'emailAddresses', class: Google::Apis::CloudsearchV1::EmailAddress, decorator: Google::Apis::CloudsearchV1::EmailAddress::Representation
      
          property :name, as: 'name'
          property :obfuscated_id, as: 'obfuscatedId'
          collection :person_names, as: 'personNames', class: Google::Apis::CloudsearchV1::Name, decorator: Google::Apis::CloudsearchV1::Name::Representation
      
          collection :photos, as: 'photos', class: Google::Apis::CloudsearchV1::Photo, decorator: Google::Apis::CloudsearchV1::Photo::Representation
      
        end
      end
      
      class Photo
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :url, as: 'url'
        end
      end
      
      class PollItemsRequest
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :connector_name, as: 'connectorName'
          property :debug_options, as: 'debugOptions', class: Google::Apis::CloudsearchV1::DebugOptions, decorator: Google::Apis::CloudsearchV1::DebugOptions::Representation
      
          property :limit, as: 'limit'
          property :queue, as: 'queue'
          collection :status_codes, as: 'statusCodes'
        end
      end
      
      class PollItemsResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :items, as: 'items', class: Google::Apis::CloudsearchV1::Item, decorator: Google::Apis::CloudsearchV1::Item::Representation
      
        end
      end
      
      class Principal
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :group_resource_name, as: 'groupResourceName'
          property :gsuite_principal, as: 'gsuitePrincipal', class: Google::Apis::CloudsearchV1::GSuitePrincipal, decorator: Google::Apis::CloudsearchV1::GSuitePrincipal::Representation
      
          property :user_resource_name, as: 'userResourceName'
        end
      end
      
      class ProcessingError
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :code, as: 'code'
          property :error_message, as: 'errorMessage'
          collection :field_violations, as: 'fieldViolations', class: Google::Apis::CloudsearchV1::FieldViolation, decorator: Google::Apis::CloudsearchV1::FieldViolation::Representation
      
        end
      end
      
      class PropertyDefinition
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :boolean_property_options, as: 'booleanPropertyOptions', class: Google::Apis::CloudsearchV1::BooleanPropertyOptions, decorator: Google::Apis::CloudsearchV1::BooleanPropertyOptions::Representation
      
          property :date_property_options, as: 'datePropertyOptions', class: Google::Apis::CloudsearchV1::DatePropertyOptions, decorator: Google::Apis::CloudsearchV1::DatePropertyOptions::Representation
      
          property :display_options, as: 'displayOptions', class: Google::Apis::CloudsearchV1::PropertyDisplayOptions, decorator: Google::Apis::CloudsearchV1::PropertyDisplayOptions::Representation
      
          property :double_property_options, as: 'doublePropertyOptions', class: Google::Apis::CloudsearchV1::DoublePropertyOptions, decorator: Google::Apis::CloudsearchV1::DoublePropertyOptions::Representation
      
          property :enum_property_options, as: 'enumPropertyOptions', class: Google::Apis::CloudsearchV1::EnumPropertyOptions, decorator: Google::Apis::CloudsearchV1::EnumPropertyOptions::Representation
      
          property :html_property_options, as: 'htmlPropertyOptions', class: Google::Apis::CloudsearchV1::HtmlPropertyOptions, decorator: Google::Apis::CloudsearchV1::HtmlPropertyOptions::Representation
      
          property :integer_property_options, as: 'integerPropertyOptions', class: Google::Apis::CloudsearchV1::IntegerPropertyOptions, decorator: Google::Apis::CloudsearchV1::IntegerPropertyOptions::Representation
      
          property :is_facetable, as: 'isFacetable'
          property :is_repeatable, as: 'isRepeatable'
          property :is_returnable, as: 'isReturnable'
          property :is_sortable, as: 'isSortable'
          property :is_suggestable, as: 'isSuggestable'
          property :is_wildcard_searchable, as: 'isWildcardSearchable'
          property :name, as: 'name'
          property :object_property_options, as: 'objectPropertyOptions', class: Google::Apis::CloudsearchV1::ObjectPropertyOptions, decorator: Google::Apis::CloudsearchV1::ObjectPropertyOptions::Representation
      
          property :text_property_options, as: 'textPropertyOptions', class: Google::Apis::CloudsearchV1::TextPropertyOptions, decorator: Google::Apis::CloudsearchV1::TextPropertyOptions::Representation
      
          property :timestamp_property_options, as: 'timestampPropertyOptions', class: Google::Apis::CloudsearchV1::TimestampPropertyOptions, decorator: Google::Apis::CloudsearchV1::TimestampPropertyOptions::Representation
      
        end
      end
      
      class PropertyDisplayOptions
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :display_label, as: 'displayLabel'
        end
      end
      
      class PushItem
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :content_hash, as: 'contentHash'
          property :metadata_hash, as: 'metadataHash'
          property :payload, :base64 => true, as: 'payload'
          property :queue, as: 'queue'
          property :repository_error, as: 'repositoryError', class: Google::Apis::CloudsearchV1::RepositoryError, decorator: Google::Apis::CloudsearchV1::RepositoryError::Representation
      
          property :structured_data_hash, as: 'structuredDataHash'
          property :type, as: 'type'
        end
      end
      
      class PushItemRequest
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :connector_name, as: 'connectorName'
          property :debug_options, as: 'debugOptions', class: Google::Apis::CloudsearchV1::DebugOptions, decorator: Google::Apis::CloudsearchV1::DebugOptions::Representation
      
          property :item, as: 'item', class: Google::Apis::CloudsearchV1::PushItem, decorator: Google::Apis::CloudsearchV1::PushItem::Representation
      
        end
      end
      
      class QueryCountByStatus
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :count, :numeric_string => true, as: 'count'
          property :status_code, as: 'statusCode'
        end
      end
      
      class QueryInterpretation
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :interpretation_type, as: 'interpretationType'
          property :interpreted_query, as: 'interpretedQuery'
          property :reason, as: 'reason'
        end
      end
      
      class QueryInterpretationOptions
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :disable_nl_interpretation, as: 'disableNlInterpretation'
          property :enable_verbatim_mode, as: 'enableVerbatimMode'
        end
      end
      
      class QueryItem
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :is_synthetic, as: 'isSynthetic'
        end
      end
      
      class QueryOperator
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :display_name, as: 'displayName'
          collection :enum_values, as: 'enumValues'
          property :greater_than_operator_name, as: 'greaterThanOperatorName'
          property :is_facetable, as: 'isFacetable'
          property :is_repeatable, as: 'isRepeatable'
          property :is_returnable, as: 'isReturnable'
          property :is_sortable, as: 'isSortable'
          property :is_suggestable, as: 'isSuggestable'
          property :less_than_operator_name, as: 'lessThanOperatorName'
          property :operator_name, as: 'operatorName'
          property :type, as: 'type'
        end
      end
      
      class QuerySource
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :display_name, as: 'displayName'
          collection :operators, as: 'operators', class: Google::Apis::CloudsearchV1::QueryOperator, decorator: Google::Apis::CloudsearchV1::QueryOperator::Representation
      
          property :short_name, as: 'shortName'
          property :source, as: 'source', class: Google::Apis::CloudsearchV1::Source, decorator: Google::Apis::CloudsearchV1::Source::Representation
      
        end
      end
      
      class QuerySuggestion
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
        end
      end
      
      class RepositoryError
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :error_message, as: 'errorMessage'
          property :http_status_code, as: 'httpStatusCode'
          property :type, as: 'type'
        end
      end
      
      class RequestOptions
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :debug_options, as: 'debugOptions', class: Google::Apis::CloudsearchV1::DebugOptions, decorator: Google::Apis::CloudsearchV1::DebugOptions::Representation
      
          property :language_code, as: 'languageCode'
          property :search_application_id, as: 'searchApplicationId'
          property :time_zone, as: 'timeZone'
        end
      end
      
      class ResetSearchApplicationRequest
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :debug_options, as: 'debugOptions', class: Google::Apis::CloudsearchV1::DebugOptions, decorator: Google::Apis::CloudsearchV1::DebugOptions::Representation
      
        end
      end
      
      class ResponseDebugInfo
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :formatted_debug_info, as: 'formattedDebugInfo'
        end
      end
      
      class RestrictItem
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :drive_follow_up_restrict, as: 'driveFollowUpRestrict', class: Google::Apis::CloudsearchV1::DriveFollowUpRestrict, decorator: Google::Apis::CloudsearchV1::DriveFollowUpRestrict::Representation
      
          property :drive_location_restrict, as: 'driveLocationRestrict', class: Google::Apis::CloudsearchV1::DriveLocationRestrict, decorator: Google::Apis::CloudsearchV1::DriveLocationRestrict::Representation
      
          property :drive_mime_type_restrict, as: 'driveMimeTypeRestrict', class: Google::Apis::CloudsearchV1::DriveMimeTypeRestrict, decorator: Google::Apis::CloudsearchV1::DriveMimeTypeRestrict::Representation
      
          property :drive_time_span_restrict, as: 'driveTimeSpanRestrict', class: Google::Apis::CloudsearchV1::DriveTimeSpanRestrict, decorator: Google::Apis::CloudsearchV1::DriveTimeSpanRestrict::Representation
      
          property :gmail_action_restrict, as: 'gmailActionRestrict', class: Google::Apis::CloudsearchV1::GmailActionRestrict, decorator: Google::Apis::CloudsearchV1::GmailActionRestrict::Representation
      
          property :gmail_attachment_restrict, as: 'gmailAttachmentRestrict', class: Google::Apis::CloudsearchV1::GmailAttachmentRestrict, decorator: Google::Apis::CloudsearchV1::GmailAttachmentRestrict::Representation
      
          property :gmail_folder_restrict, as: 'gmailFolderRestrict', class: Google::Apis::CloudsearchV1::GmailFolderRestrict, decorator: Google::Apis::CloudsearchV1::GmailFolderRestrict::Representation
      
          property :gmail_intelligent_restrict, as: 'gmailIntelligentRestrict', class: Google::Apis::CloudsearchV1::GmailIntelligentRestrict, decorator: Google::Apis::CloudsearchV1::GmailIntelligentRestrict::Representation
      
          property :gmail_time_restrict, as: 'gmailTimeRestrict', class: Google::Apis::CloudsearchV1::GmailTimeRestrict, decorator: Google::Apis::CloudsearchV1::GmailTimeRestrict::Representation
      
          property :search_operator, as: 'searchOperator'
        end
      end
      
      class ResultCounts
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :source_result_counts, as: 'sourceResultCounts', class: Google::Apis::CloudsearchV1::SourceResultCount, decorator: Google::Apis::CloudsearchV1::SourceResultCount::Representation
      
        end
      end
      
      class ResultDebugInfo
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :formatted_debug_info, as: 'formattedDebugInfo'
        end
      end
      
      class ResultDisplayField
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :label, as: 'label'
          property :operator_name, as: 'operatorName'
          property :property, as: 'property', class: Google::Apis::CloudsearchV1::NamedProperty, decorator: Google::Apis::CloudsearchV1::NamedProperty::Representation
      
        end
      end
      
      class ResultDisplayLine
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :fields, as: 'fields', class: Google::Apis::CloudsearchV1::ResultDisplayField, decorator: Google::Apis::CloudsearchV1::ResultDisplayField::Representation
      
        end
      end
      
      class ResultDisplayMetadata
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :metalines, as: 'metalines', class: Google::Apis::CloudsearchV1::ResultDisplayLine, decorator: Google::Apis::CloudsearchV1::ResultDisplayLine::Representation
      
          property :object_type_label, as: 'objectTypeLabel'
        end
      end
      
      class RetrievalImportance
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :importance, as: 'importance'
        end
      end
      
      class Schema
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :object_definitions, as: 'objectDefinitions', class: Google::Apis::CloudsearchV1::ObjectDefinition, decorator: Google::Apis::CloudsearchV1::ObjectDefinition::Representation
      
          collection :operation_ids, as: 'operationIds'
        end
      end
      
      class ScoringConfig
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :disable_freshness, as: 'disableFreshness'
          property :disable_personalization, as: 'disablePersonalization'
        end
      end
      
      class SearchApplication
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :data_source_restrictions, as: 'dataSourceRestrictions', class: Google::Apis::CloudsearchV1::DataSourceRestriction, decorator: Google::Apis::CloudsearchV1::DataSourceRestriction::Representation
      
          collection :default_facet_options, as: 'defaultFacetOptions', class: Google::Apis::CloudsearchV1::FacetOptions, decorator: Google::Apis::CloudsearchV1::FacetOptions::Representation
      
          property :default_sort_options, as: 'defaultSortOptions', class: Google::Apis::CloudsearchV1::SortOptions, decorator: Google::Apis::CloudsearchV1::SortOptions::Representation
      
          property :display_name, as: 'displayName'
          property :name, as: 'name'
          collection :operation_ids, as: 'operationIds'
          property :scoring_config, as: 'scoringConfig', class: Google::Apis::CloudsearchV1::ScoringConfig, decorator: Google::Apis::CloudsearchV1::ScoringConfig::Representation
      
          collection :source_config, as: 'sourceConfig', class: Google::Apis::CloudsearchV1::SourceConfig, decorator: Google::Apis::CloudsearchV1::SourceConfig::Representation
      
        end
      end
      
      class SearchApplicationQueryStats
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :date, as: 'date', class: Google::Apis::CloudsearchV1::Date, decorator: Google::Apis::CloudsearchV1::Date::Representation
      
          collection :query_count_by_status, as: 'queryCountByStatus', class: Google::Apis::CloudsearchV1::QueryCountByStatus, decorator: Google::Apis::CloudsearchV1::QueryCountByStatus::Representation
      
        end
      end
      
      class SearchApplicationSessionStats
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :date, as: 'date', class: Google::Apis::CloudsearchV1::Date, decorator: Google::Apis::CloudsearchV1::Date::Representation
      
          property :search_sessions_count, :numeric_string => true, as: 'searchSessionsCount'
        end
      end
      
      class SearchApplicationUserStats
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :date, as: 'date', class: Google::Apis::CloudsearchV1::Date, decorator: Google::Apis::CloudsearchV1::Date::Representation
      
          property :one_day_active_users_count, :numeric_string => true, as: 'oneDayActiveUsersCount'
          property :seven_days_active_users_count, :numeric_string => true, as: 'sevenDaysActiveUsersCount'
          property :thirty_days_active_users_count, :numeric_string => true, as: 'thirtyDaysActiveUsersCount'
        end
      end
      
      class SearchItemsByViewUrlRequest
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :debug_options, as: 'debugOptions', class: Google::Apis::CloudsearchV1::DebugOptions, decorator: Google::Apis::CloudsearchV1::DebugOptions::Representation
      
          property :page_token, as: 'pageToken'
          property :view_url, as: 'viewUrl'
        end
      end
      
      class SearchItemsByViewUrlResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :items, as: 'items', class: Google::Apis::CloudsearchV1::Item, decorator: Google::Apis::CloudsearchV1::Item::Representation
      
          property :next_page_token, as: 'nextPageToken'
        end
      end
      
      class SearchQualityMetadata
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :quality, as: 'quality'
        end
      end
      
      class SearchRequest
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :data_source_restrictions, as: 'dataSourceRestrictions', class: Google::Apis::CloudsearchV1::DataSourceRestriction, decorator: Google::Apis::CloudsearchV1::DataSourceRestriction::Representation
      
          collection :facet_options, as: 'facetOptions', class: Google::Apis::CloudsearchV1::FacetOptions, decorator: Google::Apis::CloudsearchV1::FacetOptions::Representation
      
          property :page_size, as: 'pageSize'
          property :query, as: 'query'
          property :query_interpretation_options, as: 'queryInterpretationOptions', class: Google::Apis::CloudsearchV1::QueryInterpretationOptions, decorator: Google::Apis::CloudsearchV1::QueryInterpretationOptions::Representation
      
          property :request_options, as: 'requestOptions', class: Google::Apis::CloudsearchV1::RequestOptions, decorator: Google::Apis::CloudsearchV1::RequestOptions::Representation
      
          property :sort_options, as: 'sortOptions', class: Google::Apis::CloudsearchV1::SortOptions, decorator: Google::Apis::CloudsearchV1::SortOptions::Representation
      
          property :start, as: 'start'
        end
      end
      
      class SearchResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :debug_info, as: 'debugInfo', class: Google::Apis::CloudsearchV1::ResponseDebugInfo, decorator: Google::Apis::CloudsearchV1::ResponseDebugInfo::Representation
      
          property :error_info, as: 'errorInfo', class: Google::Apis::CloudsearchV1::ErrorInfo, decorator: Google::Apis::CloudsearchV1::ErrorInfo::Representation
      
          collection :facet_results, as: 'facetResults', class: Google::Apis::CloudsearchV1::FacetResult, decorator: Google::Apis::CloudsearchV1::FacetResult::Representation
      
          property :has_more_results, as: 'hasMoreResults'
          property :query_interpretation, as: 'queryInterpretation', class: Google::Apis::CloudsearchV1::QueryInterpretation, decorator: Google::Apis::CloudsearchV1::QueryInterpretation::Representation
      
          property :result_count_estimate, :numeric_string => true, as: 'resultCountEstimate'
          property :result_count_exact, :numeric_string => true, as: 'resultCountExact'
          property :result_counts, as: 'resultCounts', class: Google::Apis::CloudsearchV1::ResultCounts, decorator: Google::Apis::CloudsearchV1::ResultCounts::Representation
      
          collection :results, as: 'results', class: Google::Apis::CloudsearchV1::SearchResult, decorator: Google::Apis::CloudsearchV1::SearchResult::Representation
      
          collection :spell_results, as: 'spellResults', class: Google::Apis::CloudsearchV1::SpellResult, decorator: Google::Apis::CloudsearchV1::SpellResult::Representation
      
          collection :structured_results, as: 'structuredResults', class: Google::Apis::CloudsearchV1::StructuredResult, decorator: Google::Apis::CloudsearchV1::StructuredResult::Representation
      
        end
      end
      
      class SearchResult
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :clustered_results, as: 'clusteredResults', class: Google::Apis::CloudsearchV1::SearchResult, decorator: Google::Apis::CloudsearchV1::SearchResult::Representation
      
          property :debug_info, as: 'debugInfo', class: Google::Apis::CloudsearchV1::ResultDebugInfo, decorator: Google::Apis::CloudsearchV1::ResultDebugInfo::Representation
      
          property :metadata, as: 'metadata', class: Google::Apis::CloudsearchV1::Metadata, decorator: Google::Apis::CloudsearchV1::Metadata::Representation
      
          property :snippet, as: 'snippet', class: Google::Apis::CloudsearchV1::Snippet, decorator: Google::Apis::CloudsearchV1::Snippet::Representation
      
          property :title, as: 'title'
          property :url, as: 'url'
        end
      end
      
      class Snippet
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :match_ranges, as: 'matchRanges', class: Google::Apis::CloudsearchV1::MatchRange, decorator: Google::Apis::CloudsearchV1::MatchRange::Representation
      
          property :snippet, as: 'snippet'
        end
      end
      
      class SortOptions
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :operator_name, as: 'operatorName'
          property :sort_order, as: 'sortOrder'
        end
      end
      
      class Source
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :name, as: 'name'
          property :predefined_source, as: 'predefinedSource'
        end
      end
      
      class SourceConfig
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :crowding_config, as: 'crowdingConfig', class: Google::Apis::CloudsearchV1::SourceCrowdingConfig, decorator: Google::Apis::CloudsearchV1::SourceCrowdingConfig::Representation
      
          property :scoring_config, as: 'scoringConfig', class: Google::Apis::CloudsearchV1::SourceScoringConfig, decorator: Google::Apis::CloudsearchV1::SourceScoringConfig::Representation
      
          property :source, as: 'source', class: Google::Apis::CloudsearchV1::Source, decorator: Google::Apis::CloudsearchV1::Source::Representation
      
        end
      end
      
      class SourceCrowdingConfig
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :num_results, as: 'numResults'
          property :num_suggestions, as: 'numSuggestions'
        end
      end
      
      class SourceResultCount
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :has_more_results, as: 'hasMoreResults'
          property :result_count_estimate, :numeric_string => true, as: 'resultCountEstimate'
          property :result_count_exact, :numeric_string => true, as: 'resultCountExact'
          property :source, as: 'source', class: Google::Apis::CloudsearchV1::Source, decorator: Google::Apis::CloudsearchV1::Source::Representation
      
        end
      end
      
      class SourceScoringConfig
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :source_importance, as: 'sourceImportance'
        end
      end
      
      class SpellResult
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :suggested_query, as: 'suggestedQuery'
        end
      end
      
      class StartUploadItemRequest
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :connector_name, as: 'connectorName'
          property :debug_options, as: 'debugOptions', class: Google::Apis::CloudsearchV1::DebugOptions, decorator: Google::Apis::CloudsearchV1::DebugOptions::Representation
      
        end
      end
      
      class Status
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :code, as: 'code'
          collection :details, as: 'details'
          property :message, as: 'message'
        end
      end
      
      class StructuredDataObject
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :properties, as: 'properties', class: Google::Apis::CloudsearchV1::NamedProperty, decorator: Google::Apis::CloudsearchV1::NamedProperty::Representation
      
        end
      end
      
      class StructuredResult
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :person, as: 'person', class: Google::Apis::CloudsearchV1::Person, decorator: Google::Apis::CloudsearchV1::Person::Representation
      
        end
      end
      
      class SuggestRequest
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :data_source_restrictions, as: 'dataSourceRestrictions', class: Google::Apis::CloudsearchV1::DataSourceRestriction, decorator: Google::Apis::CloudsearchV1::DataSourceRestriction::Representation
      
          property :query, as: 'query'
          property :request_options, as: 'requestOptions', class: Google::Apis::CloudsearchV1::RequestOptions, decorator: Google::Apis::CloudsearchV1::RequestOptions::Representation
      
        end
      end
      
      class SuggestResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :suggest_results, as: 'suggestResults', class: Google::Apis::CloudsearchV1::SuggestResult, decorator: Google::Apis::CloudsearchV1::SuggestResult::Representation
      
        end
      end
      
      class SuggestResult
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :people_suggestion, as: 'peopleSuggestion', class: Google::Apis::CloudsearchV1::PeopleSuggestion, decorator: Google::Apis::CloudsearchV1::PeopleSuggestion::Representation
      
          property :query_suggestion, as: 'querySuggestion', class: Google::Apis::CloudsearchV1::QuerySuggestion, decorator: Google::Apis::CloudsearchV1::QuerySuggestion::Representation
      
          property :source, as: 'source', class: Google::Apis::CloudsearchV1::Source, decorator: Google::Apis::CloudsearchV1::Source::Representation
      
          property :suggested_query, as: 'suggestedQuery'
        end
      end
      
      class TextOperatorOptions
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :exact_match_with_operator, as: 'exactMatchWithOperator'
          property :operator_name, as: 'operatorName'
        end
      end
      
      class TextPropertyOptions
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :operator_options, as: 'operatorOptions', class: Google::Apis::CloudsearchV1::TextOperatorOptions, decorator: Google::Apis::CloudsearchV1::TextOperatorOptions::Representation
      
          property :retrieval_importance, as: 'retrievalImportance', class: Google::Apis::CloudsearchV1::RetrievalImportance, decorator: Google::Apis::CloudsearchV1::RetrievalImportance::Representation
      
        end
      end
      
      class TextValues
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :values, as: 'values'
        end
      end
      
      class TimestampOperatorOptions
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :greater_than_operator_name, as: 'greaterThanOperatorName'
          property :less_than_operator_name, as: 'lessThanOperatorName'
          property :operator_name, as: 'operatorName'
        end
      end
      
      class TimestampPropertyOptions
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :operator_options, as: 'operatorOptions', class: Google::Apis::CloudsearchV1::TimestampOperatorOptions, decorator: Google::Apis::CloudsearchV1::TimestampOperatorOptions::Representation
      
        end
      end
      
      class TimestampValues
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :values, as: 'values'
        end
      end
      
      class UnmappedIdentity
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :external_identity, as: 'externalIdentity', class: Google::Apis::CloudsearchV1::Principal, decorator: Google::Apis::CloudsearchV1::Principal::Representation
      
          property :resolution_status_code, as: 'resolutionStatusCode'
        end
      end
      
      class UnreserveItemsRequest
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :connector_name, as: 'connectorName'
          property :debug_options, as: 'debugOptions', class: Google::Apis::CloudsearchV1::DebugOptions, decorator: Google::Apis::CloudsearchV1::DebugOptions::Representation
      
          property :queue, as: 'queue'
        end
      end
      
      class UpdateDataSourceRequest
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :debug_options, as: 'debugOptions', class: Google::Apis::CloudsearchV1::DebugOptions, decorator: Google::Apis::CloudsearchV1::DebugOptions::Representation
      
          property :source, as: 'source', class: Google::Apis::CloudsearchV1::DataSource, decorator: Google::Apis::CloudsearchV1::DataSource::Representation
      
        end
      end
      
      class UpdateSchemaRequest
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :debug_options, as: 'debugOptions', class: Google::Apis::CloudsearchV1::DebugOptions, decorator: Google::Apis::CloudsearchV1::DebugOptions::Representation
      
          property :schema, as: 'schema', class: Google::Apis::CloudsearchV1::Schema, decorator: Google::Apis::CloudsearchV1::Schema::Representation
      
          property :validate_only, as: 'validateOnly'
        end
      end
      
      class UploadItemRef
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :name, as: 'name'
        end
      end
      
      class Value
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :boolean_value, as: 'booleanValue'
          property :date_value, as: 'dateValue', class: Google::Apis::CloudsearchV1::Date, decorator: Google::Apis::CloudsearchV1::Date::Representation
      
          property :double_value, as: 'doubleValue'
          property :integer_value, :numeric_string => true, as: 'integerValue'
          property :string_value, as: 'stringValue'
          property :timestamp_value, as: 'timestampValue'
        end
      end
      
      class ValueFilter
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :operator_name, as: 'operatorName'
          property :value, as: 'value', class: Google::Apis::CloudsearchV1::Value, decorator: Google::Apis::CloudsearchV1::Value::Representation
      
        end
      end
    end
  end
end
