% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conditions.R
\name{vctrs-conditions}
\alias{vctrs-conditions}
\alias{stop_incompatible_type}
\alias{stop_incompatible_cast}
\alias{stop_incompatible_op}
\alias{stop_incompatible_size}
\alias{allow_lossy_cast}
\title{Custom conditions for vctrs package}
\usage{
stop_incompatible_type(
  x,
  y,
  ...,
  x_arg,
  y_arg,
  action = c("combine", "convert"),
  details = NULL,
  message = NULL,
  class = NULL
)

stop_incompatible_cast(
  x,
  to,
  ...,
  x_arg,
  to_arg,
  details = NULL,
  message = NULL,
  class = NULL
)

stop_incompatible_op(
  op,
  x,
  y,
  details = NULL,
  ...,
  message = NULL,
  class = NULL
)

stop_incompatible_size(
  x,
  y,
  x_size,
  y_size,
  ...,
  x_arg,
  y_arg,
  details = NULL,
  message = NULL,
  class = NULL
)

allow_lossy_cast(expr, x_ptype = NULL, to_ptype = NULL)
}
\arguments{
\item{x, y, to}{Vectors}

\item{..., class}{Only use these fields when creating a subclass.}

\item{x_arg, y_arg, to_arg}{Argument names for \code{x}, \code{y}, and \code{to}. Used in
error messages to inform the user about the locations of incompatible
types.}

\item{action}{An option to customize the incompatible type message depending
on the context. Errors thrown from \code{\link[=vec_ptype2]{vec_ptype2()}} use \code{"combine"} and
those thrown from \code{\link[=vec_cast]{vec_cast()}} use \code{"convert"}.}

\item{details}{Any additional human readable details.}

\item{message}{An overriding message for the error. \code{details} and
\code{message} are mutually exclusive, supplying both is an error.}

\item{x_ptype, to_ptype}{Suppress only the casting errors where \code{x}
or \code{to} match these \link[=vec_ptype]{prototypes}.}

\item{subclass}{Use if you want to further customize the class.}
}
\value{
\verb{stop_incompatible_*()} unconditionally raise an error of class
\code{"vctrs_error_incompatible_*"} and \code{"vctrs_error_incompatible"}.
}
\description{
These functions are called for their side effect of raising
errors and warnings.
These conditions have custom classes and structures to make
testing easier.
}
\examples{

# Most of the time, `maybe_lossy_cast()` returns its input normally:
maybe_lossy_cast(
  c("foo", "bar"),
  NULL,
  "",
  lossy = c(FALSE, FALSE),
  x_arg = "",
  to_arg = ""
)

# If `lossy` has any `TRUE`, an error is thrown:
try(maybe_lossy_cast(
  c("foo", "bar"),
  NULL,
  "",
  lossy = c(FALSE, TRUE),
  x_arg = "",
  to_arg = ""
))

# Unless lossy casts are allowed:
allow_lossy_cast(
  maybe_lossy_cast(
    c("foo", "bar"),
    NULL,
    "",
    lossy = c(FALSE, TRUE),
    x_arg = "",
    to_arg = ""
  )
)

}
\keyword{internal}
