% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{cleanSeqs}
\alias{cleanSeqs}
\title{Clean up nucleotide sequences}
\usage{
cleanSeqs(seqs)
}
\arguments{
\item{seqs}{vector of nucleotide sequences.}
}
\value{
A modified vector of nucleotide sequences.
}
\description{
\code{cleanSeqs} capitalizes nucleotides and replaces all characters 
besides \code{c("A", "C", "G", "T", "-", ".")} with \code{"N"}.
}
\examples{
# Clean messy nucleotide sequences
seqs <- c("AGAT.taa-GAG...ATA", "GATACAGTXXZZAGNNPPACA")
cleanSeqs(seqs)

}
\seealso{
\link{sortAlleles} and \link{updateAlleleNames} can
         help format a list of allele names.
}
