% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/play.R
\name{evolution_games}
\alias{evolution_games}
\alias{play_citation_age}
\alias{play_forestfire}
\alias{play_growing}
\alias{play_barabasi_albert}
\alias{play_barabasi_albert_aging}
\title{Graph games based on evolution}
\usage{
play_citation_age(
  n,
  growth = 1,
  bins = n/7100,
  p_pref = (1:(bins + 1))^-3,
  directed = TRUE
)

play_forestfire(
  n,
  p_forward,
  p_backward = p_forward,
  growth = 1,
  directed = TRUE
)

play_growing(n, growth = 1, directed = TRUE, citation = FALSE)

play_barabasi_albert(
  n,
  power,
  growth = 1,
  growth_dist = NULL,
  use_out = FALSE,
  appeal_zero = 1,
  directed = TRUE,
  method = "psumtree"
)

play_barabasi_albert_aging(
  n,
  power,
  power_age,
  growth = 1,
  growth_dist = NULL,
  bins = 300,
  use_out = FALSE,
  appeal_zero = 1,
  appeal_zero_age = 0,
  directed = TRUE,
  coefficient = 1,
  coefficient_age = 1,
  window = NULL
)
}
\arguments{
\item{n}{The number of nodes in the graph.}

\item{growth}{The number of edges added at each iteration}

\item{bins}{The number of aging bins}

\item{p_pref}{The probability that an edge will be made to an age bin.}

\item{directed}{Should the resulting graph be directed}

\item{p_forward, p_backward}{Forward and backward burning probability}

\item{citation}{Should a citation graph be created}

\item{power}{The power of the preferential attachment}

\item{growth_dist}{The distribution of the number of added edges at each iteration}

\item{use_out}{Should outbound edges be used for calculating citation probability}

\item{appeal_zero}{The appeal value for unconnected nodes}

\item{method}{The algorithm to use for graph creation. Either \code{'psumtree'},
\code{'psumtree-multiple'}, or \code{'bag'}}

\item{power_age}{The aging exponent}

\item{appeal_zero_age}{The appeal value of nodes without age}

\item{coefficient}{The coefficient of the degree dependent part of attrictiveness}

\item{coefficient_age}{The coefficient of the age dependent part of attrictiveness}

\item{window}{The aging window to take into account when calculating the preferential attraction}
}
\value{
A tbl_graph object
}
\description{
This games create graphs through different types of evolutionary mechanisms
(not necessarily in a biological sense). The nature of their algorithm is
described in detail at the linked igraph documentation.
}
\section{Functions}{
\itemize{
\item \code{play_citation_age()}: Create citation graphs based on a specific age
link probability. See \code{\link[igraph:sample_last_cit]{igraph::sample_last_cit()}}

\item \code{play_forestfire()}: Create graphs by simulating the spead of fire in
a forest. See \code{\link[igraph:sample_forestfire]{igraph::sample_forestfire()}}

\item \code{play_growing()}: Create graphs by adding a fixed number of edges
at each iteration. See \code{\link[igraph:sample_growing]{igraph::sample_growing()}}

\item \code{play_barabasi_albert()}: Create graphs based on the Barabasi-Alberts
preferential attachment model. See \code{\link[igraph:sample_pa]{igraph::sample_pa()}}

\item \code{play_barabasi_albert_aging()}: Create graphs based on the Barabasi-Alberts
preferential attachment model, incoorporating node age preferrence. See
\code{\link[igraph:sample_pa_age]{igraph::sample_pa_age()}}.

}}
\examples{
plot(play_forestfire(50, 0.5))

}
\seealso{
\code{\link[=play_traits]{play_traits()}} and \code{\link[=play_citation_type]{play_citation_type()}} for an evolutionary
algorithm based on different node types

Other graph games: 
\code{\link{component_games}},
\code{\link{sampling_games}},
\code{\link{type_games}}
}
\concept{graph games}
