% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test-that.R
\name{test_that}
\alias{test_that}
\title{Run a test}
\usage{
test_that(desc, code)
}
\arguments{
\item{desc}{Test name. Names should be brief, but evocative. It's common to
write the description so that it reads like a natural sentence, e.g.
\code{test_that("multiplication works", { ... })}.}

\item{code}{Test code containing expectations. Braces (\code{{}}) should always
be used in order to get accurate location data for test failures.}
}
\value{
When run interactively, returns \code{invisible(TRUE)} if all tests
pass, otherwise throws an error.
}
\description{
A test encapsulates a series of expectations about a small, self-contained
unit of functionality. Each test contains one or more expectations, such as
\code{\link[=expect_equal]{expect_equal()}} or \code{\link[=expect_error]{expect_error()}}, and lives in a \verb{test/testhat/test*}
file, often together with other tests that relate to the same function or set
of functions.

Each test has its own execution environment, so an object created in a test
also dies with the test. Note that this cleanup does not happen automatically
for other aspects of global state, such as session options or filesystem
changes. Avoid changing global state, when possible, and reverse any changes
that you do make.
}
\examples{
test_that("trigonometric functions match identities", {
  expect_equal(sin(pi / 4), 1 / sqrt(2))
  expect_equal(cos(pi / 4), 1 / sqrt(2))
  expect_equal(tan(pi / 4), 1)
})

\dontrun{
test_that("trigonometric functions match identities", {
  expect_equal(sin(pi / 4), 1)
})
}
}
