% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hellinger.R
\name{hellinger}
\alias{hellinger}
\title{Hellinger distance}
\usage{
hellinger(x, y, lower = -Inf, upper = Inf, method = 1, ...)
}
\arguments{
\item{x}{numeric. A vector giving the first sample.}

\item{y}{numeric. A vector giving the second sample.}

\item{lower}{numeric. Lower limit passed to \code{\link[stats]{integrate}}.}

\item{upper}{numeric. Upper limit passed to \code{\link[stats]{integrate}}.}

\item{method}{integer. If \code{method = 1}, the usual definition 
of the Hellinger distance is used; if \code{method = 2}, 
an alternative formula is used.}

\item{...}{Additional parameters to be passed to \code{\link[statip]{densityfun}}.}
}
\value{
A numeric value, the Hellinger distance.
}
\description{
Estimate the 
\href{https://en.wikipedia.org/wiki/Hellinger_distance}{Hellinger distance} 
between two random samples whose underdyling distributions 
are continuous.
}
\details{
Probability density functions are estimated with 
\code{\link[statip]{densityfun}}. 
Then numeric integration is performed with \code{\link[stats]{integrate}}.
}
\examples{
x <- rnorm(200, 0, 2)
y <- rnorm(1000, 10, 15)
hellinger(x, y, -Inf, Inf)
hellinger(x, y, -Inf, Inf, method = 2)

}
\references{
\url{https://en.wikipedia.org/wiki/Hellinger_distance}.
}
\seealso{
\code{\link[distrEx]{HellingerDist}} in package \pkg{distrEx}.
}
