\name{structure.statistics}
\alias{structure.statistics}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{ Compute Network Structure Statistics }
\description{
  Computes the structure statistics for the graph(s) in \code{dat}.
}
\usage{
structure.statistics(dat, geodist.precomp = NULL)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{dat}{ one or more input graphs. }
  \item{geodist.precomp}{ a \code{\link{geodist}} object (optional). }
}
\details{
  Let \eqn{G=(V,E)} be a graph of order \eqn{N}, and let \eqn{d(i,j)} be the geodesic distance from vertex \eqn{i} to vertex \eqn{j} in \eqn{G}.  The "structure statistics" of \eqn{G} are then given by the series \eqn{s_0,\ldots,s_{N-1}}, where \eqn{s_i = \frac{1}{N^2} \sum_{j \in V} \sum_{k \in V} I\left(d(j,k) \le i\right) }{s_i = sum(sum(I(d(j,k)<=i, k in V), j in V)/N^2} and \eqn{I} is the standard indicator function.  Intuitively, \eqn{s_i} is the expected fraction of \eqn{G} which lies within distance \code{i} of a randomly chosen vertex.  As such, the structure statistics provide an index of global connectivity.

Structure statistics have been of particular importance to biased net theorists, because of the link with Rapoport's original tracing model.  They may also be used along with component distributions or connectedness scores as descriptive indices of connectivity at the graph-level.
}
\value{
  A vector, matrix, or list (depending on \code{dat}) containing the structure statistics.
}
\references{ 
Fararo, T.J. (1981).  ``Biased networks and social structure theorems. Part I.'' \emph{Social Networks,} 3, 137-159.

Fararo, T.J. (1984).  ``Biased networks and social structure theorems. Part II.''  \emph{Social Networks,} 6, 223-258.

Fararo, T.J. and Sunshine, M.H. (1964).  ``A study of a biased friendship net.''  Syracuse, NY: Youth Development Center.
}
\author{ Carter T. Butts \email{buttsc@uci.edu} }
\note{ The term "structure statistics" has been used somewhat loosely in the literature, a trend which seems to be accelerating.  Users should carefully check references before comparing results generated by this routine with those appearing in published work. }

% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{ \code{\link{geodist}}, \code{\link{component.dist}}, \code{\link{connectedness}}, \code{\link{bn}} }
\examples{
#Generate a moderately sparse Bernoulli graph
g<-rgraph(100,tp=1.5/99)

#Compute the structure statistics for g
ss<-structure.statistics(g)
plot(0:99,ss,xlab="Mean Coverage",ylab="Distance")

}
\keyword{ graphs }% at least one, from doc/KEYWORDS
%\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
