% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxes.R
\name{infoBox}
\alias{infoBox}
\title{Create an info box for the main body of a dashboard.}
\usage{
infoBox(title, value = NULL, subtitle = NULL,
  icon = shiny::icon("bar-chart"), color = "aqua", width = 4,
  href = NULL, fill = FALSE)
}
\arguments{
\item{title}{Title text.}

\item{value}{The value to display in the box. Usually a number or short text.}

\item{subtitle}{Subtitle text (optional).}

\item{icon}{An icon tag, created by \code{\link[shiny]{icon}}.}

\item{color}{A color for the box. Valid colors are listed in
\link{validColors}.}

\item{width}{The width of the box, using the Bootstrap grid system. This is
used for row-based layouts. The overall width of a region is 12, so the
default valueBox width of 4 occupies 1/3 of that width. For column-based
layouts, use \code{NULL} for the width; the width is set by the column that
contains the box.}

\item{href}{An optional URL to link to.}

\item{fill}{If \code{FALSE} (the default), use a white background for the
content, and the \code{color} argument for the background of the icon. If
\code{TRUE}, use the \code{color} argument for the background of the
content; the icon will use the same color with a slightly darkened
background.}
}
\description{
An info box displays a large icon on the left side, and a title, value
(usually a number), and an optional smaller subtitle on the right side. Info
boxes are meant to be placed in the main body of a dashboard.
}
\seealso{
\code{\link{box}} for usage examples.

Other boxes: \code{\link{box}}, \code{\link{tabBox}},
  \code{\link{valueBox}}
}
\concept{boxes}
