#' Latest release for which a source tarball is available for download
#'
#' [r_release()] works based on the SVN tags in the main R source code
#' repository. However, an SVN tag does not mean that the same version
#' is available for download. `r_release_tarball` returns the latest
#' version for which a source tarball is available.
#'
#' @section Note:
#' This function is superseded by [resolve()]:
#' ```{r}
#' r_release_tarball()
#' ```
#' ```{r}
#' resolve("release", platform = NA)
#' ```
#'
#' @return A one row data frame, with columns \sQuote{version},
#'   \sQuote{date}, \sQuote{URL} and \sQuote{nickname}.
#'
#' @export
#' @family R downloads
#' @examplesIf rversions:::is_online()
#' r_release()
#' r_release_tarball()

r_release_tarball <- function() {
  df <- api_version_df1("r-release-tarball")
  df
}
