/*
 * Decompiled with CFR 0.152.
 */
package mine.core;

import data.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class GridFinder {
    static long start = System.currentTimeMillis();
    static long last;

    public static float[] approxMaxMI(Point[] dataX, Point[] dataY, int maxB_x, int b_y, double numClumpsFactor, int debug) {
        if (maxB_x < 2 || b_y < 2 || (double)maxB_x * numClumpsFactor < 2.0) {
            System.err.println("MI Maximizer says: BAD BINNING REQEST. maxB_x and b_y must both be at least 2, and numClumpsFactor*maxB_x must be at least 2.");
            System.err.println("Exiting.");
            System.exit(0);
        }
        last = System.currentTimeMillis();
        float[] results = new float[maxB_x + 1];
        Map<Integer, Integer> rowAssignments = GridFinder.equipartitionYAxis(dataY, b_y);
        if (debug >= 4) {
            System.out.println(String.valueOf(maxB_x) + "\t" + b_y + "\t" + "\tY-axis part\t" + (System.currentTimeMillis() - last) + "\t\t" + (System.currentTimeMillis() - start));
        }
        last = System.currentTimeMillis();
        Integer[] clumps = GridFinder.makeSuperClumps(dataX, b_y, rowAssignments, (int)(numClumpsFactor * (double)maxB_x), debug);
        if (clumps.length < 2) {
            System.out.println("\tMIMaximizer says: WARNING-- ONE OF THE VARIABLES CONTAINS ONLY ONE VALUE. Dumping data");
            int i = 0;
            while (i < dataX.length) {
                System.out.println("\t" + dataX[i] + " in row " + rowAssignments.get(dataX[i].hashCode()));
                ++i;
            }
            return new float[results.length];
        }
        int[][] clumpHistogram = GridFinder.makeClumpHistogram(dataX, b_y, rowAssignments, clumps);
        if (maxB_x > clumps.length) {
            maxB_x = clumps.length;
        }
        LinkedListNode[][] Solutions = new LinkedListNode[clumps.length][maxB_x - 1];
        float[][] Benefits = new float[clumps.length][maxB_x - 1];
        if (debug >= 4) {
            System.out.println(String.valueOf(maxB_x) + "\t" + b_y + "\t" + clumps.length + "\tclumps     \t" + (System.currentTimeMillis() - last) + "\t\t" + (System.currentTimeMillis() - start));
        }
        last = System.currentTimeMillis();
        GridFinder.BaseCases(dataX, b_y, rowAssignments, clumps, Solutions, Benefits, clumpHistogram);
        if (debug >= 4) {
            System.out.println(String.valueOf(maxB_x) + "\t" + b_y + "\t" + clumps.length + "\tbase cases\t" + (System.currentTimeMillis() - last) + "\t\t" + (System.currentTimeMillis() - start));
        }
        last = System.currentTimeMillis();
        GridFinder.OptimizeXAxis(maxB_x, b_y, clumps, Solutions, Benefits, clumpHistogram, debug);
        double yEntropy = GridFinder.Hy(dataX, b_y, rowAssignments, debug);
        if (debug >= 3) {
            System.out.println("H(Y) = " + yEntropy);
        }
        int b_x = 2;
        while (b_x <= maxB_x) {
            results[b_x] = Benefits[clumps.length - 1][b_x - 2] + (float)yEntropy;
            ++b_x;
        }
        b_x = maxB_x + 1;
        while (b_x < results.length) {
            results[b_x] = results[maxB_x];
            ++b_x;
        }
        GridFinder.normalizeResults(b_y, results);
        if (debug >= 3) {
            System.out.println("normalized results: " + Arrays.toString(results));
        }
        if (debug >= 4) {
            System.out.println("LastVal = " + results[results.length - 1]);
        }
        return results;
    }

    private static void OptimizeXAxis(int maxB_x, int b_y, Integer[] clumps, LinkedListNode[][] Solutions, float[][] Benefits, int[][] clumpHistogram, int debug) {
        int l = 1;
        while (l < maxB_x - 1) {
            int c = l + 1;
            while (c < clumps.length) {
                float maxBenefit = -3.4028235E38f;
                int bestLineClumpNum = -1;
                int[] columnHist = new int[b_y];
                int lineClumpNum = c;
                while (lineClumpNum > l - 1) {
                    if (lineClumpNum < c) {
                        int j = 0;
                        while (j < b_y) {
                            int n = j;
                            columnHist[n] = columnHist[n] + clumpHistogram[lineClumpNum + 1][j];
                            ++j;
                        }
                    }
                    int Ai = clumps[lineClumpNum] + 1;
                    int Bi = clumps[c] - clumps[lineClumpNum];
                    float Hy = 0.0f;
                    int j = 0;
                    while (j < b_y) {
                        if (columnHist[j] > 0) {
                            Hy = (float)((double)Hy + (double)columnHist[j] * Math.log((float)columnHist[j] / (float)Bi));
                        }
                        ++j;
                    }
                    float benefit = (float)Ai / (float)(Ai + Bi) * Benefits[lineClumpNum][l - 1] + Hy / (float)(Ai + Bi);
                    if (benefit > maxBenefit) {
                        maxBenefit = benefit;
                        bestLineClumpNum = lineClumpNum;
                    }
                    --lineClumpNum;
                }
                Solutions[c][l] = new LinkedListNode(clumps[c], Solutions[bestLineClumpNum][l - 1]);
                Benefits[c][l] = maxBenefit;
                ++c;
            }
            ++l;
        }
        if (debug >= 4) {
            System.out.println(String.valueOf(maxB_x) + "\t" + b_y + "\t" + clumps.length + "\ttable     \t" + (System.currentTimeMillis() - last) + "\t\t" + (System.currentTimeMillis() - start));
        }
    }

    private static void normalizeResults(int b_y, float[] results) {
        int b_x = 2;
        while (b_x < results.length) {
            if (b_x > b_y) {
                int n = b_x;
                results[n] = (float)((double)results[n] / Math.log(b_y));
            } else {
                int n = b_x;
                results[n] = (float)((double)results[n] / Math.log(b_x));
            }
            results[b_x] = (float)((int)(results[b_x] * 100000.0f)) / 100000.0f;
            results[b_x] = Math.min(1.0f, results[b_x]);
            ++b_x;
        }
    }

    private static void BaseCases(Point[] dataX, int b_y, Map<Integer, Integer> rowAssignments, Integer[] clumps, LinkedListNode[][] Solutions, float[][] Benefits, int[][] clumpHistogram) {
        Solutions[0][0] = null;
        Benefits[0][0] = Float.NaN;
        int c = 1;
        while (c < clumps.length) {
            float maxBenefit = -3.4028235E38f;
            int bestLineClumpNum = -1;
            int[] columnHistA = new int[b_y];
            int[] columnHistB = new int[b_y];
            int i = 0;
            while (i <= c) {
                int j = 0;
                while (j < b_y) {
                    int n = j;
                    columnHistB[n] = columnHistB[n] + clumpHistogram[i][j];
                    ++j;
                }
                ++i;
            }
            int lineClumpNum = 0;
            while (lineClumpNum < c) {
                int j = 0;
                while (j < b_y) {
                    int n = j;
                    columnHistB[n] = columnHistB[n] - clumpHistogram[lineClumpNum][j];
                    int n2 = j;
                    columnHistA[n2] = columnHistA[n2] + clumpHistogram[lineClumpNum][j];
                    ++j;
                }
                float benefit = 0.0f;
                int columnA = clumps[lineClumpNum] + 1;
                int columnB = clumps[c] - clumps[lineClumpNum];
                int total = clumps[c] + 1;
                int j2 = 0;
                while (j2 < b_y) {
                    if (columnHistA[j2] > 0) {
                        benefit = (float)((double)benefit + (double)columnHistA[j2] * Math.log((float)columnHistA[j2] / (float)columnA));
                    }
                    if (columnHistB[j2] > 0) {
                        benefit = (float)((double)benefit + (double)columnHistB[j2] * Math.log((float)columnHistB[j2] / (float)columnB));
                    }
                    ++j2;
                }
                if ((benefit /= (float)total) > maxBenefit) {
                    maxBenefit = benefit;
                    bestLineClumpNum = lineClumpNum;
                }
                ++lineClumpNum;
            }
            Solutions[c][0] = new LinkedListNode(clumps[c], new LinkedListNode(clumps[bestLineClumpNum]));
            Benefits[c][0] = maxBenefit;
            ++c;
        }
    }

    private static float Hy(Point[] dataX, int b_y, Map<Integer, Integer> rowAssignments, int debug) {
        float total = 0.0f;
        int[] yHist = new int[b_y];
        int i = 0;
        while (i < dataX.length) {
            int n = rowAssignments.get(dataX[i].hashCode());
            yHist[n] = yHist[n] + 1;
            ++i;
        }
        if (debug >= 3) {
            System.out.println("Y histogram = " + Arrays.toString(yHist));
        }
        int j = 0;
        while (j < b_y) {
            if (yHist[j] > 0) {
                total = (float)((double)total + (double)((float)yHist[j] / (float)dataX.length) * Math.log((double)dataX.length / (double)yHist[j]));
            }
            ++j;
        }
        return total;
    }

    private static Map<Integer, Integer> equipartitionYAxis(Point[] dataY, int b_y) {
        HashMap<Integer, Integer> rowAssignments = new HashMap<Integer, Integer>();
        int[] yHist = new int[b_y];
        float yBinSize = (float)dataY.length / (float)b_y;
        int currBin = 0;
        int numPlaced = 0;
        int i = 0;
        while (i < dataY.length) {
            int numWithThisY = 0;
            while (i + numWithThisY < dataY.length && dataY[i + numWithThisY].y == dataY[i].y) {
                ++numWithThisY;
            }
            if (Math.abs((float)(yHist[currBin] + numWithThisY) - yBinSize) >= Math.abs((float)yHist[currBin] - yBinSize) && yHist[currBin] != 0) {
                yBinSize = (float)(dataY.length - numPlaced) / (float)(b_y - ++currBin);
            }
            int j = 0;
            while (j < numWithThisY) {
                rowAssignments.put(dataY[i + j].hashCode(), currBin);
                ++j;
            }
            int n = currBin;
            yHist[n] = yHist[n] + numWithThisY;
            numPlaced += numWithThisY;
            i += numWithThisY - 1;
            ++i;
        }
        return rowAssignments;
    }

    private static Integer[] makeSuperClumps(Point[] dataX, int b_y, Map<Integer, Integer> rowAssignments, int numSuperClumps, int debug) {
        ArrayList<Integer> myClumps = new ArrayList<Integer>(dataX.length);
        int desiredSuperClumpSize = dataX.length / numSuperClumps;
        if (debug >= 4) {
            System.out.println("Desired clump size: " + desiredSuperClumpSize);
        }
        myClumps.add(-1);
        int i = 0;
        int numInThisSuperClump = 0;
        while (i < dataX.length) {
            boolean oneXVal = true;
            boolean oneRow = true;
            int numInThisClump = 0;
            while (i + numInThisClump < dataX.length) {
                if (!rowAssignments.get(dataX[i + numInThisClump].hashCode()).equals(rowAssignments.get(dataX[i].hashCode()))) {
                    oneRow = false;
                }
                if (dataX[i + numInThisClump].x != dataX[i].x) {
                    if (!oneRow) break;
                    oneXVal = false;
                }
                if (!oneXVal && !rowAssignments.get(dataX[i + numInThisClump].hashCode()).equals(rowAssignments.get(dataX[i].hashCode()))) break;
                ++numInThisClump;
            }
            if (!oneXVal && i + numInThisClump < dataX.length && dataX[i + numInThisClump].x == dataX[i + numInThisClump - 1].x) {
                int j = 1;
                while (dataX[i + numInThisClump - j].x == dataX[i + numInThisClump - 1].x) {
                    ++j;
                }
                numInThisClump -= --j;
            }
            if (Math.abs(numInThisSuperClump + numInThisClump - desiredSuperClumpSize) >= Math.abs(numInThisSuperClump - desiredSuperClumpSize) && numInThisSuperClump != 0) {
                myClumps.add(i - 1);
                numInThisSuperClump = numInThisClump;
                desiredSuperClumpSize = myClumps.size() - 1 == numSuperClumps ? Integer.MAX_VALUE : (dataX.length - i - 1) / (numSuperClumps - myClumps.size() + 1);
            } else {
                numInThisSuperClump += numInThisClump;
            }
            i += numInThisClump;
        }
        myClumps.add(dataX.length - 1);
        myClumps.remove(0);
        if (debug >= 4) {
            System.out.println("Clumping partition: " + myClumps.toString());
        }
        Integer[] list = new Integer[myClumps.size()];
        myClumps.toArray(list);
        return list;
    }

    private static int[][] makeClumpHistogram(Point[] dataX, int b_y, Map<Integer, Integer> rowAssignments, Integer[] clumps) {
        int[][] clumpHistogram = new int[clumps.length][];
        int c = 0;
        while (c < clumps.length) {
            clumpHistogram[c] = new int[b_y];
            int a = c == 0 ? 0 : clumps[c - 1] + 1;
            while (a <= clumps[c]) {
                int[] nArray = clumpHistogram[c];
                int n = rowAssignments.get(dataX[a].hashCode());
                nArray[n] = nArray[n] + 1;
                ++a;
            }
            ++c;
        }
        return clumpHistogram;
    }

    private static class LinkedListNode {
        public int info;
        public LinkedListNode child;

        public LinkedListNode(int info_) {
            this.child = null;
            this.info = info_;
        }

        public LinkedListNode(int info_, LinkedListNode child_) {
            this.child = child_;
            this.info = info_;
        }

        public int[] toArrayInReverse(int length) {
            int[] result = new int[length];
            this.putValues(result, length - 1);
            return result;
        }

        private void putValues(int[] array, int index) {
            array[index] = this.info;
            if (this.child != null) {
                this.child.putValues(array, index - 1);
            }
            if (this.child == null && index > 0) {
                int i = index - 1;
                while (i >= 0) {
                    array[i] = -1;
                    --i;
                }
            }
        }

        public String toString() {
            int[] str = new int[15];
            this.putValues(str, 14);
            return "first 15: " + Arrays.toString(str);
        }
    }
}

