% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csplit.R
\name{csplit}
\alias{csplit}
\alias{foldr}
\title{Split data into folds}
\usage{
csplit(x, p = NULL, replace = FALSE, return.index = FALSE, k = 2, ...)
}
\arguments{
\item{x}{Data or integer (size)}

\item{p}{Number of folds, or if a number between 0 and 1 is given two folds of size p and (1-p) will be returned}

\item{replace}{With or with-out replacement}

\item{return.index}{If TRUE index of folds are returned otherwise the actual data splits are returned (default)}

\item{k}{(Optional, only used when p=NULL) number of folds without shuffling}

\item{...}{additional arguments to lower-level functions}
}
\description{
Split data into folds
}
\examples{
foldr(5,2,rep=2)
csplit(10,3)
csplit(iris[1:10,]) ## Split in two sets 1:(n/2) and (n/2+1):n
csplit(iris[1:10,],0.5)
}
\author{
Klaus K. Holst
}
