% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guides-.R
\name{get_guide_data}
\alias{get_guide_data}
\title{Extract tick information from guides}
\usage{
get_guide_data(plot = last_plot(), aesthetic, panel = 1L)
}
\arguments{
\item{plot}{A \code{ggplot} or \code{ggplot_build} object.}

\item{aesthetic}{A string that describes a single aesthetic for which to
extract guide information. For example: \code{"colour"}, \code{"size"}, \code{"x"} or
\code{"y.sec"}.}

\item{panel}{An integer giving a panel number for which to return position guide
information.}
}
\value{
One of the following:
\itemize{
\item A \code{data.frame} representing the guide key, when the guide is unique for
the aesthetic.
\item A \code{list} when the coord does not support position axes or multiple guides
match the aesthetic.
\item \code{NULL} when no guide key could be found.
}
}
\description{
\code{get_guide_data()} builds a plot and extracts information from guide keys. This
information typically contains positions, values and/or labels, depending
on which aesthetic is queried or guide is used.
}
\examples{
# A standard plot
p <- ggplot(mtcars) +
  aes(mpg, disp, colour = drat, size = drat) +
  geom_point() +
  facet_wrap(vars(cyl), scales = "free_x")

# Guide information for legends
get_guide_data(p, "size")

# Note that legend guides can be merged
merged <- p + guides(colour = "legend")
get_guide_data(merged, "size")

# Guide information for positions
get_guide_data(p, "x", panel = 2)

# Coord polar doesn't support proper guides, so we get a list
polar <- p + coord_polar()
get_guide_data(polar, "theta", panel = 2)
}
\keyword{internal}
