% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_flextable.R
\name{as_flextable.data.frame}
\alias{as_flextable.data.frame}
\title{Printing data.frame summary as a flextable}
\usage{
\method{as_flextable}{data.frame}(
  x,
  max_row = 10,
  split_colnames = FALSE,
  short_strings = FALSE,
  short_size = 35,
  short_suffix = "...",
  do_autofit = TRUE,
  show_coltype = TRUE,
  color_coltype = "#999999",
  ...
)
}
\arguments{
\item{x}{a data.frame}

\item{max_row}{The number of rows to print. Default to 10.}

\item{split_colnames}{Should the column names be split
(with non alpha-numeric characters). Default to FALSE.}

\item{short_strings}{Should the character column be shorten.
Default to FALSE.}

\item{short_size}{Maximum length of character column if
\code{short_strings} is TRUE. Default to 35.}

\item{short_suffix}{Suffix to add when character values are shorten.
Default to "...".}

\item{do_autofit}{Use \code{\link[=autofit]{autofit()}} before rendering the table.
Default to TRUE.}

\item{show_coltype}{Show column types.
Default to TRUE.}

\item{color_coltype}{Color to use for column types.
Default to "#999999".}

\item{...}{unused arguments}
}
\description{
It displays the first rows and shows the column types.
If there is only one row, a simplified vertical table is produced.
}
\examples{
as_flextable(mtcars)
}
\seealso{
Other as_flextable methods: 
\code{\link{as_flextable.glm}()},
\code{\link{as_flextable.grouped_data}()},
\code{\link{as_flextable.htest}()},
\code{\link{as_flextable.kmeans}()},
\code{\link{as_flextable.lm}()},
\code{\link{as_flextable.merMod}()},
\code{\link{as_flextable.pam}()},
\code{\link{as_flextable.summarizor}()},
\code{\link{as_flextable.tabulator}()},
\code{\link{as_flextable.xtable}()},
\code{\link{as_flextable}()}
}
\concept{as_flextable methods}
