% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprec-lazyeval.R
\name{se-deprecated}
\alias{se-deprecated}
\alias{add_count_}
\alias{add_tally_}
\alias{arrange_}
\alias{count_}
\alias{distinct_}
\alias{do_}
\alias{filter_}
\alias{funs_}
\alias{group_by_}
\alias{group_indices_}
\alias{mutate_}
\alias{tally_}
\alias{transmute_}
\alias{rename_}
\alias{rename_vars_}
\alias{select_}
\alias{select_vars_}
\alias{slice_}
\alias{summarise_}
\alias{summarize_}
\title{Deprecated SE versions of main verbs.}
\usage{
add_count_(x, vars, wt = NULL, sort = FALSE)

add_tally_(x, wt, sort = FALSE)

arrange_(.data, ..., .dots = list())

count_(x, vars, wt = NULL, sort = FALSE, .drop = group_by_drop_default(x))

distinct_(.data, ..., .dots, .keep_all = FALSE)

do_(.data, ..., .dots = list())

filter_(.data, ..., .dots = list())

funs_(dots, args = list(), env = base_env())

group_by_(.data, ..., .dots = list(), add = FALSE)

group_indices_(.data, ..., .dots = list())

mutate_(.data, ..., .dots = list())

tally_(x, wt, sort = FALSE)

transmute_(.data, ..., .dots = list())

rename_(.data, ..., .dots = list())

rename_vars_(vars, args)

select_(.data, ..., .dots = list())

select_vars_(vars, args, include = chr(), exclude = chr())

slice_(.data, ..., .dots = list())

summarise_(.data, ..., .dots = list())

summarize_(.data, ..., .dots = list())
}
\arguments{
\item{x}{A \code{\link[=tbl]{tbl()}}}

\item{vars}{Various meanings depending on the verb.}

\item{wt}{<\code{\link[=dplyr_data_masking]{data-masking}}> Frequency weights.
Can be \code{NULL} or a variable:
\itemize{
\item If \code{NULL} (the default), counts the number of rows in each group.
\item If a variable, computes \code{sum(wt)} for each group.
}}

\item{sort}{If \code{TRUE}, will show the largest groups at the top.}

\item{.data}{A data frame.}

\item{.drop}{Drop groups formed by factor levels that don't appear in the
data? The default is \code{TRUE} except when \code{.data} has been previously
grouped with \code{.drop = FALSE}. See \code{\link[=group_by_drop_default]{group_by_drop_default()}} for details.}

\item{.keep_all}{If \code{TRUE}, keep all variables in \code{.data}.
If a combination of \code{...} is not distinct, this keeps the
first row of values.}

\item{dots, .dots, ...}{Pair/values of expressions coercible to lazy objects.}

\item{args}{Various meanings depending on the verb.}

\item{env}{The environment in which functions should be evaluated.}

\item{add}{When \code{FALSE}, the default, \code{group_by()} will
override existing groups. To add to the existing groups, use
\code{.add = TRUE}.

This argument was previously called \code{add}, but that prevented
creating a new grouping variable called \code{add}, and conflicts with
our naming conventions.}

\item{include, exclude}{Character vector of column names to always
include/exclude.}
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("deprecated")}

dplyr used to offer twin versions of each verb suffixed with an
underscore. These versions had standard evaluation (SE) semantics:
rather than taking arguments by code, like NSE verbs, they took
arguments by value. Their purpose was to make it possible to
program with dplyr. However, dplyr now uses tidy evaluation
semantics. NSE verbs still capture their arguments, but you can now
unquote parts of these arguments. This offers full programmability
with NSE verbs. Thus, the underscored versions are now superfluous.

Unquoting triggers immediate evaluation of its operand and inlines
the result within the captured expression. This result can be a
value or an expression to be evaluated later with the rest of the
argument. See \code{vignette("programming")} for more information.
}
\keyword{internal}
