% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyze.R
\name{TCGAbatch_Correction}
\alias{TCGAbatch_Correction}
\title{Batch correction using ComBat and Voom transformation using limma package.}
\usage{
TCGAbatch_Correction(
  tabDF,
  batch.factor = NULL,
  adjustment = NULL,
  ClinicalDF = data.frame(),
  UnpublishedData = FALSE,
  AnnotationDF = data.frame()
)
}
\arguments{
\item{tabDF}{numeric matrix, each row represents a gene,
each column represents a sample}

\item{batch.factor}{a string containing the batch factor to use for correction. Options are "Plate", "TSS", "Year", "Portion", "Center"}

\item{adjustment}{vector containing strings for factors to adjust for using ComBat. Options are "Plate", "TSS", "Year", "Portion", "Center"}

\item{ClinicalDF}{a dataframe returned by GDCquery_clinic() to be used to extract year data}

\item{UnpublishedData}{if TRUE perform a batch correction after adding new data}

\item{AnnotationDF}{a dataframe with column Batch indicating different batches of the samples in the tabDF}
}
\value{
data frame with ComBat batch correction applied
}
\description{
TCGAbatch_correction allows user to perform a Voom correction on gene expression data and have it ready for DEA.
   One can also use ComBat for batch correction for exploratory analysis. If batch.factor or adjustment argument is "Year"
 please provide clinical data. If no batch factor is provided, the data will be voom corrected only

    TCGAanalyze_DEA performs DEA using following functions from sva and limma:
    \enumerate{
    \item limma::voom Transform RNA-Seq Data Ready for Linear Modelling.
    \item sva::ComBat Adjust for batch effects using an empirical Bayes framework.
    }
}
