% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PamParam.R
\docType{class}
\name{PamParam-class}
\alias{PamParam-class}
\alias{show,PamParam-method}
\alias{.defaultScalarArguments,PamParam-method}
\alias{PamParam}
\alias{clusterRows,ANY,PamParam-method}
\title{Partitioning around medoids}
\usage{
PamParam(
  centers,
  metric = NULL,
  medoids = NULL,
  nstart = NULL,
  stand = NULL,
  do.swap = NULL,
  variant = NULL
)

\S4method{clusterRows}{ANY,PamParam}(x, BLUSPARAM, full = FALSE)
}
\arguments{
\item{centers}{An integer scalar specifying the number of centers.
Alternatively, a function that takes the number of observations and returns the number of centers.}

\item{metric, medoids, nstart, stand, do.swap, variant}{Further arguments to pass to \code{\link{pam}}.
Set to the function defaults if not supplied.}

\item{x}{A numeric matrix-like object where rows represent observations and columns represent variables.}

\item{BLUSPARAM}{A \linkS4class{PamParam} object.}

\item{full}{Logical scalar indicating whether the full PAM statistics should be returned.}
}
\value{
The \code{PamParam} constructor will return a \linkS4class{PamParam} object with the specified parameters.

The \code{clusterRows} method will return a factor of length equal to \code{nrow(x)} containing the cluster assignments.
If \code{full=TRUE}, a list is returned with \code{clusters} (the factor, as above) and \code{objects}
(a list containing \code{pam}, the direct output of \code{\link{pam}}).
}
\description{
Partition observations into k-medoids as a more robust version of k-means.
}
\details{
This class usually requires the user to specify the number of clusters beforehand.
However, we can also allow the number of clusters to vary as a function of the number of observations.
The latter is occasionally useful, e.g., to allow the clustering to automatically become more granular for large datasets.

To modify an existing PamParam object \code{x},
users can simply call \code{x[[i]]} or \code{x[[i]] <- value} where \code{i} is any argument used in the constructor.
}
\examples{
clusterRows(iris[,1:4], PamParam(centers=4))
clusterRows(iris[,1:4], PamParam(centers=4, variant="faster", do.swap=FALSE))
clusterRows(iris[,1:4], PamParam(centers=sqrt))
}
\seealso{
\code{\link{pam}}, which actually does all the heavy lifting.

\linkS4class{KmeansParam}, for the more commonly used k-means algorithm.

\linkS4class{ClaraParam}, for a scalable extension to the PAM approach.
}
\author{
Aaron Lun
}
