---
title: Training
layout: page
date: 2015-04-23 21:51
---

## Why should my company get Hypothesis training?

Hypothesis **makes your testing less labor-intensive and more thorough**. You'll find bugs you never even suspected were there in less time than your existing testing tools and methodology require.

You don't *need* training to use Hypothesis, if you're not using Hypothesis already, why not just try it out first?

Hypothesis has [extensive documentation](https://hypothesis.readthedocs.io/en/latest/), and a body of introductory articles are available [right here](/articles/intro/) to get you started. These resources and will help you and your team begin testing with Hypothesis in no time. Give it a spin!

Now that you *are* using Hypothesis, ask your team two questions:

1. Is Hypothesis useful?
2. Could we be getting more out of it?

The answers to both will be a resounding yes.

If you want to take your usage of Hypothesis to the next level and find
even more bugs with even less work, our training can help.

The exact nature of the workshop depends on your needs. To find out more about our offerings, read on!

## What do you need?

* [I need my team to get better at testing](#i-need-my-team-to-get-better-at-testing)
* [I need my product to be better tested](#i-need-my-product-to-be-better-tested)
* [I need something else](#i-need-something-else-or-something-more)

### I need my team to get better at testing

In that case you want our **structured** workshop.

* One day on-site workshop, up to 10 people.
* Video conferencing format for distributed remote teams available on request.
* Beginner friendly.
* We work through a series of examples illustrating key Hypothesis concepts.
* Attendees come away with a deeper understanding of how Hypothesis can improve their testing.

Drop us a line at [training@hypothesis.works](mailto:training@hypothesis.works) to find out more.

### I need my product to be better tested

In that case you want our **exploratory** workshop.

* One day on-site workshop, up to 10 people.
* Video conferencing format for distributed remote teams available on request.
* Some experience and familiarity with your software and Hypothesis expected.
* We work as a group to improve the test quality of your software using Hypothesis.
* Attendees come away with a better understanding of how Hypothesis fits into your specific testing needs and processes.
* You get better tested software as soon as the workshop is over!

Drop us a line at [training@hypothesis.works](mailto:training@hypothesis.works) to find out more.

### I need something else, or something more

If you're looking for a customized training experience (e.g. because you want a longer or shorter course, or are looking to dive deeper into a specific topic), we are able to create a customized training that fits your needs and format requirements.

Drop us a line at [training@hypothesis.works](mailto:training@hypothesis.works) and we can discuss the details.
