# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class BillingFrequency(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The frequency with which the cost gets billed."""

    MONTHLY = "monthly"


class OperatorNumberType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of service associated with the phone number."""

    UNKNOWN = "unknown"
    OTHER = "other"
    GEOGRAPHIC = "geographic"
    MOBILE = "mobile"


class PhoneNumberAssignmentType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Represents the assignment type of the offering."""

    PERSON = "person"
    APPLICATION = "application"


class PhoneNumberAvailabilityStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Represents the status of the phone number. Possible values include: 'available', 'reserved',
    'expired', 'error', 'purchased'.
    """

    AVAILABLE = "available"
    RESERVED = "reserved"
    EXPIRED = "expired"
    ERROR = "error"
    PURCHASED = "purchased"


class PhoneNumberCapabilityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Capability value for calling."""

    NONE = "none"
    INBOUND = "inbound"
    OUTBOUND = "outbound"
    INBOUND_OUTBOUND = "inbound+outbound"


class PhoneNumberOperationStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Status of operation."""

    NOT_STARTED = "notStarted"
    RUNNING = "running"
    SUCCEEDED = "succeeded"
    FAILED = "failed"


class PhoneNumberOperationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of operation, e.g. Search."""

    PURCHASE = "purchase"
    RELEASE_PHONE_NUMBER = "releasePhoneNumber"
    SEARCH = "search"
    UPDATE_PHONE_NUMBER_CAPABILITIES = "updatePhoneNumberCapabilities"
    RESERVATION_PURCHASE = "reservationPurchase"


class PhoneNumberSearchResultError(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Mapping Error Messages to Codes."""

    NO_ERROR = "NoError"
    UNKNOWN_ERROR_CODE = "UnknownErrorCode"
    OUT_OF_STOCK = "OutOfStock"
    AUTHORIZATION_DENIED = "AuthorizationDenied"
    MISSING_ADDRESS = "MissingAddress"
    INVALID_ADDRESS = "InvalidAddress"
    INVALID_OFFER_MODEL = "InvalidOfferModel"
    NOT_ENOUGH_LICENSES = "NotEnoughLicenses"
    NO_WALLET = "NoWallet"
    NOT_ENOUGH_CREDIT = "NotEnoughCredit"
    NUMBERS_PARTIALLY_ACQUIRED = "NumbersPartiallyAcquired"
    ALL_NUMBERS_NOT_ACQUIRED = "AllNumbersNotAcquired"
    RESERVATION_EXPIRED = "ReservationExpired"
    PURCHASE_FAILED = "PurchaseFailed"
    BILLING_UNAVAILABLE = "BillingUnavailable"
    PROVISIONING_FAILED = "ProvisioningFailed"
    UNKNOWN_SEARCH_ERROR = "UnknownSearchError"


class PhoneNumberType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Represents the number type of the offering."""

    GEOGRAPHIC = "geographic"
    TOLL_FREE = "tollFree"
    MOBILE = "mobile"


class ReservationStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Represents the status of the reservation. Possible values include: 'active', 'submitted',
    'completed', 'expired'.
    """

    ACTIVE = "active"
    SUBMITTED = "submitted"
    COMPLETED = "completed"
    EXPIRED = "expired"
