/* Python.h should always be first */
#include <Python.h>
#include <string.h>
#include "grdel.h"
#include "cferbind.h"
#include "cairoCFerBind.h"
#include "pyqtcairoCFerBind.h"

/*
 * Make the viewer visible.
 *
 * Returns one if successful.   If an error occurs, grdelerrmsg
 * is assigned an appropriate error message and zero is returned.
 */
grdelBool pyqtcairoCFerBind_showWindow(CFerBind *self, int visible)
{
    CairoCFerBindData *instdata;
    grdelBool success;

    /* Sanity check */
    if ( self->enginename != PyQtCairoCFerBindName ) {
        strcpy(grdelerrmsg, "pyqtcairoCFerBind_showWindow: unexpected error, "
                            "self is not a valid CFerBind struct");
        return 0;
    }
    instdata = (CairoCFerBindData *) self->instancedata;

    /* Tell the view to make itself visible */
    success = grdelWindowSetVisible(instdata->viewer, visible);
    if ( ! success ) {
        /* grdelerrmsg already assigned */
        return 0;
    }

    return 1;
}

