---
name: Question
about: Ask a question about how to use pydantic
labels: question
---

### Checks

* [ ] I added a descriptive title to this issue
* [ ] I have searched (google, github) for similar issues and couldn't find anything
* [ ] I have read and followed [the docs](https://pydantic-docs.helpmanual.io/) and couldn't find an answer
* [ ] After submitting this, I commit to one of:
    * Look through open issues and helped at least one other person
    * Hit the "watch" button on this repo to receive notifications and I commit to help at least 2 people that ask questions in the future
    * Implement a Pull Request for a confirmed bug

<!-- Sorry to sound so draconian, but every second saved replying to issues is time spend improving pydantic :-) -->

# Question

Output of `python -c "import pydantic.utils; print(pydantic.utils.version_info())"`:
```
...
```
<!-- or if you're using pydantic prior to v1.3, manually include: OS, python version and pydantic version -->

<!-- Please read the [docs](https://pydantic-docs.helpmanual.io/) and search through issues to
confirm your question hasn't already been answered. -->

<!-- Where possible please include a self-contained code snippet describing your question: -->

```py
import pydantic

...
```
