/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.mindmap;

import java.util.List;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOptional;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.mindmap.IdeaShape;
import net.sourceforge.plantuml.mindmap.MindMapDiagram;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.NoSuchColorException;

public class CommandMindMapOrgmodeMultiline
extends CommandMultilines2<MindMapDiagram> {
    public CommandMindMapOrgmodeMultiline() {
        super(CommandMindMapOrgmodeMultiline.getRegexConcat(), MultilinesStrategy.REMOVE_STARTING_QUOTE);
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandMindMapOrgmodeMultiline.class.getName(), RegexLeaf.start(), new RegexLeaf("TYPE", "([*]+)"), new RegexOptional((IRegex)new RegexLeaf("BACKCOLOR", "\\[(#\\w+)\\]")), new RegexLeaf("SHAPE", "(_)?"), new RegexLeaf(":"), new RegexLeaf("DATA", "(.*)"), RegexLeaf.end());
    }

    @Override
    public String getPatternEnd() {
        return "^(.*);(?:\\s*\\<\\<(.+)\\>\\>)?$";
    }

    @Override
    protected CommandExecutionResult executeNow(MindMapDiagram diagram, BlocLines lines) throws NoSuchColorException {
        RegexResult line0 = this.getStartingPattern().matcher(lines.getFirst().getTrimmed().getString());
        List<String> lineLast = StringUtils.getSplit(MyPattern.cmpile(this.getPatternEnd()), lines.getLast().getString());
        lines = lines.removeStartingAndEnding(line0.get("DATA", 0), 1);
        String stereotype = lineLast.get(1);
        if (stereotype != null) {
            lines = lines.overrideLastLine(lineLast.get(0));
        }
        String type = line0.get("TYPE", 0);
        String stringColor = line0.get("BACKCOLOR", 0);
        HColor backColor = null;
        if (stringColor != null) {
            backColor = diagram.getSkinParam().getIHtmlColorSet().getColor(diagram.getSkinParam().getThemeStyle(), stringColor);
        }
        if (stereotype == null) {
            return diagram.addIdea(backColor, type.length() - 1, lines.toDisplay(), IdeaShape.fromDesc(line0.get("SHAPE", 0)));
        }
        return diagram.addIdea(stereotype, backColor, type.length() - 1, lines.toDisplay(), IdeaShape.fromDesc(line0.get("SHAPE", 0)));
    }
}

