/* ===========================================================
 * Orson Charts : a 3D chart library for the Java(tm) platform
 * ===========================================================
 * 
 * (C)opyright 2013-2022, by David Gilbert.  All rights reserved.
 * 
 * https://github.com/jfree/orson-charts
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * [Oracle and Java are registered trademarks of Oracle and/or its affiliates. 
 * Other names may be trademarks of their respective owners.]
 * 
 * If you do not wish to be bound by the terms of the GPL, an alternative
 * commercial license can be purchased.  For details, please see visit the
 * Orson Charts home page:
 * 
 * http://www.object-refinery.com/orsoncharts/index.html
 * 
 */

package org.jfree.chart3d.marker;

import java.util.EventObject;

import org.jfree.chart3d.internal.Args;

/**
 * An event associated with a change to a {@link Marker}.  These change 
 * events will be generated by an marker and broadcast to the axis that owns the
 * marker (in the standard setup, the axis will then trigger its own change e
 * vent to notify the plot that a subcomponent of the axis has changed). 
 * <br><br>
 * NOTE: This class is serializable, but the serialization format is subject 
 * to change in future releases and should not be relied upon for persisting 
 * instances of this class. 
 * 
 * @since 1.2
 */
@SuppressWarnings("serial")
public class MarkerChangeEvent extends EventObject {
  
    /** The marker associated with this event. */
    private Marker marker;
    
    /**
     * Creates a new event.
     * 
     * @param marker  the marker ({@code null} not permitted).
     */
    public MarkerChangeEvent(Marker marker) {
        this(marker, marker);
    }
    
    /**
     * Creates a new event.
     * 
     * @param source  the event source.
     * @param marker  the marker ({@code null} not permitted).
     */
    public MarkerChangeEvent(Object source, Marker marker) {
        super(source);
        Args.nullNotPermitted(marker, "marker");
        this.marker = marker;
    }
  
    /**
     * Returns the marker associated with this event.
     * 
     * @return The marker (never {@code null}). 
     */
    public Marker getMarker() {
        return this.marker;
    }

}
