Minutes from 115th OpenVDB TSC meeting, December 7th, 2021, (EDT)

Attendees: *Ken* M., *Jeff* L., *Andre* P, *Nick* A., *Rich* J.

Additional Attendees: JT Nelson (Blender), Greg Hurst (United Therapeutics),
Kyle Wardlow (United Therapeutics), Johannes Meng (Intel), Bruce Cherniak (Intel)

Regrets: *Dan* B

Agenda:

1) Confirm quorum
2) Secretary
3) Forum
4) Google Summer of Code
5) Merging Point Data Grid
6) Release of VDB 8.2
7) VDB Occlusion Mask Outputs Float Grid
8) 2D Grid
9) Eval Min Max PR
10) Next Meeting

1) Confirm quorum

Quorum is present.

2) Secretary

Secretary is Andre Pradhana.

3) Forum

(a) Github Issue 1272

This is an issue with a user trying to build VDB 9 with symbols visibility
being hidden. Nick thinks that it is a minor fix, i.e. by prefixing the methods
built into the library with the correct visibility. This can be fixed by
turning off explicit template instantiation, which Dan has already commented.

We agree to do a patch release to fix issues regarding symbols visibility and
to add a CI to test this.

(b) Question about setting voxel size

Ken will respond to somebody asking how do you set the voxel size and the
narrowband-width when you construct VDBs, which involves a discussion on
transform.

4) Google Summer of Code

In the TAC meeting, there was a discussion about Google Summer of Code. We
would like to come up with potential projects. We want small,
well-defined projects that can be picked up by an intern.
A few ideas: (a) python bindings for the core library, (b) refactoring the
unit-tests and adding tests to untested functions, (c) using AVX and
SSE to optimize the library (perhaps using Agner Fog's VCL library:
https://www.agner.org/optimize/#vectorclass),
and (d) improve VDB's logging infrastructure, e.g. by using spdlog
(https://github.com/davidwed/tracy) or tracy
(https://github.com/davidwed/tracy).

We will start an email thread discussing projects for Google
Summer of Code 2022.

5) Merging Point Data Grid

Somebody in the forum asks about merging point data grid, i.e. having
attributes endpoints appended from a source group to a target group.
This is useful in simulation, e.g. emitting and merging points in
a simulation. Nick was working on a tool like this a few years ago,
which was working well. Nick mentions that Dan was working on a
solution which will be done soon.

Nick will mention this again when he is back.

Nick points out that API needs to be correct, but it can change.
He mentions the mentality that a code and a solution can be accepted
into the project with the possibility of them being deleted if
somebody comes up with a better solution.

6) Release of VDB 8.2

Andre mentions that OpenVDB 8.2 was successfully released. He has a PR
to merge v8.2.0_rc branch to v8.2.0 branch.

7) VDB Occlusion Mask Outputs Float Grid

Andre asks about the problem of trying to output a float grid from VDB
Occlusion mask SOP. The float grid represents a 2D distance to the
silhouette, which should happen in the frustum space. Each individual
slice represents a 2D distance based upon the trace of the intersection.

Jeff says that we can use VDB frustum to rasterize and generate the 2D
slices. You then cast extrapolate on each slice in parallel to get the
distance on those areas. More specifically: use for loop to extract
each slide along the z-axis and composite that to get the 3D grid.

Jeff mentions that doing so may get bleed between layers. He does not
know if it makes sense to sample the resulting 3D grid and to do
interpolation. The reason is that in each ray perpendicular to the
near/far plane of the frustum, the value should be constant. So
in a sense, they are not individual layers. It is as if the right
way to think about it is to query the deepest level of the layer.

8) 2D Grid

Ken brings the idea to do a 2D grid with associated 2D versions for the tools.

Several key points:

(a) Because the leaf nodes are dense, then mocking a 2D grid with a 3D grid will
be 8 times more costly.

(b) Jeff asks how does this tie into the tools, i.e. whether we should
templatized 2D and 3D.

(c) Ken says that almost all the VDB concepts will survive, but the
implementations are going to be different, which leads to a messy code-base.

(d) Nick points out calling free functions in VDB can get complicated when
trying to call it with an object. There is a need to design an API that makes
sense for clients.

(e) Another consideration is with the classes we support, e.g. Coord and BoundingBox
can either be 2D or 3D. The interface will be different, e.g. BoundingBox
can be BoundingBoundary.

(f) Applications: Greg and Kyle think that this would be useful. They mention post-process
plastic surgery in additive manufacturing where 2D processing can perform
better. Jeff mentions that this is useful when modeling road network: changing roads into
one meter wide roads is easy in 2D VDB, which is just trace (instead of working with curves).

We can decide to make a proposal of what this 2D data structure and tool may look like and
everyone can pitch in and make improvements or changes. The goal is this becomes a new
component of the library.

9) Eval Min Max PR

Greg gets the PR ready for merge. Nick reminds us that the goal of this PR
is to create a free function that supports a parallel evaluation.

Greg asks whether we want to keep eval min max for grid. Would it then call
the serial version and not the new tool?

Nick, Jeff, and Ken weigh in. In the long run, we want the tree class to be
lighter. In view of this, the conclusion is to deprecate eval min max in both
tree and grid. Greg is also to add a message saying that calling eval min max
expects a tree (i.e. you can call it with grid->tree()). He is also to add
pragma guard to prevent a duplicated deprecation message.

Greg asks whether the default value of eval min max for an empty grid are both
zero. Another option is to make min equals infinity and max equals -infinity.
Nick points out that the VDB types currently do not support limits. Nick
is fine with keeping the current convention provided that the function is
defined and we provide a comment regarding the behavior of an empty grid.

10) Next Meeting

Next meeting is January 11, 2022.
