/*      -*- linux-c -*-
 *
 * (C) Copyright IBM Corp. 2004
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  This
 * file and program are licensed under a BSD style license.  See
 * the Copying file included with the OpenHPI distribution for
 * full licensing terms.
 *
 * Author(s):
 *      Steve Sherman <stevees@us.ibm.com> 
 */

/******************************************************************* 
 * WARNING! This file is auto-magically generated by:
 *          ./SaHpi2code.pl. 
 *          Do not change this file manually. Update script instead
 *******************************************************************/

#include <stdio.h>
#include <string.h>

#include <SaHpi.h>
#include <oh_utils.h>

int main(int argc, char **argv) 
{
        char *expected_str;
        SaErrorT err;
        SaHpiEventStateT event_state, expected_state;
        SaHpiEventCategoryT event_cat, expected_cat;
        SaHpiTextBufferT buffer;

        #define BAD_EVENT 0xFFFF

        /* SAHPI_EC_UNSPECIFIED - SAHPI_ES_UNSPECIFIED testcase */
        {
                expected_cat = SAHPI_EC_UNSPECIFIED;
                expected_state = SAHPI_ES_UNSPECIFIED;
                expected_str = "UNSPECIFIED";
  
                err = oh_decode_eventstate(SAHPI_ES_UNSPECIFIED, SAHPI_EC_UNSPECIFIED, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !(expected_cat == event_cat)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_UNSPECIFIED - Bad event testcase */
        {
		if (oh_valid_eventstate(BAD_EVENT, SAHPI_EC_UNSPECIFIED, SAHPI_FALSE)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        return -1;
                }
	}

        /* SAHPI_EC_LIMIT - SAHPI_ES_LIMIT_NOT_EXCEEDED testcase */
        {
                expected_cat = SAHPI_EC_LIMIT;
                expected_state = SAHPI_ES_LIMIT_NOT_EXCEEDED;
                expected_str = "LIMIT_NOT_EXCEEDED";
  
                err = oh_decode_eventstate(SAHPI_ES_LIMIT_NOT_EXCEEDED, SAHPI_EC_LIMIT, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !(expected_cat == event_cat)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_LIMIT - SAHPI_ES_LIMIT_EXCEEDED testcase */
        {
                expected_cat = SAHPI_EC_LIMIT;
                expected_state = SAHPI_ES_LIMIT_EXCEEDED;
                expected_str = "LIMIT_EXCEEDED";
  
                err = oh_decode_eventstate(SAHPI_ES_LIMIT_EXCEEDED, SAHPI_EC_LIMIT, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !(expected_cat == event_cat)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_LIMIT - Bad event testcase */
        {
		if (oh_valid_eventstate(BAD_EVENT, SAHPI_EC_LIMIT, SAHPI_FALSE)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        return -1;
                }
	}

        /* SAHPI_EC_SENSOR_SPECIFIC - SAHPI_ES_STATE_00 testcase */
        {
                expected_cat = SAHPI_EC_SENSOR_SPECIFIC;
                expected_state = SAHPI_ES_STATE_00;
                expected_str = "STATE_00";
  
                err = oh_decode_eventstate(SAHPI_ES_STATE_00, SAHPI_EC_SENSOR_SPECIFIC, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !((SAHPI_EC_GENERIC == event_cat) || (SAHPI_EC_SENSOR_SPECIFIC == event_cat))) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_SENSOR_SPECIFIC - SAHPI_ES_STATE_01 testcase */
        {
                expected_cat = SAHPI_EC_SENSOR_SPECIFIC;
                expected_state = SAHPI_ES_STATE_01;
                expected_str = "STATE_01";
  
                err = oh_decode_eventstate(SAHPI_ES_STATE_01, SAHPI_EC_SENSOR_SPECIFIC, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !((SAHPI_EC_GENERIC == event_cat) || (SAHPI_EC_SENSOR_SPECIFIC == event_cat))) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_SENSOR_SPECIFIC - SAHPI_ES_STATE_02 testcase */
        {
                expected_cat = SAHPI_EC_SENSOR_SPECIFIC;
                expected_state = SAHPI_ES_STATE_02;
                expected_str = "STATE_02";
  
                err = oh_decode_eventstate(SAHPI_ES_STATE_02, SAHPI_EC_SENSOR_SPECIFIC, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !((SAHPI_EC_GENERIC == event_cat) || (SAHPI_EC_SENSOR_SPECIFIC == event_cat))) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_SENSOR_SPECIFIC - SAHPI_ES_STATE_03 testcase */
        {
                expected_cat = SAHPI_EC_SENSOR_SPECIFIC;
                expected_state = SAHPI_ES_STATE_03;
                expected_str = "STATE_03";
  
                err = oh_decode_eventstate(SAHPI_ES_STATE_03, SAHPI_EC_SENSOR_SPECIFIC, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !((SAHPI_EC_GENERIC == event_cat) || (SAHPI_EC_SENSOR_SPECIFIC == event_cat))) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_SENSOR_SPECIFIC - SAHPI_ES_STATE_04 testcase */
        {
                expected_cat = SAHPI_EC_SENSOR_SPECIFIC;
                expected_state = SAHPI_ES_STATE_04;
                expected_str = "STATE_04";
  
                err = oh_decode_eventstate(SAHPI_ES_STATE_04, SAHPI_EC_SENSOR_SPECIFIC, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !((SAHPI_EC_GENERIC == event_cat) || (SAHPI_EC_SENSOR_SPECIFIC == event_cat))) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_SENSOR_SPECIFIC - SAHPI_ES_STATE_05 testcase */
        {
                expected_cat = SAHPI_EC_SENSOR_SPECIFIC;
                expected_state = SAHPI_ES_STATE_05;
                expected_str = "STATE_05";
  
                err = oh_decode_eventstate(SAHPI_ES_STATE_05, SAHPI_EC_SENSOR_SPECIFIC, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !((SAHPI_EC_GENERIC == event_cat) || (SAHPI_EC_SENSOR_SPECIFIC == event_cat))) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_SENSOR_SPECIFIC - SAHPI_ES_STATE_06 testcase */
        {
                expected_cat = SAHPI_EC_SENSOR_SPECIFIC;
                expected_state = SAHPI_ES_STATE_06;
                expected_str = "STATE_06";
  
                err = oh_decode_eventstate(SAHPI_ES_STATE_06, SAHPI_EC_SENSOR_SPECIFIC, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !((SAHPI_EC_GENERIC == event_cat) || (SAHPI_EC_SENSOR_SPECIFIC == event_cat))) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_SENSOR_SPECIFIC - SAHPI_ES_STATE_07 testcase */
        {
                expected_cat = SAHPI_EC_SENSOR_SPECIFIC;
                expected_state = SAHPI_ES_STATE_07;
                expected_str = "STATE_07";
  
                err = oh_decode_eventstate(SAHPI_ES_STATE_07, SAHPI_EC_SENSOR_SPECIFIC, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !((SAHPI_EC_GENERIC == event_cat) || (SAHPI_EC_SENSOR_SPECIFIC == event_cat))) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_SENSOR_SPECIFIC - SAHPI_ES_STATE_08 testcase */
        {
                expected_cat = SAHPI_EC_SENSOR_SPECIFIC;
                expected_state = SAHPI_ES_STATE_08;
                expected_str = "STATE_08";
  
                err = oh_decode_eventstate(SAHPI_ES_STATE_08, SAHPI_EC_SENSOR_SPECIFIC, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !((SAHPI_EC_GENERIC == event_cat) || (SAHPI_EC_SENSOR_SPECIFIC == event_cat))) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_SENSOR_SPECIFIC - SAHPI_ES_STATE_09 testcase */
        {
                expected_cat = SAHPI_EC_SENSOR_SPECIFIC;
                expected_state = SAHPI_ES_STATE_09;
                expected_str = "STATE_09";
  
                err = oh_decode_eventstate(SAHPI_ES_STATE_09, SAHPI_EC_SENSOR_SPECIFIC, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !((SAHPI_EC_GENERIC == event_cat) || (SAHPI_EC_SENSOR_SPECIFIC == event_cat))) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_SENSOR_SPECIFIC - SAHPI_ES_STATE_10 testcase */
        {
                expected_cat = SAHPI_EC_SENSOR_SPECIFIC;
                expected_state = SAHPI_ES_STATE_10;
                expected_str = "STATE_10";
  
                err = oh_decode_eventstate(SAHPI_ES_STATE_10, SAHPI_EC_SENSOR_SPECIFIC, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !((SAHPI_EC_GENERIC == event_cat) || (SAHPI_EC_SENSOR_SPECIFIC == event_cat))) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_SENSOR_SPECIFIC - SAHPI_ES_STATE_11 testcase */
        {
                expected_cat = SAHPI_EC_SENSOR_SPECIFIC;
                expected_state = SAHPI_ES_STATE_11;
                expected_str = "STATE_11";
  
                err = oh_decode_eventstate(SAHPI_ES_STATE_11, SAHPI_EC_SENSOR_SPECIFIC, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !((SAHPI_EC_GENERIC == event_cat) || (SAHPI_EC_SENSOR_SPECIFIC == event_cat))) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_SENSOR_SPECIFIC - SAHPI_ES_STATE_12 testcase */
        {
                expected_cat = SAHPI_EC_SENSOR_SPECIFIC;
                expected_state = SAHPI_ES_STATE_12;
                expected_str = "STATE_12";
  
                err = oh_decode_eventstate(SAHPI_ES_STATE_12, SAHPI_EC_SENSOR_SPECIFIC, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !((SAHPI_EC_GENERIC == event_cat) || (SAHPI_EC_SENSOR_SPECIFIC == event_cat))) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_SENSOR_SPECIFIC - SAHPI_ES_STATE_13 testcase */
        {
                expected_cat = SAHPI_EC_SENSOR_SPECIFIC;
                expected_state = SAHPI_ES_STATE_13;
                expected_str = "STATE_13";
  
                err = oh_decode_eventstate(SAHPI_ES_STATE_13, SAHPI_EC_SENSOR_SPECIFIC, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !((SAHPI_EC_GENERIC == event_cat) || (SAHPI_EC_SENSOR_SPECIFIC == event_cat))) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_SENSOR_SPECIFIC - SAHPI_ES_STATE_14 testcase */
        {
                expected_cat = SAHPI_EC_SENSOR_SPECIFIC;
                expected_state = SAHPI_ES_STATE_14;
                expected_str = "STATE_14";
  
                err = oh_decode_eventstate(SAHPI_ES_STATE_14, SAHPI_EC_SENSOR_SPECIFIC, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !((SAHPI_EC_GENERIC == event_cat) || (SAHPI_EC_SENSOR_SPECIFIC == event_cat))) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_SENSOR_SPECIFIC - Bad event testcase */
        {
		if (oh_valid_eventstate(BAD_EVENT, SAHPI_EC_SENSOR_SPECIFIC, SAHPI_FALSE)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        return -1;
                }
	}

        /* SAHPI_EC_USAGE - SAHPI_ES_IDLE testcase */
        {
                expected_cat = SAHPI_EC_USAGE;
                expected_state = SAHPI_ES_IDLE;
                expected_str = "IDLE";
  
                err = oh_decode_eventstate(SAHPI_ES_IDLE, SAHPI_EC_USAGE, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !(expected_cat == event_cat)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_USAGE - SAHPI_ES_ACTIVE testcase */
        {
                expected_cat = SAHPI_EC_USAGE;
                expected_state = SAHPI_ES_ACTIVE;
                expected_str = "ACTIVE";
  
                err = oh_decode_eventstate(SAHPI_ES_ACTIVE, SAHPI_EC_USAGE, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !(expected_cat == event_cat)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_USAGE - SAHPI_ES_BUSY testcase */
        {
                expected_cat = SAHPI_EC_USAGE;
                expected_state = SAHPI_ES_BUSY;
                expected_str = "BUSY";
  
                err = oh_decode_eventstate(SAHPI_ES_BUSY, SAHPI_EC_USAGE, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !(expected_cat == event_cat)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_USAGE - Bad event testcase */
        {
		if (oh_valid_eventstate(BAD_EVENT, SAHPI_EC_USAGE, SAHPI_FALSE)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        return -1;
                }
	}

        /* SAHPI_EC_PRED_FAIL - SAHPI_ES_PRED_FAILURE_DEASSERT testcase */
        {
                expected_cat = SAHPI_EC_PRED_FAIL;
                expected_state = SAHPI_ES_PRED_FAILURE_DEASSERT;
                expected_str = "PRED_FAILURE_DEASSERT";
  
                err = oh_decode_eventstate(SAHPI_ES_PRED_FAILURE_DEASSERT, SAHPI_EC_PRED_FAIL, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !(expected_cat == event_cat)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_PRED_FAIL - SAHPI_ES_PRED_FAILURE_ASSERT testcase */
        {
                expected_cat = SAHPI_EC_PRED_FAIL;
                expected_state = SAHPI_ES_PRED_FAILURE_ASSERT;
                expected_str = "PRED_FAILURE_ASSERT";
  
                err = oh_decode_eventstate(SAHPI_ES_PRED_FAILURE_ASSERT, SAHPI_EC_PRED_FAIL, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !(expected_cat == event_cat)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_PRED_FAIL - Bad event testcase */
        {
		if (oh_valid_eventstate(BAD_EVENT, SAHPI_EC_PRED_FAIL, SAHPI_FALSE)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        return -1;
                }
	}

        /* SAHPI_EC_THRESHOLD - SAHPI_ES_LOWER_MINOR testcase */
        {
                expected_cat = SAHPI_EC_THRESHOLD;
                expected_state = SAHPI_ES_LOWER_MINOR;
                expected_str = "LOWER_MINOR";
  
                err = oh_decode_eventstate(SAHPI_ES_LOWER_MINOR, SAHPI_EC_THRESHOLD, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !(expected_cat == event_cat)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_THRESHOLD - SAHPI_ES_LOWER_MINOR | SAHPI_ES_LOWER_MAJOR testcase */
        {
                expected_cat = SAHPI_EC_THRESHOLD;
                expected_state = SAHPI_ES_LOWER_MINOR | SAHPI_ES_LOWER_MAJOR;
                expected_str = "LOWER_MINOR | LOWER_MAJOR";
  
                err = oh_decode_eventstate(SAHPI_ES_LOWER_MINOR | SAHPI_ES_LOWER_MAJOR, SAHPI_EC_THRESHOLD, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !(expected_cat == event_cat)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_THRESHOLD - SAHPI_ES_LOWER_MINOR | SAHPI_ES_LOWER_MAJOR | SAHPI_ES_LOWER_CRIT testcase */
        {
                expected_cat = SAHPI_EC_THRESHOLD;
                expected_state = SAHPI_ES_LOWER_MINOR | SAHPI_ES_LOWER_MAJOR | SAHPI_ES_LOWER_CRIT;
                expected_str = "LOWER_MINOR | LOWER_MAJOR | LOWER_CRIT";
  
                err = oh_decode_eventstate(SAHPI_ES_LOWER_MINOR | SAHPI_ES_LOWER_MAJOR | SAHPI_ES_LOWER_CRIT, SAHPI_EC_THRESHOLD, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !(expected_cat == event_cat)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_THRESHOLD - SAHPI_ES_UPPER_MINOR testcase */
        {
                expected_cat = SAHPI_EC_THRESHOLD;
                expected_state = SAHPI_ES_UPPER_MINOR;
                expected_str = "UPPER_MINOR";
  
                err = oh_decode_eventstate(SAHPI_ES_UPPER_MINOR, SAHPI_EC_THRESHOLD, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !(expected_cat == event_cat)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_THRESHOLD - SAHPI_ES_UPPER_MINOR | SAHPI_ES_UPPER_MAJOR testcase */
        {
                expected_cat = SAHPI_EC_THRESHOLD;
                expected_state = SAHPI_ES_UPPER_MINOR | SAHPI_ES_UPPER_MAJOR;
                expected_str = "UPPER_MINOR | UPPER_MAJOR";
  
                err = oh_decode_eventstate(SAHPI_ES_UPPER_MINOR | SAHPI_ES_UPPER_MAJOR, SAHPI_EC_THRESHOLD, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !(expected_cat == event_cat)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_THRESHOLD - SAHPI_ES_UPPER_MINOR | SAHPI_ES_UPPER_MAJOR | SAHPI_ES_UPPER_CRIT testcase */
        {
                expected_cat = SAHPI_EC_THRESHOLD;
                expected_state = SAHPI_ES_UPPER_MINOR | SAHPI_ES_UPPER_MAJOR | SAHPI_ES_UPPER_CRIT;
                expected_str = "UPPER_MINOR | UPPER_MAJOR | UPPER_CRIT";
  
                err = oh_decode_eventstate(SAHPI_ES_UPPER_MINOR | SAHPI_ES_UPPER_MAJOR | SAHPI_ES_UPPER_CRIT, SAHPI_EC_THRESHOLD, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !(expected_cat == event_cat)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_THRESHOLD - Bad event testcase */
        {
		if (oh_valid_eventstate(BAD_EVENT, SAHPI_EC_THRESHOLD, SAHPI_FALSE)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        return -1;
                }
	}

        /* SAHPI_EC_ENABLE - SAHPI_ES_DISABLED testcase */
        {
                expected_cat = SAHPI_EC_ENABLE;
                expected_state = SAHPI_ES_DISABLED;
                expected_str = "DISABLED";
  
                err = oh_decode_eventstate(SAHPI_ES_DISABLED, SAHPI_EC_ENABLE, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !(expected_cat == event_cat)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_ENABLE - SAHPI_ES_ENABLED testcase */
        {
                expected_cat = SAHPI_EC_ENABLE;
                expected_state = SAHPI_ES_ENABLED;
                expected_str = "ENABLED";
  
                err = oh_decode_eventstate(SAHPI_ES_ENABLED, SAHPI_EC_ENABLE, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !(expected_cat == event_cat)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_ENABLE - Bad event testcase */
        {
		if (oh_valid_eventstate(BAD_EVENT, SAHPI_EC_ENABLE, SAHPI_FALSE)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        return -1;
                }
	}

        /* SAHPI_EC_PRESENCE - SAHPI_ES_ABSENT testcase */
        {
                expected_cat = SAHPI_EC_PRESENCE;
                expected_state = SAHPI_ES_ABSENT;
                expected_str = "ABSENT";
  
                err = oh_decode_eventstate(SAHPI_ES_ABSENT, SAHPI_EC_PRESENCE, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !(expected_cat == event_cat)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_PRESENCE - SAHPI_ES_PRESENT testcase */
        {
                expected_cat = SAHPI_EC_PRESENCE;
                expected_state = SAHPI_ES_PRESENT;
                expected_str = "PRESENT";
  
                err = oh_decode_eventstate(SAHPI_ES_PRESENT, SAHPI_EC_PRESENCE, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !(expected_cat == event_cat)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_PRESENCE - Bad event testcase */
        {
		if (oh_valid_eventstate(BAD_EVENT, SAHPI_EC_PRESENCE, SAHPI_FALSE)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        return -1;
                }
	}

        /* SAHPI_EC_SEVERITY - SAHPI_ES_OK testcase */
        {
                expected_cat = SAHPI_EC_SEVERITY;
                expected_state = SAHPI_ES_OK;
                expected_str = "OK";
  
                err = oh_decode_eventstate(SAHPI_ES_OK, SAHPI_EC_SEVERITY, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !(expected_cat == event_cat)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_SEVERITY - SAHPI_ES_MINOR_FROM_OK testcase */
        {
                expected_cat = SAHPI_EC_SEVERITY;
                expected_state = SAHPI_ES_MINOR_FROM_OK;
                expected_str = "MINOR_FROM_OK";
  
                err = oh_decode_eventstate(SAHPI_ES_MINOR_FROM_OK, SAHPI_EC_SEVERITY, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !(expected_cat == event_cat)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_SEVERITY - SAHPI_ES_MAJOR_FROM_LESS testcase */
        {
                expected_cat = SAHPI_EC_SEVERITY;
                expected_state = SAHPI_ES_MAJOR_FROM_LESS;
                expected_str = "MAJOR_FROM_LESS";
  
                err = oh_decode_eventstate(SAHPI_ES_MAJOR_FROM_LESS, SAHPI_EC_SEVERITY, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !(expected_cat == event_cat)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_SEVERITY - SAHPI_ES_CRITICAL_FROM_LESS testcase */
        {
                expected_cat = SAHPI_EC_SEVERITY;
                expected_state = SAHPI_ES_CRITICAL_FROM_LESS;
                expected_str = "CRITICAL_FROM_LESS";
  
                err = oh_decode_eventstate(SAHPI_ES_CRITICAL_FROM_LESS, SAHPI_EC_SEVERITY, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !(expected_cat == event_cat)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_SEVERITY - SAHPI_ES_MINOR_FROM_MORE testcase */
        {
                expected_cat = SAHPI_EC_SEVERITY;
                expected_state = SAHPI_ES_MINOR_FROM_MORE;
                expected_str = "MINOR_FROM_MORE";
  
                err = oh_decode_eventstate(SAHPI_ES_MINOR_FROM_MORE, SAHPI_EC_SEVERITY, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !(expected_cat == event_cat)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_SEVERITY - SAHPI_ES_MAJOR_FROM_CRITICAL testcase */
        {
                expected_cat = SAHPI_EC_SEVERITY;
                expected_state = SAHPI_ES_MAJOR_FROM_CRITICAL;
                expected_str = "MAJOR_FROM_CRITICAL";
  
                err = oh_decode_eventstate(SAHPI_ES_MAJOR_FROM_CRITICAL, SAHPI_EC_SEVERITY, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !(expected_cat == event_cat)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_SEVERITY - SAHPI_ES_CRITICAL testcase */
        {
                expected_cat = SAHPI_EC_SEVERITY;
                expected_state = SAHPI_ES_CRITICAL;
                expected_str = "CRITICAL";
  
                err = oh_decode_eventstate(SAHPI_ES_CRITICAL, SAHPI_EC_SEVERITY, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !(expected_cat == event_cat)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_SEVERITY - SAHPI_ES_MONITOR testcase */
        {
                expected_cat = SAHPI_EC_SEVERITY;
                expected_state = SAHPI_ES_MONITOR;
                expected_str = "MONITOR";
  
                err = oh_decode_eventstate(SAHPI_ES_MONITOR, SAHPI_EC_SEVERITY, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !(expected_cat == event_cat)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_SEVERITY - SAHPI_ES_INFORMATIONAL testcase */
        {
                expected_cat = SAHPI_EC_SEVERITY;
                expected_state = SAHPI_ES_INFORMATIONAL;
                expected_str = "INFORMATIONAL";
  
                err = oh_decode_eventstate(SAHPI_ES_INFORMATIONAL, SAHPI_EC_SEVERITY, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !(expected_cat == event_cat)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_SEVERITY - Bad event testcase */
        {
		if (oh_valid_eventstate(BAD_EVENT, SAHPI_EC_SEVERITY, SAHPI_FALSE)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        return -1;
                }
	}

        /* SAHPI_EC_PERFORMANCE - SAHPI_ES_PERFORMANCE_MET testcase */
        {
                expected_cat = SAHPI_EC_PERFORMANCE;
                expected_state = SAHPI_ES_PERFORMANCE_MET;
                expected_str = "PERFORMANCE_MET";
  
                err = oh_decode_eventstate(SAHPI_ES_PERFORMANCE_MET, SAHPI_EC_PERFORMANCE, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !(expected_cat == event_cat)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_PERFORMANCE - SAHPI_ES_PERFORMANCE_LAGS testcase */
        {
                expected_cat = SAHPI_EC_PERFORMANCE;
                expected_state = SAHPI_ES_PERFORMANCE_LAGS;
                expected_str = "PERFORMANCE_LAGS";
  
                err = oh_decode_eventstate(SAHPI_ES_PERFORMANCE_LAGS, SAHPI_EC_PERFORMANCE, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !(expected_cat == event_cat)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_PERFORMANCE - Bad event testcase */
        {
		if (oh_valid_eventstate(BAD_EVENT, SAHPI_EC_PERFORMANCE, SAHPI_FALSE)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        return -1;
                }
	}

        /* SAHPI_EC_STATE - SAHPI_ES_STATE_DEASSERTED testcase */
        {
                expected_cat = SAHPI_EC_STATE;
                expected_state = SAHPI_ES_STATE_DEASSERTED;
                expected_str = "STATE_DEASSERTED";
  
                err = oh_decode_eventstate(SAHPI_ES_STATE_DEASSERTED, SAHPI_EC_STATE, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !(expected_cat == event_cat)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_STATE - SAHPI_ES_STATE_ASSERTED testcase */
        {
                expected_cat = SAHPI_EC_STATE;
                expected_state = SAHPI_ES_STATE_ASSERTED;
                expected_str = "STATE_ASSERTED";
  
                err = oh_decode_eventstate(SAHPI_ES_STATE_ASSERTED, SAHPI_EC_STATE, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !(expected_cat == event_cat)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_STATE - Bad event testcase */
        {
		if (oh_valid_eventstate(BAD_EVENT, SAHPI_EC_STATE, SAHPI_FALSE)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        return -1;
                }
	}

        /* SAHPI_EC_AVAILABILITY - SAHPI_ES_RUNNING testcase */
        {
                expected_cat = SAHPI_EC_AVAILABILITY;
                expected_state = SAHPI_ES_RUNNING;
                expected_str = "RUNNING";
  
                err = oh_decode_eventstate(SAHPI_ES_RUNNING, SAHPI_EC_AVAILABILITY, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !(expected_cat == event_cat)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_AVAILABILITY - SAHPI_ES_TEST testcase */
        {
                expected_cat = SAHPI_EC_AVAILABILITY;
                expected_state = SAHPI_ES_TEST;
                expected_str = "TEST";
  
                err = oh_decode_eventstate(SAHPI_ES_TEST, SAHPI_EC_AVAILABILITY, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !(expected_cat == event_cat)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_AVAILABILITY - SAHPI_ES_POWER_OFF testcase */
        {
                expected_cat = SAHPI_EC_AVAILABILITY;
                expected_state = SAHPI_ES_POWER_OFF;
                expected_str = "POWER_OFF";
  
                err = oh_decode_eventstate(SAHPI_ES_POWER_OFF, SAHPI_EC_AVAILABILITY, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !(expected_cat == event_cat)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_AVAILABILITY - SAHPI_ES_ON_LINE testcase */
        {
                expected_cat = SAHPI_EC_AVAILABILITY;
                expected_state = SAHPI_ES_ON_LINE;
                expected_str = "ON_LINE";
  
                err = oh_decode_eventstate(SAHPI_ES_ON_LINE, SAHPI_EC_AVAILABILITY, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !(expected_cat == event_cat)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_AVAILABILITY - SAHPI_ES_OFF_LINE testcase */
        {
                expected_cat = SAHPI_EC_AVAILABILITY;
                expected_state = SAHPI_ES_OFF_LINE;
                expected_str = "OFF_LINE";
  
                err = oh_decode_eventstate(SAHPI_ES_OFF_LINE, SAHPI_EC_AVAILABILITY, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !(expected_cat == event_cat)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_AVAILABILITY - SAHPI_ES_OFF_DUTY testcase */
        {
                expected_cat = SAHPI_EC_AVAILABILITY;
                expected_state = SAHPI_ES_OFF_DUTY;
                expected_str = "OFF_DUTY";
  
                err = oh_decode_eventstate(SAHPI_ES_OFF_DUTY, SAHPI_EC_AVAILABILITY, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !(expected_cat == event_cat)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_AVAILABILITY - SAHPI_ES_DEGRADED testcase */
        {
                expected_cat = SAHPI_EC_AVAILABILITY;
                expected_state = SAHPI_ES_DEGRADED;
                expected_str = "DEGRADED";
  
                err = oh_decode_eventstate(SAHPI_ES_DEGRADED, SAHPI_EC_AVAILABILITY, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !(expected_cat == event_cat)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_AVAILABILITY - SAHPI_ES_POWER_SAVE testcase */
        {
                expected_cat = SAHPI_EC_AVAILABILITY;
                expected_state = SAHPI_ES_POWER_SAVE;
                expected_str = "POWER_SAVE";
  
                err = oh_decode_eventstate(SAHPI_ES_POWER_SAVE, SAHPI_EC_AVAILABILITY, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !(expected_cat == event_cat)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_AVAILABILITY - SAHPI_ES_INSTALL_ERROR testcase */
        {
                expected_cat = SAHPI_EC_AVAILABILITY;
                expected_state = SAHPI_ES_INSTALL_ERROR;
                expected_str = "INSTALL_ERROR";
  
                err = oh_decode_eventstate(SAHPI_ES_INSTALL_ERROR, SAHPI_EC_AVAILABILITY, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !(expected_cat == event_cat)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_AVAILABILITY - Bad event testcase */
        {
		if (oh_valid_eventstate(BAD_EVENT, SAHPI_EC_AVAILABILITY, SAHPI_FALSE)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        return -1;
                }
	}

        /* SAHPI_EC_REDUNDANCY - SAHPI_ES_FULLY_REDUNDANT testcase */
        {
                expected_cat = SAHPI_EC_REDUNDANCY;
                expected_state = SAHPI_ES_FULLY_REDUNDANT;
                expected_str = "FULLY_REDUNDANT";
  
                err = oh_decode_eventstate(SAHPI_ES_FULLY_REDUNDANT, SAHPI_EC_REDUNDANCY, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !(expected_cat == event_cat)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_REDUNDANCY - SAHPI_ES_REDUNDANCY_LOST testcase */
        {
                expected_cat = SAHPI_EC_REDUNDANCY;
                expected_state = SAHPI_ES_REDUNDANCY_LOST;
                expected_str = "REDUNDANCY_LOST";
  
                err = oh_decode_eventstate(SAHPI_ES_REDUNDANCY_LOST, SAHPI_EC_REDUNDANCY, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !(expected_cat == event_cat)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_REDUNDANCY - SAHPI_ES_REDUNDANCY_DEGRADED testcase */
        {
                expected_cat = SAHPI_EC_REDUNDANCY;
                expected_state = SAHPI_ES_REDUNDANCY_DEGRADED;
                expected_str = "REDUNDANCY_DEGRADED";
  
                err = oh_decode_eventstate(SAHPI_ES_REDUNDANCY_DEGRADED, SAHPI_EC_REDUNDANCY, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !(expected_cat == event_cat)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_REDUNDANCY - SAHPI_ES_REDUNDANCY_LOST_SUFFICIENT_RESOURCES testcase */
        {
                expected_cat = SAHPI_EC_REDUNDANCY;
                expected_state = SAHPI_ES_REDUNDANCY_LOST_SUFFICIENT_RESOURCES;
                expected_str = "REDUNDANCY_LOST_SUFFICIENT_RESOURCES";
  
                err = oh_decode_eventstate(SAHPI_ES_REDUNDANCY_LOST_SUFFICIENT_RESOURCES, SAHPI_EC_REDUNDANCY, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !(expected_cat == event_cat)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_REDUNDANCY - SAHPI_ES_NON_REDUNDANT_SUFFICIENT_RESOURCES testcase */
        {
                expected_cat = SAHPI_EC_REDUNDANCY;
                expected_state = SAHPI_ES_NON_REDUNDANT_SUFFICIENT_RESOURCES;
                expected_str = "NON_REDUNDANT_SUFFICIENT_RESOURCES";
  
                err = oh_decode_eventstate(SAHPI_ES_NON_REDUNDANT_SUFFICIENT_RESOURCES, SAHPI_EC_REDUNDANCY, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !(expected_cat == event_cat)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_REDUNDANCY - SAHPI_ES_NON_REDUNDANT_INSUFFICIENT_RESOURCES testcase */
        {
                expected_cat = SAHPI_EC_REDUNDANCY;
                expected_state = SAHPI_ES_NON_REDUNDANT_INSUFFICIENT_RESOURCES;
                expected_str = "NON_REDUNDANT_INSUFFICIENT_RESOURCES";
  
                err = oh_decode_eventstate(SAHPI_ES_NON_REDUNDANT_INSUFFICIENT_RESOURCES, SAHPI_EC_REDUNDANCY, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !(expected_cat == event_cat)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_REDUNDANCY - SAHPI_ES_REDUNDANCY_DEGRADED_FROM_FULL testcase */
        {
                expected_cat = SAHPI_EC_REDUNDANCY;
                expected_state = SAHPI_ES_REDUNDANCY_DEGRADED_FROM_FULL;
                expected_str = "REDUNDANCY_DEGRADED_FROM_FULL";
  
                err = oh_decode_eventstate(SAHPI_ES_REDUNDANCY_DEGRADED_FROM_FULL, SAHPI_EC_REDUNDANCY, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !(expected_cat == event_cat)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_REDUNDANCY - SAHPI_ES_REDUNDANCY_DEGRADED_FROM_NON testcase */
        {
                expected_cat = SAHPI_EC_REDUNDANCY;
                expected_state = SAHPI_ES_REDUNDANCY_DEGRADED_FROM_NON;
                expected_str = "REDUNDANCY_DEGRADED_FROM_NON";
  
                err = oh_decode_eventstate(SAHPI_ES_REDUNDANCY_DEGRADED_FROM_NON, SAHPI_EC_REDUNDANCY, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !(expected_cat == event_cat)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_REDUNDANCY - Bad event testcase */
        {
		if (oh_valid_eventstate(BAD_EVENT, SAHPI_EC_REDUNDANCY, SAHPI_FALSE)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        return -1;
                }
	}

        /* SAHPI_EC_GENERIC - SAHPI_ES_STATE_00 testcase */
        {
                expected_cat = SAHPI_EC_GENERIC;
                expected_state = SAHPI_ES_STATE_00;
                expected_str = "STATE_00";
  
                err = oh_decode_eventstate(SAHPI_ES_STATE_00, SAHPI_EC_GENERIC, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !((SAHPI_EC_GENERIC == event_cat) || (SAHPI_EC_SENSOR_SPECIFIC == event_cat))) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_GENERIC - SAHPI_ES_STATE_01 testcase */
        {
                expected_cat = SAHPI_EC_GENERIC;
                expected_state = SAHPI_ES_STATE_01;
                expected_str = "STATE_01";
  
                err = oh_decode_eventstate(SAHPI_ES_STATE_01, SAHPI_EC_GENERIC, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !((SAHPI_EC_GENERIC == event_cat) || (SAHPI_EC_SENSOR_SPECIFIC == event_cat))) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_GENERIC - SAHPI_ES_STATE_02 testcase */
        {
                expected_cat = SAHPI_EC_GENERIC;
                expected_state = SAHPI_ES_STATE_02;
                expected_str = "STATE_02";
  
                err = oh_decode_eventstate(SAHPI_ES_STATE_02, SAHPI_EC_GENERIC, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !((SAHPI_EC_GENERIC == event_cat) || (SAHPI_EC_SENSOR_SPECIFIC == event_cat))) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_GENERIC - SAHPI_ES_STATE_03 testcase */
        {
                expected_cat = SAHPI_EC_GENERIC;
                expected_state = SAHPI_ES_STATE_03;
                expected_str = "STATE_03";
  
                err = oh_decode_eventstate(SAHPI_ES_STATE_03, SAHPI_EC_GENERIC, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !((SAHPI_EC_GENERIC == event_cat) || (SAHPI_EC_SENSOR_SPECIFIC == event_cat))) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_GENERIC - SAHPI_ES_STATE_04 testcase */
        {
                expected_cat = SAHPI_EC_GENERIC;
                expected_state = SAHPI_ES_STATE_04;
                expected_str = "STATE_04";
  
                err = oh_decode_eventstate(SAHPI_ES_STATE_04, SAHPI_EC_GENERIC, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !((SAHPI_EC_GENERIC == event_cat) || (SAHPI_EC_SENSOR_SPECIFIC == event_cat))) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_GENERIC - SAHPI_ES_STATE_05 testcase */
        {
                expected_cat = SAHPI_EC_GENERIC;
                expected_state = SAHPI_ES_STATE_05;
                expected_str = "STATE_05";
  
                err = oh_decode_eventstate(SAHPI_ES_STATE_05, SAHPI_EC_GENERIC, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !((SAHPI_EC_GENERIC == event_cat) || (SAHPI_EC_SENSOR_SPECIFIC == event_cat))) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_GENERIC - SAHPI_ES_STATE_06 testcase */
        {
                expected_cat = SAHPI_EC_GENERIC;
                expected_state = SAHPI_ES_STATE_06;
                expected_str = "STATE_06";
  
                err = oh_decode_eventstate(SAHPI_ES_STATE_06, SAHPI_EC_GENERIC, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !((SAHPI_EC_GENERIC == event_cat) || (SAHPI_EC_SENSOR_SPECIFIC == event_cat))) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_GENERIC - SAHPI_ES_STATE_07 testcase */
        {
                expected_cat = SAHPI_EC_GENERIC;
                expected_state = SAHPI_ES_STATE_07;
                expected_str = "STATE_07";
  
                err = oh_decode_eventstate(SAHPI_ES_STATE_07, SAHPI_EC_GENERIC, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !((SAHPI_EC_GENERIC == event_cat) || (SAHPI_EC_SENSOR_SPECIFIC == event_cat))) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_GENERIC - SAHPI_ES_STATE_08 testcase */
        {
                expected_cat = SAHPI_EC_GENERIC;
                expected_state = SAHPI_ES_STATE_08;
                expected_str = "STATE_08";
  
                err = oh_decode_eventstate(SAHPI_ES_STATE_08, SAHPI_EC_GENERIC, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !((SAHPI_EC_GENERIC == event_cat) || (SAHPI_EC_SENSOR_SPECIFIC == event_cat))) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_GENERIC - SAHPI_ES_STATE_09 testcase */
        {
                expected_cat = SAHPI_EC_GENERIC;
                expected_state = SAHPI_ES_STATE_09;
                expected_str = "STATE_09";
  
                err = oh_decode_eventstate(SAHPI_ES_STATE_09, SAHPI_EC_GENERIC, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !((SAHPI_EC_GENERIC == event_cat) || (SAHPI_EC_SENSOR_SPECIFIC == event_cat))) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_GENERIC - SAHPI_ES_STATE_10 testcase */
        {
                expected_cat = SAHPI_EC_GENERIC;
                expected_state = SAHPI_ES_STATE_10;
                expected_str = "STATE_10";
  
                err = oh_decode_eventstate(SAHPI_ES_STATE_10, SAHPI_EC_GENERIC, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !((SAHPI_EC_GENERIC == event_cat) || (SAHPI_EC_SENSOR_SPECIFIC == event_cat))) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_GENERIC - SAHPI_ES_STATE_11 testcase */
        {
                expected_cat = SAHPI_EC_GENERIC;
                expected_state = SAHPI_ES_STATE_11;
                expected_str = "STATE_11";
  
                err = oh_decode_eventstate(SAHPI_ES_STATE_11, SAHPI_EC_GENERIC, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !((SAHPI_EC_GENERIC == event_cat) || (SAHPI_EC_SENSOR_SPECIFIC == event_cat))) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_GENERIC - SAHPI_ES_STATE_12 testcase */
        {
                expected_cat = SAHPI_EC_GENERIC;
                expected_state = SAHPI_ES_STATE_12;
                expected_str = "STATE_12";
  
                err = oh_decode_eventstate(SAHPI_ES_STATE_12, SAHPI_EC_GENERIC, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !((SAHPI_EC_GENERIC == event_cat) || (SAHPI_EC_SENSOR_SPECIFIC == event_cat))) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_GENERIC - SAHPI_ES_STATE_13 testcase */
        {
                expected_cat = SAHPI_EC_GENERIC;
                expected_state = SAHPI_ES_STATE_13;
                expected_str = "STATE_13";
  
                err = oh_decode_eventstate(SAHPI_ES_STATE_13, SAHPI_EC_GENERIC, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !((SAHPI_EC_GENERIC == event_cat) || (SAHPI_EC_SENSOR_SPECIFIC == event_cat))) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_GENERIC - SAHPI_ES_STATE_14 testcase */
        {
                expected_cat = SAHPI_EC_GENERIC;
                expected_state = SAHPI_ES_STATE_14;
                expected_str = "STATE_14";
  
                err = oh_decode_eventstate(SAHPI_ES_STATE_14, SAHPI_EC_GENERIC, &buffer);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1; 
                }
    
                if (strcmp(expected_str, (char *)buffer.Data)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received string=%s\n", buffer.Data);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }
    
                err = oh_encode_eventstate(&buffer, &event_state, &event_cat);
                if (err != SA_OK) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d\n", err);
                        return -1;
                }
    
                if ((expected_state != event_state) || !((SAHPI_EC_GENERIC == event_cat) || (SAHPI_EC_SENSOR_SPECIFIC == event_cat))) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received state=%x; Received cat=%x\n", 
			       event_state, event_cat);
                        return -1;
                }
        }
	    
        /* SAHPI_EC_GENERIC - Bad event testcase */
        {
		if (oh_valid_eventstate(BAD_EVENT, SAHPI_EC_GENERIC, SAHPI_FALSE)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        return -1;
                }
	}

        return 0;
}
