/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

var randn = require( '@stdlib/random/base/randn' );
var Float64Array = require( '@stdlib/array/float64' );
var plot = require( '@stdlib/plot/ctor' );
var lowess = require( './../lib' );

var x;
var y;
var i;

x = new Float64Array( 100 );
y = new Float64Array( x.length );
for ( i = 0; i < x.length; i++ ) {
	x[ i ] = i;
	y[ i ] = ( 0.5*i ) + ( 10.0*randn() );
}

var opts = {
	'delta': 0
};

var out = lowess( x, y, opts );
var h = plot( [ x, out.x ], [ y, out.y ] );

h.lineStyle = [ 'none', '-' ];
h.symbols = [ 'closed-circle', 'none' ];

h.view( 'stdout' );
