/*
* @license Apache-2.0
*
* Copyright (c) 2021 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

// TypeScript Version: 2.0

/* tslint:disable:max-line-length */
/* tslint:disable:max-file-line-count */

import MAX = require( './../../../uint8/max' );
import NUM_BYTES = require( './../../../uint8/num-bytes' );

/**
* Interface describing the `uint8` namespace.
*/
interface Namespace {
	/**
	* Maximum unsigned 8-bit integer.
	*
	* @example
	* var max = ns.MAX;
	* // returns 255
	*/
	MAX: typeof MAX;

	/**
	* Size (in bytes) of an 8-bit unsigned integer.
	*
	* @example
	* var bytes = ns.NUM_BYTES;
	* // returns 1
	*/
	NUM_BYTES: typeof NUM_BYTES;
}

/**
* 8-bit unsigned integer mathematical constants.
*/
declare var ns: Namespace;


// EXPORTS //

export = ns;
