/*
 * nodoka_style.h
 * This file is part of gtk-nodoka-engine
 *
 * Copyright (C) 2007, 2008 - Martin Sourada, Daniel Geiger
 *
 * gtk-nodoka-engine is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gtk-nodoka-engine is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gtk-nodoka-engine; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, 
 * Boston, MA  02110-1301  USA
 */ 

#include <gtk/gtkstyle.h>

#include "animation.h"
#include "nodoka_types.h"

typedef struct _NodokaStyle NodokaStyle;
typedef struct _NodokaStyleClass NodokaStyleClass;

G_GNUC_INTERNAL extern GType nodoka_type_style;

#define NODOKA_TYPE_STYLE              nodoka_type_style
#define NODOKA_STYLE(object)           (G_TYPE_CHECK_INSTANCE_CAST ((object), NODOKA_TYPE_STYLE, NodokaStyle))
#define NODOKA_STYLE_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST ((klass), NODOKA_TYPE_STYLE, NodokaStyleClass))
#define NODOKA_IS_STYLE(object)        (G_TYPE_CHECK_INSTANCE_TYPE ((object), NODOKA_TYPE_STYLE))
#define NODOKA_IS_STYLE_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE ((klass), NODOKA_TYPE_STYLE))
#define NODOKA_STYLE_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS ((obj), NODOKA_TYPE_STYLE, NodokaStyleClass))

struct _NodokaStyle
{
	GtkStyle parent_instance;

	NodokaColors colors;

	double hilight_ratio;

	guint8 roundness;
	guint8 progressbarstyle;
	guint8 menubarstyle;
	guint8 toolbarstyle;
	guint8 listviewheaderstyle;
	guint8 listviewstyle;
	guint8 scrollbarstyle;
	GdkColor scrollbar_color;
	gboolean has_scrollbar_color;
	gboolean animation;
	gboolean gradients;
	gboolean stripes;
	GdkColor bullet_color;
	gboolean focus_inner;
	gboolean focus_fill;
};

struct _NodokaStyleClass
{
	GtkStyleClass parent_class;
};

G_GNUC_INTERNAL void nodoka_style_register_type (GTypeModule * module);
