// Code generated by smithy-go-codegen DO NOT EDIT.

package resiliencehub

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/resiliencehub/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Indicates the list of resource drifts that were detected while running an
// assessment.
func (c *Client) ListAppAssessmentResourceDrifts(ctx context.Context, params *ListAppAssessmentResourceDriftsInput, optFns ...func(*Options)) (*ListAppAssessmentResourceDriftsOutput, error) {
	if params == nil {
		params = &ListAppAssessmentResourceDriftsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListAppAssessmentResourceDrifts", params, optFns, c.addOperationListAppAssessmentResourceDriftsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListAppAssessmentResourceDriftsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListAppAssessmentResourceDriftsInput struct {

	// Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:
	// partition :resiliencehub: region : account :app-assessment/ app-id . For more
	// information about ARNs, see [Amazon Resource Names (ARNs)]in the Amazon Web Services General Reference guide.
	//
	// [Amazon Resource Names (ARNs)]: https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html
	//
	// This member is required.
	AssessmentArn *string

	// Indicates the maximum number of drift results to include in the response. If
	// more results exist than the specified MaxResults value, a token is included in
	// the response so that the remaining results can be retrieved.
	MaxResults *int32

	// Null, or the token from a previous call to get the next set of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListAppAssessmentResourceDriftsOutput struct {

	// Indicates all the resource drifts detected for an assessed entity.
	//
	// This member is required.
	ResourceDrifts []types.ResourceDrift

	// Null, or the token from a previous call to get the next set of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListAppAssessmentResourceDriftsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListAppAssessmentResourceDrifts{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListAppAssessmentResourceDrifts{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListAppAssessmentResourceDrifts"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpListAppAssessmentResourceDriftsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListAppAssessmentResourceDrifts(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListAppAssessmentResourceDriftsPaginatorOptions is the paginator options for
// ListAppAssessmentResourceDrifts
type ListAppAssessmentResourceDriftsPaginatorOptions struct {
	// Indicates the maximum number of drift results to include in the response. If
	// more results exist than the specified MaxResults value, a token is included in
	// the response so that the remaining results can be retrieved.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListAppAssessmentResourceDriftsPaginator is a paginator for
// ListAppAssessmentResourceDrifts
type ListAppAssessmentResourceDriftsPaginator struct {
	options   ListAppAssessmentResourceDriftsPaginatorOptions
	client    ListAppAssessmentResourceDriftsAPIClient
	params    *ListAppAssessmentResourceDriftsInput
	nextToken *string
	firstPage bool
}

// NewListAppAssessmentResourceDriftsPaginator returns a new
// ListAppAssessmentResourceDriftsPaginator
func NewListAppAssessmentResourceDriftsPaginator(client ListAppAssessmentResourceDriftsAPIClient, params *ListAppAssessmentResourceDriftsInput, optFns ...func(*ListAppAssessmentResourceDriftsPaginatorOptions)) *ListAppAssessmentResourceDriftsPaginator {
	if params == nil {
		params = &ListAppAssessmentResourceDriftsInput{}
	}

	options := ListAppAssessmentResourceDriftsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListAppAssessmentResourceDriftsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListAppAssessmentResourceDriftsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListAppAssessmentResourceDrifts page.
func (p *ListAppAssessmentResourceDriftsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListAppAssessmentResourceDriftsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListAppAssessmentResourceDrifts(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListAppAssessmentResourceDriftsAPIClient is a client that implements the
// ListAppAssessmentResourceDrifts operation.
type ListAppAssessmentResourceDriftsAPIClient interface {
	ListAppAssessmentResourceDrifts(context.Context, *ListAppAssessmentResourceDriftsInput, ...func(*Options)) (*ListAppAssessmentResourceDriftsOutput, error)
}

var _ ListAppAssessmentResourceDriftsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListAppAssessmentResourceDrifts(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListAppAssessmentResourceDrifts",
	}
}
