// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package tests

import (
	"testing"

	forgejo_options "code.forgejo.org/f3/gof3/v3/forges/forgejo/options"
	"code.forgejo.org/f3/gof3/v3/kind"
	"code.forgejo.org/f3/gof3/v3/options"
	f3_tree "code.forgejo.org/f3/gof3/v3/tree/f3"
	tests_forge "code.forgejo.org/f3/gof3/v3/tree/tests/f3/forge"
)

type forgeTest struct {
	tests_forge.Base
}

func (o *forgeTest) NewOptions(t *testing.T) options.Interface {
	return newTestOptions(t, o.GetName())
}

func (o *forgeTest) GetNameExceptions() []string {
	if o.GetName() == forgejo_options.NameAliasGitea {
		return []string{tests_forge.ComplianceNameForkedPullRequest}
	}
	return nil
}

func (o *forgeTest) GetKindExceptions() []kind.Kind {
	exceptions := []kind.Kind{
		f3_tree.KindTopics,
	}
	if o.GetName() == forgejo_options.NameAliasGitea {
		exceptions = append(
			exceptions,
			f3_tree.KindReviewComments,
			f3_tree.KindIssues,
			f3_tree.KindComments,
			f3_tree.KindReactions,
		)
	}
	return exceptions
}

func (o *forgeTest) GetNonTestUsers() []string {
	return []string{
		GetFixtureUsername(),
	}
}

func newForgeTest(name string) tests_forge.Interface {
	t := &forgeTest{}
	t.SetName(name)
	return t
}
