/*
  Routines to set mouse cursors
  Copyright (C) 2003, 2011  John Darrington

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 3 of the License,  or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <config.h>
#include <math.h>
#include "cursors.h"

GdkCursor *cursor[n_CURSORS * 2];

#define ene_data_width 16
#define ene_data_height 16
#define ene_data_x_hot 15
#define ene_data_y_hot 4
static const unsigned char ene_data_bits[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xff, 0x10, 0x80,
  0x20, 0x40, 0x20, 0x20, 0x18, 0x10, 0x06, 0x08, 0xe1, 0x04, 0x9a, 0x02,
  0x84, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00
};

#define ese_data_width 16
#define ese_data_height 16
#define ese_data_x_hot 15
#define ese_data_y_hot 11
static const unsigned char ese_data_bits[] = {
  0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x84, 0x01, 0x9a, 0x02, 0xe1, 0x04,
  0x06, 0x08, 0x18, 0x10, 0x20, 0x20, 0x20, 0x40, 0x10, 0x80, 0xf8, 0xff,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

#define nne_data_width 16
#define nne_data_height 16
#define nne_data_x_hot 11
#define nne_data_y_hot 0
static const unsigned char nne_data_bits[] = {
  0x00, 0x0c, 0x00, 0x0a, 0x00, 0x09, 0x80, 0x08, 0x40, 0x08, 0x20, 0x08,
  0x10, 0x08, 0x08, 0x08, 0x3c, 0x08, 0x20, 0x08, 0x20, 0x0b, 0x90, 0x0c,
  0x90, 0x08, 0x48, 0x00, 0x50, 0x00, 0x20, 0x00
};

#define nnw_data_width 16
#define nnw_data_height 16
#define nnw_data_x_hot 4
#define nnw_data_y_hot 0
static const unsigned char nnw_data_bits[] = {
  0x30, 0x00, 0x50, 0x00, 0x90, 0x00, 0x10, 0x01, 0x10, 0x02, 0x10, 0x04,
  0x10, 0x08, 0x10, 0x10, 0x10, 0x3c, 0x10, 0x04, 0xd0, 0x04, 0x30, 0x09,
  0x10, 0x09, 0x00, 0x12, 0x00, 0x0a, 0x00, 0x04
};

#define sse_data_width 16
#define sse_data_height 16
#define sse_data_x_hot 11
#define sse_data_y_hot 15
static const unsigned char sse_data_bits[] = {
  0x20, 0x00, 0x70, 0x00, 0x58, 0x00, 0x90, 0x08, 0xb0, 0x0c, 0x20, 0x0b,
  0x20, 0x08, 0x1c, 0x08, 0x08, 0x08, 0x10, 0x08, 0x20, 0x08, 0x40, 0x08,
  0x80, 0x08, 0x00, 0x09, 0x00, 0x0a, 0x00, 0x0c
};

#define ssw_data_width 16
#define ssw_data_height 16
#define ssw_data_x_hot 4
#define ssw_data_y_hot 15
static const unsigned char ssw_data_bits[] = {
  0x00, 0x04, 0x00, 0x0e, 0x00, 0x1a, 0x10, 0x09, 0x30, 0x0d, 0xd0, 0x04,
  0x10, 0x06, 0x10, 0x3c, 0x10, 0x10, 0x10, 0x08, 0x10, 0x04, 0x10, 0x02,
  0x10, 0x01, 0x90, 0x00, 0x50, 0x00, 0x30, 0x00
};

#define wnw_data_width 16
#define wnw_data_height 16
#define wnw_data_x_hot 0
#define wnw_data_y_hot 4
static const unsigned char wnw_data_bits[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x1f, 0x01, 0x08,
  0x02, 0x04, 0x04, 0x04, 0x08, 0x18, 0x10, 0x60, 0x20, 0x87, 0x40, 0x59,
  0x80, 0x21, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00
};

#define wsw_data_width 16
#define wsw_data_height 16
#define wsw_data_x_hot 0
#define wsw_data_y_hot 11
static const unsigned char wsw_data_bits[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x80, 0x21, 0x40, 0x59, 0x20, 0x86,
  0x10, 0x60, 0x08, 0x18, 0x04, 0x04, 0x02, 0x04, 0x01, 0x08, 0xff, 0x1f,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

#define ene_mask_width 16
#define ene_mask_height 16
#define ene_mask_x_hot 15
#define ene_mask_y_hot 4
static const unsigned char ene_mask_bits[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xff, 0xf0, 0xff,
  0xe0, 0x7f, 0xe0, 0x3f, 0xf8, 0x1f, 0xfe, 0x0f, 0xff, 0x07, 0x9e, 0x03,
  0x84, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00
};

#define ese_mask_width 16
#define ese_mask_height 16
#define ese_mask_x_hot 15
#define ese_mask_y_hot 11
static const unsigned char ese_mask_bits[] = {
  0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x84, 0x01, 0x9e, 0x03, 0xff, 0x07,
  0xfe, 0x0f, 0xf8, 0x1f, 0xe0, 0x3f, 0xe0, 0x7f, 0xf0, 0xff, 0xf8, 0xff,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

#define nne_mask_width 16
#define nne_mask_height 16
#define nne_mask_x_hot 11
#define nne_mask_y_hot 0
static const unsigned char nne_mask_bits[] = {
  0x00, 0x0c, 0x00, 0x0e, 0x00, 0x0f, 0x80, 0x0f, 0xc0, 0x0f, 0xe0, 0x0f,
  0xf0, 0x0f, 0xf8, 0x0f, 0xfc, 0x0f, 0xe0, 0x0f, 0xe0, 0x0f, 0xf0, 0x0c,
  0xf0, 0x08, 0x78, 0x00, 0x70, 0x00, 0x20, 0x00
};

#define nnw_mask_width 16
#define nnw_mask_height 16
#define nnw_mask_x_hot 4
#define nnw_mask_y_hot 0
static const unsigned char nnw_mask_bits[] = {
  0x30, 0x00, 0x70, 0x00, 0xf0, 0x00, 0xf0, 0x01, 0xf0, 0x03, 0xf0, 0x07,
  0xf0, 0x0f, 0xf0, 0x1f, 0xf0, 0x3f, 0xf0, 0x07, 0xf0, 0x07, 0x30, 0x0f,
  0x10, 0x0f, 0x00, 0x1e, 0x00, 0x0e, 0x00, 0x04
};

#define sse_mask_width 16
#define sse_mask_height 16
#define sse_mask_x_hot 11
#define sse_mask_y_hot 15
static const unsigned char sse_mask_bits[] = {
  0x20, 0x00, 0x70, 0x00, 0x78, 0x00, 0xf0, 0x08, 0xf0, 0x0c, 0xe0, 0x0f,
  0xe0, 0x0f, 0xfc, 0x0f, 0xf8, 0x0f, 0xf0, 0x0f, 0xe0, 0x0f, 0xc0, 0x0f,
  0x80, 0x0f, 0x00, 0x0f, 0x00, 0x0e, 0x00, 0x0c
};

#define ssw_mask_width 16
#define ssw_mask_height 16
#define ssw_mask_x_hot 4
#define ssw_mask_y_hot 15
static const unsigned char ssw_mask_bits[] = {
  0x00, 0x04, 0x00, 0x0e, 0x00, 0x1e, 0x10, 0x0f, 0x30, 0x0f, 0xf0, 0x07,
  0xf0, 0x07, 0xf0, 0x3f, 0xf0, 0x1f, 0xf0, 0x0f, 0xf0, 0x07, 0xf0, 0x03,
  0xf0, 0x01, 0xf0, 0x00, 0x70, 0x00, 0x30, 0x00
};

#define wnw_mask_width 16
#define wnw_mask_height 16
#define wnw_mask_x_hot 0
#define wnw_mask_y_hot 4
static const unsigned char wnw_mask_bits[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x1f, 0xff, 0x0f,
  0xfe, 0x07, 0xfc, 0x07, 0xf8, 0x1f, 0xf0, 0x7f, 0xe0, 0xff, 0xc0, 0x79,
  0x80, 0x21, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00
};

#define wsw_mask_width 16
#define wsw_mask_height 16
#define wsw_mask_x_hot 0
#define wsw_mask_y_hot 11
static const unsigned char wsw_mask_bits[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x80, 0x21, 0xc0, 0x79, 0xe0, 0xff,
  0xf0, 0x7f, 0xf8, 0x1f, 0xfc, 0x07, 0xfe, 0x07, 0xff, 0x0f, 0xff, 0x1f,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};


#define s_data_width 16
#define s_data_height 16
#define s_data_x_hot 7
#define s_data_y_hot 15
static const unsigned char s_data_bits[] = {
  0xc0, 0x01, 0x40, 0x01, 0x40, 0x01, 0x42, 0x21, 0x46, 0x31, 0x5c, 0x1d,
  0x74, 0x13, 0x08, 0x08, 0x08, 0x08, 0x10, 0x04, 0x10, 0x04, 0x20, 0x02,
  0x20, 0x02, 0x40, 0x01, 0x40, 0x01, 0x80, 0x00
};


#define e_data_width 16
#define e_data_height 16
#define e_data_x_hot 15
#define e_data_y_hot 7
static const unsigned char e_data_bits[] = {
  0x00, 0x00, 0x18, 0x00, 0x70, 0x00, 0xa0, 0x01, 0x20, 0x06, 0x40, 0x18,
  0x7f, 0x60, 0x01, 0x80, 0x7f, 0x60, 0x40, 0x18, 0x60, 0x06, 0xa0, 0x01,
  0x70, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00
};

#define n_data_width 16
#define n_data_height 16
#define n_data_x_hot 8
#define n_data_y_hot 0
static const unsigned char n_data_bits[] = {
  0x00, 0x01, 0x80, 0x02, 0x80, 0x02, 0x40, 0x04, 0x40, 0x04, 0x20, 0x08,
  0x20, 0x08, 0x10, 0x10, 0x10, 0x10, 0xe8, 0x26, 0xb8, 0x3a, 0x8c, 0x62,
  0x84, 0x42, 0x80, 0x02, 0x80, 0x02, 0x80, 0x03
};

#define e_mask_width 16
#define e_mask_height 16
#define e_mask_x_hot 15
#define e_mask_y_hot 7
static const unsigned char e_mask_bits[] = {
  0x00, 0x00, 0x18, 0x00, 0x70, 0x00, 0xe0, 0x01, 0xe0, 0x07, 0xc0, 0x1f,
  0xff, 0x7f, 0xff, 0xff, 0xff, 0x7f, 0xc0, 0x1f, 0xe0, 0x07, 0xe0, 0x01,
  0x70, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00
};

#define n_mask_width 16
#define n_mask_height 16
#define n_mask_x_hot 8
#define n_mask_y_hot 0
static const unsigned char n_mask_bits[] = {
  0x00, 0x01, 0x80, 0x03, 0x80, 0x03, 0xc0, 0x07, 0xc0, 0x07, 0xe0, 0x0f,
  0xe0, 0x0f, 0xf0, 0x1f, 0xf0, 0x1f, 0xf8, 0x3f, 0xb8, 0x3b, 0x8c, 0x63,
  0x84, 0x43, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03
};

#define s_mask_width 16
#define s_mask_height 16
#define s_mask_x_hot 7
#define s_mask_y_hot 15
static const unsigned char s_mask_bits[] = {
  0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc2, 0x21, 0xc6, 0x31, 0xdc, 0x1d,
  0xfc, 0x1f, 0xf8, 0x0f, 0xf8, 0x0f, 0xf0, 0x07, 0xf0, 0x07, 0xe0, 0x03,
  0xe0, 0x03, 0xc0, 0x01, 0xc0, 0x01, 0x80, 0x00
};

#define ne_data_width 16
#define ne_data_height 16
#define ne_data_x_hot 15
#define ne_data_y_hot 0
static const unsigned char ne_data_bits[] = {
  0x00, 0xc0, 0x00, 0xb8, 0x00, 0x47, 0xe0, 0x40, 0x18, 0x40, 0x20, 0x20,
  0xc0, 0x20, 0x40, 0x20, 0x20, 0x12, 0x10, 0x13, 0x88, 0x14, 0x44, 0x08,
  0x22, 0x08, 0x14, 0x00, 0x08, 0x00, 0x00, 0x00
};

#define se_data_width 16
#define se_data_height 16
#define se_data_x_hot 15
#define se_data_y_hot 15
static const unsigned char se_data_bits[] = {
  0x00, 0x00, 0x08, 0x00, 0x14, 0x00, 0x22, 0x08, 0x44, 0x08, 0x88, 0x14,
  0x10, 0x13, 0x20, 0x12, 0x40, 0x20, 0xc0, 0x20, 0x20, 0x20, 0x18, 0x40,
  0xe0, 0x40, 0x00, 0x47, 0x00, 0xb8, 0x00, 0xc0
};

#define sw_data_width 16
#define sw_data_height 16
#define sw_data_x_hot 0
#define sw_data_y_hot 15
static const unsigned char sw_data_bits[] = {
  0x00, 0x00, 0x00, 0x10, 0x00, 0x28, 0x10, 0x44, 0x10, 0x22, 0x28, 0x11,
  0xc8, 0x08, 0x48, 0x04, 0x04, 0x02, 0x04, 0x03, 0x04, 0x04, 0x02, 0x18,
  0x02, 0x07, 0xe2, 0x00, 0x1d, 0x00, 0x03, 0x00
};

#define nw_data_x_hot 0
#define nw_data_y_hot 0

static const unsigned char nw_data_bits[] = {
  0x03, 0x00, 0x1d, 0x00, 0xe2, 0x00, 0x02, 0x07, 0x02, 0x18, 0x04, 0x04,
  0x04, 0x03, 0x04, 0x02, 0x48, 0x04, 0xc8, 0x08, 0x28, 0x11, 0x10, 0x22,
  0x10, 0x44, 0x00, 0x28, 0x00, 0x10, 0x00, 0x00
};

static const unsigned char nw_mask_bits[] = {
  0x03, 0x00, 0x1f, 0x00, 0xfe, 0x00, 0xfe, 0x07, 0xfe, 0x1f, 0xfc, 0x07,
  0xfc, 0x03, 0xfc, 0x03, 0xf8, 0x07, 0xf8, 0x0f, 0x38, 0x1f, 0x10, 0x3e,
  0x10, 0x7c, 0x00, 0x38, 0x00, 0x10, 0x00, 0x00
};

#define ne_mask_width 16
#define ne_mask_height 16
#define ne_mask_x_hot 15
#define ne_mask_y_hot 0
static const unsigned char ne_mask_bits[] = {
  0x00, 0xc0, 0x00, 0xf8, 0x00, 0x7f, 0xe0, 0x7f, 0xf8, 0x7f, 0xe0, 0x3f,
  0xc0, 0x3f, 0xc0, 0x3f, 0xe0, 0x1f, 0xf0, 0x1f, 0xf8, 0x1c, 0x7c, 0x08,
  0x3e, 0x08, 0x1c, 0x00, 0x08, 0x00, 0x00, 0x00
};

#define se_mask_width 16
#define se_mask_height 16
#define se_mask_x_hot 15
#define se_mask_y_hot 15
static const unsigned char se_mask_bits[] = {
  0x00, 0x00, 0x08, 0x00, 0x1c, 0x00, 0x3e, 0x08, 0x7c, 0x08, 0xf8, 0x1c,
  0xf0, 0x1f, 0xe0, 0x1f, 0xc0, 0x3f, 0xc0, 0x3f, 0xe0, 0x3f, 0xf8, 0x7f,
  0xe0, 0x7f, 0x00, 0x7f, 0x00, 0xf8, 0x00, 0xc0
};

#define sw_mask_width 16
#define sw_mask_height 16
#define sw_mask_x_hot 0
#define sw_mask_y_hot 15
static const unsigned char sw_mask_bits[] = {
  0x00, 0x00, 0x00, 0x10, 0x00, 0x38, 0x10, 0x7c, 0x10, 0x3e, 0x38, 0x1f,
  0xf8, 0x0f, 0xf8, 0x07, 0xfc, 0x03, 0xfc, 0x03, 0xfc, 0x07, 0xfe, 0x1f,
  0xfe, 0x07, 0xfe, 0x00, 0x1f, 0x00, 0x03, 0x00
};

#define w_data_width 16
#define w_data_height 16
#define w_data_x_hot 0
#define w_data_y_hot 7
static const unsigned char w_data_bits[] = {
  0x00, 0x00, 0x00, 0x18, 0x00, 0x0e, 0x80, 0x05, 0x60, 0x04, 0x18, 0x02,
  0x06, 0xfe, 0x01, 0x80, 0x06, 0xfe, 0x18, 0x02, 0x60, 0x06, 0x80, 0x05,
  0x00, 0x0e, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00
};

#define w_mask_width 16
#define w_mask_height 16
#define w_mask_x_hot 0
#define w_mask_y_hot 7
static const unsigned char w_mask_bits[] = {
  0x00, 0x00, 0x00, 0x18, 0x00, 0x0e, 0x80, 0x07, 0xe0, 0x07, 0xf8, 0x03,
  0xfe, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xf8, 0x03, 0xe0, 0x07, 0x80, 0x07,
  0x00, 0x0e, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00
};


/* The angle between successive cursor intervals. */
const float cursor_interval = 360.0 / (float) n_CURSORS;

static const unsigned char *cursors_data[n_CURSORS] = {
  s_data_bits,
  ssw_data_bits,
  sw_data_bits,
  wsw_data_bits,
  w_data_bits,
  wnw_data_bits,
  nw_data_bits,
  nnw_data_bits,
  n_data_bits,
  nne_data_bits,
  ne_data_bits,
  ene_data_bits,
  e_data_bits,
  ese_data_bits,
  se_data_bits,
  sse_data_bits,
};



static const unsigned char *cursors_masks[n_CURSORS] = {
  s_mask_bits,
  ssw_mask_bits,
  sw_mask_bits,
  wsw_mask_bits,
  w_mask_bits,
  wnw_mask_bits,
  nw_mask_bits,
  nnw_mask_bits,
  n_mask_bits,
  nne_mask_bits,
  ne_mask_bits,
  ene_mask_bits,
  e_mask_bits,
  ese_mask_bits,
  se_mask_bits,
  sse_mask_bits,
};


static const int cursors_hot_x[n_CURSORS] = {
  s_data_x_hot,
  ssw_data_x_hot,
  sw_data_x_hot,
  wsw_data_x_hot,
  w_data_x_hot,
  wnw_data_x_hot,
  nw_data_x_hot,
  nnw_data_x_hot,
  n_data_x_hot,
  nne_data_x_hot,
  ne_data_x_hot,
  ene_data_x_hot,
  e_data_x_hot,
  ese_data_x_hot,
  se_data_x_hot,
  sse_data_x_hot,
};

static const int cursors_hot_y[n_CURSORS] = {
  s_data_y_hot,
  ssw_data_y_hot,
  sw_data_y_hot,
  wsw_data_y_hot,
  w_data_y_hot,
  wnw_data_y_hot,
  nw_data_y_hot,
  nnw_data_y_hot,
  n_data_y_hot,
  nne_data_y_hot,
  ne_data_y_hot,
  ene_data_y_hot,
  e_data_y_hot,
  ese_data_y_hot,
  se_data_y_hot,
  sse_data_y_hot,
};

/* Get the cursor which matches the angle the closest */
void
get_cursor (int index, const unsigned char **data,
	    const unsigned char **mask, int *height, int *width, int *hot_x,
	    int *hot_y, gboolean reverse)
{
  *hot_y = cursors_hot_y[index];
  *hot_x = cursors_hot_x[index];

  if ( reverse )
    index = index + 8;

  index = index % n_CURSORS;

  *data = cursors_data[index];
  *mask = cursors_masks[index];

  *height = 16;
  *width = 16;

}
