// This file was generated by the Gtk# code generator.
// Any changes made will be lost if regenerated.

namespace Gtk {

	using System;
	using System.Collections;
	using System.Collections.Generic;
	using System.Runtime.InteropServices;

#region Autogenerated code
	public partial class Image : Gtk.Misc {

		public Image (IntPtr raw) : base(raw) {}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gtk_image_new();

		public Image () : base (IntPtr.Zero)
		{
			if (GetType () != typeof (Image)) {
				CreateNativeObject (new string [0], new GLib.Value[0]);
				return;
			}
			Raw = gtk_image_new();
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gtk_image_new_from_animation(IntPtr animation);

		public Image (Gdk.PixbufAnimation animation) : base (IntPtr.Zero)
		{
			if (GetType () != typeof (Image)) {
				var vals = new List<GLib.Value> ();
				var names = new List<string> ();
				if (animation != null) {
					names.Add ("pixbuf_animation");
					vals.Add (new GLib.Value (animation));
				}
				CreateNativeObject (names.ToArray (), vals.ToArray ());
				return;
			}
			Raw = gtk_image_new_from_animation(animation == null ? IntPtr.Zero : animation.Handle);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gtk_image_new_from_file(IntPtr filename);

		public Image (string filename) : base (IntPtr.Zero)
		{
			if (GetType () != typeof (Image)) {
				var vals = new List<GLib.Value> ();
				var names = new List<string> ();
				names.Add ("file");
				vals.Add (new GLib.Value (filename));
				CreateNativeObject (names.ToArray (), vals.ToArray ());
				return;
			}
			IntPtr native_filename = GLib.Marshaller.StringToPtrGStrdup (filename);
			Raw = gtk_image_new_from_file(native_filename);
			GLib.Marshaller.Free (native_filename);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gtk_image_new_from_gicon(IntPtr icon, int size);

		public Image (GLib.IIcon icon, Gtk.IconSize size) : base (IntPtr.Zero)
		{
			if (GetType () != typeof (Image)) {
				var vals = new List<GLib.Value> ();
				var names = new List<string> ();
				if (icon != null) {
					names.Add ("icon");
					vals.Add (new GLib.Value (icon));
				}
				CreateNativeObject (names.ToArray (), vals.ToArray ());
				return;
			}
			Raw = gtk_image_new_from_gicon(icon == null ? IntPtr.Zero : ((icon is GLib.Object) ? (icon as GLib.Object).Handle : (icon as GLib.IconAdapter).Handle), (int) size);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gtk_image_new_from_icon_name(IntPtr icon_name, int size);

		public static Image NewFromIconName(string icon_name, Gtk.IconSize size)
		{
			IntPtr native_icon_name = GLib.Marshaller.StringToPtrGStrdup (icon_name);
			Image result = new Image (gtk_image_new_from_icon_name(native_icon_name, (int) size));
			GLib.Marshaller.Free (native_icon_name);
			return result;
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gtk_image_new_from_pixbuf(IntPtr pixbuf);

		public Image (Gdk.Pixbuf pixbuf) : base (IntPtr.Zero)
		{
			if (GetType () != typeof (Image)) {
				var vals = new List<GLib.Value> ();
				var names = new List<string> ();
				if (pixbuf != null) {
					names.Add ("pixbuf");
					vals.Add (new GLib.Value (pixbuf));
				}
				CreateNativeObject (names.ToArray (), vals.ToArray ());
				return;
			}
			Raw = gtk_image_new_from_pixbuf(pixbuf == null ? IntPtr.Zero : pixbuf.Handle);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gtk_image_new_from_resource(IntPtr resource_path);

		public static Image NewFromResource(string resource_path)
		{
			IntPtr native_resource_path = GLib.Marshaller.StringToPtrGStrdup (resource_path);
			Image result = new Image (gtk_image_new_from_resource(native_resource_path));
			GLib.Marshaller.Free (native_resource_path);
			return result;
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gtk_image_new_from_surface(IntPtr surface);

		public Image (Cairo.Surface surface) : base (IntPtr.Zero)
		{
			if (GetType () != typeof (Image)) {
				var vals = new List<GLib.Value> ();
				var names = new List<string> ();
				CreateNativeObject (names.ToArray (), vals.ToArray ());
				return;
			}
			Raw = gtk_image_new_from_surface(surface.Handle);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gtk_image_get_pixbuf(IntPtr raw);

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_image_set_from_pixbuf(IntPtr raw, IntPtr pixbuf);

		[GLib.Property ("pixbuf")]
		public Gdk.Pixbuf Pixbuf {
			get  {
				IntPtr raw_ret = gtk_image_get_pixbuf(Handle);
				Gdk.Pixbuf ret = GLib.Object.GetObject(raw_ret) as Gdk.Pixbuf;
				return ret;
			}
			set  {
				gtk_image_set_from_pixbuf(Handle, value == null ? IntPtr.Zero : value.Handle);
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_image_set_from_file(IntPtr raw, IntPtr filename);

		[GLib.Property ("file")]
		public string File {
			get {
				GLib.Value val = GetProperty ("file");
				string ret = (string) val;
				val.Dispose ();
				return ret;
			}
			set  {
				IntPtr native_value = GLib.Marshaller.StringToPtrGStrdup (value);
				gtk_image_set_from_file(Handle, native_value);
				GLib.Marshaller.Free (native_value);
			}
		}

		[GLib.Property ("stock")]
		public string Stock {
			get {
				GLib.Value val = GetProperty ("stock");
				string ret = (string) val;
				val.Dispose ();
				return ret;
			}
			set {
				GLib.Value val = new GLib.Value(value);
				SetProperty("stock", val);
				val.Dispose ();
			}
		}

		[GLib.Property ("icon-set")]
		public Gtk.IconSet IconSet {
			get {
				GLib.Value val = GetProperty ("icon-set");
				Gtk.IconSet ret = (Gtk.IconSet) val;
				val.Dispose ();
				return ret;
			}
			set {
				GLib.Value val = new GLib.Value(value, "GtkIconSet");
				SetProperty("icon-set", val);
				val.Dispose ();
			}
		}

		[GLib.Property ("icon-size")]
		public int IconSize {
			get {
				GLib.Value val = GetProperty ("icon-size");
				int ret = (int) val;
				val.Dispose ();
				return ret;
			}
			set {
				GLib.Value val = new GLib.Value(value);
				SetProperty("icon-size", val);
				val.Dispose ();
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern int gtk_image_get_pixel_size(IntPtr raw);

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_image_set_pixel_size(IntPtr raw, int pixel_size);

		[GLib.Property ("pixel-size")]
		public int PixelSize {
			get  {
				int raw_ret = gtk_image_get_pixel_size(Handle);
				int ret = raw_ret;
				return ret;
			}
			set  {
				gtk_image_set_pixel_size(Handle, value);
			}
		}

		[GLib.Property ("pixbuf-animation")]
		public Gdk.PixbufAnimation PixbufAnimation {
			get {
				GLib.Value val = GetProperty ("pixbuf-animation");
				Gdk.PixbufAnimation ret = (Gdk.PixbufAnimation) val;
				val.Dispose ();
				return ret;
			}
			set {
				GLib.Value val = new GLib.Value(value);
				SetProperty("pixbuf-animation", val);
				val.Dispose ();
			}
		}

		[GLib.Property ("icon-name")]
		public string IconName {
			get {
				GLib.Value val = GetProperty ("icon-name");
				string ret = (string) val;
				val.Dispose ();
				return ret;
			}
			set {
				GLib.Value val = new GLib.Value(value);
				SetProperty("icon-name", val);
				val.Dispose ();
			}
		}

		[GLib.Property ("gicon")]
		public GLib.IIcon Icon {
			get {
				GLib.Value val = GetProperty ("gicon");
				GLib.IIcon ret = GLib.IconAdapter.GetObject ((GLib.Object) val);
				val.Dispose ();
				return ret;
			}
			set {
				GLib.Value val = new GLib.Value(value);
				SetProperty("gicon", val);
				val.Dispose ();
			}
		}

		[GLib.Property ("resource")]
		public string Resource {
			get {
				GLib.Value val = GetProperty ("resource");
				string ret = (string) val;
				val.Dispose ();
				return ret;
			}
			set {
				GLib.Value val = new GLib.Value(value);
				SetProperty("resource", val);
				val.Dispose ();
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern int gtk_image_get_storage_type(IntPtr raw);

		[GLib.Property ("storage-type")]
		public Gtk.ImageType StorageType {
			get  {
				int raw_ret = gtk_image_get_storage_type(Handle);
				Gtk.ImageType ret = (Gtk.ImageType) raw_ret;
				return ret;
			}
		}

		[GLib.Property ("use-fallback")]
		public bool UseFallback {
			get {
				GLib.Value val = GetProperty ("use-fallback");
				bool ret = (bool) val;
				val.Dispose ();
				return ret;
			}
			set {
				GLib.Value val = new GLib.Value(value);
				SetProperty("use-fallback", val);
				val.Dispose ();
			}
		}


		// Internal representation of the wrapped structure ABI.
		static GLib.AbiStruct _class_abi = null;
		static public new GLib.AbiStruct class_abi {
			get {
				if (_class_abi == null)
					_class_abi = new GLib.AbiStruct (new List<GLib.AbiField>{ 
						new GLib.AbiField("_gtk_reserved1"
							, Gtk.Misc.class_abi.Fields
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // _gtk_reserved1
							, null
							, "_gtk_reserved2"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("_gtk_reserved2"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // _gtk_reserved2
							, "_gtk_reserved1"
							, "_gtk_reserved3"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("_gtk_reserved3"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // _gtk_reserved3
							, "_gtk_reserved2"
							, "_gtk_reserved4"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("_gtk_reserved4"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // _gtk_reserved4
							, "_gtk_reserved3"
							, null
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
					});

				return _class_abi;
			}
		}


		// End of the ABI representation.

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_image_clear(IntPtr raw);

		public void Clear() {
			gtk_image_clear(Handle);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gtk_image_get_animation(IntPtr raw);

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_image_set_from_animation(IntPtr raw, IntPtr animation);

		public Gdk.PixbufAnimation Animation { 
			get {
				IntPtr raw_ret = gtk_image_get_animation(Handle);
				Gdk.PixbufAnimation ret = GLib.Object.GetObject(raw_ret) as Gdk.PixbufAnimation;
				return ret;
			}
			set {
				gtk_image_set_from_animation(Handle, value == null ? IntPtr.Zero : value.Handle);
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_image_get_gicon(IntPtr raw, out IntPtr gicon, out int size);

		public void GetIcon(out GLib.IIcon gicon, out Gtk.IconSize size) {
			IntPtr native_gicon;
			int native_size;
			gtk_image_get_gicon(Handle, out native_gicon, out native_size);
			gicon = GLib.IconAdapter.GetObject (native_gicon, false);
			size = (Gtk.IconSize) native_size;
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_image_get_icon_name(IntPtr raw, IntPtr icon_name, out int size);

		public Gtk.IconSize GetIconName(string icon_name) {
			Gtk.IconSize size;
			IntPtr native_icon_name = GLib.Marshaller.StringToPtrGStrdup (icon_name);
			int native_size;
			gtk_image_get_icon_name(Handle, native_icon_name, out native_size);
			GLib.Marshaller.Free (native_icon_name);
			size = (Gtk.IconSize) native_size;
			return size;
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_image_get_icon_set(IntPtr raw, out IntPtr icon_set, out int size);

		[Obsolete]
		public void GetIconSet(out Gtk.IconSet icon_set, out Gtk.IconSize size) {
			IntPtr native_icon_set;
			int native_size;
			gtk_image_get_icon_set(Handle, out native_icon_set, out native_size);
			icon_set = native_icon_set == IntPtr.Zero ? null : (Gtk.IconSet) GLib.Opaque.GetOpaque (native_icon_set, typeof (Gtk.IconSet), false);
			size = (Gtk.IconSize) native_size;
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_image_get_stock(IntPtr raw, out IntPtr stock_id, out int size);

		[Obsolete]
		public void GetStock(out string stock_id, out Gtk.IconSize size) {
			IntPtr native_stock_id;
			int native_size;
			gtk_image_get_stock(Handle, out native_stock_id, out native_size);
			stock_id = GLib.Marshaller.PtrToStringGFree(native_stock_id);
			size = (Gtk.IconSize) native_size;
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gtk_image_get_type();

		public static new GLib.GType GType { 
			get {
				IntPtr raw_ret = gtk_image_get_type();
				GLib.GType ret = new GLib.GType(raw_ret);
				return ret;
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_image_set_from_gicon(IntPtr raw, IntPtr icon, int size);

		public void SetFromIcon(GLib.IIcon icon, Gtk.IconSize size) {
			gtk_image_set_from_gicon(Handle, icon == null ? IntPtr.Zero : ((icon is GLib.Object) ? (icon as GLib.Object).Handle : (icon as GLib.IconAdapter).Handle), (int) size);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_image_set_from_icon_name(IntPtr raw, IntPtr icon_name, int size);

		public void SetFromIconName(string icon_name, Gtk.IconSize size) {
			IntPtr native_icon_name = GLib.Marshaller.StringToPtrGStrdup (icon_name);
			gtk_image_set_from_icon_name(Handle, native_icon_name, (int) size);
			GLib.Marshaller.Free (native_icon_name);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_image_set_from_icon_set(IntPtr raw, IntPtr icon_set, int size);

		[Obsolete]
		public void SetFromIconSet(Gtk.IconSet icon_set, Gtk.IconSize size) {
			gtk_image_set_from_icon_set(Handle, icon_set == null ? IntPtr.Zero : icon_set.Handle, (int) size);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_image_set_from_resource(IntPtr raw, IntPtr resource_path);

		public string FromResource { 
			set {
				IntPtr native_value = GLib.Marshaller.StringToPtrGStrdup (value);
				gtk_image_set_from_resource(Handle, native_value);
				GLib.Marshaller.Free (native_value);
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_image_set_from_stock(IntPtr raw, IntPtr stock_id, int size);

		[Obsolete]
		public void SetFromStock(string stock_id, Gtk.IconSize size) {
			IntPtr native_stock_id = GLib.Marshaller.StringToPtrGStrdup (stock_id);
			gtk_image_set_from_stock(Handle, native_stock_id, (int) size);
			GLib.Marshaller.Free (native_stock_id);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_image_set_from_surface(IntPtr raw, IntPtr surface);

		public Cairo.Surface FromSurface { 
			set {
				gtk_image_set_from_surface(Handle, value.Handle);
			}
		}


		// Internal representation of the wrapped structure ABI.
		static GLib.AbiStruct _abi_info = null;
		static public new GLib.AbiStruct abi_info {
			get {
				if (_abi_info == null)
					_abi_info = new GLib.AbiStruct (new List<GLib.AbiField>{ 
						new GLib.AbiField("priv"
							, Gtk.Misc.abi_info.Fields
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // priv
							, null
							, null
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
					});

				return _abi_info;
			}
		}


		// End of the ABI representation.

#endregion
	}
}
