//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armagrifood

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strconv"
	"strings"
)

// ExtensionsClient contains the methods for the Extensions group.
// Don't use this type directly, use NewExtensionsClient() instead.
type ExtensionsClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewExtensionsClient creates a new instance of ExtensionsClient with the specified values.
// subscriptionID - The ID of the target subscription.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewExtensionsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ExtensionsClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &ExtensionsClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// Create - Install extension.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-09-01-preview
// resourceGroupName - The name of the resource group. The name is case insensitive.
// farmBeatsResourceName - FarmBeats resource name.
// extensionID - Id of extension resource.
// options - ExtensionsClientCreateOptions contains the optional parameters for the ExtensionsClient.Create method.
func (client *ExtensionsClient) Create(ctx context.Context, resourceGroupName string, farmBeatsResourceName string, extensionID string, options *ExtensionsClientCreateOptions) (ExtensionsClientCreateResponse, error) {
	req, err := client.createCreateRequest(ctx, resourceGroupName, farmBeatsResourceName, extensionID, options)
	if err != nil {
		return ExtensionsClientCreateResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ExtensionsClientCreateResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusCreated) {
		return ExtensionsClientCreateResponse{}, runtime.NewResponseError(resp)
	}
	return client.createHandleResponse(resp)
}

// createCreateRequest creates the Create request.
func (client *ExtensionsClient) createCreateRequest(ctx context.Context, resourceGroupName string, farmBeatsResourceName string, extensionID string, options *ExtensionsClientCreateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AgFoodPlatform/farmBeats/{farmBeatsResourceName}/extensions/{extensionId}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if farmBeatsResourceName == "" {
		return nil, errors.New("parameter farmBeatsResourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{farmBeatsResourceName}", url.PathEscape(farmBeatsResourceName))
	if extensionID == "" {
		return nil, errors.New("parameter extensionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{extensionId}", url.PathEscape(extensionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-09-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// createHandleResponse handles the Create response.
func (client *ExtensionsClient) createHandleResponse(resp *http.Response) (ExtensionsClientCreateResponse, error) {
	result := ExtensionsClientCreateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Extension); err != nil {
		return ExtensionsClientCreateResponse{}, err
	}
	return result, nil
}

// Delete - Uninstall extension.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-09-01-preview
// resourceGroupName - The name of the resource group. The name is case insensitive.
// farmBeatsResourceName - FarmBeats resource name.
// extensionID - Id of extension resource.
// options - ExtensionsClientDeleteOptions contains the optional parameters for the ExtensionsClient.Delete method.
func (client *ExtensionsClient) Delete(ctx context.Context, resourceGroupName string, farmBeatsResourceName string, extensionID string, options *ExtensionsClientDeleteOptions) (ExtensionsClientDeleteResponse, error) {
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, farmBeatsResourceName, extensionID, options)
	if err != nil {
		return ExtensionsClientDeleteResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ExtensionsClientDeleteResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusNoContent) {
		return ExtensionsClientDeleteResponse{}, runtime.NewResponseError(resp)
	}
	return ExtensionsClientDeleteResponse{}, nil
}

// deleteCreateRequest creates the Delete request.
func (client *ExtensionsClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, farmBeatsResourceName string, extensionID string, options *ExtensionsClientDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AgFoodPlatform/farmBeats/{farmBeatsResourceName}/extensions/{extensionId}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if farmBeatsResourceName == "" {
		return nil, errors.New("parameter farmBeatsResourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{farmBeatsResourceName}", url.PathEscape(farmBeatsResourceName))
	if extensionID == "" {
		return nil, errors.New("parameter extensionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{extensionId}", url.PathEscape(extensionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-09-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Get - Get installed extension details by extension id.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-09-01-preview
// resourceGroupName - The name of the resource group. The name is case insensitive.
// farmBeatsResourceName - FarmBeats resource name.
// extensionID - Id of extension resource.
// options - ExtensionsClientGetOptions contains the optional parameters for the ExtensionsClient.Get method.
func (client *ExtensionsClient) Get(ctx context.Context, resourceGroupName string, farmBeatsResourceName string, extensionID string, options *ExtensionsClientGetOptions) (ExtensionsClientGetResponse, error) {
	req, err := client.getCreateRequest(ctx, resourceGroupName, farmBeatsResourceName, extensionID, options)
	if err != nil {
		return ExtensionsClientGetResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ExtensionsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ExtensionsClientGetResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHandleResponse(resp)
}

// getCreateRequest creates the Get request.
func (client *ExtensionsClient) getCreateRequest(ctx context.Context, resourceGroupName string, farmBeatsResourceName string, extensionID string, options *ExtensionsClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AgFoodPlatform/farmBeats/{farmBeatsResourceName}/extensions/{extensionId}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if farmBeatsResourceName == "" {
		return nil, errors.New("parameter farmBeatsResourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{farmBeatsResourceName}", url.PathEscape(farmBeatsResourceName))
	if extensionID == "" {
		return nil, errors.New("parameter extensionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{extensionId}", url.PathEscape(extensionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-09-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *ExtensionsClient) getHandleResponse(resp *http.Response) (ExtensionsClientGetResponse, error) {
	result := ExtensionsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Extension); err != nil {
		return ExtensionsClientGetResponse{}, err
	}
	return result, nil
}

// NewListByFarmBeatsPager - Get installed extensions details.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-09-01-preview
// resourceGroupName - The name of the resource group. The name is case insensitive.
// farmBeatsResourceName - FarmBeats resource name.
// options - ExtensionsClientListByFarmBeatsOptions contains the optional parameters for the ExtensionsClient.ListByFarmBeats
// method.
func (client *ExtensionsClient) NewListByFarmBeatsPager(resourceGroupName string, farmBeatsResourceName string, options *ExtensionsClientListByFarmBeatsOptions) *runtime.Pager[ExtensionsClientListByFarmBeatsResponse] {
	return runtime.NewPager(runtime.PagingHandler[ExtensionsClientListByFarmBeatsResponse]{
		More: func(page ExtensionsClientListByFarmBeatsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ExtensionsClientListByFarmBeatsResponse) (ExtensionsClientListByFarmBeatsResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listByFarmBeatsCreateRequest(ctx, resourceGroupName, farmBeatsResourceName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return ExtensionsClientListByFarmBeatsResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return ExtensionsClientListByFarmBeatsResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return ExtensionsClientListByFarmBeatsResponse{}, runtime.NewResponseError(resp)
			}
			return client.listByFarmBeatsHandleResponse(resp)
		},
	})
}

// listByFarmBeatsCreateRequest creates the ListByFarmBeats request.
func (client *ExtensionsClient) listByFarmBeatsCreateRequest(ctx context.Context, resourceGroupName string, farmBeatsResourceName string, options *ExtensionsClientListByFarmBeatsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AgFoodPlatform/farmBeats/{farmBeatsResourceName}/extensions"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if farmBeatsResourceName == "" {
		return nil, errors.New("parameter farmBeatsResourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{farmBeatsResourceName}", url.PathEscape(farmBeatsResourceName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-09-01-preview")
	if options != nil && options.ExtensionIDs != nil {
		for _, qv := range options.ExtensionIDs {
			reqQP.Add("extensionIds", qv)
		}
	}
	if options != nil && options.ExtensionCategories != nil {
		for _, qv := range options.ExtensionCategories {
			reqQP.Add("extensionCategories", qv)
		}
	}
	if options != nil && options.MaxPageSize != nil {
		reqQP.Set("$maxPageSize", strconv.FormatInt(int64(*options.MaxPageSize), 10))
	}
	if options != nil && options.SkipToken != nil {
		reqQP.Set("$skipToken", *options.SkipToken)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByFarmBeatsHandleResponse handles the ListByFarmBeats response.
func (client *ExtensionsClient) listByFarmBeatsHandleResponse(resp *http.Response) (ExtensionsClientListByFarmBeatsResponse, error) {
	result := ExtensionsClientListByFarmBeatsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ExtensionListResponse); err != nil {
		return ExtensionsClientListByFarmBeatsResponse{}, err
	}
	return result, nil
}

// Update - Upgrade to latest extension.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-09-01-preview
// resourceGroupName - The name of the resource group. The name is case insensitive.
// farmBeatsResourceName - FarmBeats resource name.
// extensionID - Id of extension resource.
// options - ExtensionsClientUpdateOptions contains the optional parameters for the ExtensionsClient.Update method.
func (client *ExtensionsClient) Update(ctx context.Context, resourceGroupName string, farmBeatsResourceName string, extensionID string, options *ExtensionsClientUpdateOptions) (ExtensionsClientUpdateResponse, error) {
	req, err := client.updateCreateRequest(ctx, resourceGroupName, farmBeatsResourceName, extensionID, options)
	if err != nil {
		return ExtensionsClientUpdateResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ExtensionsClientUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ExtensionsClientUpdateResponse{}, runtime.NewResponseError(resp)
	}
	return client.updateHandleResponse(resp)
}

// updateCreateRequest creates the Update request.
func (client *ExtensionsClient) updateCreateRequest(ctx context.Context, resourceGroupName string, farmBeatsResourceName string, extensionID string, options *ExtensionsClientUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AgFoodPlatform/farmBeats/{farmBeatsResourceName}/extensions/{extensionId}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if farmBeatsResourceName == "" {
		return nil, errors.New("parameter farmBeatsResourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{farmBeatsResourceName}", url.PathEscape(farmBeatsResourceName))
	if extensionID == "" {
		return nil, errors.New("parameter extensionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{extensionId}", url.PathEscape(extensionID))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-09-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// updateHandleResponse handles the Update response.
func (client *ExtensionsClient) updateHandleResponse(resp *http.Response) (ExtensionsClientUpdateResponse, error) {
	result := ExtensionsClientUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Extension); err != nil {
		return ExtensionsClientUpdateResponse{}, err
	}
	return result, nil
}
