// Package amqp for read, write, parse amqp frames
// Autogenerated code. Do not edit.
package amqp

// FrameMethod identifier
const FrameMethod = 1

// FrameHeader identifier
const FrameHeader = 2

// FrameBody identifier
const FrameBody = 3

// FrameHeartbeat identifier
const FrameHeartbeat = 8

// FrameMinSize identifier
const FrameMinSize = 4096

// FrameEnd identifier
const FrameEnd = 206

// ReplySuccess identifier Indicates that the method completed successfully. This reply code is
// reserved for future use - the current protocol design does not use positive
// confirmation and reply codes are sent only in case of an error.
const ReplySuccess = 200

// ContentTooLarge identifier The client attempted to transfer content larger than the server could accept
// at the present time. The client may retry at a later time.
const ContentTooLarge = 311

// NoConsumers identifier When the exchange cannot deliver to a consumer when the immediate flag is
// set. As a result of pending data on the queue or the absence of any
// consumers of the queue.
const NoConsumers = 313

// ConnectionForced identifier An operator intervened to close the connection for some reason. The client
// may retry at some later date.
const ConnectionForced = 320

// InvalidPath identifier The client tried to work with an unknown virtual host.
const InvalidPath = 402

// AccessRefused identifier The client attempted to work with a server entity to which it has no
// access due to security settings.
const AccessRefused = 403

// NotFound identifier The client attempted to work with a server entity that does not exist.
const NotFound = 404

// ResourceLocked identifier The client attempted to work with a server entity to which it has no
// access because another client is working with it.
const ResourceLocked = 405

// PreconditionFailed identifier The client requested a method that was not allowed because some precondition
// failed.
const PreconditionFailed = 406

// FrameError identifier The sender sent a malformed frame that the recipient could not decode.
// This strongly implies a programming error in the sending peer.
const FrameError = 501

// SyntaxError identifier The sender sent a frame that contained illegal values for one or more
// fields. This strongly implies a programming error in the sending peer.
const SyntaxError = 502

// CommandInvalid identifier The client sent an invalid sequence of frames, attempting to perform an
// operation that was considered invalid by the server. This usually implies
// a programming error in the client.
const CommandInvalid = 503

// ChannelError identifier The client attempted to work with a channel that had not been correctly
// opened. This most likely indicates a fault in the client layer.
const ChannelError = 504

// UnexpectedFrame identifier The peer sent a frame that was not expected, usually in the context of
// a content header and body.  This strongly indicates a fault in the peer's
// content processing.
const UnexpectedFrame = 505

// ResourceError identifier The server could not complete the method because it lacked sufficient
// resources. This may be due to the client creating too many of some type
// of entity.
const ResourceError = 506

// NotAllowed identifier The client tried to work with some entity in a manner that is prohibited
// by the server, due to security settings or by some other criteria.
const NotAllowed = 530

// NotImplemented identifier The client tried to use functionality that is not implemented in the
// server.
const NotImplemented = 540

// InternalError identifier The server could not complete the method because of an internal error.
// The server may require intervention by an operator in order to resume
// normal operations.
const InternalError = 541

// ClassConnection identifier
const ClassConnection = 10

// MethodConnectionStart identifier
const MethodConnectionStart = 10

// MethodConnectionStartOk identifier
const MethodConnectionStartOk = 11

// MethodConnectionSecure identifier
const MethodConnectionSecure = 20

// MethodConnectionSecureOk identifier
const MethodConnectionSecureOk = 21

// MethodConnectionTune identifier
const MethodConnectionTune = 30

// MethodConnectionTuneOk identifier
const MethodConnectionTuneOk = 31

// MethodConnectionOpen identifier
const MethodConnectionOpen = 40

// MethodConnectionOpenOk identifier
const MethodConnectionOpenOk = 41

// MethodConnectionClose identifier
const MethodConnectionClose = 50

// MethodConnectionCloseOk identifier
const MethodConnectionCloseOk = 51

// MethodConnectionBlocked identifier
const MethodConnectionBlocked = 60

// MethodConnectionUnblocked identifier
const MethodConnectionUnblocked = 61

// ClassChannel identifier
const ClassChannel = 20

// MethodChannelOpen identifier
const MethodChannelOpen = 10

// MethodChannelOpenOk identifier
const MethodChannelOpenOk = 11

// MethodChannelFlow identifier
const MethodChannelFlow = 20

// MethodChannelFlowOk identifier
const MethodChannelFlowOk = 21

// MethodChannelClose identifier
const MethodChannelClose = 40

// MethodChannelCloseOk identifier
const MethodChannelCloseOk = 41

// ClassExchange identifier
const ClassExchange = 40

// MethodExchangeDeclare identifier
const MethodExchangeDeclare = 10

// MethodExchangeDeclareOk identifier
const MethodExchangeDeclareOk = 11

// MethodExchangeDelete identifier
const MethodExchangeDelete = 20

// MethodExchangeDeleteOk identifier
const MethodExchangeDeleteOk = 21

// MethodExchangeBind identifier
const MethodExchangeBind = 30

// MethodExchangeBindOk identifier
const MethodExchangeBindOk = 31

// MethodExchangeUnbind identifier
const MethodExchangeUnbind = 40

// MethodExchangeUnbindOk identifier
const MethodExchangeUnbindOk = 51

// ClassQueue identifier
const ClassQueue = 50

// MethodQueueDeclare identifier
const MethodQueueDeclare = 10

// MethodQueueDeclareOk identifier
const MethodQueueDeclareOk = 11

// MethodQueueBind identifier
const MethodQueueBind = 20

// MethodQueueBindOk identifier
const MethodQueueBindOk = 21

// MethodQueueUnbind identifier
const MethodQueueUnbind = 50

// MethodQueueUnbindOk identifier
const MethodQueueUnbindOk = 51

// MethodQueuePurge identifier
const MethodQueuePurge = 30

// MethodQueuePurgeOk identifier
const MethodQueuePurgeOk = 31

// MethodQueueDelete identifier
const MethodQueueDelete = 40

// MethodQueueDeleteOk identifier
const MethodQueueDeleteOk = 41

// ClassBasic identifier
const ClassBasic = 60

// MethodBasicQos identifier
const MethodBasicQos = 10

// MethodBasicQosOk identifier
const MethodBasicQosOk = 11

// MethodBasicConsume identifier
const MethodBasicConsume = 20

// MethodBasicConsumeOk identifier
const MethodBasicConsumeOk = 21

// MethodBasicCancel identifier
const MethodBasicCancel = 30

// MethodBasicCancelOk identifier
const MethodBasicCancelOk = 31

// MethodBasicPublish identifier
const MethodBasicPublish = 40

// MethodBasicReturn identifier
const MethodBasicReturn = 50

// MethodBasicDeliver identifier
const MethodBasicDeliver = 60

// MethodBasicGet identifier
const MethodBasicGet = 70

// MethodBasicGetOk identifier
const MethodBasicGetOk = 71

// MethodBasicGetEmpty identifier
const MethodBasicGetEmpty = 72

// MethodBasicAck identifier
const MethodBasicAck = 80

// MethodBasicReject identifier
const MethodBasicReject = 90

// MethodBasicRecoverAsync identifier
const MethodBasicRecoverAsync = 100

// MethodBasicRecover identifier
const MethodBasicRecover = 110

// MethodBasicRecoverOk identifier
const MethodBasicRecoverOk = 111

// MethodBasicNack identifier
const MethodBasicNack = 120

// ClassTx identifier
const ClassTx = 90

// MethodTxSelect identifier
const MethodTxSelect = 10

// MethodTxSelectOk identifier
const MethodTxSelectOk = 11

// MethodTxCommit identifier
const MethodTxCommit = 20

// MethodTxCommitOk identifier
const MethodTxCommitOk = 21

// MethodTxRollback identifier
const MethodTxRollback = 30

// MethodTxRollbackOk identifier
const MethodTxRollbackOk = 31

// ClassConfirm identifier
const ClassConfirm = 85

// MethodConfirmSelect identifier
const MethodConfirmSelect = 10

// MethodConfirmSelectOk identifier
const MethodConfirmSelectOk = 11

// ConstantsNameMap map for mapping error codes into error messages
var ConstantsNameMap = map[uint16]string{

	1: "FRAME_METHOD",

	2: "FRAME_HEADER",

	3: "FRAME_BODY",

	8: "FRAME_HEARTBEAT",

	4096: "FRAME_MIN_SIZE",

	206: "FRAME_END",

	200: "REPLY_SUCCESS",

	311: "CONTENT_TOO_LARGE",

	313: "NO_CONSUMERS",

	320: "CONNECTION_FORCED",

	402: "INVALID_PATH",

	403: "ACCESS_REFUSED",

	404: "NOT_FOUND",

	405: "RESOURCE_LOCKED",

	406: "PRECONDITION_FAILED",

	501: "FRAME_ERROR",

	502: "SYNTAX_ERROR",

	503: "COMMAND_INVALID",

	504: "CHANNEL_ERROR",

	505: "UNEXPECTED_FRAME",

	506: "RESOURCE_ERROR",

	530: "NOT_ALLOWED",

	540: "NOT_IMPLEMENTED",

	541: "INTERNAL_ERROR",
}
