/*
 *      fhist - file history and comparison tools
 *      Copyright (C) 1991-1994, 1998-2000, 2002, 2008 Peter Miller
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 3 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program. If not, see
 *      <http://www.gnu.org/licenses/>.
 */

#ifndef COMMON_ERROR_H
#define COMMON_ERROR_H

#include <attrib_forma.h>
#include <main.h>

#define error @/@/@
#define nerror @/@/@
#define fatal @/@/@
#define nfatal @/@/@

void error_raw(char *, ...) ATTRIBUTE_FORMAT_1_2;
void fatal_raw(char *, ...) ATTRIBUTE_FORMAT_1_2 ATTR_NORETURN;
void nerror_raw(char *, ...) ATTRIBUTE_FORMAT_1_2;
void nfatal_raw(char *, ...) ATTRIBUTE_FORMAT_1_2 ATTR_NORETURN;

void my_assert(int, char *, char *, int);
#ifdef DEBUG
# ifdef __STDC__
#  define assert(c) my_assert((c) != 0, #c, __FILE__, __LINE__)
# else
#  define assert(c) my_assert((c) != 0, "c", __FILE__, __LINE__)
# endif
#else
# define assert(c)
#endif

#endif /* COMMON_ERROR_H */
