// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*************************************************************************
 * @file OwnershipStrengthSubscriber.h
 * This header file contains the declaration of the subscriber functions.
 *
 * This file was generated by the tool fastcdrgen.
 */


#ifndef _OWNERSHIPTEST_SUBSCRIBER_H_
#define _OWNERSHIPTEST_SUBSCRIBER_H_

#include <fastdds/dds/domain/DomainParticipant.hpp>
#include <fastdds/dds/subscriber/Subscriber.hpp>
#include <fastdds/dds/subscriber/DataReader.hpp>
#include <fastdds/dds/subscriber/DataReaderListener.hpp>
#include <fastdds/dds/topic/Topic.hpp>

#include "OwnershipStrengthPubSubTypes.h"

#include <set>
#include <mutex>
#include <map>

class OwnershipStrengthSubscriber
{
public:

    OwnershipStrengthSubscriber();

    virtual ~OwnershipStrengthSubscriber();

    bool init();

    void run();

private:

    eprosima::fastdds::dds::DomainParticipant* participant_;

    eprosima::fastdds::dds::Subscriber* subscriber_;

    eprosima::fastdds::dds::Topic* topic_;

    eprosima::fastdds::dds::DataReader* reader_;

    class StrengthHierarchy
    {
    public:

        // Automatically adds a publisher to the hierarchy, and reports back whether it is the strongest.
        bool IsMessageStrong(
                const ExampleMessage& st,
                const eprosima::fastdds::dds::SampleInfo& info);

        // Deregisters a publisher removing it from the hierarchy.
        void DeregisterPublisher(
                eprosima::fastrtps::rtps::GUID_t guid);

        // Provides an ordered hierarchy of publishers, based on the Ownership Strength QoS parameter.
        std::map<unsigned int, std::set<eprosima::fastrtps::rtps::GUID_t>> strengthMap;  // Keyed by Ownership Strength
        std::mutex mapMutex;
    };

    class SubListener : public eprosima::fastdds::dds::DataReaderListener
    {
    public:

        SubListener()
            : n_matched(0)
            , n_msg(0)
        {
        }

        ~SubListener() override
        {
        }

        void on_data_available(
                eprosima::fastdds::dds::DataReader* reader) override;

        void on_subscription_matched(
                eprosima::fastdds::dds::DataReader* reader,
                const eprosima::fastdds::dds::SubscriptionMatchedStatus& info) override;

        int n_matched;

        int n_msg;

        StrengthHierarchy m_hierarchy;
    }
    m_listener;

    eprosima::fastdds::dds::TypeSupport myType;
};

#endif // _OwnershipStrength_SUBSCRIBER_H_
