/**
 * @file lv_profiler.h
 *
 */

#ifndef LV_PROFILER_H
#define LV_PROFILER_H

#ifdef __cplusplus
extern "C" {
#endif

/*********************
 *      INCLUDES
 *********************/

#include "../lv_conf_internal.h"

#if LV_USE_PROFILER

#include LV_PROFILER_INCLUDE

/*********************
 *      DEFINES
 *********************/

/**********************
 *      TYPEDEFS
 **********************/

/**********************
 * GLOBAL PROTOTYPES
 **********************/

/**********************
 *      MACROS
 **********************/

#else

#define LV_PROFILER_BEGIN
#define LV_PROFILER_END
#define LV_PROFILER_BEGIN_TAG(tag) LV_UNUSED(tag)
#define LV_PROFILER_END_TAG(tag)   LV_UNUSED(tag)

#endif /*LV_USE_PROFILER*/

#if LV_USE_PROFILER && LV_PROFILER_LAYOUT
#define LV_PROFILER_LAYOUT_BEGIN LV_PROFILER_BEGIN
#define LV_PROFILER_LAYOUT_END LV_PROFILER_END
#define LV_PROFILER_LAYOUT_BEGIN_TAG(tag) LV_PROFILER_BEGIN_TAG(tag)
#define LV_PROFILER_LAYOUT_END_TAG(tag)   LV_PROFILER_END_TAG(tag)
#else
#define LV_PROFILER_LAYOUT_BEGIN
#define LV_PROFILER_LAYOUT_END
#define LV_PROFILER_LAYOUT_BEGIN_TAG(tag)
#define LV_PROFILER_LAYOUT_END_TAG(tag)
#endif

#if LV_USE_PROFILER && LV_PROFILER_STYLE
#define LV_PROFILER_STYLE_BEGIN LV_PROFILER_BEGIN
#define LV_PROFILER_STYLE_END LV_PROFILER_END
#define LV_PROFILER_STYLE_BEGIN_TAG(tag) LV_PROFILER_BEGIN_TAG(tag)
#define LV_PROFILER_STYLE_END_TAG(tag)   LV_PROFILER_END_TAG(tag)
#else
#define LV_PROFILER_STYLE_BEGIN
#define LV_PROFILER_STYLE_END
#define LV_PROFILER_STYLE_BEGIN_TAG(tag)
#define LV_PROFILER_STYLE_END_TAG(tag)
#endif

#if LV_USE_PROFILER && LV_PROFILER_DRAW
#define LV_PROFILER_DRAW_BEGIN LV_PROFILER_BEGIN
#define LV_PROFILER_DRAW_END LV_PROFILER_END
#define LV_PROFILER_DRAW_BEGIN_TAG(tag) LV_PROFILER_BEGIN_TAG(tag)
#define LV_PROFILER_DRAW_END_TAG(tag)   LV_PROFILER_END_TAG(tag)
#else
#define LV_PROFILER_DRAW_BEGIN
#define LV_PROFILER_DRAW_END
#define LV_PROFILER_DRAW_BEGIN_TAG(tag)
#define LV_PROFILER_DRAW_END_TAG(tag)
#endif

#if LV_USE_PROFILER && LV_PROFILER_DECODER
#define LV_PROFILER_DECODER_BEGIN LV_PROFILER_BEGIN
#define LV_PROFILER_DECODER_END LV_PROFILER_END
#define LV_PROFILER_DECODER_BEGIN_TAG(tag) LV_PROFILER_BEGIN_TAG(tag)
#define LV_PROFILER_DECODER_END_TAG(tag)   LV_PROFILER_END_TAG(tag)
#else
#define LV_PROFILER_DECODER_BEGIN
#define LV_PROFILER_DECODER_END
#define LV_PROFILER_DECODER_BEGIN_TAG(tag)
#define LV_PROFILER_DECODER_END_TAG(tag)
#endif

#if LV_USE_PROFILER && LV_PROFILER_REFR
#define LV_PROFILER_REFR_BEGIN LV_PROFILER_BEGIN
#define LV_PROFILER_REFR_END LV_PROFILER_END
#define LV_PROFILER_REFR_BEGIN_TAG(tag) LV_PROFILER_BEGIN_TAG(tag)
#define LV_PROFILER_REFR_END_TAG(tag)   LV_PROFILER_END_TAG(tag)
#else
#define LV_PROFILER_REFR_BEGIN
#define LV_PROFILER_REFR_END
#define LV_PROFILER_REFR_BEGIN_TAG(tag)
#define LV_PROFILER_REFR_END_TAG(tag)
#endif

#if LV_USE_PROFILER && LV_PROFILER_INDEV
#define LV_PROFILER_INDEV_BEGIN LV_PROFILER_BEGIN
#define LV_PROFILER_INDEV_END LV_PROFILER_END
#define LV_PROFILER_INDEV_BEGIN_TAG(tag) LV_PROFILER_BEGIN_TAG(tag)
#define LV_PROFILER_INDEV_END_TAG(tag)   LV_PROFILER_END_TAG(tag)
#else
#define LV_PROFILER_INDEV_BEGIN
#define LV_PROFILER_INDEV_END
#define LV_PROFILER_INDEV_BEGIN_TAG(tag)
#define LV_PROFILER_INDEV_END_TAG(tag)
#endif

#if LV_USE_PROFILER && LV_PROFILER_FONT
#define LV_PROFILER_FONT_BEGIN LV_PROFILER_BEGIN
#define LV_PROFILER_FONT_END LV_PROFILER_END
#define LV_PROFILER_FONT_BEGIN_TAG(tag) LV_PROFILER_BEGIN_TAG(tag)
#define LV_PROFILER_FONT_END_TAG(tag)   LV_PROFILER_END_TAG(tag)
#else
#define LV_PROFILER_FONT_BEGIN
#define LV_PROFILER_FONT_END
#define LV_PROFILER_FONT_BEGIN_TAG(tag)
#define LV_PROFILER_FONT_END_TAG(tag)
#endif

#if LV_USE_PROFILER && LV_PROFILER_CACHE
#define LV_PROFILER_CACHE_BEGIN LV_PROFILER_BEGIN
#define LV_PROFILER_CACHE_END LV_PROFILER_END
#define LV_PROFILER_CACHE_BEGIN_TAG(tag) LV_PROFILER_BEGIN_TAG(tag)
#define LV_PROFILER_CACHE_END_TAG(tag)   LV_PROFILER_END_TAG(tag)
#else
#define LV_PROFILER_CACHE_BEGIN
#define LV_PROFILER_CACHE_END
#define LV_PROFILER_CACHE_BEGIN_TAG(tag)
#define LV_PROFILER_CACHE_END_TAG(tag)
#endif

#if LV_USE_PROFILER && LV_PROFILER_FS
#define LV_PROFILER_FS_BEGIN LV_PROFILER_BEGIN
#define LV_PROFILER_FS_END LV_PROFILER_END
#define LV_PROFILER_FS_BEGIN_TAG(tag) LV_PROFILER_BEGIN_TAG(tag)
#define LV_PROFILER_FS_END_TAG(tag)   LV_PROFILER_END_TAG(tag)
#else
#define LV_PROFILER_FS_BEGIN
#define LV_PROFILER_FS_END
#define LV_PROFILER_FS_BEGIN_TAG(tag)
#define LV_PROFILER_FS_END_TAG(tag)
#endif

#if LV_USE_PROFILER && LV_PROFILER_TIMER
#define LV_PROFILER_TIMER_BEGIN LV_PROFILER_BEGIN
#define LV_PROFILER_TIMER_END LV_PROFILER_END
#define LV_PROFILER_TIMER_BEGIN_TAG(tag) LV_PROFILER_BEGIN_TAG(tag)
#define LV_PROFILER_TIMER_END_TAG(tag)   LV_PROFILER_END_TAG(tag)
#else
#define LV_PROFILER_TIMER_BEGIN
#define LV_PROFILER_TIMER_END
#define LV_PROFILER_TIMER_BEGIN_TAG(tag)
#define LV_PROFILER_TIMER_END_TAG(tag)
#endif

#if LV_USE_PROFILER && LV_PROFILER_EVENT
#define LV_PROFILER_EVENT_BEGIN LV_PROFILER_BEGIN
#define LV_PROFILER_EVENT_END LV_PROFILER_END
#define LV_PROFILER_EVENT_BEGIN_TAG(tag) LV_PROFILER_BEGIN_TAG(tag)
#define LV_PROFILER_EVENT_END_TAG(tag)   LV_PROFILER_END_TAG(tag)
#else
#define LV_PROFILER_EVENT_BEGIN
#define LV_PROFILER_EVENT_END
#define LV_PROFILER_EVENT_BEGIN_TAG(tag)
#define LV_PROFILER_EVENT_END_TAG(tag)
#endif

#ifdef __cplusplus
} /*extern "C"*/
#endif

#endif /*LV_PROFILER_H*/
