/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.dff;

import com.kreative.dff.DFFResource;
import com.kreative.dff.DFFResourceAlreadyExistsException;
import com.kreative.dff.DFFResourceProvider;
import com.kreative.dff.DFFResourceTooBigException;
import com.kreative.dff.NotADFFFileException;
import com.kreative.ksfl.KSFLUtilities;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;

public class DFFResourceDatabase
extends DFFResourceProvider {
    private Connection conn;
    private String table;

    public DFFResourceDatabase(Connection conn, String table) throws NotADFFFileException {
        if (conn == null || table == null || table.length() < 1) {
            throw new NotADFFFileException("Connection or table name invalid.");
        }
        try {
            boolean hasType = false;
            boolean hasId = false;
            boolean hasDataType = false;
            boolean hasName = false;
            boolean hasAttributes = false;
            boolean hasData = false;
            DatabaseMetaData md = conn.getMetaData();
            ResultSet rs = md.getColumns(null, null, table, null);
            while (rs.next()) {
                String n = rs.getString("COLUMN_NAME");
                if (n.equals("type")) {
                    hasType = true;
                    continue;
                }
                if (n.equals("id")) {
                    hasId = true;
                    continue;
                }
                if (n.equals("datatype")) {
                    hasDataType = true;
                    continue;
                }
                if (n.equals("name")) {
                    hasName = true;
                    continue;
                }
                if (n.equals("attributes")) {
                    hasAttributes = true;
                    continue;
                }
                if (!n.equals("data")) continue;
                hasData = true;
            }
            if (!(hasType && hasId && hasDataType && hasName && hasAttributes && hasData)) {
                throw new NotADFFFileException("Required field missing.");
            }
        }
        catch (SQLException se) {
            throw new NotADFFFileException("Connection or table name invalid.");
        }
        this.conn = conn;
        this.table = table;
    }

    public Connection getConnection() {
        return this.conn;
    }

    public String getTableName() {
        return this.table;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public void flush() {
        try {
            this.conn.commit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void close() {
        try {
            this.conn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean add(DFFResource r) throws DFFResourceAlreadyExistsException {
        try {
            PreparedStatement ps = this.conn.prepareStatement("SELECT * FROM " + this.table + " WHERE type=? AND id=?", 1003, 1007);
            ps.setLong(1, r.type);
            ps.setInt(2, r.id);
            if (ps.executeQuery().next()) {
                throw new DFFResourceAlreadyExistsException();
            }
            ps = this.conn.prepareStatement("INSERT INTO " + this.table + " (type, id, datatype, name, attributes, data) VALUES (?, ?, ?, ?, ?, ?)", 1003, 1008);
            ps.setLong(1, r.type);
            ps.setInt(2, r.id);
            ps.setShort(3, r.datatype);
            ps.setString(4, r.name);
            ps.setShort(5, r.getAttributes());
            ps.setBytes(6, r.data);
            return ps.executeUpdate() > 0;
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    @Override
    public boolean contains(long type, int id) {
        try {
            PreparedStatement ps = this.conn.prepareStatement("SELECT * FROM " + this.table + " WHERE type=? AND id=?", 1003, 1007);
            ps.setLong(1, type);
            ps.setInt(2, id);
            return ps.executeQuery().next();
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    @Override
    public boolean contains(long type, String name) {
        try {
            PreparedStatement ps = this.conn.prepareStatement("SELECT * FROM " + this.table + " WHERE type=? AND name=?", 1003, 1007);
            ps.setLong(1, type);
            ps.setString(2, name);
            return ps.executeQuery().next();
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    @Override
    public DFFResource get(long type, int id) {
        try {
            PreparedStatement ps = this.conn.prepareStatement("SELECT * FROM " + this.table + " WHERE type=? AND id=?", 1003, 1007);
            ps.setLong(1, type);
            ps.setInt(2, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                return new DFFResource(rs.getLong("type"), rs.getInt("id"), rs.getShort("datatype"), rs.getShort("attributes"), rs.getString("name"), rs.getBytes("data"));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public DFFResource get(long type, String name) {
        try {
            PreparedStatement ps = this.conn.prepareStatement("SELECT * FROM " + this.table + " WHERE type=? AND name=?", 1003, 1007);
            ps.setLong(1, type);
            ps.setString(2, name);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                return new DFFResource(rs.getLong("type"), rs.getInt("id"), rs.getShort("datatype"), rs.getShort("attributes"), rs.getString("name"), rs.getBytes("data"));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public DFFResource getAttributes(long type, int id) {
        try {
            PreparedStatement ps = this.conn.prepareStatement("SELECT * FROM " + this.table + " WHERE type=? AND id=?", 1003, 1007);
            ps.setLong(1, type);
            ps.setInt(2, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                return new DFFResource(rs.getLong("type"), rs.getInt("id"), rs.getShort("datatype"), rs.getShort("attributes"), rs.getString("name"), new byte[0]);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public DFFResource getAttributes(long type, String name) {
        try {
            PreparedStatement ps = this.conn.prepareStatement("SELECT * FROM " + this.table + " WHERE type=? AND name=?", 1003, 1007);
            ps.setLong(1, type);
            ps.setString(2, name);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                return new DFFResource(rs.getLong("type"), rs.getInt("id"), rs.getShort("datatype"), rs.getShort("attributes"), rs.getString("name"), new byte[0]);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public long getLength(long type, int id) {
        try {
            PreparedStatement ps = this.conn.prepareStatement("SELECT * FROM " + this.table + " WHERE type=? AND id=?", 1003, 1007);
            ps.setLong(1, type);
            ps.setInt(2, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                return rs.getBytes("data").length;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return 0L;
    }

    @Override
    public long getLength(long type, String name) {
        try {
            PreparedStatement ps = this.conn.prepareStatement("SELECT * FROM " + this.table + " WHERE type=? AND name=?", 1003, 1007);
            ps.setLong(1, type);
            ps.setString(2, name);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                return rs.getBytes("data").length;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return 0L;
    }

    @Override
    public byte[] getData(long type, int id) {
        try {
            PreparedStatement ps = this.conn.prepareStatement("SELECT * FROM " + this.table + " WHERE type=? AND id=?", 1003, 1007);
            ps.setLong(1, type);
            ps.setInt(2, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                return rs.getBytes("data");
            }
            return new byte[0];
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    @Override
    public byte[] getData(long type, String name) {
        try {
            PreparedStatement ps = this.conn.prepareStatement("SELECT * FROM " + this.table + " WHERE type=? AND name=?", 1003, 1007);
            ps.setLong(1, type);
            ps.setString(2, name);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                return rs.getBytes("data");
            }
            return new byte[0];
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    @Override
    public int read(long type, int id, long doffset, byte[] data, int off, int len) {
        byte[] junk = this.getData(type, id);
        int n = 0;
        int s = (int)doffset;
        int d = off;
        while (s < junk.length && d < data.length && n < len) {
            data[d] = junk[s];
            ++s;
            ++d;
            ++n;
        }
        return n;
    }

    @Override
    public int read(long type, String name, long doffset, byte[] data, int off, int len) {
        byte[] junk = this.getData(type, name);
        int n = 0;
        int s = (int)doffset;
        int d = off;
        while (s < junk.length && d < data.length && n < len) {
            data[d] = junk[s];
            ++s;
            ++d;
            ++n;
        }
        return n;
    }

    @Override
    public boolean remove(long type, int id) {
        try {
            PreparedStatement ps = this.conn.prepareStatement("DELETE FROM " + this.table + " WHERE type=? AND id=? LIMIT 1", 1003, 1008);
            ps.setLong(1, type);
            ps.setInt(2, id);
            return ps.executeUpdate() > 0;
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    @Override
    public boolean remove(long type, String name) {
        try {
            PreparedStatement ps = this.conn.prepareStatement("DELETE FROM " + this.table + " WHERE type=? AND name=? LIMIT 1", 1003, 1008);
            ps.setLong(1, type);
            ps.setString(2, name);
            return ps.executeUpdate() > 0;
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    @Override
    public boolean set(long type, int id, DFFResource r) throws DFFResourceAlreadyExistsException {
        try {
            if ((type != r.type || id != r.id) && this.contains(r.type, r.id)) {
                throw new DFFResourceAlreadyExistsException();
            }
            PreparedStatement ps = this.conn.prepareStatement("UPDATE " + this.table + " SET type=?, id=?, datatype=?, name=?, attributes=?, data=? WHERE type=? AND id=? LIMIT 1", 1003, 1008);
            ps.setLong(1, r.type);
            ps.setInt(2, r.id);
            ps.setShort(3, r.datatype);
            ps.setString(4, r.name);
            ps.setShort(5, r.getAttributes());
            ps.setBytes(6, r.data);
            ps.setLong(7, type);
            ps.setInt(8, id);
            return ps.executeUpdate() > 0;
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    @Override
    public boolean set(long type, String name, DFFResource r) throws DFFResourceAlreadyExistsException {
        try {
            if ((type != r.type || this.getIDFromName(type, name) != r.id) && this.contains(r.type, r.id)) {
                throw new DFFResourceAlreadyExistsException();
            }
            PreparedStatement ps = this.conn.prepareStatement("UPDATE " + this.table + " SET type=?, id=?, datatype=?, name=?, attributes=?, data=? WHERE type=? AND name=? LIMIT 1", 1003, 1008);
            ps.setLong(1, r.type);
            ps.setInt(2, r.id);
            ps.setShort(3, r.datatype);
            ps.setString(4, r.name);
            ps.setShort(5, r.getAttributes());
            ps.setBytes(6, r.data);
            ps.setLong(7, type);
            ps.setString(8, name);
            return ps.executeUpdate() > 0;
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    @Override
    public boolean setAttributes(long type, int id, DFFResource r) throws DFFResourceAlreadyExistsException {
        try {
            if ((type != r.type || id != r.id) && this.contains(r.type, r.id)) {
                throw new DFFResourceAlreadyExistsException();
            }
            PreparedStatement ps = this.conn.prepareStatement("UPDATE " + this.table + " SET type=?, id=?, datatype=?, name=?, attributes=? WHERE type=? AND id=? LIMIT 1", 1003, 1008);
            ps.setLong(1, r.type);
            ps.setInt(2, r.id);
            ps.setShort(3, r.datatype);
            ps.setString(4, r.name);
            ps.setShort(5, r.getAttributes());
            ps.setLong(6, type);
            ps.setInt(7, id);
            return ps.executeUpdate() > 0;
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    @Override
    public boolean setAttributes(long type, String name, DFFResource r) throws DFFResourceAlreadyExistsException {
        try {
            if ((type != r.type || this.getIDFromName(type, name) != r.id) && this.contains(r.type, r.id)) {
                throw new DFFResourceAlreadyExistsException();
            }
            PreparedStatement ps = this.conn.prepareStatement("UPDATE " + this.table + " SET type=?, id=?, datatype=?, name=?, attributes=? WHERE type=? AND name=? LIMIT 1", 1003, 1008);
            ps.setLong(1, r.type);
            ps.setInt(2, r.id);
            ps.setShort(3, r.datatype);
            ps.setString(4, r.name);
            ps.setShort(5, r.getAttributes());
            ps.setLong(6, type);
            ps.setString(7, name);
            return ps.executeUpdate() > 0;
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    @Override
    public boolean setLength(long type, int id, long len) {
        if (len > Integer.MAX_VALUE) {
            throw new DFFResourceTooBigException();
        }
        return this.setData(type, id, KSFLUtilities.resize(this.getData(type, id), (int)len));
    }

    @Override
    public boolean setLength(long type, String name, long len) {
        if (len > Integer.MAX_VALUE) {
            throw new DFFResourceTooBigException();
        }
        int id = this.getIDFromName(type, name);
        return this.setData(type, id, KSFLUtilities.resize(this.getData(type, id), (int)len));
    }

    @Override
    public boolean setData(long type, int id, byte[] data) {
        try {
            PreparedStatement ps = this.conn.prepareStatement("UPDATE " + this.table + " SET data=? WHERE type=? AND id=? LIMIT 1", 1003, 1008);
            ps.setBytes(1, data);
            ps.setLong(2, type);
            ps.setInt(3, id);
            return ps.executeUpdate() > 0;
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    @Override
    public boolean setData(long type, String name, byte[] data) {
        try {
            PreparedStatement ps = this.conn.prepareStatement("UPDATE " + this.table + " SET data=? WHERE type=? AND name=? LIMIT 1", 1003, 1008);
            ps.setBytes(1, data);
            ps.setLong(2, type);
            ps.setString(3, name);
            return ps.executeUpdate() > 0;
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    @Override
    public int write(long type, int id, long doffset, byte[] data, int off, int len) {
        if (doffset + (long)len > Integer.MAX_VALUE) {
            throw new DFFResourceTooBigException();
        }
        byte[] junk = this.getData(type, id);
        int n = len;
        if (doffset > (long)junk.length) {
            junk = KSFLUtilities.paste(junk, junk.length, new byte[(int)doffset - junk.length]);
            junk = KSFLUtilities.paste(junk, (int)doffset, KSFLUtilities.copy(data, off, len));
        } else if (doffset + (long)len > (long)junk.length) {
            junk = KSFLUtilities.cut(junk, (int)doffset, junk.length - (int)doffset);
            junk = KSFLUtilities.paste(junk, (int)doffset, KSFLUtilities.copy(data, off, len));
        } else {
            n = 0;
            int s = off;
            int d = (int)doffset;
            while (s < data.length && d < junk.length && n < len) {
                junk[d] = data[s];
                ++s;
                ++d;
                ++n;
            }
        }
        return this.setData(type, id, junk) ? n : 0;
    }

    @Override
    public int write(long type, String name, long doffset, byte[] data, int off, int len) {
        if (doffset + (long)len > Integer.MAX_VALUE) {
            throw new DFFResourceTooBigException();
        }
        int id = this.getIDFromName(type, name);
        byte[] junk = this.getData(type, id);
        int n = len;
        if (doffset > (long)junk.length) {
            junk = KSFLUtilities.paste(junk, junk.length, new byte[(int)doffset - junk.length]);
            junk = KSFLUtilities.paste(junk, (int)doffset, KSFLUtilities.copy(data, off, len));
        } else if (doffset + (long)len > (long)junk.length) {
            junk = KSFLUtilities.cut(junk, (int)doffset, junk.length - (int)doffset);
            junk = KSFLUtilities.paste(junk, (int)doffset, KSFLUtilities.copy(data, off, len));
        } else {
            n = 0;
            int s = off;
            int d = (int)doffset;
            while (s < data.length && d < junk.length && n < len) {
                junk[d] = data[s];
                ++s;
                ++d;
                ++n;
            }
        }
        return this.setData(type, id, junk) ? n : 0;
    }

    @Override
    public int getTypeCount() {
        try {
            ArrayList<Long> a = new ArrayList<Long>();
            PreparedStatement ps = this.conn.prepareStatement("SELECT type FROM " + this.table, 1003, 1007);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                long t = rs.getLong("type");
                if (a.contains(t)) continue;
                a.add(t);
            }
            return a.size();
        }
        catch (SQLException sQLException) {
            return 0;
        }
    }

    @Override
    public long getType(int index) {
        try {
            ArrayList<Long> a = new ArrayList<Long>();
            PreparedStatement ps = this.conn.prepareStatement("SELECT type FROM " + this.table, 1003, 1007);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                long t = rs.getLong("type");
                if (a.contains(t)) continue;
                if (a.size() == index) {
                    return t;
                }
                a.add(t);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return 0L;
    }

    @Override
    public long[] getTypes() {
        try {
            ArrayList<Long> a = new ArrayList<Long>();
            PreparedStatement ps = this.conn.prepareStatement("SELECT type FROM " + this.table, 1003, 1007);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                long t = rs.getLong("type");
                if (a.contains(t)) continue;
                a.add(t);
            }
            long[] aa = new long[a.size()];
            Iterator i = a.iterator();
            int j = 0;
            while (i.hasNext() && j < aa.length) {
                aa[j] = (Long)i.next();
                ++j;
            }
            return aa;
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    @Override
    public int getResourceCount(long type) {
        try {
            ArrayList<Integer> a = new ArrayList<Integer>();
            PreparedStatement ps = this.conn.prepareStatement("SELECT id FROM " + this.table + " WHERE type=?", 1003, 1007);
            ps.setLong(1, type);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                a.add(rs.getInt("id"));
            }
            return a.size();
        }
        catch (SQLException sQLException) {
            return 0;
        }
    }

    @Override
    public int getID(long type, int index) {
        try {
            ArrayList<Integer> a = new ArrayList<Integer>();
            PreparedStatement ps = this.conn.prepareStatement("SELECT id FROM " + this.table + " WHERE type=?", 1003, 1007);
            ps.setLong(1, type);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                int i = rs.getInt("id");
                if (a.size() == index) {
                    return i;
                }
                a.add(i);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return 0;
    }

    @Override
    public int[] getIDs(long type) {
        try {
            ArrayList<Integer> a = new ArrayList<Integer>();
            PreparedStatement ps = this.conn.prepareStatement("SELECT id FROM " + this.table + " WHERE type=?", 1003, 1007);
            ps.setLong(1, type);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                a.add(rs.getInt("id"));
            }
            int[] aa = new int[a.size()];
            Iterator i = a.iterator();
            int j = 0;
            while (i.hasNext() && j < aa.length) {
                aa[j] = (Integer)i.next();
                ++j;
            }
            return aa;
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    @Override
    public String getName(long type, int index) {
        try {
            ArrayList<String> a = new ArrayList<String>();
            PreparedStatement ps = this.conn.prepareStatement("SELECT name FROM " + this.table + " WHERE type=?", 1003, 1007);
            ps.setLong(1, type);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                String s = rs.getString("name");
                if (a.size() == index) {
                    return s;
                }
                a.add(s);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public String[] getNames(long type) {
        try {
            ArrayList<String> a = new ArrayList<String>();
            PreparedStatement ps = this.conn.prepareStatement("SELECT name FROM " + this.table + " WHERE type=?", 1003, 1007);
            ps.setLong(1, type);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                a.add(rs.getString("name"));
            }
            return a.toArray(new String[0]);
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    @Override
    public int getNextAvailableID(long type, int start) {
        try {
            ArrayList<Integer> a = new ArrayList<Integer>();
            PreparedStatement ps = this.conn.prepareStatement("SELECT id FROM " + this.table + " WHERE type=?", 1003, 1007);
            ps.setLong(1, type);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                a.add(rs.getInt("id"));
            }
            int i = start;
            while (a.contains(i)) {
                ++i;
            }
            return i;
        }
        catch (SQLException sQLException) {
            return 0;
        }
    }

    @Override
    public String getNameFromID(long type, int id) {
        try {
            PreparedStatement ps = this.conn.prepareStatement("SELECT name FROM " + this.table + " WHERE type=? AND id=?", 1003, 1007);
            ps.setLong(1, type);
            ps.setInt(2, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                return rs.getString("name");
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public int getIDFromName(long type, String name) {
        try {
            PreparedStatement ps = this.conn.prepareStatement("SELECT id FROM " + this.table + " WHERE type=? AND name=?", 1003, 1007);
            ps.setLong(1, type);
            ps.setString(2, name);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                return rs.getInt("id");
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return 0;
    }
}

