#include "main.ih"

namespace {

char const *a_optionsDescription = R"( [OPTIONS] file
Where:
  [OPTIONS] - zero or more optional arguments (int options between
              parentheses. Short options require arguments if their long
              option variants do too).

   --analyze-only (-A): 
           only analyze the grammar; except for possibly the verbose grammar
           description file no files are written.

   --baseclass-header=<header> (-b):
           filename holding the base class definition.

   --baseclass-preinclude=<header> (-H):
           preinclude header in the base-class header file.  Use [header] to
           include <header>, otherwise \"header\" will be included.

   --baseclass-skeleton=<skeleton> (-B):
           location of the baseclass header skeleton.

   --class-header=<header> (-c):
           filename holding the parser class definition.

   --class-name=<name>:
           the name of the generated C++ class.

   --class-skeleton=<skeleton> (-C):
           location of the class header skeleton.

   --construction:
           write details about the grammar analysis to stdout.

   --debug:
           generates debug output statements in the generated parse
           function's source.

   --default-actions=<off|quiet|warn|std> (-d):
           unless 'off', add a $$ = $1 action block to production rules not
           defining final action blocks.

   --error-verbose:
           the parse function will dump the parser's state stack to stdout
           when a syntactic error is reported

   --filenames=<filename> (-f):
           filename of output files (overruling the default filename).

   --flex:
           use the traditional `flex' interface.

   --help (-h):
           produce this information (and terminate).

   --implementation-header=<header> (-i):
           filename holding the implementation header.

   --implementation-skeleton=<skeleton> (-I):
           location of the implementation header skeleton.

   --insert-stype:
           show selected semantic values in the output generated by
           --debug. Ignored unless --debug was specified.

   --max-inclusion-depth=<value>:
           sets the maximum number of nested grammar files (default: 10).

   --namespace=<namespace> (-n):
           define the parser in the mentioned namespace.

   --no-baseclass-header:
           don't create the parser's base class header.

   --no-decoration (-D):
           do not include the user-defined actions when generating the
           parser's tt(parse) member.

   --no-lines:
           don't put #line directives in generated output, overruling the 
           %lines directive.

   --no-parse-member:
           don't create the member parse().

   --own-debug:
           bisonc++ displays the actions of its parser while processing
           its input file(s) (implies --verbose).

   --own-tokens (-T):
           bisonc++ displays the tokens and corresponding matched text,
           received from its lexcial scanner.

   --parsefun-skeleton=<parserskel> (-P):
           location of the parse function's skeleton.

   --parsefun-source=<source> (-p):
           filename holding the parse function's source.

   -Q      stop after merely parsing the grammar.

   --polymorphic-code-skeleton=<skeleton> (-L):
           location of the non-inline polymorphic functions skeleton.

   --polymorphic-skeleton=<skeleton> (-M):
           location of the polymorphic semantic values skeleton.

   --print-tokens (-t):
           the print() member of the generated parser class displays the
           tokens and their corresponding matched text.

   --prompt:
           in combination with --debug: show a prompt before performing the
           next parse-cycle (caveat: the lexical scanner should not read from
           the standard input).

   --required-tokens=<value>:
           minimum number of successfully processed tokens between errors
           (default: 0).

   --scanner=<header-file> (-s):
           include `header-file' declaring the class Scanner, and call
           d_scanner.yylex() from Parser::lex().

   --scanner-class-name=<scanner class name>:
           specifies the name of the scanner class: this option is only
           interpreted if --scanner (or %scanner) is also used.

   --scanner-debug:
           extensive display of the actions of bisonc++'s scanner

   --scanner-matched-text-function=<function call>:
           specifies the function to call returning the text matched by the
           lexical scanner when returning a token

   --scanner-token-function=<scanner token function>:
           specifies the function to call by the parser's lex() function
           returning the next token returned by the lexcial scanner (by
           default d_scanner.yylex() when --scanner is used)

   --show-filenames:
           show the names of the used/generated files on the standard error
           stream.

   --skeleton-directory=<skeleton-directory> (-S):
           location of the skeleton directory.

   --tag-mismatches=<off|on>:
           unless 'off', issue a warning if no $$ statement was detected in an
           action block, or if no default $$ = $1 action can be added to a
           production rule without final action block, or if run-time a
           tag-mismatch is observed.

   --target-directory=<pathname>:
           pathname defines the directory where generated files should be
           written. By default this is the directory where bisonc++ is called.

   --thread-safe:
           provide thread-safe access by polymorphic semantic values to the
           generated code's error-counter.

   --token-class=classname (-K)
           Classname defines the name of the Tokens class  that  is  defined
           when  token-path  (see  below)  is specified. If token-path isn’t
           specified then this option is ignored. By default the class name
           Tokens is used.
 
   --token-namespace=namespace (-N)
           If token-path is specified then namespace defines the namespace of
           the Tokens class. By default no namespace is used. 
 
   --token-path=pathname (-F)
           Pathname  defines the path name of the file to contain the struct
           Tokens defining the enumeration Tokens_ containing  the  symbolic
           tokens  of the generated grammar. By  default the tokens are
           defined as the enum Tokens_ in the ParserBase class. If  pathname 
           doesn’t exist it is created by bisonc++. If the pathname file al‐
           ready exists it is rewritten at each new run of bisonc++.
 
   --usage: produce this information (and terminate).

   --verbose (-V):
           generate verbose description of the analyzed grammar. 

   --version (-v):
)";


}   // anonymous namespace

void usage(string const &program_name)
{
    cout << 
    "\n" <<
    program_name << " by Frank B. Brokken (f.b.brokken@rug.nl)\n"
    "\n"
    "LALR(1) Parser Generator V "  << version << "\n"
    "Copyright (c) GPL " << year << ". NO WARRANTY.\n"
    "Designed after `bison++' (1.21.9-1) by Alain Coetmeur "
                                                "<coetmeur@icdc.fr>\n"
    "\n"
    "Usage: " << program_name << a_optionsDescription <<
    "           display " << program_name << "'s version and terminate.\n"
                                                                << std::endl;
}




