/*
 * Copyright (c) 2019-2020, Broadcom
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef CRMU_DEF_H
#define CRMU_DEF_H

#define CRMU_REGS_BASE			0x66410000
/* 32 kB IDRAM */
#define CRMU_IDRAM_BASE_ADDR		CRMU_REGS_BASE
#define CRMU_IDRAM_SIZE			0x8000
/* 4 kB Scratch RAM */
#define CRMU_SRAM_BASE			(CRMU_IDRAM_BASE_ADDR + CRMU_IDRAM_SIZE)
#define CRMU_SRAM_SIZE			0x1000

#define CRMU_RESERVED_SPACE		0x3000
#define CRMU_CORE_BASE			(CRMU_SRAM_BASE + CRMU_SRAM_SIZE + \
					 CRMU_RESERVED_SPACE)

#define CRMU_SHARED_SRAM_BASE		CRMU_SRAM_BASE
#define CRMU_SHARED_SRAM_SIZE		0x200
#define CRMU_CFG_BASE			(CRMU_SHARED_SRAM_BASE + \
					 CRMU_SHARED_SRAM_SIZE)

#define CRMU_PWR_GOOD_STATUS		CRMU_CORE_BASE
#define CRMU_PWR_GOOD_STATUS__BBL_POWER_GOOD 0
#define CRMU_ISO_CELL_CONTROL		(CRMU_CORE_BASE + 0x4)
#define CRMU_ISO_CELL_CONTROL__CRMU_ISO_PDBBL 16
#define CRMU_ISO_CELL_CONTROL__CRMU_ISO_PDBBL_TAMPER 24
#define CRMU_SPRU_SOURCE_SEL_STAT	(CRMU_CORE_BASE + 0xc)
#define CRMU_SPRU_SOURCE_SEL_STAT__SPRU_SOURCE_SELECT 0
#define BSTI_BASE			(CRMU_CORE_BASE + 0x28)
#define BSTI_CONTROL_OFFSET		BSTI_BASE
#define BSTI_COMMAND_OFFSET		(BSTI_BASE + 0x4)

#define OCOTP_REGS_BASE			(CRMU_CORE_BASE + 0x400)

#define CRMU_TCI_BASE			(CRMU_CORE_BASE + 0x800)
#define CRMU_SWREG_STATUS_ADDR		(CRMU_TCI_BASE + 0x0c)
#define CRMU_CHIP_OTPC_STATUS		(CRMU_TCI_BASE + 0x10)
#define CRMU_CHIP_OTPC_STATUS__OTP_BISR_LOAD_DONE 19
#define CRMU_BISR_PDG_MASK		(CRMU_TCI_BASE + 0x4c)
#define CRMU_BISR_PDG_MASK__CRMU_BISR_IHOST0 2
#define CRMU_BISR_PDG_MASK__CRMU_BISR_IHOST1 3
#define CRMU_BISR_PDG_MASK__CRMU_BISR_IHOST2 4
#define CRMU_BISR_PDG_MASK__CRMU_BISR_IHOST3 0
#define CRMU_POWER_POLL			(CRMU_TCI_BASE + 0x60)
#define CRMU_OTP_STATUS			CRMU_POWER_POLL
#define CRMU_OTP_STATUS_BIT		1
#define CRMU_DDR_PHY_AON_CTRL		(CRMU_TCI_BASE + 0x64)
#define CRMU_DDRPHY2_HW_RESETN_R	BIT(21)
#define CRMU_DDRPHY2_PWROKIN_PHY_R	BIT(20)
#define CRMU_DDRPHY2_PWRONIN_PHY_R	BIT(19)
#define CRMU_DDRPHY2_ISO_PHY_DFI_R	BIT(18)
#define CRMU_DDRPHY2_ISO_PHY_REGS_R	BIT(17)
#define CRMU_DDRPHY2_ISO_PHY_PLL_R	BIT(16)
#define CRMU_DDRPHY1_HW_RESETN_R	BIT(13)
#define CRMU_DDRPHY1_PWROKIN_PHY_R	BIT(12)
#define CRMU_DDRPHY1_PWRONIN_PHY_R	BIT(11)
#define CRMU_DDRPHY1_ISO_PHY_DFI_R	BIT(10)
#define CRMU_DDRPHY1_ISO_PHY_REGS_R	BIT(9)
#define CRMU_DDRPHY1_ISO_PHY_PLL_R	BIT(8)
#define CRMU_DDRPHY0_HW_RESETN_R	BIT(5)
#define CRMU_DDRPHY0_PWROKIN_PHY_R	BIT(4)
#define CRMU_DDRPHY0_PWRONIN_PHY_R	BIT(3)
#define CRMU_DDRPHY0_ISO_PHY_DFI_R	BIT(2)
#define CRMU_DDRPHY0_ISO_PHY_REGS_R	BIT(1)
#define CRMU_DDRPHY0_ISO_PHY_PLL_R	BIT(0)
#define CRMU_EMEM_RESET_N_R		BIT(16)
#define CRMU_EMEM_PRESET_N_R		BIT(0)
#define CRMU_SWREG_CTRL_ADDR		(CRMU_TCI_BASE + 0x6c)
#define CRMU_AON_CTRL1			(CRMU_TCI_BASE + 0x70)
#define CRMU_AON_CTRL1__LCPLL1_ISO_IN    18
#define CRMU_AON_CTRL1__LCPLL1_PWRON_LDO 19
#define CRMU_AON_CTRL1__LCPLL1_PWR_ON    20
#define CRMU_AON_CTRL1__LCPLL0_ISO_IN    21
#define CRMU_AON_CTRL1__LCPLL0_PWRON_LDO 22
#define CRMU_AON_CTRL1__LCPLL0_PWR_ON    23
#define CRMU_PCIE_LCPLL_PWR_ON_SHIFT     29
#define CRMU_PCIE_LCPLL_PWR_ON_MASK      BIT(CRMU_PCIE_LCPLL_PWR_ON_SHIFT)
#define CRMU_PCIE_LCPLL_PWRON_LDO_SHIFT  28
#define CRMU_PCIE_LCPLL_PWRON_LDO_MASK   BIT(CRMU_PCIE_LCPLL_PWRON_LDO_SHIFT)
#define CRMU_PCIE_LCPLL_ISO_IN_SHIFT     27
#define CRMU_PCIE_LCPLL_ISO_IN_MASK      BIT(CRMU_PCIE_LCPLL_ISO_IN_SHIFT)
#define CRMU_MASTER_AXI_ARUSER_CONFIG	(CRMU_TCI_BASE + 0x74)
#define CRMU_MASTER_AXI_AWUSER_CONFIG	(CRMU_TCI_BASE + 0x78)
#define CRMU_DDR_PHY_AON_CTRL_1		(CRMU_TCI_BASE + 0x8c)

#define CDRU_BASE_ADDR			(CRMU_CORE_BASE + 0x1000)
#define CDRU_MISC_RESET_CONTROL		CDRU_BASE_ADDR
#define CDRU_MISC_RESET_CONTROL_TS_RESET_N		16
#define CDRU_MISC_RESET_CONTROL__CDRU_USBSS_RESET_N	14
#define CDRU_MISC_RESET_CONTROL__CDRU_SATA_RESET_N_R	15
#define CDRU_MISC_RESET_CONTROL__CDRU_MHB_RESET_N_R	13
#define CDRU_MISC_RESET_CONTROL__CDRU_PCIE_RESET_N_R	3
#define CDRU_MISC_RESET_CONTROL__CDRU_PM_RESET_N_R	2
#define CDRU_MISC_RESET_CONTROL__CDRU_NITRO_RESET_N_R	1

#define CDRU_PROC_EVENT_CLEAR		(CDRU_BASE_ADDR + 0x48)
#define CDRU_PROC_EVENT_CLEAR__IH0_CDRU_STANDBYWFIL2		0
#define CDRU_PROC_EVENT_CLEAR__IH0_CDRU_STANDBYWFI		3
#define CDRU_PROC_EVENT_CLEAR__IH1_CDRU_STANDBYWFIL2		5
#define CDRU_PROC_EVENT_CLEAR__IH1_CDRU_STANDBYWFI		8
#define CDRU_PROC_EVENT_CLEAR__IH2_CDRU_STANDBYWFIL2		10
#define CDRU_PROC_EVENT_CLEAR__IH2_CDRU_STANDBYWFI		13
#define CDRU_PROC_EVENT_CLEAR__IH3_CDRU_STANDBYWFIL2		15
#define CDRU_PROC_EVENT_CLEAR__IH3_CDRU_STANDBYWFI		18

#define CDRU_CHIP_STRAP_CTRL		(CDRU_BASE_ADDR + 0x50)
#define CDRU_CHIP_STRAP_CTRL__SOFTWARE_OVERRIDE 31

#define CDRU_CHIP_IO_PAD_CONTROL	(CDRU_BASE_ADDR + 0x58)
#define CDRU_CHIP_IO_PAD_CONTROL__CDRU_IOMUX_FORCE_PDN_R	8
#define CDRU_CHIP_IO_PAD_CONTROL__CDRU_IOMUX_FORCE_PAD_IN_R	0

#define CDRU_CHIP_STRAP_DATA_LSW	(CDRU_BASE_ADDR + 0x5c)
#define CDRU_CHIP_STRAP_DATA_LSW__BISR_BYPASS_MODE		18
#define CDRU_CHIP_STRAP_DATA_LSW__NIC_MODE_MASK		BIT(8)
#define CDRU_CHIP_STRAP_DATA_LSW_PAD_USB_MODE		BIT(26)

#define CDRU_CHIP_STRAP_DATA		(CDRU_BASE_ADDR + 0x5c)
#define CDRU_DDR0_CONTROL_OFFSET	(CDRU_BASE_ADDR + 0xb8)
#define CDRU_DDR1_CONTROL_OFFSET	(CDRU_BASE_ADDR + 0xbc)
#define CDRU_DDR2_CONTROL_OFFSET	(CDRU_BASE_ADDR + 0xc0)
#define CRMU_SW_POR_RESET_CTRL		(CDRU_BASE_ADDR + 0x100)

#define CDRU_GENPLL2_CONTROL1		(CDRU_BASE_ADDR + 0x1b0)
#define CDRU_GENPLL2_CONTROL1__CHNL6_FS4_CLK		BIT(11)
#define CDRU_GENPLL5_CONTROL1		(CDRU_BASE_ADDR + 0x24c)
#define CDRU_GENPLL5_CONTROL1__CHNL0_DME_CLK		BIT(6)
#define CDRU_GENPLL5_CONTROL1__CHNL1_CRYPTO_AE_CLK	BIT(7)
#define CDRU_GENPLL5_CONTROL1__CHNL2_RAID_AE_CLK	BIT(8)

#define CDRU_NITRO_CONTROL		(CDRU_BASE_ADDR + 0x2c4)
#define CDRU_NITRO_CONTROL__CDRU_NITRO_SEC_MODE_R		20
#define CDRU_NITRO_CONTROL__CDRU_NITRO_SEC_OVERRIDE_R		16

#define CDRU_MISC_CLK_ENABLE_CONTROL	(CDRU_BASE_ADDR + 0x2c8)
#define CDRU_MISC_CLK_ENABLE_CONTROL__CDRU_EMEM2_CLK_EN_R	11
#define CDRU_MISC_CLK_ENABLE_CONTROL__CDRU_EMEM1_CLK_EN_R	10
#define CDRU_MISC_CLK_ENABLE_CONTROL__CDRU_EMEM0_CLK_EN_R	9
#define CDRU_MISC_CLK_ENABLE_CONTROL__CDRU_SATA_CLK_EN_R	8
#define CDRU_MISC_CLK_ENABLE_CONTROL__CDRU_USBSS_CLK_EN_R	7
#define CDRU_MISC_CLK_ENABLE_CONTROL__CDRU_MHB_CLK_EN_R		6
#define CDRU_MISC_CLK_ENABLE_CONTROL__CDRU_HSLS_CLK_EN_R	5
#define CDRU_MISC_CLK_ENABLE_CONTROL__CDRU_SCR_CLK_EN_R		4
#define CDRU_MISC_CLK_ENABLE_CONTROL__CDRU_FS4_CLK_EN_R		3
#define CDRU_MISC_CLK_ENABLE_CONTROL__CDRU_PCIE_CLK_EN_R	2
#define CDRU_MISC_CLK_ENABLE_CONTROL__CDRU_PM_CLK_EN_R		1
#define CDRU_MISC_CLK_ENABLE_CONTROL__CDRU_NITRO_CLK_EN_R	0

#define CDRU_CCN_REGISTER_CONTROL_1	(CDRU_BASE_ADDR + 0x324)
#define CDRU_CCN_REGISTER_CONTROL_1__D2XS_PD_EMEM0_BIT 6
#define CDRU_CCN_REGISTER_CONTROL_1__D2XS_PD_EMEM1_BIT 5
#define CDRU_CCN_REGISTER_CONTROL_1__D2XS_PD_EMEM2_BIT 4

#define CDRU_CHIP_TOP_SPARE_REG0	(CDRU_BASE_ADDR + 0x378)
#define CDRU_CHIP_TOP_SPARE_REG1	(CDRU_BASE_ADDR + 0x37c)

#define CENTRAL_TIMER_BASE		(CRMU_CORE_BASE + 0x5000)
#define CENTRAL_TIMER_CTRL		(CENTRAL_TIMER_BASE + 0x0)
#define CENTRAL_TIMER_GET_L		(CENTRAL_TIMER_BASE + 0x4)
#define CENTRAL_TIMER_GET_L0		(CENTRAL_TIMER_BASE + 0x8) /* SCR STM */
#define CENTRAL_TIMER_GET_L1		(CENTRAL_TIMER_BASE + 0xC) /* FS STM */
#define CENTRAL_TIMER_GET_L2		(CENTRAL_TIMER_BASE + 0x10) /* iHost0 */
#define CENTRAL_TIMER_GET_L3		(CENTRAL_TIMER_BASE + 0x14) /* iHost1 */
#define CENTRAL_TIMER_GET_L4		(CENTRAL_TIMER_BASE + 0x18) /* iHost2 */
#define CENTRAL_TIMER_GET_L5		(CENTRAL_TIMER_BASE + 0x1C) /* iHost3 */
#define CENTRAL_TIMER_GET_H		(CENTRAL_TIMER_BASE + 0x28)
#define CENTRAL_TIMER_SAT_TMR_ENA	(CENTRAL_TIMER_BASE + 0x34)
#define CENTRAL_TIMER_GET_IHOST_ENA_BASE	(CENTRAL_TIMER_GET_L2)

#define CRMU_WDT_REGS_BASE		(CRMU_CORE_BASE + 0x6000)

#define CRMU_MAIL_BOX0			(CRMU_CORE_BASE + 0x8024)
#define CRMU_MAIL_BOX1			(CRMU_CORE_BASE + 0x8028)
#define CRMU_READ_MAIL_BOX0		(CRMU_CORE_BASE + 0x802c)
#define CRMU_READ_MAIL_BOX1		(CRMU_CORE_BASE + 0x8030)
#define AP_TO_SCP_MAILBOX1		CRMU_MAIL_BOX1
#define SCP_TO_AP_MAILBOX1		CRMU_READ_MAIL_BOX1
#define CRMU_IHOST_POWER_CONFIG		(CRMU_CORE_BASE + 0x8038)
#define CRMU_RESET_EVENT_LOG		(CRMU_CORE_BASE + 0x8064)
#define CRMU_SOFT_RESET_CTRL		(CRMU_CORE_BASE + 0x8090)
#define CRMU_SOFT_RESET_CTRL__SOFT_PWR_UP_RST 0
#define CRMU_SOFT_RESET_CTRL__SOFT_SYS_RST 1
#define CRMU_SPARE_REG_0		(CRMU_CORE_BASE + 0x80b8)
#define CRMU_SPARE_REG_1		(CRMU_CORE_BASE + 0x80bc)
#define CRMU_SPARE_REG_2		(CRMU_CORE_BASE + 0x80c0)
#define CRMU_SPARE_REG_3		(CRMU_CORE_BASE + 0x80c4)
#define CRMU_SPARE_REG_4		(CRMU_CORE_BASE + 0x80c8)
#define CRMU_SPARE_REG_5		(CRMU_CORE_BASE + 0x80cc)
#define CRMU_CORE_ADDR_RANGE0_LOW	(CRMU_CORE_BASE + 0x8c30)
#define CRMU_CORE_ADDR_RANGE1_LOW	(CRMU_CORE_BASE + 0x8c38)
#define CRMU_CORE_ADDR_RANGE2_LOW	(CRMU_CORE_BASE + 0x8c40)
#define CRMU_IHOST_SW_PERSISTENT_REG0	(CRMU_CORE_BASE + 0x8c54)
#define CRMU_IHOST_SW_PERSISTENT_REG1	(CRMU_CORE_BASE + 0x8c58)
#define CRMU_IHOST_SW_PERSISTENT_REG2	(CRMU_CORE_BASE + 0x8c5c)
#define CRMU_IHOST_SW_PERSISTENT_REG3	(CRMU_CORE_BASE + 0x8c60)
#define CRMU_IHOST_SW_PERSISTENT_REG4	(CRMU_CORE_BASE + 0x8c64)
#define CRMU_IHOST_SW_PERSISTENT_REG5	(CRMU_CORE_BASE + 0x8c68)
#define CRMU_IHOST_SW_PERSISTENT_REG6	(CRMU_CORE_BASE + 0x8c6c)
#define CRMU_IHOST_SW_PERSISTENT_REG7	(CRMU_CORE_BASE + 0x8c70)
#define CRMU_BBL_AUTH_CHECK		(CRMU_CORE_BASE + 0x8c78)
#define CRMU_SOTP_NEUTRALIZE_ENABLE	(CRMU_CORE_BASE + 0x8c84)
#define CRMU_IHOST_SW_PERSISTENT_REG8	(CRMU_CORE_BASE + 0x8c88)
#define CRMU_IHOST_SW_PERSISTENT_REG9	(CRMU_CORE_BASE + 0x8c8c)
#define CRMU_IHOST_SW_PERSISTENT_REG10	(CRMU_CORE_BASE + 0x8c90)
#define CRMU_IHOST_SW_PERSISTENT_REG11	(CRMU_CORE_BASE + 0x8c94)

#define CNT_CONTROL_BASE		(CRMU_CORE_BASE + 0x9000)
#define CNTCR				(CNT_CONTROL_BASE)
#define CNTCR__EN			BIT(0)

#define SPRU_BBL_WDATA			(CRMU_CORE_BASE + 0xa000)
#define SPRU_BBL_CMD			(CRMU_CORE_BASE + 0xa004)
#define SPRU_BBL_CMD__IND_SOFT_RST_N	10
#define SPRU_BBL_CMD__IND_WR		11
#define SPRU_BBL_CMD__BBL_ADDR_R	0
#define SPRU_BBL_CMD__IND_RD		12
#define SPRU_BBL_CMD__BBL_ADDR_R	0
#define SPRU_BBL_STATUS			(CRMU_CORE_BASE + 0xa008)
#define SPRU_BBL_STATUS__ACC_DONE	0
#define SPRU_BBL_RDATA			(CRMU_CORE_BASE + 0xa00c)

#endif /* CRMU_DEF_H */
