#ifndef TP_OPTIONS_H
#define TP_OPTIONS_H

/* This file does not depend on header.h */

#include <stdio.h>
#include <limits.h>  /* for INT_MAX */
#include <string.h>  /* for strcmp() */

/*************
 *
 *    Flags are boolean valued options.  To install a new flag, append
 *    a new name and index to the end of this list, then insert code to
 *    initialize it in the routine `init_options'.
 *    Example access:  if (Flags[PARA_FROM_LEFT].val) { ... }
 *    See routine `init_options' for defaults.
 *
 *************/

#define MAX_FLAGS          100  /* increase if necessary */

#define PRINT_MODELS            0
#define SUBSUME                 1
#define PRINT_MODELS_PORTABLE   2
#define DISTINCT_CONSTANTS      3
#define PRINT_MODELS_IVY        4

/* end of Flags */

/*************
 *
 *    Parms are integer valued options.  To install a new parm, append
 *    a new name and index to this list, then insert code to
 *    initialize it in the routine `init_options'.
 *    Example access:  if (Parms[FPA_LITERALS].val == 4) { ... }
 *    See routine `init_options' for defaults.
 *
 *************/

#define MAX_PARMS        30  /* increase if necessary */

#define MAX_MEM           0  /* stop search after this many K bytes allocated */
#define MAX_TP_SECONDS    1
#define MAX_MODELS        2

/* end of Parms */

struct flag {  /* Flags are boolean valued options */
    char *name;
    int val;
    };

struct parm {  /* Parms are integer valued options */
    char *name;
    int val;
    int min, max;  /* minimum and maximum permissible values */
    };

extern struct flag Flags[MAX_FLAGS];
extern struct parm Parms[MAX_PARMS];

/* function prototypes from options.c */

void init_options(void);

void print_options(FILE *fp);

void p_options(void);

void auto_change_flag(FILE *fp, int index, int val);

void dependent_flags(FILE *fp, int index);

void auto_change_parm(FILE *fp, int index, int val);

void dependent_parms(FILE *fp, int index);

int change_flag(FILE *fp, char *flag_name, int set);

int change_parm(FILE *fp, char *parm_name, int val);

void check_options(FILE *fp);

#endif  /* ! TP_OPTIONS_H */
